#!/bin/sh

FS_MD5="eba38dc2bc71d8b2029043a9041a6bd9"
BIN_MD5="b63f2a250f2d489093cde8ce6e72f247"

nsc_stat=`pidof nsc`

if [ "w$nsc_stat" != "w" ]; then
    echo "Stopping NSC....."
    service nsc stop
fi

echo "Taking backup of current existing file"
mv /usr/local/nsc/lib/libfreeswitch.so.1.0.0 /usr/local/nsc/lib/libfreeswitch.so.1.0.0-orig
mv /usr/local/nsc/bin/validate_license /usr/local/nsc/bin/validate_license-orig

echo "Applying patch file"
cp -rfL libfreeswitch.so.1.0.0 /usr/local/nsc/lib/.
cp -rfL validate_license /usr/local/nsc/bin/.

file_md5=($(md5sum /usr/local/nsc/lib/libfreeswitch.so.1.0.0))
if [ "$file_md5" == "$FS_MD5" ]; then
    file_md5=($(md5sum /usr/local/nsc/bin/validate_license))
    if [ "$file_md5" == "$BIN_MD5" ]; then
        echo "Patch Applied successfully"

        if [ "w$nsc_stat" != "w" ]; then
            echo "Starting NSC services....."
            service nsc start
	fi
    else
        echo "Patch application failed. Please re-apply the patch."
    fi
else
    echo "Patch application failed. Please re-apply the patch."
fi

