/* Copyright (C) 2009-2011 Broadcom Corporation. */

#ifdef SIMPLE_DEV_PM_OPS

#define tg3_invalid_pci_state(tp, state)	false
#define tg3_pci_save_state(tp)
#define tg3_pci_restore_state(tp)

#else /* SIMPLE_DEV_PM_OPS */

#if (LINUX_VERSION_CODE < 0x2060b)
static bool tg3_invalid_pci_state(struct tg3 *tp, u32 state)
{
	bool ret = true;
	pci_power_t target_state;

	target_state = pci_choose_state(tp->pdev, state);
	if (target_state != PCI_D3hot || target_state != PCI_D3cold)
		ret = false;

	return ret;
}
#else
static bool tg3_invalid_pci_state(struct tg3 *tp, pm_message_t state)
{
	bool ret = true;
	pci_power_t target_state;

#ifdef BCM_HAS_PCI_TARGET_STATE
	target_state = tp->pdev->pm_cap ? pci_target_state(tp->pdev) : PCI_D3hot;
#else
	target_state = pci_choose_state(tp->pdev, state);
#endif
	if (target_state != PCI_D3hot || target_state != PCI_D3cold)
		ret = false;

	return ret;
}
#endif

#if (LINUX_VERSION_CODE < 0x2060a)
#define tg3_pci_save_state(tp)		pci_save_state(tp->pdev, tp->pci_cfg_state)
#define tg3_pci_restore_state(tp)	pci_restore_state(tp->pdev, tp->pci_cfg_state)
#else
#define tg3_pci_save_state(tp)		pci_save_state(tp->pdev)
#define tg3_pci_restore_state(tp)	pci_restore_state(tp->pdev)
#endif

#endif /* SIMPLE_DEV_PM_OPS */


#ifdef BCM_HAS_NEW_PCI_DMA_MAPPING_ERROR
#define tg3_pci_dma_mapping_error(pdev, mapping)  pci_dma_mapping_error((pdev), (mapping))
#elif defined(BCM_HAS_PCI_DMA_MAPPING_ERROR)
#define tg3_pci_dma_mapping_error(pdev, mapping)  pci_dma_mapping_error((mapping))
#else
#define tg3_pci_dma_mapping_error(pdev, mapping)  0
#endif


#ifdef HAVE_POLL_CONTROLLER
#define CONFIG_NET_POLL_CONTROLLER
#endif

static inline void tg3_5780_class_intx_workaround(struct tg3 *tp)
{
#ifndef BCM_HAS_INTX_MSI_WORKAROUND
	if ((tp->tg3_flags2 & TG3_FLG2_5780_CLASS) &&
	    (tp->tg3_flags2 & TG3_FLG2_USING_MSI))
		tg3_enable_intx(tp->pdev);
#endif
}

#ifdef BCM_HAS_TXQ_TRANS_UPDATE
#define tg3_update_trans_start(dev)
#else
#define tg3_update_trans_start(dev)		((dev)->trans_start = jiffies)
#endif


#ifdef BCM_KERNEL_SUPPORTS_8021Q
#ifndef BCM_HAS_VLAN_HWACCEL_PUT_TAG

#define TG3_RX_DMA_ALIGN		16
#define TG3_RX_HEADROOM			ALIGN(VLAN_HLEN, TG3_RX_DMA_ALIGN)

#undef TG3_RAW_IP_ALIGN
#define TG3_RAW_IP_ALIGN (2 + VLAN_HLEN)

static inline struct sk_buff *tg3_vlan_hwaccel_put_tag(struct sk_buff *skb,
						       u16 vlan_tci)
{
	struct vlan_ethhdr *ve = (struct vlan_ethhdr *)
			    __skb_push(skb, VLAN_HLEN);

	memmove(ve, skb->data + VLAN_HLEN, ETH_ALEN * 2);

	ve->h_vlan_proto = htons(ETH_P_8021Q);

	ve->h_vlan_TCI = htons(vlan_tci);

	skb->protocol = htons(ETH_P_8021Q);

	return skb;
}

#endif /* BCM_HAS_VLAN_HWACCEL_PUT_TAG */

#ifdef BCM_USE_OLD_VLAN_INTERFACE
static void __tg3_set_rx_mode(struct net_device *);
static inline void tg3_netif_start(struct tg3 *tp);
static inline void tg3_netif_stop(struct tg3 *tp);
static inline void tg3_full_lock(struct tg3 *tp, int irq_sync);
static inline void tg3_full_unlock(struct tg3 *tp);

static void tg3_vlan_rx_register(struct net_device *dev, struct vlan_group *grp)
{
	struct tg3 *tp = netdev_priv(dev);

	if (!netif_running(dev)) {
		tp->vlgrp = grp;
		return;
	}

	tg3_netif_stop(tp);

	tg3_full_lock(tp, 0);

	tp->vlgrp = grp;

	/* Update RX_MODE_KEEP_VLAN_TAG bit in RX_MODE register. */
	__tg3_set_rx_mode(dev);

	tg3_netif_start(tp);

	tg3_full_unlock(tp);
}

#ifndef HAVE_NET_DEVICE_OPS
static void tg3_vlan_rx_kill_vid(struct net_device *dev, unsigned short vid)
{
	struct tg3 *tp = netdev_priv(dev);

	if (netif_running(dev))
		tg3_netif_stop(tp);

	tg3_full_lock(tp, 0);
	vlan_group_set_device(tp->vlgrp, vid, NULL);
	tg3_full_unlock(tp);

	if (netif_running(dev))
		tg3_netif_start(tp);
}
#endif /* HAVE_NET_DEVICE_OPS */
#endif /* BCM_USE_OLD_VLAN_INTERFACE */
#endif /* BCM_KERNEL_SUPPORTS_8021Q */

#ifdef __VMKLNX__

/**
 *      skb_copy_expand -       copy and expand sk_buff
 *      @skb: buffer to copy
 *      @newheadroom: new free bytes at head
 *      @newtailroom: new free bytes at tail
 *      @gfp_mask: allocation priority
 *
 *      Make a copy of both an &sk_buff and its data and while doing so
 *      allocate additional space.
 *
 *      This is used when the caller wishes to modify the data and needs a
 *      private copy of the data to alter as well as more space for new fields.
 *      Returns %NULL on failure or the pointer to the buffer
 *      on success. The returned buffer has a reference count of 1.
 *
 *      You must pass %GFP_ATOMIC as the allocation priority if this function
 *      is called from an interrupt.
 */
struct sk_buff *skb_copy_expand(const struct sk_buff *skb,
                                int newheadroom, int newtailroom,
                                gfp_t gfp_mask)
{
	int rc;
	struct sk_buff *new_skb = skb_copy((struct sk_buff *) skb, gfp_mask);

	if(new_skb == NULL)
		return NULL;

	rc = pskb_expand_head(new_skb, newheadroom, newtailroom, gfp_mask);

	if(rc != 0)
		return NULL;

	return new_skb;
}

void *memmove(void *dest, const void *src, size_t count)
{
	if (dest < src) {
		return memcpy(dest, src, count);
	} else {
		char *p = dest + count;
		const char *s = src + count;
		while (count--)
			*--p = *--s;
	}
	return dest;
}


#endif
