<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Starts PHP Sessions
session_start();

//Checks to make sure the user is logged into the WebUI
if (empty($_POST))
	include 'check_referer.php';

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{

	//Includes the File which contains classes
	include 'classes.php';
	include 'database_classes.php';
	include 'display_class.php';	
	include 'wanrouter_controls.php';
	include 'wanpipe_config/wanpipe.php';
	include 'dahdi_config/dahdi_cfg.php';
	include 'freetdm_config/freetdm.php';
	include 'sqlite/database_creation.php';
	include 'smg_ctrl/smg_ctrl.php';
	include 'SS7/ss7_linkset_view_profile_class.php';
	include 'tdm_functions.php';

	//Class constructors
	$data = new database_class;
	$tokenization = new wanrouter_hwprobe;
	$display = new Display_hwprobe;
	$remove_ss7_sessions = new ss7_linkset_view_profile_class;
	$wanrouter = new wanrouter_hwprobe_controls;
	$display_common = new Display_common;
	
	//Main PHP Script
	//Check if running relay
	//If running relay, created tabbed layout for master, create readonly layout for slave
	$table_exists = $data->check_for_table("sqlite:sqlite/relay_info.db","ss7_relay");	
	$_SESSION['no_cards']  = "";
	
	if ($table_exists < 2 && $_SESSION['shortname'] == "NSG")
	{
		//Does not allow TDM configuration until relay questionaire answered
		header('Location:relay/relay_cfg.php');
	}
	elseif ($table_exists < 2 && $_SESSION['shortname'] == "NVG") {
		//NVG mode
		//autopopulate to standalone relay mode
		$relay_type = $data->select_statement("sqlite:sqlite/relay_info.db","ss7_relay","machine_type","id = 1");
		
		if ($data->check_for_table('sqlite:sqlite/relay_info.db','ss7_relay') < 2) {
			$parameters = "id INTEGER PRIMARY KEY, machine_type varchar(15), relay_type varchar(15), ssh_key_status varchar(15)";
			$data->create_table('sqlite:sqlite/relay_info.db', 'ss7_relay', $parameters);
		}

		if ($relay_type['machine_type'] == "")
			$data->insert_statement('sqlite:sqlite/relay_info.db','ss7_relay','id, machine_type', '1,"standalone"');
		
	}
	
	//Calls the redirection script to take you to another PHP Page
	$wanrouter->redirect($_REQUEST, $data, $tokenization);	
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		
		$_SESSION['embedded'] = "true";
		
		//ClearOS Integration
		$display_common->session_vars("sqlite:sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("TDM Configuration", "/style.css","");		
	}

	//echo "<div width='100%' style='background-color:white;'>\n";
	//Unsets SS7 Configuration session variables so that it doesn't affect up the SS7 Config wizard
	$remove_ss7_sessions->unset_sessions();
	
	if ($_REQUEST['refresh'] == "yes")
		$_SESSION['first_time'] = "";

	//Resets the port and span information
	$_SESSION['port'] = 0;
	$_SESSION['span_num'] = 0;
	$_SESSION['ping'] = "";
	$_SESSION['ssh_status'] = "";
	$slave_error = 0;

	if ($table_exists > 1)
	{
		$relay_type = $data->select_statement("sqlite:sqlite/relay_info.db","ss7_relay","machine_type, relay_type","id = 1");
		if ($relay_type['machine_type'] == "")
		{
			//Does not allow TDM configuration until relay questionaire answered
			header('relay/relay_cfg.php');
		}
		elseif ($relay_type['machine_type'] == "relay")
		{
			//If slave create readonly buttons
			//If master, create tabbed interface
			if ($relay_type['relay_type'] == "SLAVE")
			{
				//Display like a standalone system but block all the edit buttons within the subpages
				create_card_classes('', $display,$data,$tokenization,"up");
				//reset_restore($display_common,$data,"Slave",'');
			}
			elseif ($relay_type['relay_type'] == "MASTER")
			{
				//Find number of relay machines from the relay_hosts table in relay_info.db
				if ($data->check_for_table("sqlite:sqlite/relay_info.db","relay_hosts") > 1)
				{
					//Get machine names for tabs
					$relay_names = generic_database_select("sqlite:sqlite/relay_info.db", "relay_hosts","id, relay_name, ip_addr");
					
					foreach ($relay_names as $relay_name) {
						//Populate finished ports table
						$data->populate_finihsed_ports_table("relay", $relay_name['relay_name']);	
					}
					
					//echo "<div id='notifications'>";
					reset_restore($display_common,$data,"Master",0, false);
					//echo "</div>";
	  
					//Display Reload Notification box
					//echo $_SESSION['first_time'] . "<br />";
					if ($_SESSION['first_time'] == "")
					{
						$_SESSION['date_refreshed'] = date('l jS \of F Y h:i:s A');
					}
					if ($_SESSION['first_time'] == "True" || $_SESSION['first_time'] == "true")
					{
						?>
						<div id='config_refresh' style="width:700px">
						<?php
						$notif = new NotificationBox( 'Info', NotificationBox::Info );
						$notif->add("Configuration", "TDM Information was last refreshed on " . $_SESSION['date_refreshed']);
						$notif->add("Configuration"," <a href=\"" . $_SERVER['PHP_SELF'] . "?refresh=yes\">Click Here</a> to refresh" );
						echo $notif->getHtml();		
						unset($notif);	
						echo "</div>\n";
						echo "<br />";
					}
					
					//Create tabs for all relay machines
        			relay_javascript();
					
					$relay_count = $_SESSION['relay_counter'];
					unset($_SESSION['relay_counter']);
					
					//Create tabs
					// Use a tab to create tabbed selection
					echo "<table width='700px'>\n";
					for ($count = 0; $count < $relay_count; $count++)
					{
						if ($relay_names[$count]['id'] == 1)
						{
							$machine = "Master";
							$machine2 = "Master";
						}
						else
							$machine = "Slave";
	  
						//echo $count . "<br />";
						//echo $relay_names[$count]['relay_name']  . "<br />";
						echo " 	<th width='10%' id='" . $relay_names[$count]['relay_name'] . "_tab' class='widget-content-header ui-corner-top'>\n";
						echo "   <a href='javascript:displayLogTab(\"" . $relay_names[$count]['relay_name'] . "\")'>" . $relay_names[$count]['id'] . " - " . $machine . "</a></th>\n";
						
					}
					
					echo "  <tr>\n";
					echo "    <td colspan='" . $relay_count . "' border='1'>\n";
				
					$_SESSION['slave_error'] = 0;
					for ($count =0; $count < $relay_count; $count++)
					{
						//echo "Counter = " . $count . "<br />";
						// Display TDM Configuration for each slave device
						//$display_common->DynamicDivBegin( $relay_names[$count]['relay_name'] . "_tab", 'display:none;width=690px', 1000 );
						echo "<div id='".  $relay_names[$count]['relay_name'] . "_tab'  style='display:none;width=690px'/>";
						// TODO(wadam) : Display relay name for DEBUG
						//echo $relay_names[$count]['relay_name'];
						unset($system_status);
						//echo "ip address = " . $relay_names[$count]['ip_addr'] . "<br />";
						if ($count > 0)
							$system_status = system_status($relay_names[$count]['ip_addr']);
						elseif ($count == 0)
							$system_status = "up";
						
						relay_tdm($relay_names[$count]['relay_name'],$display,$data,$tokenization,$system_status);    
						//$slave_error = $slave_error2;
						echo "</div>\n";
					}
					
					//echo "slave errors = " . $_SESSION['slave_error'] . "<br />";
					//echo "Session = " . $_SESSION['no_cards']  . "<br />";
					//display reset/restore/generate and error messages here for relay
					if ($_SESSION['no_cards'] != "yes")
					{
						echo "<form method='post'>\n";
						reset_restore($display_common,$data,$machine2,$_SESSION['slave_error']);
						echo "</form>\n";
					}
					
					//Loop through card_classes function within each tab and generate required database files and displays
					echo "    </td>\n";
					echo "  </tr>\n";				
					echo "</table>\n";
				}
			}
		}
		elseif ($relay_type['machine_type'] == "standalone")
		{
			$_SESSION['proc_id'] =1 ;
			create_card_classes('',$display,$data,$tokenization,"up");
		}
	}
	
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
	
	$_SESSION['first_time'] = "True";
}
else
{
	header( 'Location:index.php' ) ;
}
?>
