<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

require_once "SSH_Class_new.php";

date_default_timezone_set('America/New_York');
//Wanpipe Configuration File Class for T1/E1 cards
class T1_E1_wanpipe_dahdi
{
	private $card = "";					//Card being sent into class
	private $card_number = "";			//Contains the number of cards in that class
	public $span = "";					//span, TDMV_SPAN
	private $pci_slot = "";				//PCI Slot of the card
	private $pci_bus = ""; 				//PCI Bus of the card
	private $line_type = "";			//FE_MEDIA
	private $coding = "";				//FE_LCODE
	private $framing = "";				//FE_FRAME
	private $port_id = "";				//FE_LINE
	private $clock = "";				//TE_CLOCK
	private $ref_clock = "";			//TE_REF_CLOCK
	private $impedencee = "";			//TE_HIGHIMPEDENCE
	private $rx_level = "";				//TE_RX_LEVEL
	private $lbo = "";					//LBO
	private $txtristate = "";			//FE_TXTRISTATE
	private $dchan = "";				//TDMV_DCHAN
	private $dtmf = "";					//TDMV_HW_DTMF
	private $fax = "";					//TDMV_FAX_DETECT
	private $echo = "";					//TDMV_HWEC
	private $sig_mode = "";				//TE_SIG_MODE
	private $dahdi_span = "";			//TDMV_SPAN for Dahdi
	private $hdlc_repeat = "";			//Determines whether the link is an SS7 Signalling Link
	private $not_ss7 = "";				//Determines whether the link is an SS7 link or a regular link
	public $db_location = "";			//Contains the database location
	public $dtmf_removal;
	private $hwec_persist=false;		
	
	//Populate Wanpipe Variables
	function populate_vars($card, $card_number, $span_num, $port_num, $data, $span_var)
	{
		//Takes the current span number
		$this->dahdi_span = $span_var;
		//$this->span = $span_num;
		$this->card = $card;
		$this->card_number = $card_number;
		$this->port_id = $port_num;
		
		//Database information
		$card_format = "AFT-" . $this->card . "-SH-" . $card_number;
		$db_location = $this->db_location;
		//$db_location = "sqlite:sqlite/cardinfo.db";

		$finished = $data->select_statement($db_location,'finished_ports','span','card="' . $card .'_'.$card_number.'_'.$port_num.'"');

		//Retrieve Card Information		
		$table_name = "card_present";
		$param = "pci_slot, pci_bus";
		//$where_param = "dev_name = \"" . $card_format . "\"";
		$where_param = "id = \"" . $card_number . "\"";
		$card_info = $data->select_statement ($db_location, $table_name, $param, $where_param);
		
		$this->pci_slot = $card_info['pci_slot'];
		$this->pci_bus = $card_info['pci_bus'];
		
		//Retrieve Hardware Information
		$table_name = $card . "_" . $card_number;
		$param = "line_type, coding, framing, port_id, clock, ref_clock, impedence, rx_level, lbo, txtristate, echo, fax, dtmf, sigmode, dtmf_removal";
		$where_param = "port_id = " . $port_num;
		$hw_info = $data->select_statement ($db_location, $table_name, $param, $where_param);
		
		$this->line_type = $hw_info['line_type'];
		$this->coding = $hw_info['coding'];
		$this->framing = $hw_info['framing'];
		$this->port_id = $hw_info['port_id'];
		$this->clock = $hw_info['clock'];
		$this->ref_clock = $hw_info['ref_clock'];
		$this->impedence = $hw_info['impedence'];
		$this->rx_level = $hw_info['rx_level'];
		$this->lbo = $hw_info['lbo'];
		
		if ($hw_info['dtmf_removal'] == "") 
			$this->dtmf_removal = "YES";
		else
			$this->dtmf_removal = $hw_info['dtmf_removal'];
		
		if ($hw_info['txtristate'] == "disable")
			$this->txtristate = "NO";
		elseif ($hw_info['txtristate'] == "enable")
			$this->txtristate = "YES";
		
		//Figures out the signalling mode
		if ($hw_info['sigmode'] == "")
			$this->sig_mode = "CCS";
		else
			$this->sig_mode = $hw_info['sigmode'];
		
		//Echo Canceler Analyzer
		if ($hw_info['echo'] == "enable")
			$this->echo = "YES";
		elseif ($hw_info['echo'] == "disable" || $hw_info['echo'] == "")
			$this->echo = "NO";
		
		if ($hw_info['dtmf'] == "enable")
			$this->dtmf = "YES";
		elseif ($hw_info['dtmf'] == "disable" || $hw_info['dtmf'] == "")
			$this->dtmf = "NO";
		
		if ($hw_info['fax'] == "enable")
			$this->fax = "YES";
		elseif ($hw_info['fax'] == "disable" || $hw_info['fax'] == "")
			$this->fax = "NO";
		
		//Checks if an SS7 table exists
		unset ($ss7_link_info);
		unset ($m2ua_info);
		unset ($mg_info);
		
		$ss7_link_table = $card . "_" . $card_number . "_SS7_link";
		$m2ua_table = $card . "_" . $card_number . "_m2ua_link";
		$mg_table = $card . "_" . $card_number . "_m2ua_channels";	
		$sig_table = $card ."_".$card_number."_signalling";
		$r2_table = $card ."_".$card_number."_r2_signalling";

		if ($data->check_for_table ($db_location, $ss7_link_table) > 1 || $data->check_for_table ($db_location, $m2ua_table) > 1 || $data->check_for_table ($db_location, $mg_table) > 1 || $data->check_for_table ($db_location, $sig_table) > 1 || $data->check_for_table ($db_location, $r2_table) > 1)
		{
			//Check if link is an SS7 Link
			$ss7_link_info = $data->select_statement ($db_location, $ss7_link_table, "link_name, span, sig_channel, voice", "port_id = $port_num");	
			$ss7_m2ua_info = $data->select_statement ($db_location, $m2ua_table, 'link_name,sig_channel,span','port_id='.$port_num);
			$ss7_mg_info = $data->select_statement ($db_location, $mg_table, 'profile_name, ss7_span','port_id='.$port_num);
			$sig_info = $data->select_statement ($db_location, $sig_table, 'dev_name','port_id='.$port_num);
			$r2_info = $data->select_statement ($db_location, $r2_table, 'dev_name','port_id='.$port_num);
			
			if ($ss7_link_info['link_name'] != "")
			{
				//echo "ISUP<br />";
				//SS7 ISUP Link Present
				$this->span = $ss7_link_info['span'];
				if ($ss7_link_info['voice'] != "yes")
				{
					$this->dchan = $ss7_link_info['sig_channel'];
					$this->hdlc_repeat = "yes";
				}
				elseif ($ss7_link_info['voice'] == "yes") {
					$this->hdlc_repeat = "no";
					$this->dchan = 0;
				}
			}
			elseif ($ss7_m2ua_info['link_name'] != "") {
				//echo "M2UA<br />";
				//SS7 M2UA link present
				$this->span = $ss7_m2ua_info['span'];
				$this->dchan = $ss7_m2ua_info['sig_channel'];
				$this->hdlc_repeat = "yes";
			}
			elseif ($ss7_mg_info['profile_name'] != "" && $ss7_m2ua_info['link_name'] == "")  {			
				//echo "MG<br />";
				//MG Profile Voice Links Present
				$this->span = $ss7_mg_info['ss7_span'];
				$this->hdlc_repeat = "no";
				$this->dchan = "0";
			}
			elseif ($r2_info['dev_name'] != "") {
				//R2
				if ($finished['span'] != "")
					$this->span = $finished['span'];

				//Not an SS7 Span
				$this->not_ss7 = "yes";
				$this->hdlc_repeat = "no";
				$this->dchan = "0";
				$this->hwec_persist = true;
			}
			else {
				//echo "PRI<br />";
				//Not an SS7 Span
				if ($finished['span'] != "")
					$this->span = $finished['span'];
					
				$this->not_ss7 = "yes";
				$this->hdlc_repeat = "no";

				//D-Channel Value
				if ($this->line_type == "T1")
					$this->dchan = 24;
				elseif ($this->line_type == "E1")
					$this->dchan = 16;
			}
		}
	}
	
	//Template for the A10x series of Cards
	function A10x_template($API, $machine_type = "standalone", $id_num = 1)
	{
		if ($machine_type == "standalone")
			$file_location = "/etc/wanpipe";
		elseif ($machine_type == "relay")
			$file_location = "/tmp/relay" . $id_num . "/wanpipe";
		
		$file_name = "wanpipe" . $this->span . ".conf";

		$A10xfilehandle = fopen($file_name, 'w') or die("can't open file");

		$wanpipe_file = "
#================================================
# WANPIPE" . $this->span. " Configuration File
#================================================
# Card = " . $this->card . " Port = " . $this->port_id . "
# Date: " . date('l jS \of F Y h:i:s A') . "
#
# Note: This file was generated automatically
#       by " . $_SESSION['shortname']  . " WebUI.
#
#       If you want to edit this file, it is
#       recommended that you use " . $_SESSION['shortname']  . " WebUI App
#       
#================================================
# Sangoma Technologies Inc.
#================================================

[devices]
wanpipe" .$this->span . " = WAN_AFT_TE1, Comment

[interfaces]
w" .  $this->span . "g1 = wanpipe" . $this->span . ", , " . $API . ", Comment

[wanpipe" . $this->span . "]
CARD_TYPE       		= AFT
S514CPU         		= A
CommPort        		= PRI
AUTO_PCISLOT    		= NO
PCISLOT         		= " . $this->pci_slot . "
PCIBUS          		= " . $this->pci_bus . "
FE_MEDIA        		= " . strtoupper($this->line_type) . "
FE_LCODE        		= " . strtoupper($this->coding) . "
FE_FRAME        		= " . strtoupper($this->framing) . "";
			if ($this->card == "B601")
			{
				$wanpipe_file .="
FE_LINE         		= 2";
			}
			else
			{
				$wanpipe_file .="
FE_LINE         		= " . $this->port_id . "";
			}
				$wanpipe_file .="			
TE_CLOCK        		= " . strtoupper($this->clock) . "";
			if ($this->card != "B601")
			{
				$wanpipe_file .= "
TE_REF_CLOCK    		= " . strtoupper($this->ref_clock) . "";
			}
			else
			{
				$wanpipe_file .= "
TE_REF_CLOCK    	= 0";
			}
			
			if ($this->line_type == "E1") {
				$wanpipe_file .= "			
TE_SIG_MODE				= " . strtoupper($this->sig_mode);
			}
			$wanpipe_file .="
TE_HIGHIMPEDANCE		= " . strtoupper($this->impedence) . "
TE_RX_SLEVEL    		= " . strtoupper($this->rx_level) . "
LBO             		= " . strtoupper($this->lbo) . "
FE_TXTRISTATE   		= " . strtoupper($this->txtristate) . "
MTU						= 1500
UDPPORT         		= 9000
TTL             		= 255
IGNORE_FRONT_END        = NO";
			if ($_SESSION['freetdm'])
			{
				$wanpipe_file .="		
TDMV_SPAN               = " . $this->span;
			}
			elseif ($_SESSION['dahdi'])
			{
				$wanpipe_file .="		
TDMV_SPAN               = " . $this->dahdi_span;
			}
			
			if ($this->not_ss7 == "yes" || $this->hdlc_repeat == "yes")
			{
				$wanpipe_file .="
TDMV_DCHAN              = " . $this->dchan . "";
			}
			else
			{
				$wanpipe_file .="
TDMV_DCHAN              = 0";
			}
			$wanpipe_file .="
TE_AIS_MAINTENANCE 		= NO       					# NO: defualt  YES: Start port in AIS Blue Alarm and keep line down
					                                # wanpipemon -i w1g1 -c Ttx_ais_off to disable AIS maintenance mode
                                                    # wanpipemon -i w1g1 -c Ttx_ais_on to enable AIS maintenance mode
TDMV_HW_DTMF            = " . strtoupper($this->dtmf) . "	            		# YES: receive dtmf events from hardware
TDMV_HW_FAX_DETECT      = " . strtoupper($this->fax) . "		        		# YES: receive fax 1100hz events from hardware
HWEC_OPERATION_MODE     = OCT_NORMAL    			# OCT_NORMAL: echo cancelation enabled with nlp (default)
                                                    # OCT_SPEECH: improves software tone detection by disabling NLP (echo possible)
                                                    # OCT_NO_ECHO:disables echo cancelation but allows VQE/tone functions. 
HWEC_DTMF_REMOVAL       = " . strtoupper($this->dtmf_removal) . "	 					# NO: default  YES: remove dtmf out of incoming media (must have hwdtmf enabled)
HWEC_NOISE_REDUCTION    = NO    					# NO: default  YES: reduces noise on the line - could break fax
HWEC_ACUSTIC_ECHO       = NO    					# NO: default  YES: enables acustic echo cancelation
HWEC_NLP_DISABLE        = NO    					# NO: default  YES: guarantees software tone detection (possible echo)
HWEC_TX_AUTO_GAIN       = 0     					# 0: disable   -40-0: default tx audio level to be maintained (-20 default)
HWEC_RX_AUTO_GAIN       = 0     					# 0: disable   -40-0: default tx audio level to be maintained (-20 default)
HWEC_TX_GAIN            = 0         			    # 0: disable   -24-24: db values to be applied to tx signal
HWEC_RX_GAIN            = 0             			# 0: disable   -24-24: db values to be applied to tx signal";

			if ($this->hwec_persist) {
				$wanpipe_file .= "
TDMV_HWEC_PERSIST_DISABLE= YES
";
			}
			else
				$wanpipe_file .= "
";

			$wanpipe_file .="
[w" . $this->span . "g1]
ACTIVE_CH       		= ALL";
		if ($this->hdlc_repeat == "yes")
		{
			$wanpipe_file .="
HDLC_REPEAT 			= YES
MTP1_FILTER				= YES
SW_HDLC					= YES";

		}
		
		if (strtoupper($this->coding) == "AMI" && strtoupper($this->framing) == "D4")
		{
			$wanpipe_file .="
SEVEN_BIT_HDLC			= YES";
		}
		
		$wanpipe_file .="
TDMV_HWEC       		= " . $this->echo . "";
			if ($_SESSION['freetdm'])
			{
				$wanpipe_file.="
MTU             		= 80
";
			}
			elseif ($_SESSION['dahdi'])
			{
				$wanpipe_file.="
MTU             		= 8
";
			}
		fwrite($A10xfilehandle, $wanpipe_file);
		fclose($A10xfilehandle);
		
		//shell_exec ("mv " . $file_name . " /etc/wanpipe");
		shell_exec("mv " . $file_name . " " . $file_location);  //Moves the file to the appropriate location
	}	
		
}

//Class creates BRI wanpipe configuration files
class BRI_wanpipe
{
	//BRI Variables
	private $card = "";					//Card being sent into class
	private $card_number = "";			//Contains the number of cards in that class
	private $span = "";					//wanpipe span
	private $bri_span = "";				//TDMV_SPAN
	private $pci_slot = "";				//PCI Slot of the card
	private $pci_bus = ""; 				//PCI Bus of the card
	private $port_id = "";				//Contains the Port ID in question
	private $dtmf = "";					//TDMV_HW_DTMF
	private $fax = "";					//TDMV_FAX_DETECT
	private $echo = "";					//TDMV_HWEC
	private $codec = "";				//Codec variable
	public $db_location="";				//Contains the database location
	
	//Function that retrieves all the data for the port
	function populate_vars($card, $card_number, $span_num, $port_num, $data, $bri_span)
	{
		//Takes the current span number
		$this->span = $span_num;
		$this->card = $card;
		$this->card_number = $card_number;
		$this->port_id = $port_num;
		$this->bri_span = $bri_span;
		
		//Database information
		//$card_format = "AFT-" . $this->card . "-SH-" . ;
		$db_location = $this->db_location;
		//$db_location = "sqlite:sqlite/cardinfo.db";
		
		//Retrieve Card Information		
		$table_name = "card_present";
		$param = "pci_slot, pci_bus";
		$where_param = "id = \"" . $card_number . "\"";
		$card_info = $data->select_statement ($db_location, $table_name, $param, $where_param);
		
		$this->pci_slot = $card_info['pci_slot'];
		$this->pci_bus = $card_info['pci_bus'];
		
		//Retrieve Hardware Information
		$table_name = $card . "_" . $card_number;
		$param = "port_id, hw_ec, hw_dtmf, hw_fax";
		$where_param = "port_id = " . $port_num;
		$hw_info = $data->select_statement ($db_location, $table_name, $param, $where_param);
		
		//Retrieve switchtype Information
		$table_name = $card . "_" . $card_number . "_signalling";
		$param = "switchtype";
		$where_param = "id = " . $port_num;
		$sig_info = $data->select_statement ($db_location, $table_name, $param, $where_param);
			
		//$this->port_id = $hw_info['port_id'];
			
		if ($sig_info['switchtype'] == "EuroISDN")
			$this->codec = "ALAW";
		elseif ($sig_info['switchtype'] == "insnet")
			$this->codec = "MULAW";		
			
		//Echo Canceler Analyzer
		/*$this->echo = $hw_info['hw_ec'];
		if ($hw_info['hw_ec'] == "")
		{
			$this->echo = "NO";
		}
		
		$this->dtmf = $hw_info['hw_dtmf'];
		if ($hw_info['hw_dtmf'] == "")
		{
			$this->dtmf = "NO";
		}
		
		$this->fax = $hw_info['hw_fax'];
		if ($hw_info['hw_fax'] == "")
		{
			$this->fax = "NO";
		}*/
		
		if ($hw_info['hw_ec'] == "enable" || $hw_info['hw_ec'] == "yes")
			$this->echo = "YES";
		elseif ($hw_info['hw_ec'] == "disable" || $hw_info['hw_ec'] == "" || $hw_info['hw_ec'] == "no")
			$this->echo = "NO";
		
		if ($hw_info['hw_dtmf'] == "enable" || $hw_info['hw_dtmf'] == "yes")
			$this->dtmf = "YES";
		elseif ($hw_info['hw_dtmf'] == "disable" || $hw_info['hw_dtmf'] == "" || $hw_info['hw_dtmf'] == "no")
			$this->dtmf = "NO";
		
		if ($hw_info['hw_fax'] == "enable" || $hw_info['hw_fax'] == "yes")
			$this->fax = "YES";
		elseif ($hw_info['hw_fax'] == "disable" || $hw_info['hw_fax'] == "" || $hw_info['hw_fax'] == "no")
			$this->fax = "NO";
	}
	
	//Function that writes the config for that port
	function A500_template($API, $machine_type = "standalone", $id_num = 1)
	{
		if ($machine_type == "standalone")
		{
			$file_location = "/etc/wanpipe";
		}
		elseif ($machine_type == "relay")
		{
			$file_location = "/tmp/relay" . $id_num . "/wanpipe";
		}
	
		$file_name = "wanpipe" . $this->span . ".conf";
	
		$A500filehandle = fopen($file_name, 'w') or die("can't open file");

		$wanpipe_file = "
#================================================
# WANPIPE" . $this->span. " Configuration File
#================================================
# Card = " . $this->card . " Port = " . $this->port_id . "
# Date: " . date('l jS \of F Y h:i:s A') . "
#
# Note: This file was generated automatically
#       by " . $_SESSION['shortname']  . " WebUI.
#
#       If you want to edit this file, it is
#       recommended that you use " . $_SESSION['shortname']  . " WebUI App
#       
#================================================
# Sangoma Technologies Inc.
#================================================

[devices]		
wanpipe" . $this->span. " = WAN_AFT_ISDN_BRI, Comment

[interfaces]
w" . $this->span. "g1 = wanpipe" . $this->span. ", , " . $API . ", Comment

[wanpipe" . $this->span. "]
CARD_TYPE       		= AFT
S514CPU         		= A
CommPort        		= PRI
AUTO_PCISLOT    		= NO
PCISLOT         		= " . $this->pci_slot . "
PCIBUS          		= " . $this->pci_bus . "
FE_MEDIA        		= BRI
FE_LINE         		= " . $this->port_id . "
TDMV_LAW        		= " . $this->codec . "
RM_BRI_CLOCK_MASTER 	= NO
MTU             		= 1500
UDPPORT         		= 9000
TTL             		= 255
IGNORE_FRONT_END		= NO";
			if ($_SESSION['freetdm'])
			{
				$wanpipe_file .="		
TDMV_SPAN               = " . $this->span;
			}
			elseif ($_SESSION['dahdi'])
			{
				$wanpipe_file .="		
TDMV_SPAN               = " . $this->bri_span;
			}

			$wanpipe_file .="
TE_AIS_MAINTENANCE 		= NO                # NO: defualt  YES: Start port in AIS Blue Alarm and keep line down
                                            # wanpipemon -i w1g1 -c Ttx_ais_off to disable AIS maintenance mode
                                            # wanpipemon -i w1g1 -c Ttx_ais_on to enable AIS maintenance mode
TDMV_HW_DTMF        	= " . strtoupper($this->dtmf) . "				# YES: receive dtmf events from hardware
TDMV_HW_FAX_DETECT      = " . strtoupper($this->fax) . "				# YES: receive fax 1100hz events from hardware
HWEC_OPERATION_MODE     = OCT_NORMAL    	# OCT_NORMAL: echo cancelation enabled with nlp (default)
                                        	# OCT_SPEECH: improves software tone detection by disabling NLP (echo possible)
                                            # OCT_NO_ECHO:disables echo cancelation but allows VQE/tone functions.
HWEC_DTMF_REMOVAL       = YES    			# NO: default  YES: remove dtmf out of incoming media (must have hwdtmf enabled)
HWEC_NOISE_REDUCTION    = NO    			# NO: default  YES: reduces noise on the line - could break fax
HWEC_ACUSTIC_ECHO       = NO    			# NO: default  YES: enables acustic echo cancelation
HWEC_NLP_DISABLE        = NO    			# NO: default  YES: guarantees software tone detection (possible echo)
HWEC_TX_AUTO_GAIN       = 0     			# 0: disable   -40-0: default tx audio level to be maintained (-20 default)
HWEC_RX_AUTO_GAIN       = 0     			# 0: disable   -40-0: default tx audio level to be maintained (-20 default)
HWEC_TX_GAIN            = 0     			# 0: disable   -24-24: db values to be applied to tx signal
HWEC_RX_GAIN            = 0     			# 0: disable   -24-24: db values to be applied to tx signal

[w" . $this->span. "g1]
ACTIVE_CH      			= ALL
TDMV_HWEC       		= " . strtoupper($this->echo) . "
MTU             		= 80
";

		fwrite($A500filehandle, $wanpipe_file);
		fclose($A500filehandle);

		shell_exec("mv " . $file_name . " " . $file_location);  //Moves the file to the appropriate location
		//shell_exec ("mv " . $file_name . " /etc/wanpipe");
	}
}


//Wanpipe Configuration File Class for T1/E1 cards
class analog_wanpipe_dahdi
{
	private $card = "";					//Card being sent into class
	private $card_number = "";			//Contains the number of cards in that class
	private $span = "";					//span, TDMV_SPAN
	private $pci_slot = "";				//PCI Slot of the card
	private $pci_bus = ""; 				//PCI Bus of the card
	private $dtmf = "";					//TDMV_HW_DTMF
	private $fax = "";					//TDMV_FAX_DETECT
	private $echo = "";					//TDMV_HWEC
	private $dahdi_span = "";			//TDMV_SPAN for Dahdi
	private $codec = "";				//TDMV_LAW
	private $operation_mode = "";		//TDMV_OPERMODE
	private $network_sync = "";			//TDMV_NETWORK_SYNC
	public $db_location = "";			//Contains the database location
	
	//Populate Wanpipe Variables
	function populate_vars($card, $card_number, $span_num, $port_num, $data, $span_var)
	{
		//Takes the current span number
		$this->dahdi_span = $span_var;
		$this->span = $span_num;
		$this->card = $card;
		$this->card_number = $card_number;
		$this->port_id = $port_num;
		
		//Database information
		$card_format = "AFT-" . $this->card . "-SH-" . $card_number;
		$db_location = $this->db_location;
		//$db_location = "sqlite:sqlite/cardinfo.db";
		
		//Retrieve Card Information		
		$table_name = "card_present";
		$param = "pci_slot, pci_bus";
		//$where_param = "dev_name = \"" . $card_format . "\"";
		$where_param = "id = \"" . $card_number . "\"";
		$card_info = $data->select_statement ($db_location, $table_name, $param, $where_param);
		
		$this->pci_slot = $card_info['pci_slot'];
		$this->pci_bus = $card_info['pci_bus'];
		
		//Retrieve Hardware Information
		$table_name = $card . "_" . $card_number;
		if ($this->card == "B601")
		{
			//$port_num++;
			$param = "echo, dtmf, fax";
		}
		elseif ($this->card == "B700")
		{
			$param = "hw_ec, hw_dtmf, hw_fax";
		}
		else
		{
			$param = "hw_ec, hw_dtmf, hw_fax, network_sync";
		}
		$where_param = "port_id = " . $port_num;
		
		//echo "port = $port_num <br />";
		$hw_info = $data->select_statement ($db_location, $table_name, $param, $where_param);
		
		//Echo Canceler Analyzer
		if ($this->card == "B601")
		{
			$this->echo = $hw_info['echo'];
			$this->dtmf = $hw_info['dtmf'];
			$this->fax = $hw_info['fax'];
			$this->network_sync = "NO";
		}
		else
		{
			/*$this->echo = $hw_info['hw_ec'];
			$this->dtmf = $hw_info['hw_dtmf'];
			$this->fax = $hw_info['hw_fax'];*/
			if ($this->card == "B700")
			{
				$this->network_sync = "NO";
			}
			else
			{
				$this->network_sync = $hw_info['network_sync'];
			}

			if ($hw_info['hw_ec'] == "enable" || $hw_info['hw_ec'] == "yes")
			{
				$this->echo = "YES";
			}
			elseif ($hw_info['hw_ec'] == "disable" || $hw_info['hw_ec'] == "" || $hw_info['hw_ec'] == "no")
			{
				$this->echo = "NO";
			}
			
			if ($hw_info['hw_dtmf'] == "enable" || $hw_info['hw_dtmf'] == "yes")
			{
				$this->dtmf = "YES";
			}
			elseif ($hw_info['hw_dtmf'] == "disable" || $hw_info['hw_dtmf'] == "" || $hw_info['hw_dtmf'] == "no")
			{
				$this->dtmf = "NO";
			}
			
			if ($hw_info['hw_fax'] == "enable" || $hw_info['hw_fax'] == "yes")
			{
				$this->fax = "YES";
			}
			elseif ($hw_info['hw_fax'] == "disable" || $hw_info['hw_fax'] == "" || $hw_info['hw_fax'] == "no")
			{
				$this->fax = "NO";
			}	
		}
	
		
		//Retrieve Hardware Information
		$table_name = $card . "_" . $card_number . "_signalling";
		$param = "codec, operation_mode";
		if ($card == "B700")
		{	
			$where_param = "id = " . $port_num;
		}
		else
		{
			$where_param = "port_id = " . $port_num;
		}
		$sig_info = $data->select_statement ($db_location, $table_name, $param, $where_param);
		
		$this->codec = $sig_info['codec'];
		$this->operation_mode = $sig_info['operation_mode'];
		
		//echo "codec = " . $this->codec . ", echo = " . $this->echo . "<br />";

	}
	
	//Template for the analog series of Cards
	function analog_template($API, $machine_type = "standalone", $id_num = 1)
	{
		if ($machine_type == "standalone")
		{
			$file_location = "/etc/wanpipe";
		}
		elseif ($machine_type == "relay")
		{
			$file_location = "/tmp/relay" . $id_num . "/wanpipe";
		}
		
		$file_name = "wanpipe" . $this->span . ".conf";

		$analogfilehandle = fopen($file_name, 'w') or die("can't open file");

		$wanpipe_file = "
#================================================
# WANPIPE" . $this->span. " Configuration File
#================================================
# Card = " . $this->card . " Port = " . $this->port_id . "
# Date: " . date('l jS \of F Y h:i:s A') . "
#
# Note: This file was generated automatically
#       by " . $_SESSION['shortname']  . " WebUI.
#
#       If you want to edit this file, it is
#       recommended that you use " . $_SESSION['shortname']  . " WebUI App
#       
#================================================
# Sangoma Technologies Inc.
#================================================

[devices]
wanpipe" .$this->span . " = WAN_AFT_ANALOG, Comment

[interfaces]
w" .  $this->span . "g1 = wanpipe" . $this->span . ", , " . $API . ", Comment

[wanpipe" . $this->span . "]
CARD_TYPE   			= AFT
S514CPU     			= A
CommPort   				= PRI
AUTO_PCISLOT    		= NO
PCISLOT     			= " . $this->pci_slot . "
PCIBUS      			= " . $this->pci_bus . "
FE_MEDIA    			= FXO/FXS
TDMV_LAW    			= " . strtoupper($this->codec) . "
TDMV_OPERMODE   		= " . strtoupper($this->operation_mode) . "
RM_BATTTHRESH   		= 3
RM_BATTDEBOUNCE 		= 16
FE_NETWORK_SYNC 		= " . strtoupper($this->network_sync) . "
MTU 					= 1500
UDPPORT         		= 9000
TTL             		= 255
IGNORE_FRONT_END        = NO";
			if ($_SESSION['freetdm'])
			{
				$wanpipe_file .="		
TDMV_SPAN               = " . $this->span;
			}
			elseif ($_SESSION['dahdi'])
			{
				$wanpipe_file .="		
TDMV_SPAN               = " . $this->dahdi_span;
			}
			
			$wanpipe_file .="
TE_AIS_MAINTENANCE 		= NO         				# NO: defualt  YES: Start port in AIS Blue Alarm and keep line down
					    	                        # wanpipemon -i w1g1 -c Ttx_ais_off to disable AIS maintenance mode
                        	                        # wanpipemon -i w1g1 -c Ttx_ais_on to enable AIS maintenance mode
TDMV_HW_DTMF            = " . strtoupper($this->dtmf) . "	           			# YES: receive dtmf events from hardware
TDMV_HW_FAX_DETECT      = " . strtoupper($this->fax) . "		        		# YES: receive fax 1100hz events from hardware
HWEC_OPERATION_MODE     = OCT_NORMAL    			# OCT_NORMAL: echo cancelation enabled with nlp (default)
                                                    # OCT_SPEECH: improves software tone detection by disabling NLP (echo possible)
                                                    # OCT_NO_ECHO:disables echo cancelation but allows VQE/tone functions.
HWEC_DTMF_REMOVAL       = YES    					# NO: default  YES: remove dtmf out of incoming media (must have hwdtmf enabled)
HWEC_NOISE_REDUCTION    = NO    					# NO: default  YES: reduces noise on the line - could break fax
HWEC_ACUSTIC_ECHO       = NO    					# NO: default  YES: enables acustic echo cancelation
HWEC_NLP_DISABLE        = NO    					# NO: default  YES: guarantees software tone detection (possible echo)
HWEC_TX_AUTO_GAIN       = 0     					# 0: disable   -40-0: default tx audio level to be maintained (-20 default)
HWEC_RX_AUTO_GAIN       = 0     					# 0: disable   -40-0: default tx audio level to be maintained (-20 default)
HWEC_TX_GAIN            = 0         			    # 0: disable   -24-24: db values to be applied to tx signal
HWEC_RX_GAIN            = 0             			# 0: disable   -24-24: db values to be applied to tx signal

[w" . $this->span . "g1]
ACTIVE_CH       		= ALL
TDMV_HWEC      			= " . strtoupper($this->echo) . "
MTU             		= 8
";

		fwrite($analogfilehandle, $wanpipe_file);
		fclose($analogfilehandle);
		
		shell_exec("mv " . $file_name . " " . $file_location);  //Moves the file to the appropriate location
		//shell_exec ("mv " . $file_name . " /etc/wanpipe");
	}	
		
}


class wanpipe_common
{
	//Create New wanrouter.rc file
	function wanrouter_rc($wanpipe, $machine_type = "standalone", $id_num = 1)
	{
		//Determine the file location
		if ($machine_type == "standalone")
		{
			$file_location = "/etc/wanpipe";
		}
		elseif ($machine_type == "relay")
		{
			$file_location = "/tmp/relay" . $id_num . "/wanpipe";
		}
		
		$file_name = "wanrouter.rc";
		
		if (file_exists('/etc/redhat-release'))
		{
			shell_exec ("cp wanrouter.rc.template wanrouter.rc");		
		}
		else
		{
			shell_exec ("cp wanrouter-debian.rc.template wanrouter.rc");		
		}

		$filehandle = fopen($file_name, 'a') or die("can't open file");

		$file = "WAN_DEVICES=\"" . $wanpipe . "\"";

		fwrite($filehandle, $file);
		fclose($filehandle);
	
		//Move the file to the appropriate folder for use
		shell_exec ("mv wanrouter.rc " . $file_location . "/wanrouter.rc");
		
		//shell_exec ("cp wanrouter.rc /etc/wanpipe/wanrouter.rc");
		
	}
	
	//Creates wanrouter Start scripts
	function wanrouter_start_script($executor = null)
  {
    $tmp_exec = false;
    // Check if executor is supplied
    if ( null == $executor )
    {
      // No, create a temporary one on local host
      $tmp_exec = true;
      $executor = new executor_class();
      $executor->connect();
    }
		//Remove old sym-links
		//$this->wanrouter_no_startup();
		
		//Add new symlinks
		/*shell_exec ("ln -s /usr/sbin/wanrouter /etc/rc0.d/K91wanrouter");
		shell_exec ("ln -s /usr/sbin/wanrouter /etc/rc1.d/K91wanrouter");
		shell_exec ("ln -s /usr/sbin/wanrouter /etc/rc2.d/K91wanrouter");
		shell_exec ("ln -s /usr/sbin/wanrouter /etc/rc3.d/K91wanrouter");
		shell_exec ("ln -s /usr/sbin/wanrouter /etc/rc4.d/K91wanrouter");
		shell_exec ("ln -s /usr/sbin/wanrouter /etc/rc5.d/K91wanrouter");
		shell_exec ("ln -s /usr/sbin/wanrouter /etc/rc6.d/K91wanrouter");
		shell_exec ("ln -s /usr/sbin/wanrouter /etc/rc2.d/S25wanrouter");
		shell_exec ("ln -s /usr/sbin/wanrouter /etc/rc3.d/S25wanrouter");
		shell_exec ("ln -s /usr/sbin/wanrouter /etc/rc4.d/S25wanrouter");
		shell_exec ("ln -s /usr/sbin/wanrouter /etc/rc5.d/S25wanrouter");*/
		
		$executor->execute("ln -s /usr/sbin/wanrouter /etc/init.d/wanrouter");
		$executor->execute("chkconfig wanrouter on");
		
		$cmd = "chkconfig " . $_SESSION['gateway_script'] . " on";
    	$executor->execute($cmd);
		$cmd = "chkconfig " . $_SESSION['gateway_script'] . " start";
		$executor->execute($cmd);
		
		//require_once '../database_classes.php';
		$data = new database_class;
		
		//Checks if transcoding is enabled or disabled
		$table_name = "transcode_setup";	
		$type = $data->select_statement("sqlite:sqlite/cardinfo.db", $table_name, "setup", "id = 1");	

		if ($type['setup'] != "")
		{
			$cmd = "chkconfig sngtc_server_ctrl on";
			$executor->execute($cmd);
		}
		
		unset($data);		
		
		// Need to close executor ?
		if ($tmp_executor)
		{
		  $executor->disconnect();
		  $executor = null;
		}
	}
	
	//Removes wanrouter boot scripts
	function wanrouter_no_startup($executor = null)
	{
    $tmp_exec = false;
    // Check if executor is supplied
    if ( null == $executor )
    {
      // No, create a temporary one on local host
      $tmp_exec = true;
      $executor = new executor_class();
      $executor->connect();
    }
		
		$executor->execute("chkconfig wanrouter off");
		//exec ("rm -f /etc/init.d/wanrouter");

		$cmd = "chkconfig " . $_SESSION['gateway_script'] . " off";
		$executor->execute($cmd);
		
		//require_once '../database_classes.php';
		$data = new database_class;
		
		//Checks if transcoding is enabled or disabled
		$table_name = "transcode_setup";	
		$type = $data->select_statement("sqlite:sqlite/cardinfo.db", $table_name, "setup", "id = 1");	
	
		if ($type['setup'] != "")
		{
			$cmd = "chkconfig sngtc_server_ctrl off";
			$executor->execute($cmd);
		}
		
		unset($data);
	
		/*shell_exec ("rm -fr /etc/rc1.d/K91wanrouter");	
		shell_exec ("rm -fr /etc/rc2.d/K91wanrouter");	
		shell_exec ("rm -fr /etc/rc3.d/K91wanrouter");	
		shell_exec ("rm -fr /etc/rc4.d/K91wanrouter");	
		shell_exec ("rm -fr /etc/rc5.d/K91wanrouter");	
		shell_exec ("rm -fr /etc/rc6.d/K91wanrouter");	
		shell_exec ("rm -fr /etc/rc2.d/S25wanrouter");
		shell_exec ("rm -fr /etc/rc3.d/S25wanrouter");
		shell_exec ("rm -fr /etc/rc4.d/S25wanrouter");
		shell_exec ("rm -fr /etc/rc5.d/S25wanrouter");*/
	}
  
  // Test if gw starts on boot
  // Rely on the chkconfig --list command (search for 'on' in result)
  function wanrouter_startup_check()
  {
    $fGw = false;
    $fDriver = false;

		exec( "chkconfig " . $_SESSION['gateway_script'] . " --list", $gwStatus );
    if ( strpos( $gwStatus[0], "on")>0 )
      $fGw = true;
		exec ("chkconfig wanrouter --list", $wanrouterStatus);
    if ( strpos( $wanrouterStatus[0], "on")>0 )
      $fDriver = true;
    return ( $fGw && $fDriver );
  }
}

?>