<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

function create_card_classes($relay_name,$display,$data,$tokenization,$system_status)
{
	require_once "display_class.php";
	$dis_common = new Display_common;

	if ($_SESSION['first_time'] == "" || $_REQUEST['refresh'] || $relay_name == "")
	{
		unset($parse_results);
		
		if ($system_status == "up")
		{
			$parse_results = $tokenization->get_information($relay_name);
			$counter = count($parse_results);
		}
		elseif ($system_status == "down")
		{
			$parse_results[0] = "empty";
		}
		//echo $counter . "<br />";
		/*for ($z = 0; $z <= $counter; $z++)
		{
			//if ($parse_results[$z] == "AFT-B600-SH")
			//{
				echo "$z = $parse_results[$z], $parse_results[$int]<br />";
			//}	
		}*/
		
		if ($parse_results[0] == "empty")
		{
			$notif = new NotificationBox( 'Error', NotificationBox::Error );
			$notif->add("Relay", "Unable to retreive data from Slave " . $relay_id['id'] . "Relay node is either down or unable to communicate with Master node.");
			//$notif->add("Configuration"," <a href=\"" . $_SERVER['PHP_SELF'] . "?refresh=yes\">Click Here</a> to refresh" );
			echo $notif->getHtml();		
			unset($notif);	
			$_SESSION['slave_error']++;		
		}
		else
		{
			if ($counter > 0)
			{
				//Initializes the counters
				$a101count = 0;
				$a102count = 0;
				$a104count = 0;		
				$a108count = 0;	
				$b601count = 0;	
				$a200count = 0;
				$a400count = 0;	
				$a500count = 0;	
				$b600count = 0;	
				$b700count = 0;
				$a116count = 0;
				
				for ($b = 0; $b <= $counter; $b++)
				{
					//Fills B601 Class with information from wanrouter hwprobe dump		
					if ($parse_results[$b] == "AFT-B601-SH")
					{	
						if ($b601count % 2 == 0)
						{
							$ii++;
							$b601[$ii] = new cardinfo();
						}
						
						$b601[$ii]->class_create_no_shift($parse_results, $b);
						$b601count++;
					}
					
					//Fills B600 Class with information from wanrouter hwprobe dump
					if ($parse_results[$b] == "AFT-B600-SH")
					{
						if ($b600count % 1 == 0)
						{
							$ax++;
							$b600[$ax] = new cardinfo();
						}
						$b600[$ax]->class_create_no_shift($parse_results, $b);
						$b600count++;	
					}
				
					//Fills A200 Class with information from wanrouter hwprobe dump
					if ($parse_results[$b] == "AFT-A200-SH")
					{
						if ($a200count % 1 == 0)
						{
							$g++;
							$a200[$g] = new cardinfo();
						}
						
						$a200[$g]->class_create_shift($parse_results,$b);
						$a200count++;			
					}
					
					//Fills A400 Class with information from wanrouter hwprobe dump
					if ($parse_results[$b] == "AFT-A400-SH")
					{
						if ($a400count % 1 == 0)
						{
							$f++;
							$a400[$f] = new cardinfo();
						}
						
						$a400[$f]->class_create_shift($parse_results,$b);	
						$a400count++;
					}
						
					//Fills A101 Class with information from wanrouter hwprobe dump
					if ($parse_results[$b] == "AFT-A101-SH")
					{
						if ($a101count % 1 == 0)
						{
							$e++;
							$a101[$e] = new cardinfo();
						}
					
						$a101[$e]->class_create_shift($parse_results,$b);
						$a101count++;
					}
						//Fills A102 Class with information from wanrouter hwprobe dump
					if ($parse_results[$b] == "AFT-A102-SH")
					{
						if ($a102count % 2 == 0)
						{
							$d++;
							$a102[$d] = new cardinfo();
						}
						
						$a102[$d]->class_create_shift($parse_results,$b);
						$a102count++;
					}
					
					//Fills A101 Class with information from wanrouter hwprobe dump
					if ($parse_results[$b] == "AFT-A104-SH")
					{
						if ($a104count % 4 == 0)
						{
							$x++;
							$a104[$x] = new cardinfo();			
						}
						
						$a104[$x]->class_create_shift($parse_results,$b);
						$a104count++;
					}
					
					//Fills A108 Class with information from wanrouter hwprobe dump
					if ($parse_results[$b] == "AFT-A108-SH")
					{
						if ($a108count % 8 == 0)
						{
							$y++;
							$a108[$y] = new cardinfo();	
						}
				
						$a108[$y]->class_create_shift($parse_results,$b);
						$a108count++;		
					}
					//Fills A116 Class with information from wanrouter hwprobe dump
					if ($parse_results[$b] == "AFT-A116-SH")
					{
						if ($a116count % 8 == 0)
						{
							$yl++;
							$a116[$yl] = new cardinfo();	
						}
				
						$a116[$yl]->class_create_shift($parse_results,$b);
						$a116count++;		
					}					
					//Fills A500 Class with information from wanrouter hwprobe dump
					if ($parse_results[$b] == "AFT-A500-SH")
					{
						$q = $b + 1;
						$h = $b + 3;
						$i = $b + 2;
						$s = $b + 4;
						if ($last_bus != $parse_results[$s] || $last_slot != $parse_results[$i])
						{	
							$last_bus = $parse_results[$s];
							$last_slot = $parse_results[$i];			
							$z++;
							$a500[$z] = new cardinfo();		
						}
						$mc = $b + 14;
						$line = $b + 8;
						
						//Takes in all the values for the line type and the fe_line
						if ($parse_results[$mc] == "NT" || $parse_results[$mc] == "TE")
						{
							//echo "$z<br />";
							//echo "$parse_results[$line] = $parse_results[$mc] <br />";
						
							$bri_info[$z][$parse_results[$line]] = $parse_results[$mc];
						}
						//echo "<hr style='width:700px;' align='left'/>";
						/*foreach ($bri_info[$z] as $key => $value)
						{
							echo "$bri_info[$z] , $key = $value<br />";
						}*/
						
						$a500[$z]->class_bri($parse_results,$b);
						$a500count++;
					}
						//Fills B700 Class with information from wanrouter hwprobe dump
					if ($parse_results[$b] == "AFT-B700-SH")
					{
						$qli = $b + 1;
						$hil = $b + 3;
						$iil = $b + 2;
						$sil = $b + 4;
								
						if ($last_bus != $parse_results[$sil] || $last_slot != $parse_results[$iil])
						{	
							$last_bus = $parse_results[$sil];
							$last_slot = $parse_results[$iil];			
							$zil++;
							$b700[$zil] = new cardinfo();		
						}
						//echo "last_bus = " . $last_bus . "<br />";
						
						//BRI
						$mc = $b + 14;
						$line = $b + 8;
				
						//Takes in all the values for the line type and the fe_line
						if ($parse_results[$mc] == "NT" || $parse_results[$mc] == "TE" || $parse_results[$mc] == "FXO" || $parse_results[$mc] == "FXS")
						{
							//echo "$parse_results[$line] = $parse_results[$mc] <br />";
						
							$bri_b700_info[$zil][$parse_results[$line]] = $parse_results[$mc];
						}
				
						$b700[$zil]->class_bri($parse_results,$b);
						
						$b700count++;
					}
				}
				
				unset ($_SESSION['last_int']);
				
				//Creates the wanrouterhwprobe table in SQLite
				if ($_SESSION['first_time'] == "")
				{
					$data->create_hardware_table($relay_name);
				}	
		
				$_SESSION['card_count'] = $display->create_html_table($a101, $a102, $a104, $a108, $a200, $a400, $b601, $b700, $a500, $a116, $data, $tokenization, $bri_info, $bri_b700_info, $b600, $relay_name);
				
				unset($_SESSION['group']);
			}
			else
			{
				$notif = new NotificationBox( 'Error', NotificationBox::Error );
				$notif->add("TDM", "TDM Cards Not Detected");
				$notif->add("TDM", "If you do not have the latest wanpipe driver, please <a href=\"http://wiki.sangoma.com/wanpipe-linux-drivers\" target=\"_blank\">click here</a>");
				$notif->add("TDM", "If there are no cards inserted, please power down the gateway and insert your TDM Cards");
				echo $notif->getHtml();		
				unset($notif);	
			}
		}
	}
	else
	{
		//Run Cached mode
		//Initializes the counters
		$a101count = 0;
		$a102count = 0;
		$a104count = 0;		
		$a108count = 0;	
		$b601count = 0;	
		$a200count = 0;
		$a400count = 0;	
		$a500count = 0;	
		$b600count = 0;	
		$b700count = 0;
		$a116count = 0;
		
		//Pull all information out of the card_present table for each database
		$relay_id = $data->select_statement('sqlite:sqlite/relay_info.db','relay_hosts','id',"relay_name = \"$relay_name\"");
		
		if ($relay_id['id'] == 1)
			$db = "sqlite:sqlite/cardinfo.db";
		else
			$db = "sqlite:sqlite/cardinfo" . $relay_id['id'] . ".db";
		
		$card_tot = $data->select_statement($db,'card_present','count(id)','');
		
		
		if ($card_tot['count(id)'] == 0)
		{
			$notif = new NotificationBox( 'Error', NotificationBox::Error );
			$notif->add("Relay", "Unable to retreive data from Slave " . $relay_id['id'] . ". Relay node is either down or unable to communicate with Master node.");
			//$notif->add("Configuration"," <a href=\"" . $_SERVER['PHP_SELF'] . "?refresh=yes\">Click Here</a> to refresh" );
			echo $notif->getHtml();		
			unset($notif);	
			$_SESSION['slave_error']++;	
		}
		else
		{
			$parse_results= $data->array_select_statement ($db, 'card_present','dev_name' , '');
			$z = 0;
			do
			{
				//Pull each card out of the table and create the object		
				$c = $z + 1;
				//Fills A101 Class with information from wanrouter hwprobe dump
				for ($b = 0; $b <= count($parse_results); $b++)
				{
					if ($parse_results[$z]['dev_name'] == "AFT-A101-SH-$b")
					{
						//echo "i am here<br />";
						//echo "$b = " . $parse_results[$z]['dev_name'] . "<br />\n";
						$e++;
						$a101[$e] = new cardinfo();
						$a101[$e]->cached_info($data,$db,$c);
						$a101count++;
					}
				}
				
				//Fills A102 Class with information from wanrouter hwprobe dump
				for ($b = 0; $b <= count($parse_results); $b++)
				{
					if ($parse_results[$z]['dev_name'] == "AFT-A102-SH-$b")
					{				
						$d++;
						$a102[$d] = new cardinfo();	
						$a102[$d]->cached_info($data,$db,$c);
						$a102count++;
					}
				}
				
				//Fills A104 Class with information from wanrouter hwprobe dump
				for ($b = 0; $b <= count($parse_results); $b++)
				{
					//echo "Here <br />";
					//echo "$b = " . $parse_results[$z]['dev_name'] . "<br />\n";
					if ($parse_results[$z]['dev_name'] == "AFT-A104-SH-$b")
					{
						//echo "I am here<br />";
						$x++;
						$a104[$x] = new cardinfo();			
						
						$a104[$x]->cached_info($data,$db,$c);
						$a104count++;
					}
				}
				
				//Fills A108 Class with information from wanrouter hwprobe dump.
				for ($b = 0; $b <= count($parse_results); $b++)
				{
					if ($parse_results[$z]['dev_name'] == "AFT-A108-SH-$b")
					{
						$y++;
						$a108[$y] = new cardinfo();	
						$a108[$y]->cached_info($data,$db,$c);
						$a108count++;		
					}					
				}
				//Fills A116 Class with information from wanrouter hwprobe dump
				for ($b = 0; $b <= count($parse_results); $b++)
				{
					if ($parse_results[$z]['dev_name'] == "AFT-A116-SH-" . $b)
					{
						if ($a116count % 8 == 0) {
							$yl++;
							$a116[$yl] = new cardinfo();	
						}
				
						//$a116[$yl]->class_create_shift($parse_results,$b);
						$a116[$yl]->cached_info($data,$db,$c);
						$a116count++;		
					}					
				}
				$z++;
			}while ($z <= count($parse_results));
				
			$_SESSION['card_count'] = $display->create_html_table($a101, $a102, $a104, $a108, $a200, $a400, $b601, $b700, $a500, $a116, $data, $tokenization, $bri_info, $bri_b700_info, $b600, $relay_name);		
			unset($_SESSION['group']);	
				
		}
	}
	unset($dis_common);
	//return $slave_error2;
}
            

function generic_database_select($db_location, $table_name, $param)
{
    $a = 0;

    $select = "SELECT " . $param . " FROM " . $table_name . ";";

    try
    {
        //open the database
        $db = new PDO($db_location);

        $result = $db->query($select);

        foreach($result as $row)
        {
        $array[$a] = $row;
        $a++;
    }
        // close the database connection
        $db = NULL;
    }
    catch(PDOException $e)
    {
        print 'Exception : '.$e->getMessage();
    }

    $_SESSION['relay_counter'] = $a;
    return $array;
}


function relay_tdm( $relay_name,$display,$data,$tokenization, $system_status)
{
	echo "        <table border='0'>\n";
	echo "<tr>\n<td>\n";

	//Create required tables within the cardinfo databases for the slaves
	if (!preg_match("'\bMaster1\b'",$relay_name) && $_SESSION['first_time'] == "")
		create_slave_tables($data,$relay_name);
	
	create_card_classes($relay_name,$display,$data,$tokenization,$system_status);

	// Close table
	echo "</td>\n</tr>\n";
	echo "    </table>\n";
}

function relay_javascript()
{
	echo "
	<script type='text/javascript'>
	function displayLogTab( logType )
	{
		// Retrieve all div elements
		var aDivList = document.getElementsByTagName('div');
		for (var i = 0; i < aDivList.length; i++) {
		  // check if div is a log div
		  if ( -1 != aDivList[i].id.indexOf( '_tab' ) )
		  {
			// Check if it's the one we want to display
			if ( aDivList[i].id == logType + '_tab' )
			{
			  // change style to block
			  aDivList[i].style.display = 'block'; 
			  ResizeFrame();
			}
			else
			{
			  // change style to none
			  aDivList[i].style.display = 'none'; 
			}
		  }
		}
  		// Retrieve all div elements
        var aDivList = document.getElementsByTagName('th');
        for (var i = 0; i < aDivList.length; i++) {
          // check if div is a tab div
          if ( -1 != aDivList[i].id.indexOf( '_tab' ) )
          {
            // Check if it's the one we want to modify
            if ( aDivList[i].id == logType + '_tab' )
            {
              // change style to block
              aDivList[i].setAttribute( 'class', 'widget-content-header ui-state-active ui-corner-top');
            }
            else
            {
              // change style to none
              aDivList[i].setAttribute( 'class', 'widget-content-header ui-corner-top');
            }
          }
		}
	}	
	 \n"; 
	//ResizeFrame();
	
	if ($_SESSION['proc_id'] == "")
		echo "window.onload = function() {displayLogTab( 'Master1' );ResizeFrame();};\n";
	elseif ($_SESSION['proc_id'] == 1)
		echo "window.onload = function() {displayLogTab( 'Master1' );ResizeFrame();};\n";		
	elseif ($_SESSION['proc_id'] > 1)
		echo "window.onload = function() {displayLogTab( 'Slave" . $_SESSION['proc_id'] . "' );ResizeFrame();};\n";		
	
    echo "</script>\n";	
}


function reset_restore($display_common,$data,$relay_name,$slave_error,$notification=true)
{
	//Checks for completed ports
	//determine databases and check to make sure at least the master is ready to generate configuration.
	$count_hosts = $data->select_statement('sqlite:sqlite/relay_info.db','relay_hosts','count(id)',"");

	if ($relay_name == "Master")
	{
		for ($b = 1; $b <= $count_hosts['count(id)']; $b++)
		{
			//echo "counter = $b<br />";
			unset($check);
			if ($b == 1)
			{
				$db_location = "sqlite:sqlite/cardinfo.db";	
				$type = "local";
			}
			elseif ($b > 1)
			{
				$db_location = "sqlite:sqlite/cardinfo" . $b . ".db";
				$type = "remote";
			}	

			if ($data->check_for_table($db_location,'finished_ports') > 1)
			{
				$result = $data->select_statement($db_location, "finished_ports", "id", "");	
				$relay_info = $data->select_statement('sqlite:sqlite/relay_info.db','relay_hosts','ip_addr,ssh_port',"id = $b");
				//echo $relay_info['ip_addr'];
				//echo "Results = " . count($result) . "<br />";
				if (count($result) > 1)
				{
					//Check wanrouter status
					require_once "SSH_Class.php";
					$ssh = new ssh_class;
					$output = $ssh->execute($type,"/usr/sbin/wanrouter status | grep -c wanpipe",$relay_info['ip_addr'],$relay_info['ssh_port']);
					unset($ssh);
				
					//echo "$b = wanrouter = " . $output[0] . "<br />";
					if (intval($output[0]) != 0)
					{
						//echo " equals everything else<br />";
						//Check if the gateway is started on each machine then check if each relay database is in sync
						if ( !isTdmConfigInSync($db_location) )
							$out_of_sync = "yes";

						$gateway_started = "yes";
					}
					elseif ($output[0] == "DISABLED" || $output[0] == "INVALID KEY" || $output[0] == 0)
					{
							if ( !isTdmConfigInSync($db_location) )
									$out_of_sync = "yes";
					}
				}
			}
			require_once 'display_class.php';
			require_once "production-test/prod-test-class.php";
			
			$notif = new NotificationBox( 'Warnings', NotificationBox::Warning );

			//Check for relay node connection errors
			if ( $slave_error > 0 )
			{
				$notif->add("Relay", $slave_error . " Slave relay node(s) are unreachable." );
				$notif->add("Relay","Check slave relay node configuration within the <a href='relay/relay_cfg.php?top'>Relay Configuration</a>." );
			}

			// Check if TDM configuration is in synch
			if ( $out_of_sync == "yes" )
			{
				$notif->add("TDM","Configuration out of sync" );
				if ( $slave_error > 0 )
					$notif->add("TDM","Cannot generate configuration until all Relay Nodes active" );
				else
				{
					if ( $gateway_started == "yes")
					{
						if(isMGConfigInSync($db_location)) {
							if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
								$notif->add("TDM","<a href='profile_panel.php' >Synchronize</a> configuration." );
							else
								$notif->add("TDM","<a href='/admin/ss7_profile_panel.php' target='_parent'>Synchronize</a> configuration." );
						}else{
							if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
								$notif->add("TDM","<a href='controls_embedded.php' >Stop</a> or <a href='profile_panel.php' >Synchronize</a> the gateway" );
							else
								$notif->add("TDM","<a href='/admin/ss7_controls.php' target='_parent'>Stop</a> or <a href='/admin/ss7_profile_panel.php' target='_parent'>Synchronize</a> the gateway" );
							$notif->add("TDM","Generate TDM configuration." );
						}
					}
					else
					{
						if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
							$notif->add("TDM","Please proceed to the <a href=\"sng_config_manager.php\" >Apply Configuration</a> Page");
						else
							$notif->add("TDM","Please proceed to the <a href=\"/admin/ss7_cfg_manager.php\" target='_parent'>Apply Configuration</a> Page");
					}
				}
			}						
			elseif ($gateway_started != "yes" && $slave_error == 0 && count($result) > 0)
			{
				if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
					$notif->add("TDM","Start the <a href='controls_embedded.php' >gateway</a>" );
				else
					$notif->add("TDM","Start the <a href='/admin/ss7_controls.php' target='_parent'>gateway</a>" );
			}
			elseif ($gateway_started != "yes" && $slave_error != 0)
				$notif->add("TDM","Cannot start the gateway until all Relay Nodes active" );
			
		}
			
		echo "<br />";	
		
		//CHECK LICENSE CONFLICTS	
		$mediaObj = new prod_test();
		$display_common->get_license_status($data,$mediaObj,$license_err, $channel_err,$trial_license_error);
		$mediaObj = NULL;	
		
		if ( $license_err!= "" )
		{
			$notif->add("License", $license_err);
		}
		$notif->display();	
		echo "<br />";
		unset($notif);
		$notif = new NotificationBox( 'Error', NotificationBox::Error );
		if ( $channel_err!= "" )
			$notif->add("Channels", $channel_err);

		if (isset($trial_license_error))
			$notif->add("Timed Trial", $trial_license_error);

		$notif->display();	
		unset($notif);		
		
		if ($notification) {
			if ($_SESSION['first_time'] == "True" || $_SESSION['first_time'] == "true")
			{
				echo "<br />";
				?>
				<div id='config_refresh' style="width:700px">
				<?php
				$notif = new NotificationBox( 'Info', NotificationBox::Info );
				$notif->add("Configuration", "TDM Information was last refreshed on " . $_SESSION['date_refreshed']);
				$notif->add("Configuration"," <a href=\"" . $_SERVER['PHP_SELF'] . "?refresh=yes\">Click Here</a> to refresh" );
				$notif->display();		
				unset($notif);	
				echo "</div>\n";
				echo "<br />";
				unset($notif);	
			}
			?>
			</table>
			<?php				
		}
	}
}

//Creates the slave database structures
function create_slave_tables($data,$relay_name)
{
	$relay_info = $data->select_statement('sqlite:sqlite/relay_info.db','relay_hosts','id',"relay_name = \"$relay_name\"");		
	$db_location = "sqlite:sqlite/cardinfo" . $relay_info['id'] . ".db";
	
	//echo $db_location;
	
	//Create required tables
	$table_name = "t1e1_profile";
	$parameters = "id int primary key, profile_name varchar(60), line_type varchar(10), protocol varchar(10), switchtype varchar(30), signalling varchar(30), ton_name varchar(100), ton_value varchar(100), npi_name varchar(100), npi_value varchar(100), facility varchar(10), facility_timeout int, bearer_ITC varchar(30), bearer_UIL varchar(30), overlap varchar(30)";
	$data->create_table($db_location, $table_name, $parameters);
	
	$table_name = "bri_profile";
	$parameters = "id int primary key, profile_name varchar(60), conn_type varchar(10), sig_type varchar(10), interface varchar(10), switchtype varchar(30), tei int, overlap varchar(10), ton_name varchar(100), ton_value varchar(100), npi_name varchar(100), npi_value varchar(100), bearer_ITC varchar(30), bearer_UIL varchar(30), msn varchar(100), min_digits int";
	$data->create_table($db_location, $table_name, $parameters);
	
	$table_name = "analog_profile";
	$parameters = "id int primary key, profile_name varchar(60), conn_type varchar(10), codec varchar(10), operation_mode varchar(10), hangup_polarity varchar(20), answer_polarity varchar(20),callerid varchar(20), tones varchar(20), call_waiting varchar(20), three_way varchar(20), call_swap varchar(20), digit_timeout int, max_digits int, polarity_delay int";
	$data->create_table($db_location, $table_name, $parameters);
	
	//Creates the card_present table
	$table_name = "card_present";
	$parameters = "id int primary key, dev_name varchar(60), pci_slot int, pci_bus int, num_ports int, firmware int, echo varchar(20), analog_location int, num_te int, num_nt int";
	$data->create_table($db_location, $table_name, $parameters);		
	
	//Creates the SS7 Linkset Profile Table
	$table_name = "ss7_linkset_profile";
	$parameters = "id int primary key, profile_name varchar(60), apc int, minactive int";
	$data->create_table($db_location, $table_name, $parameters);	
	
	//Create the linkset used table
	$table_name="used_linkset";
	$parameters = "id int primary key, card varchar(30), name varchar(60)";
	$data->create_table($db_location, $table_name, $parameters);	
	
	//Creates the SS7 ISUP Profile Table
	$table_name = "ss7_isup_profile";
	$parameters = "id int primary key, profile_name varchar(60), spc int, ssf varchar(30), route varchar(60), t6 int, t9 int";
	$data->create_table($db_location, $table_name, $parameters);	
		
	//Create the isup used table
	$table_name="used_isup";
	$parameters = "id int primary key, card varchar(30), name varchar(60)";
	$data->create_table($db_location, $table_name, $parameters);	
	
	//Creates the SS7 Route Profile Table
	$table_name = "ss7_route_profile";
	$parameters = "id int primary key, profile_name varchar(60), dpc int, linksets varchar(100), stp varchar(10)";
	$data->create_table($db_location, $table_name, $parameters);	
	
	//Create the route used table
	$table_name="used_route";
	$parameters = "id int primary key, isup varchar(30), name varchar(60)";
	$data->create_table($db_location, $table_name, $parameters);	
		
	//Creates the Hosts Table
	$table_name = "hosts";
	$parameters = "id int, hostname varchar(100), ssh_port int, username varchar(100), smg_version varchar(50), relay_port int";
	$data->create_table($db_location, $table_name, $parameters);		
	
	//Creates the transcoding table
	$table_name = "transcode";
	$parameters = "id int primary key, interface varchar(30), ip_address varchar(30), net_mask varchar(30), mac_addr varchar(30), num_modules int, nibble varchar(30)";
	$data->create_table($db_location, $table_name, $parameters);	
	
	//Creates finished ports table
	$table_name = "finished_ports";
	$parameters = "id int primary key, card varchar(30), completed varchar(10), type varchar(30)";
	$data->create_table($db_location, $table_name, $parameters);	
	
	//Creates the transcoding codec	table. This is the table which the users chosen codecs get placed
	$table_name = "transcode_user_codecs";
	$parameters = "id int primary key, codec_syntax varchar(30)";
	$data->create_table($db_location, $table_name, $parameters);	
	
	//Creates the transcoding setup database
	$table_name = "transcode_setup";
	$parameters = "id int primary key, setup varchar(20)";
	$data->create_table($db_location, $table_name, $parameters);				
	
	//Creates the transcoding codec	table. This is the table which the users chosen codecs get placed
	$table_name = "transcode_bind";
	$parameters = "id int primary key, bind_addr varchar(30), bind_port varchar(30)";
	$data->create_table($db_location, $table_name, $parameters);	
	
	//Insert Default Profiles
	$table_name = "t1e1_profile";
	$parameters = "id, profile_name, line_type, protocol, switchtype, signalling, facility, bearer_ITC, overlap";
	
	$values = "1, \"T1 PRI CPE\", \"T1\", \"CCS\", \"NI2\", \"PRI CPE\", \"no\", \"\", \"disable\"";
	$data->insert_statement($db_location, $table_name, $parameters, $values);
	
	$values = "2, \"E1 PRI CPE\", \"E1\", \"CCS\", \"EuroISDN\", \"PRI CPE\", \"no\", \"\", \"disable\"";
	$data->insert_statement($db_location, $table_name, $parameters, $values);
	
	$values = "3, \"T1 PRI NET\", \"T1\", \"CCS\", \"NI2\", \"PRI NET\", \"no\", \"\", \"disable\"";
	$data->insert_statement($db_location, $table_name, $parameters, $values);
	
	$values = "4, \"E1 PRI NET\", \"E1\", \"CCS\", \"EuroISDN\", \"PRI NET\", \"no\", \"\", \"disable\"";
	$data->insert_statement($db_location, $table_name, $parameters, $values);		
	
	//Insert Default BRI Profiles
	$table_name = "bri_profile";
	$parameters = "id, profile_name, conn_type, sig_type,  interface, switchtype, tei, overlap, bearer_ITC, min_digits";
	
	$values = "1, \"BRI PTMP CPE\", \"TE\", \"CPE\", \"ptmp\", \"EuroISDN\", \"\", \"disable\", \"\", 7";
	$data->insert_statement($db_location, $table_name, $parameters, $values);
	
	$values = "2, \"BRI PTMP NET\", \"NT\", \"NET\", \"ptmp\", \"EuroISDN\", \"\", \"disable\", \"\", 7";
	$data->insert_statement($db_location, $table_name, $parameters, $values);
	
	$values = "3, \"BRI PTP CPE\", \"TE\", \"CPE\", \"ptp\", \"EuroISDN\", \"\", \"disable\", \"\", 7";
	$data->insert_statement($db_location, $table_name, $parameters, $values);
				
	$values = "4, \"BRI PTP NET\", \"NT\", \"NET\", \"ptp\", \"EuroISDN\", \"\", \"disable\", \"\", 7";
	$data->insert_statement($db_location, $table_name, $parameters, $values);			
	
	//Insert Default Analog Profiles
	$table_name = "analog_profile";
	$parameters = "id, profile_name, codec, operation_mode, hangup_polarity, answer_polarity, callerid, tones, call_waiting, three_way, call_swap, polarity_delay";
	
	$values = "1, \"ANALOG MULAW\", \"MULAW\", \"FCC\", \"disable\", \"disable\", \"enable\", \"us\", \"disable\", \"disable\", \"disable\", \"600\"";
	$data->insert_statement($db_location, $table_name, $parameters, $values);
	
	$values = "2, \"ANALOG ALAW\", \"ALAW\", \"TBR21\", \"disable\", \"disable\", \"enable\", \"us\", \"disable\", \"disable\", \"disable\", \"600\"";
	$data->insert_statement($db_location, $table_name, $parameters, $values);	
	
}



//Checks for remote system status
function system_status ($ip_addr)
{
	//Run ping command and check for results
	//$cmd = "ping -c4 " . $ip_addr . " | grep -c 'Destination Host Unreachable'";
	$cmd = "ping -c 1 -w 1 -W 1 -s 160 -q -Q 0x18 " . $ip_addr;
	exec ($cmd, $output);
	
	for ($a = 0; $a <= count($output); $a++)
	{
		
		if (preg_match("'\brtt\b'",$output[$a]))
		{
			$rtt_vals = $output[$a];
		}
	}
	
	//Cut out "=" and "ms" values
	$equalsign = strpos($rtt_vals, '=');
	$ms = strpos($rtt_vals,'ms');
		
	$value = substr($rtt_vals,($equalsign + 1));
	$value2 = substr($value,0,-3);
	
	//echo "values = $value2<br />";
	
	//Determine the average by tokenizing the return
	$token_rtt = tokenize_rtt($value2);
	$sum = 0.0;
	for ($a = 0; $a < count($token_rtt); $a++)
	{
		//echo gettype($token_rtt[$a]) . "<br />";
		//$sum = bcadd($token_rrt[$a],$sum,4);
		$sum = sprintf("%.4f", $token_rtt[$a] + $sum);
		//echo "tentaive sum = $sum<br />";
	}
	//echo "Sum = $sum<br />";
	$avg = $sum / 4;
	//echo "Average = $avg<br />";
	if ($avg == (float)0)
	{
		$system = "down";
	}
	elseif ($avg > (float)0)
	{
		$system = "up";
	}
	//echo $system;
	return $system;
}
//Tokenizes the card name
function tokenize_rtt($string)
{
	$tok = strtok($string, "/");

	$count = 0;
	while ($tok !== false) 
	{
		$token[$count] = (float)$tok;
		$tok = strtok("/");
		$count++;
	}

	return $token;
}
?>
