<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

session_start();
//include 'database_classes.php';

class ss7_display extends database_class
{
	public $card_num="";				//Contains the card number
	public $port_count="";				//Contains the port count
	public $card_name="";				//Contains the card name
	private $ss7_linksets = array();	//Contains all the ss7 linksets
	private $ss7_routes = array();		//Contains all the ss7 ISUP Interfaces
	private $ss7_isups = array();		//Contains all the ss7 Routes
	private $ss7_ccspans = array();		//Contains all the ss7 CCSpans
	private $counter_linkset="";		//Linkset Counter variable
	private $counter_route="";			//Route Counter variable
	private $counter_isup="";			//ISUP Counter variable
	public $ss7_linkset="";				//Contains the SS7 Linkset chosen by the user
	private $token_card_name="";		//Contains the card name tokenized
	private $ss7_voicelink="";			//Variable that shows whether the link is a voicelink or not
	public $line_type="";				//T1/E1 line type
	public $span_counter="";			//Counts the number of spans in the system
	public $proc_id="";					//Contains the SS7 proc_id
	public $ss7_m2ua_link="";	
	public $ss7_mg_channels="";
	
	//Main Display function for the SS7 Class
	function main()
	{	
		//Opens the global hwprobe table functions
		unset($view);
		include_once ('global_view.php');
		$view = new view_options;
		$view->view();		
		
		//Tokenizes the card name for use
		$this->token_cardname();
		
		//Gets information from the database
		$this->get_chosen_linkset();
		$this->get_linkset_list();
		$this->get_isup_list();
		$this->get_route_list();
		$this->check_voicelink();		
		$this->check_m2ualink();
		$this->check_mglink();
		
		$table_status = parent::check_for_table('sqlite:sqlite/relay_info.db','relay_hosts');
		//echo $table_status . "<br />";	
		if ($table_status > 1)
		{
			//pull information
			$relay_type = parent::select_statement('sqlite:sqlite/relay_info.db','ss7_relay','machine_type,relay_type',"");
			//echo $relay_type['relay_type'] . "<br />";
			if (($relay_type['machine_type'] == "relay" && $relay_type['relay_type'] == "SLAVE"))
			{
				$ss7_slave = "yes";
			}
		}
		
		if ($this->ss7_m2ua_link['link_name'] != "")
		{
			//Master Table Separations (Needed to seperate the specific tables)
			echo "</td>\n";
			echo "<td width='93px'><b>Cluster</b>:";
			if ($this->ss7_m2ua_link['cluster']!="")
				echo $this->ss7_m2ua_link['cluster'] . "\n";
				
			echo "</td>\n";
			echo "<td align=\"right\">\n";
			if (($relay_type['machine_type'] == "relay" && $relay_type['relay_type'] == "SLAVE"))
			{
				echo "<input type=\"submit\" name=\"config-cluster-" . $this->card_name . "-". $this->port_count . "-" . $this->card_num . "-" . $_SESSION['span_num'] . "-" . $this->proc_id . "\" value=\"Edit\" disabled=\"disabled\" " . $_SESSION['disabled_button_class'] . "/>\n";	
			}
			else
			{
				echo "<input type=\"submit\" name=\"config-cluster-" . $this->card_name . "-". $this->port_count . "-" . $this->card_num . "-" . $_SESSION['span_num'] . "-" . $this->proc_id . "\" value=\"Edit\" " . $_SESSION['button_class'] . "/>\n";	
			}
			echo "</td>\n";
			echo "</tr>\n";
			echo "</table>\n";			
		}		
		elseif ($this->ss7_voicelink == "" && $this->ss7_mg_channels['profile_name'] == "")
		{
			//Master Table Separations (Needed to seperate the specific tables)
			echo "</td>\n";
			//echo "<td>\n";

			echo "<td width='80px'><b>Linkset</b>:";		
			
			if ($this->ss7_linkset['linkset']!="")
			{
				echo $this->ss7_linkset['linkset'] . "\n";
			}
			echo "</td>\n";
			echo "<td align=\"right\">\n";
			if (($relay_type['machine_type'] == "relay" && $relay_type['relay_type'] == "SLAVE"))
			{
				echo "<input type=\"submit\" name=\"config-linkset-" . $this->card_name . "-". $this->port_count . "-" . $this->card_num . "-" . $_SESSION['span_num'] . "-" . $this->proc_id . "\" value=\"Edit\" disabled=\"disabled\" " . $_SESSION['disabled_button_class'] . "/>\n";	
			}
			else
			{
				echo "<input type=\"submit\" name=\"config-linkset-" . $this->card_name . "-". $this->port_count . "-" . $this->card_num . "-" . $_SESSION['span_num'] . "-" . $this->proc_id . "\" value=\"Edit\" " . $_SESSION['button_class'] . "/>\n";	
			}
			echo "</td>\n";
			echo "</tr>\n";
			echo "</table>\n";
			
			//echo "\t\t</td>\n";
		}
		elseif ($this->ss7_voicelink == "yes" || $this->ss7_mg_channels['profile_name'] != "")
		{
			echo "</td>\n";
			echo $view->voice_link_td;
			echo "</tr>\n";
			echo "</table>\n";
			//echo "</td>\n";
		}
		
		//Master Table Separations (Needed to seperate the specific tables)
		echo "\t\t</td>\n";
		echo "\t\t<td>\n";	
		
		//Check whether there are linksets/routes/isups defined
		for ($a = 0; $a <= $this->counter_isup; $a++)
		{
			if ($this->ss7_isups[$a]['profile_name'] != "")
			{
				$ok_isup = "ok";
			}
		}
		for ($a = 0; $a <= $this->counter_linksets; $a++)
		{
			if ($this->ss7_linksets[$a]['profile_name'] != "")
			{
				$ok_linkset = "ok";
			}
		}
		for ($a = 0; $a <= $this->counter_route; $a++)
		{
			if ($this->ss7_routes[$a]['profile_name'] != "")
			{
				$ok_route = "ok";
			}
		}

		//echo "linkeset = " . $ok_linkset . " route = $ok_route isup = $ok_isup<br />";
		
		if (($this->ss7_linkset['linkset'] != "" && $this->ss7_m2ua_link == ""  && $this->ss7_mg_channels['profile_name'] == "")|| ( $this->ss7_voicelink == "yes" && $this->ss7_m2ua_link == "" && $this->ss7_mg_channels['profile_name'] == ""))
		{
			if (($ok_linkset == "ok" && $ok_route == "ok" && $ok_isup == "ok") || $ss7_slave == "yes")
			{
				$this->get_ccspans();
				//echo "ccspan isup = " . $this->ss7_ccspans['isup'];
				if ($this->ss7_ccspans['isup'] == "")
				{
					
					//CC Spans not configured
					echo $view->ccspan_notconfigured;
					
					echo "\t\t\t<tr>\n";
					echo "\t\t\t\t<td>\n";
					echo "<b>Channel Configuration: </b>";
					echo "</td>\n";
					echo "<td align=\"right\">\n";
					echo "<input type=\"submit\" name=\"config-ss7ccspan-" . $this->card_name . "-". $this->port_count . "-" . $this->card_num . "-" . $_SESSION['span_num'] . "-" . $this->proc_id . "\" value=\"Edit\" " . $_SESSION['button_class'] . "/>\n";			
					echo "</td>\n";
					echo "\t\t\t</tr\">\n";
					echo "\t\t</table>\n";					
				}
				else
				{
					
					//CCSpans Configured
					echo $view->ccspan_configured;
					
					echo "\t\t\t<tr align=\"center\">\n";
					echo "\t\t\t\t<td>\n";
					echo "\t\t\t\t<table>\n";
					echo "\t\t\t\t\t<tr>\n";
					echo "\t\t\t\t\t\t<td align=\"center\"><b>Channel Map</b></td>\n";
					echo "\t\t\t\t\t\t<td align=\"center\"><b>CiC</b></td>\n";
					echo "\t\t\t\t\t\t<td align=\"center\"><b>Group</b></td>\n";
					echo "\t\t\t\t\t\t<td align=\"center\"><b>Interface</b></td>\n";									
					echo "\t\t\t\t\t</tr>\n";
					echo "\t\t\t\t\t<tr>\n";		
					//echo "<input type=\"text\" name=\"channel-map-" . $card_name . "-". $port[$count] . "-" . $span . "\" style=\"width:100px\" value=\"$channels\" readonly=\"readonly\" />";
					if ($this->ss7_voicelink == "yes")
					{
						if ($this->ss7_ccspans['channels'] != "")
						{
							$this->channels = $this->ss7_ccspans['channels'];
						}
						elseif ($this->line_type == "T1")
						{
							$this->channels = "1-24";
						}
						elseif ($this->line_type == "E1")
						{
							$this->channels = "1-31";
						}
						$port_type = "SS7 Voice Link";
					}
					else
					{
						$port_type = "SS7 Signalling Link";
						$this->channels = $this->ss7_ccspans['channels'];
					}
					//echo "\t\t\t\t\t\t<td><input type=\"text\" name=\"channel-map-" . $this->card_name . "-". $this->port_count . "-" . $this->card_num . "-" . $_SESSION['span_num'] . "\" style=\"text-align:right; width:90px\" value=\"" . $this->channels . "\" readonly=\"readonly\" /></td>\n";
					echo "\t\t\t\t\t\t<td align=\"center\">" . $this->channels . "</td>\n";
					//echo "\t\t\t\t\t\t<td align=\"center\"><input type=\"text\" name=\"cic-" . $this->card_name . "-". $this->port_count . "-" . $this->card_num . "-" . $_SESSION['span_num'] . "\" style=\"text-align:right; width:30px\" value=\"" . $this->ss7_ccspans['cic'] . "\" readonly=\"readonly\" /></td>\n";	
					echo "\t\t\t\t\t\t<td align=\"center\">" . $this->ss7_ccspans['cic'] . "</td>\n";
					//echo "\t\t\t\t\t\t<td align=\"center\"><input type=\"text\" name=\"group-" . $this->card_name . "-". $this->port_count . "-" . $this->card_num . "-" . $_SESSION['span_num'] . "\" style=\"text-align:right; width:30px\" value=\"" . $this->ss7_ccspans['group_num'] . "\" readonly=\"readonly\" /></td>\n";
					echo "\t\t\t\t\t\t<td align=\"center\">" . $this->ss7_ccspans['group_num'] . "</td>\n";
					echo "\t\t\t\t\t\t<td align=\"center\">" . $this->ss7_ccspans['isup'] . "</td>\n";											
					echo "\t\t\t\t\t</tr>\n";
					echo "\t\t\t\t</table>\n";
					echo "<td align=\"right\"><input type=\"submit\" name=\"config-ss7ccspan-" . $this->card_name . "-". $this->port_count . "-" . $this->card_num . "-" . $_SESSION['span_num'] . "-" . $this->proc_id . "\" value=\"Edit\" " . $_SESSION['button_class'] . "/></td>\n";			
					echo "\t\t\t</tr>\n";
					echo "\t\t</table>\n";
					
					//Final completion. Place in database and tell the page to display an anchor and the generate configuration button
					/*if ($this->proc_id == 1)
						$db_location = "sqlite:sqlite/cardinfo.db";	
					elseif ($this->proc_id > 1)
						$db_location = "sqlite:sqlite/cardinfo" . $this->proc_id . ".db";
					//$db_location = "sqlite:sqlite/cardinfo.db";
					$table = "finished_ports";
					$insert = "id, card, completed, type";
					//name_num_portnum
					//echo $this->span_counter;
					$_SESSION['span_counter']++;
					$insert_card = $this->token_card_name. "_" . $this->card_num . "_" . $this->port_count;				
					$where = "id = " . $_SESSION['span_counter'];
					//Check if the span number is taken. If so, update the table with the proper values
					$result = parent::select_statement($db_location,$table,"id",$where);

					if ($result['id'] == "")
					{	
						$insert_values = $_SESSION['span_counter'] . ", \"" . $insert_card . "\", \"yes\", \"$port_type\"";
						parent::insert_statement($db_location, $table, $insert, $insert_values);
						unset($insert_card);
					}
					else
					{
						parent::delete_generic($db_location, $table, $where);
						$insert_values = $_SESSION['span_counter'] . ", \"" . $insert_card . "\", \"yes\", \"$port_type\"";
						parent::insert_statement($db_location, $table, $insert, $insert_values);
					}*/
				}
			}
			else
			{	
				//CCSpan Error due to missing Linkset/Route/ISUP
				echo $view->ccspan_error;

				echo "\t\t\t<tr>\n";
				echo "\t\t\t\t<td><font color=\"red\"><b>Error: Please Configure a Linkset, Route and ISUP interface</b></td>";		
				echo "\t\t\t</tr>\n";
				echo "\t\t</table>\n";
			}
		}
		elseif ($this->ss7_mg_channels['profile_name'] != "" || $this->ss7_m2ua_link['voice_chans'] == "yes")
		{
			//Check if there are any media gateway profiles created. if not, generate an error.
			if ($this->mg_check()) {
				if ($this->ss7_m2ua_link['voice_chans'] == "yes" && $this->ss7_mg_channels['profile_name'] == "") {
						//MG Channels no configured
						echo $view->ccspan_notconfigured;
						
						echo "\t\t\t<tr>\n";
						echo "\t\t\t\t<td>\n";
						echo "<b>Channel Configuration: </b>";
						echo "</td>\n";
						echo "<td align=\"right\">\n";
						echo "<td align=\"right\"><input type=\"submit\" name=\"config-ss7mgchan-" . $this->card_name . "-". $this->port_count . "-" . $this->card_num . "-" . $_SESSION['span_num'] . "-" . $this->proc_id . "\" value=\"Edit\" " . $_SESSION['button_class'] . "/></td>\n";		
						echo "</td>\n";
						echo "\t\t\t</tr\">\n";
						echo "\t\t</table>\n";					
				}
				else {
					echo $view->ccspan_configured;	
					echo "\t\t\t<tr align=\"center\">\n";
					echo "\t\t\t\t<td>\n";
					echo "\t\t\t\t<table>\n";
					echo "\t\t\t\t\t<tr>\n";
					echo "\t\t\t\t\t\t<td align=\"center\"><b>MG Profile</b></td>\n";
					echo "\t\t\t\t\t\t<td align=\"center\"><b>Channel Map</b></td>\n";
					echo "\t\t\t\t\t\t<td align=\"center\"><b>Prefix</b></td>\n";
					echo "\t\t\t\t\t\t<td align=\"center\"><b>Base</b></td>\n";									
					echo "\t\t\t\t\t</tr>\n";
					echo "\t\t\t\t\t<tr>\n";	
					echo "\t\t\t\t\t\t<td align=\"center\">" . $this->ss7_mg_channels['mg_profile'] . "</td>\n";			
					echo "\t\t\t\t\t\t<td align=\"center\">" . $this->ss7_mg_channels['channel_map'] . "</td>\n";
					echo "\t\t\t\t\t\t<td align=\"center\">" . $this->ss7_mg_channels['prefix'] . "</td>\n";
					echo "\t\t\t\t\t\t<td align=\"center\">" . $this->ss7_mg_channels['base'] . "</td>\n";
					echo "\t\t\t\t\t</tr>\n";
					echo "\t\t\t\t</table>\n";
					echo "<td align=\"right\"><input type=\"submit\" name=\"config-ss7mgchan-" . $this->card_name . "-". $this->port_count . "-" . $this->card_num . "-" . $_SESSION['span_num'] . "-" . $this->proc_id . "\" value=\"Edit\" " . $_SESSION['button_class'] . "/></td>\n";			
					echo "\t\t\t</tr>\n";
					echo "\t\t</table>\n";								
					
					if ($this->ss7_m2ua_link['voice_chans'] == "yes")
						$port_type = "M2UA Signalling Gateway";
					else
						$port_type = "Media Gateway";

					//Final completion. Place in database and tell the page to display an anchor and the generate configuration button
					/*if ($this->proc_id == 1)
						$db_location = "sqlite:sqlite/cardinfo.db";	
					elseif ($this->proc_id > 1)
						$db_location = "sqlite:sqlite/cardinfo" . $this->proc_id . ".db";
					//$db_location = "sqlite:sqlite/cardinfo.db";
					
					$table = "finished_ports";
					$insert = "id, card, completed, type,mg_profile";
					//name_num_portnum
					//echo $this->span_counter;
					$_SESSION['span_counter']++;
					$insert_card = $this->token_card_name. "_" . $this->card_num . "_" . $this->port_count;				
					$where = "id = " . $_SESSION['span_counter'];
					//Check if the span number is taken. If so, update the table with the proper values
					$result = parent::select_statement($db_location,$table,"id",$where);
			
					if ($result['id'] == "")
					{	
						$insert_values = $_SESSION['span_counter'] . ", \"" . $insert_card . "\", \"yes\", \"$port_type\", \"" . $this->ss7_mg_channels['mg_profile']  . "\"";
						parent::insert_statement($db_location, $table, $insert, $insert_values);
						unset($insert_card);
					}
					else
					{
						parent::delete_generic($db_location, $table, $where);
						$insert_values = $_SESSION['span_counter'] . ", \"" . $insert_card . "\", \"yes\", \"$port_type\", \"" . $this->ss7_mg_channels['mg_profile']  . "\"";
						parent::insert_statement($db_location, $table, $insert, $insert_values);
					}*/			
				}
			}
			else {
				//MG Channels no configured, and no mg profiles configured
				echo $view->ccspan_notconfigured;
				
				echo "\t\t\t<tr>\n";
				echo "\t\t\t\t<td>\n";
				echo "<b><font color='red'>NO MEDIA GATEWAY PROFILES CREATED. PLEASE CREATE A MEDIA GATEWAY PROFILE TO PROCEED</font></b>";
				echo "</td>\n";
				echo "<td align=\"right\">\n";
				echo "<td align=\"right\"></td>\n";		
				echo "</td>\n";
				echo "\t\t\t</tr\">\n";
				echo "\t\t</table>\n";				
			}
		}
		else
		{
			//No CCSPANS Section yet
			echo $view->ccspan_notconfigured;
			echo "\t\t\t<tr>\n";
			echo "\t\t\t\t<td>\n";
			echo "</td>\n";
			echo "</tr>\n";
			echo "</table>\n";	
			
			if ($this->ss7_m2ua_link != "" && $this->ss7_m2ua_link['voice_chans'] == "no")
			{
				$port_type = "M2UA Signalling Gateway";
				//Final completion. Place in database and tell the page to display an anchor and the generate configuration button
				/*if ($this->proc_id == 1)
					$db_location = "sqlite:sqlite/cardinfo.db";	
				elseif ($this->proc_id > 1)
					$db_location = "sqlite:sqlite/cardinfo" . $this->proc_id . ".db";
				//$db_location = "sqlite:sqlite/cardinfo.db";
				$table = "finished_ports";
				$insert = "id, card, completed, type";
				//name_num_portnum
				//echo $this->span_counter;
				$_SESSION['span_counter']++;
				$insert_card = $this->token_card_name. "_" . $this->card_num . "_" . $this->port_count;				
				$where = "id = " . $_SESSION['span_counter'];
				//Check if the span number is taken. If so, update the table with the proper values
				$result = parent::select_statement($db_location,$table,"id",$where);
	
				if ($result['id'] == "")
				{	
					$insert_values = $_SESSION['span_counter'] . ", \"" . $insert_card . "\", \"yes\", \"$port_type\"";
					parent::insert_statement($db_location, $table, $insert, $insert_values);
					unset($insert_card);
				}
				else
				{
					parent::delete_generic($db_location, $table, $where);
					$insert_values = $_SESSION['span_counter'] . ", \"" . $insert_card . "\", \"yes\", \"$port_type\"";
					parent::insert_statement($db_location, $table, $insert, $insert_values);
				}*/				
			}
		}
		if ($this->ss7_ccspans['group_num'] > 1)
		{
			$_SESSION['group']++;
		}

	}
	
	
	//function that retrieves SS7 Linkset Information
	function get_linkset_list()
	{
		//Database related variables	
		
		$db_location = "sqlite:sqlite/cardinfo.db";
		$table_name = "ss7_linkset_profile";
		$a = 0;

		$select = "SELECT profile_name FROM " . $table_name . ";";
		
		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				//echo $row['profile_name'];
				$this->ss7_linksets[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}
		
		$this->counter_linkset = $a;
	}
	
	//Gets all the ISUP Interface names
	function get_isup_list()
	{		
		$db_location = "sqlite:sqlite/cardinfo.db";
		$table_name = "ss7_isup_profile";
		$a = 0;

		$select = "SELECT profile_name FROM " . $table_name . ";";
		
		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				//echo $row['profile_name'];
				$this->ss7_isups[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}
		
		$this->counter_isup = $a;		
	}
	
	//Gets all the Route Names
	function get_route_list()
	{	
		$db_location = "sqlite:sqlite/cardinfo.db";
		$table_name = "ss7_route_profile";
		$a = 0;

		$select = "SELECT profile_name FROM " . $table_name . ";";
		
		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				//echo $row['profile_name'];
				$this->ss7_routes[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}
		
		$this->counter_route = $a;		
	}

	//Grabs the chosen linkset from the database
	function get_chosen_linkset()
	{	
		if ($this->proc_id == 1)
		{
			$db_location = "sqlite:sqlite/cardinfo.db";	
		}
		elseif ($this->proc_id > 1)
		{
			$db_location = "sqlite:sqlite/cardinfo" . $this->proc_id . ".db";
		}	
		//echo $db_location;
		$where = "port_id = " . $this->port_count;
		$table_name = $this->token_card_name . "_" . $this->card_num . "_SS7_link";
		
		$this->ss7_linkset = parent::select_statement($db_location,$table_name, "linkset", $where);
	}
	
	function get_ccspans()
	{
		if ($this->proc_id == 1)
		{
			$db_location = "sqlite:sqlite/cardinfo.db";	
		}
		elseif ($this->proc_id > 1)
		{
			$db_location = "sqlite:sqlite/cardinfo" . $this->proc_id . ".db";
		}	
		
		//echo $this->card_num;
		unset($this->ss7_ccspans);
		$table_name = $this->token_card_name . "_" . $this->card_num . "_SS7_ccspans";
		$table_exist = parent::check_for_table($db_location,$table_name);
		
		if ($table_exist > 1)
		{
			$where = "port_id = " . $this->port_count;
			$param = "isup, cic, channels, group_num";
			$this->ss7_ccspans = parent::select_statement($db_location,$table_name, $param, $where);		
		}
	}
	
	function check_voicelink()
	{
		if ($this->proc_id == 1)
		{
			$db_location = "sqlite:sqlite/cardinfo.db";	
		}
		elseif ($this->proc_id > 1)
		{
			$db_location = "sqlite:sqlite/cardinfo" . $this->proc_id . ".db";
		}	
		
		$where = "port_id = " . $this->port_count;
		$table_name = $this->token_card_name . "_" . $this->card_num . "_SS7_link";
		
		$value = parent::select_statement($db_location,$table_name, "voice", $where);		
		
		$this->ss7_voicelink = $value['voice'];
		
	}
	
	function check_m2ualink()
	{
		if ($this->proc_id == 1)
		{
			$db_location = "sqlite:sqlite/cardinfo.db";	
		}
		elseif ($this->proc_id > 1)
		{
			$db_location = "sqlite:sqlite/cardinfo" . $this->proc_id . ".db";
		}	
		
		$where = "port_id = " . $this->port_count;
		$table_name = $this->token_card_name . "_" . $this->card_num . "_m2ua_link";
		
		$value = parent::select_statement($db_location,$table_name, "*", $where);		
		
		$this->ss7_m2ua_link = $value;
			
	}
	
	function check_mglink()
	{
		if ($this->proc_id == 1)
		{
			$db_location = "sqlite:sqlite/cardinfo.db";	
		}
		elseif ($this->proc_id > 1)
		{
			$db_location = "sqlite:sqlite/cardinfo" . $this->proc_id . ".db";
		}	
		
		$where = "port_id = " . $this->port_count;
		$table_name = $this->token_card_name . "_" . $this->card_num . "_m2ua_channels";
		
		$this->ss7_mg_channels = parent::select_statement($db_location,$table_name, "*", $where);		
	}
	
	private function mg_check() {
		$db_location = "sqlite:sqlite/cardinfo.db";
		$table_name = "mg_profiles";
		$a = 0;

		$select = "SELECT name FROM " . $table_name . ";";
		
		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
			if (!empty($result) ) {		
		    	foreach($result as $row)
		    	{
					//echo $row['profile_name'];
					$profile[$a] = $row;
					$a++;
				}
			}
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
			echo "DB = $db_location<br />";
			echo "Table = $table_name<br />";
			echo "SQL = $select<br />";
		}

		if ($a == 0) 
			return false;
		else
			return true;			
	}
	
	//Tokenizes the card name
	function token_cardname()
	{
		$tok = strtok($this->card_name, "-");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok= strtok(",");
			$count++;
		}
		
		$this->token_card_name = $token[0];
	}
}

?>