<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

function cfg_manager ($reset=NULL,$restore=NULL) {
	include_once 'database_classes.php';
	require_once 'display_class.php';
	require_once "production-test/prod-test-class.php";
	require_once 'generic_functions.php';
					
	//create the class
	$data = new database_class;
	$display_common = new Display_common;
	
	$relay_result = $data->select_statement('sqlite:sqlite/relay_info.db','ss7_relay','machine_type, relay_type','id=1');
	
	$notif = new NotificationBox( 'Info', NotificationBox::Info );
	if ($reset)
		$notif->add('Configuration','All gateway configuration has been reset');
	elseif ($restore)
		$notif->add('Configuration','All gateway configuration files have been restored to last generated values');
	
	if (!check_tdm_configured($data,'sqlite:sqlite/cardinfo.db')) {
		$notif->add("Configuration","In order to generate configuration, at least 1 TDM Span must be configured.");
	}	
		
	$notif->display();
	unset($notif);	
	?>
    	<br />
    	<form name='sng_config_manager'>
    <?php
	$out_of_sync = false;
	
	//Checks for completed ports on a standalone ss7 or multifunction gateway application
	if (strtolower($relay_result['relay_type']) == "slave")
	{
		//Configured as slave, cannot generate configuration
		$notif = new NotificationBox( 'Warnings', NotificationBox::Warning );
		$notif->add("Relay","System configured for SLAVE Relay. Please see Relay Master to generate TDM configuration" );
		$notif->display();
		unset($notif);
		echo "<br />";
	}
	
	$db_location = "sqlite:sqlite/cardinfo.db";
	$check = $data->check_for_table($db_location,'finished_ports');
	if ($check > 1)
	{
		$result = $data->select_statement($db_location, "finished_ports", "id", "");	

		if (count($result) > 1)
		{
			//Check wanrouter status
			exec ("/usr/sbin/wanrouter status | grep -c wanpipe",$output);
			if ($output[0] == "DISABLED" || $output[0] == "INVALID KEY" || $output[0] == 0) {
				if ( !isTdmConfigInSync($db_location) )
					$out_of_sync = true;
			}
			elseif ($output[0] > 0)
			{
				//Check if the gateway is started on each machine then check if each relay database is in sync
				$gateway_started = "yes";
				if ( !isTdmConfigInSync($db_location) )
					$out_of_sync = true;
			}
		}
	}

	$notif = new NotificationBox( 'Warnings', NotificationBox::Warning );

	// Check if TDM configuration is in sync
	if ($relay_result['machine_type'] == "standalone" || ($relay_result['machine_type'] == "relay" && $relay_result['relay_type'] == "MASTER"))	{
		if ( $out_of_sync)
		{
			if ( $slave_error > 0 )
			{
				$notif->add("TDM","Configuration out of sync." );
				$notif->add("TDM","Cannot generate configuration until all Relay Nodes active" );
			}
			elseif ($slave_error == 0 || $slave_error == "")
			{
				$notif->add("TDM","Configuration out of sync.");				

				if ( $gateway_started == "yes") {
					//check if there has been a span removed and gateway is started.
					$finished_boards = $data->array_select_statement('sqlite:sqlite/cardinfo.db','finished_ports','card, type','');
					$generated_boards = $data->array_select_statement('sqlite:sqlite/cardinfo.db','generated_ports','card, type','');
					foreach ($generated_boards as $gen_board) {
						$found = false;
						foreach ($finished_boards as $fin_board) {
							if ($fin_board['card'] == $gen_board['card']) {
								$found = true;
								break;
							}
						}
	
						if (!$found && $_SESSION['shortname'] == "NSG" && ($gen_board['type'] == "M2UA Signalling Gateway" || $gen_board['type'] == "Media Gateway")) {
							if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
								$notif->add("TDM",$gen_board['card'] . " has been removed. Please <a href='profile_panel.php' target='_parent'>Synchronize</a> configuration.");
							else
								$notif->add("TDM",$gen_board['card'] . " has been removed. Please <a href='/admin/ss7_profile_panel.php' target='_parent'>Synchronize</a> configuration.");
							$skip_out_of_sync = true;
						}
						elseif (!$found && $_SESSION['shortname'] == "NSG") {
							if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
								$notif->add("TDM",$gen_board['card'] . " has been removed. Please <a href='controls_embedded.php' target='_parent'>Stop the Gateway</a> in order to re-configure the span.");
							else
								$notif->add("TDM",$gen_board['card'] . " has been removed. Please <a href='/admin/ss7_controls.php' target='_parent'>Stop the Gateway</a> in order to re-configure the span.");
							$skip_out_of_sync = true;
						}
					}
	
					if (!$skip_out_of_sync) {
						$found = false;
						foreach ($finished_boards as $fin_board) {
							if ($fin_board['type'] != "Media Gateway" && $fin_board['type'] != "M2UA Signalling Gateway") {
								$found = true;
								break;
							}
						}
	
						if (!$found) {
							if(isMGConfigInSync($db_location)) {
								if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
									$notif->add("TDM","<a href='profile_panel.php' >Synchronize</a> configuration." );
								else
									$notif->add("TDM","<a href='/admin/ss7_profile_panel.php' target='_parent'>Synchronize</a> configuration." );
							}
						}else{
							if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
								$notif->add("TDM","<a href='controls_embedded.php' >Stop</a> the gateway" );
							else
								$notif->add("TDM","<a href='/admin/ss7_controls.php' target='_parent'>Stop</a> the gateway" );
						}
					}
				}
				$notif->add("TDM","Generate TDM configuration." );
				/*if ( $gateway_started == "yes" && $_SESSION['shortname'] == "NSG")
				{
					if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
						$notif->add("TDM","<a href='controls_embedded.php' >Stop</a> or <a href='profile_panel.php' >Synchronize</a> the gateway" );
					else
						$notif->add("TDM","<a href='/admin/ss7_controls.php' target='_parent'>Stop</a> or <a href='/admin/ss7_profile_panel.php' target='_parent'>Synchronize</a> the gateway" );
					$notif->add("TDM","Generate TDM configuration." );
				}
				elseif ($gateway_started == "yes" && $_SESSION['shortname'] == "NVG") {
					if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
						$notif->add("TDM","<a href='/admin/ss7_controls.php' target='_parent'>Stop</a> the gateway" );								
					else
						$notif->add("TDM","<a href='controls_embedded.php' >Stop</a> the gateway" );
				}*/				
			}
		}
		elseif ($gateway_started != "yes" && $slave_error == 0 && count($result) > 0)
		{
				if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
					$notif->add("TDM","Start the <a href='controls_embedded.php' >gateway</a>" );
				else
					$notif->add("TDM","Start the <a href='/admin/ss7_controls.php' target='_parent'>gateway</a>" );
		}
		elseif ($gateway_started != "yes" && $slave_error != 0)
			$notif->add("TDM","Cannot start the gateway until all Relay Nodes active" );
	}
	//Run Transcoding configuration check
	if (transcode_check($notif,$data))
		$out_of_sync = true;

	//Run Megaco configuration check
	if ($relay_result['machine_type'] == "standalone" || ($relay_result['machine_type'] == "relay" && $relay_result['relay_type'] == "MASTER"))	{
		if (mg_check($notif,$data))
			$out_of_sync = true;
	}

	
	if (!$out_of_sync) {
		$notif = new NotificationBox( 'Info', NotificationBox::Info );
		$notif->add('Configuration','Configuration up to date');
		if ($gateway_started == "yes") {
			if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
				$href= "<a href='controls_embedded.php' >Control Panel</a>";
			else
				$href = "<a href='/admin/ss7_controls.php' target='_parent'>Control Panel</a>";
				
			$notif->add('Configuration','If you need to regenerate your configuration, please go to the ' . $href . ' to stop the gateway.');
		}
		else {
			$notif->add('Configuration','If you need to regenerate your configuration, please click on <b>Generate Config</b>');		
		}
	}
	$notif->display();
	unset($notif);
	echo "<br />";

	$sctp_status = false;
	$sig_ip_status = false;
	$rtp_ip_status = false;
	check_ip_exist($data,'sqlite:sqlite/cardinfo.db',$sctp_status, $sig_ip_status, $rtp_ip_status);
	$notif = new NotificationBox( 'Warnings', NotificationBox::Warning );
	if (!$sctp_status)
		$notif->add('SCTP',	'One of your SCTP Profiles contains an invalid IP Address. Please adjust your SCTP Profiles');
	if (!$sig_ip_status)
		$notif->add('Media Gateway Profile','One of your Media Gateway profiles contains an invalid Signalling IP Address. Please adjust your Media Gateway Profiles');
	if (!$rtp_ip_status)
		$notif->add('Media Gateway Profile','One of your Media Gateway profiles contains an invalid RTP IP Address. Please adjust your Media Gateway Profiles');
	$notif->display();
	unset($notif);

	//echo "sctp status = $sctp_status, sip_ip status = $sig_ip_status, rtp_ip status = $rtp_ip_status<br />";

	echo "<br />";
	$mediaObj = new prod_test();
	$display_common->get_license_status($data,$mediaObj,$license_err, $channel_err, $trial_license_error);
	$mediaObj = NULL;	
	$notif = new NotificationBox( 'Warnings', NotificationBox::Warning );
	//echo $license_err . "<br />";
	if ( $license_err!= "" )
		$notif->add("License", $license_err);
	if ( $channel_err!= "" )
		$notif->add("Channels", $channel_err);
	if (isset($trial_license_error))
		 $notif->add("Timed Trial", $trial_license_error);
	$notif->display();
	unset($notif);

	echo "<table width=\"700px\">\n";
	echo "<tr>\n";

	if ($gateway_started != "yes" && $slave_error == 0 && $sctp_status && $sig_ip_status && $rtp_ip_status && check_tdm_configured($data,'sqlite:sqlite/cardinfo.db'))
		echo '<td align="left" width="1%"><input type="submit" name="generate" value="Generate Config" ' . $_SESSION['tc_button_class'] . ' /></td>';
	
	if ($relay_result['machine_type'] == "standalone")	{
		if ($slave_error == 0 && $sctp_status && $sig_ip_status && $rtp_ip_status && check_tdm_configured($data,'sqlite:sqlite/cardinfo.db')) {	
			if ($gateway_started == "yes")
				echo '<td align="left" width="1%"><input type="submit" name="install-restart" value="Generate and Restart Gateway" ' . $_SESSION['tc_button_class'] . ' /></td>';
			elseif ($gateway_started != "yes") 
				echo '<td align="left" width="1%"><input type="submit" name="install-start" value="Generate and Start Gateway" ' . $_SESSION['tc_button_class'] . ' /></td>';
		}
	}

	echo "<td align=\"right\">\n";
	echo "<input type=\"submit\" name=\"reset\" value=\"Reset Config\" " . $_SESSION['button_class'] . "/>\n";
	echo "<input type=\"submit\" name=\"restore\" value=\"Restore Config\" " . $_SESSION['button_class'] . "/>\n";				
	echo "</td>\n";		
		
	?>
	</table>
	</form>
	<?php
}

function transcode_check(&$notif,$data=NULL,$db=NULL)
{
	if (!isset($db))
		$db = 'sqlite:sqlite/cardinfo.db';
		
	//Check if sngtc is running
	exec ("pidof sngtc_server",$output);
	
	//Checks if transcoding is enabled or disabled
	$mediaObj = new prod_test();
	$mediaObj->find_mp_cards();
	$mediaCardCount = count($mediaObj->mp_cards);
	$mediaObj = NULL;
	
	//Check to make sure there is an entry in the database in order to generate configuration
	$table = "transcode";
	$param = "interface";

	if (!isset($db))
		$db='sqlite:sqlite/cardinfo.db';

	$check = $data->select_statement($db,$table, $param, "");
	
	// Check for transcoding configuration
	if ($mediaCardCount && !isMediaConfigInSync($db) )
	{
	  if ( $output[0] != "")
	  {
		  $notif->add('Media Processing','Configuration out of sync');
		  $notif->add('Media Processing','Media Processing Started. Please stop by navigating to the <a href="controls_embedded.php">Control Panel</a>');
		  return true;
	  }
	  else
	  {
		  $notif->add('Media Processing','Configuration out of sync.');
		  return true;
	  }
	}
	return false;
}


function mg_check(&$notif,$data=NULL,$db=NULL) 
{
	exec ("pidof nsg",$output);
	if (!isset($db))
		$db = 'sqlite:sqlite/cardinfo.db';
	
	if (!isMGConfigInSync($db))
	{
		if ($output[0] != "")
		{
			$notif->add('Media Gateway','Configuration out of sync');
			$notif->add('Media Gateway','Media Gateway Started. Please stop by navigating to the <a href="controls_embedded.php">Control Panel</a>');			
			return true;
		}
		else
		{
			$notif->add('Media Gateway','Configuration out of sync.');
			return true;
		}
		
	}
	return false;
}


function cfg_display_files($tdm_config,$tokenization,$data,$restart) {
		//Generates all configuration	
		
		//Pull Relay Configuration to check what will be generated
		$relay = $data->select_statement("sqlite:sqlite/relay_info.db", "ss7_relay","machine_type, relay_type", 'id=1');
		
		if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded'])) {
			ob_implicit_flush(true);
			echo "<div id='notif_div' style='display:block;'>";
			$html .= "  <table class='mytable ui-state-error;' border='0' width='100%' style='background-color:#E6E6E6;'>\n";
			$html .= "    <tr>\n";
			$html .= "      <td>\n";
			$html .= "      <b>\n";
			$html .= "<img src='resources/icon-loading.gif'>";
			$html .= "      </b>\n";
			$html .= "      <td>\n";
			$html .= "<b>Generating Configuration</b>";
			$html .= "      </td>\n";
			$html .= "      </td>\n";
			$html .= "    </tr>\n";
			$html .= "  </table>\n";
			echo $html;
			echo "</div>";
		}
		?>
		<br />
		<table class="mytable" width='700px'>
        	<th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Configuration Generation</th>
      	<?php	
		if ($restart == "stop" || $restart == "restart") {
				//Restart the gateway
				if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded'])) {
						ob_end_flush();
						flush();
				}
				//stop wanrouter
				//stop nsg
        ?>
            <tr>
                <td bgcolor="<?=COLOR_ROW_EVEN?>"> Stopping the Gateway</td>
                </tr>
        <?php
			exec ('/etc/init.d/'.$_SESSION['gateway_script'] . ' stop',$output);
			sleep(1);
			exec ('/usr/bin/pkill -9 wanpipemon', $output);
			exec ('/usr/sbin/wanrouter stop',$output);
			exec ('/usr/sbin/wanrouter stop',$output);
	
	
			if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded'])) {
					ob_end_flush();
					flush();
			}

		}

		if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded'])) {
			ob_flush();
			flush();
			sleep(3);
		}
		
		//Only generate tdm configuration if relay master or standalone machine
		if ($relay['machine_type'] == "standalone" || ($relay['machine_type'] == "relay" && $relay['relay_type'] == "MASTER")) {
		?>     
            <tr bgcolor="<?=COLOR_ROW_ODD?>">		
            	<td> Generating wanpipe configuration files </td>
			</tr>
			<tr bgcolor="<?=COLOR_ROW_EVEN?>">
				<td> Generating freetdm.conf</td>
            </tr>
            <tr bgcolor="<?=COLOR_ROW_ODD?>">
            	<td> Generating freetdm.conf.xml</td>
            </tr>   
		<?php
			if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded'])) {
				ob_flush();
				flush();
				sleep(2);
			}
			//TDM Configuration
			$tdm_config->redirect($_REQUEST,$data,$tokenization);	
			$dir = $_SESSION['smg_root_path'] . "/nginx/html/php/";
			chdir($dir);
		}
		if ($relay['machine_type'] == "standalone") {
			?>
				<tr>
					<td bgcolor="<?=COLOR_ROW_EVEN?>"> Generating mod_media_gateway.conf.xml</td>     
				</tr>  
				  
			<?php
			if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded'])) {
				ob_end_flush();
				flush();
			}
			//Megaco Configuration	
			save_mg_tables($data);
			xml_gen($data);
		}

		//Turn on nsg
		$cmd = '/sbin/chkconfig ' . $_SESSION['gateway_script'] . ' on';	
		exec ($cmd);
		exec ('/sbin/chkconfig wanrouter on');
				
		//Media Processiong Configuration	
		generate_mp_files($data, $relay['machine_type'], $relay['relay_type']);
		
		if ($restart == "start" || $restart == "restart") {
			//start wanrouter
			//start nsg
			//Restart the gateway
			if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded'])) {
					ob_end_flush();
					flush();
					sleep(1);
			}

		?>
            <tr>
                <td bgcolor="<?=COLOR_ROW_ODD?>">Starting the Gateway</td>
                </tr>

		<?php
				shell_exec ('/usr/sbin/wanrouter start');
				sleep(5);
				shell_exec ('/etc/init.d/' . $_SESSION['gateway_script'] . ' start > /dev/null 2>/dev/null');
				sleep(5);
				if (trim(shell_exec('pidof ' . $_SESSION['gateway_script'])) == "") {
		?>
            <tr>
                <td bgcolor="<?=COLOR_ROW_EVEN?>">Failed to start the gateway!</td>
                </tr>
		<?php
		}

		}

		?>
			<th class='widget-content-header ui-state-active ui-corner-bottom' />            
        </table>
        <br />
        <?php
		if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded'])) {
			ob_flush();
			flush();
			sleep(2);	
		}
		$notif = new NotificationBox( 'info', NotificationBox::Info );
		$notif->add('Configuration','Gateway Configuration Files Generated.');
		if ($restart == "") {
			if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
				$notif->add('Configuration','Please proceed to the <a href="controls_embedded.php">Control Panel</a>');
			else
				$notif->add('Configuration','Please proceed to the <a href="/admin/ss7_controls.php" target="_parent">Control Panel</a>');
		}
		$notif->display();
		unset($notif);
			
}


function generate_mp_files($data) {
	$transcode = new transcoding_class;
	$transcode->data = $data;
	$transcode->db_location = 'sqlite:sqlite/cardinfo.db';
		
	//Auto populate db
	$transcode->get_info();
	$transcode->get_codecs($db='sqlite:sqlite/smg_data.db');
	$transcode->auto_populate();

	//Check if transcoding table and codecs table populated. If so, change mod_sangaom_codec into enabled.
	//If not, disable it.
	$transcoding = $data->array_select_statement($transcode->db_location,'transcode','*','');
	$codecs = $data->select_statement($transcode->db_location,'transcode_user_codecs','*','id=1');

	$file = $_SESSION['smg_root_path'] . "/conf/autoload_configs/modules.conf.xml";
	$file_open = file_get_contents($file);
	if (empty($transcoding)) {
			$file_open = preg_replace ('/.*mod_sangoma_codec.*/', '   <!--  <load module="mod_sangoma_codec" /> -->',$file_open);
			file_put_contents($file,$file_open);
	}
	else {
			$file_open = file_get_contents($file);
				$file_open = preg_replace ('/.*mod_sangoma_codec.*/', '    <load module="mod_sangoma_codec" />',$file_open);
				file_put_contents($file,$file_open);
	
		//Generate ifcfg files
	?>
			<tr bgcolor="<?=COLOR_ROW_ODD?>">
				<td>Generating ifcfg files</td>
			</tr>
	
		<?php
		ob_end_flush();
		flush();
		$transcode->ifcfg();
		//Determine number of entries in the database
		$transcode->num_entries('sqlite:sqlite/cardinfo.db');
	?>
			<tr bgcolor="<?=COLOR_ROW_EVEN?>">
				<td>Generating sangoma_codec.conf.xml</td>
			</tr>
	
	<?php
		ob_end_flush();
		flush();
		//Create sangoma_codec.conf.xml
		$transcode->sangoma_codec();	
	?>
			<tr bgcolor="<?=COLOR_ROW_ODD?>">
				<td>Generating sngtc_server.conf.xml</td>
			</tr>    
	<?php
		ob_end_flush();
		flush();
		//Create /etc/sngtc/sngtc_server.conf 
		$transcode->sngtc_server('sqlite:sqlite/cardinfo.db');
	}

	//Turn on sngtc
	$cmd = '/sbin/chkconfig sngtc_server_ctrl on';	
	exec ($cmd);	
	
	//Append db
	$transcoder_session = 'single';
	$table_name = "transcode_setup";
	$where = "id = 1";
	$return = $transcode->data->select_statement($transcode->db_location, $table_name, "setup", $where);

	if ($return['setup'] != "")
	{
		//update the table
		$update_param = "setup = \"" . $transcoder_session . "\"";
		$transcode->data->update_table($transcode->db_location, $table_name, $update_param, $where);
	}
	elseif ($return['setup'] == "")
	{
		//insert new data
		$insert_param = "id, setup";
		$insert_values = "1, \"" . $transcoder_session . "\"";
		$transcode->data->insert_statement($transcode->db_location, $table_name, $insert_param, $insert_values);
	}	
	
	if ($transcode->data->check_for_table ($transcode->db_location, "perm_transcode_setup") > 0)
		$transcode->data->drop_table($transcode->db_location, "perm_transcode_setup");
	$transcode->data->select_into ($transcode->db_location, "transcode_setup", "*", "perm_transcode_setup");
	
	//Create the generated transcoding interface table
	//Drop the generate table then re-create the generate table
	
	if ($transcode->data->check_for_table ($transcode->db_location, "perm_transcode") > 0)
		$transcode->data->drop_table($transcode->db_location, "perm_transcode");
	$transcode->data->select_into ($transcode->db_location, "transcode", "*", "perm_transcode");

	if ($transcode->data->check_for_table ($transcode->db_location, "perm_transcode_setup") > 0)
		$transcode->data->drop_table($transcode->db_location, "perm_transcode_setup");
	$transcode->data->select_into ($transcode->db_location, "transcode_setup", "*", "perm_transcode_setup");
	
	if ($transcode->data->check_for_table ($transcode->db_location, "perm_transcode_user_codecs") > 0)
		$transcode->data->drop_table($transcode->db_location, "perm_transcode_user_codecs");
	$transcode->data->select_into ($transcode->db_location, "transcode_user_codecs", "*", "perm_transcode_user_codecs");

	if ($transcode->data->check_for_table ($transcode->db_location, "perm_transcode_bind") > 0)
		$transcode->data->drop_table($transcode->db_location, "perm_transcode_bind");
	$transcode->data->select_into ($transcode->db_location, "transcode_bind", "*", "perm_transcode_bind");

}

/**
*	restores media processing tables from permanent tables
*
*	@param data
*		database object
*/
function restore_mp_tables($data) {
	
	$db="sqlite:sqlite/cardinfo.db";
	
	if ($data->check_for_table($db,'transcode') > 1)
		$data->drop_table($db,'transcode');
	$data->select_into ($db,'perm_transcode','*','transcode');
	
	if ($data->check_for_table($db,'transcode_setup') > 1)
		$data->drop_table($db,'transcode_setup');
	$data->select_into ($db,'perm_transcode_setup','*','transcode_setup');

	if ($data->check_for_table($db,'transcode_user_codecs') > 1)
		$data->drop_table($db,'transcode_user_codecs');
	$data->select_into ($db,'perm_transcode_user_codecs','*','transcode_user_codecs');

	if ($data->check_for_table($db,'transcode_bind') > 1)
		$data->drop_table($db,'transcode_bind');
	$data->select_into ($db,'perm_transcode_bind','*','transcode_bind');
}

/**
*	resets media processing tables
*
*	@param data
*		database object
*/
function reset_mp_tables($data) {
	
	$db="sqlite:sqlite/cardinfo.db";
	
	
	//Creates the transcoding table
	if ($data->check_for_table($db,'transcode') > 1)
		$data->drop_table($db,'transcode');	
	$table_name = "transcode";
	$parameters = "id int primary key, interface varchar(30), ip_address varchar(30), net_mask varchar(30), mac_addr varchar(30), num_modules int, nibble varchar(30)";
	$data->create_table($db, $table_name, $parameters);	
	
	//Creates the transcoding codec	table. This is the table which the users chosen codecs get placed
	if ($data->check_for_table($db,'transcode_user_codecs') > 1)
		$data->drop_table($db,'transcode_user_codecs');
	$table_name = "transcode_user_codecs";
	$parameters = "id int primary key, codec_syntax varchar(30)";
	$data->create_table($db, $table_name, $parameters);	
	
	//Creates the transcoding setup database
	if ($data->check_for_table($db,'transcode_setup') > 1)
		$data->drop_table($db,'transcode_setup');
	$table_name = "transcode_setup";
	$parameters = "id int primary key, setup varchar(20)";
	$data->create_table($db, $table_name, $parameters);				

	//Creates the transcoding codec	table. This is the table which the users chosen codecs get placed
	if ($data->check_for_table($db,'transcode_bind') > 1)
		$data->drop_table($db,'transcode_bind');
	$table_name = "transcode_bind";
	$parameters = "id int primary key, bind_addr varchar(30), bind_port varchar(30)";
	$data->create_table($db, $table_name, $parameters);	
}


?>
