<?php
/*
	SMG WebGUI
	Version: 1.1

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class BRI_SMG
{
	//Class Private Variables
	private $context = "";				//woomera context
	private $group = "";				//chan_dahdi group number
	private $span = "";					//smg_bri.conf span number
	private $card_name = "";			//Gets the card name
	private $card_number = "";			//The Card number from the card_present table
	private $port_num = "";				//Port Number being writen
	private $slot = "";					//PCI Slot number
	private $bus = ""; 					//PCI Bus number
	

	//Function that populates the dahdi variables
	function populate($card, $card_number, $span_num, $port_num, $data)
	{	
		$this->port_num = $port_num;		
		$this->span = $span_num;
		$this->card_name = $card;
		$this->card_number = $card_number;
		
		//Database information
		$card_format = "AFT-" . $this->card_name . "-SH-" . $card_number;
		$db_location = "sqlite:sqlite/cardinfo.db";

		//Retrieve Card Information		
		$table_name = "card_present";
		$param = "pci_slot, pci_bus";
		$where_param = "id = \"" . $card_number . "\"";
		$card_info = $data->select_statement ($db_location, $table_name, $param, $where_param);
		
		$this->slot = $card_info['pci_slot'];
		$this->bus = $card_info['pci_bus'];
		
		//Get the context from the signalling database
		$table_name = $card . "_" . $card_number . "_signalling";
		$param = "profile_name, conn_type, interface, tei, group_num, context";
		$where_param = "id = $port_num";
		$sig_info = $data->select_statement ($db_location, $table_name, $param, $where_param);	
		
		$this->context = $sig_info['context'];
		$this->group = $sig_info['group_num'];
		
		//Analyze the way signalling comes in and adjust accordingly for chan_dahdi.conf
		if ($sig_info['conn_type'] == "NT")
		{
			$this->conn_type = $sig_info['conn_type'];
			$this->signalling = "bri_nt";	
		}
		elseif ($sig_info['conn_type'] == "TE")
		{
			$this->conn_type = $sig_info['conn_type'];
			$this->signalling = "bri_te";
		}
		
		if ($sig_info['interface'] == "ptp")
		{
			$this->interface = "point_to_point";
		}
		elseif ($sig_info['interface'] == "ptmp")
		{
			$this->interface = "point_to_multipoint";
		}
	}	
	
	//Values for smg_bri.conf
	function smg_bri()
	{
		$file_name = "smg_ctrl/smg_bri.conf";		
		
		$filehandle = fopen($file_name, 'a') or die("can't open file");		
		
		$bri =  "\n;Sangoma AFT-" . $this->card_name . " port " . $this->port_num . " [slot:" . $this->slot . " bus:" . $this->bus . " span:" . $this->span . "]\ngroup=" . $this->group . "\ncountry=europe\noperator=etsi\nconnection_type=" . $this->interface . "\nsignalling=" . $this->signalling . "\nspans=" . $this->span . "\n";

		fwrite($filehandle, $bri);
		fclose($filehandle);
	}
	
	//woomera.conf
	function woomera()
	{
		$file_name = "smg_ctrl/woomera.conf";		
		
		$filehandle = fopen($file_name, 'a') or die("can't open file");		
		
		$bri =  "
context = " . $this->context . "
group=" . $this->group . "
";

		fwrite($filehandle, $bri);
		fclose($filehandle);
		
	}

	//appends the wanpipe startup scripts if both bri and dahdi devices are used
	function append_start_script()
	{
		$file_name = "/etc/wanpipe/scripts/start";		
		
		$filehandle = fopen($file_name, 'a') or die("can't open file");		
		
		$bri = "cnt=0\nmax_delay=30\nfor ((i=0;i<\$max_delay;i++))\ndo\n	if [ -e /dev/wanpipe ]; then\n        	break;\n	fi\n\n	echo \"Waiting for TDM API device /dev/wanpipe ($i/$max_delay)...\"\n  	sleep 2\ndone\n\nif [ ! -e /dev/wanpipe ]; then\n	echo\n	echo \"Error: Sangoma TDM API device failed to come up\";\n        echo \"Possible Cause: UDEV not installed!\";\n	echo\n	exit 1\nfi \n\nsleep 1\n\nsmg_ctrl start\n\n";

		fwrite($filehandle, $bri);
		fclose($filehandle);		
	}
	
}
?>
