<?php
header('Content-type: text/xml');
$xml = <<<XML
<configuration name="freetdm.conf" description="FreeTDM Configuration">
<signaling_configs>
<sngss7_configs>
<mtp1_links>
<mtp1_link name="mtp1-1">
<param name="id" value="1"/>
<param name="span" value="1"/>
<param name="chan" value="16"/>
</mtp1_link>
</mtp1_links>
</sngss7_configs>
</signaling_configs>
</configuration>

XML;

/**
Add New xml elements to an existing tree
*/

$sxe = new SimpleXMLElement($xml);
$new_book = $sxe->signaling_configs->sngss7_configs->mtp1_links->addChild('mtp1_link');
$new_book->addAttribute('name','mtp1-2');
$p1 = $new_book->addChild('param');
$p1->addAttribute('name','id');
$p1->addAttribute('value',2);
$p1 = $new_book->addChild('param');
$p1->addAttribute('name','span');
$p1->addAttribute('value',2);
$p1 = $new_book->addChild('param');
$p1->addAttribute('name','chan');
$p1->addAttribute('value',1);

$new_book = $sxe->signaling_configs->sngss7_configs->mtp1_links->addChild('mtp1_link');
$new_book->addAttribute('name','mtp1-3');
$p1 = $new_book->addChild('param');
$p1->addAttribute('name','id');
$p1->addAttribute('value',3);
$p1 = $new_book->addChild('param');
$p1->addAttribute('name','span');
$p1->addAttribute('value',3);
$p1 = $new_book->addChild('param');
$p1->addAttribute('name','chan');
$p1->addAttribute('value',1);


/*
XPath

Retrieve all mtp1 links

//mtp1_link
//mtp1_link[0]
(//mtp1_link)[0]

/configuration/signalling_configs/sngss7_configs/mtp1_links/mtp1_link[name="mtp1-1"]

//mtp1_link[name="mtp1-1"]
*/

$obj = $sxe->xpath('/configuration/signaling_configs/sngss7_configs/mtp1_links/mtp1_link[@name="mtp1-1"]');
$obj[0]->param[1]->attributes()->value='2';
$obj[0]->param[2]->attributes()->value='14';


/**
Delete node out of xml
*/
foreach ($sxe->xpath('/configuration/signaling_configs/sngss7_configs/mtp1_links/mtp1_link') as $mtp) {
	if ($mtp[0]->attributes()->name == "mtp1-1") {
		unset($mtp[0]);
	}
}


echo $sxe->asXML();

?>