#!/bin/bash

#This app checks the firmware version of the card name provided. It returns the highest firmware file found on the system

usage() 
{ 
	echo "USAGE: $0 CARDNAME" 
}

if [ $# -ne 1 ]; then
	usage
	exit 1
else
	#Command to check firmware files
	CARD=$1

	ls /etc/wanpipe/util/wan_aftup | grep $CARD | cut -f3 -d"_"| cut -f1 -d"." | sed "s/^V//" | sort -n -r
fi
