<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class questionnaire
{
	//Class variables
	public $upload_error = "";					//Contains the error message for uploading a file
	private $error_radio = "";					//Contains the error message when radio buttons are not selected
	
	//Status bar displayed at top of the screen to show relay configuration status
	function status_bar($error_counter,$error_counter2,$error_counter3)
	{
		if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
		{
			echo "<h3>" . $_SESSION['name'] . " Setup</h3>\n";
		}
		$selected_style = "background: none repeat scroll 0 0 #80B0D6;font-family: Arial,Helvetica,sans serif;font-size:8pt;font-weight:bold;";		
		?>
        
        <table width='700px' border='1' bgcolor="<?php echo COLOR_TABLE_BG; ?>" style="border:2px;">
        	<tr>
        <?php
		if ($error_counter != 0 || (!$_REQUEST['Step2'] && !$_REQUEST['Step3'] && !$_REQUEST['back_step2']) || $_REQUEST['back_step1'] == "Back")
		{
			//echo "<td align='center' width='33%' bgcolor='" . COLOR_TABLE_NON_SELECTED . "'><font color='black'><b>Step 1<br />" . $_SESSION['shortname'] . " Setup</b></font></td>\n";
			echo "<td align='center' width='33%' style='" . $selected_style . "'><font color='black'><b>Step 1<br />" . $_SESSION['shortname'] . " Setup</b></font></td>\n";
		}
		else
		{
			echo "<td align='center' width='33%' style='font-family: Arial,Helvetica,sans serif;font-size:8pt;'><font color='black'>Step 1<br />" . $_SESSION['shortname'] . " Setup</font></td>\n";
		}
		
		if ($error_counter2 != 0 || $error_counter == 0 && $_REQUEST['Step2'] == "Next Step" || $_REQUEST['back_step2'] == "Back")
		{
			//echo "<td align='center' width='33%' bgcolor='" . COLOR_TABLE_NON_SELECTED . "'><font color='black'><b>Step 2<br />Relay Configuration</b></font></td>\n";
			echo "<td align='center' width='33%' style='" . $selected_style . "'><font color='black'><b>Step 2<br />Relay Configuration</b></font></td>\n";
		}
		else
		{
        	echo "<td align='center' width='33%' style='font-family: Arial,Helvetica,sans serif;font-size:8pt;'><font color='black'>Step 2<br />Relay Configuration</font></td>\n";
		}
		
		if ($error_counter3 != 0 ||$error_counter2 == 0 && $_REQUEST['Step3'] == "Next Step")
		{
			//echo "<td align='center' width='33%' bgcolor='" . COLOR_TABLE_NON_SELECTED . "'><font color='black'><b>Step 3<br />SSH Configuration</b></font></td>\n";
			echo "<td align='center' width='33%' style='" . $selected_style . "'><font color='black'><b>Step 3<br />SSH Configuration</b></font></td>\n";
		}
		else
		{
         	echo "<td align='center' width='33%' style='font-family: Arial,Helvetica,sans serif;font-size:8pt;'><font color='black'>Step 3<br />SSH Configuration</font></td>\n";
		}
		?>
            </tr>
        </table>

        <?php		
	}
	
	//Initial view of the questionnaire
	function initial_quesiton($data)
	{
		//Check if an entry exists. If it doesn't, disable the cancel button	
		$table = $data->check_for_table(DB_LOCATION,'ss7_relay');
		
		if ($table > 1)
		{
			$result = $data->select_statement(DB_LOCATION,RELAY_TABLE,'machine_type','id = 1');
			
			if ($result['machine_type'] == "")
			{
				$disabled = $_SESSION['disabled_button_class'] . "disabled='disabled'";
			}
			elseif ($result['machine_type'] != "")
			{
				if ($result['machine_type'] == "standalone")
				{
					$standalone = "checked='checked'";
				}
				elseif ($result['machine_type'] == "relay")
				{
					$relay_choice = "checked='checked'";
				}
				$disabled = "class=\"ui-state-default ui-corner-all\"";
			}
		}
		elseif ($table < 2)
		{
			$disabled = $_SESSION['disabled_button_class'] . "disabled='disabled'";
		}
		
		?>
        <br />
        <div id='notification' style="display:none;">
        <?php
			require_once '../display_class.php';
			$notif = new NotificationBox( 'Warnings', NotificationBox::Warning );
			$notif->add('Configuration','A change in relay configuration will result a reset of TDM Configuration.');
			$notif->display();
			unset($notif);		
		?>
        </div>
        <br />
        <form method='post' action=''>
            <table class='mytable' width='500px'>
                <th class='widget-content-header ui-state-active ui-corner-top' align='left' colspan='7'>Step 1: NSG Setup</th>
                <tr>
                    <td class='mytableheader ui-state-active' width='60%'>Will this system be part of a Relay Setup?</td>
                    <td>
                        <input type='radio' name='option' id='ss7_type' value='yes' <?php echo $relay_choice; ?>/>YES<br />
                        <input type='radio' name='option' id='ss7_type' value='no'<?php echo $standalone; ?> />NO
                    </td>
                </tr>
                <th align='left' class='widget-content-header ui-state-active ui-corner-bottom' colspan='7'></th>
            </table>
            <br /><?php echo $this->error_radio . "<br />"; ?>
            <table width='500px'>
            	<tr>
            		<td width='1%'><input type='submit' name='Step2' value='Next Step' <?php echo $_SESSION['button_class']; ?>/></td>
					<td width='1%' align='right'><input type='submit' name='cancel' value='Cancel' <?php echo $disabled; ?>/></td>
                </tr>
            </table>
        </form>
        <?php
	}
	
	//step 2
	function step2_question($data)
	{
		//Check if an entry exists. If it doesn't, disable the cancel button	
		$table = $data->check_for_table(DB_LOCATION,'ss7_relay');
		
		if ($table > 1)
		{
			$result = $data->select_statement(DB_LOCATION,RELAY_TABLE,'relay_type','id = 1');
			
			if ($result['relay_type'] == "")
			{
				$disabled = $_SESSION['disabled_button_class'] . "disabled='disabled'";
			}
			elseif ($result['relay_type'] != "")
			{
				if ($result['relay_type'] == "MASTER")
				{
					$master = "checked='checked'";
				}
				elseif ($result['relay_type'] == "SLAVE")
				{
					$slave = "checked='checked'";
				}
				$disabled = "class=\"ui-state-default ui-corner-all\"";
			}
		}
		elseif ($table < 2)
		{
			$disabled = $_SESSION['disabled_button_class'] . "disabled='disabled'";
		}		
		?>
        <br /><br />
        <form method='post' action=''>
            <table class='mytable' width='500px'>
                <th class='widget-content-header ui-state-active ui-corner-top' align='left' colspan='7'>Step 2: Relay Configuration</th>
                <tr>
                    <td class='mytableheader ui-state-active' width='60%'>Will this Relay Machine be a Master or Slave?</td>
                    <td>
                        <input type='radio' name='option' value='MASTER' <?php echo $master; ?>/>MASTER<br />
                        <input type='radio' name='option' value='SLAVE' <?php echo $slave; ?>/>SLAVE
                    </td>
                </tr>
                <th align='left' class='widget-content-header ui-state-active ui-corner-bottom' colspan='7'></th>
            </table>
            <br /><?php echo $this->error_radio . "<br />"; ?>
            <table width='500px'>
            	<tr>
            		<td width='100px'>
                        <input type='submit' name='back_step1' value='Back' <?php echo $_SESSION['button_class']; ?> />                    
                    	<input type='submit' name='Step3' value='Next Step' <?php echo $_SESSION['button_class']; ?>/></td>
					<td width='1%' align='right'><input type='submit' name='cancel' value='Cancel' <?php echo $disabled; ?>/></td>
                </tr>
            </table>
        </form>
        <?php		
	}
	
	
	//step 3 Master
	function step3_master_question($data)
	{
		?>
        <br /><br />
        <form method='post' action=''>
            <table class='mytable' width='500px'>
                <th class='widget-content-header ui-state-active ui-corner-top' align='left' colspan='7'>Step 3: Generate SSH Keys</th>
                <tr>
                    <td class='mytableheader ui-state-active' width='40%'>Generate your SSH Keys</td>
                    <td align='right'>
                        <input type='submit' name='generate' value='Generate SSH Key' <?php echo $_SESSION['button_class']; ?> />
                    </td>
                </tr>
                <th align='left' class='widget-content-header ui-state-active ui-corner-bottom' colspan='7'></th>
            </table>
            <br />
            <table width='500px'>
            	<tr>
     				<td width='100px'>
                        <input type='submit' name='back_step2' value='Back' <?php echo $_SESSION['button_class']; ?> />
                        <input type='submit' name='skip' value='Skip' <?php echo $_SESSION['button_class']; ?>/>
                    </td>
					<td width='1%' align='right'><input type='submit' name='cancel' value='Cancel' <?php echo $_SESSION['button_class']; ?>/></td>
                </tr>
            </table>
        </form>
        <?php		
	}
	
	
	//step 3 Slave
	function step3_slave_question()
	{
		?>
        <br /><br />
       <FORM ENCTYPE="multipart/form-data" ACTION="" METHOD=POST>
            <table class='mytable' width='500px'>
                <th class='widget-content-header ui-state-active ui-corner-top' align='left' colspan='7'>Step 3: Upload SSH Public Key</th>
                <tr>
                    <td class='mytableheader ui-state-active' width='40%'>Upload Master SSH Key </td>
                    <td align='right'>
						 <INPUT NAME="userfile" TYPE="file" width='200px'/>
                    </td>
                </tr>
                <th align='left' class='widget-content-header ui-state-active ui-corner-bottom' colspan='7'></th>
            </table>
            <br />
            <?php echo $this->upload_error . "<br />"; ?>
            <table width='500px'>
            	<tr>
                	<td width='100px'>
                        <input type='submit' name='back_step2' value='Back' <?php echo $_SESSION['button_class']; ?> />
                        <INPUT TYPE="submit" name="upload_key" VALUE="Upload Key" <?php echo $_SESSION['button_class']; ?> />
                        <input type='submit' name='skip' value='Skip' <?php echo $_SESSION['button_class']; ?>/>
                    </td>
					<td width='10px' align='right'><input type='submit' name='cancel' value='Cancel' <?php echo $_SESSION['button_class']; ?>/></td>
                </tr>
            </table>
        </FORM>
        <?php		
	}	
	
	//Generates a new SSH key
	function generate_ssh_key($data)
	{
		//Generate the SSH Keys
		$cmd = 'ssh-keygen -q -t rsa -f nsg_rsa -N ""';
		$output = shell_exec ($cmd);
		
		//Check if /root/.ssh exists
		if (!file_exists('/root/.ssh'))
		{
			mkdir('/root/.ssh',0644);
		}
		
		
		//Place keys in /root/.ssh directory so that the user can check for ssh status
		$cmd = "cp nsg_rsa /root/.ssh/";
		shell_exec ($cmd);
		
		$cmd = "cp nsg_rsa.pub /root/.ssh/";
		shell_exec ($cmd);
		
		//Update the database that the key was generated
		$parameters = "ssh_key_status = \"generated\"";
		$where_param = "id = 1";
		$data->update_table (DB_LOCATION, RELAY_TABLE, $parameters, $where_param);	
	}
	
	
	//Uploads public key to slave relay host
	function upload_pub_key($data)
	{
		$parts = explode('.', $_FILES['userfile']['name']);
		//echo $_FILES['userfile']['name'];
		if($parts[(count($parts)-1)] == 'pub')
		{
			// Continue
			if ($_FILES["userfile"]["size"] < 50000)
			{
				if ($_FILES["userfile"]["error"] > 0)
				{
					 $this->upload_error= "<font color='COLOR_ERROR'><b>Return Code: " . $_FILES["userfile"]["error"] . "</b></font>";
				}
				else
				{
					/*echo "Upload: " . $_FILES["userfile"]["name"] . "<br />";
					echo "Type: " . $_FILES["userfile"]["type"] . "<br />";
					echo "Size: " . ($_FILES["userfile"]["size"] / 1024) . " Kb<br />";
					echo "Temp file: " . $_FILES["userfile"]["tmp_name"] . "<br />";*/
			
					//if (file_exists(UPLOAD_LOCATION . "/" . $_FILES["userfile"]["name"]))
					//{
					//	echo $_FILES["userfile"]["name"] . " already exists. ";
					//}
					//else
					//{
						//Check if the .ssh folder exists
						if (!file_exists('/root/.ssh'))
						{
							mkdir("/root/.ssh",0644);
						}
						
						move_uploaded_file($_FILES["userfile"]["tmp_name"], UPLOAD_LOCATION . "/" . $_FILES["userfile"]["name"]);
						//echo "Stored in: " . UPLOAD_LOCATION . $_FILES["userfile"]["name"];
					//}
				}
			}
			else
			{
				$this->upload_error= "<font color='COLOR_ERROR'><b>ERROR:Invalid Upload Size. SSH Public Key must be less then 5KB</b></font>";
			}
		}
		else
		{
			$this->upload_error= "<font color='COLOR_ERROR'><b>ERROR:Invalid file type. Please use a SSH Public Key with the .pub extension</b></font>";
		}
		
		//create authorized hosts file
		$cmd = 'cat /root/.ssh/nsg_rsa.pub >> /root/.ssh/authorized_keys';
		exec ($cmd);
		
		$cmd = 'chmod 600 /root/.ssh/authorized_keys';
		exec ($cmd);
		
		//Update the database that the key was generated
		$parameters = "ssh_key_status = \"uploaded\"";
		$where_param = "id = 1";
		$data->update_table (DB_LOCATION, RELAY_TABLE, $parameters, $where_param);			
	}
	
	//Insert step 1 into the database
	function ss7_type_database($data, $table, $db = null)
	{
		if ($db != "") 
			$db_location = $db;
		else
			$db_location = DB_LOCATION;
		
		//Database entry options
		if ($_REQUEST['option'] == "yes")
		{
			$machine = "relay";
		}
		elseif ($_REQUEST['option'] == "no")
		{
			//Drop the existing table
			$data->drop_table($db_location,RELAY_TABLE);
			$machine = "standalone";
		}
		//echo $table;
		
		$table = $data->check_for_table($db_location,RELAY_TABLE);
		
		//Not part of relay
		if ($table < 2)
		{
			//Create table
			$parameters = "id INTEGER PRIMARY KEY, machine_type varchar(15), relay_type varchar(15), ssh_key_status varchar(15)";
			$data->create_table($db_location, RELAY_TABLE, $parameters);
			
			//Insert value
			$parameters = "id, machine_type";
			$values = "1, \"" . $machine . "\"";
			$data->insert_statement($db_location, RELAY_TABLE, $parameters, $values);
			
		}
		elseif ($table > 1)
		{
			//check if user previously chosen for machine to be part of relay
			$result = $data->select_statement($db_location, RELAY_TABLE,"machine_type","id = 1");
			
			if ($result['machine_type'] != "")
			{
				//Update
				$parameters = "machine_type = \"" . $machine . "\"";
				$where_param = "id = 1";
				$data->update_table ($db_location, RELAY_TABLE, $parameters, $where_param);
			}
			elseif ($result['machine_type'] == "")
			{
				//Insert
				$parameters = "id, machine_type";
				$values = "1, \"" . $machine . "\"";
				$data->insert_statement($db_location, RELAY_TABLE, $parameters, $values);
			}
		}		
	}
	
	//Insert step 2 into the database
	function ss7_relay_type_database($data)
	{
		//Update
		$parameters = "relay_type = \"" . $_REQUEST['option'] . "\"";
		$where_param = "id = 1";
		$data->update_table (DB_LOCATION, RELAY_TABLE, $parameters, $where_param);	
	}	
	
	
	//Validates Radio buttons for null entries
	function validate_radio_buttons()
	{
		unset($error_counter);
		
		if ($_REQUEST['option'] == "")
		{
			$this->error_radio = "<font color=" . COLOR_ERROR . "><b>PLEASE SELECT 1 OF THE OPTIONS</b></font>\n";
			$error_counter++;
		}
		//echo $error_counter;
		return $error_counter;
	}
}


?>