<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Starts PHP Sessions
session_start();
$_SESSION['ping'] = "";
$_SESSION['ssh_status'] = "";

if (empty($_POST)) 
	include '../check_referer.php';


//Checks to make sure the user is logged into the WebUI
if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{	
	//Defines
	define( "DB_LOCATION",					"sqlite:../sqlite/relay_info.db"); //Contains the database tables for relay
	define( "COLOR_ERROR" , 				"#E42217"); // Kind of Firebrick
	define( "COLOR_TABLE_BG" , 				"#F1F0F0"); // Sangoma Light blue
	define( "COLOR_TABLE_NON_SELECTED" , 	"#80B0D6"); // Sangoma Dark Blue
	//define( "COLOR_TABLE_NON_SELECTED" , 	"#005C85"); // Sangoma Dark Blue
	define(	"RELAY_TABLE", 					"ss7_relay"); //Table which contains the relay hosts
	define(	"UPLOAD_LOCATION",				"/root/.ssh/"); //Contains the location of the public key


	//Includes
	include 'relay_questionnaire_class.php';
	include '../database_classes.php';
	
	//Constructors
	$relay = new questionnaire;
	$data = new database_class;
	
	//------FORM POST------//
	if ($_REQUEST['cancel'])
	{
		header('location:../controls_embedded.php');
	}

	if ($_REQUEST['skip'])
	{
		//redirect to relay_cfg.php
		header('location:relay_cfg.php');
	}

	if ($_REQUEST['Step2'])
	{
		//Validate the return
		$error_counter = $relay->validate_radio_buttons();
		//echo "counter = $error_counter <br />";
		if ($error_counter == 0)
		{
			//Wipe TDM configuration tables
			include '../wanrouter_controls.php';
			include '../classes.php';
			include '../mg/mg_config_generate.php';
			$tdm_config = new wanrouter_hwprobe_controls;
			$tokenization = new wanrouter_hwprobe;
			$_REQUEST['reset'] = "Reset Config";
			$tdm_config->redirect($_REQUEST,$data,$tokenization,'sqlite:../sqlite/cardinfo.db','sqlite:../sqlite/relay_info.db');
			reset_mg_tables($data,'sqlite:../sqlite/cardinfo.db');
			unset($_REQUEST['reset']);
			//Check if table exists
			$table = $data->check_for_table(DB_LOCATION,RELAY_TABLE);
		
			//Perform POST results for Step 1
			if ($_REQUEST['option'] == "yes")
			{
				//Part of Relay
				$relay->ss7_type_database($data, $table);
			}
			elseif ($_REQUEST['option'] == "no")
			{	
				//Check if last entry was standalong
				$last = $data->select_statement(DB_LOCATION,RELAY_TABLE,"machine_type","id = 1");
				if ($last['machine_type'] != "standalone")
				{
					//echo "i am here";
					//Not part of relay
					$data->drop_table(DB_LOCATION,'relay_hosts');
					$relay->ss7_type_database($data, $table);
				}
				
				//Redirect to the control panel
				if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
				{
					header('location:../controls_embedded.php');
				}
				elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
				{
					echo "<script type='text/javascript'>\n";
					echo " self.parent.location.href = '/admin/ss7_controls.php';";
					echo "</script>";
					exit;
				}
			}
		}
	}

	if ($_REQUEST['Step3'])
	{
		//Validate the return
		$error_counter2 = $relay->validate_radio_buttons();
		
		if ($error_counter2 == 0)
		{
			$relay->ss7_relay_type_database($data);
		}
	}

	if ($_REQUEST['generate'])
	{
		$relay->generate_ssh_key($data);
		header('location:relay_cfg.php');
	}

	//Upload the key to /root/.ssh directory
	if ($_REQUEST['upload_key'])
	{
		$relay->upload_pub_key($data);
		header('location:relay_cfg.php');
		exit;
	}

	//check if relay_info.db exists under sqlite directory
	if (!file_exists('../sqlite/relay_info.db'))
	{
		//relay_info.db not found. Create file
	}
	
		
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';	
		include '../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
		
		//ClearOS Integration
		$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("NSG Questionnaire ", "../../style.css","");		
	}
	
	//MAIN PAGE
	$relay->status_bar($error_counter,$error_counter2,$error_counter3);
	
	if ($error_counter != 0 || (!$_REQUEST['Step2'] && !$_REQUEST['Step3'] && !$_REQUEST['back_step2']) || $_REQUEST['back_step1'] == "Back")
	{
		$relay->initial_quesiton($data);
	}
	elseif ($error_counter == 0 && ($_REQUEST['Step2'] || $_REQUEST['back_step2']))
	{	
		//Display Step 2
		$relay->step2_question($data);
	}
	elseif ($error_counter2 != 0)
	{
		//Display Step 2
		$relay->step2_question($data);
	}
	elseif ($error_counter2 == 0 && $_REQUEST['Step3'])
	{
		if ($_REQUEST['option'] == "MASTER")
		{
			$relay->step3_master_question($data);
		}
		elseif ($_REQUEST['option'] == "SLAVE")
		{
			$relay->step3_slave_question($data);
		}
	}
	elseif ($relay->upload_error != "")
	{
		$relay->step3_slave_question($data);
	}
	
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer(true);	
	}
}
else
{
	header( 'Location:../index.php' ) ;
}
?>
