<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class relay_hosts
{
	private $ssh_status = "";				//Contains the pid of the sshd service
	public $upload_error = "";				//Contains the error message after an upload is made
	public $database = array();				//Contains database information
	private $profile_array = array();		//Contains all the relay_host profiles
	private $counter = "";					//Profile Counter
	
	
	//HTML output for the relay configuration page
	function relay_page($data, $display_common)
	{
		//Pull information regarding the relay type
		$table = $data->check_for_table(DB_LOCATION,"ss7_relay");
		if ($table >1)
		{
			//Pull information
			$this->pull_data($data);
		}
		if ( $display_common->IsRenderingNonDynamicDiv( ) ) 
		{	
		  echo "<form method='get' action='relay_questionnaire.php'>\n";
		  echo "<table width='100%'>";
		  echo "<tr>";
		  echo "<td>";
		  echo "<h3>";
		  echo "SS7 Configuration";
		  echo "</h3>\n";
		  echo "</td>";
		  echo "<td align='right'>";
		  echo "<input type='submit' name='change_ss7_config' value='Change' " . $_SESSION['button_class'] . "/>\n";
		  echo "</td>";
		  echo "</tr>";
		  echo "</table>";
		  echo "</form>";
		  if ($this->database['machine_type'] == "relay" )
			echo "System is configured as SS7 Relay ". $this->database['relay_type'] . " node type.";
		  else
			echo "System is configured as SS7 standalone.";
	
		  echo "<hr>";
		}
		if ($this->database['machine_type'] == "relay" )
		{
		  //-----MASTER STATUS PAGE-----//
		  
		  //Add the relay master to the relay_info.db file
		  if ($this->database['relay_type'] == "MASTER")
		  {
			//Pull relay information
			$this->get_profiles();
			
			//Render as a dynamic refreshing div
			
			if( $display_common->IsRenderingNonDynamicDiv()|| $display_common->IsDynamicDivRefreshRequest('MasterRelayDiv') )
			{	
			  $display_common->DynamicDivBegin( "MasterRelayDiv","width:100%", 500 );
			  echo "<table width='100%'>";
			  echo "<tr>";
			  echo "<td>";
			  echo "<h3>Relay Hosts Configuration</h3>\n";
			  echo "</td>";
			  echo "<td align='right'>";
			  echo "<form method='post'>\n";
			  if ($this->counter >= 9)
			  	echo "<input type='submit' name='add_new_host' value='Add New Host' " . $_SESSION['disabled_button_class'] . " />";
			  else
			  	echo "<input type='submit' name='add_new_host' value='Add New Host' " . $_SESSION['button_class'] . " />";
			  echo "</form>\n";
			  echo "</td>";
			  echo "</tr>";
			  echo "<td colspan='2' align='center'>";
				
			  //echo "ping=" . $_SESSION['ping'];
			  echo "<form method='post'>\n";
			  echo "<table class='mytable' border='1' width='700px'>\n";		
			  echo "<th class='widget-content-header ui-state-active ui-corner-top' align='left' colspan='8'>Relay Hosts</th>\n";
			  echo "<tr>\n";
			  echo "<td class='mytableheader ui-state-active'>Node</td>\n";
			  echo "<td class='mytableheader ui-state-active'>Node Type</td>\n";
			  echo "<td class='mytableheader ui-state-active'>IP Address</td>\n";
			  echo "<td class='mytableheader ui-state-active'>SSH Port</td>\n";
			  echo "<td class='mytableheader ui-state-active'>Relay Port</td>\n";
			  echo "<td class='mytableheader ui-state-active'>System Status</td>\n";                                              
			  echo "<td class='mytableheader ui-state-active'>SSH Status</td>\n";
			  echo "<td class='mytableheader ui-state-active'>Options</td>\n";                                              
			  echo "</tr>\n";
			
	
			  //Display information from relay_hosts table
			  $b = 0;
			  foreach ($this->profile_array as $profile)
			  {
				echo "<tr>\n";
				echo "<td>" . $profile['id'] . "</td>\n";
				if (preg_match("'\bMaster1\b'",$profile['relay_name']))
				  $name = "Master";
				else
				  $name = "Slave";

				echo "<td>" . $name . "</td>\n";
				echo "<td align='center'>";
				if ($name == "Slave")
				{
				  echo "<u><a href='http://".$profile['ip_addr'].":";
				  echo (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))?8888:81;
				  echo "' target='blank'>";
				}
				echo $profile['ip_addr'];
				if ($name == "Slave")
				  echo "</u></a>";
				echo "</td>\n";
				echo "<td align='center'>" . $profile['ssh_port'] . "</td>\n";
				echo "<td align='center'>" . $profile['relay_port'] . "</td>\n";
				//Check system status
				if (!isset($_SESSION['ping']) || $_SESSION['ping'] == "")
				  echo "<td align='center' style='background-color:" . COLOR_CONNECT . "'><img src='" .ICON_LOADING. "' style='margin-left:auto;margin-right:auto;float:center;' width='12px' height='12px'/></td>";
				else
				{
				  unset($sys_status);
				  $sys_status = $this->system_status($profile['ip_addr']);
				  //echo $sys_status . "<br />";
				  if ($sys_status == "up")
					echo "<td align='center' style='background-color:" . COLOR_OK . "'><font color='white'><b>UP</b></font></td>";
				  elseif ($sys_status == "down")
					echo "<td align='center' style='background-color:" . COLOR_ERROR . "'><font color='white'><b>DOWN</b></td>";
				}
				if (!isset($_SESSION['ping']) || $_SESSION['ping'] == "")
				  echo "<td align='center' style='background-color:" . COLOR_CONNECT . "'><img src='" .ICON_LOADING. "' style='margin-left:auto;margin-right:auto;float:center;' width='12px' height='12px'/></td>";
				else
				{
				
				  //Check SSH Status
				  if ($profile['id'] == 1)
				  {
					$this->check_ssh_status("local", "", "");
				  }
				  else
				  {
					//echo $sys_status . "<br />";
					if ($sys_status == "up")
					{
					  $this->check_ssh_status("remote", $profile['ssh_port'], $profile['ip_addr']);
					}
					else
					{
					  $this->ssh_status = "DISABLED";
					}
					//echo $ssh
				  }
				  
				  if ($this->ssh_status == "ENABLED")
				  {
					echo "<td align='center' style='background-color:" . COLOR_OK . "'><font color='white'><b>ENABLED</b></font></td>";
				  }
				  elseif ($this->ssh_status == "DISABLED")
				  {
					echo "<td align='center' style='background-color:" . COLOR_ERROR . "'><font color='white'><b>DISABLED</b></td>";
				  }
				  elseif ($this->ssh_status == "INVALID KEY")
				  {
					  $invalidkey = "yes";
					echo "<td align='center' style='background-color:" . COLOR_WARNING . "'><font color='white'><img src='../fusionpbx/AlertSign.png' width='12' height='12' title='INVALID KEY' style='vertical-align:text-bottom; float:none'/><b>INVALID KEY</b></td>";
				  }
				}
				echo "<td align='center'>\n";
				echo "<input type='submit' name='edit" . $profile['id'] . "' value='Edit' " . $_SESSION['button_class'] . "/>\n";
				if ($profile['id'] == 1)
				{
				  echo "<input type='submit' name='delete" . $profile['id'] . "' value='Remove' " . $_SESSION['disabled_button_class'] . "/>\n";
				}
				else
				{
				  echo "<input type='submit' name='delete" . $profile['id'] . "' value='Remove' " . $_SESSION['button_class'] . "/>\n";
				}
				echo "</td>\n";
				echo "</tr>\n";
				$b++;
			  }
			  
			  
			  echo "<th align='left' class='widget-content-header ui-state-active ui-corner-bottom' colspan='8'></th>\n";
			  echo "</table>\n";
			  echo "</td>";
			  echo "</tr>";
			  echo "</table>";
				
			  echo "<hr>\n";
			  
			  //Check if a public key exists for download
			  echo "<table width='100%'>";
			  echo "<tr>";
			  echo "<td>";
			  echo "<h3>Key management</h3>\n";
			  echo "</td>";
			  echo "<td align='right'>";
				
			  if (file_exists('nsg_rsa.pub') || $this->database['ssh_key_status'] == "generated")
			  {
				  echo "<a href=\"relay_cfg.php?generate_key=Generate\">Re-Generate</a> a new key<br />";
				//echo "<INPUT TYPE='submit' name='generate_key' VALUE='Generate' " . $_SESSION['button_class'] . " />\n";
			  }
			  if (file_exists('nsg_rsa.pub') || $this->database['ssh_key_status'] == "generated")
			  {
				   echo "<form>"; 
				   echo "<INPUT TYPE='button' name='download_key' VALUE='Download'" . $_SESSION['button_class'] . " onclick='parent.location=\"nsg_rsa.pub\"'/>\n";
				   echo "</form>";  
			  }
				
	//            echo "Download the existing public key: <a href='nsg_rsa.pub'>Download</a>\n";
			  
			  echo "</td>";
			  echo "</tr>";
			  echo "</table>";
			  echo "<hr>";
			  $display_common->DynamicDivEnd( "MasterRelayDiv" );
			  require_once '../display_class.php';
			  //echo "<br />\n";
			  if ( $display_common->IsRenderingNonDynamicDiv( ) ) 
			  {
				  if (!file_exists('nsg_rsa.pub'))
				  {
						$notif = new NotificationBox('Error', NotificationBox::Error);
						//$notif->add("SSH KEYS", "Please <input type='submit' name='generate_key2' value='Generate New Keys' " . $_SESSION['button_class'] . "/>\n");
						$notif->add("SSH KEYS", "Please <a href=\"relay_cfg.php?generate_key=Generate\">Generate</a> a new key\n");
				  }
			  }
				  if ($invalidkey == "yes")
				  {
					$notif = new NotificationBox('Error', NotificationBox::Error);
					$notif->add("INVALID KEY", "1 or more slaves do not have a valid RSA key. Please download your RSA key, and upload it to your slave\n");
					
				  }
			}
	
			
			if (isset($notif))
			{
			  $notif->display();
			}
			 unset($notif);
			 echo "</form>\n";
			 
		  }
		  
		  //-----SLAVE MACHINE STATUS------//
		  if ($this->database['relay_type'] == "SLAVE")
		  {
			if( $display_common->IsRenderingNonDynamicDiv()|| $display_common->IsDynamicDivRefreshRequest('SlaveRelayDiv') )
			{	
			  if ( $display_common->IsRenderingNonDynamicDiv( ) ) 
			  {
				echo "<table width='100%'>";
				echo "<tr>";
				echo "<td>";
				echo "<h3>SSH configuration</h3>\n";
				echo "</td>";
				echo "<td align='right'>";
				echo "<form enctype='multipart/form-data' method='post'>";
				echo "<input type='file' name='userfile'/>";
				echo "<input type='submit' name='upload_key' VALUE='Upload Key' ". $_SESSION['button_class'] . "/>\n";
				echo "</form>\n";
				echo "</td>";
				echo "</tr>";
				echo "<tr>";
				echo "<td colspan='2'>";
			  }
			  $display_common->DynamicDivBegin( "SlaveRelayDiv","width:100%", 500 );	
			  //Checks the slave machines ssh status
			  $this->check_ssh_status("local", "", "");
		  ?>
			  
			  <table class='mytable' border='1' width='300px'>
				<th class='widget-content-header ui-state-active ui-corner-top' align='left' colspan='7'>SSH Status</th>
				  <tr>
					<td class='mytableheader ui-state-active'>Relay Name</td>
					<td class='mytableheader ui-state-active'>Status</td>                                             
				  </tr>
				  <tr>
					<td>SSH Status</td>
			  <?php 
			  if ($this->ssh_status == "ENABLED")
			  {
				echo "<td align='center' style='background-color:" . COLOR_OK . "'><font color='white'><b>ENABLED</b></font></td>";
			  }
			  elseif ($this->ssh_status == "DISABLED")
			  {
				echo "<td align='center' style='background-color:" . COLOR_ERROR . "'><font color='white'><b>DISABLED</b></td>";
				$ssh_disabled = "yes";
			  }
			  ?>
					  
				  </tr>
				  <th align='left' class='widget-content-header ui-state-active ui-corner-bottom' colspan='7'></th>
			  </table>
				<?php
			  $display_common->DynamicDivEnd( "SlaveRelayDiv" );
			  if ( $display_common->IsRenderingNonDynamicDiv( ) ) 
			  {
				echo "</td>";
				echo "</tr>";
				echo "</table>";
				echo "<hr />";
			  
			  if(strlen($this->upload_error))
			  {
				$notif = new NotificationBox('Error', NotificationBox::Error);
				$notif->add("SSH KEY", $this->upload_error);
			  }
			  if (!file_exists('/root/.ssh/nsg_rsa.pub'))
			  {
				$notif = new NotificationBox('Error', NotificationBox::Error);
				$notif->add("SSH KEY", "Please upload an SSH key in order to proceed with the relay configuration");
			  }
			  if($ssh_disabled == "yes")
			  {
				$notif = new NotificationBox('Warnings', NotificationBox::Warning);
				if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
				{
					$notif->add("SSH STATUS", "SSH is currently <b>DISABLED</b>.");
				}
				elseif (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
				{
					$notif->add("SSH STATUS", "SSH is currently <b>DISABLED</b>. <a href='" . $_SERVER['PHP_SELF'] . "?enable_ssh=yes'>Click Here</a> to enable SSH");
				}
			  }
			  if (isset($notif))
			  {
				  $notif->display();
			  }
			  unset($notif);
			  }
			}
		  }
		}
	}	
	
	//Checks for remote system status
	function system_status ($ip_addr)
	{
		//Run ping command and check for results
		//$cmd = "ping -c4 " . $ip_addr . " | grep -c 'Destination Host Unreachable'";
		$cmd = "ping -c 4 -w 2 -W 1 -s 160 -q -Q 0x18 " . $ip_addr;
		exec ($cmd, $output);
		
		for ($a = 0; $a <= count($output); $a++)
		{
			if (preg_match("'\brtt\b'",$output[$a]))
				$rtt_vals = $output[$a];
		}
		
		//Cut out "=" and "ms" values
		$equalsign = strpos($rtt_vals, '=');
		$ms = strpos($rtt_vals,'ms');
			
		$value = substr($rtt_vals,($equalsign + 1));
		$value2 = substr($value,0,-3);
		
		//echo "values = $value2<br />";
		
		//Determine the average by tokenizing the return
		$token_rtt = $this->tokenize_rtt($value2);
		$sum = 0.0;
		for ($a = 0; $a < count($token_rtt); $a++)
		{
			//echo gettype($token_rtt[$a]) . "<br />";
			//$sum = bcadd($token_rrt[$a],$sum,4);
			$sum = sprintf("%.4f", $token_rtt[$a] + $sum);
			//echo "tentaive sum = $sum<br />";
		}
		//echo "Sum = $sum<br />";
		$avg = $sum / 4;
		//echo "Average = $avg<br />";
		if ($avg == (float)0)
			$system = "down";
		elseif ($avg > (float)0)
			$system = "up";

		//echo $system;
		return $system;
	}

	//Tokenizes the card name
	function tokenize_rtt($string)
	{
		$tok = strtok($string, "/");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = (float)$tok;
			$tok = strtok("/");
			$count++;
		}

		return $token;
	}

	//Gets relay hosts from database
	function get_profiles()
	{
		$where_param = "";
		$a = 0;

		$select = "SELECT * FROM " . RELAY_TABLE . " ORDER BY id;";
		
		try
		{
			//open the database
			$db = new PDO(DB_LOCATION);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$this->profile_array[$a] = $row;
				//echo "card = " . $this->profile_array[$a]['dev_name'] . "<br />";
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}

		$this->counter = $a;
	}
	
	
	//Determines the SSH status
	function check_ssh_status($type, $port, $machine_ip)
	{
		//Include ssh executor class
		require_once '../SSH_Class.php';
		
		$ssh = new ssh_class;
		$output = $ssh->execute($type,"pidof sshd",$machine_ip,$port);				

		if ($output[0] == "ENABLED")
			$this->ssh_status = "ENABLED";			
		elseif ($output[0] == "DISABLED")
			$this->ssh_status = "DISABLED";			
		elseif ($output[0] == "INVALID KEY")
			$this->ssh_status = "INVALID KEY";			
		elseif ($output[0] == "")
			$this->ssh_status = "DISABLED";
		elseif ($output[0] != "")
			$this->ssh_status = "ENABLED";
		
		unset($ssh);
	}
	
	//Uploads public key to slave relay host
	function upload_pub_key($data)
	{
    $this->upload_error = "";
		$parts = explode('.', $_FILES['userfile']['name']);
		//echo $_FILES['userfile']['name'];
		if($parts[(count($parts)-1)] == 'pub')
		{
			// Continue
			if ($_FILES["userfile"]["size"] < 50000)
			{
				if ($_FILES["userfile"]["error"] > 0)
				{
					 $this->upload_error= "Return Code: " . $_FILES["userfile"]["error"];
				}
				else
				{
					/*echo "Upload: " . $_FILES["userfile"]["name"] . "<br />";
					echo "Type: " . $_FILES["userfile"]["type"] . "<br />";
					echo "Size: " . ($_FILES["userfile"]["size"] / 1024) . " Kb<br />";
					echo "Temp file: " . $_FILES["userfile"]["tmp_name"] . "<br />";*/
			
					/*if (file_exists(UPLOAD_LOCATION . $_FILES["userfile"]["name"]))
					{
						echo $_FILES["userfile"]["name"] . " already exists. ";
					}
					else
					{*/
						//Check if the .ssh folder exists
						if (!file_exists('/root/.ssh'))
						{
							mkdir("/root/.ssh",0644);
						}
						move_uploaded_file($_FILES["userfile"]["tmp_name"], UPLOAD_LOCATION . $_FILES["userfile"]["name"]);
						//echo "Stored in: " . UPLOAD_LOCATION . $_FILES["userfile"]["name"];
					//}
				}
			}
			else
				$this->upload_error= "Invalid Upload Size. SSH Public Key must be less then 5KB";
		}
		else
			$this->upload_error= "Invalid file type. Please use a SSH Public Key with the .pub extension";
		
		if ( 0 == strlen($this->upload_error) )
		{  
		  //create authorized hosts file
		  $cmd = 'cat /root/.ssh/nsg_rsa.pub >> /root/.ssh/authorized_keys';
		  exec ($cmd);
		  
		  $cmd = 'chmod 600 /root/.ssh/authorized_keys';
		  exec ($cmd);
		  
		  //Update the database that the key was generated
		  $parameters = "ssh_key_status = \"uploaded\"";
		  $where_param = "id = 1";
		  $data->update_table (DB_LOCATION, RELAY_TABLE, $parameters, $where_param);					
		}
	}
	
	//Pulls relevant information from ss7_relay table
	function pull_data($data)
	{
		$where_param = "id = 1";
		$param = "*";
		
		$this->database = $data->select_statement(DB_LOCATION,"ss7_relay",$param, $where_param);
		
		//If master machine, add itself as a master in the relay_hosts table
		//Find IP Address
		exec("/sbin/ifconfig | grep eth | cut -d: -f1 | awk '{ print $1}'", $name_1);
		foreach ($name_1 as $if_name) {
			$command = "/sbin/ifconfig " . $name . " | grep 'inet addr:' | cut -d: -f2 | awk '{ print $1}'";
			exec($command, $output);
			if (trim($output[0]) != "") {
				$ip_addr = $output[0];
				break;				
			}
		}
		
		//$ip_addr = $output[0];
		$ssh_port = "22";
		$relay_port = "5000";
		
		//Insert into the relay_hosts table
		//check if table exits
		if ($data->check_for_table(DB_LOCATION,RELAY_TABLE) > 1)
		{
			//check if field exists
			$result = $data->select_statement(DB_LOCATION,RELAY_TABLE,'id','id=1');
			if ($result['id'] == "")
			{
				//Insert
				$param = "relay_name, ip_addr,ssh_port,relay_port";
				$value ="\"Master1\", \"" . $ip_addr . "\", \"" . $ssh_port . "\", \"" . $relay_port . "\"";
				
				$data->insert_statement(DB_LOCATION,RELAY_TABLE,$param,$value);
			}
			else {
				//Update the table with the new parameters
				$value ="relay_name = \"Master1\", ip_addr = \"" . $ip_addr . "\", ssh_port = \"" . $ssh_port . "\", relay_port = \"" . $relay_port . "\"";
				$data->update_table(DB_LOCATION,RELAY_TABLE,$value,'id=1');								
			}
		}
		elseif ($table < 2)
		{
			//Create table
			$param = "id INTEGER PRIMARY KEY, relay_name varchar(30), ip_addr varchar(30), ssh_port int, relay_port int";
			$data->create_table(DB_LOCATION,RELAY_TABLE, $param);
			
			//insert into table
			$param = "relay_name, ip_addr,ssh_port,relay_port";
			$value ="\"Master1\", \"" . $ip_addr . "\", \"" . $ssh_port . "\", \"" . $relay_port . "\"";
			
			$data->insert_statement(DB_LOCATION,RELAY_TABLE,$param,$value);
		}
	}
}


?>
