<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class add_relay_host
{
	public $form_val = array();					//Contains the value for the html form
	public $database = array();					//Contains the values from the database table
	public $data = "";							//Contains the class database_class
	private $error = array();					//Contains an array of all errors in the form
	
	//HTML Display
	function main_html()
	{
		//if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
		//{
			if ($this->database['id'] == "")
			{
				echo "<h3>RELAY HOST ADDITION</h3>\n";
			}
			elseif ($this->database['id'] != "")
			{
				echo "<h3>RELAY HOST EDIT</h3>\n";
			}
		//}
		
		//Auto-populate the table
		$this->auto_populate();
		
		?>
        <form method='post' action="">
        	<table>
            	<tr>
                	<td>Relay Type</td>
                    <?php
					if ($this->database['id'] == 1)
					{
					?>
					<td align='right'><b>Master</b></td>
                    <?php
					}
					elseif ($this->database['id'] > 1)
					{
					?>
                    <td align='right'><b>Slave <?php echo "# " . $this->database['id']; ?></b></td>
                    <?php
					}
					else
					{
					?>
                    <td align='right'><b>Slave</b></td>
                    <?php
					}
					?>
                </tr>
                <tr>
                	<td>IP Address</td>
                    <td align='right'><input type='text' name='ip_addr' value='<?php echo $this->form_val['ip_addr']; ?>' style="text-align:right; width:150px" /></td>
                    <td><?php echo $this->error['ip_addr']; ?></td>
                </tr>
                	<?php
					if ($this->database['id'] > 1 || $this->database['id'] == "")
					{
					?>
                <tr>
                	<td>SSH Port</td>
                    <td align='right'><input type='text' name='ssh_port' value='<?php echo $this->form_val['ssh_port']; ?>' style="text-align:right; width:50px" /></td>
                    <td><?php echo $this->error['ssh_port']; ?></td>
                </tr>
                	<?php
					}
					?>
                <tr>
                	<td>Relay Port</td>
                    <td align='right'><input type='text' name='relay_port' value='<?php echo $this->form_val['relay_port']; ?>' style="text-align:right; width:50px" /></td>
                    <td><?php echo $this->error['relay_port']; ?></td>
                </tr>
            </table>
            <br />
            <table width='230px'>
            	<tr>
            <?php
			//echo $this->database['id'] . "<br />";
			if ($this->database['id'] != "")
			{
				?>
	            	<td width='1%' align='left'><input type='submit' name='add_host' value='Apply Configuration'  <?php echo $_SESSION['button_class']; ?>/></td>
            	<?php
			}
			elseif ($this->database['id'] == "")
			{
			?>
	            	<td width='1%' align='left'><input type='submit' name='add_host' value='Add Host'  <?php echo $_SESSION['button_class']; ?>/></td>
            <?php
			}
			?>
                    <td align='right'><input type='submit' name='cancel' value='Cancel' <?php echo $_SESSION['button_class']; ?>/></td>
                </tr>
            </table>
        </form>
        
        <?php
	}
	
	//Auto-populate the form
	function auto_populate()
	{
		if ($_REQUEST['ip_addr'] != "")
		{
			$this->form_val['ip_addr'] = $_REQUEST['ip_addr'];
		}
		elseif($this->database['ip_addr'] != "")
		{
			$this->form_val['ip_addr'] = $this->database['ip_addr'];
		}
		
		if ($_REQUEST['ssh_port'] == "" && $this->database['ssh_port'] == "")
		{
			$this->form_val['ssh_port'] = "22";
		}
		elseif ($_REQUEST['ssh_port'] != "")
		{
			$this->form_val['ssh_port'] = $_REQUEST['ssh_port'];
		}
		elseif($this->database['ssh_port'] != "")
		{
			$this->form_val['ssh_port'] = $this->database['ssh_port'];
		}
		
		if ($_REQUEST['relay_port'] == "" && $this->database['relay_port'] == "")
		{
			$this->form_val['relay_port'] = "5001";
		}
		elseif ($_REQUEST['relay_port'] != "")
		{
			$this->form_val['relay_port'] = $_REQUEST['relay_port'];
		}
		elseif($this->database['relay_port'] != "")
		{
			$this->form_val['relay_port'] = $this->database['relay_port'];
		}
	}
	
	//Validate the form results
	function validate()
	{
		//Validate IP Address
		//if (!preg_match('/^(([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]).){3}([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$/',$_REQUEST['ip_addr']))
		if (!preg_match('/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)/',$_REQUEST['ip_addr']))
		{
			$this->error['ip_addr'] = "<b><font color='" . COLOR_ERROR . "'>IP Address entered is not a valid IPv4 Address</font></b>";
			$error_count++;
		}
		
		//Check if master ip entered is actually on that system
		if ($this->database['id'] == 1)
		{
			$command = "/sbin/ifconfig -a | grep -e \"inet addr:".$_REQUEST['ip_addr']."\" | cut -d: -f2 | awk '{ print $1}'";
       		$output = shell_exec($command);
			
			if (trim($output) != trim($_REQUEST['ip_addr']))
        	{
				$this->error['ip_addr'] = "<b><font color='" . COLOR_ERROR . "'>IP Address entered is not a valid IPv4 Address on the Master Relay Node</font></b>";
				$error_count++;
			}
		}
		
		if ($_REQUEST['relay_port'] == "")
		{
			$this->error['relay_port'] = "<b><font color='" . COLOR_ERROR . "'>The Relay Port field must contain a value</font></b>";
			$error_count++;
		}
		elseif (!is_numeric($_REQUEST['relay_port']))
		{
			$this->error['relay_port'] = "<b><font color='" . COLOR_ERROR . "'>The port used for Relay must be a numeric value</font></b>";
			$error_count++;
		}
		
		if ($_REQUEST['ssh_port'] == "")
		{
			$this->error['ssh_port'] = "<b><font color='" . COLOR_ERROR . "'>The SSH Port field must contain a value</font></b>";
			$error_count++;
		}
		elseif (!is_numeric($_REQUEST['ssh_port']))
		{
			$this->error['ssh_port'] = "<b><font color='" . COLOR_ERROR . "'>The port used for SSH must be a numeric value</font></b>";
			$error_count++;
		}
		
		return $error_count;
	}
	
	//Check for entry
	function database_check()
	{
		//Host ID only set when editing
		$id = $_SESSION['host_id'];
				
		//Pull the information from the relay_hosts table
		$this->database = $this->data->select_statement (DB_LOCATION, RELAY_TABLE, "*", "id = $id");
		
	}
	
	//Inserts data into database
	function insert_info()
	{
		//Check if entry in table
		//echo $this->database['id'] . "<br />";
		if ($this->database['id'] != "")
		{
			//Update the table
			$relay_name = "slave" . $this->database['id'];
			$param = "ip_addr = \"" . $_REQUEST['ip_addr'] . "\", ssh_port = \"" . $_REQUEST['ssh_port'] . "\", relay_port = \"" . $_REQUEST['relay_port'] . "\"";
			$where_param = "id = " . $this->database['id'];
			$this->data->update_table (DB_LOCATION, RELAY_TABLE, $param, $where_param);
		}
		elseif ($this->database['id'] == "")
		{
			//Insert into table
			$param = "ip_addr, ssh_port, relay_port";
			$value = "\"" . $_REQUEST['ip_addr'] . "\", \"" . $_REQUEST['ssh_port'] . "\", \"" . $_REQUEST['relay_port'] . "\"";
			$this->data->insert_statement(DB_LOCATION, RELAY_TABLE, $param, $value);
			
			//Pull new ID and enter slave number into database
			$tmp = $this->data->select_statement (DB_LOCATION, RELAY_TABLE, "id", "ip_addr = \"" . $_REQUEST['ip_addr'] . "\"");+		
  
			//Change the ID value to a number between 2-9
			$id = 2;
			do
			{
				//echo "id = $id<br />";
				$check_val = $this->data->select_statement (DB_LOCATION, RELAY_TABLE, "id", "id = $id");
				
				//echo "id = $id and check value = " . $check_val['id'] . "<br />";
				if ($check_val['id'] == "")
				{
					$exit = "yes";
					$id--;
				}
				elseif ($check_val['id'] != "")
				{
					$id++;
				}
			}
			while ($exit != "yes");
		
			//Update table with new id number	
			$param = "id  = " . $id . "";
			$where_param = "id = " . $tmp['id'];
			$this->data->update_table (DB_LOCATION, RELAY_TABLE, $param, $where_param);
			
			$tmp['id'] = $id;
			
		//echo "Temp id = " . $tmp['id'] . "<br />";
			
			$relay_name = "slave" . $tmp['id'];
			$param = "relay_name = \"Slave" . $tmp['id'] . "\"";
			$where_param = "id = " . $tmp['id'];
			$this->data->update_table (DB_LOCATION, RELAY_TABLE, $param, $where_param);
		}
	}
}

?>
