<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Start Session
session_start();

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{
	//ONLY ALLOWED IF MASTER OR STANDALONE MODE
	if ($relay_type != "SLAVE") {
		include 'view_r2_profiles_class.php';
		include '../database_classes.php';
		
		$data = new database_class;
		$r2 = new r2_profiles;
		
		if ($data->check_for_table('sqlite:../sqlite/relay_info.db',"ss7_relay") > 1)
		{
			$relay = $data->select_statement('sqlite:../sqlite/relay_info.db',"ss7_relay","machine_type,relay_type","id = 1");
			$relay_type = $relay['relay_type'];
			$machine_type = $relay['machine_type'];
		}
		
		$proc_id = $_SESSION['proc_id'];
		
		if ($proc_id == 1)
			$db_location = "sqlite:../sqlite/cardinfo.db";	
		elseif ($proc_id > 1)
			$db_location = "sqlite:../sqlite/cardinfo" . $proc_id . ".db";
	
		$r2->db = $db_location;	
		
		if ($_POST['create'] == "Create New Profile") {
			//Redirects to viewing all profiles page
			header( 'Location:create_r2_profile.php' ) ;		
			exit;
		}
		elseif ($_POST['back'] == "Go Back to Hardware Information") {
			unset ($_SESSION['last_profile']);
			//Redirects to hardware probe
			header( 'Location:../wanrouterhwprobe.php' ) ;
			exit;
		}
		else {
			foreach ($_POST as $k=>$v) {
				$port = $_SESSION['port_num_clicked'];
				
				if (preg_match('"\bedit\b"',$k)) {
					$key = explode ('-',$k);
					$id = $key[1];
					$_SESSION['r2_id'] = $id;
					header('Location:create_r2_profile.php');
				}
				elseif (preg_match('"\buse-all\b"',$k)) {
					$key = explode ('-',$k);
					$id = $key[2];

					//Find total number of ports on card
					$table = 'card_present';
					$param = 'num_ports';
					$where = 'id='.$_SESSION['card_num'];
					
					$num_ports = $data->select_statement($r2->db,$table,$param,$where);
					$current = $data->select_statement($r2->db,$_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'],'*','port_id='.$_SESSION['port_num_clicked']);
					$physical = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'];
					
					for ($a=1;$a<=$num_ports['num_ports'];$a++) {
						$where_param = "port_id = " . $a;
						$result = $data->select_statement ($db_location, $physical, "port_id,sigmode", $where_param);
						
						//Configure Port with the exact same values as the port being used
						if ($result['port_id'] == "")
						{
							$where = "port_id = " . $_SESSION['port_num_clicked'];
							
							//Change sigmode to CAS on the first port
							//update_table ($db_location, $table_name, $parameters, $where_param)
							$param='sigmode="CAS"';
							$data->update_table($r2->db,$physical,$param,$where);
							
							$current = $data->select_statement($r2->db,$physical,"*",$where);
							
							$insert_parameters = "port_id, dev_name, line_type, coding, framing, clock, ref_clock, echo, dtmf, fax, lbo, txtristate, sigmode, impedence, rx_level, rxgain, txgain, dtmf_removal, pre_buffer_size";	
							$insert_value = $a . ", \"" . $current['dev_name'] . "\", \"" . $current['line_type'] . "\", \"" .$current['coding'] . "\", \"" . $current['framing'] . "\", \"" . $current['clock'] . "\",\"" . $current['ref_clock'] . "\", \"" .$current['echo']. "\", \"" . $current['dtmf'] . "\", \"" . $current['fax'] . "\", \"" . $current['lbo'] . "\", \"" . $current['txtristate'] . "\", \"CAS\", \"" . $current['impedence'] . "\", \"" . $current['rx_level'] . "\", \"" . $current['rxgain'] . "\", \"" . $current['txgain'] . "\", \"" . $current['dtmf_removal'] . "\", \"" . $current['pre_buffer_size'] . "\"";
							
							$data->insert_statement($r2->db, $physical, $insert_parameters, $insert_value);	
						}
					}
					
					$table_name =  $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_r2_signalling";
					for ($a=1;$a<=$num_ports['num_ports'];$a++) {
						$dev = "";
						$port = $a;
	
						//Check if port has any other config. if it does, skip over the configuration.
						$skip = false;
						
						$m2ua = $data->select_statement($r2->db,$_SESSION['card_clicked'].'_'.$_SESSION['card_num'].'_m2ua_link','link_name','port_id='.$port);
						$mg = $data->select_statement($r2->db,$_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_m2ua_channels",'profile_name','port_id='.$port);
						$ss7_link = $data->select_statement($r2->db,$_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_SS7_link","link_name",'port_id='.$port);
						$pri = $data->select_statement($r2->db,$_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_signalling",'signalling','port_id='.$port);
						
						if ($ss7_link['link_name'] != "")
							$skip = true;
						elseif($mg['profile_name'] != "")
							$skip = true;
						elseif ($m2ua['link_name'] != "")
							$skip = true;
						elseif ($pri['signalling'] != "")
							$skip = true;

						//Port empty, configure port							
						if (!$skip) {
							
							//make sure sigmode on port is set to CAS
							$new_port = $data->select_statement($r2->db,$physical,"sigmode",'port_id='.$a);
							
							if ($new_port['sigmode'] != "CAS") {
								//change to CAS
								$where = "port_id=".$port;
								$param = 'sigmode="CAS"';
								$data->update_table($r2->db,$_SESSION['card_clicked'].'_'.$_SESSION['card_num'],$param,$where);								
							}
							
							if ($data->check_for_table($r2->db,$_SESSION['card_clicked'].'_'.$_SESSION['card_num'].'_r2_signalling') > 1) {
								//check if port exists
								$r2_sig = $data->select_statement($r2->db,$_SESSION['card_clicked'].'_'.$_SESSION['card_num'].'_r2_signalling','port_id, r2_profile','port_id='.$a);
								if ($r2_sig['port_id'] != "") {
									//update
									$r2->update_r2_table($data,$id,$a);
								}
								else {
									//insert
									$r2->insert_r2_table($data,$id,$a);
								}
							}
							else {
								//create table
								$r2->create_r2_table($data);
								
								//insert
								$r2->insert_r2_table($data,$id,$a);
							}							
						}
					}
										
					//Redirects to hardware probe
					header( 'Location:../wanrouterhwprobe.php' ) ;					
				}
				elseif (preg_match('"\buse\b"',$k)) {
					$key = explode ('-',$k);
					$id = $key[1];
					$physical = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'];

                                        $param='sigmode="CAS"';
                                        $where = "port_id = " . $_SESSION['port_num_clicked'];
                                        $data->update_table($r2->db,$physical,$param,$where);

					if ($data->check_for_table($r2->db,$_SESSION['card_clicked'].'_'.$_SESSION['card_num'].'_r2_signalling') > 1) {
						//check if port exists
						$r2_sig = $data->select_statement($r2->db,$_SESSION['card_clicked'].'_'.$_SESSION['card_num'].'_r2_signalling','port_id, r2_profile','port_id='.$_SESSION['port_num_clicked']);
						if ($r2_sig['port_id'] != "") {
							//update
							$r2->update_r2_table($data,$id);
						}
						else {
							//insert
							$r2->insert_r2_table($data,$id);
						}
					}
					else {
						//create table
						$r2->create_r2_table($data);
						
						//insert
						$r2->insert_r2_table($data,$id);
					}
					//Redirects to hardware probe
					header( 'Location:../wanrouterhwprobe.php' ) ;
				}
				elseif (preg_match('"\bdelete\b"',$k)) {
					$key = explode ('-',$k);
					$id = $key[1];
					$data->delete_generic($r2->db,'r2_profile','id='.$id);

					//Redirects to hardware probe
					header( 'Location:../wanrouterhwprobe.php' ) ;
				}			
			}
		}
	
	
	
		//Check to see which UI we are running in
		if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
		{
			unset($_SESSION['embedded']);
			
			//FusionPBX Integration
			require_once "../fusionpbx/includes/header.php";
		}
		elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
		{
			//Includes required for ClearOS Integration
			include '../sqlite/database_creation.php';
			include '../display_class.php';
			
			$display_common = new Display_common;
			$_SESSION['embedded'] = "true";	
		
			//ClearOS Integration
			$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
			$display_common->html_header();
			$display_common->html_title("MFC/R2 Profiles", "../../style.css","");		
		}	
	
		//Display HTML
		$r2->display($data);
		
		//Check to see which UI we are running in
		if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
		{
			unset($_SESSION['embedded']);
			//FusionPBX Integration
			require_once "../fusionpbx/includes/footer.php";
		}
		elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
		{
			//ClearOS Integration
			$display_common->html_footer();	
		}	
	}
}
else
{
	header( 'Location:../index.php' ) ;	
}
?>
