<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Starts PHP Sessions
session_start();

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{	

	include 'create_r2_profile_class.php';
	include '../database_classes.php';
	
	$data = new database_class;
	$r2 = new r2_profile;
	
	if ($data->check_for_table('sqlite:../sqlite/relay_info.db',"ss7_relay") > 1)
	{
		$relay = $data->select_statement('sqlite:../sqlite/relay_info.db',"ss7_relay","machine_type,relay_type","id = 1");
		$relay_type = $relay['relay_type'];
		$machine_type = $relay['machine_type'];
	}
	
	$proc_id = $_SESSION['proc_id'];
	
	if ($proc_id == 1)
		$db_location = "sqlite:../sqlite/cardinfo.db";	
	elseif ($proc_id > 1)
		$db_location = "sqlite:../sqlite/cardinfo" . $proc_id . ".db";

	$r2->db = $db_location;	
	
	if ($_REQUEST['save'] == "Save Profile") {
		//validate
		if ($r2->validation($data)) {
			//save
			if ($_SESSION['r2_id'] != "") {
				$id = $_SESSION['r2_id'];
				unset($_SESSION['r2_id']);
				
				//update record
				$where = "id = " . $id;
				$update_param = 'varient="'.$_REQUEST['varient'].'",ani_length='.$_REQUEST['ani_length'].',dnis_length='.$_REQUEST['dnis_length'].',category="'.$_REQUEST['category'].'",collect_calls="'.$_REQUEST['collect_calls'].'",immediate_accept="'.$_REQUEST['immediate_accept'].'",double_answer="'.$_REQUEST['double_answer'].'",skip_category="'.$_REQUEST['skip_category'].'",forced_release="'.$_REQUEST['forced_release'].'",charge_calls="'.$_REQUEST['charge_calls'].'",ani_first="'.$_REQUEST['ani_first'].'",backward_timeout="'.$_REQUEST['backward_timeout'].'",pulse_timeout='.$_REQUEST['pulse_timeout'].',call_files="'.$_REQUEST['call_files'].'"';;
				
				$data->update_table($r2->db,'r2_profile',$update_param,$where);
			}
			else {
				$profiles = $data->array_select_statement ($r2->db, 'r2_profile', 'count(*)', '');
				$count = $profiles[0]['count(*)'];
				settype($count,'integer');
				$id = $count+1;
				
				//insert record
				$param = "id,profile_name,varient,ani_length,dnis_length,category,collect_calls,immediate_accept,double_answer,skip_category,forced_release,charge_calls,ani_first,backward_timeout,pulse_timeout,call_files";
				$values = $id.',"'.$_REQUEST['profile_name'].'","'.$_REQUEST['varient'].'",'.$_REQUEST['ani_length'].','.$_REQUEST['dnis_length'].',"'.$_REQUEST['category'].'","'.$_REQUEST['collect_calls'].'","'.$_REQUEST['immediate_accept'].'","'.$_REQUEST['double_answer'].'","'.$_REQUEST['skip_category'].'","'.$_REQUEST['forced_release'].'","'.$_REQUEST['charge_calls'].'","'.$_REQUEST['ani_first'].'","'.$_REQUEST['backward_timeout'].'",'.$_REQUEST['pulse_timeout'].',"'.$_REQUEST['call_files'].'"';
				
				$data->insert_statement($r2->db,'r2_profile',$param,$values);
			}
			$_SESSION['last_profile'] = $_REQUEST['profile_name'];
			//Redirects to viewing all profiles page
			header( 'Location:view_r2_profiles.php' ) ;		
		}
	}
	if ($_REQUEST['back'] == "Cancel") {
		unset($_SESSION['r2_id']);
		//Redirects to hardware probe
		header( 'Location:view_r2_profiles.php' ) ;
	}


	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';
		include '../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("Create R2 Profile", "../../style.css");		
	}	
		
	$r2->display($data);	
		
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:../index.php' ) ;
}

?>