<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Starts PHP Sessions
session_start();
	
if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{	
	$db_location = "sqlite:../sqlite/cardinfo.db";
	$analog_table = "analog_profile";
	
	//Include Statements
	include '../database_classes.php';
	include 'analog_view_profile_class.php';
	
	//PHP Class Constructors
	$data = new database_class;	
	$analog_view = new analog_view_profile_class;
	
	//Holds the number of entries variable
	$num_entries = $_SESSION['num_entries'];
	
	$_SESSION['id_num'] = "";
	
	//If back button pressed
	if ($_REQUEST['back'] == "Go Back to Hardware Information")
	{
		unset ($_SESSION['last_profile']);
		//Redirects to hardware probe
		header( 'Location:../wanrouterhwprobe.php' );
	}
	
	//If create profile clicked on
	if ($_REQUEST['create'] == "Create New Profile")
	{
		//Redirects to hardware probe
		header( 'Location:create_analog_profile.php' );
	}
	
	//Goes through the request variables and checks what was clicked on
	foreach ($_REQUEST as $key => $value)
	{	
		//Parameters needed for all if statements
		$table_name =  $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_signalling";
				
		//Checks to see which module is in use
		if ($_SESSION['dahdi'] == "True")
		{	
			if ($_SESSION['card_clicked'] == "B700")
			{
				$create_param = "id int primary key, dev_name varchar(60), profile_name varchar(60), conn_type varchar(10), sig_type varchar(10), interface varchar(10), switchtype varchar(30), tei int, channels varchar(60), group_num int, context varchar(60), codec varchar(10), operation_mode varchar(10)";	
			}
			elseif ($_SESSION['card_clicked'] == "B601")
			{
				$create_param = "port_id int primary key, dev_name varchar(60), profile_name varchar(60), line_type varchar(10), signalling varchar(60), channels varchar(60), group_num int, context varchar(60), codec varchar(10), operation_mode varchar(10)";				
			}
			else
			{
				$create_param = "port_id int primary key, dev_name varchar(60), profile_name varchar(60), codec varchar(10), operation_mode varchar(10), group_num int, context varchar(30)";				
			}
		}
		elseif ($_SESSION['freetdm'] == "True")
		{
			if ($_SESSION['card_clicked'] == "B700")
			{
				$create_param = "id int primary key,  dev_name varchar(60), profile_name varchar(60), conn_type varchar(10), sig_type varchar(10), interface varchar(10), switchtype varchar(30), tei int, overlap varchar(10), ton_name varchar(100), ton_value varchar(100), npi_name varchar(100), npi_value varchar(100), bearer_ITC varchar(30), bearer_UIL varchar(30), msn varchar(100), channels varchar(60), group_num int, codec varchar(10), operation_mode varchar(10)";
			}
			elseif ($_SESSION['card_clicked'] == "B601")
			{
				$create_param = "port_id int primary key, dev_name varchar(60), profile_name varchar(60), line_type varchar(10), signalling varchar(60), channels varchar(60), group_num int, ton_name varchar(30), ton_value varchar(30),  npi_name varchar(30), npi_value varchar(30), facility varchar(10), facility_timeout int, bearer_ITC varchar(30), bearer_UIL varchar(30), codec varchar(10), operation_mode varchar(10)";				
			}
			else
			{
				$create_param = "port_id int primary key,  dev_name varchar(60), profile_name varchar(60), codec varchar(10), operation_mode varchar(10), group_num int";
			}

		}

		$dev_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'];

		//Check to see if the Signalling table for that card exists
		$perm_exists = $data->check_for_table ($db_location, $table_name);
		
		//echo $perm_exists;
		
		if ($perm_exists < 2)
		{
			//Creates the permanent Database
			$perm_table_name = "perm_" . $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_signalling";		
			$data->create_table($db_location, $perm_table_name, $create_param);		
		}

		//Check to see if the Signalling table for that card exists
		$exists = $data->check_for_table ($db_location, $table_name);
		
		for ($x = 0; $x <= $num_entries+100; $x++)
		{
			//$x = the bri_profile line number			
			//Checks to see which Delete button was pressed
			if ($key == "delete$x" && $value == "Delete Profile")
			{
				$table_name = "analog_profile";
				$param = "id = $x";
				$data->delete_generic($db_location, $table_name, $param);
			}
			if ($key == "config$x" && $value == "Edit Profile")
			{
				//Takes the last value in the key to know the database ID number clicked
				$rest = substr($key, -1);
				
				//Sets the ID number into a session variable to go to the redirection and edit the profile
				$_SESSION['id_num'] = $rest;
			
				//Redirects to the create profile page
				header( 'Location:create_analog_profile.php' ) ;
			}
			//Clicked when user wants to use a BRI Profile
			if ($key == "use$x" && $value == "Use")
			{
				$port = $_SESSION['port_num_clicked'];
				//echo $port;
				$exists = $data->check_for_table ($db_location, $table_name);

				$param = "*";
				$where_param = "id = " . $x;
				$values = $data->select_statement ($db_location, "analog_profile", $param, $where_param);
				
				//Checks which module is installed and creates the database as per that module

				if ($_SESSION['card_clicked'] == "B700")
				{	
					$update_where = "id = $port";	
					$insert_param = "id, dev_name, conn_type, profile_name, codec, operation_mode";
					$update_param = "id = " . $port . ", dev_name = \"" . $dev_name . "\", conn_type = \"" . $_SESSION['bri_type'] . "\", profile_name = \"" . $values['profile_name'] . "\", codec = \"" . $values['codec'] . "\", operation_mode = \"" . $values['operation_mode'] . "\"";
					$insert_values = "" . $port . ", \"" . $dev_name . "\", \"" . $_SESSION['bri_type'] . "\", \"" . $values['profile_name'] . "\", \"" . $values['codec'] . "\", \"" . $values['operation_mode'] . "\"";													
				}
				elseif ($_SESSION['card_clicked'] == "B601")
				{
					$update_where = "port_id = $port";	
					$insert_param = "port_id, dev_name , profile_name, codec, operation_mode";
					$update_param = "port_id = " . $port . ", dev_name = \"" . $dev_name . "\", profile_name = \"" . $values['profile_name'] . "\", codec = \"" . $values['codec'] . "\", operation_mode = \"" . $values['operation_mode'] . "\"";
					$insert_values = "" . $port . ", \"" . $dev_name . "\", \"" . $values['profile_name'] . "\", \"" . $values['codec'] . "\", \"" . $values['operation_mode'] . "\"";													
				}
				else
				{
					$update_where = "port_id = 1";	
					$insert_param = "port_id, dev_name , profile_name, codec, operation_mode";
					$update_param = "port_id = 1, dev_name = \"" . $dev_name . "\", profile_name = \"" . $values['profile_name'] . "\", codec = \"" . $values['codec'] . "\", operation_mode = \"" . $values['operation_mode'] . "\"";
					$insert_values = "1, \"" . $dev_name . "\", \"" . $values['profile_name'] . "\", \"" . $values['codec'] . "\", \"" . $values['operation_mode'] . "\"";													
				}
			
				if ($exists < 2)
				{
					//Table doesn't exist
					//Create the table
					$data->create_table($db_location, $table_name, $create_param);
					
					//Insert the line
					$data->insert_statement($db_location, $table_name, $insert_param, $insert_values);
				}
				elseif ($exists > 1)
				{
					if ($_SESSION['card_clicked'] == "B700")
					{	
						if ($_SESSION['dahdi'] == "True")
						{	
							$insert_parameter = "id , dev_name , profile_name , conn_type , sig_type , interface , switchtype , tei , channels , group_num , context , codec , operation_mode ";	
							$data->check_schema($db_location, $table_name, $create_param, "13", $insert_parameter);					
						}
						elseif ($_SESSION['freetdm'] == "True")
						{
							$insert_parameter = "id,  dev_name , profile_name , conn_type , sig_type , interface, switchtype , tei , overlap , ton_name, ton_value, npi_name, npi_value, bearer_ITC, bearer_UIL, msn , channels, group_num , codec, operation_mode ";
							$data->check_schema($db_location, $table_name, $create_param, "20", $insert_parameter);											
						}						
					}
					elseif ($_SESSION['card_clicked'] == "B601")
					{
						if ($_SESSION['dahdi'] == "True")
						{
							$insert_parameter = "port_id, dev_name, line_type, signalling , channels, group_num , context, codec , operation_mode ";
							$data->check_schema($db_location, $table_name, $create_param, "9", $insert_parameter);							
						}
						elseif ($_SESSION['freetdm'] == "True")
						{
							$insert_parameter = "port_id , dev_name , profile_name , line_type , signalling , channels , group_num , ton_name , ton_value ,  npi_name , npi_value , facility , facility_timeout , bearer_ITC , bearer_UIL , codec , operation_mode ";
							$data->check_schema($db_location, $table_name, $create_param, "17", $insert_parameter);							
						}						
					}
					else
					{
						if ($_SESSION['dahdi'] == "True")
						{	
							$insert_parameter = "port_id , dev_name , profile_name , codec, operation_mode , group_num , context ";
							$data->check_schema($db_location, $table_name, $param, "7", $insert_parameter);				
						}
						elseif ($_SESSION['freetdm'] == "True")
						{
							$insert_parameter = "port_id , dev_name , profile_name , codec, operation_mode , group_num";
							$data->check_schema($db_location, $table_name, $param, "6", $insert_parameter);											
						}							
					}					
					
					//Checks to see if the line exists
					if ($_SESSION['card_clicked'] == "B700")
					{
						$sig_param = "id = $port";
						$sig_table = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_signalling"; 
						$param = "id";
					}
					else
					{
						$sig_param = "port_id = $port";
						$sig_table = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_signalling"; 
						$param = "port_id";
					}
					$sig_info = $data->select_statement ($db_location, $sig_table, $param, $sig_param);						
					
					if ($_SESSION['card_clicked'] == "B700")
					{
						if ($sig_info['id'] != "")
						{
							//Port ID found, please update that port
							$data->update_table($db_location,$table_name, $update_param, $update_where);
						}
						if ($sig_info['id'] == "")
						{
							//echo "I am here <br />";
							//Insert the line
							$data->insert_statement($db_location, $table_name, $insert_param, $insert_values);
						}
					}
					else
					{
						if ($sig_info['port_id'] != "")
						{
							//Port ID found, please update that port
							$data->update_table($db_location,$table_name, $update_param, $update_where);
						}
						if ($sig_info['port_id'] == "")
						{
							//echo "I am here <br />";
							//Insert the line
							$data->insert_statement($db_location, $table_name, $insert_param, $insert_values);
						}						
					}
				}
				
				unset($_SESSION['last_profile']);
				header( 'Location:../wanrouterhwprobe.php' );
			}
		}
	}
	
	//Retrieve Profile Information
	$analog_view->get_profiles();
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';
		//include 'database_classes.php';	
		include '../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("View Analog Profiles", "../../../style.css");		
	}	

	//Display the profiles for the matching connection type (PTP/PTMP)
	$analog_view->display_profiles();
	
		//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:../index.php' ) ;
}

?>