<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Starts PHP Session
session_start();

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{	
	//Includes the File which contains classes
	include '../database_classes.php';	
	include '../display_class.php';
	include 'create_bri_class.php';
	
	//PHP Class Constructor
	$data = new database_class;
	$display = new config_PRI_Profiles;
	$bri = new create_bri_profile;
	
	$display->data = $data;
	$db_location = "sqlite:../sqlite/cardinfo.db";
	$table_name = "t1e1_profile";	
	
	//Retrieves the information from the view page
	if ($_SESSION['id_num'] != "")
	{
		$param = "*";
		$where_param = " id = " . $_SESSION['id_num'];
		$edit = $data->select_statement ($db_location, $table_name, $param, $where_param);
		//$_SESSION['profile_pri_num'] = $_SESSION['id_num'];
	}
	$value = $data->get_profiles("profile_name");
	$count = count($value);

	for ($a = 0; $a < $count; $a++)
		$returned_value[$a] = $value[$a]['profile_name'];

	//Checks if Cancel was pressed
	if ($_REQUEST['cancel'] == "Cancel Profile Creation" || $_REQUEST['cancel'] == "Cancel Profile Editing")
	{
		$_SESSION['id_num'] = "";
		
		//Redirects to viewing all profiles page
		header( 'Location:../profiles/view_profiles.php' ) ;		
	}
	
	//Checks if Create Profile was pressed and places in the database and redirects to view page
	if ($_REQUEST['create'] == "Create Profile" || $_REQUEST['create'] == "Save Profile")
	{
		//echo "Click Successful <br />";
		//Sets the Session Variable to a local variable
		//$id_num = $_SESSION['id_num'];
		$id_num = $_REQUEST['id_number'];
		
		//Validate information
		$error_counter = 0; //Error Counter
		
		if ($id_num == 0)
		{
			//Validates profile name
			for ($b = 0; $b < $a; $b++)
			{
				if (strtoupper($_REQUEST['profile_name']) == strtoupper($returned_value[$b]))
				{
					$error['profile_name'] = "<font color=\"red\">" . $returned_value[$b] . " exists. Please select another Profile Name</font>";
					$error_counter++;
				}
			}
		}

		//Checks the BRI profile table to see if there is a conflicting profile name in there
		$bri_profiles = $data->get_BRI_profiles();
		$counter = count($bri_profiles);
		
		for ($z = 0; $z < $counter; $z++)
		{	
			if (strtoupper($bri_profiles[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
			{
				$error['profile_name'] = "<font color=\"red\">" . $returned_value[$b] . " exists. Please select another Profile Name</font>";
				$error_counter++;
			}
							
		}
		
		//Checks the Analog profile table to see if there is a conflicting profile name in there
		$bri_profiles = $bri->get_analog_profiles();
		$counter = count($bri_profiles);
		
		for ($z = 0; $z < $counter; $z++)
		{	
			if (strtoupper($bri_profiles[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
			{
				$error['profile_name'] = "<font color=\"red\">" . $returned_value[$b] . " exists. Please select another Profile Name</font>";
				$error_counter++;
			}
							
		}		
		
		//Makes sure the user enters a profile name
		if ($_REQUEST['profile_name'] == "" && isset($_REQUEST['profile_name']))
		{
			$error['profile_name'] = "<font color=\"red\">Please Enter a Profile Name</font>";
			$error_counter++;
		}
		
		//Checks if you chose the right protocol and the right switchtype
		if ($_REQUEST['protocol'] == "CCS" && $_REQUEST['switchtype'] == "E&MWink")
		{
			$error['protocol'] = "<font color=\"red\">". $_REQUEST['protocol'] . " cannot be used if " . $_REQUEST['switchtype'] ." is used</font>";
			$error_counter++;
		}
		elseif ($_REQUEST['protocol'] == "CAS" && $_REQUEST['switchtype'] == "EuroISDN")
		{
			$error['protocol'] = "<font color=\"red\">" . $_REQUEST['protocol'] . " cannot be used if " . $_REQUEST['switchtype'] . " is used</font>";
			$error_counter++;
		}
		elseif ($_REQUEST['line_type'] == "E1" && $_REQUEST['protocol'] == "")
		{
			$error['protocol'] = "<font color=\"red\">Please Select a Protocol</font>";
			$error_counter++;
		}
		
		//Checks if you chose a switchtype when you weren't supposed to for E&M Wink
		if ($_REQUEST['signalling'] == "E&MWink" && $_REQUEST['switchtype'] != "E&MWink")
		{
			$error['switchtype'] = "<font color=\"red\">E&M Wink Selected. Cannot use another signalling type or switch type other then E&M Wink";
			$error_counter++;
		}
		elseif ($_REQUEST['switchtype'] == "E&MWink" && $_REQUEST['signalling'] != "E&MWink")
		{
			$error['switchtype'] = "<font color=\"red\">E&M Wink Selected. Cannot use another signalling type or switch type other then E&M Wink";
			$error_counter++;
		}	
		elseif ($_REQUEST['switchtype'] == "")
		{
			$error['switchtype'] = "<font color=\"red\">Please Select a Switchtype</font>";
			$error_counter++;
		}	
		
		if ($_REQUEST['facility'] == "no" && $_REQUEST['facility_timeout'] > 0)
		{
			$error['facility'] = "<font color=\"red\">Please <strong>ENABLE</strong> Facility messages in order to enter a timeout</font>";
			$error_counter++;
		}
		
		if (!is_numeric($_REQUEST['facility_timeout']) && $_REQUEST['facility_timeout'] != "")
		{
			$error['facility_timeout'] = "<font color=\"red\">Please enter a <strong>NUMERIC</strong> value for the Facility Timeout</font>";
			$error_counter++;
		}	
		if ($_REQUEST['facility_timeout'] < 0 || $_REQUEST['facility_timeout'] > 500)
		{
			$error['facility_timeout'] = "<font color=\"red\">Please enter a numerical value between 0 and 500</font>";
			$error_counter++;
		}
		
		
		//If validation passes, go back to main view page and put in database
		//If it fails, go back and ask the user to re-input the data
		if ($error_counter == 0)
		{
			$_SESSION['profile_pri_num'] = $_REQUEST['id_number'];
			
			//echo "No Errors <br />";
			//Finds the last id used
			$param = "id";
			$id = $data->select_statement ($db_location, $table_name, $param, "");
			//echo "ID = $id[0]<br />";
			//Increments the ID by 1
			//$id[0]++;

			$profile_name = $_REQUEST['profile_name'];
			$line_type = $_SESSION['line_type'];
			$protocol = $_REQUEST['protocol'];
			$switchtype = $_REQUEST['switchtype'];
			$signalling = $_REQUEST['signalling'];
			$facility = $_REQUEST['facility'];
			$facility_timeout = $_REQUEST['facility_timeout'];
			$bearer_ITC = $_REQUEST['bearer_ITC'];
			$bearer_UIL = $_REQUEST['bearer_UIL'];
			$overlap = $_REQUEST['overlap'];
			
			$_SESSION['last_profile'] = $profile_name;

			if ($_REQUEST['ton_value1'] != "")
				$_REQUEST['ton_name1'] = "outbound-called-ton";
			if ($_REQUEST['ton_value2'] != "")
				$_REQUEST['ton_name2'] = "outbound-calling-ton";
			if ($_REQUEST['ton_value3'] != "")
				$_REQUEST['ton_name3'] = "outbound-rdnis-ton";
			
			if ($_REQUEST['npi_value1'] != "")
				$_REQUEST['npi_name1'] = "outbound-called-npi";
			if ($_REQUEST['npi_value2'] != "")
				$_REQUEST['npi_name2'] = "outbound-calling-npi";
			if ($_REQUEST['npi_value3'] != "")
				$_REQUEST['npi_name3'] = "outbound-rdnis-npi";

			//Analyzes the TON and NPI values			
			$ton_name = $bri->combine_ton_name();
			$npi_name = $bri->combine_npi_name();
			$npi_value = $bri->combine_npi_value();
		 	$ton_value = $bri->combine_ton_value();

			//echo "\"" . $ton_name . "\",\"" . $ton_value . "\",\"" . $npi_name . ",\"" . $npi_value . "\"";

			if ($_SESSION['line_type'] == "T1")
				$protocol = "CCS";
			
			
			if ($_SESSION['freetdm'] == "True")
			{
				$insert_parameters = "id, profile_name, line_type, protocol, switchtype, signalling, ton_name, ton_value,  npi_name, npi_value, facility, facility_timeout, bearer_ITC, bearer_UIL, overlap, transfer";
				$insert_values = "$id_num, \"$profile_name\", \"$line_type\", \"$protocol\", \"$switchtype\", \"$signalling\", \"$ton_name\", \"$ton_value\", \"$npi_name\", \"$npi_value\", \"$facility\", \"$facility_timeout\", \"$bearer_ITC\", \"$bearer_UIL\", \"$overlap\", \"" . $_REQUEST['transfer'] . "\"";
				$update_parameters = "line_type=\"$line_type\", protocol=\"$protocol\", switchtype=\"$switchtype\", signalling=\"$signalling\", ton_name=\"$ton_name\", ton_value=\"$ton_value\", npi_name=\"$npi_name\", npi_value=\"$npi_value\", facility = \"$facility\", facility_timeout = \"$facility_timeout\", bearer_ITC = \"$bearer_ITC\", bearer_UIL = \"$bearer_UIL\", overlap=\"$overlap\", transfer =\"" . $_REQUEST['transfer'] . "\"";
				$update_where_param = "id = $id_num";
			}
			elseif ($_SESSION['dahdi'] == "True")
			{
			}

			if ($_REQUEST['edit_profile'] != "yes")
				$data->insert_statement($db_location, $table_name, $insert_parameters, $insert_values);				
			//if ($id_num > 0)
			else
				$data->update_table ($db_location, $table_name, $update_parameters, $update_where_param);

			//Redirects to viewing all profiles page
			header( 'Location:../profiles/view_profiles.php' ) ;			
		}
		elseif ($error_counter > 0 )
		{
			//echo "found error <br />";
		}
	}

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
		
		//If statement that controls the HTML Title
		if ($_SESSION['id_num'] == "") 
			$title = $_SESSION['line_type'] . " PRI Profile Creation"; 
		else 
			$title = $_SESSION['line_type'] . " PRI Profile Edit"; 
				
		//ClearOS Integration
		$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title($title, "../../../style.css");		
	}

	//T1/E1 Profile Creation Page
	$display->display_PRI_profile_options($edit, $error, $_REQUEST);

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:../index.php' ) ;
}
?>