<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class create_analog_profile
{
	
	private $error= "";				//Contains validation errors
	public $error_counter="";		//Contains the number of errors in the form
	public $edit="";				//Contains database returned values for editing
	private $interface="";			//Contains the Interface
	public $profile_name = array();	//Contains the profile names within the database
	public $profile_counter = "";	//Contains the number of profiles in the database
	private $pick="";				//Contains the data for what was returned to the form
	
	//Display function
	function display()
	{
		if ($_SESSION['id_num'] == "") 
		{ 
			echo "<h3>Analog Profile Creation</h3>";		
		} 
		else 
		{ 
			echo "<h3>Analog Profile - Edit</h3>"; 
		} 
		
		if ($_SESSION['profile_analog_num'] == "")
		{
			$a = 1;
			//$_SESSION['profile_num'] = $a;
		}
		elseif ($_SESSION['profile_analog_num'] != "")
		{
			$a = $_SESSION['profile_analog_num'];
			$a++;
			//$_SESSION['profile_num'] = $a;
		}
		
		$this->check_submit();
		
		?>
	<p>
    	Please enter the Signalling Level configuration in order to generate a valid Analog Profile.<br />
        Advanced options are available for your Analog Profile. They are populated with their default values, but you may change them if required.
    </p>
	<form name="create_profile" method="post">
    	<input type="hidden" name="id_number" value="<?php echo $a; ?>" />
		<hr style='width:700px;' align='left'/>    		
       <h4>Standard Options</h4>    
		<table>
			<tr>
				<td>Profile Name</td>
                <td></td>
				<td align="right"><input type="text" name="profile_name" value="<?php if ($this->edit['profile_name'] != "") { echo $this->edit['profile_name']; } elseif($_REQUEST['profile_name'] == "") { echo "New Analog Profile$a"; } else { echo $_REQUEST['profile_name']; } ?>" style="text-align:right"/></td>
				<td><?php echo $this->error['profile_name']; ?></td>
			</tr>            
			<tr>
				<td>Interface</td>
                <td></td>
				<td align="right">
                	<select name="codec" style="text-align:right">
                    	<option value="">Select a Codec</option>
                    	<option value="MULAW" <?php if ($this->pick['codec_mulaw'] == "yes") { ?> selected=selected <?php }  ?> style="text-align:right" >MULAW</option>
                        <option value="ALAW" <?php if ($this->pick['codec_alaw'] == "yes") { ?> selected=selected <?php } ?> style="text-align:right" >ALAW</option>
                    </select>
				</td>
				<td><?php echo $this->error['codec']; ?></td>                                        
			</tr>            
			<tr>
				<td>Operation Mode</td>
                <td></td>
				<td align="right">
					<select name="operation_mode" style="text-align:right">
                    	<option value="">Select an Operation Mode</option>
						<option value="FCC" <?php if ($this->pick['operation_mode_fcc'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right" >FCC</option>
                        <option value="TBR21" <?php if ($this->pick['operation_mode_tbr21'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right" >TBR21</option>
            			<option value="Australia" <?php if ($this->pick['operation_mode_austrailia'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right" >Australia</option>
                    </select>
				</td>
                <td><?php echo $this->error['operation_mode'];?></td>
			</tr>
       </table>
       <br />
       <hr style='width:700px;' align='left'/>
            <div class="fakelink"
                    id="show_e"
                    onclick="this.style.display='none';
                    document.getElementById('hide_e').style.display='block';
                    document.getElementById('options').style.display='inline';
                    ">&raquo; Show Advanced Options</div>
            <div class="fakelink"
                    id="hide_e"
                    onclick="this.style.display='none';
                    document.getElementById('show_e').style.display='block';
                    document.getElementById('options').style.display='none';
                    ">&raquo; Hide Advanced Options</div>
            <div id="options">       
	   <br />
       <font color="red">NOTE: These options are set to their default parameters and shouldn't be changed unless required.</font><br />
       <table>
       		<tr>
            	<td>Hangup Polarity Reversal</td>
                <td></td>
                <td align="right">
                	<select name="hangup_polarity" style="text-align:right">
                    	<option value="hangup_enable_fxo" <?php if ($this->pick['hangup_polarity_fxo_enable'] == "yes") { ?> selected="selected" <?php } ?>  style="text-align:right" >Enable for FXO</option>
                    	<option value="hangup_enable_fxs" <?php if ($this->pick['hangup_polarity_fxs_enable'] == "yes") { ?> selected="selected" <?php } ?>  style="text-align:right" >Enable for FXS</option>
                    	<option value="hangup_enable_both" <?php if ($this->pick['hangup_polarity_both_enable'] == "yes") { ?> selected="selected" <?php } ?>  style="text-align:right" >Enable for FXO & FXS</option>
                        <option value="hangup_disable" <?php if ($this->pick['hangup_polarity_disable'] == "yes") { ?> selected="selected" <?php } ?>  style="text-align:right" >Disable</option>
                    </select>
                </td>
            </tr>
       		<tr>
            	<td>Answer Polarity Reversal</td>
                <td></td>
                <td align="right">
                	<select name="answer_polarity" style="text-align:right">
                    	<option value="answer_enable_fxo" <?php if ($this->pick['answer_polarity_fxo_enable'] == "yes") { ?> selected="selected" <?php } ?>  style="text-align:right" >Enable for FXO</option>
                    	<option value="answer_enable_fxs" <?php if ($this->pick['answer_polarity_fxs_enable'] == "yes") { ?> selected="selected" <?php } ?>  style="text-align:right" >Enable for FXS</option>
                    	<option value="answer_enable_both" <?php if ($this->pick['answer_polarity_both_enable'] == "yes") { ?> selected="selected" <?php } ?>  style="text-align:right" >Enable for FXO & FXS</option>
                        <option value="answer_disable" <?php if ($this->pick['answer_polarity_disable'] == "yes") { ?> selected="selected" <?php } ?>  style="text-align:right" >Disable</option>
                    </select>
                </td>
            </tr>
            <tr>
            	<td>FXO Polarity Reversal Delay (ms)</td>
                <td></td>
                <td align="right"><input type="text" name="polarity_delay" value="<?php if ($this->edit['polarity_delay'] != "") { echo $this->edit['polarity_delay']; } elseif($_REQUEST['polarity_delay'] != "") { echo $_REQUEST['polarity_delay']; } else { echo "600"; }?>" style="text-align:right"/> </td>
                <td><?php echo $this->error['polarity_delay']; ?></td>
            </tr>            
            <tr>
            	<td>Caller ID</td>
                <td></td>
                <td align="right">
                	<select name="callerid" style="text-align:right">
                    	<option value="enable" <?php if ($this->pick['callerid_enable'] == "yes") { ?> selected="selected" <?php } ?>   style="text-align:right" >Enable</option>
                        <option value="disable" <?php if ($this->pick['callerid_disable'] == "yes") { ?> selected="selected" <?php } ?>   style="text-align:right" >Disable</option>
                    </select>
                </td>
            </tr>
       		<tr>
            	<td>Call Waiting</td>
                <td></td>
                <td align="right">
                	<select name="call_waiting" style="text-align:right">
                    	<option value="enable" <?php if ($this->pick['call_waiting_enable'] == "yes") { ?> selected="selected" <?php } ?>  style="text-align:right" >Enable</option>
                        <option value="disable" <?php if ($this->pick['call_waiting_disable'] == "yes") { ?> selected="selected" <?php } ?>  style="text-align:right" >Disable</option>
                    </select>
                </td>
            </tr>            
            <tr>
            	<td>Tone Group</td>
                <td></td>
                <td align="right">
                	<select name="tones" style="text-align:right">
                    	<option value="us" <?php if ($this->pick['tones_us'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right" >United States</option>
                        <option value="sg" <?php if ($this->pick['tones_sg'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right" >Singapore</option>
                        <option value="ru" <?php if ($this->pick['tones_ru'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right" >Russia</option>
                    </select>
                </td>
            </tr>
            <tr>
            	<td>Three Way Calling</td>
                <td></td>
                <td align="right">
                	<select name="three-way" style="text-align:right">
                    	<option value="enable" <?php if ($this->pick['three-way_disable'] == "yes") { ?> selected="selected" <?php } ?>  style="text-align:right" >Enable</option>
                        <option value="disable" <?php if ($this->pick['three-way_disable'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right" >Disable</option>
                    </select>
                </td>
                <td><?php echo $this->error['three-way']; ?></td>
            </tr>            
            <tr>
            	<td>Call Swapping</td>
                <td></td>
                <td align="right">
                	<select name="call-swap" style="text-align:right">
                    	<option value="enable" <?php if ($this->pick['call-swap_disable'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right" >Enable</option>
                        <option value="disable" <?php if ($this->pick['call-swap_disable'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right" >Disable</option>
                    </select>
                </td>
            </tr> 
            <tr>
            	<td>FXS Digit Timeout</td>
                <td></td>
                <td align="right"><input type="text" name="digit_timeout" value="<?php if ($this->edit['digit_timeout'] != "") { echo $this->edit['digit_timeout']; } elseif($_REQUEST['digit_timeout'] != "") { echo $_REQUEST['digit_timeout']; }?>" style="text-align:right"/> </td>
                <td><?php echo $this->error['digit_timeout']; ?></td>
            </tr>
            <tr>
            	<td>FXS Maximum Digits</td>
                <td></td>
                <td align="right"><input type="text" name="max_digits" value="<?php if ($this->edit['max_digits'] != "") { echo $this->edit['max_digits']; } elseif($_REQUEST['max_digits'] != "") { echo $_REQUEST['max_digits']; }?>" style="text-align:right"/> </td>
                <td><?php echo $this->error['max_digits']; ?></td>
            </tr>            
       </table>
       </div>
       <hr style='width:700px;' align='left'/>
        <table width="700px">
        <tr>
        <td width="1%"><input type="submit" name="create" value="<?php if ($_SESSION['id_num'] == "") { echo "Create Profile"; } else { echo "Save Profile"; } ?>" <?php echo $_SESSION['button_class']; ?>/></td>
		<td align="right"><input type="submit" name="cancel" value="<?php if ($_SESSION['id_num'] == "") { echo "Cancel Profile Creation"; } else { echo "Cancel Profile Editing"; } ?>" <?php echo $_SESSION['button_class']; ?>/></td>
        </tr>
        </table>
	</form>         
	<?php
	}	
	
	//Validates the Form
	function validation()
	{
		
		//Grab the profile name and make sure there isn't a profile already in the database
		//Only to occur if you are making a new profile
		if ($_SESSION['id_num'] == 0)
		{
			//Calls the profile class
			$this->get_bri_profiles();
			
			for ($z = 0; $z <= $this->profile_counter; $z++)
			{
				if (strtoupper($this->profile_name[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
				{
					$this->error['profile_name'] = "<font color=\"red\">Profile already <strong>EXISTS</strong>. Please use a different profile name</font>";
					$this->error_counter++;
				}
			}
			
			$this->get_t1_e1_profiles();
			
			for ($z = 0; $z <= $this->profile_counter; $z++)
			{
				if (strtoupper($this->profile_name[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
				{
					$this->error['profile_name'] = "<font color=\"red\">Profile already <strong>EXISTS</strong>. Please use a different profile name</font>";
					$this->error_counter++;
				}
			}
			
			$this->get_analog_profiles();
			
			for ($z = 0; $z <= $this->profile_counter; $z++)
			{
				if (strtoupper($this->profile_name[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
				{
					$this->error['profile_name'] = "<font color=\"red\">Profile already <strong>EXISTS</strong>. Please use a different profile name</font>";
					$this->error_counter++;
				}
			}			
			
		}
		
		//Makes sure the user enters a profile name
		if ($_REQUEST['profile_name'] == "")
		{
			$this->error['profile_name'] = "<font color=\"red\">Please Enter a Profile Name</font>";
			$this->error_counter++;
		}
		
		if ($_REQUEST['codec'] == "")
		{
			$this->error['codec'] = "<font color=\"red\">Please select a <strong>CODEC</strong></font>";
			$this->error_counter++;
		}
				
		if ($_REQUEST['operation_mode'] == "")
		{
			$this->error['operation_mode'] = "<font color=\"red\">Please select an <strong>OPERATION MODE</strong></font>";
			$this->error_counter++;
		}	
		
		if ($_REQUEST['digit_timeout'] != "" && !is_numeric($_REQUEST['digit_timeout']))
		{
			$this->error['digit_timeout'] = "<font color=\"red\">Please enter a <strong>NUMERIC</strong> value for the <strong>FXS Digit Timeout</strong></font>";
			$this->error_counter++;
		}	
		
		if ($_REQUEST['three-way'] == "enable" && $_REQUEST['call-swap'] == "enable")
		{
			$this->error['three-way'] = "<font color=\"red\">Cannot use <b>Three Way Calling</b> and <b>Call Swapping</b> together.<br /> Please choose one or the other</font>";
			$this->error_counter++;			
		}
		
		if ($_REQUEST['max_digits'] != "" && !is_numeric($_REQUEST['max_digits']))
		{
			$this->error['max_digits'] = "<font color=\"red\">Please enter a <strong>NUMERIC</strong> value for the <strong>FXS Maximum Digits</strong></font>";
			$this->error_counter++;
		}	
		
		if (!is_numeric($_REQUEST['polarity_delay']))
		{
			$this->error['polarity_delay'] = "<font color=\"red\">Please enter a <strong>NUMERIC</strong> value for the <strong>Polarity Reversal Delay</strong></font>";
			$this->error_counter++;
		}

	}
	
	//Retrieves all the BRI Profile Names
	function get_bri_profiles()
	{
		$db_location = "sqlite:../sqlite/cardinfo.db";
		$table_name = "bri_profile";
		$a = 0;

		$select = "SELECT profile_name FROM " . $table_name . ";";

		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$this->profile_name[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}

		$this->profile_counter = $a;
	}	
	
	//Retrieves all the BRI Profile Names
	function get_t1_e1_profiles()
	{
		$db_location = "sqlite:../sqlite/cardinfo.db";
		$table_name = "t1e1_profile";
		$a = 0;

		$select = "SELECT profile_name FROM " . $table_name . ";";

		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$this->profile_name[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}

		$this->profile_counter = $a;
	}		
	
	//Retrieves all the Analog Profile Names
	function get_analog_profiles()
	{
		$db_location = "sqlite:../sqlite/cardinfo.db";
		$table_name = "analog_profile";
		$a = 0;

		$select = "SELECT profile_name FROM " . $table_name . ";";

		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$this->profile_name[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}

		$this->profile_counter = $a;
	}	
	
	function check_submit()
	{
		
		if ($_REQUEST['codec'] == "MULAW")
		{
			$this->pick['codec_mulaw'] = "yes";
		}
		elseif ($_REQUEST['codec'] == "ALAW")
		{
			$this->pick['codec_alaw'] = "yes";
		}
		elseif ($this->edit['codec'] == "MULAW")
		{
			$this->pick['codec_mulaw'] = "yes";
		}
		elseif ($this->edit['codec'] == "ALAW")
		{
			$this->pick['codec_alaw'] = "yes";
		}
		
		if ($_REQUEST['hangup_polarity'] == "" && $this->edit['hangup_polarity'] == "")
		{
			$this->pick['hangup_polarity_disable'] = "yes";
		}
		elseif ($_REQUEST['hangup_polarity'] == "hangup_enable_fxo")
		{
			$this->pick['hangup_polarity_fxo_enable'] = "yes";
		}
		elseif ($_REQUEST['hangup_polarity'] == "hangup_enable_fxs")
		{
			$this->pick['hangup_polarity_fxs_enable'] = "yes";
		}
		elseif ($_REQUEST['hangup_polarity'] == "hangup_enable_both")
		{
			$this->pick['hangup_polarity_both_enable'] = "yes";
		}				
		elseif ($_REQUEST['hangup_polarity'] == "disable")
		{
			$this->pick['hangup_polarity_disable'] = "yes";
		}
		elseif ($this->edit['hangup_polarity'] == "hangup_enable_fxo")
		{
			$this->pick['hangup_polarity_fxo_enable'] = "yes";
		}
		elseif ($this->edit['hangup_polarity'] == "hangup_enable_fxs")
		{
			$this->pick['hangup_polarity_fxs_enable'] = "yes";
		}
		elseif ($this->edit['hangup_polarity'] == "hangup_enable_both")
		{
			$this->pick['hangup_polarity_both_enable'] = "yes";
		}				
		elseif ($this->edit['hangup_polarity'] == "disable")
		{
			$this->pick['hangup_polarity_disable'] = "yes";
		}
		
		if ($_REQUEST['answer_polarity'] == "" && $this->edit['answer_polarity'] == "")
		{
			$this->pick['answer_polarity_disable'] = "yes";
		}
		elseif ($_REQUEST['answer_polarity'] == "answer_enable_fxo")
		{
			$this->pick['answer_polarity_fxo_enable'] = "yes";
		}
		elseif ($_REQUEST['answer_polarity'] == "answer_enable_fxs")
		{
			$this->pick['answer_polarity_fxs_enable'] = "yes";
		}
		elseif ($_REQUEST['answer_polarity'] == "answer_enable_both")
		{
			$this->pick['answer_polarity_both_enable'] = "yes";
		}				
		elseif ($_REQUEST['answer_polarity'] == "disable")
		{
			$this->pick['answer_polarity_disable'] = "yes";
		}
		elseif ($this->edit['answer_polarity'] == "answer_enable_fxo")
		{
			$this->pick['answer_polarity_fxo_enable'] = "yes";
		}
		elseif ($this->edit['answer_polarity'] == "answer_enable_fxs")
		{
			$this->pick['answer_polarity_fxs_enable'] = "yes";
		}
		elseif ($this->edit['answer_polarity'] == "answer_enable_both")
		{
			$this->pick['answer_polarity_both_enable'] = "yes";
		}				
		elseif ($this->edit['answer_polarity'] == "disable")
		{
			$this->pick['answer_polarity_disable'] = "yes";
		}		
		
		if ($_REQUEST['callerid'] == "" && $this->edit['callerid'] == "")
		{
			$this->pick['callerid_enable'] = "yes";
		}
		elseif ($_REQUEST['callerid'] == "enable")
		{
			$this->pick['callerid_enable'] = "yes";
		}
		elseif ($_REQUEST['callerid'] == "disable")
		{
			$this->pick['callerid_disable'] = "yes";
		}
		elseif ($this->edit['callerid'] == "enable")
		{
			$this->pick['callerid_enable'] = "yes";
		}
		elseif ($this->edit['callerid'] == "disable")
		{
			$this->pick['callerid_disable'] = "yes";
		}
		
		if ($_REQUEST['call_waiting'] == "" && $this->edit['call_waiting'] == "")
		{
			$this->pick['call_waiting_disable'] = "yes";
		}
		elseif ($_REQUEST['call_waiting'] == "enable")
		{
			$this->pick['call_waiting_enable'] = "yes";
		}
		elseif ($_REQUEST['call_waiting'] == "disable")
		{
			$this->pick['call_waiting_disable'] = "yes";
		}
		elseif ($this->edit['call_waiting'] == "enable")
		{
			$this->pick['call_waiting_enable'] = "yes";
		}
		elseif ($this->edit['call_waiting'] == "disable")
		{
			$this->pick['call_waiting_disable'] = "yes";
		}		
				
		if ($_REQUEST['three-way'] == "" && $this->edit['three_way'] == "")
		{
			$this->pick['three-way_disable'] = "yes";
		}
		elseif ($_REQUEST['three-way'] == "enable")
		{
			$this->pick['three-way_enable'] = "yes";
		}
		elseif ($_REQUEST['three-way'] == "disable")
		{
			$this->pick['three-way_disable'] = "yes";
		}
		elseif ($this->edit['three_way'] == "enable")
		{
			$this->pick['three-way_enable'] = "yes";
		}
		elseif ($this->edit['three_way'] == "disable")
		{
			$this->pick['three-way_disable'] = "yes";
		}
		
		if ($_REQUEST['call-swap'] == "" && $this->edit['call_swap'] == "")
		{
			$this->pick['call-swap_disable'] = "yes";
		}
		elseif ($_REQUEST['call-swap'] == "enable")
		{
			$this->pick['call-swap_enable'] = "yes";
		}
		elseif ($_REQUEST['call-swap'] == "disable")
		{
			$this->pick['call-swap_disable'] = "yes";
		}
		elseif ($this->edit['call_swap'] == "enable")
		{
			$this->pick['call-swap_enable'] = "yes";
		}
		elseif ($this->edit['call_swap'] == "disable")
		{
			$this->pick['call-swap_disable'] = "yes";
		}
						
		if ($_REQUEST['operation_mode'] == "FCC")
		{
			$this->pick['operation_mode_fcc'] = "yes";
		}
		elseif ($_REQUEST['operation_mode'] == "TBR21")
		{
			$this->pick['operation_mode_tbr21'] = "yes";
		}
		elseif ($_REQUEST['operation_mode'] == "Austrailia")
		{
			$this->pick['operation_mode_austrailia'] = "yes";
		}
		elseif ($this->edit['operation_mode'] == "FCC")
		{
			$this->pick['operation_mode_fcc'] = "yes";
		}
		elseif ($this->edit['operation_mode'] == "TBR21")
		{
			$this->pick['operation_mode_tbr21'] = "yes";
		}
		elseif ($this->edit['operation_mode'] == "Austrailia")
		{
			$this->pick['operation_mode_austrailia'] = "yes";
		}
		
		if ($_REQUEST['tones'] == "us")
		{
			$this->pick['tones_us'] = "yes";
		}
		elseif ($_REQUEST['tones'] == "sg")
		{
			$this->pick['tones_sg'] = "yes";
		}
		elseif ($_REQUEST['tones'] == "ru")
		{
			$this->pick['tones_ru'] = "yes";
		}
		elseif ($this->edit['tones'] == "us")
		{
			$this->pick['tones_us'] = "yes";
		}
		elseif ($this->edit['tones'] == "sg")
		{
			$this->pick['tones_sg'] = "yes";
		}
		elseif ($this->edit['tones'] == "ru")
		{
			$this->pick['tones_ru'] = "yes";
		}
		
		
	}
}