<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class analog_view_profile_class
{
	
	//Variable declarations
	private $counter = int;					//Contains the total number of profiles
	private $profile_array = array();		//Contains the Analog Profiles in an array	
	public $total_ports = int;				//Contains the total number of ports for the card in question
	public $conn_type = "";					//Contains the connection type for the port
	
	//Function that retrieves the BRI profiles from the database and stores it in a multi-dimensional array
	function get_profiles()
	{
		$db_location = "sqlite:../sqlite/cardinfo.db";
		$where_param = "";
		$table_name = "analog_profile";
		$a = 0;

		$select = "SELECT * FROM " . $table_name . ";";
		
		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$this->profile_array[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}

		$this->counter = $a;
	}
	
	function display_profiles()
	{
		//echo $_SESSION['bri_type'];
?>	
    	<h3>Analog Profiles</h3>
		<p>
        	Below is a list of all Analog Profiles configured on this system.<br />
            There are two default profiles configured for the user. These profiles can be edited to add more functionality to the profile.<br />
            You can manage you profiles using the edit and delete buttons on the right of the specific profile.<br />
            In order to create a new profile, click on "Create New Profile".<br />
            In order to use a specific profile on a port, click on "Use".
        </p>
        <br />        
		<form name="view" method="post">
    
    	<table class="mytable">
        	<th colspan="15" class="widget-content-header ui-state-active ui-corner-top" align="left">Analog Profiles</th>
            <tr>
    		<td class="mytableheader ui-state-active">Profile Name</td>
            <td class="mytableheader ui-state-active">Codec</td>
    	    <td class="mytableheader ui-state-active">Operation Mode</td>
<?php
//polarity, callerid, tones, call_waiting, three_way, call_swap
		if ($_SESSION['freetdm'] != "")
		{
?>
			<td class="mytableheader ui-state-active">Hangup Polarity Reversal</td>
			<td class="mytableheader ui-state-active">Answer Polarity Reversal</td>
            <td class="mytableheader ui-state-active">Caller ID</td>
            <td class="mytableheader ui-state-active">Tone Zone</td>
            <td class="mytableheader ui-state-active">Call Waiting</td>
            <td class="mytableheader ui-state-active">Three Way Calling</td>
            <td class="mytableheader ui-state-active">Call Swapping</td>
            </tr>
<?php			
		}
		for ($b = 0; $b < $this->counter; $b++)
		{
			echo "\t\t\t<tr>\n";
			if ($_SESSION['last_profile'] == $this->profile_array[$b]['profile_name'])
			{
				echo "\t\t\t\t<td align=\"center\"><b>" . $this->profile_array[$b]['profile_name'] . "</b></td>\n";
			}
			else
			{
				echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['profile_name'] . "</td>\n";
			}
			echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['codec'] . "</td>\n";
			echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['operation_mode'] . "</td>\n";
			if ($_SESSION['freetdm'] != "")
			{
				if ($this->profile_array[$b]['hangup_polarity'] == "hangup_enable_fxo")
				{
					echo "\t\t\t\t<td align=\"center\">FXO Enabled</td>\n";					
				}
				elseif ($this->profile_array[$b]['hangup_polarity'] == "hangup_enable_fxs")
				{
					echo "\t\t\t\t<td align=\"center\">FXS Enabled</td>\n";					
				}
				elseif ($this->profile_array[$b]['hangup_polarity'] == "hangup_enable_both")
				{
					echo "\t\t\t\t<td align=\"center\">FXO/FXS Enabled</td>\n";
				}
				else
				{
					echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['hangup_polarity'] . "</td>\n";
				}
				
				if ($this->profile_array[$b]['answer_polarity'] == "answer_enable_fxo")
				{
					echo "\t\t\t\t<td align=\"center\">FXO Enabled</td>\n";					
				}
				elseif ($this->profile_array[$b]['answer_polarity'] == "answer_enable_fxs")
				{
					echo "\t\t\t\t<td align=\"center\">FXS Enabled</td>\n";					
				}
				elseif ($this->profile_array[$b]['answer_polarity'] == "answer_enable_both")
				{
					echo "\t\t\t\t<td align=\"center\">FXO/FXS Enabled</td>\n";
				}
				else
				{				
					echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['answer_polarity'] . "</td>\n";
				}
				echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['callerid'] . "</td>\n";
				echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['tones'] . "</td>\n";
				echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['call_waiting'] . "</td>\n";
				echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['three_way'] . "</td>\n";
				echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['call_swap'] . "</td>\n";
			}
			echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"use" . $this->profile_array[$b]['id'] . "\" value=\"Use\" " . $_SESSION['button_class'] . "/></td>\n";		
			//echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"use-all-" . $this->profile_array[$b]['id'] . "\" value=\"Use for all Ports\" /></td>\n";		
			echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"config" . $this->profile_array[$b]['id'] . "\" value=\"Edit Profile\" " . $_SESSION['button_class'] . "/></td>\n";
	
			$skip = 0;
			//Disables deleting the default profile
			if ($this->profile_array[$b]['profile_name'] == "ANALOG MULAW" || $this->profile_array[$b]['profile_name'] == "ANALOG ALAW")
			{
				$skip = 1;
			}
			
			if ($skip == 0)
			{
				echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"delete" . $this->profile_array[$b]['id'] . "\" value=\"Delete Profile\" " . $_SESSION['button_class'] . "/></td>\n";
			}

			echo "\t\t\t<tr>\n";
			$num_entries++;
		}
		echo "\t\t</table>\n";		
	
	//Puts the number of entries in the database into a session variable
	$_SESSION['num_entries'] = $num_entries;
?>	        
    	<br />
        <table width="900px">
        <tr>
        <td width="1%"><input type="submit" name="create" value="Create New Profile" <?php echo $_SESSION['button_class']; ?>/></td>
    	<td align="right"><input type="submit" name="back" value="Go Back to Hardware Information" <?php echo $_SESSION['button_class']; ?>/></td>
        </tr>
        </table>
</form>        

<?php
	}
	
	//Tokenizes the TON,NPI and MSN values for entry into the form
	function tokenize_values($string)
	{
		$tok = strtok($string, ",");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok= strtok(",");
			$count++;
		}	
		
		for ($a = 0; $a < $count; $a++)
		{
			if ($token[$a] == " " || $token[$a] == "  ")
			{
			}
			else
			{
				$counter++;
			}
		}
		
		return $counter;		
	}	

}

?>