<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class profile_panel {

	private $_gateway_status = NULL;

	public function main($data) {
		$mg_profiles = $this->pull_data('mg_profiles','*',$data);
		$perm_mg_profiles = $this->pull_data('perm_mg_profiles','id,name',$data);
		$configured_port_info = $this->pull_data('finished_ports','card,type,mg_profile',$data);
		$generated_port_info = $this->pull_data('generated_ports','*',$data);
		$cluster_info = $this->pull_data('m2ua_clusters','*',$data);
		$sctp_interfaces = $this->pull_data('sctp_interfaces','*',$data);
		$rows = 0;
		
		foreach ($cluster_info as $cluster) {
			$cluster_name = $cluster['profile_name'];
			$cluster_id = $cluster['id'];
			if (!$this->compare_cluster_tables($data,$cluster_name,$cluster_id)) {
				$cl_out_sync = true;
				break;
			}
			else
				$cl_out_sync = false;
		}

		if (!$cl_out_sync) {
			foreach($sctp_interfaces as $sctp) {
				$sctp_name = $sctp['profile_name'];
				$sctp_id = $sctp['id'];
				if (!$this->compare_sctp_tables($data,$sctp_name,$sctp_id)) {
					$cl_out_sync = true;
					break;
				}
				else
					$cl_out_sync = false;
			}
		}
	
		if ($cl_out_sync) {
			$notif = new NotificationBox( 'Warning', NotificationBox::Warning );
			$notif->add("","Changes were made to the SCTP Interface(s), Cluster Interface(s) and/or Cluster Peer(s).");
			$notif->add("","The Profile Panel is disabled until the gateway is stopped and the gateway configuration is regenerated.");
			echo $notif->getHtml();		
			unset($notif);	
			echo "<br />";
		}
		
		$deleted_board = $this->find_deleted_boards($data);
		
		if (!empty($deleted_board) ) {
			$notif = new NotificationBox( 'Warning', NotificationBox::Warning );
			foreach ($deleted_board as $missing) {
				$notif->add("","TDM Span " . $missing['board'] . " has been removed from configuration. Please Sync or Stop " . $missing['mg_profile'] . " for the changes to become effective.");
			}
			echo $notif->getHtml();		
			unset($notif);	
			echo "<br />";
		}


		//Detects if an m2ua sig has removed its mg voice channels	
		$m2ua_only = $this->find_m2ua_only($data);

                if (!empty($m2ua_only) ) {
                        $notif = new NotificationBox( 'Warning', NotificationBox::Warning );
                        foreach ($m2ua_only as $m2ua) {
                                $notif->add("","TDM Span " . $m2ua['board'] . " has its voice spans removed. Please Stop the gateway, then re-apply the configuration for the changes to become effective.");
                        }
                        echo $notif->getHtml();
                        unset($notif);
                        echo "<br />";
                }

	
		?>
				<form name='mg_profiles' method='post'>     
        <?php
		foreach ($perm_mg_profiles as $perm_mg) {
			//Check if any profiles were removed
			if ($this->check_mg_deletion($data,$perm_mg['name'],$perm_mg['id'])) {
				$notif = new NotificationBox( 'Warning', NotificationBox::Warning );
				$notif->add("",$perm_mg['name']." has been removed from the system.");
				$notif->add("","To remove it from the gateway, please click" . "<input type='submit' name='stop-".$perm_mg['id']."' value='Stop' " . $_SESSION['button_class'] . " />");
				echo $notif->getHtml();		
				unset($notif);	
				echo "<br />";
			}
		}

	
		foreach ($mg_profiles as $profile) {
			
			//Get peer information about mg profile
			$peers = $this->pull_data($profile['name'] . '_peers','id,name',$data);
		?>      
   				<br />
				<table class="mytable" width='100%'>
	                <th colspan="7" class="widget-content-header ui-state-active ui-corner-top" align="left"><?=$profile['name']?> 
                    <br />
         <?php
		 	//Determine if the mg_profile/peers are in sync
		 ?>       
                    </th>
                    <tr>
                    	<td class="mytableheader" width='15%'></td>
                        <td class="mytableheader" width='20%'>Info</td>
                        <td class="mytableheader" width='25%'>Type</td>
                        <td class="mytableheader" width='10%'>In Use</td>
           				<td class="mytableheader" width='20%'>Config</td> 
         <?php
		 	echo "<tr>";
		 	echo "<td>".$profile['name']."</td>";
			echo "<td>";
			foreach ($peers as $peer)
				echo $peer['name'] . "<br />";
				
			echo "</td>";
			echo "<td>" . ucfirst($profile['protocol']) . "</td>";
			
			// Default statys us inactive
			$mg_active = false;
			$state = "<font color='red'><b>Inactive</b></font>";
			if($this->gateway_status()){
				// Get MG profile xml status
				unset($output);
				unset($status);
				try{
					exec ('/usr/sbin/nsg_cli -x "mg profile list"', $output);
					$obj = simplexml_load_string(implode("", $output));
					if($obj){
						$status = $obj->xpath('/mg_profiles/mg_profile[@name="'.$profile['name'].'"]');
						if($status){
							$state = "<font color='green'><b>Active</b></font>";
							$mg_active = true;
						}
					}
				}catch(Exception $e){
				}
			}
			
			if ($this->compare_mg_profile_tables($data,$profile['name'],$profile['id']))
				$state2 = "<font color='green'><b>In Sync</b></font>";
			else 
				$state2 = "<font color='red'><b>Out of Sync</b></font>";
				
			echo "<td><b>$state</b></td>";
			echo "<td><b>$state2</b></td>";
			unset($state);
		 	echo "</tr>";
			$a=0;
		 	foreach ($configured_port_info as $port) {
				if ($port['mg_profile'] == $profile['name'] ){
					$card = explode('_',$port['card']);
					//Retrieve Information about mg channels
					$mg_channels = $this->get_data_values($data,$card['0'].'_'.$card[1].'_m2ua_channels','port_id=' . $card[2]);					
					$rows++;
					if (($a % 2) == 0)
						echo "<tr bgcolor=" . COLOR_ROW_ODD . " >";
					else
						echo "<tr bgcolor=" . COLOR_ROW_EVEN . " >";
						
					$a++;
					//echo "<tr>";
					echo "<td>TDM " . $card[0] . ":" . $card[1] . ":" . $card[2] . "</td>";
					echo "<td>" . $mg_channels['prefix'] . $mg_channels['base'] . ": " . $mg_channels['channel_map'] . "</td>";
					if ($port['type'] == "M2UA Signalling Gateway")
						$type = "Media Gateway + M2UA SG";
					else
						$type = $port['type'];
					echo "<td>" . $type . "</td>";
					echo "<td><b>";
					// Default status is inactive
					$state = "<font color='red'><b>Inactive</b></font>";	
					foreach ($generated_port_info as $gen_info) {
						$status_str = "??";
						if ($gen_info['card'] == $port['card']) {
							if ($this->gateway_status())  {
								unset($output);
								$status_str = "??";
								try{
									$span_id = trim(substr($gen_info['wanpipe'],7)); 
									exec ('/usr/sbin/nsg_cli -x "ftdm xmlstatus wp' . $span_id . '"', $output);
									$obj = simplexml_load_string(implode("", $output));
									if($obj){
										$status = $obj->xpath('/span/status');
										$status_str = trim((string)$status[0]);
									}
								}
									catch(Exception $e){
								}
								if('PRESENT'==$status_str)
									$state = "<font color='green'><b>Active</b></font>";
								else
									$state = "<font color='red'><b>Inactive</b></font>";	
							}
							break;
						}
					}
					echo $state;
					echo "</b></td>";
					echo "<td><b>";
					//Check if in/out of sync
					if ($this->compare_card_tables($data,$card))
						$state="<font color='green'><b>In Sync</b></font>";
					else 
						$state="<font color='red'><b>Out of Sync</b></font>";	
					}
					
					echo $state;
					unset($state);
					echo "</b></td>";
					echo "</tr>";
					
			}
		 ?>
                <tr>
            		<td class="widget-content-header ui-state-active ui-corner-bottom"  colspan='7' align='center'>
<?php
			if ($this->gateway_status()) {
				if (!$cl_out_sync) {
					if (!$mg_active)
						echo "<input type='submit' name='start-" . $profile['id'] . "' value='Start' " . $_SESSION['button_class'] . " style='float:left;'/>";
					else
						echo "<input type='submit' name='stop-".$profile['id']."' value='Stop' " . $_SESSION['button_class'] . " style='float:left;'/>";
				}
				echo "<input type='submit' name='restart-".$profile['id']."' value='&nbsp;Sync&nbsp;' ".$_SESSION['button_class']." style='float:right;'/>";
			}
?>
</td>
                </tr>
				</table>
                        
         <?php
		}
		echo "</form>";
	}
	
	
	/**
	*	Pulls data out of the database and returns it in an array
	*	@param table
	*			database table name
	*	@param param
	*			sql select parameter
	*	@param $data
	*			database object
	*	@return array
	*/
	public function pull_data($table,$param,$data,$db=null) {
		$c = 0;
		$profile_array = array();
		
		if ($db == "") 
			$db = 'sqlite:sqlite/cardinfo.db';
		
		
		//Table exists
		if ($data->check_for_table ($db, $table) > 1)
		{
			$select = "SELECT " . $param . " FROM " . $table . ";";
	
			try
			{
				//open the database
				$db = new PDO($db);
	
				$result = $db->query($select);
			
				foreach($result as $row)
				{
					$profile_array[$c] = $row;
					$c++;
				}
				// close the database connection
				$db = NULL;
			}
			catch(PDOException $e)
			{
				//echo "hello <br />";
				print 'Exception : '.$e->getMessage();
			}
		}	
		return $profile_array;
	}
	
	/**
	*	Pulls specific data from the database
	*/
	public function get_data_values($data,$table,$where_clause,$db=NULL) {
		if (!isset($db))
			$db='sqlite:sqlite/cardinfo.db';
			
		$db_info = $data->select_statement($db,$table,'*',$where_clause);
		return $db_info;
	}
	
	public function find_deleted_boards($data) {
		$generated_boards = $this->pull_data('generated_ports','*',$data);
		$finished_boards = $this->pull_data('finished_ports','*',$data);
		
		$a = 0;
		foreach ($generated_boards as $boards) {
			$found_port = false;
			foreach ($finished_boards as $finished) {
				if ($boards['card'] == $finished['card']) {
					$found_port = true;
					break;
				}
			}
			if (!$found_port) {
				$return_array[$a]['mg_profile'] = $boards['mg_name'];
				$return_array[$a]['board'] = $boards['card'];
				$a++;
			}
		}
		return $return_array;
	}

	public function find_m2ua_only($data) {
               $generated_boards = $this->pull_data('generated_ports','*',$data);
                $finished_boards = $this->pull_data('finished_ports','*',$data);
                $a = 0;
                foreach ($generated_boards as $boards) {
                        $found_port = false;
                        foreach ($finished_boards as $finished) {
                                if (($boards['card'] == $finished['card'])) {
					if ($finished['mg_profile'] == "" && $boards['mg_name'] != ""  && $finished['type'] == 'M2UA Signalling Gateway') {
	                                        $found_port = true;
        	                                break;
					}
                                }
                        }
                        if ($found_port) {
                                $return_array[$a]['board'] = $boards['card'];
                                $a++;
                        }
                }
                return $return_array;
	}

	
	public function compare_cluster_tables($data,$cluster,$id) {
		$scratch_m2ua_table = $this->get_data_values($data,'m2ua_clusters','id='.$id);	
		$perm_m2ua_table = $this->get_data_values($data,'perm_m2ua_clusters','id='.$id);
		if (!empty($scratch_m2ua_table) && !empty($perm_m2ua_table)) {
			if (!$this->sng_array_diff($scratch_m2ua_table,$perm_m2ua_table))
				return false;
			else {
				$peers = $this->pull_data($cluster . '_peers','*',$data);
				$perm_peers = $this->pull_data('perm_'.$cluster.'_peers','*',$data);
				if ($this->sng_array_diff($peers,$perm_peers)) {
					foreach ($peers as $peer) {
						//Check if peers are in sync
						if (!$this->compare_peers($data,$cluster,$peer['id'])) {
							return false;
						}
					}
				}
				else
					return false;
			}
		}
		elseif (!empty($scratch_m2ua_table) && empty($perm_m2ua_table)) {
			//this scenario is allowed as you are adding a new cluster to the configuration
			return true;
		}
		else
			return false;
			
		unset($diff);
		return true;
	}
	
	public function compare_sctp_tables($data,$sctp,$id) {
		$scratch_sctp_table = $this->get_data_values($data,'sctp_interfaces','id='.$id);	
		$perm_sctp_table = $this->get_data_values($data,'perm_sctp_interfaces','id='.$id);

		if (!empty($scratch_sctp_table) && !empty($perm_sctp_table)) {
			if (!$this->sng_array_diff($scratch_sctp_table,$perm_sctp_table))
				return false;
		}
		elseif (!empty ($scratch_sctp_table) && empty($perm_sctp_table)) {
			//This scenario is allowed as you can add new sctp interfaces to the configuration
			return true;
		}
		else
			return false;
			
		unset($diff);
		return true;
	}	
	
	private function check_mg_deletion($data,$mg_profile,$id) {
		$scratch_mg_table = $this->get_data_values($data,'mg_profiles','id='.$id);	
		$perm_mg_table = $this->get_data_values($data,'perm_mg_profiles','id='.$id);

		if (empty($scratch_mg_table) && !empty($perm_mg_table)) {
				return true;
		}
		return false;
	}
	
	public function compare_mg_profile_tables($data,$mg_profile,$id) {
		$scratch_mg_table = $this->get_data_values($data,'mg_profiles','id='.$id);	
		$perm_mg_table = $this->get_data_values($data,'perm_mg_profiles','id='.$id);
	
		if (!empty($scratch_mg_table) && !empty($perm_mg_table)) {
			if (!$this->sng_array_diff($scratch_mg_table,$perm_mg_table)) 
				return false;
			else {
				$peers = $this->pull_data($mg_profile . '_peers','id,name',$data);
				$perm_peers = $this->pull_data('perm_'.$mg_profile.'_peers','id,name',$data);

				if ($this->sng_array_diff($peers,$perm_peers)) {
					foreach ($peers as $peer) {
						//Check if peers are in sync
						//echo $this->compare_peers($data,$mg_profile,$peer['id'])."<br />";
						if (!$this->compare_peers($data,$mg_profile,$peer['id'])) {
							return false;
						}
					}
				}
				else
					return false;
			}
		}
		else
			return false;
			
		unset($diff);
		return true;
	}
	
	public function compare_peers($data,$mg_profile,$id) {
		$scratch_peer_data = $this->get_data_values($data,$mg_profile.'_peers','id='.$id);
		$perm_peer_data = $this->get_data_values($data,'perm_'.$mg_profile.'_peers','id='.$id);

		if (!empty($scratch_peer_data) && !empty($perm_peer_data)) {
			if (!$this->sng_array_diff($scratch_peer_data,$perm_peer_data))
				return false;
		}
		else
			return false;
			
		unset($diff);
		return true;
	}
	
	public function compare_card_tables($data,$card) {
		$scratch_card_info = $this->get_data_values($data,$card[0] . '_' . $card[1],'port_id=' . $card[2]);
		$perm_card_info = $this->get_data_values($data,'perm_'.$card[0] . '_' . $card[1],'port_id=' . $card[2]);
		if (!empty($scratch_card_info) && !empty($perm_card_info)) {
			if (!$this->sng_array_diff($scratch_card_info,$perm_card_info))
				return false;
		}elseif (( !empty($scratch_card_info) && empty($perm_card_info))
			|| empty($scratch_card_info) && !empty($perm_card_info)) 
			return false;
			
		unset($diff);
		$scratch_m2ua_info = $this->get_data_values($data,$card[0].'_'.$card[1].'_m2ua_link', 'port_id='.$card[2]);
		$perm_m2ua_info = $this->get_data_values($data,'perm_'.$card[0].'_'.$card[1].'_m2ua_link', 'port_id='.$card[2]);

		if (!empty($scratch_m2ua_info) && !empty($perm_m2ua_info)) {
			if (!$this->sng_array_diff($scratch_m2ua_info,$perm_m2ua_info))
				return false;
		}elseif (( !empty($scratch_m2ua_info) && empty($perm_m2ua_info))
			|| empty($scratch_m2ua_info) && !empty($perm_m2ua_info)) 
			return false;
						
		unset($diff);
		$scratch_mg_channels = $this->get_data_values($data,$card[0].'_'.$card[1].'_m2ua_channels','port_id='.$card[2]);
		$perm_mg_channels = $this->get_data_values($data,'perm_'.$card[0].'_'.$card[1].'_m2ua_channels','port_id='.$card[2]);		

		if (!empty($scratch_mg_channels) && !empty($perm_mg_channels)) {
			if (!$this->sng_array_diff($scratch_mg_channels,$perm_mg_channels))
				return false;
		}elseif (( !empty($scratch_mg_channels) && empty($perm_mg_channels))
			|| empty($scratch_mg_channels) && !empty($perm_mg_channels)) 
			return false;
		
		return true;
	}
	
	public function gateway_status() {
		$this->_gateway_status = shell_exec('pidof ' . $_SESSION['gateway_script']);
		if ($this->_gateway_status == 0 || $this->_gateway_status == "")
			return false;
		else
			return true;
	}
	
	public function mg_profile_count($data) {
		$mg_profiles = $this->pull_data('mg_profiles','name',$data);
		return count($mg_profiles);
	}
	
	public function generate_single_mp_config($tdm_config,$tokenization,$data) {
		require_once ('wanpipe_config/wanpipe.php');
		require_once ('freetdm_config/freetdm.php');
		
		//TDM Configuration
		$post['generate'] = "Generate Config";
		$tdm_config->redirect($post,$data,$tokenization);	
		//Megaco Configuration	
		save_mg_tables($data);
		xml_gen($data);
		//Turn on nsg
		$cmd = '/sbin/chkconfig nsg on';	
		exec ($cmd);
		exec ('/sbin/chkconfig wanrouter on');
	}
	
	public function generate_mg_config($data,$profile) {
		//Check if boards out of sync
		$mg_profile_id = $this->get_data_values($data,'mg_profiles','name="'.$profile.'"');
		if (empty($mg_profile_id)) {
			$mg_profile_id = $this->get_data_values($data,'perm_mg_profiles','name="'.$profile.'"');
		}
		$finished_boards = $this->pull_data('finished_ports','*',$data);
		$generated_boards = $this->pull_data('generated_ports','*',$data);

		//check if mg profile is out of sync
		//if out of sync, check if it needs to be updated
		$scratch_mg_table = $this->get_data_values($data,'mg_profiles','id='.$mg_profile_id['id']);	
		$perm_mg_table = $this->get_data_values($data,'perm_mg_profiles','id='.$mg_profile_id['id']);

		$peers = $this->pull_data($profile.'_peers','*',$data);
		$perm_peers = $this->pull_data('perm_'.$profile.'_peers','*',$data);		

		if (!empty($scratch_mg_table) && !empty($perm_mg_table)) {
			if (!$this->sng_array_diff($scratch_mg_table,$perm_mg_table)) {
				//update
				generate_mg_profile_config($profile,$data,'update');
			}
		}
		elseif (!empty($scratch_mg_table) && empty($perm_mg_table)) { 
			//create new
			generate_mg_profile_config($profile,$data);
		}
		
		//Check peers for this particular mg profile
		$table = false;
		foreach ($peers as $peer) {
			$scratch_peer_data = get_data_values($data,$profile.'_peers','id='.$peer['id']);
			$perm_peer_data = get_data_values($data,'perm_'.$profile.'_peers','id='.$peer['id']);
			if (!empty($scratch_peer_data) && empty($perm_peer_data)) {
				//new
				generate_peers ($profile,$peer['name'],$data,'new');		
				$table=true;				
			}
			elseif (!empty($scratch_peer_data) && !empty($perm_peer_data)) {
				if (!$this->sng_array_diff($scratch_peer_data,$perm_peer_data)) {
					//update
					generate_peers ($profile,$peer['name'],$data,'update');
					$table=true;
				}
			}
		}
		
		if ($table) {		
			//Update peers table as it needs to be done after all completed
			//drop perm peers table
			$data->drop_table('sqlite:sqlite/cardinfo.db','perm_'.$profile.'_peers');
			//select into perm peers table
			$data->select_into('sqlite:sqlite/cardinfo.db',$profile.'_peers', "*", 'perm_'.$profile.'_peers');
		}

		//Check if anything needs to be removed from the profiles
		$a = 0;
		foreach ($generated_boards as $board) {
				if ($board['mg_name'] == $profile) {
						$board_info = $this->get_data_values($data,'generated_ports','card="'.$board['card'].'"');
						if ($board_info['id'] != "")
								$rm_span = $board_info['id'];
						$card = explode('_',$board['card']);
						$remove_wanrouter=false;

						$scratch_card_info = $this->get_data_values($data,$card[0] . '_' . $card[1],'port_id=' . $card[2]);
						$perm_card_info = $this->get_data_values($data,'perm_'.$card[0] . '_' . $card[1],'port_id=' . $card[2]);
						if (empty($scratch_card_info) && !empty($perm_card_info)) {
								//remove
								remove_wanpipe_file($card,$rm_span,$data);
								$removed_span[$a] = $board;
								$a++;
								$remove_wanrouter=true;
						}


						$scratch_m2ua_channels = $this->get_data_values($data,$card[0].'_'.$card[1].'_m2ua_channels', 'port_id='.$card[2]);
						$perm_m2ua_channels = $this->get_data_values($data,'perm_'.$card[0].'_'.$card[1].'_m2ua_channels', 'port_id='.$card[2]);
						if (empty($scratch_m2ua_channels) && !empty($perm_m2ua_channels)) {
								//remove
								//echo "remove mg";
								generate_freetdm_config($card,$rm_span,$data,'remove');
								generate_mg_board_config($card,$rm_span,$profile,$data,'remove');
						}

						$scratch_m2ua_info = $this->get_data_values($data,$card[0].'_'.$card[1].'_m2ua_link', 'port_id='.$card[2]);
						$perm_m2ua_info = $this->get_data_values($data,'perm_'.$card[0].'_'.$card[1].'_m2ua_link', 'port_id='.$card[2]);
						if (empty($scratch_m2ua_info) && !empty($perm_m2ua_info)) {
								//remove
								generate_m2ua_config($card,$rm_span,$data,'remove');
						}

						if ($remove_wanrouter) {
								//delete generated port entry
								$data->delete_generic ('sqlite:sqlite/cardinfo.db','generated_ports','card="'.$board['card'].'"');
								update_wanrouter_rc($data);
						}
				}
		}

		//check for new boards or update to boards
		foreach ($finished_boards as $board) {
			if ($board['mg_profile'] == $profile) {
				$board_info = $this->get_data_values($data,'generated_ports','card="'.$board['card'].'"');
				if ($board_info['id'] != "") {	
					$id = $board['id'];
					$rm_span = $board_info['id'];
				}
				else {
					unset($rm_span);
					$gen_ids = array();
					$finished_ids = array();
					$gen_ids = $this->pull_data('generated_ports','id',$data);
					$finished_ids = $this->pull_data('finished_ports','id',$data);
					if (!empty($gen_ids)) {
						$span_counter = 1;
						//foreach ($gen_ids as $gen_id) {
						$a = 0;
						foreach ($finished_ids as $finished_id) {
							$finished[$a] = $finished_id['id'];
							$a++;
						}
						$a = 0;
						foreach ($gen_ids as $gen_id) {
							$gen[$a] = $gen_id['id'];
							$a++;
						}

						$diff = array_diff ($finished,$gen);
						foreach ($diff as $k=>$v) {
							$span = $v;
							unset($diff[$k]);
							break;
						}
						//Make sure last id not the last element. If so, append by 1
						$numItems = count($gen_ids);
						$i = 0;
						foreach($gen_ids as $key=>$value) {
						  if(++$i === $numItems) {
							if ($span == $gen_ids[$key]['id']) {
								$span++;
								break;
							}
						  }
						}
						$rm_span = $span;   	
					}
					else {
						$span = 1;
						$rm_span = 1;
					}
				}
				$card = explode('_',$board['card']);
				//if they are out of sync
				//check if wanpipes out of sync
				$scratch_card_info = $this->get_data_values($data,$card[0] . '_' . $card[1],'port_id=' . $card[2]);
				$perm_card_info = $this->get_data_values($data,'perm_'.$card[0] . '_' . $card[1],'port_id=' . $card[2]);

				if (!empty($scratch_card_info) && !empty($perm_card_info)) {
					if (!$this->sng_array_diff($scratch_card_info,$perm_card_info)) {
						//update
						generate_wanpipe_config($card,$rm_span,$data);
					}
				}
				elseif (!empty($scratch_card_info) && empty($perm_card_info)) {
					//new card
					if ($span == "") 
						$span = $rm_span;
					generate_wanpipe_config($card,$span,$data);
				}
			
						
				//see if board associated has an m2ua
				//check if m2ua_link needs to be updated
				$scratch_m2ua_info = $this->get_data_values($data,$card[0].'_'.$card[1].'_m2ua_link', 'port_id='.$card[2]);
				$perm_m2ua_info = $this->get_data_values($data,'perm_'.$card[0].'_'.$card[1].'_m2ua_link', 'port_id='.$card[2]);
				
				if (!empty($scratch_m2ua_info)) {
					if (!empty($scratch_m2ua_info) && !empty($perm_m2ua_info)) {
						if (!$this->sng_array_diff($scratch_m2ua_info,$perm_m2ua_info)) {
							//update
							generate_m2ua_config($card,$rm_span,$data,$gen_type = 'update');							
						}
					}
				}
				if (!empty($scratch_m2ua_info) && empty($perm_m2ua_info)) {
					//create new
					if ($span == "") 
						$span = $rm_span;
					generate_m2ua_config($card,$span,$data,$gen_type = 'new');	
				}
				
				//see if m2ua_channels table needs to be updated
				//update channels and mod_media_gateway for board
				$scratch_m2ua_channels = $this->get_data_values($data,$card[0].'_'.$card[1].'_m2ua_channels', 'port_id='.$card[2]);
				$perm_m2ua_channels = $this->get_data_values($data,'perm_'.$card[0].'_'.$card[1].'_m2ua_channels', 'port_id='.$card[2]);
				if (!empty($scratch_m2ua_channels) && empty($perm_m2ua_channels)) {
					//create new
					if ($span == "") 
						$span = $rm_span;
					generate_freetdm_config($card,$span,$data,'new');
					generate_mg_board_config($card,$span,$profile,$data,'new');
				}
				if (!empty($scratch_m2ua_channels) && !empty($perm_m2ua_channels)) {
					if (!$this->sng_array_diff($scratch_m2ua_channels,$perm_m2ua_channels)) {
						//update
						generate_freetdm_config($card,$rm_span,$data,'update');
						generate_mg_board_config($card,$rm_span,$profile,$data,'update');							
					}
				}
			}
		}
		
		//Check if new cluster added
		$cluster_info = $this->pull_data('m2ua_clusters','*',$data);

		foreach ($cluster_info as $cluster) {
			$cluster_name = $cluster['profile_name'];
			$cluster_id = $cluster['id'];
			
			$scratch_m2ua_table = $this->get_data_values($data,'m2ua_clusters','id='.$cluster_id);	
			$perm_m2ua_table = $this->get_data_values($data,'perm_m2ua_clusters','id='.$cluster_id);
			if (!empty($scratch_m2ua_table) && empty($perm_m2ua_table)) {
				//this scenario is allowed as you are adding a new cluster to the configuration
				//add new cluster
				add_new_cluster($cluster_name,$cluster_id,$data,'new');
			}
		}

		//check if new sctp interface added
		$sctp_interfaces = $this->pull_data('sctp_interfaces','*',$data);
		
		foreach($sctp_interfaces as $sctp) {
			$sctp_name = $sctp['profile_name'];
			$sctp_id = $sctp['id'];
			$scratch_sctp_table = $this->get_data_values($data,'sctp_interfaces','id='.$sctp['id']);	
			$perm_sctp_table = $this->get_data_values($data,'perm_sctp_interfaces','id='.$sctp['id']);

			if (!empty ($scratch_sctp_table) && empty($perm_sctp_table)) {
				//This scenario is allowed as you can add new sctp interfaces to the configuration
				//create new sctp interface
				add_new_sctp($sctp_name,$sctp_id,$data,'new');
			}
		}
		
		
		//Check if anything needs to be removed from the profiles
		$a = 0;
		foreach ($generated_boards as $board) {
			if ($board['mg_name'] == $profile) {
				$board_info = $this->get_data_values($data,'generated_ports','card="'.$board['card'].'"');
				if ($board_info['id'] != "")	
					$rm_span = $board_info['id'];
				$card = explode('_',$board['card']);
				$remove_wanrouter=false;
				
				$scratch_card_info = $this->get_data_values($data,$card[0] . '_' . $card[1],'port_id=' . $card[2]);
				$perm_card_info = $this->get_data_values($data,'perm_'.$card[0] . '_' . $card[1],'port_id=' . $card[2]);
				if (empty($scratch_card_info) && !empty($perm_card_info)) {
					//remove
					remove_wanpipe_file($card,$rm_span,$data);
					$removed_span[$a] = $board;
					$a++;
					$remove_wanrouter=true;
				}
				
				
				$scratch_m2ua_channels = $this->get_data_values($data,$card[0].'_'.$card[1].'_m2ua_channels', 'port_id='.$card[2]);
				$perm_m2ua_channels = $this->get_data_values($data,'perm_'.$card[0].'_'.$card[1].'_m2ua_channels', 'port_id='.$card[2]);
				if (empty($scratch_m2ua_channels) && !empty($perm_m2ua_channels)) {
					//remove
					//echo "remove mg";
					generate_freetdm_config($card,$rm_span,$data,'remove');
					generate_mg_board_config($card,$rm_span,$profile,$data,'remove');
				}
				
				$scratch_m2ua_info = $this->get_data_values($data,$card[0].'_'.$card[1].'_m2ua_link', 'port_id='.$card[2]);
				$perm_m2ua_info = $this->get_data_values($data,'perm_'.$card[0].'_'.$card[1].'_m2ua_link', 'port_id='.$card[2]);
				if (empty($scratch_m2ua_info) && !empty($perm_m2ua_info)) {
					//remove
					generate_m2ua_config($card,$rm_span,$data,'remove');
				}
				
				if ($remove_wanrouter) {
					//delete generated port entry
					$data->delete_generic ('sqlite:sqlite/cardinfo.db','generated_ports','card="'.$board['card'].'"');
					update_wanrouter_rc($data);
				}
			}
		}
		$perm_peers = $this->pull_data('perm_'.$profile.'_peers','*',$data);		
		foreach ($perm_peers as $peer) {
			$scratch_peer_data = get_data_values($data,$profile.'_peers','id='.$peer['id']);
			$perm_peer_data = get_data_values($data,'perm_'.$profile.'_peers','id='.$peer['id']);
			if (empty($scratch_peer_data) && !empty($perm_peer_data)) {
				//remove
				generate_peers ($profile,$peer['name'],$data,'remove');
				$table=true;				
			}
		}


		if (empty($scratch_mg_table) && !empty($perm_mg_table)) {
			//remove
			generate_mg_profile_config($profile,$data,'remove');
			$data->drop_table('sqlite:sqlite/cardinfo.db','perm_'.$profile.'_peers');
		}	
		
		//Drop Perm Finished ports table and recreate it
		$table_name = "perm_finished_ports";
		if ($data->check_for_table ('sqlite:sqlite/cardinfo.db', $table_name) > 1)
			$data->drop_table('sqlite:sqlite/cardinfo.db', $table_name);	
			
		$new_table = "perm_finished_ports";
		$table_name = "finished_ports";
		$parameters = "*";	
		$data->select_into ('sqlite:sqlite/cardinfo.db', $table_name, $parameters, $new_table);	
		
		return $removed_span;		
	}
	
	/**
	* Checks for differences between 2 arrays and returns whether there is a difference or not
	* @param array $array1
	* @param array $array2
	*/
	public function sng_array_diff($array1,$array2) {
		$diff1 = array_diff($array1,$array2);
		$diff2 = array_diff ($array2, $array1);

		if (!empty($diff1)|| !empty($diff2))
			return false;
		else
			return true;
	}
}


?>
