<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Checks to make sure the user is logged into the WebUI
if (empty($_POST))
	include 'check_referer.php';

//Start Session
session_start();

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{
	
	include 'database_classes.php';
	include 'profile_panel_class.php';
	include 'generate_single_config.php';	
	include 'sng_config_manager_functions.php';
	include 'wanrouter_controls.php';
	include 'classes.php';
	include 'mg/mg_config_generate.php';	
	
	$data = new database_class;
	$panel = new profile_panel;
	$tdm_config = new wanrouter_hwprobe_controls;
	$tokenization = new wanrouter_hwprobe;
		
	//Check how many profiles in system
	$mg_profile_count = $panel->mg_profile_count($data);

	foreach ($_POST as $k=>$v) {
		if (preg_match("'\brestart\b'",$k)) {
			$post = explode('-',$k);
			$id = $post[1];
			
			//Determine mg profile being effected
			$mg = $data->select_statement('sqlite:sqlite/cardinfo.db','mg_profiles','name','id='.$id);
			$profile = $mg['name'];
	
			//stop wanpipes
			$wanpipe_array = pull_array_data('generated_ports','id,card,wanpipe,mg_name',$data);
			$a = 0;
			foreach ($wanpipe_array as $wanpipe) {
				if (trim($wanpipe['mg_name']) == trim($profile)) {
					$card = explode('_',$wanpipe['card']);
					if (!$panel->compare_card_tables($data,$card)) {
						$wan[$a] = $wanpipe['wanpipe'];
						$wp[$a] = 'wp'.$wanpipe['id'];
						$a++;
					}
				}
			}
			//stop mg profile
			shell_exec ('/usr/sbin/nsg_cli -x "mg profile ' . $profile . ' stop"');
			if (!empty ($wan)) {
				$stop_mg = true;
				foreach ($wp as $wanpipe){
					$cmd = '/usr/sbin/nsg_cli -x "ftdm destroy '. $wanpipe.'"';
					shell_exec ($cmd);
				}
				sleep(1);
				$cmd = "/usr/bin/pkill -9 wanpipemon";
				shell_exec($cmd);
				foreach ($wan as $wanpipe){
					$cmd = '/usr/sbin/wanrouter stop '.$wanpipe.' > /dev/null 2>/dev/null';
					shell_exec ($cmd);
				}
			}
			else
				$stop_mg = false;
				
			//regenerate
			$removed_span = $panel->generate_mg_config($data,$profile);
			
			//start wanpipes
			$wanpipe_array = pull_array_data('generated_ports','wanpipe,mg_name',$data);
			$a = 0;

			if (!empty($wan)) {
				//confirm entry is still in list
				if (!empty($removed_span)) {
					foreach ($wanpipe_array as $wanpipe) {
						if (trim($wanpipe['mg_name']) == trim($profile)) {
							$wan[$a] = $wanpipe['wanpipe'];
							$a++;
						}
					}
				}
				foreach ($wan as $wanpipe)
					shell_exec ('/usr/sbin/wanrouter start ' . $wanpipe . ' > /dev/null 2>/dev/null');			
			}
			else {
				$a = 0;
				foreach ($wanpipe_array as $wanpipe) {
					if (trim($wanpipe['mg_name']) == trim($profile)) {
						$wan[$a] = $wanpipe['wanpipe'];
						$a++;
					}
				}
				sleep(1);
				if (!empty($wan)) {
					foreach ($wan as $wanpipe)
						shell_exec ('/usr/sbin/wanrouter start ' . $wanpipe . ' > /dev/null 2>/dev/null');	
				}
			}
			//start mg_profile
			shell_exec ('/usr/sbin/nsg_cli -x "reloadxml"');
			shell_exec ('/usr/sbin/nsg_cli -x "ftdm reload"');
			shell_exec ('/usr/sbin/nsg_cli -x "mg profile ' . $profile . ' start"');
				
			break;
		}
		elseif (preg_match("'\bstop\b'",$k)) {
			
			$post = explode('-',$k);
			$id = $post[1];
			$mg = $data->select_statement('sqlite:sqlite/cardinfo.db','mg_profiles','name','id='.$id);
			
			if (empty($mg)) 
				$mg = $data->select_statement('sqlite:sqlite/cardinfo.db','perm_mg_profiles','name','id='.$id);
			
			$profile = $mg['name'];

			//stop mg profile
			shell_exec ('/usr/sbin/nsg_cli -x "mg profile ' . $profile . ' stop"');
			
			//stop wanpipes
			$wanpipe_array = pull_array_data('generated_ports','id,card,wanpipe,mg_name',$data);
			$a = 0;
			$wan = array();
			$wp = array();
			foreach ($wanpipe_array as $wanpipe) {
				if (trim($wanpipe['mg_name']) == $profile) {
					$wan[$a] = $wanpipe['wanpipe'];
					$wp[$a] = 'wp'.$wanpipe['id'];
					$a++;
				}
			}
			foreach ($wp as $wanpipe){
				$cmd = '/usr/sbin/nsg_cli -x "ftdm destroy '. $wanpipe.'"';
				shell_exec ($cmd);
			}
			sleep(1);
			$cmd = "/usr/bin/pkill -9 wanpipemon";
			shell_exec($cmd);			
			foreach ($wan as $wanpipe){
				$cmd = '/usr/sbin/wanrouter stop '.$wanpipe.' > /dev/null 2>/dev/null';
				shell_exec ($cmd);
			}
		
			//regenerate
			$panel->generate_mg_config($data,$profile);

			break;
		}
		elseif (preg_match("'\bstart\b'",$k)) {
			$post = explode('-',$k);
			$id = $post[1];
			
			//Determine mg profile being effected
			$mg = $data->select_statement('sqlite:sqlite/cardinfo.db','mg_profiles','name','id='.$id);
			$profile = $mg['name'];

			//start wanpipes
			$wanpipe_array = pull_array_data('generated_ports','id,wanpipe,mg_name',$data);
			$a = 0;
			foreach ($wanpipe_array as $wanpipe) {
				if (trim($wanpipe['mg_name']) == $profile) {
					$wan[$a] = $wanpipe['wanpipe'];
					$a++;
				}
			}
			
			if (!empty($wan)) {
				for ($a = 0; $a < count($wan); $a++) {
					$cmd = '/usr/sbin/wanrouter start ' . $wan[$a] . ' > /dev/null 2>/dev/null';
					shell_exec ($cmd);		
				}
			}
			
			//start mg_profile
			$cmd = '/usr/sbin/nsg_cli -x "reloadxml"';
			shell_exec ($cmd);
			$cmd = '/usr/sbin/nsg_cli -x "ftdm reload"';
			shell_exec ($cmd);
			$cmd = '/usr/sbin/nsg_cli -x "mg profile ' . $profile . ' start"';
			shell_exec ($cmd);
			break;
		}
	}
	
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		require_once ('display_class.php');
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include 'sqlite/database_creation.php';
		include 'display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";	
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("Profile Panel", "../style.css","");		
	}	
	
	$panel->main($data);

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
		//ClearOS Integration
		$display_common->html_footer(false);	
}
else
{
	header( 'Location:../../index.php' ) ;
}
?>
