<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

session_start();

date_default_timezone_set('America/New_York');

//Includes the File which contains classes
require_once '../classes.php';
require_once '../database_classes.php';
require_once 'prod-test-class.php';
require_once 'wanpipe_prod.php';

declare(ticks = 1);

//Restores the configuration when the script is exited
pcntl_signal (SIGTERM, "restoreConfig");
pcntl_signal (SIGINT, "restoreConfig");
pcntl_signal (SIGHUP, "restoreConfig");


$input = fopen("php://stdin","r");

//Analyze the arguments passed to the script
if (in_array($argv[1], array('--help')) || $argv[1] == "")
{
	usage($argv[0]);
	exit(0);
}
elseif (in_array($argv[1], array('--TDM', '--tdm')))
{
	if (strtolower($argv[2]) == "e1" || strtolower($argv[2]) == "t1" )
	{
		$line = $argv[2];
		echo "Running Self Test on TDM Boards in " . strtoupper($line) . "\n";
	}
	else
	{
		echo "Improper usage of " . $argv[0] . "\n\n";
		usage($argv[0]);
		exit(2);
	}	
	
	if (strtolower($argv[3] == "physical")){
		echo "Running Physical Line Test\n";
		test("TDM",$line,"",'physical');
	}
	elseif (strtolower($argv[3] == "") ) {
		echo "Running Virtual Line Test\n";
		test("TDM",$line,"");
	}
	else {
		echo "Improper usage of " . $argv[0]  ."\n\n";
		usage($argv[0]);
		exit(2);
	}
}
elseif (in_array($argv[1], array('--media')))
{
	$media_card = $argv[2];
	echo "Running Media Tests for $media_card\n";
	test("media","",$media_card);
}
elseif (in_array($argv[1], array('--all')))
{
	if (strtolower($argv[2]) == "e1" || strtolower($argv[2]) == "t1" )
	{
		$line = $argv[2];
		echo "Running Media Tests and TDM tests in " . strtoupper($line) . "\n";
	}
	else
	{
		echo "Improper usage of " . $argv[0] . "\n\n";
		usage($argv[0]);
		exit(2);
	}
	if (strtolower($argv[3] == "physical")){
		echo "Running Physical Line Test\n";
		test("all",$line,"all",'physical');
	}
	elseif (strtolower($argv[3] == "") ) {
		echo "Running Virtual Line Test\n";
		test("all",$line,"all");
	}
	else {
		echo "Improper usage of " . $argv[0]  ."\n\n";
		usage($argv[0]);
		exit(2);
	}	
	
}
elseif (in_array($argv[1], array('--silent')))
{
	test("silent","E1","all");
}
else
{
	usage($argv[0]);
	exit(2);
}

fclose($input);

function test($test_type, $line_type, $media, $physical = "")
{
	//echo $test_type;
	
	//Class constructors
	$data = new database_class;
	$tokenization = new wanrouter_hwprobe;
	$prod = new prod_test;		
	
	if (strtoupper($test_type) == "SILENT" )
	{
		echo "NETBORDER SS7 - HARDWARE TEST\n";
		echo "===============================\n";
		echo "\n";
		echo "This application will test all connected A Series boards and D Series boards for errors.\n";
		echo "The test will stop all services related to the TDM interfaces in order to run the test. THIS WILL INTERUPT ALL FUNCTIONALITY IF THE SYSTEM IS IN PRODUCTION\n";
		echo "\n";
	}
	
	//Detects the install path
	$prod->smg_path();

	//Gets A10X and media processing card information
	$prod->parse_results = $tokenization->get_information('');
	$prod->get_cards();
	$prod->find_mp_cards();
	$prod->calc_num_spans();
	
	//Remove old tarball
	$cmd = "rm -f " . $prod->main_smg_path . "/nginx/html/php/production-test/SangomaOutput.tgz";
	//echo $cmd . "\n";
	shell_exec($cmd);	
	
	if ($prod->card_error == "YES" || $prod->num_a101 == 0 && $prod->num_a102 == 0 && $prod->num_a104 == 0 && $prod->num_a108 == 0 && count($prod->mp_cards) == 0)
	{
		//No Cards Found
		echo "No Boards Found\n";
		echo "Please Insert a board into your system in order to run the hardware test\n";
		exit(2);
	}
	elseif ($prod->num_a101 != 0 || $prod->num_a102 != 0 || $prod->num_a104 != 0 || $prod->num_a108 != 0 || count($prod->mp_cards) != 0)
	{
		//Displays the information regarding cards only when run with the silent option
		if (strtoupper($test_type) == "SILENT")
		{
			//Displays Media Processing Cards
			if (isset($prod->mp_card))
			{
				echo "Media Processing Boards Present\n";
				echo "==============================\n";
			
				for ($a = 0; $a < count($prod->mp_cards); $a++)
				{
					echo $prod->mp_cards[$a] . "\n";
				}
				echo "\n";			
			}

			if (isset($prod->a101count) || isset($prod->a102count) || isset($prod->a104count) || isset($prod->a108count) || isset($prod->a116count))
			{
				echo "Number of A10X Boards Present\n";
				echo "============================\n";
				echo "A101: " . $prod->num_a101 . "\n";
				echo "A102: " . $prod->num_a102 . "\n";
				echo "A104: " . $prod->num_a104 . "\n";
				echo "A108: " . $prod->num_a108 . "\n";
				echo "A116: " . $prod->num_a116 . "\n";
				
				
				echo "Total Number of spans = " . $prod->num_spans . "\n";
				echo "\n";
			}
		}
		
		//Checking Firmware Versions of Cards
		
		echo "Checking Firmware Versions on all Boards\n";
		$count = 1;
		$span_counter = 0;
		if (strtoupper($test_type) == "TDM"|| strtoupper($test_type) == "SILENT" || strtoupper($test_type) == "ALL")
		{
			if (isset($prod->a101count) || isset($prod->a102count) || isset($prod->a104count) || isset($prod->a108count) || isset($prod->a116count))
			{
				for ($y = 1; $y <= $prod->num_a101; $y++)
				{
					//Run script to check highest firmware version and check it with what is on the card
					$cmd = $prod->main_smg_path . "/nginx/html/php/scripts/firmware.sh A101";
					//echo $cmd;
					unset($firm);
					exec ($cmd, $firm);

					//echo $prod->a101[$y]->firmware . "\n";
					if ($firm[0] != $prod->a101[$y]->firmware)
					{
						$outofdate = "yes";
						echo "TDM Device <b>A101</b> Current Firmware = <b><font color='red'>".  $prod->a101[$y]->firmware . " OUT OF DATE</font></b>\n";
					}
					else
						echo "TDM Device <b>A101</b> Current Firmware = ".  $prod->a101[$y]->firmware . "\n";
				}
				for ($y = 1; $y <= $prod->num_a102; $y++)
				{		
					//Run script to check highest firmware version and check it with what is on the card
					$cmd = $prod->main_smg_path . "/nginx/html/php/scripts/firmware.sh A102";
					//echo $cmd;
					unset($firm);
					exec ($cmd, $firm);

					//echo $prod->a102[$y]->firmware . "\n";
					
					if ($firm[0] != $prod->a102[$y]->firmware)
					{
						$outofdate = "yes";
						echo "TDM Device <b>A102</b> Current Firmware = <b><font color='red'>".  $prod->a102[$y]->firmware . " OUT OF DATE</font></b>\n";
					}
					else
						echo "TDM Device <b>A102</b> Current Firmware = ".  $prod->a102[$y]->firmware . "\n";
				}
				for ($y = 1; $y <= $prod->num_a104; $y++)
				{
					//Run script to check highest firmware version and check it with what is on the card
					$cmd = $prod->main_smg_path . "/nginx/html/php/scripts/firmware.sh A104";
					//echo $cmd;
					unset($firm);
					exec ($cmd, $firm);

					//echo $prod->a104[$y]->firmware . "\n";
					
					if ($firm[0] != $prod->a104[$y]->firmware)
					{
						$outofdate = "yes";
						echo "TDM Device <b>A104</b> Current Firmware = <b><font color='red'>".  $prod->a104[$y]->firmware . " OUT OF DATE</font></b>\n";
					}
					else
						echo "TDM Device <b>A104</b> Current Firmware = ".  $prod->a104[$y]->firmware . "\n";
				}
				for ($y = 1; $y <= $prod->num_a108; $y++)
				{
					//Run script to check highest firmware version and check it with what is on the card
					$cmd = $prod->main_smg_path . "/nginx/html/php/scripts/firmware.sh A108";
					//echo $cmd;
					unset($firm);
					exec ($cmd, $firm);
					
					if ($firm[0] != $prod->a108[$y]->firmware)
					{
						$outofdate = "yes";
						echo "TDM Device <b>A108</b> Current Firmware = <b><font color='red'>".  $prod->a108[$y]->firmware . " OUT OF DATE</font></b>\n";
					}
					else
						echo "TDM Device <b>A108</b> Current Firmware = ".  $prod->a108[$y]->firmware . "\n";
				}
				for ($z = 1; $z <= $prod->num_a116; $z++)
				{
					//Run script to check highest firmware version and check it with what is on the card
					$cmd = $prod->main_smg_path . "/nginx/html/php/scripts/firmware.sh A116";
					//echo $cmd;
					unset($firm);
					exec ($cmd, $firm);
					
					if ($firm[0] != $prod->a116[$z]->firmware)
					{
						$outofdate = "yes";
						echo "TDM Device <b>A116</b> Current Firmware = <b><font color='red'>".  $prod->a116[$z]->firmware . " OUT OF DATE</font></b>\n";
					}
					else
						echo "TDM Device <b>A116</b> Current Firmware = ".  $prod->a116[$z]->firmware . "\n";
				}				
			}
			//exit(2);
		}
		if (strtoupper($test_type) == "MEDIA"||strtoupper($test_type) == "SILENT" || strtoupper($test_type) == "ALL")
		{
			if (isset($prod->mp_card))
			{
				for ($a = 0; $a < count($prod->legacy_names); $a++)
				{
					$outofdate = $prod->find_vocallo_firmware($a);
					//echo $outofdate . "\n";
				}
			}
			//exit(2);
		}
		
		if ($outofdate == "yes")
		{
			echo "\nFirmware Out Dated. Please Proceed to Firmware Update Page in order to update firmware\n";
			exit(2);
		}		

		if (strtoupper($test_type) == "SILENT" || strtoupper($test_type) == "MEDIA" || strtoupper($test_type) == "ALL")
		{
			if (isset($prod->mp_card))
			{
				//Stop sngmp_server_ctrl
				$sngmp_stop_error = $prod->sngmp_server("stop");		
			
				if ($sngmp_stop_error == "yes")
				{
					//Error
					echo "Error stopping media processing service\n";
					echo "Please contact sangoma technical support at techdesk@sangoma.com for assistance\n";
					exit(2);
				}
			}
		}
		
		//Stops smg
		$prod->smg("stop");
		
		if (strtoupper($test_type) == "TDM" || strtoupper($test_type) == "SILENT" || strtoupper($test_type) == "ALL")
		{	
			if (isset($prod->a101count) || isset($prod->a102count) || isset($prod->a104count) || isset($prod->a108count) || isset($prod->a116count))
			{
				//Stops wanrouter
				$error = $prod->wanrouter("stop");
			}
		}		
		
		//Backup configuration files
		echo "Backing up Configuration\n";
		$prod->backup();
		
		//Found a card, start creating the configuration files
		echo "Creating Test Configuration Files\n";
		
		if (strtoupper($test_type) == "SILENT" || strtoupper($test_type) == "TDM" || strtoupper($test_type) == "ALL")
		{
			if (isset($prod->a101count) || isset($prod->a102count) || isset($prod->a104count) || isset($prod->a108count)|| isset($prod->a116count))
			{
				$prod->line_type = strtoupper($line_type);
				$prod->create_wanpipe_devices();
			}
		}
		
		if (strtoupper($test_type) == "SILENT" || strtoupper($test_type) == "MEDIA" || strtoupper($test_type) == "ALL")
		{
			if (isset($prod->mp_card))
			{
				$prod->ifcfg();
				$prod->sngtc_server_file();
			}
		}
		
		//TDM Test
		if (strtoupper($test_type) == "SILENT" || strtoupper($test_type) == "TDM" || strtoupper($test_type) == "ALL")
		{
			if (isset($prod->a101count) || isset($prod->a102count) || isset($prod->a104count) || isset($prod->a108count) || isset($prod->a116count))
			{
				//Start Wanrouter
				echo "Starting the TDM Driver\n";
				$error = $prod->wanrouter("start");
				$test1_fail = array();
				$test2_fail = array();
			}
			
			if ($error == "")
			{	
			    if ($physical == "") {

					echo "Placing all TDM Ports in Digital Loopback mode\n";	

					for ($l = 1; $l <= $prod->total_span; $l++)
					{
						$prod->digital_loopback($l);
					}					
				}

				echo "Waiting for TDM Ports to become Connected\n";
				$prod->wanrouter_connected();					
				echo "TDM Ports now Connected\n";
				
				echo "Testing TDM Boards:\n";
				echo "Running test through the echo canceler:\n";
				
				//Put all in mpd mode
				for ($l = 0; $l <= $prod->total_span; $l++)
				{
					$prod->mpd($l);
				}
				
				$count =0;
				$lastspan = "";

				do
				{
					$count++;
					if ($repeat == "yes")
					{
						$lastspan = "";
						echo "Repeating HDLC test to confirm port failures\n";
					}
					
					$test_output = $prod->hdlc_test();
					
					//display output
					//echo "Test Output:\n";
					for ($ll = 0; $ll < count($test_output); $ll++)
					{
						if ($test_output[$ll] == "|result=passed|")
						{
							$if = "passed";
							unset($test2_fail);
						}
						else
						{
							$if = "failed";
						}
					}	
					//echo "if = $if\n";
					if ($if == "passed")
					{
						echo "Self-Test Results\n";
						echo "All Spans <font color='green'><b>PASSED</b></font> the Self-Test with Echo Cancellation ENABLED\n";
						//echo "$test_output[45]\n";
						$count = 2;
					}
					elseif ($if == "failed")
					{
						if ($count == 2)
						{
							echo "Self-Test Results\n";
							echo "The following ports <font color='red'><b>FAILED</b></font> the Self-Test with Echo Cancellation ENABLED\n";
						}
						
						for ($ll = 0; $ll < count($test_output); $ll++)
						{
							//echo "i am here \n";
							if ($test_output[$ll] == "|result=failed|")
							{
							}
							elseif (preg_match('/failed/',$test_output[$ll]))
							{
								$cc++;
								//echo "$test_output[$ll]\n";
								$values = explode("|", $test_output[$ll]);
								//echo $values[1] . "\n";
								$portandchan = $prod->token_name($values[1]);
								$span = substr($portandchan,1,1);
								if ($lastspan != $span)
								{
									//echo "Span Failed = $port\n";
									$test1_fail[$span] = $prod->translate[$span]['port'];
									if ($count == 2)
									{
										if ($_SESSION['embedded'])
										{
											echo " <b><a href='../identify/identify_ui.php?embedded=true&card=" . $prod->translate[$span]['name'] . "&card_num=" . $prod->translate[$span]['card_num'] . "&port_num=" .  $prod->translate[$span]['port'] . "&pci_slot=" . $prod->translate[$span]['pci_slot'] . "&pci_bus=" . $prod->translate[$span]['pci_bus'] . "&echo=" . $prod->translate[$span]['echo'] . "' target='_blank'> ". $prod->translate[$span]['name'] . "</b></a>, Board Number = " . $prod->translate[$span]['card_num'] . ", Port Number = " . $prod->translate[$span]['port'] . "\n";
										}
										else
										{
											echo " <b><a href='../identify/identify_ui.php?card=" . $prod->translate[$span]['name'] . "&card_num=" . $prod->translate[$span]['card_num'] . "&port_num=" .  $prod->translate[$span]['port'] . "&pci_slot=" . $prod->translate[$span]['pci_slot'] . "&pci_bus=" . $prod->translate[$span]['pci_bus'] . "&echo=" . $prod->translate[$span]['echo'] . "' target='_blank'> ". $prod->translate[$span]['name'] . "</b></a>, Board Number = " . $prod->translate[$span]['card_num'] . ", Port Number = " . $prod->translate[$span]['port'] . "\n";
										}
									}
									$lastspan = $span;
								}
								
								$repeat = "yes";
							}
						}
						
						$hdlc_error = "yes";
					}
				} while ($count != 2);
				
				$file = array("Self-Test Results with Echo Cancellation ENABLED", "");
				$prod->append_file($file);
				$prod->append_file($test_output);				
				
				echo "\n";
				
				echo "Running test with echo cancelation bypassed\n";
				
				//Put all in bypass disable mode
				for ($l = 1; $l <= $prod->total_span; $l++)
				{
					$prod->bypass_disable($l);
				}


				$count =0;
				$repeat = "";
				$lastspan = "";
				
				//Command for debuging selftest
				/*$cmd = "wanpipemon -i w1g1 -c Tddlb";
				exec ($cmd);
				$cmd = "wanpipemon -i w4g1 -c Tddlb";
				exec ($cmd);				
				$cmd = "wanpipemon -i w8g1 -c Tddlb";
				exec ($cmd);*/
				
				unset($test_output);
				$test_output = array();
				
				do
				{
					$count++;
					if ($repeat == "yes")
					{
						$lastspan = "";
						echo "Repeating HDLC test to confirm port failures\n";
					}	
					$test_output = $prod->hdlc_test();
						
					//Display Output
					//echo "Test Output\n";
					for ($ll = 0; $ll < count($test_output); $ll++)
					{
						if ($test_output[$ll] == "|result=passed|")
						{
							$if = "passed";
							unset($test2_fail);
						}
						else
						{
							$if = "failed";
						}
					}	
					
					if ($if == "passed")
					{
						echo "Self-Test Results\n";
						echo "All Spans <font color='green'><b>PASSED</b></font> the Self-Test with Echo Cancellation BYPASSED\n";
						$count = 2;
					}
					elseif ($if == "failed")
					{
						if ($count == 2)
						{
							echo "Self-Test Results\n";
							echo "The following ports <font color='red'><b>FAILED</b></font> the Self-Test with Echo Cancellation BYPASSED\n";
						}
						
						$ll = 0;
						$lastspan = "";
						$span = "";
						$portandchan="";
						for ($ll = 0; $ll < count($test_output); $ll++)
						{
							//echo "i am here \n";
							if ($test_output[$ll] == "|result=failed|")
							{
							}
							elseif (preg_match('/failed/',$test_output[$ll]))
							{
								//echo "$test_output[$ll]\n";
								$values = explode("|", $test_output[$ll]);
								//echo $values[1] . "\n";
								$portandchan = $prod->token_name($values[1]);
								$span = substr($portandchan,1,1);
								if ($lastspan != $span)
								{
									//$_SESSION['failures'][$ll] = $span;
									//echo "Span Failed = $port\n";
									//echo "<b>" . $prod->translate[$span]['name'] . "</b>, Card Number = " . $prod->translate[$span]['card_num'] . ", Port Number = " . $prod->translate[$span]['port'] . "\n";
									$test2_fail[$span] = $prod->translate[$span]['port'];
									if ($count == 2)
									{
										if ($_SESSION['embedded'])
										{
											echo " <b><a href='../identify/identify_ui.php?embedded=true&card=" . $prod->translate[$span]['name'] . "&card_num=" . $prod->translate[$span]['card_num'] . "&port_num=" .  $prod->translate[$span]['port'] . "&pci_slot=" . $prod->translate[$span]['pci_slot'] . "&pci_bus=" . $prod->translate[$span]['pci_bus'] . "&echo=" . $prod->translate[$span]['echo'] . "' target='_blank'> ". $prod->translate[$span]['name'] . "</b></a>, Board Number = " . $prod->translate[$span]['card_num'] . ", Port Number = " . $prod->translate[$span]['port'] . "\n";
										}
										else
										{
											echo " <b><a href='../identify/identify_ui.php?card=" . $prod->translate[$span]['name'] . "&card_num=" . $prod->translate[$span]['card_num'] . "&port_num=" .  $prod->translate[$span]['port'] . "&pci_slot=" . $prod->translate[$span]['pci_slot'] . "&pci_bus=" . $prod->translate[$span]['pci_bus'] . "&echo=" . $prod->translate[$span]['echo'] . "' target='_blank'> ". $prod->translate[$span]['name'] . "</b></a>, Board Number = " . $prod->translate[$span]['card_num'] . ", Port Number = " . $prod->translate[$span]['port'] . "\n";
										}

									}
									$lastspan = $span;
								}
								
								$repeat = "yes";
							}
							//echo "$test_output[$ll]\n";
							
							$hdlc_error = "yes";
						}
					}
				} while ($count != 2);
				//print_r ($issue_array);
				$file = array("Self-Test Results with Echo Cancellation BYPASSED", "");
				$prod->append_file($file);
				$prod->append_file($test_output);				
				
				echo "\n";	
				//Stop Wanrouter
				echo "Stopping the TDM Driver\n";
				$stop_error = $prod->wanrouter("stop");
				
				if ($stop_error != "")
				{
					echo "There was an error stopping the TDM Driver.\n";
					echo "Please contact Sangoma Technical Support at techdesk@sangoma.com for more help with the issue\n";
					exit(2);
				}									
			}
			elseif ($error = "wanrouter error")
			{
				echo "There was an error starting the TDM Driver.\n";
				echo "Please contact Sangoma Technical Support at techdesk@sangoma.com for more help with the issue\n";
				exit(2);
			}	
		}

		//Media Test
		if (strtoupper($test_type) == "SILENT" || strtoupper($test_type) == "MEDIA" || strtoupper($test_type) == "ALL")
		{			
			$mp_test = array();	
			echo "Starting Media Processing Service\n";
			if (isset($prod->mp_card))
			{	
				//Start sngmp_server_ctrl
				$prod->sngmp_server("start");
			}
		
			//Start SMG
			//$prod->smg("start");
		
			//Start Test
			echo "\nTesting Devices\n";
			echo "===============\n";
			echo "\n";
				
			if (isset($prod->mp_card))
			{
				echo "Testing Media Processing Boards:\n";
				
				if (strtoupper($media) == "ALL")
				{
					for ($a = 0; $a < count($prod->mp_cards); $a++)
					{
						echo "Testing: " . $prod->mp_cards[$a] . "\n";
						
						//Bring interfaces up
						$prod->interface_up($a);
						
						//Run the test
						$output = $prod->run_sngmp_bert($a);
					
						//Display output of bert command
						if ($output[$a] == 0)
						{
							echo $prod->mp_cards[$a] . " <font color='green'><b>PASSED</b></font> the Self-Test\n";
						}
						else
						{
							echo $prod->mp_cards[$a] . " <font color='red'><b>FAILED</b></font> the Self-Test\n";
							$media_error = "yes";
						}
					}			
					echo "\n";
				}
				else
				{
					//Check to see if Media Processing Card Exists
					if (!in_array($media,$prod->mp_cards))
					{
						echo "Media Processing device not found on system. Please specifiy the right device.\n";
						exit(2);
					}

					echo "Testing: " . $media . "\n";
						
					//Bring interfaces up
					$prod->interface_up($media);
						
					//Run the test
					$output = $prod->run_sngmp_bert($media);
				
					//Display output of bert command
					if ($output[$a] == 0)
					{
						echo $prod->mp_cards[$a] . " <font color='green'><b>PASSED</b></font> the Self-Test\n";
					}
					else
					{
						$mp_test[$a] = $prod->mp_cards[$a];
						echo $prod->mp_cards[$a] . " <font color='red'><b>FAILED</b></font> the Self-Test\n";
						$media_error = "yes";
					}						
				}
			}
				
				
			echo "Stopping Media Processing Service\n";
			if (isset($prod->mp_card))
			{
				//Stop sngmp_server_ctrl
				$sngmp_stop_error = $prod->sngmp_server("stop");
			
			}
			
			if ($sngmp_stop_error == "yes")
			{
				//Error
				echo "Error stopping media processing service.\n";
				echo "Please contact sangoma technical support at techdesk@sangoma.com for assistance\n";
				exit(2);
			}
		}
		
	}

	//Generating Log files to tar up
	echo "Creating archive file\n";
	$prod->files_to_send();
	
	//Restore Configuration
	restoreConfig();
	
	//TDM Test
	if (strtoupper($test_type) == "TDM" || strtoupper($test_type) == "SILENT" || strtoupper($test_type) == "ALL")
	{	
		echo "<table width='700px' align='center' border='1'>";
		echo "<th>Board</th>";
		echo "<th>Board Number</th>";
		echo "<th>Port</th>\n";
		echo "<th>Test with Echo</th>";
		echo "<th>Test without Echo</th>";

		//Loop spans
		//$test1_failt[$span] = $port
		//$test2_failt[$span] = $port					
		//$this->translate[$span]['name'] = "A108";
		//$this->translate[$span]['port'] = $port;
		//$this->translate[$span]['card_num'] = $counting;
		
		for ($aa = 1; $aa <= $prod->num_spans; $aa++)
		{			
			//echo "test 1 span = $aa , fail = " . $test1_fail[$aa] . ", port = " .  $prod->translate[$aa]['port'] . "\n";
			//echo "test 2 span = $aa , fail = " . $test2_fail[$aa] . ", port = " .  $prod->translate[$aa]['port'] ."\n";
			echo "<tr>";
			if ($test1_fail[$aa] == $prod->translate[$aa]['port'] || $test2_fail[$aa] == $prod->translate[$aa]['port'])
			{
				if ($_SESSION['embedded'])
			   {
				  echo "<td align='center'><font color='red'><b><a href='../identify/identify_ui.php?embedded=true&card=" . $prod->translate[$span]['name'] . "&card_num=" . $prod->translate[$span]['card_num'] . "&port_num=" .  $prod->translate[$span]['port'] . "&pci_slot=" . $prod->translate[$span]['pci_slot'] . "&pci_bus=" . $prod->translate[$span]['pci_bus'] . "&echo=" . $prod->translate[$span]['echo'] . "' target='_blank'> ". $prod->translate[$span]['name'] . "</a></b></font></td>";
			  }
			  else
			  {
				  echo "<td align='center'><font color='red'><b><a href='../identify/identify_ui.php?card=" . $prod->translate[$span]['name'] . "&card_num=" . $prod->translate[$span]['card_num'] . "&port_num=" .  $prod->translate[$span]['port'] . "&pci_slot=" . $prod->translate[$span]['pci_slot'] . "&pci_bus=" . $prod->translate[$span]['pci_bus'] . "&echo=" . $prod->translate[$span]['echo'] . "' target='_blank'> ". $prod->translate[$span]['name'] . "</a></b></font></td>";
			  }
			}
			else
			{
				echo "<td align='center'>" . $prod->translate[$aa]['name'] . "</td>";
			}
		
			if ($test1_fail[$aa] == $prod->translate[$aa]['port'] || $test2_fail[$aa] == $prod->translate[$aa]['port'])
			{
				echo "<td align='center'><b><font color='red'>" . $prod->translate[$aa]['card_num'] . "</font></b></td>";
				echo "<td align='center'><b><font color='red'>" . $prod->translate[$aa]['port'] . "</font></b></td>";
			}
			else
			{	
				echo "<td align='center'>" . $prod->translate[$aa]['card_num'] . "</td>";
				echo "<td align='center'>" . $prod->translate[$aa]['port'] . "</td>";
			}
			if ($test1_fail[$aa] == $prod->translate[$aa]['port'])
			{
				echo "<td align='center'><b><font color='red'>FAILED</font></b></td>";
			}
			else
			{
				echo "<td align='center'><font color='green'>PASSED</font></td>";
			}
			if ($test2_fail[$aa] == $prod->translate[$aa]['port'])
			{
				echo "<td align='center'><b><font color='red'>FAILED</font></b></td>";
			}
			else
			{
				echo "<td align='center'><font color='green'>PASSED</font></td>";
			}
			echo "</tr>";		
		}
		echo "</table>";		
		
		if ($hdlc_error)
		{
			echo "\n To identify failed port, please click on the board name";
		}
	
		//Media Test	
		echo "\n";
		if (strtoupper($test_type) == "SILENT" || strtoupper($test_type) == "MEDIA" || strtoupper($test_type) == "ALL")
		{	
			//for ($a = 0; $a < count($prod->mp_cards); $a++)
			//echo "Testing: " . $prod->mp_cards[$a] . "\n";
			echo "<table width='400px' align='center' border='1'>";
			echo"<th>MP Interface</th>";
			echo"<th>BERT Test Result</th>";
			
			//Loop Transcoders
			for ($a = 0; $a < count($prod->mp_cards); $a++)
			{
				echo "<tr>";
				if ($prod->mp_cards[$a] == $mp_test[$a])
				{
					echo "<td align='center'><font color='red'><b>" . $prod->mp_cards[$a]  ."</b></font></td>";
					echo "<td align='center'><font color='red'><b>FAILED</b></font></td>";
				}
				else
				{
					echo "<td align='center'>" . $prod->mp_cards[$a]  ."</td>";
					echo "<td align='center'><font color='green'>PASSED</font></td>";
				}
				echo "</tr>";	
			}	
			echo "</table>";		
		}
	}
	
	if ($media_error == "yes" || $hdlc_error == "yes")
	{
		echo "\n\n<font size='+2'>Self Test <font color=\"red\"><b>FAILED</b></font></font>\n";
	}
	else
	{
		echo "\n\n<font size='+2'>Self-Test <font color=\"green\"><b>PASSED</b></font></font>\n";
	}
	
	//echo "Self-Test Complete\n";
}

//Restores Configuration Files
function restoreConfig()
{

	$prod2 = new prod_test;
	$cmd = "cat /proc/net/wanrouter/status | grep -c \"wanpipe\"";

	exec($cmd,$output);

	if ($output[0] > 0)
	{
		echo "Stopping the TDM Driver\n";
        $stop_error = $prod2->wanrouter("stop");

		if ($stop_error != "")
		{
			echo "There was an error stopping the TDM Driver.\n";
			echo "Please contact Sangoma Technical Support at techdesk@sangoma.com for more help with the issue\n";
	   		exit(2);
		}
	}

	$prod = new prod_test;
	$prod->smg_path();
	
	//Restore Configuration Files
	echo "Restoring Configuration Files\n";
	$prod->restore();
	unset ($prod);
}

function usage($argv)
{
?>
 Usage:
<?php echo $argv; ?> <option>

<option> can be any of the following below:
--help			Displays all arguments that can be passed
--all E1/T1		Runs all tests with no user interaction in either T1 or E1

--TDM T1		Runs the TDM Self Test in T1
--TDM E1		Runs the TDM Self Test in E1

--media ethX		Runs the media processing test for specific Media Processing Device
--media all		Runs the media processing test for all Media Processing Cards Detected

--silent		Runs all tests with no user interaction in E1

<?php
}
?>
