<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

session_start();

/**
*	Generates Media Gateway XML files
*	@param: $data
*				database object
*/
function xml_gen($data) {
	//Pull information regarding all megaco profiles from cardinfo.db

	$file_location = $_SESSION['smg_path'] . '/autoload_configs/';
	$file_name = "mod_media_gateway.conf.xml";
	
	$mg_profiles_handle = fopen($file_name, 'w') or die("can't open file");

	//Pull megaco data
	$profile_array = pull_data('mg_profiles','*',$data,'id');

        $file = $_SESSION['smg_root_path'] . "/conf/autoload_configs/modules.conf.xml";
        $file2 = $_SESSION['smg_root_path'] . "/conf/autoload_configs/modules.conf.xml2";

	$file_open = file_get_contents($file);
	if (empty($profile_array)) {
		//remove entry in modules.conf.xml
 		$file_open = preg_replace ('/.*mod_media_gateway.*/', '    <!--<load module="mod_media_gateway" critical="true" />-->',$file_open);
	}
	else {
		//enter in modules.conf.xml to load
 		$file_open = preg_replace ('/.*mod_media_gateway.*/', '    <load module="mod_media_gateway" critical="true" />',$file_open);
	}
	file_put_contents($file,$file_open);

	$mg_profiles_file ='
<configuration name="media_gateway.conf" description="Megaco Controllee">
	<mg_profiles>';
	
	foreach ($profile_array as $profile) {
		$mg_profiles_file .='
		<mg_profile name="' . $profile['name'] . '">
			<param name="protocol" value="' . strtoupper($profile['protocol']) . '" />
			<param name="version" value="' . $profile['megaco_version'] . '" />
			<param name="local-ip" value="' . $profile['ip_addr'] . '" />
			<param name="port" value="' . $profile['port'] . '" />
			<param name="domain-name" value="' . $profile['domain'] . '" />
			<param name="message-identifier" value="' . $profile['mid'] . '" />
			<param name="rtp-termination-id-prefix" value="' . $profile['term_prefix'] . '" />
			<param name="codec-prefs" value="$${global_codec_prefs}" />
			<param name="rtp-ip" value="' . $profile['rtp_ip'] . '" />
			<param name="t38-fax-notify" value="' . strtoupper($profile['t38']) . '" />
			
			<physical_terminations>';
			
			//Enter mg_channels associated to this mg_profile to the file
			$cards = pull_cards($data);
		 	$span = 1;	
			foreach ($cards as $card) {
				//Check for mg_channels table
				if ($data->check_for_table('sqlite:sqlite/cardinfo.db',$card['name'] . '_' . $card['num'] . '_m2ua_channels')) {
					$table = $card['name'] . '_' . $card['num'] . '_m2ua_channels';
					//Pull all data from that particular channels table and enter it into the db
					$mg_profiles = pull_data($table,'*',$data);
					foreach ($mg_profiles as $mg){
						$location = 0;
						unset($base);
						$finished_ports = pull_data('finished_ports','*',$data,'id');
						foreach ($finished_ports as $finished) {
							if ($finished['card'] == $card['name'].'_'.$card['num'].'_'.$mg['port_id']) {
								$span = $finished['span'];
								break;
							}
						}
						if ($mg['mg_profile'] == $profile['name']) {
							$table = "generated_ports";
							$gen_ports = pull_data($table,'id,card',$data);

							foreach ($gen_ports as $gen_port) {
								$card_name = $card['name'].'_'.$card['num'].'_'.$mg['port_id'];
								if ($gen_port['card'] == $card_name)
									$mg['ss7_span'] = $gen_port['id'];
							}							
							$channel_map = "";
							$chans = explode(',',$mg['channel_map']);
							if (count($chans) == 2) {
								$a = 1;
								foreach ($chans as $chan) {
									$s_pos = strpos($chan,'s');
									$g_pos = strpos($chan,'g');
									if ($s_pos !== false || $g_pos !== false) {
										if ($s_pos !== false)
											$sig_type = 's';
										elseif ($g_pos !== false)
											$sig_type = 'g';
									}
									else{
										$channel_map = $chan;
										$channels = explode ('-',$chan);
										if ($sig_type == 's')
											$base = ($mg['base'] + $channels[0]) - 1;
										elseif ($sig_type == 'g')
											$base = ($mg['base'] + $channels[0]) - 2;

										unset($sig_type);
										$mg_profiles_file.='
					<map termination-id-prefix="' . $mg['prefix'] . '" termination-id-base="' . $base . '" tech="freetdm" channel-prefix="wp' . $span . '" channel-map="' . $channel_map . '" />';
									}
									$a++;
								}
							}
							elseif (count($chans) > 2) {
								$a = 1;
								foreach ($chans as $chan) {
									$s_pos = strpos($chan,'s');
									$g_pos = strpos($chan,'g');
									if ($s_pos !== false || $g_pos !== false) {
										if ($s_pos !== false)
											$sig_type = 's';
										elseif ($g_pos !== false)
											$sig_type = 'g';
										
										$location = $a + 1;
									}
									else {
										if ($a == 1) {
											//First portion of the channel map. No signalling link found here.
											$channel_map = $chan;
											$base = $mg['base'];
										}
										elseif ($a == count($chans)) {
											//signalling link present just before the end
											$channels = explode ('-',$chan);
											if ($sig_type == 's')
												$base = ($mg['base'] + $channels[0]) - 1;
											elseif ($sig_type == 'g')
												$base = ($mg['base'] + $channels[0]) - 2;
											
											$channel_map = $chan;
										}
										else {
											//placed just in case of multiple signalling links
											$channels = explode ('-',$chan);
											if ($sig_type == 's')
												$base = ($mg['base'] + $channels[0]) - 1;
											elseif ($sig_type == 'g')
												$base = ($mg['base'] + $channels[0]) - 2;
											
											$channel_map = $chan;
										}
									}
									
									//$channel_map = $chans[0].','.$chans[2];
									$a++;
									if ($a != $location) {
										$mg_profiles_file.='
					<map termination-id-prefix="' . $mg['prefix'] . '" termination-id-base="' . $base . '" tech="freetdm" channel-prefix="wp' . $span . '" channel-map="' . $channel_map . '" />';
									}
								}
								unset($sig_type);
							}
							else {
								//No signalling channels
								$channel_map = $mg['channel_map'];
								$base = $mg['base'];
								$mg_profiles_file.='
					<map termination-id-prefix="' . $mg['prefix'] . '" termination-id-base="' . $base . '" tech="freetdm" channel-prefix="wp' . $span . '" channel-map="' . $channel_map . '" />';
							}
							//update generated ports table
							$generate_update = "mg_name = \"" . $mg['mg_profile'] . "\"";
							$generate_table = "generated_ports";
							$generate_where = "id = " . $finished['id'];
							$data->update_table ('sqlite:sqlite/cardinfo.db', $generate_table, $generate_update, $generate_where);
						}
						$span++;
					}
				}
			}	
			$mg_profiles_file .='
			</physical_terminations>

			<peers>';
		
		//find all peer names associated to this profile
		$megaco_peer = pull_data($profile['name'] . '_peers', 'name,mid',$data , 'id');		
		foreach ($megaco_peer as $peer) {
			if ($peer['mid'] != "") {
				$mg_profiles_file .='
				<param name="peer" value="' . $peer['name'] . '" />';
			}
		}
		unset($megaco_peer);
		$mg_profiles_file .='
			</peers>
		</mg_profile>			
			';
	}
	$mg_profiles_file .='
	</mg_profiles>
	
	<mg_peers>';
	
	unset ($profile);
		
	//Pull all peers from all db's
	foreach ($profile_array as $profile) {
		$peer_data = pull_data($profile['name'] . '_peers','*',$data ,'id');
		//Print each peer
		foreach ($peer_data as $peer) {
			if ($peer['mid'] != "") {
				$mg_profiles_file .='
				<mg_peer name="' . $peer['name'] . '">
					<param name="ip" value="' . $peer['ip_addr'] . '" />
					<param name="port" value="' . $peer['port'] . '" />
					<param name="encoding-scheme" value="' . strtoupper($peer['encoding_scheme']) . '" />
					<param name="transport-type" value="' . strtoupper($peer['protocol']) . '" />
					<param name="message-identifier" value="' . $peer['mid'] . '" />';
				if ($peer['mid'] == "DOMAIN")
					$mg_profiles_file.= '
					<param name="domain-name" value="' . $peer['domain'] . '" />';
				$mg_profiles_file.='
				</mg_peer>';
			}
		}
	}
	
	$mg_profiles_file .='
	</mg_peers>
</configuration>';
	
	fwrite($mg_profiles_handle, $mg_profiles_file);
	fclose($mg_profiles_handle);
		
	shell_exec("mv " . $file_name . " " . $file_location);  //Moves the file to the appropriate location	
}

/**
* 	Pulls card information out of card_present table
*
*	@param: $data
*				Contians the database object
*	@return: array
*/

function pull_cards($data)
{
	$temp_cards = pull_data('card_present','id,dev_name',$data,'id');
	$a = 0;
	foreach($temp_cards as $card) {
		$card_explode = explode ('-', $card['dev_name']);
		if ($card_explode[1] == "A101" || $card_explode[1] == "A102" || $card_explode[1] == "A104" || $card_explode[1] == "A108" || $card_explode[1] == "A116" || $card_explode[1] == "B601")
			$cards[$a]['name'] = $card_explode[1];
			$cards[$a]['num'] = $card['id'];
		$a++;
	}
	
	return $cards;
}


/**
*	Pulls data out of the database and returns it in an array
*	@param table
*			database table name
*	@param param
*			sql select parameter
*	@param $data
*			database object
*	@return array
*/
function pull_data($table,$param,$data,$id=null,$db=null) {
	$c = 0;
	$profile_array = array();
	
	if ($db == "") 
		$db = 'sqlite:sqlite/cardinfo.db';
	
	if ($id == "")
		$id = "port_id";
	
	
	//Table exists
	if ($data->check_for_table ($db, $table) > 1)
	{
		$select = "SELECT " . $param . " FROM " . $table . " ORDER BY " . $id . " ;";
		try
		{
			//open the database
			$db = new PDO($db);

			$result = $db->query($select);
	
			if (!empty($result)) {	
				foreach($result as $row)
				{
					$profile_array[$c] = $row;
					$c++;
				}
			}
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			//echo "hello <br />";
			print 'Exception : '.$e->getMessage();
		}
	}	
	
	return $profile_array;
	
}


/**
*	Saves mg profile tables in permanent tables
*
*	@param data
*		database object
*/
function save_mg_tables($data) {
	
	$db="sqlite:sqlite/cardinfo.db";	
	
	//pull mg profile names and backup mg peers tables
	$profile_array = pull_data('perm_mg_profiles','*',$data,'id',$db);
	foreach ($profile_array as $profile) {
		if ($data->check_for_table($db,$profile['name'].'_peers') > 1)
			//$data->drop_table($db,$profile['name'].'_peers');
			$data->drop_table($db,'perm_'.$profile['name'].'_peers');		
	}
	

	//drop old tables
	$profile_array = pull_data('perm_mg_profiles','*',$data);
	foreach ($profile_array as $profile) {
			if ($data->check_for_table('sqlite:sqlite/cardinfo.db','perm_'.$profile['name'].'_peers') > 1)
					$data->drop_table('sqlite:sqlite/cardinfo.db','perm_'.$profile['name'].'_peers');
	}

	if ($data->check_for_table('sqlite:sqlite/cardinfo.db','perm_mg_profiles') > 1)
			$data->drop_table('sqlite:sqlite/cardinfo.db','perm_mg_profiles');
	
	
	//save mg_profiles table
	if ($data->check_for_table('sqlite:sqlite/cardinfo.db','mg_profiles') > 1) {
			
		$table_name="mg_profiles";
		$new_table = "perm_mg_profiles";
		$parameters="*";
		$data->select_into ($db, $table_name, $parameters, $new_table);
	}
	
	//pull mg profile names and backup mg peers tables
	$profile_array = pull_data('mg_profiles','*',$data,'id');
	foreach ($profile_array as $profile) {
			
		$table_name=$profile['name'].'_peers';
		$new_table='perm_'.$profile['name'].'_peers';
		$parameters="*";
		$data->select_into ($db, $table_name, $parameters, $new_table);		
	}
}

/**
*	restores mg profile tables from permanent tables
*
*	@param data
*		database object
*/
function restore_mg_tables($data) {
	
	$db="sqlite:sqlite/cardinfo.db";
	
	//save mg_profiles table
	if ($data->check_for_table('sqlite:sqlite/cardinfo.db','mg_profiles') > 1) {
		$data->drop_table('sqlite:sqlite/cardinfo.db','mg_profiles');
			
		$table_name="mg_profiles";
		$new_table = "perm_mg_profiles";
		$parameters="*";
		$data->select_into ($db, $new_table, $parameters, $table_name);
	}
	
	//pull mg profile names and backup mg peers tables
	$profile_array = pull_data('mg_profiles','*',$data);
	foreach ($profile_array as $profile) {
		if ($data->check_for_table('sqlite:sqlite/cardinfo.db',$profile['name'].'_peers') > 1)
			$data->drop_table('sqlite:sqlite/cardinfo.db',$profile['name'].'_peers');
			
		$table_name=$profile['name'].'_peers';
		$new_table='perm_'.$profile['name'].'_peers';
		$parameters="*";
		$data->select_into ($db, $new_table, $parameters, $table_name);		
	}
}

/**
*	resets mg profile tables
*
*	@param data
*		database object
*/
function reset_mg_tables($data,$db=null) {
	
	if ($db=="")
		$db="sqlite:sqlite/cardinfo.db";

	//pull mg profile names and backup mg peers tables
	$profile_array = pull_data('mg_profiles','*',$data,'id',$db);
	foreach ($profile_array as $profile) {
		if ($data->check_for_table($db,$profile['name'].'_peers') > 1)
			$data->drop_table($db,$profile['name'].'_peers');	
	}	
	
	//drop mg_profiles table
	if ($data->check_for_table($db,'mg_profiles') > 1) {
		$data->drop_table($db,'mg_profiles');
	}
}


?>
