<?php
/*
	NSG WebUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Starts PHP Sessions
session_start();
ini_set('session.bug_compat_warn', 0);
ini_set('session.bug_compat_42', 0);

if (empty($_POST))
	include '../check_referer.php';	
	
if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{	
	$db_location = "sqlite:../sqlite/cardinfo.db";
	$megaco_table = "mg_profiles";
	
	//Include Statements
	include '../database_classes.php';
	include 'view_megaco_profiles_class.php';
	
	//PHP Class Constructors
	$data = new database_class;	
	$megaco_view = new view_megaco_profiles_class;
	
	//Holds the number of entries variable
	$num_entries = $_SESSION['num_entries'];
	$delete_confirm = false;
	
	$_SESSION['id_num'] = "";
	
	//Check if db tables created for mg_profiles. 
	$exist = $megaco_view->db_table_check($data,$megaco_table);
	//Check if a profile exists. If not, redirect to adding a new profile
	if (!$megaco_view->check_for_row($data,$megaco_table)){
		$_SESSION['no_profile'] = true;
		header('Location:create_megaco_profile.php');
	}
	
	//If create profile clicked on
	if ($_REQUEST['create'] == "Add New Profile")
	{
		//Redirects to hardware probe
		$_SESSION['no_profile'] = true;
		header( 'Location:create_megaco_profile.php' );
	}
	if ($_REQUEST['delete'] == "Remove") {
		$param = "id = " . $_SESSION['delete_id'];
		//Remove peers table
		$profile_name = $data->select_statement($db_location,$megaco_table,'name',$param);	
		$data->drop_table($db_location,$profile_name['name'] . '_peers');
			
		$data->delete_generic($db_location, $megaco_table, $param);
		$_SESSION['delete_id'] = "";
	}
	
	//Goes through the request variables and checks what was clicked on
	if ($_REQUEST) {
		foreach ($_REQUEST as $key => $value)
		{	
			$exists = $data->check_for_table ($db_location, $megaco_table);
			
			for ($x = 0; $x <= $num_entries+100; $x++)
			{
				//Checks to see which Delete button was pressed
				if ($key == "delete$x" && $value == "Delete Profile")
				{
					//Display confirmation box for deletion of object from db
					$_SESSION['delete_id'] = $x;
					$delete_confirm = true;
				}
				if ($key == "config$x" && $value == "Edit Profile")
				{
					//Takes the last value in the key to know the database ID number clicked
					$rest = substr($key, -1);
					
					//Sets the ID number into a session variable to go to the redirection and edit the profile
					$_SESSION['id_num'] = $rest;
				
					//Redirects to the create profile page
					$_SESSION['edit_mg'] = true;
					header( 'Location:create_megaco_profile.php' ) ;
				}
			}
		}
	}
	
	//Retrieve Profile Information
	$megaco_view->get_profiles();
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';
		//include 'database_classes.php';	
		include '../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("View Media Gateway Profiles", "../../../style.css",'');		
	}	


	if (!$delete_confirm)
		$megaco_view->display_profiles($data);
	else
		$megaco_view->display_delete($data);
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:../index.php' ) ;
}

?>