<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class create_megaco_profile
{
	
	private $error= "";						//Contains validation errors
	public $error_counter="";				//Contains the number of errors in the form
	public $edit="";						//Contains database returned values for editing
	public $profile_name = array();			//Contains the profile names within the database
	public $peer_profile_name = array();
	public $peer_profile_counter = "";
	public $profile_counter = "";			//Contains the number of profiles in the database
	private $pick="";						//Contains the data for what was returned to the form

	public $db_location = "sqlite:../sqlite/cardinfo.db";
	public $table_name = "mg_profiles";
	
	
	public function create_profile_name($data) {		

		$id = $data->select_statement_order_by($this->db_location,$this->table_name,'id','','id','-1');
		$a = $id['id'] + 1;
		?>
		<form name="create_profile" method="post">  		   
	    <input type="hidden" name="id_number" value="<?php echo $a; ?>" />
    	<table class="mytable" width='100%'>
        	<th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Media Gateway Profile Configuration</th> 
    		<tr>
				<td class="mytablesubheader" width='50%'>Profile Name</td>
				<td align="left" width='30%'><input type="text" name="name" value="MG_profile<?=$a?>" style="text-align:left; width:150px" /></td>
				<td width='20%'><?php echo $this->error['profile_name']; ?></td>
			</tr>
        </table>
        <br />
        <table width="100%">
        <tr>
		<td width="1%"><input type="submit" name="create_mg" value='Create Media Gateway Profile'  <?php echo $_SESSION['button_class']; ?>/></td>
		<td align="right"><input type="submit" name="cancel" value="Cancel Configuration" <?php echo $_SESSION['button_class']; ?>/></td>
        </tr>
        </table>
	</form>
		<?php
	}
	
	public function create_peer($data) {		

		$id = $data->select_statement_order_by($this->db_location,$_SESSION['profile_name'] . '_peers','id','','id','-1');
		$a = $id['id'] + 1;
		?>
		<form name="create_peer" method="post">  		   
	    <input type="hidden" name="id_number" value="<?php echo $a; ?>" />
        <input type="hidden" name="mg_profile" value="<?=$_SESSION['profile_name']?>" />
    	<table class="mytable" width='100%'>
        	<th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Add <?=$_SESSION['profile_name']?> Peer</th> 
    		<tr>
				<td class="mytablesubheader" width='30%'>Peer Name</td>
				<td align="left" width='50%'><?=$_SESSION['profile_name']?>_<input type="text" name="peer_name" value="Peer<?=$a?>" style="text-align:left; width:150px" /></td>
				<td width='20%'><?php echo $this->error['peer_name']; ?></td>
			</tr>
            <tr>
            	<td class="mytablesubheader" width='30%'></td>
                <td>
                	<input type="submit" name="create_peer" value='Create Peer'  <?php echo $_SESSION['button_class']; ?>/><input type="submit" name="cancel_peer" value="Cancel" <?php echo $_SESSION['button_class']; ?>/>
                </td>
            </tr>
        </table>
		</form>
		<?php
	}
	
	//Retrieves all media gateway profile names
	function get_profiles()
	{
		$a = 0;

		$select = "SELECT * FROM " . $this->table_name . ";";

		$data = new database_class;
		
		$table = $data->check_for_table($this->db_location,$this->table_name);
		if ($table >1 )
		{
			try
			{
				//open the database
				$db = new PDO($this->db_location);
	
				$result = $db->query($select);
			
				foreach($result as $row) {
					$this->profile_name[$a] = $row;
					$a++;
				}
				// close the database connection
				$db = NULL;
			}
			catch(PDOException $e)
			{
				print 'Exception : '.$e->getMessage();
			}
		}
	
		$this->profile_counter = $a;
	}	
	
		//Retrieves all media gateway profile names
	function get_peer_profiles($table="")
	{
		$a = 0;
		if ($table == "") 
			$table = $_SESSION['profile_name'] . "_peers";
			
		$select = "SELECT * FROM " . $table . ";";

		$data = new database_class;
		
		$table = $data->check_for_table($this->db_location,$table);
		if ($table >1 )
		{
			try
			{
				//open the database
				$db = new PDO($this->db_location);
	
				$result = $db->query($select);
			
				foreach($result as $row)
				{
					$this->peer_profile_name[$a] = $row;
					$a++;
				}
				// close the database connection
				$db = NULL;
			}
			catch(PDOException $e)
			{
				print 'Exception : '.$e->getMessage();
			}
		}
	
		$this->peer_profile_counter = $a;
	}	
	
	
	//Aggregated View Display
	function aggregated_view($data) {
		//Pull information from db if available and place it in the appropriate boxes
		$this->get_data_values($data,$this->table_name,$_SESSION['id_num']);
		$this->check_submit();
		$issue = false;
		$_SESSION['profile_name'] = $this->edit['name'];
		$this->get_peer_profiles();		
		for ($b = 0; $b < $this->peer_profile_counter; $b++) {
			if ($this->peer_profile_name[$b]['ip_addr'] == "" && $this->peer_profile_name[$b]['protocol'] == "" && $this->peer_profile_name[$b]['encoding_scheme'] == "" && 	$this->peer_profile_name[$b]['mid'] == "") {
				$issue = true;
				break;
			}
		}		
		
		if  ($this->peer_profile_counter == 0 || $issue) {
			$notif = new NotificationBox( 'Warning', NotificationBox::Warning );
			if ($this->pick['domain'] == "" && $this->pick['ip_addr'] == "" && $this->pick['port'] == "")
				$notif->add("Media Gateway Profile","You must configure your Media Gateway Profile in order to proceed.");
			if ($this->peer_profile_counter == 0 ) {
				$notif->add("Media Gateway Peer","There are no Peer Profiles created.");
				$notif->add("Media Gateway Peer", "You <b>MUST CREATE</b> a peer profile in order to proceed." );
			}
			
			if ($issue)
				$notif->add("Media Gateway Peer", "You <b>MUST CONFIGURE</b> all peer profiles in order to proceed.");
			
			echo $notif->getHtml();		
			unset($notif);	
		}
		else {
			$notif = new NotificationBox( 'complete', NotificationBox::Checkmark );
			$notif->add("","Media Gateway Configuration Completed.");
			$notif->add("", "Click here to <a href=\"mg_config.php\">view all profiles</a>" );
			echo $notif->getHtml();		
			unset($notif);	
			echo "<br />";
			$notif = new NotificationBox( 'Info', NotificationBox::Info );
			if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
				$notif->add("","Next Step: <a href='../wanrouterhwprobe.php' target='_parent'>Configure TDM Interfaces</a>.");
			else
				$notif->add("","Next Step: <a href='/admin/ss7_tdm_config.php' target='_parent'>Configure TDM Interfaces</a>.");
			echo $notif->getHtml();		
			unset($notif);	

		}
		//$this->get_profiles();
		?>
    <br />
	<form name="create_profile" method="post">  		   
	    <input type="hidden" name="id_number" value="<?php echo $_SESSION['id_num']; ?>" />
        
        <table class="mytable" width='100%'>
        	<th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left"><?=$this->edit['name']?> : Summary</th>  
            <tr>
            	<td class="mytablesubheader" width='50%'>Protocol</td>
                <td align="left" width='50%'>
					<?php 
					if ($this->pick['protocol_megaco'] == "yes")
						echo 'Megaco';
					elseif ($this->pick['protocol_mgcp'] == "yes") 
						echo 'MGCP';
					?>
                </td>
            </tr> 
            <tr>
            	<td class="mytablesubheader" width='50%'>Message Identifier Type</td>
            	<td align="left" width='50%'><?=$this->pick['mid']?></td>
            </tr>            
            <tr>
            	<td class="mytablesubheader" width='50%'>IP Address</td>
                <td align="left" width='50%'><?=$this->pick['ip_addr']?></td>
            </tr>                       
            <tr>
            	<td class="mytablesubheader" width='50%'>Port</td>
            	<td align="left" width='50%'><?=$this->pick['port']?></td>
            </tr>  
            <tr>
            	<td class="mytablesubheader" width='50%'>Domain</td>
            	<td align="left" width='50%'><?=$this->pick['domain']?></td>
            </tr>              
            <tr>
            	<td class="mytablesubheader" width='50%'>Megaco Version</td>
                <td align='left' width='50%'>
				<?php
                	if ($this->pick['megaco_version_1'] == "yes")
						echo "Version 1";
                	if ($this->pick['megaco_version_2'] == "yes")
						echo "Version 2";
                	if ($this->pick['megaco_version_3'] == "yes")
						echo "Version 3";
				?>
                </td>
            </tr>                      
            <!-- <tr>
            	<td class="mytablesubheader" width='50%'>RTP Port Range</td>
                <?php
					if ($this->pick['rtp_port_min'] == "" && $this->pick['rtp_port_max'] == "")
						echo '<td align="left" width="50%"></td>';
					else
						echo '<td align="left" width="50%">' . $this->pick['rtp_port_min'] . ' : ' . $this->pick['rtp_port_max'] . '</td>';
				?>
            </tr> -->
            <tr>
            	<td class="mytablesubheader" width='50%'>RTP IP</td>
                <td align='left' width='50%'><?=$this->pick['rtp_ip']?></td>
            </tr>
            <tr>
            	<td class="mytablesubheader" width='50%'>T.38 Fax</td>
                <td align='left' width='50%'>
				<?php
					if ($this->pick['t38_enable'] == 'yes')
						echo "Enabled";
					if ($this->pick['t38_disable'] == "yes")
						echo "Disabled";
                ?>
                </td>
            </tr>
            <tr>
				<td class="mytablesubheader" width='50%'>Termination Prefix</td>
				<td align="left" width='50%'><?=$this->pick['term_prefix']?></td>     
            </tr>
            <!-- <tr>
				<td class="mytablesubheader" width='50%'>Termination ID Length</td>
            	<td align="left" width='50%'><?=$this->pick['term_id_len']?></td>     
            </tr> -->
            <tr>
            	<td class="mytablesubheader" width='50%'></td>
          		<td width='50%'><input type="submit" name="edit_profile" value='Edit Profile'  <?php echo $_SESSION['button_class']; ?>/></td>
            </tr>
		</table>
		<br />
        
        <table class="mytable" width='100%'>
        	<th colspan="7" class="widget-content-header ui-state-active ui-corner-top" align="left"><?=$this->edit['name']?> : Peers</th>
            <tr>
    		<td class="mytableheader ">Name</td>
            <td class="mytableheader ">Message Identifier Type</td>
            <td class="mytableheader ">IP Address</td>
    	    <td class="mytableheader ">Port</td>
            <td class="mytableheader ">Transport Protocol</td>
            <td class="mytableheader ">Encoding</td>
			<td class="mytableheader "></td>
            </tr>
        <?php
		$this->get_peer_profiles();
		for ($b = 0; $b < $this->peer_profile_counter; $b++)
		{
			echo "<tr>\n";
			if ($_SESSION['last_peer_profile'] == $this->peer_profile_name[$b]['name'])
			{
				echo "<td><b>" . $this->peer_profile_name[$b]['name'] . "</b></td>\n";
			}
			else
			{
				echo "<td>" . $this->peer_profile_name[$b]['name'] . "</td>\n";
			}
			echo "<td>" . $this->peer_profile_name[$b]['mid'] . "</td>\n";
			echo "<td>" . strtoupper($this->peer_profile_name[$b]['ip_addr']) . "</td>\n";
			echo "<td>" . $this->peer_profile_name[$b]['port'] . "</td>\n";
			echo "<td>" . strtoupper($this->peer_profile_name[$b]['protocol']) . "</td>\n";
			echo "<td>" . $this->peer_profile_name[$b]['encoding_scheme'] . "</td>\n";	
			echo "<td align=\"right\">\n";		
			echo "<input type=\"submit\" name=\"config_peer" . $this->peer_profile_name[$b]['id'] . "\" value=\"Edit Peer\" " . $_SESSION['button_class'] . "/>\n";
			echo "<input type=\"submit\" name=\"delete_peer" . $this->peer_profile_name[$b]['id'] . "\" value=\"Delete Peer\" " . $_SESSION['button_class'] . "/>\n";
			echo "</td>\n";

			echo "<tr>\n";
			$num_entries++;
			
		}
		?>      
            <tr>
            	<td align='center' colspan="7" class="widget-content-header ui-state-active ui-corner-bottom"><input type='submit' name='new_peer' value='Add Peer' <?php echo $_SESSION['button_class'];?> /></td>
            </tr>
		</table> 		
     	</form>     		

        <?php
	}
	
	//Display function
	function display($data)
	{	
		require_once '../generic_functions.php';
		$interface_list = get_eth_interfaces();
	
		//Pull information from db if available and place it in the appropriate boxes
		$this->get_data_values($data,$this->table_name, $_SESSION['id_num']);
		$this->check_submit();
		//$this->get_profiles();
		?>
	<form name="create_profile" method="post">
    	<input type="hidden" name="mg_profile_edit" value="mg_profile_edit" />  		   
	    <input type="hidden" name="id_number" value="<?php echo $_SESSION['id_num']; ?>" />
        <input type="hidden" name="profile_name" value="<?=$this->edit['name']?>" />
        
        <table class="mytable" width='100%'>
        	<th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left"><?=$this->edit['name']?> : Gateway Control Options</th>  
            <tr>
            	<td class="mytablesubheader" width='50%'>Protocol</td>
                <td align="left" width='30%'>
                	<select name='protocol'>
                    	<option value='megaco' <?php if ($this->pick['protocol_megaco'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Megaco</option>
<!--                        <option value='mgcp' <?php if ($this->pick['protocol_mgcp'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">MGCP</option> -->
                    </select>
                </td>
                <td width='20%'><?=$this->error['protocol']?></td>
            </tr> 
            <tr>
            	<td class="mytablesubheader" width='50%'>Message Identifier Type</td>
            	<td align="left" width='30%'>
                	<select name='mid'>
                       	<option value='IP-PORT' <?php if ($this->pick['mid_ip_port'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">IP:Port</option>
                    	<option value='DOMAIN' <?php if ($this->pick['mid_domain'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Domain</option>
                    	<option value='IP' <?php if ($this->pick['mid_ip'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">IP</option>                                        
                        <!-- <option value='Custom' <?php if ($this->pick['mid_custom'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Custom</option> -->
                    </select>
                </td>
                <td width='20%'><?php echo $this->error['mid']; ?></td>
            </tr>            
            <tr>
            	<td class="mytablesubheader" width='50%'>Signalling IP</td>
                <!-- <td align="left" width='30%'><input type="text" name="ip_addr" id='ip_addr' value="<?=$this->pick['ip_addr']?>" style="text-align:left; width:150px" /></td> -->
                <td align='left' width='30%'>
                	<select name='ip_addr' id='ip_addr'>
                    <?php
						foreach ($interface_list as $k=>$v) {
							echo '<option value="' . $k . '" ';
							if ($_REQUEST['ip_addr'] == $k)
								echo 'selected="selected"';
							elseif ($this->edit['ip_addr'] == $k)
								echo 'selected="selected"';
							echo '>'.$v;
							echo '</option>';
						}
					?>
                    </select>
                </td>
				<td width='20%'><?=$this->error['ip_addr']?>
            </tr>                       
            <tr>
            	<td class="mytablesubheader" width='50%'>Port</td>
            	<td align="left" width='30%'><input type="text" name="port" value="<?=$this->pick['port']?>" style="text-align:left; width:60px" /></td>
                <td width='20%'><?php echo $this->error['port']; ?></td>
            </tr>  
            <tr>
            	<td class="mytablesubheader" width='50%'>Domain</td>
            	<td align="left" width='30%'><input type="text" name="domain" value="<?=$this->pick['domain']?>" style="text-align:left; width:150px" /></td>
                <td width='20%'><?php echo $this->error['domain']; ?></td>
            </tr>              
            <!--<tr>
            	<td class="mytablesubheader" width='50%'>Custom MID String</td>
            	<td align="left" width='30%'>
					<input type="text" name="mid_custom" value="<?=$this->pick['mid_custom']?>" style="text-align:left; width:150px" />
                </td>
                <td width='20%'><?php echo $this->error['mid_custom']; ?></td>
            </tr> -->
            <tr>
            	<td class="mytablesubheader" width='50%'>Megaco Version</td>
            	<td align="left" width='30%'>
                	<select name='megaco_version'>
                    	<option value='1' <?php if ($this->pick['megaco_version_1'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">1</option>
                        <option value='2' <?php if ($this->pick['megaco_version_2'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">2</option>
                        <option value='3' <?php if ($this->pick['megaco_version_3'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">3</option>                        
                    </select>                
                </td>
                <td width='20%'><?php echo $this->error['transport_protocol']; ?></td>
            </tr> 
            <tr>
            	<td class="mytablesubheader" width='50%'>T.38 Fax</td>
            	<td align="left" width='30%'>
                	<select name='t38'>
                    	<option value='enable' <?php if ($this->pick['t38_enable'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Enabled</option>
                        <option value='disable' <?php if ($this->pick['t38_disable'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Disabled</option>                        
                    </select>                
                </td>
                <td width='20%'></td>            	
            </tr>                                                  
		</table>
        <br />
        <table class="mytable" width='100%'>
        	<th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left"><?=$this->edit['name']?> : RTP Termination</th>
            <!-- <tr>
            	<td class="mytablesubheader" width='50%'>RTP Port Range</td>
            	<td align="left" width='30%'>
                <input type="text" name="rtp_port_min" value="<?=$this->pick['rtp_port_min']?>" style="text-align:left; width:60px" /> : <input type="text" name="rtp_port_max" value="<?=$this->pick['rtp_port_max']?>" style="text-align:left; width:60px" />
                </td>
                <td width='20%'><?=$this->error['rtp']?><br /><?=$this->error['rtp_port_min']?><br /><?=$this->error['rtp_port_max']?></td>
            </tr> -->
            <tr>
            	<td class="mytablesubheader" width='50%'>RTP IP</td>
            	<!-- <td align="left" width='30%'><input type="text" name="rtp_ip" id='rtp_ip' value="<?=$this->pick['rtp_ip']?>" style="text-align:left; width:150px" /></td> -->
                <td align='left' width='30%'>
                	<select name='rtp_ip' id='rtp_ip'>
                    <?php
						foreach ($interface_list as $k=>$v) {
							echo '<option value="' . $k . '" ';
							if ($_REQUEST['rtp_ip'] == $k)
								echo 'selected="selected"';
							elseif ($this->edit['rtp_ip'] == $k)
								echo 'selected="selected"';
							echo '>'.$v;
							echo '</option>';
						}
					?>
                    </select>
                </td>
                <td width='20%'><?=$this->error['rtp_ip']?></td>   
            </tr>
            <tr>
				<td class="mytablesubheader" width='50%'>Termination-ID Prefix</td>
            	<td align="left" width='30%'><input type="text" name="term_prefix" value="<?=$this->pick['term_prefix']?>" style="text-align:left; width:40px" /></td>
                <td width='20%'><?=$this->error['term_prefix']?></td>            
            </tr>
            <!-- <tr>
				<td class="mytablesubheader" width='50%'>Termination-ID Length</td>
            	<td align="left" width='30%'><input type="text" name="term_id_len" value="<?=$this->pick['term_id_len']?>" style="text-align:left; width:40px" /></td>
                <td width='20%'><?=$this->error['term_id_len']?></td>            
            </tr> -->
		</table>
        <br />
        <table width="100%">
        <tr>
		<td width="1%"><input type="submit" name="update_gw" value='Update Media Gateway Profile'  <?php echo $_SESSION['button_class']; ?>/></td>
		<td align="right"><input type="submit" name="cancel_update" value="Cancel Update" <?php echo $_SESSION['button_class']; ?>/></td>
        </tr>
        </table>
	</form>         
	<?php
	}	
	
	/**
	* Display for to configure peer
	*/
	public function edit_peer($data){
		//Pull information from db if available and place it in the appropriate boxes
		$table = $_SESSION['profile_name'] . '_peers';
		$this->get_data_values($data,$table,$_SESSION['peer_id_num']);
		$this->check_submit();
		//$this->get_profiles();
		?>
	<form name="create_profile" method="post">  		   
	    <input type="hidden" name="id_number" value="<?php echo $_SESSION['id_num']; ?>" />
        <input type="hidden" name="profile_name" value="<?=$this->edit['name']?>" />
        <input type="hidden" name="mg_profile_name" value="<?=$_SESSION['profile_name']?>" />
        <input type="hidden" name="mg_peer_edit" value="mg_peer_edit" />  	
        
        <table class="mytable" width='100%'>
        	<th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left"><?=$this->edit['name']?> : Peer Options</th>  
            <tr>
            	<td class="mytablesubheader" width='50%'>Message Identifier Type</td>
            	<td align="left" width='30%'>
                	<select name='mid' id='mid'>
                       	<option value='IP-PORT' <?php if ($this->pick['mid_ip_port'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">IP:Port</option>
                    	<option value='DOMAIN' <?php if ($this->pick['mid_domain'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Domain</option>
                    	<option value='IP' <?php if ($this->pick['mid_ip'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">IP</option>                                       
                    </select>
                </td>
                <td width='20%'><?php echo $this->error['mid']; ?></td>
            </tr> 
            <tr id='domain_id'>
            	<td class="mytablesubheader" width='50%'>Domain</td>
            	<td align="left" width='30%'><input type="text" name="domain" id='domain' value="<?=$this->pick['domain']?>" style="text-align:left; width:150px" /></td>
                <td width='20%'><?php echo $this->error['domain']; ?></td>
            </tr> 
            <tr>
            	<td class="mytablesubheader" width='50%'>IP Address</td>
                <td align="left" width='30%'><input type="text" name="ip_addr" value="<?=$this->pick['ip_addr']?>" style="text-align:left; width:150px" /></td>
				<td width='20%'><?=$this->error['ip_addr']?>
            </tr>                       
            <tr>
            	<td class="mytablesubheader" width='50%'>Port</td>
            	<td align="left" width='30%'><input type="text" name="port" value="<?=$this->pick['port']?>" style="text-align:left; width:60px" /></td>
                <td width='20%'><?php echo $this->error['port']; ?></td>
            </tr>  
            <tr>
            	<td class="mytablesubheader" width='50%'>H.248 Encoding Scheme</td>
            	<td align="left" width='30%'>
                	<select name='encoding_scheme'>
                    	<option value='text' <?php if ($this->pick['encoding_scheme_text'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Text</option>
<!--                        <option value='binary' <?php if ($this->pick['encoding_scheme_binary'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Binary</option> 		-->
                    </select>                
                </td>
                <td width='20%'><?php echo $this->error['encoding_scheme']; ?></td>
            </tr>              
            <tr>
            	<td class="mytablesubheader" width='50%'>Transport Protocol</td>
            	<td align="left" width='30%'>
                	<select name='transport_protocol'>
                    	<option value='tcp' <?php if ($this->pick['transport_protocol_tcp'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">TCP</option>
                        <option value='udp' <?php if ($this->pick['transport_protocol_udp'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">UDP</option>
<!--                        <option value='sctp' <?php if ($this->pick['transport_protocol_sctp'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">SCTP</option>                        -->
                    </select>                
                </td>
                <td width='20%'><?php echo $this->error['transport_protocol']; ?></td>
            </tr>         
            <tr>

            <tr>
            	<td class="mytablesubheader" width='50%'></td>
                <td>
             		<input type="submit" name="update_peer" value='Update'  <?php echo $_SESSION['button_class']; ?>/><input type="submit" name="cancel_peer_update" value="Cancel" <?php echo $_SESSION['button_class']; ?>/></td>
                </td>
            </tr>
		</table>
        </form>
        <?php		
	}

	/**
	* Displays the deletion confirmation box
	*/
	public function display_delete($data) {
		$table = $_SESSION['profile_name'] . "_peers";
		$profile_name = $data->select_statement($this->db_location,$table,"name","id = " . $_SESSION['delete_id']);
		$notif = new NotificationBox( 'Error', NotificationBox::Error );
		$notif->add("", "Removing the Profile <b>" . $profile_name['name'] . "</b> will remove the peer." );
		$notif->add("", "Click <b>REMOVE</b> to continue." );
		echo $notif->getHtml();		
		unset($notif);	
		?>
        <br />
		<form name="remove_profile" method="post">  		   
	    <input type="hidden" name="id_number" value="<?php echo $a; ?>" />
    	<table class="mytable" width='100%'>
        	<th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left"><?=$_SESSION['profile_name']?>: Peer Removal</th> 
    		<tr>
				<td class="mytablesubheader" width='50%'>Peer marked for Removal</td>
				<td align="left" width='50%'><b><?=$profile_name['name']?></b></td>
			</tr>
            <tr>
            	<td class="mytablesubheader" width='50%'></td>
                <td>
                <input type="submit" name="delete_peer" value='Remove'  <?php echo $_SESSION['button_class']; ?>/>
                <input type="submit" name="cancel_peer_removal" value="Cancel" <?php echo $_SESSION['button_class']; ?>/>
                </td>
            </tr>
        </table>
	</form>
	<?php
	}


	//Validates the Form
	function validation()
	{
		//Grabs profile names out of the database
		if ($_REQUEST['name'] != "" && isset($_REQUEST['name']))
			$this->get_profiles();
		
		//Makes sure the user enters a profile name
		if ($_REQUEST['name'] == "" && isset($_REQUEST['name']))
		{
			$this->error['profile_name'] = "<font color=\"red\">Please Enter a Profile Name</font>";
			$this->error_counter++;
		}	
		
		if ($_REQUEST['name'] != "") {
			if ((strpbrk($_REQUEST['name'],'-') != FALSE || strpbrk($_REQUEST['name'],',') != FALSE || strpbrk($_REQUEST['name'],'@') != FALSE || strpbrk($_REQUEST['name'],'*') != FALSE) && $_REQUEST['name'] != "") {
				$this->error['profile_name'] =  "<font color=\"red\">Invalid characters, <b>-,@*</b>, used in profile name</font>";
				$this->error_counter++;			
			}
		}
		
		//Checks if profile exists		
		if (count($this->profile_name) > 0 && isset($_REQUEST['name'])) {
			foreach ($this->profile_name as $profile){
				if (strtoupper($profile['name']) == strtoupper($_REQUEST['name'])) {
					$proceed = false;
					$this->error['profile_name'] = "<font color=\"red\">MG Profile Exists</font>";
					$this->error_counter++;
					break;
				}
			}
		}
	
		if (isset($_REQUEST['peer_name']) && $_REQUEST['peer_name'] != "")
			$this->get_peer_profiles();	
		
		if ($_REQUEST['peer_name'] == "" && isset($_REQUEST['peer_name'])) {
			$this->error['peer_name'] = "<font color=\"red\">Please Enter a Peer Name</font>";
			$this->error_counter++;
		}
	
		if ($_REQUEST['peer_name'] != "") {
			if ((strpbrk('-',$_REQUEST['peer_name']) != FALSE || strpbrk(',',$_REQUEST['peer_name']) != FALSE || strpbrk('@',$_REQUEST['peer_name']) != FALSE || strpbrk('*',$_REQUEST['peer_name']) != FALSE) && $_REQUEST['peer_name'] != "") {
				$this->error['peer_name'] =  "<font color=\"red\">Invalid characters, <b>-,@*</b>, used in profile name</font>";
				$this->error_counter++;			
			}
		}
			
		if (count($this->peer_profile_name) > 0 && isset($_REQUEST['peer_name'])) {
			foreach ($this->peer_profile_name as $profile) {
				if (strtoupper($profile['name']) == strtoupper($_SESSION['profile_name'] . '_' .  $_REQUEST['peer_name'])) {
					$proceed = false;
					$this->error['peer_name'] = "<font color=\"red\">Peer Exists</font>";
					$this->error_counter++;
					break;
				}
			}
		}
	
		if ($_REQUEST['ip_addr'] == "" && isset($_REQUEST['ip_addr']))
		{
			$this->error['ip_addr'] = "<font color=\"red\">Please Enter an <b>IP Address</b></font>";
			$this->error_counter++;
		}
		//elseif (!preg_match('/^(([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]).){3}([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$/',$_REQUEST['ip_addr']) && isset($_REQUEST['ip_addr']))
		elseif (!preg_match('/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)/',$_REQUEST['ip_addr']) && isset($_REQUEST['ip_addr']))
		{
			$this->error['ip_addr'] = "<b><font color='red'>Signalling IP entered is not a valid IPv4 Address</font></b>";
			$error_count++;
		}
		
		if ($_REQUEST['rtp_ip'] != "" && isset($_REQUEST['rtp_ip'])) {
			if (!preg_match('/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)/',$_REQUEST['ip_addr']) && isset($_REQUEST['rtp_ip']))
			{
				$this->error['rtp_ip'] = "<b><font color='red'>RTP IP entered is not a valid IPv4 Address</font></b>";
				$error_count++;
			}
		}
		
		
		if ($_REQUEST['port'] == "" && isset($_REQUEST['port']))
		{
			$this->error['port'] = "<font color=\"red\">Please Enter a <b>port</b></font>";
			$this->error_counter++;
		}
		elseif (!is_numeric($_REQUEST['port']) && isset($_REQUEST['port']))
		{
			$this->error['port'] = "<font color=\"red\">Please Enter a <b>NUMERIC</b> value for the <b>port</b></font>";
			$this->error_counter++;
		}
		elseif (($_REQUEST['port'] < 0 || $_REQUEST['port'] > 65535) && isset($_REQUEST['port'])) {
			$this->error['port'] = "<font color=\"red\"><b>Port</b> MUST be between 1 and 65535</font>";
			$this->error_counter++;
		}
		if ($_REQUEST['mg_profile_edit'] == "mg_profile_edit") {
			//check all mg profiles for the same port but skip over itself
			$this->table_name = "mg_profiles";
			$this->get_profiles();
			if (count($this->profile_name) > 0) {
				foreach ($this->profile_name as $profile){
					if (strtoupper($profile['name']) != strtoupper($_REQUEST['profile_name'])) {
						if ($_REQUEST['mid'] == "IP-PORT") {
							if ($profile['mid'] == $_REQUEST['mid']) {
								if ($_REQUEST['ip_addr'] == $profile['ip_addr'] && $_REQUEST['port'] == $profile['port']) {
									$this->error['ip_addr'] = "<font color='red'><b>IP Address + Port</b> MUST be unique across all MG Profiles when choosing MID Type IP:PORT</font>";
									$this->error_counter++;
									break;
								}
							}
						}											
						elseif ($_REQUEST['mid'] == "DOMAIN") {
							if ($profile['mid'] == $_REQUEST['mid']) {
								if ($_REQUEST['domain'] == $profile['domain']) {
									$this->error['domain'] = "<font color='red'><b>Domain Name</b> MUST be unique across all MG Profile Peers when choosing MID Type Domain</font>";
									$this->error_counter++;
									$this->table_name = "mg_profiles";
									break;
								}
							}
						}
						elseif ($_REQUEST['mid'] == "IP") {
							if ($profile['mid'] == $_REQUEST['mid']) {
								if ($_REQUEST['ip_addr'] == $profile['ip_addr']) {
									$this->error['ip_addr'] = "<font color='red'><b>IP Address</b> MUST be unique across all MG Profile Peers when choosing MID Type IP</font>";
									$this->error_counter++;
									$this->table_name = "mg_profiles";
									break;
								}
							}							
						}						
					}
				}
			}
		}
		if ($_REQUEST['mg_peer_edit'] == "mg_peer_edit") {
			$this->table_name = "mg_profiles";
			$this->get_profiles();
			foreach ($this->profile_name as $profiles) {
				if ($_REQUEST['ip_addr'] == $profiles['ip_addr'] && $_REQUEST['port'] == $profiles['port']) {
					$this->error['ip_addr'] = "<font color='red'><b>IP Address + Port</b> already used by MG profile ".$profiles['name']."</font>";
					$this->error_counter++;
					break;
				}
				$this->get_peer_profiles($profiles['name'].'_peers');
				if (count($this->peer_profile_name) > 0) {
					foreach ($this->peer_profile_name as $profile){
						if (strtoupper($profile['name']) != strtoupper($_REQUEST['profile_name'])) {
							if ($_REQUEST['mid'] == "IP-PORT") {
								if ($profile['mid'] == $_REQUEST['mid']) {
									if ($_REQUEST['ip_addr'] == $profile['ip_addr'] && $_REQUEST['port'] == $profile['port']) {
										$this->error['ip_addr'] = "<font color='red'><b>IP Address + Port</b> MUST be unique across all MG Profile Peers when choosing MID Type IP:PORT</font>";
										$this->error_counter++;
										$this->table_name = "mg_profiles";
										break;
									}
								}
							}
							elseif ($_REQUEST['mid'] == "DOMAIN") {
								if ($profile['mid'] == $_REQUEST['mid']) {
									if ($_REQUEST['domain'] == $profile['domain']) {
										$this->error['domain'] = "<font color='red'><b>Domain Name</b> MUST be unique across all MG Profile Peers when choosing MID Type Domain</font>";
										$this->error_counter++;
										$this->table_name = "mg_profiles";
										break;
									}
								}
							}
							elseif ($_REQUEST['mid'] == "IP") {
								if ($profile['mid'] == $_REQUEST['mid']) {
									if ($_REQUEST['ip_addr'] == $profile['ip_addr']) {
										$this->error['ip_addr'] = "<font color='red'><b>IP Address</b> MUST be unique across all MG Profile Peers when choosing MID Type IP</font>";
										$this->error_counter++;
										$this->table_name = "mg_profiles";
										break;
									}
								}								
							}
						}
					}
				}
			}
		}
				
				
		if ($_REQUEST['domain'] == "" && isset($_REQUEST['domain']))
		{
			$this->error['domain'] = "<font color=\"red\">Please Enter a <b>domain</b></font>";
			$this->error_counter++;
		}
		
		/* if ($_REQUEST['rtp_port_min'] == "" && isset($_REQUEST['rtp_port_min']))
		{
			$this->error['rtp'] = "<font color=\"red\">Please Enter a valid <b>RTP Port</b> range</font>";
			$this->error_counter++;
		}
		elseif (!is_numeric($_REQUEST['rtp_port_min']) && isset($_REQUEST['domain']))
		{
			$this->error['rtp'] = "<font color=\"red\">Please Enter a <b>NUMERIC</b> value for the starting <b>RTP Port</b></font>";
			$this->error_counter++;
		}
		elseif (($_REQUEST['rtp_port_min'] < 0 || $_REQUEST['rtp_port_min'] > 65535) && isset($_REQUEST['rtp_port_min'])) {
			$this->error['rtp_port_min'] = "<font color=\"red\"><b>Starting RTP Port</b> MUST be between 1 and 65535</font>";
			$this->error_counter++;
		}
		
		if ($_REQUEST['rtp_port_max'] == "" && isset($_REQUEST['rtp_port_max']) )
		{
			$this->error['rtp'] = "<font color=\"red\">Please Enter a valid <b>RTP Port</b> range</font>";
			$this->error_counter++;
		}
		elseif (!is_numeric($_REQUEST['rtp_port_max']) && isset($_REQUEST['rtp_port_max']))
		{
			$this->error['rtp'] = "<font color=\"red\">Please Enter a <b>NUMERIC</b> value for the ending <b>RTP Port</b></font>";
			$this->error_counter++;
		}
		elseif (($_REQUEST['rtp_port_max'] < 0 || $_REQUEST['rtp_port_max'] > 65535) && isset($_REQUEST['rtp_port_max'])) {
			$this->error['rtp_port_max'] = "<font color=\"red\"><b>Ending RTP Port</b> MUST be between 1 and 65535</font>";
			$this->error_counter++;
		}
		
		if ($_REQUEST['rtp_port_min'] > $_REQUEST['rtp_port_max']) {
		  $this->error['rtp'] = "<font color=\"red\"><b>STARTING</b> RTP port must be less then <b>ENDING</b> RTP port</font>";
			$this->error_counter++;
		}*/
		
		if ($_REQUEST['term_prefix'] == ""  && isset($_REQUEST['term_prefix']))
		{
			$this->error['term_prefix'] = "<font color=\"red\">Please Enter a <b>Termination Prefix</b></font>";
			$this->error_counter++;
		}

		/* if ($_REQUEST['term_id_len'] == "" && isset($_REQUEST['term_id_len']) )
		{
			$this->error['term_id_len'] = "<font color=\"red\">Please Enter a <b>Termination ID Length</b></font>";
			$this->error_counter++;
		}
		if (($_REQUEST['term_id_len'] < 1 || $_REQUEST['term_id_len'] > 9) && isset($_REQUEST['term_id_len'])) {
			$this->error['term_id_len'] = "<font color=\"red\"><b>Termination ID Length</b> MUST be between 1 and 9</font>";
			$this->error_counter++;			
		} */
	}	
	
	//Pulls information out of the database
	function get_data_values($data,$table,$id){
		$this->edit = $data->select_statement($this->db_location,$table,'*','id=' . $id);
	}
	
	
	//Function to return the proper values when entering the page
	function check_submit()
	{
		if ($_REQUEST['protocol'] == "megaco")
			$this->pick['protocol_megaco'] = "yes";
		elseif ($_REQUEST['protocol'] == "mgcp")
			$this->pick['protocol_mgcp'] = "yes";
		elseif ($this->edit['protocol'] == "mgcp")
			$this->pick['protocol_mgcp'] = "yes";
		elseif ($this->edit['protocol'] == "megaco")
			$this->pick['protocol_megaco'] = "yes";

		if ($_REQUEST['encoding_scheme'] == "text")
			$this->pick['encoding_scheme_text'] = "yes";
		elseif ($_REQUEST['encoding_scheme'] == "binary")
			$this->pick['encoding_scheme_binary'] = "yes";
		elseif ($this->edit['encoding_scheme'] == "text")
			$this->pick['encoding_scheme_text'] = "yes";
		elseif ($this->edit['encoding_scheme'] == "binary")
			$this->pick['encoding_scheme_binary'] = "yes";

		if ($_REQUEST['transport_protocol'] == "tcp")
			$this->pick['transport_protocol_tcp'] = "yes";
		elseif ($_REQUEST['transport_protocol'] == "udp")
			$this->pick['transport_protocol_udp'] = "yes";
		elseif ($_REQUEST['transport_protocol'] == "sctp")
			$this->pick['transport_protocol_sctp'] = "yes";
		elseif ($this->edit['protocol'] == "tcp")
			$this->pick['transport_protocol_tcp'] = "yes";
		elseif ($this->edit['protocol'] == "udp")
			$this->pick['transport_protocol_udp'] = "yes";
		elseif ($this->edit['protocol'] == "sctp")
			$this->pick['transport_protocol_sctp'] = "yes";
		elseif ($this->edit['protocol'] == "" && $_REQUEST['transport_protocol'] == "") 
			$this->pick['transport_protocol_udp'] = "yes";

		if ($_REQUEST['megaco_version'] == "1")
			$this->pick['megaco_version_1'] = "yes";
		elseif ($_REQUEST['megaco_version'] == "2")
			$this->pick['megaco_version_2'] = "yes";
		elseif ($_REQUEST['megaco_version'] == "3")
			$this->pick['megaco_version_3'] = "yes";
		elseif ($this->edit['megaco_version'] == "1")
			$this->pick['megaco_version_1'] = "yes";
		elseif ($this->edit['megaco_version'] == "2")
			$this->pick['megaco_version_2'] = "yes";
		elseif ($this->edit['megaco_version'] == "3")
			$this->pick['megaco_version_3'] = "yes";				
			
		if ($_REQUEST['ip_addr'] != "")
			$this->pick['ip_addr'] = $_REQUEST['ip_addr'];
		elseif ($this->edit['ip_addr'] != "")
			$this->pick['ip_addr'] = $this->edit['ip_addr'];
		
		if ($_REQUEST['port'] != "")
			$this->pick['port'] = $_REQUEST['port'];
		elseif ($this->edit['port'] != "") 
			$this->pick['port'] = $this->edit['port'];
		
		if ($_REQUEST['domain'] != "")
			$this->pick['domain'] = $_REQUEST['domain'];
		elseif ($this->edit['domain'] != "")
			$this->pick['domain'] = $this->edit['domain'];
		elseif ($this->edit['domain'] == "" && $_REQUEST['domain'] == "")
			$this->pick['domain'] = shell_exec('hostname');
		
		if ($_REQUEST['mid'] != "")
			$this->pick['mid'] = $_REQUEST['mid'];
		elseif ($this->edit['mid'] != "")
			$this->pick['mid'] = $this->edit['mid'];
			
		if ($_REQUEST['mid'] == "DOMAIN")
			$this->pick['mid_domain'] = "yes";
		elseif ($_REQUEST['mid'] == "IP-PORT")
			$this->pick['mid_ip_port'] = "yes";
		elseif ($_REQUEST['mid'] == "IP")
			$this->pick['mid_ip'] = "yes";
		elseif ($this->edit['mid'] == "DOMAIN")
			$this->pick['mid_domain'] = "yes";
		elseif ($this->edit['mid'] == "IP-PORT")
			$this->pick['mid_ip_port'] = "yes";
		elseif ($this->edit['mid'] == "IP")
			$this->pick['mid_ip'] = "yes";

		if ($_REQUEST['rtp_port_min'] != "")
			$this->pick['rtp_port_min'] = $_REQUEST['rtp_port_min'];
		elseif ($this->edit['rtp_port_min'] != "")
			$this->pick['rtp_port_min'] = $this->edit['rtp_port_min'];
		elseif ($this->edit['rtp_port_min'] == "" && $_REQUEST['rtp_port_min'] == "")
			$this->pick['rtp_port_min'] = 40000;

		if ($_REQUEST['rtp_port_max'] != "")
			$this->pick['rtp_port_max'] = $_REQUEST['rtp_port_max'];
		elseif ($this->edit['rtp_port_max'] != "")
			$this->pick['rtp_port_max'] = $this->edit['rtp_port_max'];	
		elseif ($this->edit['rtp_port_max'] == "" && $_REQUEST['rtp_port_max'] == "")
			$this->pick['rtp_port_max'] = 45000;					
			
		if ($_REQUEST['term_prefix'] != "")
			$this->pick['term_prefix'] = $_REQUEST['term_prefix'];
		elseif ($this->edit['term_prefix'] != "")
			$this->pick['term_prefix'] = $this->edit['term_prefix'];	
		elseif ($this->edit['term_prefix'] == "" && $_REQUEST['term_prefix'] == "")
			$this->pick['term_prefix'] = "RTP";

		if ($_REQUEST['ip_addr'] != "")
			$this->pick['ip_addr'] = $_REQUEST['ip_addr'];
		elseif ($this->edit['ip_addr'] != "")
			$this->pick['ip_addr'] = $this->edit['ip_addr'];

		if ($_REQUEST['term_id_len'] != "")
			$this->pick['term_id_len'] = $_REQUEST['term_id_len'];
		elseif ($this->edit['term_id_len'] != "")
			$this->pick['term_id_len'] = $this->edit['term_id_len'];			
		elseif ($_REQUEST['term_id_len'] == "" && $this->edit['term_id_len'] == "")
			$this->pick['term_id_len'] = "3";
			
		if ($_REQUEST['rtp_ip'] != "")
			$this->pick['rtp_ip'] = $_REQUEST['rtp_ip'];
		elseif ($this->edit['rtp_ip'] != "")
			$this->pick['rtp_ip'] = $this->edit['rtp_ip'];
			
		if ($_REQUEST['t38'] == "enable") 
			$this->pick['t38_enable'] = 'yes';
		elseif ($_REQUEST['t38'] == "disable")
			$this->pick['t38_disable'] = 'yes';
		elseif ($this->edit['t38'] == "enable")
			$this->pick['t38_enable'] = 'yes';
		elseif ($this->edit['t38'] == 'disable')
			$this->pick['t38_disable'] = "yes";
			
	}	
}
?>
