<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class transcoding_class
{
	//Variable declarations
	public $is_sangoma="";					//Variable which states whether the device is a sangoma device
	public $array_name="";					//contains the proper names that will be put in the /etc/sysconfig/network-scripts file
	public $array_ip_addr="";				//contains all the values returned from ifconfig
	public $array_mask="";					//contains all the values returned from ifconfig
	public $array_mac="";					//contains all the values returned from ifconfig
	public $array_nibble=array();			//Contians the nibble value for the configuration of the modules
	public $counter="";						//contains all the values returned from ifconfig
	public $num_modules=array();			//Contains the array of modules on the cards
	public $db_location="";					//Contains the Database Location
	public $data="";						//Contains the database class
	public $total_entries="";				//Contains the total entries in the transcode table
	public $array_names=array();			//Contains an Array of ethernet devices that need to be brought up
	public $codec_array = array();			//Contains the available codecs within the transcoding class
	public $codec_names = array();			//Contains the names of the codecs available for use
	public $codec_info = array();			//Contains the information about the codec
	public $bind_addr = "";
	public $bind_port = "";
	public $ifcfg_error = array();
	public $ifup_error = array();
	public $sngtc_error = "";
	public $sangoma_codec_error = "";
	private $all_ids = array();				//Contains all the id's within the transcode table
	public $legacy_names=array();			//Contains the legacy ifconfig interface names originally generated by kernel
	
	//Retrieves all the codecs from the database
	function get_codecs($db=NULL)
	{
		if (!isset($db))
			$database = "sqlite:../sqlite/smg_data.db";
		else
			$database = $db;
			
		$table_name = "codecs";
		
		$select = "SELECT codec_name, codec_syntax FROM " . $table_name . " ORDER BY codec_name;";

		$count = 1;
		try
		{
			//open the database
			$db = new PDO($database);

			$result = $db->query($select);
					
			foreach($result as $row)
			{
				$this->codec_array[$count] = $row['codec_syntax'];
				$this->codec_names[$count] = $row['codec_name'];
				$this->codec_info[$count] = $row['info'];
				
				$count++;				
			}
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}		
	}
	
	function get_info()
    {
		exec("/sbin/ifconfig -a | grep eth | cut -d: -f1 | awk '{ print $1}'", $name_1);
		exec("/sbin/ifconfig -a | grep __tmp | cut -d: -f1 | awk '{ print $1}'", $name_2);
		
		for ($a = 0; $a < count($name_1); $a ++)
		{
			$command = "/sbin/ifconfig " . $name_1[$a] . " | grep 'inet addr:' | cut -d: -f2 | awk '{ print $1}'";
			//echo $command . "<br />";
			$command_2 = "/sbin/ifconfig " . $name_1[$a] . " | grep -o -E '([[:xdigit:]]{1,2}:){5}[[:xdigit:]]{1,2}'";
			$command_3 = "/sbin/ifconfig " . $name_1[$a] . " | grep 'Mask:' | cut -d: -f4 | awk '{ print $1}'";
			exec($command, $name_1_ip_addr);
			exec($command_2, $name_1_mac);
			exec($command_3, $name_1_mask);
			if ($name_1_ip_addr[$a] == "")
			{
				$name_1_ip_addr[$a] = "";
			}
			if ($name_1_mask[$a] == "")
			{
				$name_1_mask[$a] = "";
			}
			if ( $name_1_mac[$a] == "")
			{
				 $name_1_mac[$a] = "";
			}
			//echo "$a = " . $name_1[$a] . " IP " . $name_1_ip_addr[$a] . " MAC " . $name_1_mac[$a] . " MASK " . $name_1_mask[$a] . "<br />";
			
		}
		for ($a = 0; $a < count($name_2); $a ++)
		{
			$command = "/sbin/ifconfig " . $name_2[$a] . " | grep 'inet addr:' | cut -d: -f2 | awk '{ print $1}'";
			$command_2 = "/sbin/ifconfig " . $name_2[$a] . " | grep -o -E '([[:xdigit:]]{1,2}:){5}[[:xdigit:]]{1,2}'";
			$command_3 = "/sbin/ifconfig " . $name_2[$a] . " | grep 'Mask:' | cut -d: -f4 | awk '{ print $1}'";
			exec($command, $name_2_ip_addr);
			exec($command_2, $name_2_mac);
			exec($command_3, $name_2_mask);
			
			if ($name_2_ip_addr[$a] == "")
			{
				$name_2_ip_addr[$a] = "";
			}
			if ($name_2_mask[$a] == "")
			{
				$name_2_mask[$a] = "";
			}
			if ( $name_2_mac[$a] == "")
			{
				 $name_2_mac[$a] = "";
			}
			//echo $name_2[$a] . " " . $name_2_ip_addr[$a] . " " . $name_2_mac[$a] . " " . $name_2_mask[$a] . "<br />";
		}
		
		//Merges results into 1 array with all the relevant information
		$this->counter = count($name_1) + count($name_2);
		
		for ($b = 0; $b < count($name_1); $b++)
		{
			$this->legacy_names[$b] = $name_1[$b];
			$this->array_name[$b] = $name_1[$b];
			$this->array_ip_addr[$b] = $name_1_ip_addr[$b];
			$this->array_mask[$b] = $name_1_mask[$b];
			$this->array_mac[$b] = $name_1_mac[$b];
			$this->array_nibble[$b] = "150";
			//echo "$b = " . $this->array_name[$b] . " " . $this->array_ip_addr[$b] . " and " . $name_1_ip_addr[$b] . "<br />";
		}
		for ($c = 0; $c < count($name_2); $c++)
		{
			//$this->array_name[$b] = $name_2[$c];
			//Change the name into an "eth" device
			$this->legacy_names[$b] = $name_2[$c];
			$this->array_name[$b] = "eth" . $b;
			$this->array_ip_addr[$b] = $name_2_ip_addr[$c];
			$this->array_mask[$b] = $name_2_mask[$c];
			$this->array_mac[$b] = $name_2_mac[$c];
			$this->array_nibble[$b] = "150";
			//echo "$b = " . $this->array_name[$b] . " " . $this->array_ip_addr[$b] . "<br />";
			$b++;
		}
	}
	
	//Insert entry into the database
	function initial_database($a, $num_modules)
	{
		$table_name = "transcode";
		$param = "interface";
		$where = "interface = \"" . $this->array_name[$a] . "\"";
		$exist = $this->data->select_statement($this->db_location, $table_name, $param, $where);
		
		//echo "interface = " . $exist['interface'];
		if ($exist['interface'] == "")
		{
			//insert
			$param = "id, interface, ip_address, net_mask, mac_addr,  num_modules, nibble";
			$insert_param = "\"" . $a . "\", \"" . $this->array_name[$a] . "\", \"" . $this->array_ip_addr[$a] . "\", \"" . $this->array_mask[$a] . "\", \"" . $this->array_mac[$a] . "\", \"" . $num_modules . "\", \"150\"";
			$this->data->insert_statement($this->db_location, $table_name, $param, $insert_param);
		}
		elseif ($exist['interface'] != "")
		{
			//update
			$param = "id = \"" . $a . "\", interface = \"" . $this->array_name[$a] . "\", ip_address = \"" . $this->array_ip_addr[$a] . "\", net_mask = \"" . $this->array_mask[$a] . "\", mac_addr = \"" . $this->array_mac[$a] . "\", num_modules = \"" . $num_modules . "\", nibble = \"240\"";
			$where = "interface = " . $this->array_name[$a];
			$this->data->update_table ($this->db_location, $table_name, $param, $where);
		}
	}
	
	//Updates the database with the IP Nibble
	function update_nibble($a)
	{
		//update
		$table_name = "transcode";
		$param = "nibble = \"" . $this->array_nibble[$a] . "\"";
		$where = "interface = \"" . $this->array_name[$a] . "\"";
		$this->data->update_table ($this->db_location, $table_name, $param, $where);		
	}
	
	//Compare the first 3 elements of the mac address to find whether it is a sangoma mac address
	function compare_mac($mac_addr)
	{
		//tokenize the mac address
		$tok = strtok($mac_addr, ":");
	
		$count = 0;
		
		while ($tok !== false) {
			$token[$count] = $tok;
			
			//Stores the tokens in an array to be parsed
			$token_values[$total_token] = $token[$count];			
		    $tok = strtok(":");
			$count++;
			$total_token++;
		}
		
		if ($token[0] == "02")
		{
			if ($token[1] == "19")
			{
				if ($token[2] == "23")
					$this->is_sangoma = "YES";
				else
					$this->is_sangoma = "NO";
			}
			else
				$this->is_sangoma = "NO";
		}
		else
			$this->is_sangoma = "NO";	
	}
	
	//Figures out what values are to be used
	function find_values($database, $a)
	{
		$request = "accept$a";
		$ip_hash = "ip_addr_$a";
		$netmask_hash = "netmask$a";
		$nibble_hash = "nibble$a";


		if ($_REQUEST[$ip_hash] != "")
			$this->array_ip_addr[$a] = $_REQUEST[$ip_hash];
		elseif ($database[$a]['ip_address'] != "")
			$this->array_ip_addr[$a] = $database[$a]['ip_address'];
		elseif ($_REQUEST[$ip_hash] == "" && $database[$a]['ip_address'] == "" && $this->array_ip_addr[$a] == "")
			$this->array_ip_addr[$a] = "10.$a.199.1";
		
		if ($_REQUEST[$netmask_hash] != "")
			$this->array_mask[$a] = $_REQUEST[$netmask_hash];
		elseif ($database[$a]['net_mask'] != "")
			$this->array_mask[$a] = $database[$a]['net_mask'];
		elseif ($_REQUEST[$netmask_hash] == "" && $database[$a]['net_mask'] == "" && $this->array_mask[$a] == "")
			$this->array_mask[$a] = "255.255.255.0";
		
		if ($_REQUEST[$nibble_hash] != "")
			$this->array_nibble[$a] = $_REQUEST[$nibble_hash];
		elseif ($database[$a]['nibble'] != "")
			$this->array_nibble[$a] = $database[$a]['nibble'];
		
		if ($database[$a]['interface'] != "")
			$this->array_name[$a] = $database[$a]['interface'];	
		
		if ($database[$a]['num_modules'] != "")
			$this->num_modules[$a] = $database[$a]['num_modules'];
		
		//echo "IP = " . $this->array_ip_addr[$a] . "<br />";
		
		//Bind values
		$bind_table = "transcode_bind";
		$bind = $this->data->select_statement($this->db_location, $bind_table, "bind_addr, bind_port", "id = 1");
		
		if ($bind['bind_addr'] != "")
			$this->bind_addr = $bind['bind_addr'];
		elseif ($_REQUEST['bind_addr'] != "")
			$this->bind_addr = $_REQUEST['bind_addr'];
		else
			$this->bind_addr = "0.0.0.0";
		
		if ($bind['bind_port'] != "")
			$this->bind_port = $bind['bind_port'];
		elseif ($_REQUEST['bind_port'] != "")
			$this->bind_port = $_REQUEST['bind_port'];
		else
			$this->bind_port = "9000";
	}
	
	//Determines the number of entries in the transcode table
	function num_entries($db=NULL)
	{
		if (isset($db))
			$db_location = $db;
		else
			$db_location = "sqlite:../sqlite/cardinfo.db";
			
		$table_name = "transcode";
	
		$select = "SELECT id FROM " . $table_name . ";";

		unset($this->total_entries);
		$this->total_entries = 0;
		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
					
			foreach($result as $row)
			{
				if (isset($row['id']))
				{
					//echo $row['id'] . "<br />";
					$this->all_ids[$this->total_entries] = $row['id'];
					$this->total_entries++;
				}
			}
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage() . "<br />";
			echo "table = " . $table_name . "<br />";
			echo "database = $db_location<br />";
		}	
	}
	
	//Generate sngtc_server.conf
	function sngtc_server($db=NULL)
	{
		//open a file
		$file_name = "sngtc_server.conf.xml";		
		$filehandle = fopen($file_name, 'w') or die("can't open file");		

		$xml =	"<configuration name=\"sngtc_server.conf\" description=\"Sangoma Transcoding Manager Configuration\">\n";

		//Bind IP and Port only needed on distributed setups
		if($_SESSION['transcoder_session'] == "distributed")
		{
			$xml.= "\t<settings>\n";
			
			$table_name = "transcode_bind";
			$param = "bind_addr, bind_port";
			$where_param = "id = 1";
			$info = $this->data->select_statement($this->db_location, $table_name, $param, $where_param);
		
			if ($info['bind_addr'] != "" && $info['bind_port'] != "")
				$xml.="\t\t<param name=\"bindaddr\" value=\"" . $info['bind_addr'] . "\" />\n\t\t<param name=\"bindport\" value=\"" . $info['bind_port'] . "\" />\n";
			
			$xml.= "\t</settings>\n";
		}
		$xml.= "\t<vocallos>\n";
	
		//echo $db;
	
		if (isset ($db))
			$this->num_entries($db);
		else
			$this->num_entries();
		
		//echo "number of entries = " . $this->total_entries . "<br />";
		
		//Enter each vocallo entry
		//For loop for all the entries
		for ($a = 0; $a < $this->total_entries; $a++)
		{
			//Pull information for each entry from the database
			//Enter the information
			$table_name = "transcode";
			if (isset($db))
				$db_location = $db;
			else
				$db_location = "sqlite:../sqlite/cardinfo.db";
			
			//echo $db_location;
				
			$param = "interface, nibble";
			$where_param = "id = " . $this->all_ids[$a] . "";
			$info = $this->data->select_statement($db_location, $table_name, $param, $where_param);

			//echo "interface = " . $info['interface'] . "<br />";
			if ($info['interface'] != "")
			{
				$xml .="\n\t\t<vocallo name=\"" . $info['interface'] . "\">\n\t\t\t<param name=\"base_udp\" value=\"5000\"/>\n\t\t\t<param name=\"base_ip_octet\" value=\"" . $info['nibble'] . "\"/>\n\t\t</vocallo>\n";
			}
		}
	
		$xml.= "\n\t</vocallos>\n</configuration>\n";

		//close the file
		fwrite($filehandle, $xml);
		fclose($filehandle);
		
		//Moves the created file to the required place.
		$cmd = "mv " . $file_name . " /etc/sngtc/" . $file_name;	
		//echo $cmd;			
		exec($cmd);
		exec('echo $?', $output);
		
		if ($output[0] > 0)
		{
			$this->sngtc_error == "error";
		}		
	}
	
	//Generates the ifcfg files required
	function ifcfg()
	{
		$where_param = "";
		$table_name = "transcode";
		$a = 0;

		$select = "SELECT * FROM " . $table_name . ";";
		
		try
		{
			//open the database
			$db = new PDO($this->db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$info[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}

		for ($b = 0; $b < $a; $b++)
		{
			//If an __tmp name exists, bring it down so that you can change the interface name
			for ($l = 0; $l < count($this->legacy_names); $l++)
			{
				if ($info[$b]['interface'] == $this->array_name[l] && $this->array_name[$l] != $this->legacy_names[$l])
				{
					$error = "yes";
					echo "Name = " . $info[$b]['interface'] . " legacy = " . $this->legacy_names[$l] . "<br />";
					$interface[$b] = $this->legacy_names[$l];
				}
			}
			//echo $error;
			
			if ($error == "yes")
			{
				//echo "issue <br />";
				$cmd = "ifconfig " . $interface[$b] . " down";
				echo $cmd;
				exec ($cmd);
			}			
			$this->compare_mac($info[$b]['mac_addr']);
			
			if ($this->is_sangoma == "YES")
			{
				//Use this only if using a RedHat Install (CentOS, Fedora, RHEL)
				$file_name = "ifcfg-" . $info[$b]['interface'];
				$filehandle = fopen($file_name, 'w') or die("can't open file");		
		
		
				$ifcfg = "#Sangoma D-Series Card Networking Configuration\nDEVICE=" . $info[$b]['interface'] . "\nBOOTPROTO=static\nIPADDR=" . $info[$b]['ip_address'] . "\nNETMASK=" . $info[$b]['net_mask'] . "\nHWADDR=" . $info[$b]['mac_addr'] . "\nONBOOT=yes\nUSERCTL=no\n";
		
				//close the file
				fwrite($filehandle, $ifcfg);
				fclose($filehandle);
		
				//Moves the created file to the required place.
				//Specific to RedHat Distributions
				$cmd = "mv " . $file_name . " /etc/sysconfig/network-scripts/" . $file_name;				
				exec($cmd);
				exec("echo \$?", $output);
				
				$cmd = "ifconfig " . $info[$b]['interface'] . " up";
				exec ($cmd);	
				$cmd = "ifconfig " . $info[$b]['interface'] . "	" . $info[$b]['ip_address'] . " netmask " . $info[$b]['net_mask'];
				exec ($cmd);
				
				if ($output[0] > 0)
				{
					$this->ifcfg_error[$b] == "error";
				}
			}
		}
	}
	
	//Generate sangoma_codec.conf
	function sangoma_codec()
	{
		$table = "transcode_bind";
		$result = $this->data->select_statement ($this->db_location, $table, "*", "id = 1");
		
		//open a file
		$file_name = "sangoma_codec.conf.xml";		
		$filehandle = fopen($file_name, 'w') or die("can't open file");		
		
		$xml = "<configuration name=\"sangoma_codec.conf\" description=\"Sangoma Codec Configuration\">\n";

		$info = $this->get_codecs_database();
		$a = count($info);
		
		for ($b = 0; $b < $a; $b++)
		{
			if ($b == 0)
				$codec = $info[$b];
			elseif ($b != $a)
				$codec .= "," . $info[$b];
		}
		
		$codec2 = "PCMU,PCMA," . $codec;
		
		$xml.="\t<settings>\n";
		$xml.="\t\t<param name=\"register\" value=\"" . $codec . "\" />\n";
		
		if ($_SESSION['transcoder_session'] == "distributed")
			$xml.="\t\t<param name=\"soapserver\" value=\"http://" . $result['bind_addr'] . ":" . $result['bind_port'] . "\"/>\n";
		
		//grab interfaces from interface table and choose the first sangoma transcoder from the list
		$interfaces = $this->data->select_statement($this->db_location,'transcode','ip_address','');
		
		$xml.="\t\t<param name=\"rtpip\" value=\"" . $interfaces['ip_address'] . "\"/>\n";
		$xml.= "\t</settings>\n";
		$xml .="</configuration>\n";
		//close the file
		fwrite($filehandle, $xml);
		fclose($filehandle);
		
		//Moves the created file to the required place.
		$cmd = "mv " . $file_name . " " . $_SESSION['smg_root_path'] . "/conf/autoload_configs/" . $file_name;	
		//echo $cmd;			
		exec($cmd);
		exec('echo $?', $output);
		
		if ($output[0] > 0)
		{
			$this->sangoma_codec_error == "error";
		}
		
		//Modify sip profile so that it has the proper codecs in there	
		$file = $_SESSION['smg_root_path'] . "/conf/sip_profiles/internal.xml";
		$xml = simplexml_load_file($file) or die ("Unable to Load XML File");
		//print_r ($xml);
		//var_dump ($xml);
		
		$this->xml_edit_value($xml,'//param',"name","inbound-codec-prefs",$codec2);
		$this->xml_edit_value($xml,'//param',"name","outbound-codec-prefs",$codec2);
		$xml->asXML($file);

		unset($xml);
	
		$file = $_SESSION['smg_root_path'].'/conf/freeswitch.xml';
		$file_open = file_get_contents($file);
		$file_open = preg_replace ('/.*global_codec_prefs.*/', '  <X-PRE-PROCESS cmd="set" data="global_codec_prefs='.$codec2.'"/>',$file_open);
		$file_open = preg_replace ('/.*outbound_codec_prefs.*/', '  <X-PRE-PROCESS cmd="set" data="outbound_codec_prefs='.$codec2.'"/>',$file_open);
		file_put_contents($file,$file_open);

	}
	
	//XML Editor
	function xml_edit_value($object_data, $xpath_expression, $attribute_name, $attribute_value, $replace_string)
	{
		# xpath query.
		$xpathvar = $object_data->xpath($xpath_expression);
		
		$counter=0;	
		# iterates the xpath query results.
		foreach ($xpathvar as $result):
			# checks the attribute of the entries in the xpath query, 
			# if match is found will set $fieldnumber to the array field number of the matched entry.
			if ($result[$attribute_name] == $attribute_value):
				//echo "field = " . $fieldnumber;
				//echo "attribute = " . $attribute_value . "<br />";
				$fieldnumber[] = $counter;
			
			endif;
		$counter++;
		endforeach;
		
		# iterates the mached entries.
		foreach ($fieldnumber as $field):
			/*echo $field . "<br />";
			echo $xpathvar->param[$field] . "<br />";
			# replaces the value.	
			$xpathvar->word[$field] = $replace_string;*/
			//var_dump ($xpathvar[13]);
			//echo "value = " . $xpathvar[13]->attributes() . "<br />";
			
			foreach ($xpathvar[$field]->attributes() as $key=>$value)
			{
				//unset($xpathvar[$field]->param[$attribute_value]);
				if ($key == "value")
				{
					//$value = $replace_string;
					
					$xpathvar[$field]{'value'} = $replace_string;
				}
				//echo $key . " = " . $value . "<br />";				
			}
			//echo "new value = " . $xpathvar[$field]->attributes['value'] . "<br />";
			//echo "new value = " . $xpathvar[$field]{'value'} . "<br />";
			//unset($xpathvar$field[$attribute_value]);
			
		endforeach;
	}	
	
	function get_codecs_database()
	{
		$where_param = "";
		$table_name = "transcode_user_codecs";
		$a = 0;

		$table = $this->data->check_for_table($this->db_location,$table_name);
		
		if ($table > 1)
		{
			$select = "SELECT * FROM " . $table_name . ";";
			
			try
			{
				//open the database
				$db = new PDO($this->db_location);
	
				$result = $db->query($select);
			
				foreach($result as $row)
				{
					$info[$a] = $row['codec_syntax'];
					$a++;
				}
				// close the database connection
				$db = NULL;
			}
			catch(PDOException $e)
			{
				print 'Exception : '.$e->getMessage();
			}	
		}
		
		return $info;		
	}
	
	function ifup_configure()
	{
		$where_param = "";
		$table_name = "transcode";
		$a = 0;

		$select = "SELECT * FROM " . $table_name . ";";
		
		try
		{
			//open the database
			$db = new PDO($this->db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$info[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}

		for ($b = 0; $b < $a; $b++)
		{
			$this->compare_mac($info[$b]['mac_addr']);
			
			if ($this->is_sangoma == "YES")
			{
				$command = "ifup " . $info[$b];
				exec ($command);
				exec ("echo \$?",$output);
				
				if ($output[0] > 0)
				{
					$this->ifup_error[$b] == "error";
				}
			}
		}
	}
	
	//Auto populates the table so that the configuration can automatically be generated
	function auto_populate()
	{
		for ($a = 0; $a < count($this->array_name); $a++)
		{
			$this->compare_mac($this->array_mac[$a]);
					
			if ($this->is_sangoma == "YES")
			{
				if ($this->array_ip_addr[$a] == "")
				{
					$l = $a;
					$this->array_ip_addr[$a] = "192.168.25".$l.".254";
				}
				
				$command = " sudo /sbin/ifconfig " . $this->legacy_names[$a] . " " . $this->array_ip_addr[$a] . " netmask " . $this->array_mask[$a];
				exec($command);
				$command = "sudo /sbin/ifconfig " . $this->legacy_names[$a] . " up";
				exec($command);
				sleep(1);
			
				//Scan for modules
				$command = "/usr/sbin/sngtc_tool -dev '" . $this->legacy_names[$a] . "' -list_modules | grep 'MAC' -c";
				exec ($command, $sngtc);
		
				if (count($sngtc) > 0)
				{
					//echo "i am here<br />";
					$this->num_modules[$a] = $sngtc[0];
					
					//Place in database
					if ($this->num_modules[$a] != 0)
						$this->initial_database($a, $sngtc[0]);
						
				}
			}
		}
		
	}
	
	//Updates the codec table
	function update_codec_table()
	{
		$table_name = "transcode_user_codecs";
		
		//clean out the existing database
		//drop table
		$this->data->drop_table($this->db_location, $table_name);
			
		//create table		
		$parameters = "id int primary key, codec_syntax varchar(30)";
		$this->data->create_table($this->db_location, $table_name, $parameters);	
		
		
		$counter = 1;	
		//Insert the users select codecs into the database
		foreach ($_REQUEST as $key => $value)
		{	
			if (preg_match('/^codec[0-9]*/',$key))
			{	
				//if it doesn't, insert the entry
				$insert_param = "id, codec_syntax";
				$insert_values = "$counter, \"$value\"";
				$this->data->insert_statement($this->db_location, $table_name, $insert_param, $insert_values);
				
				$counter++;
			}
		}				
	}
	
	//Checks the vocallo firmware to check if it is the right firmware or the wrong firmware
	function find_vocallo_firmware($display_common)
	{
		//Find transcoding cards in system
		//$this->get_info();
		
		//print_r ($media_process->legacy_names);
		//print_r ($media_process->array_ip_addr);
		for ($a = 0; $a < count($this->array_mac); $a++)
		{
			$this->compare_mac($this->array_mac[$a]);
			//echo $media_process->is_sangoma;
			if ($this->is_sangoma == "YES" && $this->array_ip_addr[$a] != "")
			{
				//Use the IP Address of that device and find out the firmware using sngtc_tool
				$cmd = "/usr/sbin/sngtc_tool -dev " . $this->legacy_names[$a] . " -list_modules | grep Ver | cut -d\"=\" -f3 | cut -d\" \" -f1";
				exec ($cmd,$output);
				
				if ($output[0] != $_SESSION['vocallo_firmware'])
				{
					$display_common->WarningBox( 
						"<table><tr><td>\n".
						"Media Firmware Out Dated<br/>" .
						"</td>\n".
						"<td>\n".
						"<ul>\n" .
						"<li>Media Firmware Version currently <b>" . $output[0] . "</b> and needs to be at <b>" . $_SESSION['vocallo_firmware'] . "</b></li>\n" .
						"" .
						"</ul>\n".
						"</td></tr></table>\n",$style="style='width:700px'" );
				}
			}
		}
		//print_r ($media_process->array_names);
	}
}

?>
