<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Starts PHP Sessions
session_start();

if ($_SESSION['pidof'] != "")
{
	require_once '../database_classes.php';
	include '../SSH_Class.php';
	$ssh = new ssh_class;
	$data = new database_class;
	$proc_id = $_SESSION['proc_id'];
	
	//adjust cardinfo.db based on proc_id
	if ($proc_id == 1)
	{
		$db_location = "sqlite:../sqlite/cardinfo.db";
	}
	elseif ($proc_id > 1)
	{
		$db_location = "sqlite:../sqlite/cardinfo" . $proc_id . ".db";
	}
	//Pull relay information from database
	$relay_type = $data->select_statement('sqlite:../sqlite/relay_info.db','ss7_relay','machine_type,relay_type','');
	if ($relay_type['machine_type'] == "standalone" || $relay_type['relay_type'] == "SLAVE")
	{
		$type = "local";
	}
	else
	{
		$relay_info = $data->select_statement('sqlite:../sqlite/relay_info.db','relay_hosts','relay_name,ip_addr,ssh_port',"id = $proc_id");			
	
		$pattern = "'\bMaster1\b'";
	
		if (preg_match($pattern,$relay_info['relay_name']))
		{
			$type = "local";
		}
		elseif (!preg_match($pattern,$relay_info['relay_name']))
		{
			$type = "remote";
		}
	}
	
	//echo "Session = "  . $_SESSION['pidof'];
	//kill the wanpipemon process
	$cmd = "kill -2 " . $_SESSION['pidof'];
	//exec ($cmd);
	$null = $ssh->execute($type,$cmd, $relay_info['ip_addr'], $relay_info['ssh_port']);
	//echo $cmd . "<br />";
	//echo  $_SESSION['wanrouter_started'];
	//Stop port if it was never started
	if (isset($_SESSION['wanrouter_started']))
	{
		$cmd = "/usr/bin/pkill -9 wanpipemon";
		shell_exec($cmd);
		$cmd = "/usr/sbin/wanrouter stop " . $_SESSION['wanrouter_started'];
		//echo $cmd;
		$null = $ssh->execute($type,$cmd, $relay_info['ip_addr'], $relay_info['ssh_port']);
	}
	
	//delete the file if it was temporary
	if ($_SESSION['delete_file'] == "yes")
	{
		$cmd = "rm -f /etc/wanpipe/" . $_SESSION['wanpipe_off'] . ".conf";
		$null = $ssh->execute($type,$cmd, $relay_info['ip_addr'], $relay_info['ssh_port']);
	}

}
unset($_SESSION['pidof']);

?>
