<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class freetdm_configuration extends database_class
{
	//Freetdm configuration variables
	private $card_name="";
	private $port_num="";
	private $card_number="";
	private $tx_gain="";
	private $rx_gain="";
	public $span_num="";				//FreeTDM.conf span variable
	private $line_type="";				//FreeTDM.conf linetype (T1/E1)
	private $group_num="";				//FreeTDM.conf group number
	private $channel_map1="";			//FreeTDM.conf channels (T1 full, E1 start portion)
	private $channel_map2="";			//FreeTDM.conf channels (E1 end portion)
	private $switchtype="";				//FreeTDM.conf.xml switchtype
	public $profile_name="";			//FreeTDM.conf.xml profile name
	private	$interface="";				//FreeTDM.conf.xml interface type (T1/E1/BRI)
	private $dchan="";					//FreeTDM.conf d-channel value
	public $facility="";				//FreeTDM.conf.xml facility message
	private $facility_timeout="";		//FreeTDM.conf.xml facility timeout
	private $bearer_ITC="";				//FreeTDM.conf.xml bearer capability Information Transfer Capability
	private $bearer_UIL="";				//FreeTDM.conf.xml bearer capability User Information Layer 1 Protocol
	private $tei="";					//FreeTDM.conf.xml tei value
	private $overlap="";				//FreeTDM.conf.xml overlap dialing
	private $conn_type="";				//FreeTDM.conf TE/NT module
	private $sig_type="";				//FreeTDM.conf.xml BRI NET/CPE
	private $trunk_type="";				//FreeTDM.conf BRI Trunk Type
	private $ton_name1="";				//FreeTDM.conf.xml TON Name
	private $ton_value1="";				//FreeTDM.conf.xml TON Value
	private $npi_name1="";				//FreeTDM.conf.xml NPI name
	private $npi_value1="";				//FreeTDM.conf.xml NPI value
	private $ton_name2="";				//FreeTDM.conf.xml TON Name
	private $ton_value2="";				//FreeTDM.conf.xml TON Value
	private $npi_name2="";				//FreeTDM.conf.xml NPI name
	private $npi_value2="";				//FreeTDM.conf.xml NPI value
	private $ton_name3="";				//FreeTDM.conf.xml TON Name
	private $ton_value3="";				//FreeTDM.conf.xml TON Value
	private $npi_name3="";				//FreeTDM.conf.xml NPI name
	private $npi_value3="";				//FreeTDM.conf.xml NPI value	
	private $msn1="";					//FreeTDM.conf.xml msn value
	private $msn2="";					//FreeTDM.conf.xml msn value
	private $msn3="";					//FreeTDM.conf.xml msn value
	private $msn4="";					//FreeTDM.conf.xml msn value
	private $msn5="";					//FreeTDM.conf.xml msn value
	private $msn6="";					//FreeTDM.conf.xml msn value
	private $msn7="";					//FreeTDM.conf.xml msn value
	private $msn8="";					//FreeTDM.conf.xml msn value	
	private $min_digits="";				//FreeTDM.conf.xml min_digits value
	private $ton_name="";				//FreeTDM.conf.xml TON Name (untokenized)
	private $ton_value="";				//FreeTDM.conf.xml TON Value (untokenized)
	private $npi_name="";				//FreeTDM.conf.xml NPI name (untokenized)
	private $npi_value="";				//FreeTDM.conf.xml NPI value (untokenized)
	private $msn="";					//FreeTDM.conf.xml msn value (untokenized)
	public $module_list=array();		//FreeTDM.conf Analog module listing
	public $ss7_span="";				//Global freetdm variable which states if a link is an SS7 Span or not
	private $ss7_link_name="";			//Contains the SS7 link profile name
	private $ss7_span_num="";			//Contains the SS7 link span number
	public $ss7_sig_channel="";			//Contains the SS7 link signalling channel
	public $ss7_error_type="";			//Contains the SS7 link error type
	public $ss7_lssu="";				//Contains the SS7 link LSSU value
	private $ss7_priority="";			//Contains the SS7 link priority
	private $ss7_switchtype="";			//Contains the SS7 link switchtype
	private $ss7_ssf="";				//Contains the SS7 link SSF value
	private $ss7_slc="";				//Contains the SS7 link SLC value
	public $ss7_link_type="";			//Contains the SS7 link link type
	private $ss7_line_type="";			//Contains the SS7 link line type
	public $ss7_voice="";				//Contains the SS7 link voice link
	private $ss7_link_linkset="";		//Contains the SS7 Linkset being used by the signalling link
	private $ss7_ccspan_profile="";		//Contains the SS7 ccspan Profile Name
	private $ss7_ccspan_isup="";		//Contains the SS7 ccspan ISUP interface
	private $ss7_ccspan_cic="";			//Contains the SS7 ccspan CiC
	private $ss7_ccspan_channel="";		//Contains the SS7 ccspan Channel Map
	private $ss7_ccspan_min_digits="";	//Contains the SS7 ccspan min digits
	private $ss7_ccspan_clg_nadi="";	//Contains the SS7 ccspan clg_nadi
	private $ss7_ccspan_rdins_nadi="";	//Contains the SS7 ccspan rdnis_nadi
	private $ss7_ccspan_cld_nadi="";	//Contains the SS7 ccspan cld_nadi
	private $ss7_ccspan_obci_bita="";	//Contains the SS7 ccspan obci_bita
	private $ss7_ccspan_typecntrl="";	//Contains the SS7 ccspan type control
	private $ss7_ccspan_group_num="";	//Contains the SS7 Group Number
	private $ss7_isup_id="";			//Contains the SS7 ISUP ID
	private $ss7_linkset_id="";			//Contains the SS7 Linkset ID
	private $ss7_route_id="";			//Contains the SS7 Route ID
	private $table_name = "";			//Contains a table name variable
	private $counter = "";				//Contains a counter variable
	private $profile_array=array();		//Contains a list of profiles
	private $linkset_list=array();		//Contains all the linksets attached to a route	
	private $hangup_polarity="";		//Analog Polarity Reversal
	private $answer_polarity ="";		//Analog Polarity Reversal
	private $polarity_delay="";			//Analog FXO Polarity Delay
	private $callerid="";				//Analog Caller ID
	private $tones="";					//Analog tone configuration
	private $call_waiting="";			//Analog Call Waiting
	private $three_way="";				//Analog Three Way Calling
	private $call_swap="";				//Analog Call Swapping
	private $digit_timeout="";			//Analog FXS Digit Timeout
	private $max_digits="";				//Analog FXS Max Digits
	private $ss7_ccspan_lpa="";			//SS7 LPA on COT Variable
	public $db_location="";				//Contains the database location
	private $ss7_ccspan_itx = "";					//Contains the ITX value for ccpsans
	private $ss7_ccspan_transparent_iam = "";		//Contains the transparent IAM value
	private $ss7_ccspan_transparent_iam_timeout="";	//Contains the transparent IAM timeout value
	private $ss7_ccspan_cpg_on_progress="";			//Contains the cpg on progress value
	private $ss7_ccspan_cpg_on_progress_media="";	//Contains the cpg on progress media value
	public $ss7_m2ua_link=array();
	public $ss7_m2ua_chans=array();
	public $data;
	private $mg_link_exist = false;
	public $pre_buffer_size = "";
	private $transfer="";
	public $r2_span;					//States whether an R2 span exists
	private $r2_info = array();			//Contains R2 information for freetdm.conf and freetdm.conf.xml
	private $ss7_global_config = array();
	
	//Function the populates the freetdm variables
	function freetdm_generate($card, $card_number, $span_num, $port_num, $data)
	{
		$this->port_num = $port_num;		
		$this->span_num = $span_num;
		$this->card_name = $card;
		$this->card_number = $card_number;
		$this->ss7_span = "no";
		$this->r2_span = false;
		$pass = false;
		$db_location = $this->db_location;
		
		unset($this->r2_info);

		//Database information
		$card_format = "AFT-" . $this->card_name . "-SH-" . $card_number;
		//$db_location = "sqlite:sqlite/cardinfo.db";
		
		if ($card == "A101" || $card == "A102" || $card == "A104" || $card == "A108" || $card == "A116" || $card == "B601" && $port_num == 1)
		{
			//Gets hardware information needed for freetdm config
			$table_name = $card . "_" . $card_number;
			$param = "rxgain, txgain, line_type, pre_buffer_size";
			$where_param = "port_id = $port_num";
			$hw_info = $data->select_statement ($db_location, $table_name, $param, $where_param);

			$this->rx_gain = $hw_info['rxgain'];
			$this->tx_gain = $hw_info['txgain'];
			$this->line_type = $hw_info['line_type'];
			if ($hw_info['pre_buffer_size'] != "") 
				$this->pre_buffer_size = $hw_info['pre_buffer_size'];
			else
				$this->pre_buffer_size = 0;
				
				
			//Checks if an SS7 table exists
			$table_name = $card . "_" . $card_number . "_SS7_link";
			$tablecheck = parent::check_for_table ($db_location, $table_name);
			//echo $check;
			//echo "table exists = $tablecheck <br />";
			
			if ($tablecheck > 1)
			{
				//Check if this an SS7 Span or not
				$table_name = $card . "_" . $card_number . "_SS7_link";
				$param = "link_name";
				$where_param = "port_id = $port_num";
				$check = $data->select_statement ($db_location, $table_name, $param, $where_param);				
			}
			
			//echo "table name = " . $table_name . " link name = " . $check['link_name'] . "<br />";
			if ($check['link_name'] != "")
			{	
				//echo "I am here<br />";
				//Check if this an SS7 Span or not
				$table_name = $card . "_" . $card_number . "_SS7_link";
				$param = "link_name, span, sig_channel, error_type, lssu, priority, switchtype, SSF, SLC, link_type, line_type, voice, linkset";
				$where_param = "port_id = $port_num";
				$ss7_link_info = $data->select_statement ($db_location, $table_name, $param, $where_param);				
			
				//There is SS7 configuration
				$this->ss7_span = "yes";
				$this->r2_span = false;				
				//echo "Port = " . $port_num . " span = " . $this->ss7_span;	
				//Populate the variables
				$this->ss7_link_name = $ss7_link_info['link_name'];
				//$this->ss7_span_num = $ss7_link_info['span'];
				$this->ss7_sig_channel = $ss7_link_info['sig_channel'];
				$this->ss7_error_type = $ss7_link_info['error_type'];
				$this->ss7_lssu = $ss7_link_info['lssu'];
				$this->ss7_priority = $ss7_link_info['priority'];
				$this->ss7_ssf = $ss7_link_info['SSF'];
				$this->ss7_slc = $ss7_link_info['SLC'];
				$this->ss7_link_type = $ss7_link_info['link_type'];
				$this->ss7_line_type = $ss7_link_info['line_type'];
				$this->ss7_voice = $ss7_link_info['voice'];
				$this->ss7_link_linkset = $ss7_link_info['linkset'];
				$this->ss7_switchtype = $ss7_link_info['switchtype'];
				
				$this->span_num = $ss7_link_info['span'];
				
				//Get the SS7 ccspans information
				$table_name = $card . "_" . $card_number . "_SS7_ccspans";
				$param = "profile_name, isup, cic, channels, min_digits, clg_nadi, cld_nadi, rdnis_nadi, obci_bita, typeCntrl, group_num, lpa, transparent_iam, itx, transparent_iam_timeout, cpg_on_progress, cpg_on_progress_media, t10, t35";
				$where_param = "port_id = $port_num";
				$ss7_ccspan_info = $data->select_statement ($db_location, $table_name, $param, $where_param);	
				
				$this->ss7_ccspan_profile = $ss7_ccspan_info['profile_name'];
				$this->ss7_ccspan_isup = $ss7_ccspan_info['isup'];
				$this->ss7_ccspan_cic = $ss7_ccspan_info['cic'];
				$this->ss7_ccspan_channel = $ss7_ccspan_info['channels'];
				$this->ss7_ccspan_min_digits = $ss7_ccspan_info['min_digits'];
				$this->ss7_ccspan_clg_nadi = $ss7_ccspan_info['clg_nadi'];
				$this->ss7_ccspan_rdnis_nadi = $ss7_ccspan_info['rdnis_nadi'];
				$this->ss7_ccspan_cld_nadi = $ss7_ccspan_info['cld_nadi'];
				$this->ss7_ccspan_obci_bita = $ss7_ccspan_info['obci_bita'];
				$this->ss7_ccspan_typecntrl = $ss7_ccspan_info['typeCntrl'];
				$this->ss7_ccspan_group_num = $ss7_ccspan_info['group_num'];
				$this->ss7_ccspan_lpa = $ss7_ccspan_info['lpa'];
				$this->ss7_ccspan_transparent_iam = $ss7_ccspan_info['transparent_iam'];
				$this->ss7_ccspan_itx = $ss7_ccspan_info['itx'];
				$this->ss7_ccspan_transparent_iam_timeout = $ss7_ccspan_info['transparent_iam_timeout'];
				$this->ss7_ccspan_cpg_on_progress = $ss7_ccspan_info['cpg_on_progress'];
				$this->ss7_ccspan_cpg_on_progress_media = $ss7_ccspan_info['cpg_on_progress_media'];
				$this->ss7_ccspan_t10 = $ss7_ccspan_info['t10'];
				$this->ss7_ccspan_t35 = $ss7_ccspan_info['t35'];
				
				//echo "ccspan profile = " . $this->ss7_ccspan_profile . ", link profile = " . $this->ss7_link_name . "<br />";
				
				if ($this->ss7_voice == "")
				{
					//Grab the ID of the linkset being used by the SS7 Signalling Link
					$table_name = "ss7_linkset_profile";
					$param = "id, profile_name";
					$where_param = "profile_name = \"" . $this->ss7_link_linkset . "\"";
					$linkset_pull = $data->select_statement ("sqlite:sqlite/cardinfo.db", $table_name, $param, $where_param);
					
					$this->ss7_linkset_id = $linkset_pull['id'];
					//echo "profile_name = \"" . $this->ss7_link_linkset . " Linkset ID = " . $linkset_pull['id'] . "<br />";
				}
				
				//Grab the ID of the ISUP Interface being used by the SS7 Link (Voice of V/S link)
				$table_name = "ss7_isup_profile";
				$param = "id, profile_name";
				$where_param = "profile_name = \"" . $this->ss7_ccspan_isup . "\"";
				$isup_pull = $data->select_statement ("sqlite:sqlite/cardinfo.db", $table_name, $param, $where_param);

				$this->ss7_isup_id = $isup_pull['id'];		
				unset ($this->ss7_m2ua_chans);
				unset ($this->ss7_m2ua_link);		
				
			}
			elseif ($check['link_name'] == "")
			{
				
				//Check for M2UA and MG
				unset ($this->ss7_m2ua_link);
				unset($this->ss7_m2ua_chans);
				unset ($this->ss7_sig_channel);
				$pass=false;
				$m2ua_table = $card . "_" . $card_number . "_m2ua_link";
				$mg_table = $card . "_" . $card_number . "_m2ua_channels";
				$param = "link_name";
				$where_param = "port_id = $port_num";
				unset ($check);
				unset ($check_mg);
				
				$check_m2ua = $data->select_statement ($db_location, $m2ua_table, $param, $where_param);		
				$check_mg = $data->select_statement($db_location,$mg_table,"profile_name",$where_param);
				
				if ($check_m2ua['link_name'] != "")
				{
					$this->ss7_span = "yes";
					$this->r2_span = false;
					$this->ss7_m2ua_link=$data->select_statement($db_location,$m2ua_table,'*',$where_param);
					$this->ss7_sig_channel = $this->ss7_m2ua_link['sig_channel'];
					$this->span_num = $this->ss7_m2ua_link['span'];
					$this->line_type=$this->ss7_m2ua_link['line_type'];
					$pass=true;
				}
				
				if ($check_mg['profile_name'] != "")
				{
					$this->ss7_span = "yes";
					$this->r2_span = false;					
					$this->ss7_m2ua_chans=$data->select_statement($db_location,$mg_table,'*',$where_param);
					$this->ss7_ccspan_channel = $this->ss7_m2ua_chans['channel_map'];
					$this->mg_link_exist = true;
					$pass=true;
				}
				
				//echo "<b> Link name = " . $check['link_name'] . "<br /></b>";
				//echo "<b> mg profile = " . $check_mg['profile_name'] . "<br /></b>";
				//echo "SS7 Span = " . $this->ss7_span . " PASS = " . $pass.'<br />';
				
				if ($pass) {
					//unset all standard ss7 vars
					if ($check_mg['profile_name'] != "" && $this->ss7_m2ua_link['sig_channel'] == "") {
						unset($this->ss7_sig_channel);
						unset($this->ss7_ccspan_channel);						
					}
					
					unset($this->ss7_ccspan_profile);
					unset($this->ss7_ccspan_isup);
					unset($this->ss7_ccspan_cic);
					unset($this->ss7_ccspan_min_digits);
					unset($this->ss7_ccspan_clg_nadi);
					unset($this->ss7_ccspan_rdnis_nadi);
					unset($this->ss7_ccspan_cld_nadi);
					unset($this->ss7_ccspan_obci_bita);
					unset($this->ss7_ccspan_typecntrl);
					unset($this->ss7_ccspan_group_num);
					unset($this->ss7_ccspan_lpa);
					unset($this->ss7_ccspan_transparent_iam);
					unset($this->ss7_ccspan_itx);
					unset($this->ss7_ccspan_transparent_iam_timeout);
					unset($this->ss7_ccspan_cpg_on_progress);
					unset($this->ss7_ccspan_cpg_on_progress_media);
					unset($this->ss7_ccspan_t10);
					unset($this->ss7_ccspan_t35);	
					unset($this->ss7_link_name);
					unset($this->ss7_error_type);
					unset($this->ss7_lssu);
					unset($this->ss7_priority);
					unset($this->ss7_ssf);
					unset($this->ss7_slc);
					unset($this->ss7_link_type);
					unset($this->ss7_line_type);
					unset($this->ss7_voice);
					unset($this->ss7_link_linkset);
					unset($this->ss7_switchtype);							
				}
				
				
				if (!$pass && $this->ss7_span == "no") {
					$this->ss7_span = "no";
					
					//echo $this->ss7_span . "<br />";
					//There isn't SS7 configuration
					//Get the context from the signalling database
					$table_name = $card . "_" . $card_number . "_signalling";
					$param = "channels, group_num, signalling";
					$where_param = "port_id = $port_num";
					$sig_info = $data->select_statement ($db_location, $table_name, $param, $where_param);	

					$table_name = $card . "_" . $card_number . "_r2_signalling";
					$param = "channels, group_num, r2_profile";
					$where_param = "port_id = $port_num";
					$r2_sig_info = $data->select_statement ($db_location, $table_name, $param, $where_param);	
					
					$finished = $data->select_statement ($db_location,'finished_ports','span','card="'.$card.'_'.$card_number.'_'.$port_num.'"');
					$this->span_num = $finished['span'];
					
					if ($r2_sig_info['r2_profile'] != "") {
						$this->profile_name = $r2_sig_info['r2_profile'];
						$this->group_num = $r2_sig_info['group_num'];
						$this->channel_map1 = "1-15:1101";
						$this->channel_map2 = "17-31:1101";
						
						$this->r2_info = $data->select_statement ($db_location, 'r2_profile', '*', 'profile_name="'.$r2_sig_info['r2_profile'].'"');
						$this->r2_span = true;
					}
					elseif ($sig_info['signalling'] != "") {
						//PRI Configuration
						$this->group_num = $sig_info['group_num'];
						$this->profile_name = $sig_info['signalling'];
	
						$table_name = "t1e1_profile";
						$param = "signalling, switchtype, ton_name, ton_value, npi_name, npi_value, facility, facility_timeout, bearer_ITC, bearer_UIL, overlap,transfer";
						$where_param = "profile_name = \"" . $sig_info['signalling'] . "\"";
						$profile_info = $data->select_statement ($db_location, $table_name, $param, $where_param);	
					
						$this->ton_name = $profile_info['ton_name'];
						$this->ton_value = $profile_info['ton_value'];
						$this->npi_name = $profile_info['npi_name'];
						$this->npi_value = $profile_info['npi_value'];
						$this->facility = $profile_info['facility'];
						$this->facility_timeout = $profile_info['facility_timeout'];
						$this->overlap = $profile_info['overlap'];
						$this->bearer_ITC = $profile_info['bearer_ITC'];
						$this->bearer_UIL = $profile_info['bearer_UIL'];
						$this->transfer = $profile_info['transfer'];
	
						$this->tokenize_values();			
					
						//Analyze the way signalling comes in and adjust accordingly for chan_dahdi.conf
						if ($profile_info['signalling'] == "PRI CPE")
							$this->interface = "pri_cpe";	
						elseif ($profile_info['signalling'] == "PRI NET")
							$this->interface = "pri_net";
						elseif ($profile_info['signalling'] == "E&MWink")
							$this->interface = "em";
						
						//Switchtypes	
						if ($profile_info['switchtype'] == "NI2")
							$this->switchtype = "national";
						elseif ($profile_info['switchtype'] == "4ESS")
							$this->switchtype = "4ess";
						elseif ($profile_info['switchtype'] == "5ESS")
							$this->switchtype = "5ess";
						elseif ($profile_info['switchtype'] == "DMS100")
							$this->switchtype = "dms100";
						elseif ($profile_info['switchtype'] == "QSIG")
							$this->switchtype = "qsig";
						elseif ($profile_info['switchtype'] == "EuroISDN")
							$this->switchtype = "euroisdn";
						elseif ($profile_info['switchtype'] == "E&MWink")
							$this->switchtype = "em";
					
						//Channel Calculations
						if ($this->line_type == "T1")
						{
							$this->channel_map1 = $sig_info['channels'];
							$this->dchan = "24";
						}
						elseif ($this->line_type == "E1")
						{
							$this->channel_map1 = "1-15";
							$this->channel_map2 = "17-31";
							$this->dchan = "16";
						}
						$this->r2_span = false;
					}
				}
			}
		}
		if ($card == "A500" || $card == "B700")
		{
			//Gets hardware information needed for freetdm config
			$table_name = $card . "_" . $card_number;
			$param = "rxgain, txgain";
			$where_param = "port_id = $port_num";
			$hw_info = $data->select_statement ($db_location, $table_name, $param, $where_param);

			$this->rx_gain = $hw_info['rxgain'];
			$this->tx_gain = $hw_info['txgain'];
						
			//Get the context from the signalling database
			$table_name = $card . "_" . $card_number . "_signalling";
			$param = "profile_name, conn_type, sig_type, interface, switchtype, tei, overlap, ton_name, ton_value, npi_name, npi_value, bearer_ITC, bearer_UIL, msn, channels, group_num, min_digits";
			$where_param = "id = $port_num";
			$sig_info = $data->select_statement ($db_location, $table_name, $param, $where_param);	

			$this->group_num = $sig_info['group_num'];
			$this->bearer_ITC = $sig_info['bearer_ITC'];
			$this->bearer_UIL = $sig_info['bearer_UIL'];						
			$this->channels = $sig_info['channels'];
			$this->msn = $sig_info['msn'];
			$this->switchtype = strtolower($sig_info['switchtype']);
			$this->sig_type = strtolower ($sig_info['sig_type']);
			$this->conn_type = $sig_info['conn_type'];
			$this->profile_name = $sig_info['profile_name'];
			$this->interface = $sig_info['interface'];
			$this->ton_name = $sig_info['ton_name'];
			$this->ton_value = $sig_info['ton_value'];
			$this->npi_name = $sig_info['npi_name'];
			$this->npi_value = $sig_info['npi_value'];
			$this->tei = $sig_info['tei'];
			$this->min_digits = $sig_info['min_digits'];
			
			if ($this->conn_type == "TE" || $this->conn_type == "NT")
			{
				$this->tokenize_values();
			
				if ($sig_info['overlap'] == "enable")
					$this->overlap = "yes";
				elseif ($sig_info['overlap'] == "disable")
					$this->overlap = "no";
				
				if ($this->interface == "ptmp")
					$this->trunk_type = "bri_ptmp";
				if ($this->interface == "ptp")
					$this->trunk_type = "bri";
			}
			elseif ($this->conn_type == "FXO" || $this->conn_type == "FXS")
			{
				$param = "*";
				$where_param = "profile_name = \"" . $sig_info['profile_name'] . "\"";
				$sig_info = $data->select_statement ($db_location, "analog_profile", $param, $where_param);	
				
				$this->hangup_polarity = $sig_info['hangup_polarity'];
				$this->answer_polarity = $sig_info['answer_polarity'];
				$this->polarity_delay = $sig_info['polarity_delay'];
				$this->callerid = $sig_info['callerid'];
				$this->tones = $sig_info['tones'];
				$this->call_waiting = $sig_info['call_waiting'];
				$this->three_way = $sig_info['three_way'];
				$this->call_swap = $sig_info['call_swap'];
				$this->digit_timeout = $sig_info['digit_timeout'];
				$this->max_digits = $sig_info['max_digits'];				
			}
		}
		//Analog port information
		if ($card == "A200" || $card == "A400" || $card == "B600" || $card == "B601" && $port_num == 2)
		{
			//Gets hardware information needed for freetdm config
			$table_name = $card . "_" . $card_number;
			$param = "rxgain, txgain";
			$where_param = "port_id = $port_num";
			$hw_info = $data->select_statement ($db_location, $table_name, $param, $where_param);

			$this->rx_gain = $hw_info['rxgain'];
			$this->tx_gain = $hw_info['txgain'];
			
			//Get the group number from the signalling database
			$table_name = $card . "_" . $card_number . "_signalling";
			$param = "*";
			if ($card == "B700")
				$where_param = "id = $port_num";
			else
				$where_param = "port_id = $port_num";
				
			$sig_info = $data->select_statement ($db_location, $table_name, $param, $where_param);				
			
			$this->group_num = $sig_info['group_num'];
			
			$param = "*";
			$where_param = "profile_name = \"" . $sig_info['profile_name'] . "\"";
			$sig_info = $data->select_statement ($db_location, "analog_profile", $param, $where_param);	

			//echo "profile = " . $sig_info['profile_name'] . ", polarity = " . $sig_info['polarity'] . "<br />";
			
			$this->hangup_polarity = $sig_info['hangup_polarity'];
			$this->answer_polarity = $sig_info['answer_polarity'];
			$this->polarity_delay = $sig_info['polarity_delay'];			
			$this->callerid = $sig_info['callerid'];
			$this->tones = $sig_info['tones'];
			$this->call_waiting = $sig_info['call_waiting'];
			$this->three_way = $sig_info['three_way'];
			$this->call_swap = $sig_info['call_swap'];
			$this->digit_timeout = $sig_info['digit_timeout'];
			$this->max_digits = $sig_info['max_digits'];
			
			//echo $this->threeway . "<br />";
		}

		//get ss7_global_config_data
		$this->ss7_global_config = $data->array_select_statement($this->db_location, 'ss7_global_config' , '*');
	}
	
	//Generates FreeTDM.conf
	function freetdm_conf($static, $module)
	{
		if ($static == "")
		{
			$file_name = "freetdm.conf";		
			$filehandle = fopen($file_name, 'w') or die("can't open file");
			$card_portion = "[general]
cpu_monitor=yes
cpu_alarm_action=warn
cpu_set_alarm_threshold=92
cpu_clear_alarm_threshold=82
";
			fwrite($filehandle, $card_portion);
			fclose($filehandle);			
		}
		
		//write the config file
		if ($static == "hello")
		{
			$file_name = "freetdm.conf";		
			$filehandle = fopen($file_name, 'a') or die("can't open file");
		
			if ($this->card_name == "A101" || $this->card_name == "A102" || $this->card_name == "A104" || $this->card_name == "A108" || $this->card_name == "A116" || $this->card_name == "B601" && $this->port_num == 1)
			{
				//echo "SS7 span = "  . $this->ss7_span . "<br />";
				$no_bchans=false;
						
				/*echo "<b>Chans:";		
				print_r ($this->ss7_m2ua_chans);
				echo "<br />Link:";
				print_r ($this->ss7_m2ua_link);
				echo "<br /></b>";*/
				$skip = false;
				if ($this->ss7_m2ua_link['voice_chans'] == "" && !$this->mg_link_exist ) {
					//echo "found one, " . $this->span_num . "<br />";
					$skip = true;
				}
				elseif ($this->ss7_m2ua_link['voice_chans'] == 'no')
					$no_bchans=true;
					
				if ($this->ss7_span == "yes")
				{	

					if ($this->ss7_m2ua_chans['ss7_span'] != "") 
                    	$span_id = $this->ss7_m2ua_chans['ss7_span'];
                    else
                    	$span_id = $this->span_num;

					if (($this->ss7_m2ua_link['voice_chans'] != 'no' && !$skip) || ($this->ss7_ccspan_profile != "")) {
						$card_portion="
						
#" . $this->card_name . " Card Number = " . $this->card_number . " ". $this->line_type . " SS7 Configuration Port = " . $this->port_num . "
[span wanpipe wp" . $span_id . "]";
						if ($this->pre_buffer_size != 0)
							$card_portion.="
pre_buffer_size=" . $this->pre_buffer_size;

					$card_portion.="
trunk_type=" . $this->line_type . "
rxgain => " . $this->rx_gain . "
txgain => " . $this->tx_gain;
					if ($this->ss7_ccspan_group_num!="") 
						$card_portion.= "
group=>g" . $this->ss7_ccspan_group_num;
						
						if ($this->line_type == "T1")
							$last_chan = "24";
						elseif ($this->line_type == "E1")
							$last_chan = "31";
					
						if ($this->ss7_sig_channel == 1)
						{
							
								$card_portion.="
b-channel => " . $span_id . ":2-" . $last_chan . "\n
";
						}
						elseif ($this->ss7_sig_channel == 2)
						{
							if ($this->line_type == "T1")
								$last_chan = "24";						
							elseif ($this->line_type == "E1")
								$last_chan = "31";
								
							$card_portion.="
b-channel => " . $span_id . ":1
b-channel => " . $span_id . ":3-" . $last_chan . "\n
";	
						}
						elseif ($this->ss7_sig_channel == 23 && $this->line_type == "T1")
						{
							$card_portion.="
b-channel => " . $span_id . ":1-22
b-channel => " . $span_id . ":24\n
";	
						}
						elseif ($this->ss7_sig_channel == 30 && $this->line_type == "E1")
						{
							$card_portion.="
b-channel => " . $span_id . ":1-29
b-channel => " . $span_id . ":31\n	
";	
						}
						elseif ($this->ss7_sig_channel == 24 || $this->ss7_sig_channel == 31)
						{
							$previous_chan = $last_chan -1;
							$card_portion.="
b-channel => " . $span_id . ":1-" . $previous_chan . "\n
";
						}
						elseif ($this->ss7_sig_channel == "")
						{
							$card_portion.="
b-channel => " . $span_id . ":1-" . $last_chan . "\n
";						
						}
						else
						{
							//echo "I am here";
							$previous_chan = $this->ss7_sig_channel -1;
							$next_chan = $this->ss7_sig_channel + 1;
							
							//Make check how many sections of sig channels are in the channel map
							//echo "channel map = " . $this->ss7_ccspan_channel . "<br />";
							$chan_map = explode (',',$this->ss7_ccspan_channel);
							//echo count($chan_map);
							if (count($chan_map) == 2) {
								foreach ($chan_map as $chan) {
									$pos = strpos($chan,'s');
									if ($pos === false) {
										//echo " i am here";
										$card_portion.= "
b-channel => " . $span_id . ":" . $chan .  "\n";						
									}
								}
								$card_portion.='
';
							}
							if (count($chan_map) > 2) {
								if ($this->line_type == "T1")
								{
									$last_chan = "24";
									$card_portion.="
b-channel => " . $span_id . ":1-" . $previous_chan . "
b-channel => " . $span_id . ":" . $next_chan . "-" . $last_chan . "\n
";							
								}
								elseif ($this->line_type == "E1")
								{
									$last_chan = "31";
									$card_portion.="
b-channel => " . $span_id . ":1-" . $previous_chan . "
b-channel => " . $span_id . ":" . $next_chan . "-" . $last_chan . "\n
";
								}
							}
						}
					}
				}
				else
				{
					//T1/E1 PRI/R2 Profiles
					if ($this->line_type == "T1" || $this->line_type == "E1")
					{
						$span_id = $this->span_num;
						if ($this->r2_info['profile_name'] != "") {
						$card_portion="

#" . $this->card_name . " Card Number = " . $this->card_number . " MFC/R2 " . $this->line_type . " Configuration Port = " . $this->port_num;
						}
						else {
						$card_portion="

#" . $this->card_name . " Card Number = " . $this->card_number . " PRI " . $this->line_type . " Configuration Port = " . $this->port_num;
						}
						
						$card_portion.="
[span wanpipe wp" . $span_id . "]";

						if ($this->pre_buffer_size != 0)
							$card_portion.="
pre_buffer_size=" . $this->pre_buffer_size;

						if ($this->group_num == "")
							$this->group_num = $this->span_num;

$card_portion .= "
trunk_type=" . $this->line_type . "
rxgain => " . $this->rx_gain . "
txgain => " . $this->tx_gain . "
group=>g" . $this->group_num;
						if ($this->r2_info['profile_name'] == "") {
							$card_portion.="
b-channel => " . $span_id . ":" . $this->channel_map1 . "";
				
							if ($this->line_type == "E1")
							{
							$card_portion.="
b-channel => " . $span_id . ":" . $this->channel_map2 . "";
							}
						}
						else {
							$card_portion.="
cas-channel => " . $span_id . ":" . $this->channel_map1 . "
cas-channel => " . $span_id . ":" . $this->channel_map2;
						}
						if ($this->r2_info['profile_name'] != "") {
							$card_portion.="
";
						}
						else 
							$card_portion.="
d-channel => " . $span_id . ":" . $this->dchan . "
";
					}					
				}
			}
			if ($this->card_name == "A500")
			{
				//BRI Profiles
				if ($this->interface == "ptmp" || $this->interface == "ptp")
				{
					$card_portion="

#" . $this->card_name . " BRI " . $this->interface . " Configuration
[span wanpipe wp" . $this->span_num . "]
trunk_type => " . $this->trunk_type . "
rxgain => " . $this->rx_gain . "
txgain => " . $this->tx_gain . "
group=>g" . $this->group_num . "
b-channel => " . $this->span_num . ":" . $this->channels . "
d-channel => " . $this->span_num . ":3
";
				}
			}
			if ($this->card_name == "B700")
			{
				//BRI Profiles
				if ($this->interface == "ptmp" || $this->interface == "ptp")
				{
					$card_portion="

#" . $this->card_name . " BRI " . $this->interface . " Configuration
[span wanpipe wp" . $this->span_num . "]
trunk_type => " . $this->trunk_type . "
rxgain => " . $this->rx_gain . "
txgain => " . $this->tx_gain . "
group=>g" . $this->group_num . "
b-channel => " . $this->span_num . ":" . $this->channels . "
d-channel => " . $this->span_num . ":3
";
				}
			}			
			
			if ($this->card_name == "A200" || $this->card_name == "A400" || $this->card_name == "B600" || $this->card_name == "B601" && $this->port_num == 2)
			{
				//FXO Profiles
				if ($module == "FXO")
				{
					$card_portion = "

#" . $this->card_name . " FXO Ports
[span wanpipe wp" . $this->span_num . "-FXO]
name => freetdm";					
//echo $this->module_list[1] . "; " .$this->module_list[2] . "<br />";
//echo "counter = " .  count($this->module_list) . "<br />";
					for ($a = 1; $a <= count($this->module_list); $a++)
					{
//echo $this->module_list[$a] . "<br />";						
						if ($this->module_list[$a] == "FXO")
						{
							$card_portion.="
trunk_type => fxo
rxgain => " . $this->rx_gain . "
txgain => " . $this->tx_gain . "
group=> g" . $this->group_num . "
fxo-channel => " . $this->span_num . ":" . $a . "
";
						}
					}	
				}
				
				//FXS Profiles
				if ($module == "FXS")
				{
					$card_portion = "
					
#" . $this->card_name . " FXS Ports
[span wanpipe wp" . $this->span_num . "-FXS]
name => freetdm";											
					for ($a = 1; $a <= count($this->module_list); $a++)
					{
						if ($this->module_list[$a] == "FXS")
						{
							$card_portion.="
							
trunk_type => fxs
rxgain => " . $this->rx_gain . "
txgain => " . $this->tx_gain . "
group=> g" . $this->group_num . "
fxs-channel => " . $this->span_num . ":" . $a . "
";
						}
					}					
				}
			}
			if ($this->card_name == "B700")
			{
				//FXO Profiles
				if ($module == "FXO")
				{
					$card_portion = "
					
#" . $this->card_name . " FXO Ports
[span wanpipe wp" . $this->span_num . "-FXO]
name => freetdm";		
					//echo  count($this->module_list);			
					for ($a = 1; $a <= count($this->module_list); $a++)
					{
						if ($this->module_list[$a] == "FXO")
						{
							$card_portion.="
trunk_type => fxo
rxgain => " . $this->rx_gain . "
txgain => " . $this->tx_gain . "
group=> g" . $this->group_num . "
fxo-channel => " . $this->span_num . ":" . $a . "
";
						}
					}
				}
				
				//FXS Profiles
				if ($module == "FXS")
				{	
					$card_portion = "
					
#" . $this->card_name . " FXS Ports
[span wanpipe wp" . $this->span_num . "-FXS]
name => freetdm";					
					for ($a = 1; $a <= count($this->module_list); $a++)
					{
						if ($this->module_list[$a] == "FXS")
						{
							$card_portion.="
trunk_type => fxs
rxgain => " . $this->rx_gain . "
txgain => " . $this->tx_gain . "
group=> g" . $this->group_num . "
fxs-channel => " . $this->span_num . ":" . $a . "
";
						}
					}
				}
			}			
			//echo $card_portion;
			fwrite($filehandle, $card_portion);
			fclose($filehandle);			
		}
	}	

	//FreeTDM.conf.xml genration
	function freetdm_xml($static, $machine_type = "standalone", $id_num = 1, $relay_id = 1, $mtp3id=NULL)
	{
		if ($relay_id == 1)
			$relay_id = $this->span_num;
		
		$file_name = "freetdm.conf.xml";		
		//echo $this->span_num . "<br />";
		if ($static == "")
		{
			$filehandle = fopen($file_name, 'w') or die("can't open file");
			
			//Generate Static portion of freetdm.conf.xml
			$xml = "		
<configuration name=\"freetdm.conf\" description=\"FreeTDM Configuration\">
	<settings>
		<param name=\"debug\" value=\"0\" />";
			if ($_SESSION['app'] != "freeswitch")
			{
				$xml .= "
		<param name=\"sip-headers\" value=\"1\"/>
		<param name=\"fail-on-error\" value=\"yes\" />
		<param name=\"crash-on-assert\" value=\"no\" />";
			}
			$xml .= "		
	</settings>
	<config_profiles>";
		}
		elseif ($static == "r2_profile") {
			$filehandle = fopen($file_name, 'a') or die("can't open file");			
			
			if ($this->card_name == "A101" || $this->card_name == "A102" || $this->card_name == "A104" || $this->card_name == "A108" || $this->card_name == "A116" || ($this->card_name == "B601" && $this->port_num == 1))
			{
				if ($_SESSION['last_r2_profile'] != $this->profile_name)
				{ 
					//Used to check if the last profile is being written again
					$_SESSION['last_r2_profile'] = $this->profile_name;		
					$xml = '
		<profile name="' . $this->profile_name . '">
			<param name="variant" value="'.$this->r2_info['varient'].'" />
			<param name="max_ani" value="'.$this->r2_info['ani_length'].'" />
			<param name="max_dnis" value="' . $this->r2_info['dnis_length'] . '" />
			<param name="category" value="'.$this->r2_info['category'].'" />';
			
					if ($this->r2_info['collect_calls'] == "yes")
						$xml.='
            <param name="allow_collect_calls" value="yes"/>';
			
					if ($this->r2_info['immediate_accept'] == "yes")
						$xml.='
            <param name="immediate_accept" value="yes"/>';

					if ($this->r2_info['double_answer'] == "yes")
						$xml.='			
            <param name="double_answer" value="yes"/>';

					if ($this->r2_info['skip_category'] == "yes")
						$xml.='				
            <param name="skip_category" value="yes"/>';

					if ($this->r2_info['forced_release'] == "yes")
						$xml.='				
            <param name="forced_release" value="yes"/>';

					if ($this->r2_info['charge_calls'] == "yes")
						$xml.='				
            <param name="charge_calls" value="yes"/>';

					if ($this->r2_info['ani_first'] == "yes")
						$xml.='				
            <param name="get_ani_first" value="yes"/>';

					if ($this->r2_info['backward_timeout'] != 0 && $this->r2_info['backward_timeout'] != "")
						$xml.='				
            <param name="mfback_timeout" value="'.$this->r2_info['backward_timeout'].'"/>';

					if ($this->r2_info['pulse_timeout'] != 0 && $this->r2_info['pulse_timeout'] != "")
						$xml.='				
            <param name="metering_pulse_timeout" value="' . $this->r2_info['pulse_timeout'] . '"/>';
					
					if ($this->r2_info['call_files'] == "yes")
						$xml.='
			<param name="call_files" value="yes"/>';
			
					$xml.='
			<param name="logdir" value="$${base_dir}/log/mfcr2"/>
			<!-- <param name="advanced_protocol_file" value="$${base_dir}/conf/autoload_configs/r2proto.conf"/> -->
		</profile>';
				}
			}
		}
		elseif ($static == "Profile")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");			
			
			if ($this->card_name == "A101" || $this->card_name == "A102" || $this->card_name == "A104" || $this->card_name == "A108" || $this->card_name == "A116" || $this->card_name == "B601" && $this->port_num == 1)
			{
				if ($_SESSION['last_t1_e1_profile'] != $this->profile_name)
				{ 
				//Used to check if the last profile is being written again
					$_SESSION['last_t1_e1_profile'] = $this->profile_name;
					$xml = "
		<profile name=\"" . $this->profile_name . "\">
			<param name=\"switchtype\" value=\"" . $this->switchtype . "\" />
			<param name=\"transfer\" value=\"" . $this->transfer . "\" />";
			
					if ($this->card_name == "A101" || $this->card_name == "A102" || $this->card_name == "A104" || $this->card_name == "A108" || $this->card_name == "A116" || $this->card_name == "B601" && $this->port_num == 1)
					{
						$xml.="
			<param name=\"interface\" value=\"" . $this->interface . "\" />";
					}
					elseif ($this->card_name == "A500" || $this->card_name == "B700")
					{
						$xml.="
			<param name=\"interface\" value=\"" . $this->sig_type . "\" />";
					}
	
					//Overlap Dialing Option	
					if ($this->overlap == "disable") {			
						$xml.="
			<param name=\"overlap\" value=\"no\" />";
					}
					elseif ($this->overlap == "enable") {
						$xml.="
			<param name=\"overlap\" value=\"yes\" />";
					}
					
					if ($this->bearer_ITC != "" )
					{
						$xml .= "
			<param name=\"outbound-bc-transfer-cap\" value=\"" . $this->bearer_ITC . "\" />";
					}
	
					if ($this->bearer_UIL != "" )
					{
						$xml .= "
			<param name=\"outbound-bc-user-layer1\" value=\"" . $this->bearer_UIL . "\" />";
					}
					if ($this->facility != "no" && $this->facility_timeout > 0)
					{
						$xml .="
			<param name=\"facility\" value=\"" . $this->facility . "\" />
			<param name=\"facility-timeout\" value=\"" . $this->facility_timeout . "\" />";
					}
					elseif ($this->facility == "yes")
					{
						$xml .="
			<param name=\"facility\" value=\"" . $this->facility . "\" />";			
					}
					if ($this->ton_name1 != "" && $this->ton_value1 != "")
					{
						$xml.="
			<param name=\"" . $this->ton_name1 . "\" value=\"" . $this->ton_value1 . "\" />";
					}
					if ($this->ton_name2 != "" && $this->ton_value2 != "")
					{
						$xml.="
			<param name=\"" . $this->ton_name2 . "\" value=\"" . $this->ton_value2 . "\" />";
					}
					if ($this->ton_name3 != "" && $this->ton_value3 != "")
					{
						$xml.="
			<param name=\"" . $this->ton_name3 . "\" value=\"" . $this->ton_value3 . "\" />";
					}								
					if ($this->npi_name1 != "" && $this->npi_value1 != "")
					{
						$xml.="
			<param name=\"" . $this->npi_name1 . "\" value=\"" . $this->npi_value1 . "\" />";
					}
					if ($this->npi_name2 != "" && $this->npi_value2 != "")
					{
						$xml.="
			<param name=\"" . $this->npi_name2 . "\" value=\"" . $this->npi_value2 . "\" />";
					}
					if ($this->npi_name3 != "" && $this->npi_value3 != "")
					{
						$xml.="
			<param name=\"" . $this->npi_name3 . "\" value=\"" . $this->npi_value3 . "\" />";
					}																
					$xml .="
		</profile>";					
				}
			}
			if ($this->card_name == "A500" || $this->card_name == "B700")
			{
								
				if ($_SESSION['last_bri_profile'] != $this->profile_name)
				{				
					
					$_SESSION['last_bri_profile'] = $this->profile_name;
					$xml = "
		<profile name=\"" . $this->profile_name . "\">
			<param name=\"switchtype\" value=\"" . $this->switchtype . "\" />";
					$xml.="
			<param name=\"interface\" value=\"" . $this->sig_type . "\" />
			<param name=\"min_digits\" value=\"" . $this->min_digits ."\" />";
			
					if ($this->bearer_ITC != "" )
					{
						$xml .= "
			<param name=\"outbound-bc-transfer-cap\" value=\"" . $this->bearer_ITC . "\" />";
					}

					if ($this->bearer_UIL != "" )
					{
						$xml .= "
			<param name=\"outbound-bc-user-layer1\" value=\"" . $this->bearer_UIL . "\" />";
					}
					if ($this->ton_name1 != "" && $this->ton_value1 != "")
					{
						$xml.="
			<param name=\"" . $this->ton_name1 . "\" value=\"" . $this->ton_value1 . "\" />";
					}
					if ($this->ton_name2 != "" && $this->ton_value2 != "")
					{
						$xml.="
			<param name=\"" . $this->ton_name2 . "\" value=\"" . $this->ton_value2 . "\" />";
					}
					if ($this->ton_name3 != "" && $this->ton_value3 != "")
					{
						$xml.="
			<param name=\"" . $this->ton_name3 . "\" value=\"" . $this->ton_value3 . "\" />";
					}								
					if ($this->npi_name1 != "" && $this->npi_value1 != "")
					{
						$xml.="
			<param name=\"" . $this->npi_name1 . "\" value=\"" . $this->npi_value1 . "\" />";
					}
					if ($this->npi_name2 != "" && $this->npi_value2 != "")
					{
						$xml.="
			<param name=\"" . $this->npi_name2 . "\" value=\"" . $this->npi_value2 . "\" />";
					}
					if ($this->npi_name3 != "" && $this->npi_value3 != "")
					{
						$xml.="
			<param name=\"" . $this->npi_name3 . "\" value=\"" . $this->npi_value3 . "\" />";
					}		
						
					if ($this->msn1 != "")
					{
						$xml.="
			<param name=\"local-number\" value=\"" . $this->msn1 . "\" />";
					}
					if ($this->msn2 != "")
					{
						$xml.="
			<param name=\"local-number\" value=\"" . $this->msn2 . "\" />";
					}
					if ($this->msn3 != "")
					{
						$xml.="
			<param name=\"local-number\" value=\"" . $this->msn3 . "\" />";
					}
					if ($this->msn4 != "")
						{
						$xml.="
			<param name=\"local-number\" value=\"" . $this->msn4 . "\" />";
					}
					if ($this->msn5 != "")
					{
						$xml.="
			<param name=\"local-number\" value=\"" . $this->msn5 . "\" />";
					}
					if ($this->msn6 != "")
					{
						$xml.="
			<param name=\"local-number\" value=\"" . $this->msn6 . "\" />";
					}
					if ($this->msn7 != "")
					{
						$xml.="
			<param name=\"local-number\" value=\"" . $this->msn7 . "\" />";
					}
					if ($this->msn8 != "")
					{
						$xml.="
			<param name=\"local-number\" value=\"" . $this->msn8 . "\" />";
					}																												
					if ($this->overlap == "yes")
					{
						$xml.="
			<param name=\"overlap\" value=\"" . $this->overlap . "\" />";
					}
					if ($this->tei != "")
					{
						if ($this->tei > 0 || $this->tei < 127)
						{
							$xml.="
			<param name=\"tei\" value=\"" . $this->tei . "\" />";
						}
					}
			
					$xml .="
		</profile>";
				}
			}
		}
		elseif ($static == "end config_profiles")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
	</config_profiles>";
		}
		//PRI Spans
		elseif ($static == "start R2 spans")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
	<r2_spans>";			
		}
		elseif ($static == "R2 spans")
		{
			if ($this->ss7_span != "yes")
			{
				$filehandle = fopen($file_name, 'a') or die("can't open file");					
				$dialplan = "\$\${pstn_context}";
				
				$xml = "
		<span name=\"wp" . $this->span_num . "\" cfgprofile=\"" . $this->profile_name . "\">
			<param name=\"dialplan\" value=\"XML\" />
			<param name=\"context\" value=\"$dialplan\" />
		</span>";
			}
		}
		elseif ($static == "close R2 spans")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
	</r2_spans>";
		}		
		//PRI Spans
		elseif ($static == "start PRI spans")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
	<sangoma_pri_spans>";			
		}
		elseif ($static == "PRI spans")
		{
			if ($this->ss7_span != "yes")
			{
				$filehandle = fopen($file_name, 'a') or die("can't open file");	
				$dialplan = "\$\${pstn_context}";
				
				$xml = "
		<span name=\"wp" . $this->span_num . "\" cfgprofile=\"" . $this->profile_name . "\">
			<param name=\"dialplan\" value=\"XML\" />
			<param name=\"context\" value=\"$dialplan\" />
		</span>";
			}
		}
		elseif ($static == "close PRI spans")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
	</sangoma_pri_spans>";
		}
		//BRI Spans
		elseif ($static == "start BRI spans")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
	<sangoma_bri_spans>";			
		}
		elseif ($static == "BRI spans")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			if ($_SESSION['app'] == "freeswitch")
				$dialplan = "default";
			else
				$dialplan = "\$\${pstn_context}";
			
			$xml = "
		<span name=\"wp" . $this->span_num . "\" cfgprofile=\"" . $this->profile_name . "\">
			<param name=\"dialplan\" value=\"XML\" />
			<param name=\"context\" value=\"$dialplan\" />
		</span>";			
		}
		elseif ($static == "close BRI spans")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
	</sangoma_bri_spans>";
		}
		elseif ($static == "start analog spans")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
	<analog_spans>";
		}
		elseif ($static == "fxo analog spans")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			if ($_SESSION['app'] == "freeswitch")
				$dialplan = "default";
			else
				$dialplan = "\$\${pstn_context}";
	
			$xml = "			
		<span name=\"wp" . $this->span_num . "-FXO\">
			<param name=\"tonegroup\" value=\"" . $this->tones . "\" />";
			
			if ($this->callerid == "enable")
			{
				$xml .="
			<param name=\"enable-callerid\" value=\"true\" />";
			}
			elseif ($this->callerid == "disable")
			{
				$xml .="
			<param name=\"enable-callerid\" value=\"false\" />";
			}
			if ($this->call_waiting == "enable")
			{
				$xml .="
			<param name=\"callwaiting\" value=\"true\" />";
			}
			elseif ($this->call_waiting == "disable")
			{
				$xml .="
			<param name=\"callwaiting\" value=\"false\" />";
			}					
			if ($this->hangup_polarity == "hangup_enable_fxo" || $this->hangup_polarity == "hangup_enable_both" )
			{
				$xml .="
			<param name=\"hangup-polarity-reverse\" value=\"true\" />";
			}
			if ($this->answer_polarity == "answer_enable_fxo" || $this->answer_polarity == "answer_enable_both" )
			{
				$xml .="
			<param name=\"answer-polarity-reverse\" value=\"true\" />";
			}			
			if ($this->polarity_delay != "")
			{
				$xml .="
			<param name=\"polarity-delay\" value=\"" . $this->polarity_delay . "\" />";				
			}			
			if ($this->three_way == "enable")
			{
				$xml .="
			<param name=\"enable-analog-option\" value=\"3-way\" />";
			}
			if ($this->call_swap == "enable")
			{
				$xml .="
			<param name=\"enable-analog-option\" value=\"call-swap\" />";
			}			
				
			$xml .= "
			<param name=\"dialplan\" value=\"XML\" />
			<param name=\"context\" value=\"$dialplan\" />
		</span>";
		}
		elseif ($static == "fxs analog spans")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			if ($_SESSION['app'] == "freeswitch")
				$dialplan = "default";
			else
				$dialplan = "\$\${pstn_context}";

			//polarity, callerid, tones, call_waiting, three_way, call_swap, digit_timeout, max_digits		
			$xml = "
		<span name=\"wp" . $this->span_num . "-FXS\">
			<param name=\"tonegroup\" value=\"" . $this->tones . "\" />";
			
			if ($this->callerid == "enable")
			{
				$xml .="
			<param name=\"enable-callerid\" value=\"true\" />";
			}
			elseif ($this->callerid == "disable")
			{
				$xml .="
			<param name=\"enable-callerid\" value=\"false\" />";
			}			
			if ($this->call_waiting == "enable")
			{
				$xml .="
			<param name=\"callwaiting\" value=\"true\" />";
			}	
			elseif ($this->call_waiting == "disable")
			{
				$xml .="
			<param name=\"callwaiting\" value=\"false\" />";
			}
			if ($this->hangup_polarity == "hangup_enable_fxs" || $this->hangup_polarity == "hangup_enable_both" )
			{
				$xml .="
			<param name=\"hangup-polarity-reverse\" value=\"true\" />";
			}
			if ($this->answer_polarity == "answer_enable_fxs" || $this->answer_polarity == "answer_enable_both" )
			{
				$xml .="
			<param name=\"answer-polarity-reverse\" value=\"true\" />";
			}	
			if ($this->digit_timeout != "")
			{
				$xml .="
			<param name=\"digit-timeout\" value=\"". $this->digit_timeout . "\" />";
			}
			if ($this->max_digits != "")
			{
				$xml .="
			<param name=\"max-digits\" value=\"" . $this->max_digits . "\" />";				
			}
			if ($this->three_way == "enable")
			{
				$xml .="
			<param name=\"enable-analog-option\" value=\"3-way\" />";
			}
			if ($this->call_swap == "enable")
			{
				$xml .="
			<param name=\"enable-analog-option\" value=\"call-swap\" />";
			}		
					
			$xml .="
			<param name=\"dialplan\" value=\"XML\" />
			<param name=\"context\" value=\"$dialplan\" />
		</span>";
		}
		elseif ($static == "end analog spans")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
	</analog_spans>";			
		}
		elseif ($static == "end")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");		
			
			//Close File and place static end tags
			$xml = "
</configuration>";
		}
		
		//SS7 Spans
		//elseif ($this->ss7_span == "yes")
		//{
			
			elseif ($static == "start SS7 spans")
			{
				$filehandle = fopen($file_name, 'a') or die("can't open file");	
				
				$xml = "
	<sangoma_ss7_spans>";			
			}
			elseif ($static == "SS7 spans")
			{
				$filehandle = fopen($file_name, 'a') or die("can't open file");	
				
				if ($_SESSION['app'] == "freeswitch")
					$dialplan = "default";
				else
					$dialplan = "\$\${pstn_context}";
				
				$skip = false;
				
				if ($this->ss7_m2ua_link['link_name'] != "") {
					$op_mode = "M2UA_SG";
					$span_id = $this->ss7_m2ua_link['span'];
					if ($this->ss7_m2ua_link['cluster'] == "") 
						$skip = true;
					else
						$skip = false;
				}
				else {
					$op_mode = "ISUP";
					$skip = false;
					$span_id = $this->span_num;
				}
				
				if (!$skip) {
					#If span number for ccspanid is wrong, put $relay_id
					$xml = "
		<span name=\"wp" . $span_id . "\" cfgprofile=\"ss7config\" operating_mode=\"" . $op_mode . "\">
			<param name=\"ccSpanId\" value=\"" . $span_id . "\" />
			<param name=\"dialplan\" value=\"XML\" />
			<param name=\"context\" value=\"$dialplan\" />
		</span>";
				}
			}
			elseif ($static == "close SS7 spans")
			{
				$filehandle = fopen($file_name, 'a') or die("can't open file");	
				
				$xml = "
	</sangoma_ss7_spans>";
			}	

		elseif ($static == "start SS7 config")
		{
			$licence_file = $_SESSION['smg_location'] . "/conf/license.txt";
			
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
	<signaling_configs>
		<sngss7_configs>
			<sng_isup name=\"ss7config\">
				<sng_gen>
					<param name=\"procId\" value=\"" . $id_num . "\"/>
					<param name=\"license\" value=\"" . $licence_file . "\" />".PHP_EOL;
			$autocongestion = false;
			foreach ($this->ss7_global_config as $globalparameters) {
				if($globalparameters['parameter'] == 'auto-congestion-control' && $globalparameters['value'] == 'enable')
					{
						$autocongestion = true;
					}
				}
			foreach($this->ss7_global_config as $globalparameters) {
				if($autocongestion==false && $globalparameters['valuegroup'] == 'acc')
				{
					continue;
				}
				if($globalparameters['parameter'] == 'isup-message-hexadecimal')
				{
					continue;
				}
				if($globalparameters['value']!='')
				$xml.="\t\t\t\t\t<param name=\"".$globalparameters['parameter']."\" value=\"" . $globalparameters['value'] . "\"/>".PHP_EOL;
			}

		$xml.="\t\t\t\t</sng_gen>".PHP_EOL;
		$xml.="\t\t\t\t<sng_relay>";
				//Determine the relay configuration settings. If standalone, leave blank
				//If not standalone, find out the relay type, then place the appropriate information in there.
				//echo $machine_type . "<br />";
				if ($machine_type != "standalone")
				{
					$relay = $this->get_relay_hosts();
					if ($id_num == 1)
					{
						//Pull all the information for the relay hosts and place it in freetdm.conf.xml
						for ($a = 0; $a <= count($relay); $a++)
						{
							if ( $relay[$a]['id'] > 1)
							{
								//Slave
								$xml.= "
					<relay_channel name=\"" . $relay[$a]['relay_name'] . "\">
						<param name=\"type\" value=\"server\" />
						<param name=\"hostname\" value=\"" . $relay[$a]['ip_addr'] . "\" />
						<param name=\"port\" value=\"" . $relay[$a]['relay_port'] . "\" />
						<param name=\"procId\" value=\"" . $relay[$a]['id'] . "\" />
					</relay_channel>
						";
							}
							elseif ( $relay[$a]['id'] == 1)
							{
								//Master
								$xml.= "
					<relay_channel name=\"" . $relay[$a]['relay_name'] . "\">
						<param name=\"type\" value=\"listen\" />
						<param name=\"hostname\" value=\"" . $relay[$a]['ip_addr'] . "\" />
						<param name=\"port\" value=\"" . $relay[$a]['relay_port'] . "\" />
						<param name=\"procId\" value=\"" . $relay[$a]['id'] . "\" />
					</relay_channel>
						";							
							}
						}
					}
					else
					{
						for ($a = 0; $a <= count($relay); $a++)
						{
							//Pull all the information for the master and the slave itself and place in freetdm.conf.xml
							if ($relay[$a]['id'] == $id_num)
							{
								//Slave
								$xml.= "
						<relay_channel name=\"" . $relay[$a]['relay_name'] . "\">
							<param name=\"type\" value=\"listen\" />
							<param name=\"hostname\" value=\"" . $relay[$a]['ip_addr'] . "\" />
							<param name=\"port\" value=\"" . $relay[$a]['relay_port'] . "\" />
							<param name=\"procId\" value=\"" . $relay[$a]['id'] . "\" />
						</relay_channel>
						";
							}
							elseif ($relay[$a]['id'] == 1)
							{
								//Master
								$xml.= "
						<relay_channel name=\"" . $relay[$a]['relay_name'] . "\">
							<param name=\"type\" value=\"client\" />
							<param name=\"hostname\" value=\"" . $relay[$a]['ip_addr'] . "\" />
							<param name=\"port\" value=\"" . $relay[$a]['relay_port'] . "\" />
							<param name=\"procId\" value=\"" . $relay[$a]['id'] . "\" />
						</relay_channel>
						";							
							}	
						}
						
					}
				}
			$xml .="	
				</sng_relay>			
";

		}
		elseif ($static == "stop SS7 config")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
			</sng_isup>
		</sngss7_configs>
	</signaling_configs>			
";
		}
		elseif ($static == "start_mtp1_links")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				<mtp1_links>";
		}		
		elseif ($static == "mtp1_links")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			if ($this->ss7_m2ua_link['link_name'] != "" && $this->ss7_m2ua_link['cluster'] != "") {
				//M2UA
				$xml = "					
					<mtp1_link name=\"mtp1-". $this->ss7_m2ua_link['span'] . "\">
						<param name=\"id\" value=\"" . $this->ss7_m2ua_link['span'] . "\"/>
						<param name=\"span\" value=\"" . $this->ss7_m2ua_link['span'] . "\"/>
						<param name=\"chan\" value=\"" . $this->ss7_sig_channel . "\"/>
					</mtp1_link>";					
			}
			elseif ($this->ss7_m2ua_link['link_name'] != "" && $this->ss7_m2ua_link['cluster'] == "") {
			}
			else {
				//ISUP
				$xml = "					
					<mtp1_link name=\"mtp1-". $this->span_num . "\">
						<param name=\"id\" value=\"" . $this->span_num . "\"/>
						<param name=\"span\" value=\"" . $this->span_num . "\"/>
						<param name=\"chan\" value=\"" . $this->ss7_sig_channel . "\"/>
					</mtp1_link>";	
			}
		}
		elseif ($static == "stop_mtp1_links")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				</mtp1_links>
";
		}		
		elseif ($static == "start_mtp2_links")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				<mtp2_links>";			
		}		
		elseif ($static == "mtp2_links")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			if ($this->ss7_m2ua_link['link_name'] != "" && $this->ss7_m2ua_link['cluster'] != "") {
				//M2UA
				$xml = "
					<mtp2_link name=\"mtp2-". $this->ss7_m2ua_link['span'] . "\">
						<param name=\"id\" value=\"" . $this->ss7_m2ua_link['span'] . "\"/>
						<param name=\"mtp1Id\" value=\"" . $this->ss7_m2ua_link['span']. "\"/>
						<param name=\"errorType\" value=\"" . $this->ss7_m2ua_link['error_type'] . "\"/>
						<param name=\"lssuLength\" value=\"" . $this->ss7_m2ua_link['lssu'] . "\"/>
						<param name=\"linkType\" value=\"" . $this->ss7_m2ua_link['link_type']. "\"/>
					</mtp2_link>";
			}
			elseif ($this->ss7_m2ua_link['link_name'] != "" && $this->ss7_m2ua_link['cluster'] == "") {
			}
			else {
				//ISUP
				$xml = "
					<mtp2_link name=\"mtp2-". $this->span_num . "\">
						<param name=\"id\" value=\"" . $this->span_num . "\"/>
						<param name=\"mtp1Id\" value=\"" . $this->span_num. "\"/>
						<param name=\"errorType\" value=\"" . $this->ss7_error_type . "\"/>
						<param name=\"lssuLength\" value=\"" . $this->ss7_lssu . "\"/>
						<param name=\"linkType\" value=\"" . $this->ss7_link_type . "\"/>
					</mtp2_link>";				
			}
		}
		elseif ($static == "stop_mtp2_links")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				</mtp2_links>
";			
		}				
		elseif ($static == "start_mtp3_links")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				<mtp3_links>";			
		}		
		elseif ($static == "mtp3_links")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			//ISUP
			$xml = "					
					<mtp3_link name=\"mtp3-". $this->span_num  . "\">
						<param name=\"id\" value=\"" . $this->span_num  . "\"/>
						<param name=\"mtp2Id\" value=\"" . $this->span_num  . "\"/>
						<param name=\"mtp2ProcId\" value=\"" . $id_num . "\"/>
						<param name=\"linkType\" value=\"" . $this->ss7_link_type . "\"/>
						<param name=\"switchType\" value=\"" . $this->ss7_switchtype . "\"/>
						<param name=\"ssf\" value=\"" . $this->ss7_ssf . "\" />
						<param name=\"slc\" value=\"" . $this->ss7_slc . "\"/>
						<param name=\"linkset\" value=\"" . $this->ss7_linkset_id . "\"/>
					</mtp3_link>";			
		}
		elseif ($static == "stop_mtp3_links")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				</mtp3_links>
";			
		}	
		
		//SCTP
		elseif ($static == "start_sctp") {
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				<sng_sctp_interfaces>";			
		}
		elseif ($static == "sctp_interfaces")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$this->table_name = "sctp_interfaces";
			$this->get_profiles();
			
			//echo $this->counter;
			
			for ($a = 0; $a < $this->counter; $a++)
			{
				//Check if this linkset is used in any routes. If it is not, do not enter it.
				//$result = $this->match_used($this->profile_array[$a]['profile_name'],'linksets', "ss7_route_profile");
				//echo $this->profile_array[$a]['profile_name'] . "<br />";
				//if ($result == "found")
				//{
					$xml .= "
					<sng_sctp_interface name=\"" . $this->profile_array[$a]['profile_name'] . "\">
						<param name=\"id\" value=\"" . $this->profile_array[$a]['id'] . "\"/>
						<sng_source_addresses>";
					if ($this->profile_array[$a]['dest_ip_1'] != "")
						$xml .="
							<param name=\"address\" value=\"" . $this->profile_array[$a]['dest_ip_1'] . "\" />";
					if ($this->profile_array[$a]['dest_ip_2'] != "")
						$xml .="
							<param name=\"address\" value=\"" . $this->profile_array[$a]['dest_ip_2'] . "\" />";
					if ($this->profile_array[$a]['dest_ip_3'] != "")
						$xml .="
							<param name=\"address\" value=\"" . $this->profile_array[$a]['dest_ip_3'] . "\" />";
					if ($this->profile_array[$a]['dest_ip_4'] != "")
						$xml .="
							<param name=\"address\" value=\"" . $this->profile_array[$a]['dest_ip_4'] . "\" />";		
					if ($this->profile_array[$a]['dest_ip_5'] != "")
						$xml .="
							<param name=\"address\" value=\"" . $this->profile_array[$a]['dest_ip_5'] . "\" />";
													
					$xml .= "
						</sng_source_addresses>
						<param name=\"source-port\" value=\"" . $this->profile_array[$a]['port'] . "\" />
					</sng_sctp_interface>";			
				//}
			}
		}		
			
		elseif ($static == "stop_sctp")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				</sng_sctp_interfaces>
";			
		}				
		
		elseif ($static == "start_nif") {
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				<sng_nif_interfaces>";			
		}
		elseif ($static == "stop_nif") {
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				</sng_nif_interfaces>
";			
		}	
		elseif ($static == "nif_int") {
			if ($this->ss7_m2ua_link['cluster'] != "") {
				$filehandle = fopen($file_name, 'a') or die("can't open file");
				$xml = "					
					<sng_nif_interface name=\"M2UA_NIF_". $this->ss7_m2ua_link['span'] . "\">
						<param name=\"id\" value=\"" . $this->ss7_m2ua_link['span'] . "\" />
						<param name=\"m2ua-interface-id\" value=\"" . $this->ss7_m2ua_link['span'] . "\" />
						<param name=\"mtp2-interface-id\" value=\"" . $this->ss7_m2ua_link['span'] . "\" />
					</sng_nif_interface>";				
			}
		}
		elseif ($static == "start_m2ua")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				<sng_m2ua_interfaces>";			
		}	
		elseif ($static == "m2ua_config") {
			if ($this->ss7_m2ua_link['cluster'] != "") {
				$cluster_id = $this->data->select_statement($this->db_location,'m2ua_clusters','id','profile_name="' . $this->ss7_m2ua_link['cluster'] . '"');
				$cluster_int = $cluster_id['id'];
			
				$filehandle = fopen($file_name, 'a') or die("can't open file");
				$xml = "					
					<sng_m2ua_interface name=\"". $this->ss7_m2ua_link['link_name'] . "\">
						<param name=\"id\" value=\"" . $this->ss7_m2ua_link['span'] . "\" />
						<param name=\"m2ua-cluster-interface-id\" value=\"" . $cluster_int . "\" />
						<param name=\"interface-identifier\" value=\"" . $this->ss7_m2ua_link['interface_id'] . "\" />
					</sng_m2ua_interface>";
			}
		}		
		elseif ($static == "stop_m2ua")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				</sng_m2ua_interfaces>
";			
		}					
		elseif ($static == "start_m2ua_peers")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				<sng_m2ua_peer_interfaces>";			
		}	
		elseif ($static == "m2ua_peer") {
			//Get all cluster peer tables
			$this->table_name = "m2ua_clusters";
			$this->get_profiles();
			
			$filehandle = fopen($file_name, 'a') or die("can't open file");
			
			if (isset ($this->profile_array)) {
				$peer_num = 1;
				foreach ($this->profile_array as $cluster) {
				//Pull peers
				$peer_info = $this->get_gen_data($cluster['profile_name'] . '_peers');
				if (!empty($peer_info)) {	
					foreach ($peer_info as $peer) {
						$sctp_id = $this->data->select_statement($this->db_location,'sctp_interfaces','id','profile_name="' . $peer['sctp_int_name']. '"');
						
						if ($peer['include_asp_identifier'] == "enable")
							$include_asp_identifier = "TRUE";
						else
							$include_asp_identifier = "FALSE";
						
						if ($peer['sctp_association'] == "enable")
							$sctp_association = "TRUE";
						else
							$sctp_association = "FALSE";
						
						$xml .= "					
						<sng_m2ua_peer_interface name=\"" . $peer['profile_name'] . "\">
							<param name=\"id\" value=\"" . $peer_num . "\" />
							<param name=\"include-asp-identifier\" value=\"" . $include_asp_identifier . "\" />
							<param name=\"sctp-interface-id\" value=\"" . $sctp_id['id'] . "\" />
							<sng_destination_addresses>";
							if ($peer['dest_ip_addr_1'] != "")
								$xml .="
								<param name=\"address\" value=\"" . $peer['dest_ip_addr_1'] . "\" />";
							if ($peer['dest_ip_addr_2'] != "")
								$xml .="
								<param name=\"address\" value=\"" . $peer['dest_ip_addr_2'] . "\" />";
							if ($peer['dest_ip_addr_3'] != "")
								$xml .="
								<param name=\"address\" value=\"" . $peer['dest_ip_addr_3'] . "\" />";
							if ($peer['dest_ip_addr_4'] != "")
								$xml .="
								<param name=\"address\" value=\"" . $peer['dest_ip_addr_4'] . "\" />";		
							if ($peer['dest_ip_addr_5'] != "")
								$xml .="
								<param name=\"address\" value=\"" . $peer['dest_ip_addr_5'] . "\" />";			
							$xml.="			
							</sng_destination_addresses>
							<param name=\"destination-port\" value=\"" . $peer['dest_port'] . "\" />
							<param name=\"number-of-outgoing-streams\" value=\"" . $peer['num_out_streams'] . "\" />
							<param name=\"init-sctp-association\" value=\"" . $sctp_association . "\" />
						</sng_m2ua_peer_interface>";	
						$peer_num++;
						}
					}
				}
			}
		}		
		elseif ($static == "stop_m2ua_peers")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				</sng_m2ua_peer_interfaces>
";			
		}
		elseif ($static == "start_m2ua_clusters")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				<sng_m2ua_cluster_interfaces>";			
		}	
		elseif ($static == "m2ua_clusters") {
			//Get all cluster peer tables
			unset ($this->profile_array);
			$this->table_name = "m2ua_clusters";
			$this->get_profiles();
			
			$filehandle = fopen($file_name, 'a') or die("can't open file");
			$peer_num = 1;
			if (isset ($this->profile_array)) {
				foreach ($this->profile_array as $cluster) {
					$xml .= "					
					<sng_m2ua_cluster_interface name=\"" . $cluster['profile_name'] . "\">
						<param name=\"id\" value=\"" . $cluster['id'] . "\" />
						<param name=\"traffic-mode\" value=\"" . $cluster['traffic_mode'] . "\" />
						<param name=\"load-share-algorithm\" value=\"" . $cluster['load_share'] . "\" />
						<sng_m2ua_peers>";
					
					$peer_info = $this->get_gen_data($cluster['profile_name'] . '_peers');	
					foreach ($peer_info as $peer) {	
						$xml.="
							<param name=\"m2ua-peer-interface-id\" value=\"" . $peer_num . "\" />";
						$peer_num++;
					}
					
					$xml.= "
						</sng_m2ua_peers>
					</sng_m2ua_cluster_interface>";	
					
				}
			}
		}		
		elseif ($static == "stop_m2ua_clusters")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				</sng_m2ua_cluster_interfaces>
";			
		}				
		elseif ($static == "start_ccspans")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				<cc_spans>";			
		}		
		elseif ($static == "ccspans")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
					<cc_span name=\"" . $this->ss7_ccspan_profile . "\">
						<param name=\"id\" value=\"" . $this->span_num  . "\"/>
						<param name=\"procId\" value=\"" . $id_num . "\"/>
						<param name=\"isup_interface\" value=\"" . $this->ss7_isup_id . "\"/>
						<param name=\"cicbase\" value=\"" . $this->ss7_ccspan_cic . "\"/>
						<param name=\"ch_map\" value=\"" . $this->ss7_ccspan_channel . "\"/>
						<param name=\"typeCntrl\" value=\"" . $this->ss7_ccspan_typecntrl . "\"/>
						<param name=\"lpa_on_cot\" value=\"" . $this->ss7_ccspan_lpa . "\"/>";
						
			//Overlap dialing minimum digits option
			if ($this->ss7_ccspan_min_digits != "")
			{
				$xml .="
						<param name=\"min_digits\" value=\"" . $this->ss7_ccspan_min_digits . "\"/>";
			}
			
			if ($this->ss7_ccspan_t10 != "")
			{
				$t10 = $this->ss7_ccspan_t10 * 10;
				$xml .="
						<param name=\"isup.t10\" value=\"" . $t10 . "\"/>";
			}
			
			if ($this->ss7_ccspan_t35 != "")
			{
				$t35 = $this->ss7_ccspan_t35 * 10;
				$xml .="
						<param name=\"isup.t35\" value=\"" . $t35 . "\"/>";
			}
			
			//NADI Values
			if ($this->ss7_ccspan_clg_nadi != "")
			{
				$xml .="
						<param name=\"clg_nadi\" value=\"" . $this->ss7_ccspan_clg_nadi . "\"/>";
			}
			if ($this->ss7_ccspan_cld_nadi != "")
			{
				$xml .="
						<param name=\"cld_nadi\" value=\"" . $this->ss7_ccspan_cld_nadi . "\"/>";
			}
			if ($this->ss7_ccspan_rdnis_nadi != "")
			{
				$xml .="
						<param name=\"rdnis_nadi\" value=\"" . $this->ss7_ccspan_rdnis_nadi . "\"/>";
			}
			
			//Optional Backwards Indicator Bit Option
			if ($this->ss7_ccspan_obci_bita != "")
			{
				$xml .="
                        <param name=\"obci_bita\" value=\"" . $this->ss7_ccspan_obci_bita . "\"/>";
			}
			
			//SPIROU Transparent IAM Options
			if ($this->ss7_ccspan_transparent_iam != "")
			{
				if (strtoupper($this->ss7_ccspan_transparent_iam) == strtoupper(enable))
				{
					$iam = "yes";
				}
				elseif (strtoupper($this->ss7_ccspan_transparent_iam) == strtoupper(disable))
				{
					$iam = "no";
				}
				$xml .="
						<param name=\"transparent_iam\" value=\"" . $iam . "\"/>";
				if ($iam == "yes")
				{
					$xml.="
						<param name=\"transparent_iam_max_size\" value=\"" . $this->ss7_ccspan_transparent_iam_timeout . "\" />";
				}						
			}
			
			//SPIROU ITX Options
			if ($this->ss7_ccspan_itx != "")
			{
				if (strtoupper($this->ss7_ccspan_itx) == strtoupper(enable))
				{
					$itx = "yes";
				}
				elseif (strtoupper($this->ss7_ccspan_itx) == strtoupper(disable))
				{
					$itx = "no";
				}
				$xml .="
						<param name=\"itx_auto_reply\" value=\"" . $itx . "\"/>";
			}	
			
			//Call Progress Options
			if ($this->ss7_ccspan_cpg_on_progress != "")
			{
				if (strtoupper($this->ss7_ccspan_cpg_on_progress) == strtoupper(enable))
				{
					$cpg_on_progress = "yes";
				}
				elseif (strtoupper($this->ss7_ccspan_cpg_on_progress) == strtoupper(disable))
				{
					$cpg_on_progress = "no";
				}
				$xml .="
						<param name=\"cpg_on_progress\" value=\"" . $cpg_on_progress . "\"/>";
			}	
			
			if ($this->ss7_ccspan_cpg_on_progress_media != "")
			{
				if (strtoupper($this->ss7_ccspan_cpg_on_progress_media) == strtoupper(enable))
				{
					$cpg_on_progress_media = "yes";
				}
				elseif (strtoupper($this->ss7_ccspan_cpg_on_progress_media) == strtoupper(disable))
				{
					$cpg_on_progress_media = "no";
				}
				$xml .="
						<param name=\"cpg_on_progress_media\" value=\"" . $cpg_on_progress_media . "\"/>";
			}						
			
			$xml .="
					</cc_span>";	
									
		}
		elseif ($static == "stop_ccspans")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				</cc_spans>";			
		}		
		elseif ($static == "start_linkset")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				<mtp_linksets>";			
		}		
		elseif ($static == "mtp_linksets")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$this->table_name = "ss7_linkset_profile";
			$this->get_profiles();
			
			//echo $this->counter;
			
			for ($a = 0; $a < $this->counter; $a++)
			{
				//Check if this linkset is used in any routes. If it is not, do not enter it.
				$result = $this->match_used($this->profile_array[$a]['profile_name'],'linksets', "ss7_route_profile");
				//echo $this->profile_array[$a]['profile_name'] . "<br />";
				if ($result == "found")
				{
					$xml .= "
					<mtp_linkset name=\"" . $this->profile_array[$a]['profile_name'] . "\">
						<param name=\"id\" value=\"" . $this->profile_array[$a]['id'] . "\"/>
						<param name=\"apc\" value=\"" . $this->profile_array[$a]['apc'] . "\"/>
						<param name=\"minActive\" value=\"" . $this->profile_array[$a]['minactive'] . "\"/>
					</mtp_linkset>";			
				}
			}
		}
		elseif ($static == "stop_linkset")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				</mtp_linksets>
";			
		}						

		elseif ($static == "start_route")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				<mtp_routes>";			
		}
		elseif ($static == "mtp_route")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			//backhere
			$this->table_name = "ss7_route_profile";
			$this->get_profiles();
			
			//echo $this->profile_array[$a]['profile_name'] . "<br />";
			//tokenize the linksets
			for ($a = 0; $a < $this->counter; $a++)
			{
				$this->token_linksets($this->profile_array[$a]['linksets']);
					
				//echo $this->profile_array[$a]['profile_name'] . "<br />";
				$xml .= "
					<mtp_route name=\"" . $this->profile_array[$a]['profile_name'] . "\">
						<param name=\"id\" value=\"" . $this->profile_array[$a]['id'] . "\"/>
						<param name=\"dpc\" value=\"" . $this->profile_array[$a]['dpc'] . "\"/>
						<param name=\"isSTP\" value=\"" . $this->profile_array[$a]['stp'] . "\"/>
						<linksets>";
				for ($b = 0; $b < count($this->linkset_list); $b++)
				{
					//echo $this->linkset_list[$b] . "<br />";
					$param = "id";
					$where = "profile_name = \"" . $this->linkset_list[$b] . "\"";
					$linkset_id = parent::select_statement($this->db_location,"ss7_linkset_profile", $param, $where);	
					
					$xml .="
							<linkset name=\"" . $linkset_id['id'] . "\"/>";
				}
				$xml .="		
						</linksets>
					</mtp_route>";			
			}
		}				
		elseif ($static == "stop_route")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				</mtp_routes>
";			
		}						

		elseif ($static == "start_isup")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				<isup_interfaces>";			
		}	
		elseif ($static == "isup")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$this->table_name = "ss7_isup_profile";
			$this->get_profiles();
			
			//echo $this->counter;
			
			for ($a = 0; $a < $this->counter; $a++)
			{
				//$this->table_name = "ss7_route_profile";
				$param = "id";
				$where = "profile_name = \"" . $this->profile_array[$a]['route'] . "\"";
				$route_id = parent::select_statement($this->db_location,"ss7_route_profile", $param, $where);
			
				$t6 = $this->profile_array[$a]['t6'] * 10;
				$t9 = $this->profile_array[$a]['t9'] * 10;
			
				//echo $this->profile_array[$a]['profile_name'] . "<br />";
				$xml .= "
					<isup_interface name=\"" . $this->profile_array[$a]['profile_name'] . "\">
						<param name=\"id\" value=\"" . $this->profile_array[$a]['id'] . "\"/>
						<param name=\"spc\" value=\"" . $this->profile_array[$a]['spc'] . "\"/>
						<param name=\"mtpRouteId\" value=\"" . $route_id['id'] . "\"/>
						<param name=\"ssf\" value=\"" . $this->profile_array[$a]['ssf'] . "\"/>
						<param name=\"isup.t6\" value=\"" . $t6 . "\"/>
						<param name=\"isup.t9\" value=\"" . $t9 . "\"/>
					</isup_interface>";			
			}
		}			
		elseif ($static == "stop_isup")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "
				</isup_interfaces>
";			
		}						

		elseif ($static == "ss7_isup")
		{
			$filehandle = fopen($file_name, 'a') or die("can't open file");	
			
			$xml = "";		
		}

		fwrite($filehandle, $xml);
		fclose($filehandle);
	}
	
	//Tokenizes the TON, NPI and MSN values
	function tokenize_values()
	{
		$sPattern = '/\s*/m';
		$sReplace = '';

		//TON Name tokenization
		$tok = strtok($this->ton_name, ",");

		$count = 0;
		while ($tok !== false) 
		{
			//$token[$count] = $tok;
			$token[$count] = preg_replace( $sPattern, $sReplace, $tok);			
		    $tok = strtok(",");
			$count++;
		}	
		
		$this->ton_name1 = $token[0];
		$this->ton_name2 = $token[1];
		$this->ton_name3 = $token[2];
		
		
		$token="";
		$tok = strtok($this->ton_value, ",");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $token[$count] = preg_replace( $sPattern, $sReplace, $tok);
		    $tok = strtok(",");
			$count++;
		}	
		
		$this->ton_value1 = $token[0];
		$this->ton_value2 = $token[1];
		$this->ton_value3 = $token[2];
		
		$token="";
		$tok = strtok($this->npi_name, ",");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $token[$count] = preg_replace( $sPattern, $sReplace, $tok);
		    $tok = strtok(",");
			$count++;
		}	
		
		$this->npi_name1 = $token[0];
		$this->npi_name2 = $token[1];
		$this->npi_name3 = $token[2];
		
		$token="";
		$tok = strtok($this->npi_value, ",");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $token[$count] = preg_replace( $sPattern, $sReplace, $tok);
		    $tok = strtok(",");
			$count++;
		}	
		
		$this->npi_value1 = $token[0];
		$this->npi_value2 = $token[1];
		$this->npi_value3 = $token[2];
		
		
		if ($this->card_name == "A500" || $this->card_name == "B700")
		{
			$token="";
			$tok = strtok($this->msn, ",");

			$count = 0;
			while ($tok !== false) 
			{
				$token[$count] = $tok;
			    $tok = strtok(",");
				$count++;
			}	
		
			$this->msn1 = $token[0];
			$this->msn2 = $token[1];
			$this->msn3 = $token[2];
			$this->msn4 = $token[3];
			$this->msn5 = $token[4];
			$this->msn6 = $token[5];
			$this->msn7 = $token[6];
			$this->msn8 = $token[7];		
		}
	}	
	
	function get_profiles()
	{
		$db_location = "sqlite:sqlite/cardinfo.db";
		//$db_location = $this->db_location;
		$where_param = "";
		$a = 0;

		$select = "SELECT * FROM " . $this->table_name . ";";
		
		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$this->profile_array[$a] = $row;
				//echo "card = " . $this->profile_array[$a]['profile_name'] . "<br />";
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}

		$this->counter = $a;
	}	
	
	//separates the linkset values in the database
	function token_linksets($string)
	{
		$tok = strtok($string, ",");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok(",");
			$count++;
		}	
		//$hash = "sel_linkset$count";
		
		for ($a = 0; $a < $count; $a++)
		{
			$this->linkset_list[$a] = $token[$a];
			//echo $token[$a] . "<br />";
		}
		
		//echo $count;		
	}	
	
	//Searches through a table and checks to see if the item is there
	function match_used($profile_name,$item_search_param,$table_name)
	{
		#USAGE: $result = $this->match_used($this->profile_array[$a]['profile_name'],'linksets', "ss7_route_profile");
		$db_location = "sqlite:sqlite/cardinfo.db";
		$where_param = "";
		$a = 0;

		$select = "SELECT " . $item_search_param . " FROM " . $table_name . ";";
		
		//Pull all the linksets configured within all the SS7 Links and match them to the linksets configured
		if ($item_search_param == "linksets")
		{
			$link_list = $this->get_linksets_used($profile_name);
			for ($b=0; $b < count($link_list); $b++)
			{
				//echo $link_list[$b]['name'];
				try
				{
					//open the database
					$db = new PDO($db_location);
		
					$result = $db->query($select);
				
					foreach($result as $row)
					{
						//$this->profile_array[$a] = $row;
						//echo "Item = " . $profile_name . "<br />";
						//echo "DB entry = " . $row[$item_search_param] . "<br />";
						if ($item_search_param == "linksets")
						{
							if (preg_match("'\b$profile_name\b'",$row[$item_search_param]) && $profile_name == $link_list[$b]['name'])
							{
								$result = "found";
								//echo $result . "<br />";
							}
						}
						
						//echo "card = " . $this->profile_array[$a]['profile_name'] . "<br />";
						$a++;
					}
					// close the database connection
					$db = NULL;
				}
				catch(PDOException $e)
				{
					print 'Exception : '.$e->getMessage();
				}
			}			
		}
		if ($item_search_param == "route" || $item_search_param == "isup")
		{
			$link_list = $this->get_route_used($profile_name);
			$c = 0;
			for ($b = 0; $b < count($link_list); $b++)
			{
				//echo $link_list[$b]['name'] . "<br />";
				try
				{
					//open the database
					$db = new PDO($db_location);
		
					$result = $db->query($select);
				
					foreach($result as $row)
					{
						//$this->profile_array[$a] = $row;
						echo "a loop = $a , b loop = $b <br />";
						echo "Item = " . $profile_name . "<br />";
						echo "DB entry = " . $row[$item_search_param] . "<br />";
						echo "link_list entry = " . $link_list[$b]['name'] . "<br />";
						echo "<hr />";

						if ($profile_name == $row[$item_search_param] && $profile_name == $link_list[$b]['name'])
						{
							$first_step = "found";
							$routes_step1[$a] = $link_list[$b]['name'];
							//$result = "found";
							echo $first_step . "<br />";
						}
						$a++;
					}
					// close the database connection
					$db = NULL;
				}
				catch(PDOException $e)
				{
					print 'Exception : '.$e->getMessage();
				}	
			}	
			if ($first_step == "found")
			{
				//get all ISUP interfaces used in ccspans
				//$db_location = "sqlite:sqlite/cardinfo.db";
				$db_location = $this->db_location;
				$where_param = "";
				$a = 0;
		
				$select = "SELECT * FROM ss7_isup_profile;";
				
				try
				{
					//open the database
					$db = new PDO($db_location);
		
					$result = $db->query($select);
				
					foreach($result as $row)
					{
						$isup_profile_array[$a] = $row;
						//echo "card = " . $this->profile_array[$a]['profile_name'] . "<br />";
						$a++;
					}
					// close the database connection
					$db = NULL;
					}
				catch(PDOException $e)
				{
					print 'Exception : '.$e->getMessage();
				}
				
				//Pull data from used_isup table	
			
			}
		}			
		
		
		return $result;
	}
	
	function get_linksets_used($profile_name)
	{
		//$db_location = "sqlite:sqlite/cardinfo.db";
		$db_location = $this->db_location;
		$where_param = "";
		$a = 0;

		$select = "SELECT name FROM used_linkset WHERE name=\"" . $profile_name . "\";";
		
		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$profile_array[$a] = $row;
				//echo "card = " . $this->profile_array[$a]['profile_name'] . "<br />";
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}
		return $profile_array;
	}	
	
	function get_route_used($profile_name)
	{
		//$db_location = "sqlite:sqlite/cardinfo.db";
		$db_location = $this->db_location;
		$where_param = "";
		$a = 0;

		$select = "SELECT name FROM used_route WHERE name=\"" . $profile_name . "\";";
		
		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$profile_array[$a] = $row;
				//echo "card = " . $this->profile_array[$a]['profile_name'] . "<br />";
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}
		return $profile_array;
	}
	
	function get_isup_used($profile_name)
	{
		//$db_location = "sqlite:sqlite/cardinfo.db";
		$db_location = $this->db_location;
		$where_param = "";
		$a = 0;

		$select = "SELECT name FROM used_isup WHERE name=\"" . $profile_name . "\";";
		
		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$profile_array[$a] = $row;
				//echo "card = " . $this->profile_array[$a]['profile_name'] . "<br />";
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}
		return $profile_array;
	}	
	
	function get_relay_hosts()
	{
		$db_location = "sqlite:sqlite/relay_info.db";
		$where_param = "";
		$a = 0;

		$select = "SELECT * FROM relay_hosts;";
		//echo $select;
		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$profile_array[$a] = $row;
				//echo "card = " . $this->profile_array[$a]['profile_name'] . "<br />";
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}
		return $profile_array;
	}
	
	private function get_gen_data($table)
	{
		$db_location = $this->db_location;
		$where_param = "";
		$a = 0;

		$select = "SELECT * FROM $table;";
		//echo $select;
		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
				if (!empty($result)) {
				foreach($result as $row)
				{
					$profile_array[$a] = $row;
					//echo "card = " . $this->profile_array[$a]['profile_name'] . "<br />";
					$a++;
				}
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
			echo "SQL = $select <br />";
			echo "db = $db_location <br />";
			echo "table = $table<br />";
		}
		return $profile_array;
	}		
	
	/**
	*	Generates single freetdm.conf entry for SS7/M2UA/MG
	*	Returns a string of data to be placed in the file
	*	@return string
	*/
	function generate_single_freetdm_conf_entry() {
		if ($this->card_name == "A101" || $this->card_name == "A102" || $this->card_name == "A104" || $this->card_name == "A108" || $this->card_name == "A116" || $this->card_name == "B601" && $this->port_num == 1) {
			//echo "SS7 span = "  . $this->ss7_span . "<br />";
			$no_bchans=false;
					
			/*echo "<b>Chans:";		
			print_r ($this->ss7_m2ua_chans);
			echo "<br />Link:";
			print_r ($this->ss7_m2ua_link);
			echo "<br /></b>";*/
			$skip = false;
			if ($this->ss7_m2ua_link['voice_chans'] == "" && !$this->mg_link_exist ) 
				$skip = true;
			elseif ($this->ss7_m2ua_link['voice_chans'] == 'no')
				$no_bchans=true;
				
			if ($this->ss7_span == "yes")
			{	
				if (($this->ss7_m2ua_link['voice_chans'] != 'no' && !$skip) || ($this->ss7_ccspan_profile != "")) {
					$card_portion="
					
#" . $this->card_name . " " . $this->line_type . " SS7 Configuration
[span wanpipe wp" . $this->span_num . "]
trunk_type=" . $this->line_type . "
rxgain => " . $this->rx_gain . "
txgain => " . $this->tx_gain;
				if ($this->ss7_ccspan_group_num!="") 
					$card_portion.= "
group=>g" . $this->ss7_ccspan_group_num;
					
					if ($this->line_type == "T1")
						$last_chan = "24";
					elseif ($this->line_type == "E1")
						$last_chan = "31";
					
					if ($this->ss7_sig_channel == 1)
					{
						
							$card_portion.="
b-channel => " . $this->span_num . ":2-" . $last_chan . "\n";
					}
					elseif ($this->ss7_sig_channel == 2)
					{
						if ($this->line_type == "T1")
							$last_chan = "24";						
						elseif ($this->line_type == "E1")
							$last_chan = "31";
							
						$card_portion.="
b-channel => " . $this->span_num . ":1
b-channel => " . $this->span_num . ":3-" . $last_chan . "\n";	
					}
					elseif ($this->ss7_sig_channel == 23 && $this->line_type == "T1")
					{
						$card_portion.="
b-channel => " . $this->span_num . ":1-22
b-channel => " . $this->span_num . ":24\n";	
					}
					elseif ($this->ss7_sig_channel == 30 && $this->line_type == "E1")
					{
						$card_portion.="
b-channel => " . $this->span_num . ":1-29
b-channel => " . $this->span_num . ":31\n";	
					}
					elseif ($this->ss7_sig_channel == 24 || $this->ss7_sig_channel == 31) {
						$previous_chan = $last_chan -1;
						$card_portion.="
b-channel => " . $this->span_num . ":1-" . $previous_chan . "\n";						
					}
					elseif ($this->ss7_sig_channel == "") {
						$card_portion.="
b-channel => " . $this->span_num . ":1-" . $last_chan . "\n";						
					}
					else {
						//echo "I am here";
						$previous_chan = $this->ss7_sig_channel -1;
						$next_chan = $this->ss7_sig_channel + 1;
						
						//Make check how many sections of sig channels are in the channel map
						//echo "channel map = " . $this->ss7_ccspan_channel . "<br />";
						$chan_map = explode (',',$this->ss7_ccspan_channel);
						//echo count($chan_map);
						if (count($chan_map) == 2) {
							foreach ($chan_map as $chan) {
								$pos = strpos($chan,'s');
								if ($pos === false) {
									//echo " i am here";
									$card_portion.= "
b-channel => " . $this->span_num . ":" . $chan .  "\n";						
								}
							}
						}
						if (count($chan_map) > 2) {
							if ($this->line_type == "T1")
							{
								$last_chan = "24";
								$card_portion.="
b-channel => " . $this->span_num . ":1-" . $previous_chan . "
b-channel => " . $this->span_num . ":" . $next_chan . "-" . $last_chan . "\n";							
							}
							elseif ($this->line_type == "E1")
							{
								$last_chan = "31";
								$card_portion.="
b-channel => " . $this->span_num . ":1-" . $previous_chan . "
b-channel => " . $this->span_num . ":" . $next_chan . "-" . $last_chan . "\n";
							}
						}
					}
				}
			}
		}
		return $card_portion;
	}
	
}



?>
