<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

date_default_timezone_set('America/New_York');

//Includes the File which contains classes
include '../classes.php';
include '../database_classes.php';
include '../production-test/prod-test-class.php';
include '../production-test/wanpipe_prod.php';

/*declare(ticks = 1);

//Restores the configuration when the script is exited
pcntl_signal (SIGTERM, "restoreConfig");
pcntl_signal (SIGINT, "restoreConfig");
pcntl_signal (SIGKILL, "restoreConfig");*/


$input = fopen("php://stdin","r");

//Analyze the arguments passed to the script
if (in_array($argv[1], array('--help')) || $argv[1] == "")
{
	usage($argv[0]);
	exit(0);
}
elseif (in_array($argv[1], array('--TDM', '--tdm')))
{
	echo "Running Firmware Update on TDM Cards.\n";
	echo "Please do not interrupt the firmware update. If firmware update interrupted, TDM cards will become unusable.\n";
	test("TDM",$line,"");
}
elseif (in_array($argv[1], array('--media')))
{
	$media_card = $argv[2];
	echo "Running Media Tests for $media_card\n";
	echo "Please do not interrupt the firmware update. If firmware update interrupted, Media cards will become unusable.\n";
	test("media","",$media_card);
}
elseif (in_array($argv[1], array('--all')))
{
	$line = $argv[2];
	echo "Running Media Tests and TDM tests in " . strtoupper($line) . "\n";
	echo "Please do not interrupt the firmware update. If firmware update interrupted, ALL cards will become unusable.\n";
	test("all",$line,"all");
}
elseif (in_array($argv[1], array('--silent')))
{
	test("silent","E1","all");
}
else
{
	usage($argv[0]);
	exit(2);
}

fclose($input);

function test($test_type, $line_type, $media)
{
	//echo $test_type;
	
	//Class constructors
	$data = new database_class;
	$tokenization = new wanrouter_hwprobe;
	$prod = new prod_test;		
	
	if (strtoupper($test_type) == "SILENT" )
	{
		echo "NETBORDER SS7 - FIRMWARE UPDATE\n";
		echo "===============================\n";
		echo "\n";
		echo "This application will update all connected A Series cards and D Series Cards.\n";
		echo "The firmware update will stop all services on this system. THIS WILL INTERUPT ALL FUNCTIONALITY IF THE SYSTEM IS IN PRODUCTION\n";
		echo "\n";
	}
	
	//Detects the install path
	$prod->smg_path();

	//Gets A10X and media processing card information
	$prod->parse_results = $tokenization->get_information('');
	$prod->get_cards();
	$prod->find_mp_cards();
	$prod->calc_num_spans();
	
	//Remove old tarball
	$cmd = "rm -f " . $prod->main_smg_path . "/nginx/html/php/firmware/SangomaOutput.tgz";
	//echo $cmd . "\n";
	shell_exec($cmd);	
	
	if ($prod->card_error == "YES" || $prod->num_a101 == 0 && $prod->num_a102 == 0 && $prod->num_a104 == 0 && $prod->num_a108 == 0 && $prod->num_a116 != 0 && count($prod->mp_cards) == 0)
	{
		//No Cards Found
		echo "No Cards Found\n";
		echo "Please Insert a card into your system in order to run the hardware test\n";
		exit(2);
	}
	elseif ($prod->num_a101 != 0 || $prod->num_a102 != 0 || $prod->num_a104 != 0 || $prod->num_a108 != 0 || $prod->num_a116 != 0 || count($prod->mp_cards) != 0)
	{
		//Displays the information regarding cards only when run with the silent option
		if (strtoupper($test_type) == "SILENT")
		{
			//Displays Media Processing Cards
			if (isset($prod->mp_card))
			{
				echo "Media Processing Cards Present\n";
				echo "==============================\n";
			
				for ($a = 0; $a < count($prod->mp_cards); $a++)
				{
					echo $prod->mp_cards[$a] . "\n";
				}
				echo "\n";			
			}

			if (isset($prod->a101count) || isset($prod->a102count) || isset($prod->a104count) || isset($prod->a108count))
			{
				echo "Number of A10X Cards Present\n";
				echo "============================\n";
				echo "A101: " . $prod->num_a101 . "\n";
				echo "A102: " . $prod->num_a102 . "\n";
				echo "A104: " . $prod->num_a104 . "\n";
				echo "A108: " . $prod->num_a108 . "\n";
				echo "A116: " . $prod->num_a116 . "\n";
				
				echo "Total Number of spans = " . $prod->num_spans . "\n";
				echo "\n";
			}
		}
		
		if (strtoupper($test_type) == "SILENT")
		{
			//Checking Firmware Versions of Cards
			echo "Checking Firmware Versions on all Cards\n";
			
			if (isset($prod->a101count) || isset($prod->a102count) || isset($prod->a104count) || isset($prod->a108count))
			{
				for ($y = 1; $y <= $prod->num_a101; $y++)
				{
					//Run script to check highest firmware version and check it with what is on the card
					$cmd = $prod->main_smg_path . "/nginx/html/php/scripts/firmware.sh A101";
					//echo $cmd;
					exec ($cmd, $firm);
					
					echo $prod->a101[$y]->firmware . "\n";
					
					if ($firm[0] != $prod->a101[$y]->firmware)
					{
						//$outofdate = "yes";
						echo "TDM Device <b>A101</b> Current Firmware = <b><font color='red'>".  $prod->a101[$y]->firmware . " OUT OF DATE</font></b>\n";
					}
					else
					{
						echo "TDM Device <b>A101</b> Current Firmware = ".  $prod->a101[$y]->firmware . "\n";
					}
					
				}
				for ($y = 1; $y <= $prod->num_a102; $y++)
				{
					//Run script to check highest firmware version and check it with what is on the card
					$cmd = $prod->main_smg_path . "/nginx/html/php/scripts/firmware.sh A102";
					//echo $cmd;
					exec ($cmd, $firm);

					echo $prod->a102[$y]->firmware . "\n";
					
					if ($firm[0] != $prod->a102[$y]->firmware)
					{
						//$outofdate = "yes";
						echo "TDM Device <b>A102</b> Current Firmware = <b><font color='red'>".  $prod->a102[$y]->firmware . " OUT OF DATE</font></b>\n";
					}
					else
					{
						echo "TDM Device <b>A102</b> Current Firmware = ".  $prod->a102[$y]->firmware . "\n";
					}
				}
				for ($y = 1; $y <= $prod->num_a104; $y++)
				{
					//Run script to check highest firmware version and check it with what is on the card
					$cmd = $prod->main_smg_path . "/nginx/html/php/scripts/firmware.sh A104";
					//echo $cmd;
					exec ($cmd, $firm);

					echo $prod->a104[$y]->firmware . "\n";
					
					if ($firm[0] != $prod->a104[$y]->firmware)
					{
						//$outofdate = "yes";
						echo "TDM Device <b>A104</b> Current Firmware = <b><font color='red'>".  $prod->a104[$y]->firmware . " OUT OF DATE</font></b>\n";
					}
					else
					{
						echo "TDM Device <b>A104</b> Current Firmware = ".  $prod->a104[$y]->firmware . "\n";
					}
				}
				for ($y = 1; $y <= $prod->num_a108; $y++)
				{
					//Run script to check highest firmware version and check it with what is on the card
					$cmd = $prod->main_smg_path . "/nginx/html/php/scripts/firmware.sh A108";
					//echo $cmd;
					exec ($cmd, $firm);
					
					if ($firm[0] != $prod->a108[$y]->firmware)
					{
						//$outofdate = "yes";
						echo "TDM Device <b>A108</b> Current Firmware = <b><font color='red'>".  $prod->a108[$y]->firmware . " OUT OF DATE</font></b>\n";
					}
					else
					{
						echo "TDM Device <b>A108</b> Current Firmware = ".  $prod->a108[$y]->firmware . "\n";
					}
				}
				for ($z = 1; $z <= $prod->num_a116; $z++)
				{
					//Run script to check highest firmware version and check it with what is on the card
					$cmd = $prod->main_smg_path . "/nginx/html/php/scripts/firmware.sh A116";
					//echo $cmd;
					unset($firm);
					exec ($cmd, $firm);
					
					if ($firm[0] != $prod->a116[$y]->firmware)
					{
						$outofdate = "yes";
						echo "TDM Device <b>A116</b> Current Firmware = <b><font color='red'>".  $prod->a116[$y]->firmware . " OUT OF DATE</font></b>\n";
					}
					else
						echo "TDM Device <b>A116</b> Current Firmware = ".  $prod->a116[$y]->firmware . "\n";
				}				
			}
			//exit(2);
		}
		if (strtoupper($test_type) == "SILENT")
		{
			if (isset($prod->mp_card))
			{
				for ($a = 0; $a < count($prod->legacy_names); $a++)
				{
					$outofdate = $prod->find_vocallo_firmware($a);
					//echo $outofdate . "\n";
				}
			}
			//exit(2);
		}
		
		if (strtoupper($test_type) == "SILENT" || strtoupper($test_type) == "MEDIA" || strtoupper($test_type) == "ALL")
		{
			if (isset($prod->mp_card))
			{
				//Stop sngmp_server_ctrl
				$sngmp_stop_error = $prod->sngmp_server("stop");		
			
				if ($sngmp_stop_error == "yes")
				{
					//Error
					echo "Error stopping media processing service\n";
					echo "Please contact sangoma technical support at techdesk@sangoma.com for assistance\n";
					exit(2);
				}
			}
		}
		
		//Stops smg
		$prod->smg("stop");
		
		if (strtoupper($test_type) == "TDM" || strtoupper($test_type) == "SILENT" || strtoupper($test_type) == "ALL")
		{	
			if (isset($prod->a101count) || isset($prod->a102count) || isset($prod->a104count) || isset($prod->a108count) || isset($prod->a116count))
			{
				//Stops wanrouter
				$error = $prod->wanrouter("stop");
			}
			elseif ($error = "wanrouter error")
			{
				echo "There was an error starting the TDM Driver.\n";
				echo "Please contact Sangoma Technical Support at techdesk@sangoma.com for more help with the issue\n";
				exit(2);
			}
		}		
		
		//Update Firmware on TDM Cards
		if (strtoupper($test_type) == "SILENT" || strtoupper($test_type) == "TDM" || strtoupper($test_type) == "ALL")
		{
			if (isset($prod->a101count) || isset($prod->a102count) || isset($prod->a104count) || isset($prod->a108count) || isset($prod->a116count))
			{
				//Update Firmware on TDM Cards
				$cwd = getcwd();
				$dir = "/etc/wanpipe/util/wan_aftup/";
				chdir($dir);
				//exec("pwd",$output);
				//echo $output[0] . "\n";
				$command = "./update_aft_firm.sh auto";
				passthru($command, $tdm);
				
				$dir = $prod->main_smg_path . "/nginx/html/php/firmware/";
				chdir($dir);
			}
		}

		//Media Test
		if (strtoupper($test_type) == "SILENT" || strtoupper($test_type) == "MEDIA" || strtoupper($test_type) == "ALL")
		{		
			echo "Media Card Firmware Update may take up to 5 Minutes for each card. Please be patient.\n";			
			if (isset($prod->mp_card))
			{	
				if (strtoupper($media) == "ALL")
				{
					for ($a = 0; $a < count($prod->mp_cards); $a++)
					{
						echo "Updating: " . $prod->mp_cards[$a] . "\n";
						
						//Bring interfaces up
						$prod->interface_up($a);
						
						$command = "/usr/sbin/sngtc_tool -dev " . $prod->mp_cards[$a] . " -firmware -silent";
						passthru($command, $media_output);
					}			
					echo "\n\n";
				}
				else
				{
					//Check to see if Media Processing Card Exists
					if (!in_array($media,$prod->mp_cards))
					{
						echo "Media Processing device not found on system. Please specifiy the right device.\n";
						exit(2);
					}

					echo "Updating: " . $media . "\n";
						
					//Bring interfaces up
					$prod->interface_up($media);
						
					$command = "/usr/sbin/sngtc_tool -dev " . $prod->mp_cards[$a] . " -firmware -silent";
					passthru($command, $media_output);				
				}
			}
		}
	}

	//Generating Log files to tar up
	//echo "Creating archive file\n";
	//$prod->files_to_send();
	
	echo "Firmware Update Complete. Please restart the Gateway Services from the Control Panel\n";
}


function usage($argv)
{
?>
 Usage:
<?php echo $argv; ?> <option>

<option> can be any of the following below:
--help			Displays all arguments that can be passed
--all			Runs all Firmware Update with no user interaction

--TDM			Runs the TDM Firmware Update

--media ethX		Runs a Firmware Update for a Specific Media Processing Card
--media all		Runs a Firmware Update for all the Media Processing Cards

--silent		Runs Firmware Update for all Cards in the system

<?php
}
?>
