<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
	Jonathan Maurice <jmaurice@sangoma.com>
*/

date_default_timezone_set('America/New_York');

//Starts PHP Sessions
session_start();

$_SESSION['ping'] = "";
$_SESSION['ssh_status'] = "";

//Make sure the user is logged into the WebUI
Authenticate();

require_once('../classes.php');
require_once('../database_classes.php');
require_once('../bg_process_class.php');
require_once('../display_class.php');
require_once('firmware-setup-class.php');


define("ICON_LOADING", "./icon-loading.gif");

$testScriptPath = getcwd(). "/firmware_update.sh";
$testProcessName = "self-test";

$prodTestDynDivName = "SelfTestDiv";
$prodTestDispCommon = new Display_common();

$bgProcessTest = new BgProcess($testScriptPath, null, $testProcessName);

///////////////////////////////////////////////////////////////////////////////
//
// HEADER
//
///////////////////////////////////////////////////////////////////////////////
//Check to see which UI we are running in
if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
{
  unset($_SESSION['embedded']);
  
  //FusionPBX Integration
  require_once "../fusionpbx/includes/header.php";
}
elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
{
  //Includes required for ClearOS Integration
  include '../sqlite/database_creation.php';
  
  $display_common = new Display_common;
  
  $_SESSION['embedded'] = "true";
  
  //ClearOS Integration
  $prodTestDispCommon->session_vars("sqlite:../sqlite/cardinfo.db");
  $prodTestDispCommon->html_header();
  $prodTestDispCommon->html_title("Firmware Update", "../../style.css","");		
}
///////////////////////////////////////////////////////////////////////////////
//
// Main
//
///////////////////////////////////////////////////////////////////////////////

//Check if the test script was aborted
if(isset($_POST['Abort-Self-Test']) && $prodTestDispCommon->IsRenderingNonDynamicDiv()) {

  //Test must be aborted.
  $testSetup = new TestSetup();

  DisplayHeader();
  DisplayCardsTable($testSetup);
  
  //Abort test (wait 10 sec for script to exit)
  if ($bgProcessTest->abort(10)){
    $prodTestDispCommon->WarningBox("Firmware Update was aborted!");
  }
  else {
    $prodTestDispCommon->WarningBox("Failed to stop the Firmware Update!");
    DisplayTestOutput($bgProcessTest);
  }
}
//Check if request is a refresh.
elseif ($prodTestDispCommon->IsRenderingNonDynamicDiv() && !isset($_POST['Start-Self-Test']) ) {
  //This is a normal request.
  DisplayHeader();
  
  $testSetup = new TestSetup();

  //Make sure there is any cards
  if (!$testSetup->hasCards()) {
    $prodTestDispCommon->WarningBox("Please Insert a TDM card or Media Processing Card into your system in order to run the Firmware Update");
  }
  else {

    DisplayCardsTable($testSetup);

    //Check if this is already running...
    if($bgProcessTest->isRunning()){
      DisplayTestOutput($bgProcessTest);
    }
    else {
      //Test is not running
      DisplayTestForm($testSetup);
    }
  }

  DisplayFooter();
}
elseif($prodTestDispCommon->IsDynamicDivRefreshRequest($prodTestDynDivName) && !isset($_POST['Start-Self-Test'])) {
  //This is a refresh.
  DisplayTestOutput($bgProcessTest);

}
elseif(isset($_POST['Start-Self-Test'])) {
  //This is a start self test request
  $testSetup = new TestSetup();

  //Make sure that any test type was checked in the form
  if ( isset($_POST['Run-Tdm-Test']) || isset($_POST['Run-Media-Test']) ){
    //Start self test
    DisplayHeader();
    DisplayCardsTable($testSetup);
    $prodTestDispCommon->DynamicDivEnable();
    //Start dynamic div with refresh of 2 second.
    $prodTestDispCommon->DynamicDivBegin($prodTestDynDivName, "", 2000);
    StartSelfTest($testSetup, $bgProcessTest, $_POST);
    DisplayTestOutput($bgProcessTest);
    $prodTestDispCommon->DynamicDivEnd($prodTestDynDivName);
  }
  else {
    //No test was selected in the form
    $prodTestDispCommon->WarningBox("Please select the type of the test you want to run!");
    DisplayHeader();
    DisplayCardsTable($testSetup);
    DisplayTestForm($testSetup);
  }

  DisplayFooter();
}
///////////////////////////////////////////////////////////////////////////////
//
// FOOTER
//
///////////////////////////////////////////////////////////////////////////////
if ( $prodTestDispCommon->IsRenderingNonDynamicDiv( ) )
{  
  if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
  {
    unset($_SESSION['embedded']);
    //FusionPBX Integration
    require_once "../fusionpbx/includes/footer.php";
  }
  elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
  {
    //ClearOS Integration
    $prodTestDispCommon= new Display_common;
    $prodTestDispCommon->html_footer();	
  }
}

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

function Authenticate ()
{
  if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1"){
    return true;
  }
  else {
    header( 'Location:index.php' ) ;
    exit();
  }
}

function StartSelfTest(&$in_testSetup, &$in_bgProcess, $in_post)
{
  //Need to use $in_bgProcess->setArgs() to add arguments base on the POST.
  //POST will be similar to this:
  //Array ( [Run-Tdm-Test] => Tdm [Tdm-Line-Type] => T1 [Run-Media-Test] => 
  //Media [Start-Self-Test] => Start Self Test ) 

  $runTdm = isset($in_post['Run-Tdm-Test']);
  $runMedia = isset($in_post['Run-Media-Test']);

  $args = "";
  $tdmLineType = "";
  if ($runTdm && $runMedia){
    $tdmLineType = $in_post['Tdm-Line-Type'];
    $args = "--all $tdmLineType";
  }
  elseif ($runTdm){
    $tdmLineType = $in_post['Tdm-Line-Type'];
    $args = "--TDM $tdmLineType";
  }
  elseif ($runMedia){
    $args = "--media all";
  }

  //Set arguments
  $in_bgProcess->setArgs($args);

  //Start self test
  $in_bgProcess->run();
}

function DisplayTestOutput(&$in_bgProcess)
{
  $running = $in_bgProcess->isRunning();
  $logContent = $in_bgProcess->getLog();
  $output = "";

  foreach ($logContent as $line) {
    $output = $output . "$line<br/>\n";
  }

  if($running){
    $output = $output . "<img src='" .ICON_LOADING. "' align='left'/>&nbsp;"
              . "Firmware Update is running... please wait<br/>\n";
  }
  else {
    $output = $output . "Done<br/>\n";
  }

  echo "<br/>\n";
  echo "<table class='mytable' border='1' width='100%'>\n";
  echo "	<tr>\n";
  //Show abort button
  echo "     <th class='widget-content-header ui-state-active ui-corner-top' align='left'>";
  echo "     <table width='100%'>\n";
  echo "       <tr>\n";
  echo "	     <td align='left'>\n";
  echo "	 	     <b>Update Output</b>\n";
  echo "       </td>\n";
  echo "	     <td align='right' width='33%'>\n";
  if ($running){
    /*//echo "       <form name='Abort-self-test' method='post'>\n"; 
    //echo "         <input align='center' type='submit' name='Abort-Self-Test' value='Abort Self Test' " . $_SESSION['button_class'] . "/>\n";
    //echo "       </form>\n";*/
  }
  else {
    echo "       <form name='Download-test-results' method='get' action='firm-landing.php'>\n"; 
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
  	{
    	echo "         <input align='center' type='submit' name='refresh-page' value='Refresh Page' " . $_SESSION['button_class'] . "/>\n";
	}
	elseif  (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
  	{
		echo "       <form name='refresh-page' method='get' action='/admin/ss7_ss7_firmware_update.php' target=\"_parent\">\n"; 
	}	
    echo "       </form>\n";
  }
  echo "       </td>\n";
  echo "     </table>\n";
  echo "     </th>\n";
  echo "	</tr>\n";
  echo "<tr><td>\n";
  //Show output log
  echo $output;
  echo "</td></tr>\n";
  echo "<th align='left' class='widget-content-header ui-state-active ui-corner-bottom'>\n";
  echo "</th>\n";
  echo "</table>\n";
  echo "<br/>\n";

}

function DisplayCardsTable(&$in_testSetup)
{
	require_once('../classes.php');
	require_once('../production-test/prod-test-class.php');
	$prod = new prod_test;
	$tokenization = new wanrouter_hwprobe;

	$prod->smg_path();
	$prod->parse_results = $tokenization->get_information('');
	$prod->get_cards();
	
  //Process digitals cards
  if ($in_testSetup->hasDigitalCards()){
    $digCards = $in_testSetup->getDigitalCards();

    echo "<table class='mytable' border='1' width='450px'>\n";
    echo "<th colspan='5' class='widget-content-header ui-state-active ui-corner-top' align='left'>TDM Cards\n";
    echo "</th>\n";
    echo "<tr align='center'>\n
           	<td class='mytableheader ui-state-active'>Card Name</td>\n
            <td class='mytableheader ui-state-active'>Card Type</td>\n
            <td class='mytableheader ui-state-active'>Firmware</td>\n
          </tr>\n";


	//Run card check and display it on the page
	for ($y = 1; $y <= $prod->num_a101; $y++)
	{
		echo "<tr align='center'>\n";
      	echo "<td>A101</td>\n";
      	echo "<td>1 Port T1/E1 Card</td>\n";
		//Run script to check highest firmware version and check it with what is on the card
		$cmd = $prod->main_smg_path . "/nginx/html/php/scripts/firmware.sh A101";
		//echo $cmd;
		unset($firm);
		exec ($cmd, $firm);
		
		//echo $prod->a101[$y]->firmware . "\n";
		
		if ($firm[0] != $prod->a101[$y]->firmware)
		{
			//$outofdate = "yes";
			echo "<td><b><font color='red'>".  $prod->a101[$y]->firmware . "</font><img src='../fusionpbx/AlertSign.png' width='12' height='12' title='Firmware outdated' style='vertical-align:text-bottom;float:none'/></b></td>";
		}
		else
		{
			echo "<td>".  $prod->a101[$y]->firmware . "</td>";
		}
		//echo "<td>$firmware</td>\n";
      	echo "</tr>\n";

	}
	for ($y = 1; $y <= $prod->num_a102; $y++)
	{
		echo "<tr align='center'>\n";
      	echo "<td>A102</td>\n";
      	echo "<td>2 Port T1/E1 Card</td>\n";
		//Run script to check highest firmware version and check it with what is on the card
		$cmd = $prod->main_smg_path . "/nginx/html/php/scripts/firmware.sh A102";
		//echo $cmd;
		unset($firm);
		exec ($cmd, $firm);

		//echo $prod->a102[$y]->firmware . "\n";
		
		if ($firm[0] != $prod->a102[$y]->firmware)
		{
			//$outofdate = "yes";
			echo "<b><font color='red'>".  $prod->a102[$y]->firmware . "</font><img src='../fusionpbx/AlertSign.png' width='12' height='12' title='Firmware outdated' style='vertical-align:text-bottom;float:none'/></b></td>";
		}
		else
		{
			echo "<td>".  $prod->a102[$y]->firmware . "</td>";
		}
	}
	for ($y = 1; $y <= $prod->num_a104; $y++)
	{
		echo "<tr align='center'>\n";
      	echo "<td>A104</td>\n";
      	echo "<td>4 Port T1/E1 Card</td>\n";
		//Run script to check highest firmware version and check it with what is on the card
		$cmd = $prod->main_smg_path . "/nginx/html/php/scripts/firmware.sh A104";
		//echo $cmd;
		unset($firm);
		exec ($cmd, $firm);

		//echo $prod->a104[$y]->firmware . "\n";
		//echo $firm[0] . "<br />";
		if ($firm[0] != $prod->a104[$y]->firmware)
		{
			//$outofdate = "yes";
			echo "<td><b><font color='red'>".  $prod->a104[$y]->firmware . "</font><img src='../fusionpbx/AlertSign.png' width='12' height='12' title='Firmware outdated' style='vertical-align:text-bottom;float:none'/></b></td>\n";
		}
		else
		{
			echo "<td>".  $prod->a104[$y]->firmware . "</td>";
		}
		echo "</tr>\n";
	}
	for ($y = 1; $y <= $prod->num_a108; $y++)
	{
		echo "<tr align='center'>\n";
      	echo "<td>A108</td>\n";
      	echo "<td>8 Port T1/E1 Card</td>\n";
		//Run script to check highest firmware version and check it with what is on the card
		$cmd = $prod->main_smg_path . "/nginx/html/php/scripts/firmware.sh A108";
		//echo $cmd;
		unset($firm);
		exec ($cmd, $firm);
		//echo $firm[0] . "<br />";
		if ($firm[0] != $prod->a108[$y]->firmware)
		{
			//$outofdate = "yes";
			echo "<td><b><font color='red'>".  $prod->a108[$y]->firmware . "</font><img src='../fusionpbx/AlertSign.png' width='12' height='12' title='Firmware outdated' style='vertical-align:text-bottom;float:none'/></b></td>";
		}
		else
		{
			echo "<td>".  $prod->a108[$y]->firmware . "</td>";
		}
		echo "</tr>\n";
	}
	for ($y = 1; $y <= $prod->num_a116; $y++)
	{
		echo "<tr align='center'>\n";
      	echo "<td>A116</td>\n";
      	echo "<td>16 Port T1/E1 Card</td>\n";
		//Run script to check highest firmware version and check it with what is on the card
		$cmd = $prod->main_smg_path . "/nginx/html/php/scripts/firmware.sh A116";
		//echo $cmd;
		unset($firm);
		exec ($cmd, $firm);
		//echo $firm[0] . "<br />";
		if ($firm[0] != $prod->a116[$y]->firmware)
		{
			//$outofdate = "yes";
			echo "<td><b><font color='red'>".  $prod->a116[$y]->firmware . "</font><img src='../fusionpbx/AlertSign.png' width='12' height='12' title='Firmware outdated' style='vertical-align:text-bottom;float:none'/></b></td>";
		}
		else
		{
			echo "<td>".  $prod->a116[$y]->firmware . "</td>";
		}
		echo "</tr>\n";
	}
		
    $digCardSpecs = new DigitalCardSpecs();
    /*foreach ($digCards as $cardName => $numCard) {
      $cardType = $digCardSpecs->getCardTypeStr($cardName);
      $numSpan = $digCardSpecs->getNumSpan($cardName);
      echo "<tr align='center'>\n";
      echo "<td>$cardName</td>\n";
      echo "<td>$cardType</td>\n";
	  echo "<td>$firmware</td>\n";
      echo "</tr>\n";
    }*/

    echo "<th align='left' class='widget-content-header ui-state-active ui-corner-bottom' colspan='5'>\n";
    echo "</th>\n";
    echo "</table>\n";
    echo "<br/>\n";
	
  }

  //Process media cards
  if ($in_testSetup->hasMediaCards()){
    $mediaCards = $in_testSetup->getMediaCards();

    echo "<table class='mytable' border='1' width='450px'>\n";
    echo "<th colspan='3' class='widget-content-header ui-state-active ui-corner-top' align='left'>Media Cards\n";
    echo "</th>\n";
    echo "<tr align='center'>\n
           	<td class='mytableheader ui-state-active'>Interface</td>\n
           	<td class='mytableheader ui-state-active'>MAC Address</td>\n
			<td class='mytableheader ui-state-active'>Firmware</td>\n
          </tr>\n";

    foreach ($mediaCards as $ethName => $macAddr) {
		//echo $ethName . "<br />";
      echo "<tr align='center'>\n";
      echo "<td valign='top'>$ethName</td>\n";
      echo "<td valign='top'>$macAddr</td>\n";
	  echo "<td>\n";
	  //Get vocallo firmware version
	  $firmware = new firmware_check;
	  $firmware_value = $firmware->vocallo_firmware($ethName,$data);
	  for ($a = 0; $a < count($firmware_value); $a++)
	  {
	  if (!preg_match("/\\b" . $_SESSION['vocallo_firmware'] . "\\b/",$firmware_value[$a]))
	  {
		  $firmware_string = "<font color='red'><b>" . $firmware_value[$a] . "</b><img src='../fusionpbx/AlertSign.png' width='12' height='12' title='Firmware outdated' style='vertical-align:text-bottom;float:none'/></font>";
	  }
	  else
	  {
		  $firmware_string = $firmware_value[$a];
	  }
	  
	  echo "$firmware_string<br />\n";
	  }
	  echo "</td>\n";
      echo "</tr>\n";
    }

    echo "<th align='left' class='widget-content-header ui-state-active ui-corner-bottom' colspan='3'>\n";
    echo "</th>\n";
    echo "</table>\n";
    echo "<br/>\n";
  }

}

function DisplayTestForm(&$in_testSetup)
{
  $display_common = new Display_common;

  if( $display_common->IsGatewayRunning() ) {
    //$display_common->WarningBox("The Gateway is currently started. Please stop the gateway in order to proceed with the firmware update.");
    $notif = new NotificationBox( 'Error', NotificationBox::Error );
	$notif->add("Gateway", "The Gateway is currently started. Please stop the gateway in order to proceed with the firmware update");
	echo $notif->getHtml();		
	unset($notif);
	
	return false;
  }
  

  echo "<br/>\n";
  echo "<table class='mytable' border='1' width='270px'>\n";
  echo "<th colspan='2' class='widget-content-header ui-state-active ui-corner-top' align='left'>Firmware Update Settings\n";
  echo "</th>\n";
  echo "<tr align='center'>\n
          <td class='mytableheader ui-state-active'>Type</td>\n
          <td class='mytableheader ui-state-active'>Run</td>\n
        </tr>\n";
  //echo "<td class='mytableheader ui-state-active'>Options</td>\n";
  echo "<form name='Run-self-test' method='post'>\n"; 
  //If there is digital cards show related input
  if ($in_testSetup->hasDigitalCards()){
    echo "  <tr align='center'>\n";
    echo "    <td>TDM</td>\n";
    echo "    <td><input align='center' type='checkbox' checked='checked' name='Run-Tdm-Test' value='Tdm'/></td>\n";
    /*echo "    <td>\n
                <select name='Tdm-Line-Type'>\n
                  <option value='T1' selected='selected'>T1</option>\n
                  <option value='E1'>E1</option>\n
              </td>\n";*/
    echo "  </tr>\n";
  }
  //If there is media cards show related input
  if ($in_testSetup->hasMediaCards()){
    echo "  <tr align='center'>\n";
    echo "    <td>Media</td>\n";
    echo "    <td><input align='center' type='checkbox' checked='checked' name='Run-Media-Test' value='Media'/></td>\n";
    //echo "    <td></td>\n";
    echo "  </tr>\n";
  }
  //Close the table
  echo "<th align='left' class='widget-content-header ui-state-active ui-corner-bottom' colspan='2'>\n";
  echo "</th>\n";
  echo "</table>\n";
  echo "<br/>\n";
  echo "<br/>\n";
  echo '<font color="RED"><b>NOTE: FIRMWARE UPDATE CAN TAKE UP TO 5 MINUTES TO COMPLETE</b></font><br />';
  echo "<br/>\n";
  //Submit button
  echo "<input align='center' type='submit' name='Start-Self-Test' value='Run Firmware Update' " . $_SESSION['button_class'] . "/>\n";
  echo "</form>\n";

}

function DisplayHeader()
{
  // !+!wadam use old method otherwise binary version does not work
  return;
  //Check to see which UI we are running in
  if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
  {
    unset($_SESSION['embedded']);
    
    //FusionPBX Integration
    require_once "../fusionpbx/includes/header.php";
  }
  elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
  {
    //Includes required for ClearOS Integration
    include '../sqlite/database_creation.php';
    
    $display_common = new Display_common;
    
    $_SESSION['embedded'] = "true";
    
    //ClearOS Integration
    $display_common->session_vars("sqlite:../sqlite/cardinfo.db");
    $display_common->html_header();
    $display_common->html_title("Firmware Update", "../../style.css","");		
  }
}

function DisplayFooter()
{
  // !+!wadam use old method otherwise binary version does not work
  return;
  if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
  {
    unset($_SESSION['embedded']);
    //FusionPBX Integration
    require_once "../fusionpbx/includes/footer.php";
  }
  elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
  {
    //ClearOS Integration
    $display_common = new Display_common;
    $display_common->html_footer();	
  }
}

?>
