<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
   NSG WebGUI

   Software distributed under the License is distributed on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
   for the specific language governing rights and limitations under the
   License.

   Licence information can be found within the file LICENCE.php

   The Original Code is SMG WebGUI

   The Initial Developer of the Original Code is
   Shaunt Libarian <shaunt@sangoma.com>

   Contributor(s):
   Shaunt Libarian <shaunt@sangoma.com>
 */

//Contains all the display related code
define("ICON_WARNING", "/fusionpbx/sangoma/resources/icon-warning.png");
define("ICON_INFO", "/fusionpbx/sangoma/resources/icon-info.png");
define("ICON_ERROR", "/fusionpbx/sangoma/resources/icon-stop.svg");
define("ICON_LOADING", "/fusionpbx/sangoma/resources/icon-loading.gif");
define ("ICON_CHECKMARK","/fusionpbx/sangoma/resources/icon-checkmark.jpg");
// Color defines
define( "COLOR_OK" ,        "#8BB381"); // Kind of Dark Sea Green
define( "COLOR_WARNING", "#E56717"); // Kind of of Dark Orange
define( "COLOR_ERROR" ,     "#E42217"); // Kind of Firebrick
define( "COLOR_CONNECT",    "CCCCFF" ); //Connecting background
// Colors for rows
define( "COLOR_ROW_ODD", "#EFF5FA"); // Pale blue 
define( "COLOR_ROW_EVEN", "#FFFFFF" ); // White 

session_start();

/*
 * NotificationBox class
 */
class NotificationBox
{
    const Warning = 0;
    const Info = 1;
    const Error = 2;
    const Loading = 3;
    const Checkmark = 4;
    private $_notification_type = self::Warning;
    private $_icon;
    private $_notifications = array();
    private $_notification_pane_name; 


    function __construct($notification_pane_name = null, $notification_type = self::Warning)
    {
        $this->_notification_type = $notification_type;
        $this->_notification_pane_name = "notification_pane". $notification_pane_name;
        switch($this->_notification_type)
        {
            case self::Warning:
                $this->_icon = ICON_WARNING;
                break;
            case self::Info:
                $this->_icon = ICON_INFO;
                break;
            case self::Error:
                $this->_icon = ICON_ERROR;
                break;
            case self::Loading:
                $this->_icon = ICON_LOADING;
                break;
            case self::Checkmark:
                $this->_icon = ICON_CHECKMARK;
                break;
        }
        /*
           ?>
           <script type='text/javascript'>
           function toggle_<?php echo $this->_notification_pane_name; ?>() {
           var pane = document.getElementById('<?php echo $this->_notification_pane_name; ?>');
           if (pane.style.display == 'none')
           pane.style.display = "block";
           else
           pane.style.display = "none";
           ResizeFrame();
           }
           </script>
           <?php*/
    }

    function add( $category, $description, $replace = false )
    {
        if ($replace)
            unset($this->_notifications[$category]);

        $this->_notifications[$category][] = $description;
    }
    function getCount()
    {
        return count($this->_notifications);
    }
    // In order to be understand by javascript, HTML code need to be cleaned up
    // add escape sequence on ' and "
    // remove \n
    function getHtmlForJavaScript()
    {
        $js_code =  str_replace("'", "\\'", $this->getHtml());
        $js_code =  str_replace("\"","\\\"", $js_code);
        $js_code =  str_replace("\n","", $js_code);
        return $js_code; 
    }
    function getBodyHtml()
    {
        $html = "";
        if ($this->getCount())
        {
            $html .= "  <table class='mytable ui-state-error;' border='0' width='100%'>\n";
            foreach($this->_notifications as $category => $cat_notif)
            {
                $html .= "    <tr>\n";
                $html .= "      <td>\n";
                $html .= "      <b>\n";
                $html .= $category;
                $html .= "      </b>\n";
                $html .= "      <td>\n";
                $html .= "      <ul>\n";
                foreach($cat_notif as $notif)
                {
                    $html .= "     <li>\n";
                    $html .= $notif;
                    $html .= "     </li>\n";

                }
                $html .= "      </ul>\n";
                $html .= "      </td>\n";
                $html .= "      </td>\n";
                $html .= "    </tr>\n";
            }
            $html .= "  </table>\n";
        }
        //echo $html;
        return $html;
    }
    function getHtml()
    {
        $html = "";
        $html .= "<table class='mytable ui-state-error;' border='0' width='700px' style='display:";
        if ($this->getCount())
            $html .= "block";
        else
            $html .= "none";
        $html .= ";'>";
        $html .= " <tr>\n"; 
        $html .= "        <td width='35'>\n";
        $html .= "        <img src='".$this->_icon."' height='30px' width='30px'/>\n";
        $html .= "        </td>\n";
        $html .= "        <td>\n";
        $html .= "        </td>\n";
        $html .= "        <td width='99%'>\n";
        // Create hidden notification list
        // Body container
        $html .= "  <div  id='". $this->_notification_pane_name."' style='display:block;'>\n";
        $html .= $this->getBodyHtml();
        $html . "     </td>\n";
        $html .= " </tr>\n"; 
        // End table
        $html .= "</table>\n";
        $html .= "</div>\n";
        return $html;
    }
    function display()
    {
        echo $this->getHtml();
    }
};
//Contains Common display functions
class Display_common
{

    /**
     * Determines whether the gateway is running in NVG mode of NSG mode
     * @return $product
     */
    public function determine_gateway_type() {

        $xml = $this->parseProdDefXML('/usr/local/sng/conf/prod-def.xml');
        if( null === $xml){
            // Invalid of binary install
            // fallback to NSG
            return "NSG";
        }

        if( !$this->getProductValue($xml, "", "license", $out_licenseFilePath) ) {
            //error
            return false;
        }           

        $licenseFile = fopen($out_licenseFilePath, "r");

        if( $licenseFile == "" ) {
            //notificatio
            fclose($licenseFile);
            return;
        }

        $licenseArray = array();            

        while( !feof($licenseFile) ) {
            $line = fgets($licenseFile);
            array_push($licenseArray, explode( "=", $line));
        }

        fclose($licenseFile);

        if (!empty($licenseArray)) {
            foreach ($licenseArray as $file_content) {
                if (trim(strtolower($file_content[0])) == "brand") {
                    if (trim(strtolower($file_content[1])) == "netborder voip gateway") {
                        $product = "NVG";
                        break;
                    }
                    elseif (trim(strtolower($file_content[1])) == "netborder ss7 gateway") {
                        $product = "NSG";
                        break;
                    }
                    else {
                        $product = "NSG";
                        break;
                    }
                }
            }
        }

        return $product;
    }


    // Returns the xml object loaded from the file given in parameter
    public function parseProdDefXML($in_licenseConfFilePath) {
        $dom = new DOMDocument();
        @$dom->load($in_licenseConfFilePath);
        @$dom->xinclude();

        @$xml = simplexml_import_dom($dom);

        if( $xml == "" ) {
            return null;
        }

        return $xml;
    }

    // Scans the SNG prod-def xml object to locate a specific item in a product
    //
    // parameters:
    // in_xml: the xml object to be scanned
    // in_productName: the name of the product
    // in_key: the xml tag we are looking for
    // out_value: the value of the xml tag
    //
    // returns true if product name/key were found; false if not
    public function getProductValue($in_xml, $in_productName, $in_key, &$out_value)
    {
        if( 'product' == $in_xml->getName() ) {
            $out_value = $in_xml->$in_key;
            return true;
        } else {
            foreach( $in_xml->children() as $child ) {
                if( $child['name'] == $in_productName ) {
                    $out_value = $child->$in_key;
                    return true;
                }
            }
        }
        return false;
    }       

    //Function that will set the parameters required for SMG
    function session_vars($db_location)
    {   
        $product = $this->determine_gateway_type();
        //Determines the type of gateway being used
        $_SESSION['nbess7']="yes";
        $_SESSION['msbg'] = "";

        $cmd = "/usr/sbin/sngtc_tool -firmware_version | grep 'Vocallo' | cut -d\":\" -f2 | cut -d\" \" -f3";
        exec ($cmd,$output); 

        //$_SESSION['vocallo_firmware'] = "01.04.08-B7-PR";
        $_SESSION['vocallo_firmware'] = $output[0];

        //Set the class for the buttons
        $_SESSION['button_class'] = "class=\"ui-state-default ui-corner-all\"";
        $_SESSION['tc_button_class'] = "class=\"ui-state-default ui-corner-all\"";
        $_SESSION['table_class'] = "class=\"mytable\"";
        $_SESSION['disabled_button_class'] = "class=\"ui-state-default ui-corner-all\" style=\"color:#C0C0C0\" disabled='disabled'";

        //Sets the variables for the application and the start scripts
        if ($product == "NVG") {
            $_SESSION['shortname'] = "NVG";
            $_SESSION['name'] = "Netborder VoIP Media Gateway";
            $_SESSION['webui_script'] = "nsg-webgui";
            $_SESSION['gateway_script'] = "nsg";
            $_SESSION['cli'] = "nsg_cli";
        }
        else {
            $_SESSION['shortname'] = "NSG";
            $_SESSION['name'] = "Netborder SS7 to VoIP Media Gateway";
            $_SESSION['webui_script'] = "nsg-webgui";
            $_SESSION['gateway_script'] = "nsg";
            $_SESSION['cli'] = "nsg_cli";
        }
        $_SESSION['media_script'] = "sngtc_server_ctrl";
        $_SESSION['media_noctrl'] = "sngtc_server";

        //Use ths session variable for Asterisk
        //$_SESSION['dahdi'] = "True";

        //Turn on both the freetdm and freeswitch sessions for freeswitch use
        //$_SESSION['freeswitch'] = "True";

        //Turn on the FreeTDM session for Sangoma Media Gateway
        $_SESSION['freetdm'] = "True";

        $output = shell_exec ("pwd");
        $_SESSION['path'] = $output;

        if ($_SERVER['PHP_SELF'] == "/fusionpbx/mod/exec/v_exec.php" || $_SERVER['PHP_SELF'] == "/fusionpbx/sangoma/status.php" || $_SERVER['PHP_SELF'] == "/fusionpbx/sangoma/Howtos/help.php" || $_SERVER['PHP_SELF'] == "/fusionpbx/sangoma/Howtos/dialplans.php" || $_SERVER['PHP_SELF'] == "/fusionpbx/mod/script_edit/index.php"|| $_SERVER['PHP_SELF'] == "/fusionpbx/mod/script_edit/fileoptionslist.php"|| $_SERVER['PHP_SELF'] == "/fusionpbx/mod/script_edit/filelist.php" || $_SERVER['PHP_SELF'] == "/fusionpbx/core/status/v_status.php")
        {
            require_once 'sqlite/database_creation.php';
        }

        //Create Database files
        $creation = new create_database;

        unset($creation->db_location);
        $creation->db_location = $db_location;

        //Checks for the database and creates it if needed
        $creation->database_creation();             

        //Tokenize the path and strip eveything up to nginx
        //Counter for tokens to place into an array
        $total_token = 0;

        $tok = strtok($output, "/");
        $count = 0;

        while ($tok !== false) {
            $token[$count] = $tok;

            //Stores the tokens in an array to be parsed
            $token_values[$total_token] = $token[$count];           
            $tok = strtok("/");
            $count++;
            $total_token++;
        }   

        $a = $total_token;

        do
        {
            $a--;
        } 
        while($token_values[$a] != "nginx");

        for ($z = 0; $z < $a; $z++)
        {
            $smg_temp_path .= "/" . $token_values[$z];
        }
        $_SESSION['smg_location'] = $smg_temp_path;

        $smg_path = $smg_temp_path . "/conf";

        //Sets the path to the SMG Configuration Folder
        $_SESSION['smg_path'] = $smg_path;
        $_SESSION['smg_root_path'] = $smg_temp_path;

        //echo $_SESSION['smg_path'] . "<br />";

        //Detects the browser
        $useragent = $_SERVER['HTTP_USER_AGENT'];               
        if (preg_match('|MSIE ([0-9].[0-9]{1,2})|',$useragent,$matched)) {
            $browser_version=$matched[1];
            $browser = 'IE';
        } elseif (preg_match( '|Opera ([0-9].[0-9]{1,2})|',$useragent,$matched)) {
            $browser_version=$matched[1];
            $browser = 'Opera';
        } elseif(preg_match('|Firefox/([0-9\.]+)|',$useragent,$matched)) {
            $browser_version=$matched[1];
            $browser = 'Firefox';
        } elseif(preg_match('|Safari/([0-9\.]+)|',$useragent,$matched)) {
            $browser_version=$matched[1];
            $browser = 'Safari';
        } else {
            // browser not recognized!
            $browser_version = 0;
            $browser= 'other';
        }

        //print "browser: $browser $browser_version";       

        $_SESSION['browser'] = $browser;        

        if ($_SESSION['pidof'] != "")
        {
            //require_once $_SESSION['smg_root_path'] . '/nginx/html/php/identify/idenfity-stop.php';
            if ($_SERVER['PHP_SELF'] != "/fusionpbx/sangoma/identify/identify_ui.php")
            {
                //echo "i am here";
                $cwd = getcwd();
                chdir($_SESSION['smg_root_path'] . '/nginx/html/php/identify');

                require_once 'identify-stop.php';

                chdir($cwd);
            }
        }
    }

    //HTML Header
    function html_header()
    {
        if ( $this->IsRenderingNonDynamicDiv( ) ) {
            ?>
                <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
                <html xmlns="http://www.w3.org/1999/xhtml">
                <head>
                <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
                <?php
                //echo "hello";
        }
    }

    //HTML Title
    function html_title($title, $css_location, $javascript=NULL)
    { 
        if ( $this->IsRenderingNonDynamicDiv( ) ) 
        {
            ?>
                <title><?php echo $title; ?></title>
                <link rel="stylesheet" type="text/css" href="<?php echo "$css_location"; ?>" />
                <script src="/fusionpbx/sangoma/jquery-ui/jquery-1.8.1.js" ></script>

                <?php
                if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
                {
                    //$this->identify_alert();
                    $this->iframe_resize();   
                    echo "</head>\n";
                    echo "<body>";
                }
        }
    }

    //Binary Custom JQuery
    function binary_jquery() {
        if ($_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/mg/create_megaco_profile.php') {
            $return_jquery =  "
                <!-- Run custom JQUERY Code -->
                <script>
                $('#ip_addr').change(function() {
                        $('#rtp_ip').val($('#ip_addr').val());
                        });
            $('#mid').change(function() {
                    if ($(this).val() == 'DOMAIN')
                    $('#domain').removeAttr(\"disabled\");
                    else
                    $('#domain').attr(\"disabled\", \"disabled\");
                    });
            $(document).ready(function() {
                    $('#rtp_ip').val($('#ip_addr').val());
                    if ($(this).val() == 'DOMAIN')
                    $('#domain').removeAttr(\"disabled\");
                    else
                    $('#domain').attr(\"disabled\", \"disabled\");
                    });
            </script>
                <?php
                ";
        }
        elseif ($_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/relay/relay_questionnaire.php') {
            $return_jquery =  "
                <!-- Run custom JQUERY Code -->
                <script>
                $('input:radio').change(function() {
                        if ($(this).is(':checked')) {
                        $('#notification').show();
                        }
                        });
            </script>
                ";
        }
        elseif ($_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/sng_config_manager.php') {
            $return_jquery =  '
                <script>
                $(document).ready(function() {
                        $("#notif_div").hide();
                        });
            </script>
                ';
        }
        elseif($_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/SS7/sigtran/m2ua_clusters.php') {
            $return_jquery =  "
                <script>
                $(document).ready(function() {
                        $('#asp_identifier').attr(\"disabled\", \"disabled\");
                        });
            $('#include_asp_identifier').change(function() {
                    if ($(this).val() == 'disable') {
                    $('#asp_identifier').attr(\"disabled\", \"disabled\");
                    }
                    if ($(this).val() == 'enable') {
                    $('#asp_identifier').attr(\"disabled\", false);
                    }
                    });
            </script>
                ";
        }   
        return $return_jquery;
    }


    //HTML Footer
    function html_footer($jquery=false)
    {       
        if ( $this->IsRenderingNonDynamicDiv( ) ) {
            //<div class="footer">Copyright Sangoma Technologies 2010-2011</div>
            ?>  
                </body>
                <?php
                if ($jquery) {
                    if ($_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/configuration/configure_t1e1.php') {
                        ?>
                            <!-- Run custom JQUERY code -->
                            <script>
                            //HW Echo disable/enable jquery
                            $('#HW_EC').change(function() {
                                    if ($(this).val() == "disable") {
                                    $('#dtmf_removal').val('NO');
                                    $('#DTMF').val('disable');
                                    $('#HW_FAX').val('disable');
                                    }
                                    if ($(this).val() == "enable") {
                                    $('#dtmf_removal').val('NO');
                                    $('#DTMF').val('enable');
                                    $('#HW_FAX').val('disable');
                                    }
                                    });

                        //HW DTMF disable/enable jquery
                        $('#DTMF').change(function() {
                                if ($(this).val() == "disable") {
                                $('#dtmf_removal').val('NO');
                                }
                                if ($(this).val() == "enable") {
                                $('#dtmf_removal').val('NO');
                                }
                                });
                        </script>
                            <?php
                    }

                    if ($_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/mg/create_megaco_profile.php') {
                        ?>
                            <!-- Run custom JQUERY Code -->
                            <script>
                            $('#ip_addr').change(function() {
                                    $('#rtp_ip').val($('#ip_addr').val());
                                    });
                        $('#mid').change(function() {
                                if ($(this).val() == 'DOMAIN')
                                $('#domain_id').show()
                                else
                                $('#domain_id').hide();
                                });
                        $(document).ready(function() {
                                $('#rtp_ip').val($('#ip_addr').val());
                                if ($('#mid').val() == 'DOMAIN')
                                $('#domain_id').show()
                                else
                                $('#domain_id').hide();
                                });
                        </script>
                            <?php
                    }
                    elseif ($_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/relay/relay_questionnaire.php') {
                        ?>
                            <!-- Run custom JQUERY Code -->
                            <script>
                            $('input:radio').change(function() {
                                    if ($(this).is(':checked')) {
                                    $('#notification').show();
                                    }
                                    });
                        </script>
                            <?php
                    }
                    elseif ($_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/sng_config_manager.php') {
                        ?>
                            <script>
                            $(document).ready(function() {
                                    $("#notif_div").hide();
                                    });
                        </script>
                            <?php
                    }
                    elseif($_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/SS7/sigtran/m2ua_clusters.php') {
                        ?>
                            <script>
                            $(document).ready(function() {
                                    if ($('#include_asp_identifier').val() == 'enable')
                                    $('#asp_identifier').attr("disabled", false);
                                    if ($('#include_asp_identifier').val() == 'disable')
                                    $('#asp_identifier').attr("disabled", "disabled");
                                    });
                        $('#include_asp_identifier').change(function() {
                                if ($(this).val() == 'disable') {
                                $('#asp_identifier').attr("disabled", "disabled");
                                }
                                if ($(this).val() == 'enable') {
                                $('#asp_identifier').attr("disabled", false);
                                }
                                });
                        </script>
                            <?php
                    }
                }
            ?>

                </html>
                <?php
        }
    }

    //Checks the vocallo firmware to check if it is the right firmware or the wrong firmware
    function find_vocallo_firmware()
    {
        //Find transcoding cards in system
        include 'installation/transcoding_class.php';
        $media_process = new transcoding_class;

        $media_process->get_info();

        //print_r ($media_process->legacy_names);
        //print_r ($media_process->array_ip_addr);
        for ($a = 0; $a < count($media_process->array_mac); $a++)
        {
            $media_process->compare_mac($media_process->array_mac[$a]);
            //echo $media_process->is_sangoma;
            if ($media_process->is_sangoma == "YES" && $media_process->array_ip_addr[$a] != "")
            {
                //Use the IP Address of that device and find out the firmware using sngtc_tool
                $cmd = "/usr/sbin/sngtc_tool -dev " . $media_process->legacy_names[$a] . " -list_modules | grep Ver | cut -d\"=\" -f3 | cut -d\" \" -f1";
                exec ($cmd,$output);

                if ($output[0] != $_SESSION['vocallo_firmware'])
                {
                    $this->WarningBox( 
                            "<table><tr><td>\n".
                            "Media Firmware Out Dated<br/>" .
                            "</td>\n".
                            "<td>\n".
                            "<ul>\n" .
                            "<li>Media Firmware Version currently <b>" . $output[0] . "</b> and needs to be at <b>" . $_SESSION['vocallo_firmware'] . "</b></li>\n" .
                            "" .
                            "</ul>\n".
                            "</td></tr></table>\n",$style="style='width:700px'" );
                }
            }
        }
        //print_r ($media_process->array_names);
    }


    //Moves to an anchor when clear is clicked
    function clear_anchor()
    {
        ?>
            <script type="text/javascript" language="javascript">
            function moveWindow (){window.location.hash="<?php echo $_SESSION['anchor_id']; ?>";}
        </script>           
            <?php
            unset ($_SESSION['anchor_id']);
    }


    //Alert box launched on identify click
    function identify_alert()
    {
        ?>
            <script type='text/javascript'>
            //Opens the XML object based on your browser
            function getXMLHTTPRequest()
            {
                var req = false;

                try
                {
                    req = new XMLHttpRequest();     //Firefox, Chrome, IE7, Safari
                }
                catch(err1)
                {
                    try
                    {
                        req = new ActiveXObject("Msxml2.XMLHTTP"); //IE5 and IE6
                    }
                    catch (err2)
                    {
                        try 
                        {
                            req = new ActiveXObject("Microsoft.XMLHTTP"); //Other versions of IE
                        }
                        catch(err3)
                        {
                            req=false;
                        }
                    }
                }

                return req;
            }

        //Starts an AJAX redirect to get the port blinking
        function identify(fullcard,port,number,card)
        {   
            //Sends an AJAX request to start a PHP script
            xmlhttp = getXMLHTTPRequest();
            var url = "identify/identify-start.php?fullcard="+fullcard+"&card="+card+"&card_num="+number+"&port="+port;
            xmlhttp.open("GET",url,true);
            xmlhttp.send(null); 

            //Alert box blocking the page from the user
            //alert('Click OK to stop the identification process on port ' + port + ' of your ' + card + '. '); 
            //window.location = "/fusionpbx/sangoma/identify/identify_ui.php";
        }

        function identify_stop()
        {
            //Sends an AJAX request to start a PHP script
            //xmlhttp = getXMLHTTPRequest();
            //var url = "identify-stop.php";
            //xmlhttp.open("GET",url,true);
            //xmlhttp.send(null);           

            //window.location.pathname ('../wanrouterhwprobe.php');
            //alert('Click OK to End the Identification Procedure');
            var i = document.createElement("img");
            i.src = "identify_stop.php?" + Math.random();
            document.appendChild(i);
            return;
        }
        </script>
            <?php           
    }

    // Resize page after load if iframed
    function iframe_resize()
    {
        //echo $_SERVER['PHP_SELF'];
        ?>  
            <script type='text/javascript'>
            function ResizeFrame() {
                <?php
                    if ($_SERVER['PHP_SELF'] == "/fusionpbx/sangoma/wanrouterhwprobe.php" || $_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/configuration/configure_t1e1.php' ||  $_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/SS7/sigtran/SS7_m2ua_config.php' || $_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/SS7/sigtran/m2ua_clusters.php' ||  $_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/SS7/create_ss7_ccspans.php' || $_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/SS7/view_ss7_linkset.php' || $_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/SS7/create_ss7_linkset.php' || $_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/SS7/create_ss7_route.php' || $_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/SS7/create_ss7_isup.php' || $_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/SS7/sigtran/mg_channels.php' || $_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/SS7/decide_ss7_linktype.php' || $_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/profiles/view_profiles.php' || $_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/profiles/create_profile.php' || $_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/r2_config/view_r2_profiles.php' || $_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/r2_config/create_r2_profile.php' || $_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/sng_config_manager.php' || $_SERVER['PHP_SELF'] == '/fusionpbx/sangoma/profile_panel.php') {
                        ?>  
                            //if ( document.documentElement.clientHeight < document.body.scrollHeight ) {
                            try {
                                // Get the document height, add some pixels to be sure
                                var FramePageHeight = document.body.scrollHeight + 50;
                                // Query parent iFrames elements. 
                                var iFrames = parent.document.getElementsByTagName('iframe');
                                // Find ourself in the iFrame array
                                for (var i = 0; i < iFrames.length; i++) {
                                    //if (iFrames[i].contentWindow.url === window.url) 
                                    iFrames[i].style.height=FramePageHeight;
                                }
                                //document.write(iFrames[0].style.height);
                                //document.write(iFrames[1].style.height);

                                iFrames = null;
                            } catch(e) {}           
                        //} 
                        <?php
                    }
                    else {
                        ?>
                            if ( document.documentElement.clientHeight < document.body.scrollHeight ) {
                                try {
                                    // Get the document height, add some pixels to be sure
                                    var FramePageHeight = document.body.scrollHeight + 50;
                                    // Query parent iFrames elements. 
                                    var iFrames = parent.document.getElementsByTagName('iframe');
                                    // Find ourself in the iFrame array
                                    for (var i = 0; i < iFrames.length; i++) {
                                        if (iFrames[i].contentWindow.url === window.url) 
                                            iFrames[i].style.height=FramePageHeight;
                                    }
                                    iFrames = null;
                                } catch(e) {}           
                            }                   
                        <?php
                    }
                ?>
            };
        window.onload = ResizeFrame;       
        </script>
            <?php
    }
    function IsGatewayRunning() {
        exec("pidof " . $_SESSION['gateway_script'],$output);
        if ($output[0] <= 0)
            $IsRunning = false;
        else
            $IsRunning = true;

        unset( $output );
        return $IsRunning;
    }
    function LoadingIcon($style = null) {
        if (!isset($style) )
            $style = "style='margin-left:auto;margin-right:auto;float:center;'";
        echo "<img src='" .ICON_LOADING. "' ".$style."/>\n";
    }

    function WarningBox( $in_message, $style="style='width:100%'" ) {
        echo "<table class='mytable ui-state-error' border='0' $style>\n";
        echo "  <tr>\n";
        echo "      <td width='35'>\n";
        echo "      <img src='/fusionpbx/dialog_icon_warning.png'/>\n";
        echo "      </td>\n";
        echo "      <td>\n";
        // Just space
        echo "      </td>\n";
        echo "      <td width='99%'>\n";
        echo        $in_message;
        echo "      </td>\n";
        echo "  </tr>\n";
        echo "</table>\n";
    }
    // Dynamic Ajax refresh functions
    function DynamicDivAutoRefresh($style = "style='width:100%'") {
        // Don't create auto refresh if synamic refresh request
        if ( !$this->IsRenderingNonDynamicDiv() ) return;
        // Display auto-refresh box
        echo "<div align='right'$style >\n";
        echo "<form name='AutoRefresh' method='post' action='" . $_SERVER['PHP_SELF'] . "'>\n";
        echo "<table class='mytable' border='1'>\n";
        echo "  <th class='widget-content-header ui-state-active ui-corner-all'>\n";
        echo "      <input type='checkbox' id='AutoRefreshEnable' checked='yes'/>\n"; 
        echo "      <b>Auto refresh</b>:\n";
        echo "      <input type='text' name='RefreshValueInSec' id='RefreshValueInSec' value='";
        echo (isset($_REQUEST['RefreshValueInSec']))?$_REQUEST['RefreshValueInSec']:"5";
        echo "' size='3' /> sec.\n";
        echo "      <input type='submit' name='action' value='Refresh' " . $_SESSION['button_class'] . "/>\n"; 
        echo "  </th>\n";
        echo "</table>\n";
        // Create hidden input for all $_SERVER['QUERY_STRING'] (exclude form args)
        $QueryArgs = explode( "&", $_SERVER['QUERY_STRING'] );
        foreach ( $QueryArgs as $QueryArg )
        {
            $KeyValue = explode("=", $QueryArg );
            if ( "action" == $KeyValue[0] || "RefreshValueInSec" == $KeyValue[0] )
                continue;
            echo "<input type='hidden' name='" . $KeyValue[0] . "' value='" . $KeyValue[1] . "'/>\n";
            unset( $KeyValue );
        }
        unset( $QueryArgs );
        echo "</form>\n";
        echo "</div>\n";
    }
    function DynamicDivEnable() {
        if ( $this->IsRenderingNonDynamicDiv() )
        {
            // Page refresh
            ?>
                <script type='text/javascript'>
                function RefreshDynamicDiv( szDivId, szURI, szQueryArgs, uiTimeoutMs )
                {
                    var xmlHttpRequestObj=false;
                    var   szHttpRequest;

                    if (!xmlHttpRequestObj) 
                    {
                        if (window.XMLHttpRequest) {
                            xmlHttpRequestObj = new XMLHttpRequest();
                        } else if (window.ActiveXObject) {
                            try {
                                xmlHttpRequestObj = new ActiveXObject('Msxml2.XMLHTTP');
                            } catch(e) {
                                xmlHttpRequestObj = new ActiveXObject('Microsoft.XMLHTTP');
                            }
                        }
                    }

                    if (xmlHttpRequestObj) {
                        // Store data inside http request object
                        xmlHttpRequestObj.szDivId = szDivId; 
                        xmlHttpRequestObj.szURI = szURI; 
                        xmlHttpRequestObj.szQueryArgs = szQueryArgs; 
                        xmlHttpRequestObj.uiTimeoutMs = uiTimeoutMs; 
                        // Set callback
                        xmlHttpRequestObj.onreadystatechange = 
                            function() {
                                if (/4|^complete$/.test(xmlHttpRequestObj.readyState)) {
                                    var fRefresh = true;
                                    // Try getting the enable refresh check box value if exists
                                    try {
                                        fRefresh = document.getElementById("AutoRefreshEnable").checked;
                                    } catch(e) {
                                        fRefresh = true;
                                    }

                                    if (fRefresh)
                                        document.getElementById(szDivId).innerHTML = xmlHttpRequestObj.responseText;

                                    setTimeout("RefreshDynamicDiv( '"+szDivId+"','"+ szURI+"','"+ szQueryArgs+"',"+ uiTimeoutMs+")", uiTimeoutMs );
                                    ResizeFrame();
                                }
                            }
                        // Build http request URI
                        szHttpRequest = szURI + '?';
                        if ( szQueryArgs.length ) 
                            szHttpRequest += '?' + szQueryArgs + '&';
                        // Indicate which div should be refreshed
                        szHttpRequest += 'DynamicDiv=' + szDivId + '&';
                        // randomize uri    
                        szHttpRequest += new Date().getTime();
                        // Request the page
                        xmlHttpRequestObj.open('GET', szHttpRequest, true);
                        xmlHttpRequestObj.send(null);
                    }
                }
            function GetTimeoutMs( szTimeoutId )
            {
                try {
                    var uiTimeout;
                    uiTimeout = document.getElementById( szTimeoutId ).value;
                    uiTimeout *= 1000;
                    if ( !uiTimeout ) 
                        uiTimeout = 1000;

                    return uiTimeout;
                } catch(e) {
                    return 5000;
                }
            }

            </script>
                <?php
        }
    }

    function DynamicDivRegisterRefresh( $in_dynamicDivId, $in_refreshTimeMs = null )
    {
        echo "  <script type='text/javascript'>\n";
        if ($in_refreshTimeMs === null) {
            echo "      setTimeout(\"RefreshDynamicDiv( '" .$in_dynamicDivId . "', '" 
                . $_SERVER['PHP_SELF'] . "' , '" 
                . $_SERVER['QUERY_STRING'] 
                . "' , GetTimeoutMs( 'RefreshValueInSec' ) )\"
                , GetTimeoutMs( 'RefreshValueInSec' ) );\n";
        }
        else {
            echo "      setTimeout(\"RefreshDynamicDiv( '" .$in_dynamicDivId . "', '" 
                . $_SERVER['PHP_SELF'] . "' , '" 
                . $_SERVER['QUERY_STRING'] 
                . "' , $in_refreshTimeMs )\"
                , $in_refreshTimeMs);\n";
        }
        echo "  </script>\n";
    }
    function IsRenderingNonDynamicDiv() {
        return ( !isset( $_REQUEST['DynamicDiv'] ));
    }
    function IsDynamicDivRefreshRequest( $in_dynamicDivId ) {
        //echo $_REQUEST['DynamicDiv'];
        return ( isset( $_REQUEST['DynamicDiv'] ) && $in_dynamicDivId == $_REQUEST['DynamicDiv'] );
    }
    function DynamicDivBegin( $in_dynamicDivId, $in_divStyle = "", $in_refreshTimeMs = null ) {
        if ( $this->IsRenderingNonDynamicDiv() )
        {
            $this->DynamicDivRegisterRefresh( $in_dynamicDivId, $in_refreshTimeMs );
            echo "<div id='" .$in_dynamicDivId . "' style='" . $in_divStyle . "'>\n";
        }
    }
    function DynamicDivEnd( $in_dynamicDivId ) {
        if ( $this->IsRenderingNonDynamicDiv() )
            echo "</div>\n";
    }

    function get_license_status($data,$prod, &$license_err, &$channel_err, &$trial_license_error)
    {
        $table = "configured_channels";
        $validusb = false;
        $validhd = false;
        $db = "sqlite:sqlite/cardinfo.db";
        $tableresult = $data->check_for_table($db,$table);
        if ($tableresult > 1 )
        {
            $param = "channels";
            $return = $data->select_statement($db,$table,$param,"");
        }   
        settype($return['channels'], "integer");            
        $totchannels = intval($return['channels']);


        $file = $_SESSION['smg_root_path'] . '/conf/license.txt';
        $array = $this->open_file($file);

        //print_r ($array); 
        //echo $totchannels . "<br />";
        for ($a = 0; $a < count($array); $a++)
        {
            if(preg_match('/USB_SERIAL/', $array[$a]))
            {
                $usbserial = explode('=', $array[$a]);
                $usbserialvalue = trim(end($usbserial));
                exec("grep -h 'Serial' /proc/scsi/usb-storage/* '{print $1}'", $attachedusbserials);
                foreach($attachedusbserials as $serialnumnber)
                {
                    $sysusbserialnumnber =  explode(':', $serialnumnber);
                    if(trim(end($sysusbserialnumnber)) == $usbserialvalue)
                    {
                        $validusb = true;
                    }
                }

            }
            if(preg_match('/HD_SERIAL/', $array[$a]))
            {
                $hdserial = explode('=', $array[$a]);
                $hdserialValue = trim(end($hdserial));
                exec("hdparm -I /dev/sda | grep 'Serial Number'", $attachedhdserials);
                foreach($attachedhdserials as $serialnumnber)
                {
                    $syshdserialnumnber =  explode(':', $serialnumnber);
                    if(trim(end($sysusbserialnumnber)) == $hdserial)
                    {
                        $validhd = true;
                    }
                }
            }
        }
        for ($a = 0; $a < count($array); $a++)
        {
            if (preg_match("'\bTIME_TRIAL_BEGIN\b'",$array[$a]))
            {
                $key_value = explode("=",$array[$a]);
                $trial_array['timed_trial'] = TRUE;
                $trial_array['time_start'] = str_replace( ",", " ", $key_value[1]);
            }
            if (preg_match("'\bTIME_TRIAL_END\b'", $array[$a]))
            {
                $key_value = explode("=",$array[$a]);
                $trial_array['time_end'] = str_replace( ",", " ", $key_value[1]);
            }
            if (preg_match('/MAC/',$array[$a]))
            {
                //echo $array[$a] . "<br />";
                $_tmp = explode('=', $array[$a]);
                $_mac_addr = array_map('trim', explode(',', $_tmp[1]));

                $temp = false;
                //Get the MAC Address of all Ethernet devices on the system
                $prod->get_mp_info();
                foreach ($prod->array_mac as $mac)
                {
                    foreach ($_mac_addr as $mac_addr)
                    {
                        if ($mac_addr == "00:00:00:00:00:00")
                        {
                            $license = "Demo License Installed. Please purchase a License from <a href='mailto:sales@sangoma.com'>sales@sangoma.com</a>\n";
                            $temp = true;
                            break;
                        }
                        else if((strtoupper($mac_addr) == 'ANY' && $validusb === true) || (strtoupper($mac_addr) == 'FF:FF:FF:FF:FF:FF' && $validusb === true))
                        {
                            $temp = true;
                            unset($license);
                            break;
                        }
                        else if((strtoupper($mac_addr) == 'ANY' && $validhd === true) || (strtoupper($mac_addr) == 'FF:FF:FF:FF:FF:FF' && $validhd === true))
                        {
                            $temp = true;
                            unset($license);
                            break;
                        }
                        else if ($mac_addr == $mac)
                        {
                            $temp = true;
                            unset($license);
                            break;
                            //echo $temp . "<br />";
                        }
                    }

                }

                if ($temp == false)
                {
                    //$license = "<li>MAC Address in License File differs from the MAC Address' of your Network Ports</li>\n";
                    $license = "MAC Address in License File differs from the MAC Address' of your Network Ports\n";
                }
                //echo "MAC Address = $mac_addr <br />";
            }
            if (preg_match('/CIC/',$array[$a]))
            {
                //echo $array[$a] . "<br />";
                $pos = strpos($array[$a],' ');
                $chan = substr($array[$a],$pos);
                $channels = trim($chan," ");
                //echo $channels . " " . $return['channels'] . "<br />";
                //echo "Channels returned = " . $channels . "Total channels = $totchannels <br />";
                if ($channels < $totchannels)
                {
                    $channel_error = "Licensed " . $channels . " channels but configured " . $return['channels'] . " channels\n";
                }
                //echo "channels=" . $channels;
            }
            //echo $channel_error . "<br />";
            $license_err = $license;
            $channel_err = $channel_error;
        }   
        //Determine if License has expired or not
        if ($trial_array['timed_trial']) {
            $current_time = date("Y/m/d H:i");
            $cur_linux_time = strtotime($current_time);
            $temp_end_time = $trial_array['time_end'];
            $end_time = trim($temp_end_time);
            $end_linux_time = strtotime($end_time);

            //echo "Current time = $cur_linux_time, End time = $end_linux_time<br />";

            if ($cur_linux_time >= $end_linux_time)
            { 
                $expired = TRUE;
            }
        } 
        if ($expired)
        {
            $trial_license_error = "Trial License Expired. Please contact <a href='mailto:sales@sangoma.com'>sales@sangoma.com</a>";
        }


    }
    function license_conflicts($data,$prod,$relay_name)
    {
        if ($_SERVER['PHP_SELF'] != "/fusionpbx/sangoma/controls_embedded.php")
        {
            include 'production-test/prod-test-class.php';
            $prod = new prod_test;
        }
        $this->get_license_status($data, $prod, $license, $channel_error);



        if ($channel_error!= "" || $license != "")
        {
            $this->WarningBox( 
                    "<table><tr><td>\n".
                    "$relay_name Node License File Conflict:<br/>" .
                    "</td>\n".
                    "<td>\n".
                    "<ul>\n" .
                    $channel_error.
                    $license.
                    "</ul>\n".
                    "</td></tr></table>\n", "style='width:700px'" );
        }           
    }

    function token_generic($string)
    {
        $tok = strtok($string,',');

        $count = 0;
        while ($tok !== false) 
        {
            $token[$count] = $tok;
            $tok = strtok(',');
            $count++;
        }
        //print_r ($token);
        return $token;
    }

    function open_file($filename)
    {
        $fp = fopen($filename, "r");

        while (!feof($fp))
        {
            $in = fgets($fp, 4094);
            $anArray[] = trim($in);
        }

        fclose ($fp);       
        return $anArray;
    }

    function Download_log($style="")
    {
        echo "<div align='right'$style >\n";
        echo "<form name='logDownload' method='post' action='" . $_SERVER['PHP_SELF'] . "'>\n";
        echo "<table class='mytable' border='1'>\n";
        echo "  <th class='widget-content-header ui-state-active ui-corner-all'>\n";
        echo "      <b>Download Logs</b>:\n";
        echo "      <input type='submit' name='logs' value='Download' " . $_SESSION['button_class'] . "/>\n"; 
        echo "      <input type='hidden' name='file' value='" . $_SESSION['smg_root_path'] . "/nginx/html/php/production-test/SangomaOutput.tgz' />\n";
        echo "      <input type='hidden' name='properFilename' value='SangomaOutput' />\n";
        echo "  </th>\n";
        echo "</table>\n";
        echo "</div>\n";
    }
}   

//Class that contains the display functions for Hardware Probe
class Display_hwprobe
{   
    public $button_class = "";
    private $result="";     //variable storing whether there is an entry in the results table or not

    //Controls the Main HTML table used to display wanrouter hwprobe information
    function create_html_table($a101, $a102, $a104, $a108, $a200, $a400, $b601, $b700, $a500, $a116, $data, $tokenization, $bri_info, $bri_b700_info, $b600, $relay_name)
    {
        //echo "Session = " . $_SESSION['freetdm'] . "<br />";
        //include the file
        require_once 'ss7_display.php';
        include_once 'database_classes.php';
        require_once 'update_card_present.php';

        //create the class
        $ss7_class = new ss7_display;
        $display_common = new Display_common;

        $relay_result = $data->select_statement('sqlite:sqlite/relay_info.db','ss7_relay','machine_type','id=1');

        //Enters everything in the card present table and does not go on a span basis
        enter_card_present($a101,$a102,$a104,$a108,$a116,$b601,$a200,$a400,$a500,$b600,$b700,$data,$relay_name);

        if ($relay_result['machine_type'] == "standalone")
            $data->populate_finihsed_ports_table();

        if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']) && $relay_result['machine_type'] == "standalone")
        {   
            echo "<h3>TDM Configuration</h3>\n";
            echo "<p>\n";               
            echo "Please configure your hardware for use with " . $_SESSION['name'] . "<br />\n";               
            echo "</p>\n";
            echo "<hr style='width:700px;' align='left'/>\n";               
        }

        //$relay_result = $data->select_statement('sqlite:sqlite/relay_info.db','ss7_relay','machine_type','id=1');
        if ($_SESSION['no_cards'] != "yes")
        {
            //Checks for completed ports on a standalone ss7 or multifunction gateway application
            if ($_SESSION['msbg'] != "" || $relay_result['machine_type'] == "standalone")
            {
                $db_location = "sqlite:sqlite/cardinfo.db";
                $check = $data->check_for_table($db_location,'finished_ports');
                if ($check > 1)
                {
                    $result = $data->select_statement($db_location, "finished_ports", "id", "");    

                    if (count($result) > 1)
                    {
                        echo "<h4 id='generate'></h4>\n";
                        //Check wanrouter status
                        exec ("/usr/sbin/wanrouter status | grep -c wanpipe",$output);

                        //echo "$b = wanrouter = " . $output[0] . "<br />";
                        if ($output[0] == "DISABLED" || $output[0] == "INVALID KEY" || $output[0] == 0)
                        {
                        }
                        elseif ($output[0] > 0)
                        {
                            //echo " equals everything else<br />";
                            //Check if the gateway is started on each machine then check if each relay database is in sync
                            $gateway_started = "yes";

                        }
                    }
                }

                if ( !isTdmConfigInSync($db_location) )
                    $out_of_sync = "yes";

                //echo "out of sync = $out_of_sync, gateway started = $gateway_started , slave error = $slave_error<br />";
                require_once 'display_class.php';
                require_once "production-test/prod-test-class.php";

                $notif = new NotificationBox( 'Warnings', NotificationBox::Warning );
                //print_r ($notif);
                // Check if TDM configuration is in synch
                if ( $out_of_sync == "yes" )
                {
                    if ( $slave_error > 0 )
                    {
                        $notif->add("TDM","Configuration out of sync" );
                        $notif->add("TDM","Cannot generate configuration until all Relay Nodes active" );
                    }
                    elseif ($slave_error == 0 || $slave_error == "")
                    {
                        if ( $gateway_started == "yes"  && $_SESSION['shortname'] == "NSG")
                        {
                            $notif->add("TDM","Configuration out of sync" );

                            //check if there has been a span removed and gateway is started.
                            $finished_boards = $data->array_select_statement('sqlite:sqlite/cardinfo.db','finished_ports','card, type','');
                            $generated_boards = $data->array_select_statement('sqlite:sqlite/cardinfo.db','generated_ports','card, type','');
                            foreach ($generated_boards as $gen_board) {
                                $found = false;
                                foreach ($finished_boards as $fin_board) {
                                    if ($fin_board['card'] == $gen_board['card']) {
                                        $found = true;
                                        break;
                                    }
                                }

                                if (!$found && $_SESSION['shortname'] == "NSG" && ($gen_board['type'] == "M2UA Signalling Gateway" || $gen_board['type'] == "Media Gateway")) {
                                    if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
                                        $notif->add("TDM",$gen_board['card'] . " has been removed. Please <a href='profile_panel.php' target='_parent'>Synchronize</a> configuration.");
                                    else
                                        $notif->add("TDM",$gen_board['card'] . " has been removed. Please <a href='/admin/ss7_profile_panel.php' target='_parent'>Synchronize</a> configuration.");
                                    $skip_out_of_sync = true;
                                }
                                elseif (!$found && $_SESSION['shortname'] == "NSG") {
                                    if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
                                        $notif->add("TDM",$gen_board['card'] . " has been removed. Please <a href='controls_embedded.php' target='_parent'>Stop the Gateway</a> in order to re-configure the span.");
                                    else
                                        $notif->add("TDM",$gen_board['card'] . " has been removed. Please <a href='/admin/ss7_controls.php' target='_parent'>Stop the Gateway</a> in order to re-configure the span.");
                                    $skip_out_of_sync = true;
                                }
                            }

                            if (!$skip_out_of_sync) {
                                $found = false;
                                foreach ($finished_boards as $fin_board) {
                                    if ($fin_board['type'] != "Media Gateway" && $fin_board['type'] != "M2UA Signalling Gateway") {
                                        $found = true;
                                        break;
                                    }
                                }

                                if (!$found) {
                                    if(isMGConfigInSync($db_location)) {
                                        if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
                                            $notif->add("TDM","<a href='profile_panel.php' >Synchronize</a> configuration." );
                                        else
                                            $notif->add("TDM","<a href='/admin/ss7_profile_panel.php' target='_parent'>Synchronize</a> configuration." );
                                    }
                                }else{
                                    if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded'])) {
                                        $notif->add("TDM","<a href='controls_embedded.php' >Stop</a> the gateway" );
                                        $notif->add("TDM","Please proceed to the <a href=\"sng_config_manager.php\" target='_parent'>Apply Configuration</a> Page");                                                                                        
                                    } else {
                                        $notif->add("TDM","<a href='/admin/ss7_controls.php' target='_parent'>Stop</a> the gateway" );
                                        $notif->add("TDM","Please proceed to the <a href=\"/admin/ss7_cfg_manager.php\" target='_parent'>Apply Configuration</a> Page");    
                                    }
                                    $notif->add("TDM","Generate TDM configuration." );
                                }
                            }
                        }
                        elseif ($gateway_started == "yes" && $_SESSION['shortname'] == "NVG") {
                            if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded'])) {
                                $notif->add("TDM","<a href='controls_embedded.php' >Stop</a> the gateway" );
                                $notif->add("TDM","Please proceed to the <a href=\"sng_config_manager.php\" target='_parent'>Apply Configuration</a> Page");                                                                                        
                            }
                            else {
                                $notif->add("TDM","<a href='/admin/ss7_controls.php' target='_parent'>Stop</a> the gateway" );
                                $notif->add("TDM","Please proceed to the <a href=\"/admin/ss7_cfg_manager.php\" target='_parent'>Apply Configuration</a> Page");    
                            }
                        }
                        else
                        {
                            $notif->add("TDM","Configuration out of sync" );

                            if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
                                $notif->add("TDM","Please proceed to the <a href=\"sng_config_manager.php\" >Apply Configuration</a> Page");
                            else
                                $notif->add("TDM","Please proceed to the <a href=\"/admin/ss7_cfg_manager.php\" target='_parent'>Apply Configuration</a> Page");
                        }
                    }
                }                       
                elseif ($gateway_started != "yes" && $slave_error == 0 && count($result) > 0)
                {
                    if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
                        $notif->add("TDM","Start the <a href='controls_embedded.php' >gateway</a>" );
                    else
                        $notif->add("TDM","Start the <a href='/admin/ss7_controls.php' target='_parent'>gateway</a>" );
                }
                elseif ($gateway_started != "yes" && $slave_error != 0)
                {
                    //$notif->add("TDM","Configuration out of synch," );
                    $notif->add("TDM","Cannot start the gateway until all Relay Nodes active" );
                }



                $mediaObj = new prod_test();
                $display_common->get_license_status($data,$mediaObj,$license_err, $channel_err, $trial_license_error);
                $mediaObj = NULL;   
                //echo $license_err . "<br />";
                if ( $license_err!= "" )
                    $notif->add("License", $license_err);
                if ( $channel_err!= "" )
                    $notif->add("Channels", $channel_err);
                if (isset($trial_license_error))
                    $notif->add("Timed Trial", $trial_license_error);

                $notif->display();
            }
            if ($relay_result['machine_type'] == "standalone")
                unset($notif);

        }               
        //Creates HTML Form
        echo "\t<form method=\"post\" action=\"\">\n";

        //Keeps a count of the amount of cards in the system
        $a101count = count($a101);
        $a102count = count($a102);
        $a104count = count($a104);      
        $a108count = count($a108);  
        $b601count = count($b601);  
        $a200count = count($a200);
        $a400count = count($a400);  
        $a500count = count($a500);  
        $b600count = count($b600);  
        $b700count = count($b700);
        $a116count = count($a116);

        unset ($_SESSION['span_counter']);
        //echo "a101 = $a101count a102 = $a102count a104 = $a104count a108 = $a108count<br />";
        //Total number of cards in the system
        $total_cards = $a101count + $a102count + $a104count + $a108count + $a500count + $a200count + $a400count + $b600count + $b700count + $b701count + $a116count;

        if ($a101[$a101count]->device_name != "" || $a102[$a102count]->device_name != "" || $a104[$a104count]->device_name != "" || $a108[$a108count]->device_name != ""|| $a116[$a116count]->device_name != "")
        {
            //$_SESSION['no_cards']  = "";
            echo "\t\t<h4>T1/E1 Cards</h4>\n";

            for ($x = 0; $x <= $a116count; $x++)
            {

                if ($a116[$x]->device_name != "")
                {
                    $count++;           
                    $this->table($a116[$x], $count,$tokenization, $data,"", $ss7_class, $count,$relay_name);
                }   
            }

            for ($x = 0; $x <= $a108count; $x++)
            {

                if ($a108[$x]->device_name != "")
                {
                    $count++;           
                    $this->table($a108[$x], $count,$tokenization, $data,"", $ss7_class, $count,$relay_name);
                }   
            }

            for ($x = 0; $x <= $a104count; $x++)
            {       
                if ($a104[$x]->device_name != "")
                {                               
                    $count++;           
                    $this->table($a104[$x], $count,$tokenization, $data,"", $ss7_class, $count,$relay_name);
                }
            }

            for ($x = 0; $x <= $a102count; $x++)
            {       
                if ($a102[$x]->device_name != "")
                {                       
                    $count++;                                       
                    $this->table($a102[$x], $count,$tokenization, $data,"", $ss7_class, $count,$relay_name);                 
                }
            }

            for ($x = 0; $x <= $a101count; $x++)
            {   
                if ($a101[$x]->device_name != "")
                {                       
                    $count++;
                    $this->table($a101[$x],$count,$tokenization, $data,"", $ss7_class, $count,$relay_name);
                }
            }
        }
        elseif (($a101[$a101count]->device_name == "" && $a102[$a102count]->device_name == "" && $a104[$a104count]->device_name == "" && $a108[$a108count]->device_name == "" && $a116[$a116count]->device_name == "") && $_SESSION['nbess7'] == "yes")
        {
            //Did not detect any ss7 compatible cards in the system
            //display an error
            $notif = new NotificationBox( 'Error', NotificationBox::Error );
            $notif->add("TDM", "Did not find any compatible TDM Hardware within the system.<br />Please insert a compatible A-Series card (i.e. A101, A102, A104, A108 or an A116");
            echo $notif->getHtml();     
            unset($notif);  
            $_SESSION['no_cards'] = "yes";
        }
        if ($a500[$a500count]->device_name != "" && $_SESSION['msbg'] == "yes")
        {
            echo "\t\t<h4>ISDN BRI Cards</h4>\n";
            for ($x = 1; $x <= $a500count; $x++)
            {                               
                $bri_values = "";
                $count++;
                //echo "card = $x<br />";
                foreach ($bri_info[$x] as $key => $value)
                {
                    //echo "$key = $value<br />";
                    $bri_values[$key] = $value;
                }
                $this->table($a500[$x], $count,$tokenization, $data, $bri_values, "", $count,$relay_name);  
            }                       
        }
        if ($a200[$a200count]->device_name != "" && $_SESSION['msbg'] == "yes"|| $a400[$a400count]->device_name != ""  && $_SESSION['msbg'] == "yes")
        {
            echo "\t\t<h4>Analog Cards</h4>\n";
            for ($x = 0; $x <= $a200count; $x++)
            {
                if ($a200[$x]->device_name != "")
                {                           
                    $count++;   
                    $this->table($a200[$x], $count,$tokenization, $data, "", "", $count,$relay_name);
                }
            }

            for ($x = 0; $x <= $a400count; $x++)
            {
                if ($a400[$x]->device_name != "")
                {                           
                    $count++;               
                    $this->table($a400[$x], $count,$tokenization, $data, "", "", $count,$relay_name);
                }
            }

        }   
        if ( $b601[$b601count]->device_name != ""  && $_SESSION['msbg'] == "yes" || $b700[$b700count]->device_name != ""  && $_SESSION['msbg'] == "yes" || $b600[$b600count]->device_name != ""  && $_SESSION['msbg'] == "yes")
        {

            echo "\t\t<h4>Hybrid Cards</h4>\n";

            for ($x = 0; $x <= $b600count; $x++)
            {
                if ($b600[$x]->device_name != "")
                {                                       
                    $count++;   
                    $this->table($b600[$x], $count,$tokenization, $data, "", "", $count,$relay_name);
                }
            }                               

            for ($x = 0; $x <= $b601count; $x++)
            {
                //echo "device name = " . $b601[$x]->device_name . "<br />";
                if ($b601[$x]->device_name != "")
                {                           
                    $count++;               
                    $this->table($b601[$x], $count,$tokenization, $data, "", $ss7_class, $count,$relay_name);   
                }
            }

            for ($x = 0; $x <= $b700count; $x++)
            {
                if ($b700[$x]->device_name != "")
                {                               
                    $bri_values = "";
                    $count++;
                    //echo "card = $x<br />";
                    foreach ($bri_b700_info[$x] as $key => $value)
                    {
                        //echo "$key = $value<br />";
                        $bri_values[$key] = $value;
                    }
                    $this->table($b700[$x], $count,$tokenization, $data, $bri_values, "", $count,$relay_name);  
                }                   
            }                           
        }       

        unset($ss7_class);
        return $count;
    }   

    //Creates the table as per the layout needed
    function table($object, $span, $tokenization, $data, $bri_info, $ss7_class, $span_counter,$relay_name)
    {   
        //echo $object->device_name . "<br />";

        unset($relay_type);
        //Tokenizes the card name and removes everything but the actual card name
        $card_name = $tokenization->tokenize_name($object->device_name);  
        $card_only_name = $tokenization->token_name($card_name);
        $db = database_selection($relay_name);
        $db_location = "sqlite:sqlite/" . $db;      

        //pull id of each relay_node so it will become the proc_id
        $table_status = $data->check_for_table('sqlite:sqlite/relay_info.db','relay_hosts');
        //echo $table_status . "<br />";    
        if ($table_status > 1)
        {
            //pull information
            $relay_type = $data->select_statement('sqlite:sqlite/relay_info.db','ss7_relay','machine_type,relay_type',"");
            //echo $relay_type['relay_type'] . "<br />";
            if ($relay_type['machine_type'] == "standalone" || ($relay_type['machine_type'] == "relay" && $relay_type['relay_type'] == "SLAVE"))
            {
                $proc_id = 1;
                //echo "i am here <br />";
            }
            elseif ($relay_type['relay_type'] == "MASTER")
            {
                $proc = $data->select_statement('sqlite:sqlite/relay_info.db','relay_hosts','id',"relay_name = \"$relay_name\"");
                //echo "relay id = " . $relay_name['id'] . "<br />";
                $proc_id = $proc['id'];
            }               

        }
        elseif ($table_status < 2)
        {
            $proc_id = 1;
            //$relay_type = $data->select_statement('sqlite:sqlite/relay_info.db','ss7_relay','machine_type',"");       
        }
        //echo "proc = $proc_id<br />";;
        //echo $db_location . "<br />"; 
        //$db_location = "sqlite:sqlite/cardinfo.db";       

        //Gets all the Required information for BRI
        if ($object->device_name == "AFT-A500-SH" || $object->device_name == "AFT-B700-SH")
        {
            $port = array();
            $p = 1;
            foreach ($bri_info as $key => $value)
            {
                //echo "$key = $value<br />";
                $port[$p] = $key;
                $port_type[$p] = $value;
                //echo "$port[$p], $port_type[$p]<br />";

                if ($object->device_name == "AFT-A500-SH")
                    $_SESSION['a500_ports'][$p] = $port[$p];
                elseif ( $object->device_name == "AFT-B700-SH")
                    $_SESSION['b700_ports'] = $port;                    

                //Insert the port numbers into the hardware database
                $table = $card_only_name . "_" . $span;
                //check if the table exists
                $existance = $data->check_for_table ($db_location, $table);

                if ($existance > 1)
                {
                    //Check if the line exists
                    $param = "port_id";
                    $where_param = "port_id = " . $port[$p];
                    $result = $data->select_statement ($db_location, $table_name, $param, $where_param);

                    if ($result != "")
                    {
                        $update_bri_parameter = "port_id = \"" . $port[$p] . "\"";
                        $where_update = "port_id = " . $port[$p];
                        $data->update_table ($db_location, $table, $update_bri_parameter, $where_update);               
                    }
                    else
                    {
                        $parameters = "port_id";
                        $values =  $port[$p] . "";              
                        $data->insert_statement($db_location, $table, $parameters, $values);                        
                    }
                }
                elseif ($existance < 2)
                {
                    $param = "port_id int primary key, conn_type varchar(10), dev_name varchar(30), hw_ec varchar(10), hw_dtmf varchar(10), hw_fax varchar(10), rxgain decimal(10,2), txgain decimal(10,2)";
                    $data->create_table($db_location, $table, $param);

                    $parameters = "port_id";
                    $values =  $port[$p] . "";              
                    $data->insert_statement($db_location, $table, $parameters, $values);
                }

                $p++;               
            }
        }
        //echo $object->device_name;
        $span_count = 0;

        for ($count = 1; $count <= $object->port_num; $count++)
        {
            $span_count++;

            //Increments the SS7 span number
            if ($object->device_name == "AFT-A101-SH" || $object->device_name == "AFT-A102-SH" || $object->device_name == "AFT-A104-SH" || $object->device_name == "AFT-A108-SH" || $object->device_name == "AFT-A116-SH" || $object->device_name == "AFT-B601-SH" && $count == 1)
            {
                $_SESSION['span_num']++;
            }           

            //Port Counter which increments after each port is displayed on the screen.
            //Used when generating wanpipe configs  
            if ($object->device_name != "AFT-A500-SH" && $object->device_name != "AFT-B700-SH")
            {
                $_SESSION['port']++;
                $port = $_SESSION['port'];
            }

            //Gets hardware/signalling information
            if ($object->device_name == "AFT-A500-SH" || $object->device_name == "AFT-B700-SH" )
            {
                //Gets the hardware information from the database
                $hw_info = $data->get_hardware_info($card_name, $port[$count], $span, $relay_name);

                //Gets the signalling information from the database
                $sig_info = $data->get_signalling_info($card_name, $port[$count], $span, $relay_name);
            }
            elseif ($object->device_name == "AFT-A101-SH" || $object->device_name == "AFT-A102-SH" || $object->device_name == "AFT-A104-SH" || $object->device_name == "AFT-A108-SH" || $object->device_name == "AFT-A116-SH" || $object->device_name == "AFT-B601-SH" )
            {
                unset($hw_info);
                unset($sig_info);
                unset($ss7_info);
                unset($r2_info);
                //Gets the hardware information from the database
                $hw_info = $data->get_hardware_info($card_name, $count, $span, $relay_name);
                //echo $hw_info[0] . "<br />";

                //Gets the signalling information from the database
                $sig_info = $data->get_signalling_info($card_name, $count, $span, $relay_name);

                //Gets r2 signalling info from the database
                $r2_info = $data->get_r2_info($card_name,$count,$span,$relay_name);

                //Gets the SS7 Link information from the database
                $ss7_info = $data->get_ss7_link($card_name, $count, $span, $relay_name);
                //echo $ss7_info[0] . "<br />";

                //Gets M2UA/MG Information
                $ss7_m2ua_info = $data->get_ss7_m2ua_link($card_name, $count, $span, $relay_name);
                $ss7_mg_info = $data->get_ss7_mg_channels($card_name, $count, $span, $relay_name);

                //Get linkset info if an SS7 link is detected
                if ($ss7_info[0] != "")
                {
                    //echo "i am here <br />";
                    $table_name = $card_only_name . "_" . $span . "_SS7_link";
                    $where = "port_id = " . $count;
                    //$where = "link_name = \"" . $ss7_info[0] . "\"";
                    $ss7_linkset = $data->select_statement($db_location,$table_name, "linkset", $where);
                    //echo "Linkset = " . $ss7_linkset['linkset'] . "<br />";
                    $ss7_voice = $data->select_statement($db_location,$table_name, "voice", $where);
                    //var_dump($ss7_voice);
                    //Get ccspan info if the table exists
                    $table_name = $card_only_name . "_" . $span . "_SS7_ccspans";
                    $table_exist = $data->check_for_table ($db_location, $table_name);

                    if ($table_exist > 1)
                    {
                        $where = "port_id = " . $count;
                        $ss7_ccspan = $data->select_statement($db_location,$table_name, "isup", $where);    
                    }
                }
                if ($ss7_m2ua_info[0] != "")
                {
                    //get m2ua related info
                }
                if ($ss7_mg_info[0] != "")
                {
                    //get mg profile into
                }

            }
            elseif ($object->device_name == "AFT-A200-SH" || $object->device_name == "AFT-A400-SH" || $object->device_name == "AFT-B600-SH")
            {
                //Gets the hardware information from the database
                $hw_info = $data->get_hardware_info($card_name, $count, $span);
                $sig_info = $data->get_signalling_info($card_name, $count, $span);
            }

            unset($clear_button);
            if ($hw_info[0] != "")
            {
                if ($object->device_name == "AFT-A500-SH" || $object->device_name == "AFT-B700-SH") 
                {
                    $anchor_id = $card_only_name . "_" . $span . "_" . $port[$count];
                    $clear_button = "<input type=\"submit\" name=\"config-clear-" . $card_name . "-". $port[$count] . "-" . $span . "\" value=\"Clear\" " . $_SESSION['button_class'] . "/>";       
                }
                elseif ($object->device_name == "AFT-A101-SH" || $object->device_name == "AFT-A102-SH" || $object->device_name == "AFT-A104-SH" || $object->device_name == "AFT-A108-SH" || $object->device_name == "AFT-A116-SH" || $object->device_name == "AFT-A200-SH" || $object->device_name == "AFT-A400-SH" || $object->device_name == "AFT-B600-SH" || $object->device_name == "AFT-B601-SH")
                {
                    $anchor_id = $card_only_name . "_" . $span . "_" . $count;
                    $clear_button = "<input type=\"submit\" name=\"config-clear-" . $card_name . "-". $count . "-" . $span . "-" . $proc_id . "\" value=\"Clear\" " . $_SESSION['button_class'] . " />";
                }
            }   
            else
            {
                if ($object->device_name == "AFT-A500-SH" || $object->device_name == "AFT-B700-SH") 
                {
                    $anchor_id = $card_only_name . "_" . $span . "_" . $port[$count];
                    $clear_button = "<input type=\"submit\" name=\"config-clear-" . $card_name . "-". $port[$count] . "-" . $span . "\" value=\"Clear\" " . $_SESSION['disabled_button_class'] . " disabled=\"disabled\"/>";        
                }
                elseif ($object->device_name == "AFT-A101-SH" || $object->device_name == "AFT-A102-SH" || $object->device_name == "AFT-A104-SH" || $object->device_name == "AFT-A108-SH" || $object->device_name == "AFT-A116-SH" || $object->device_name == "AFT-A200-SH" || $object->device_name == "AFT-A400-SH" || $object->device_name == "AFT-B600-SH" || $object->device_name == "AFT-B601-SH")
                {
                    $anchor_id = $card_only_name . "_" . $span . "_" . $count;
                    $clear_button = "<input type=\"submit\" name=\"config-clear-" . $card_name . "-". $count . "-" . $span . "-" . $proc_id . "\" value=\"Clear\" " . $_SESSION['disabled_button_class'] . " disabled=\"disabled\"/>";
                }
            }

            //Run script to check highest firmware version and check it with what is on the card
            $cmd = $_SESSION['smg_root_path'] . "/nginx/html/php/scripts/firmware.sh " . $card_only_name;
            //echo $cmd;
            exec ($cmd, $firm);

            //echo $firm[0];

            //Check the firmware for the A10X cards
            //$a108firm = 43;
            //$a104firm = 43;
            //$a102firm = 37;
            //$a101firm = 37;
            //$b601firm = 4;

            //Sets the string to show the hardware info in the port banner
            unset ($card_information);
            if ($hw_info[0] != "")
            {
                //echo $a104firm;
                if ($object->device_name == "AFT-A101-SH" && $object->firmware < $firm[0] || $object->device_name == "AFT-A102-SH" && $object->firmware < $firm[0] || $object->device_name == "AFT-A104-SH" && $object->firmware < $firm[0] || $object->device_name == "AFT-A108-SH" && $object->firmware < $firm[0] || $object->device_name == "AFT-A116-SH" && $object->firmware < $firm[0])
                    $card_information = strtoupper("[HWEC=" . $object->echo . ", <font color='red'>V" . $object->firmware . "</font>") . "<img src='fusionpbx/AlertSign.png' width='12' height='12' title='Firmware outdated' style='vertical-align:text-bottom; float:none'/>";
                else
                    $card_information = strtoupper("[HWEC=" . $object->echo . ", V" . $object->firmware);

                if ($object->device_name == "AFT-A500-SH" || $object->device_name == "AFT-B700-SH")
                    $card_information.= ", ". $port_type[$count]."]";
                elseif ($object->device_name == "AFT-A101-SH" || $object->device_name == "AFT-A102-SH" || $object->device_name == "AFT-A104-SH" || $object->device_name == "AFT-A108-SH"|| $object->device_name == "AFT-B601-SH")
                    $card_information.= strtoupper(", $hw_info[0], $hw_info[2], $hw_info[1],");
                if ($hw_info[3] == "normal")
                    $card_information.= " N]\n";
                elseif ($hw_info[3] == "master")
                    $card_information.= "M-$hw_info[4]]\n";             
                else
                    $card_information .= "]\n";
            }
            else
            {
                if ($object->device_name == "AFT-A101-SH" && $object->firmware < $firm[0] || $object->device_name == "AFT-A102-SH" && $object->firmware < $firm[0] || $object->device_name == "AFT-A104-SH" && $object->firmware < $firm[0] || $object->device_name == "AFT-A108-SH" && $object->firmware < $firm[0] || $object->device_name == "AFT-A116-SH" && $object->firmware < $firm[0])
                    $card_information = strtoupper("[HWEC=" . $object->echo . ", <font color='red'>V" . $object->firmware . "</font>") . "<img src='fusionpbx/AlertSign.png' width='12' height='12' title='Firmware outdated' style='vertical-align:text-bottom;float:none'/>]";
                else
                    $card_information = strtoupper("[HWEC=" . $object->echo . ", V" . $object->firmware . "]");
            }


            //echo "Session = " . $_SESSION['nbess7'] . "<br />";
            //Opens the global hwprobe table functions
            unset($view);
            include_once ('global_view.php');
            $view = new view_options;
            $view->view();
            //echo "Hardware = " . $hw_info[0] . " SS7 link = " .  $ss7_info[0] . " Linkset = " .  $ss7_linkset . " ISUP Interface = " . $ss7_ccspan['isup'] . "<br />";
            //Handles PRI/BRI/Analog/R2 completion
            if ((isset($sig_info[0]) && isset($hw_info[0])) || (isset ($r2_info[0]) && isset($hw_info[0])))
            {   
                if ($object->device_name == "AFT-A101-SH" || $object->device_name == "AFT-A102-SH" || $object->device_name == "AFT-A104-SH" || $object->device_name == "AFT-A108-SH" || $object->device_name == "AFT-A116-SH" || $object->device_name == "AFT-B601-SH" && $count == 0)
                {                                           
                    //Completed T1/E1 Card
                    echo $view->completet1e1;
                    echo "<th id=\"$anchor_id\" class=\"widget-content-header ui-state-active ui-corner-top\" colspan=\"4\">\n";

                    echo "<table>\n<tr>\n";
                    echo "<td align=\"left\" width=\"635px\">" . $object->device_name . " Board $span Port $count Span " . $_SESSION['span_num'] . " $card_information<img src=\"fusionpbx/checkbox.gif\" width=\"12px\" height=\"12px\" /></td>\n";
                    echo "<td align=\"right\">$clear_button</td>\n";    
                    echo "</tr>\n</table>\n";
                    echo "</th>\n";

                    echo "</td>\n";                     
                }
                elseif ($object->device_name == "AFT-A500-SH" || $object->device_name == "AFT-B700-SH")
                {

                    //Completed BRI Card
                    echo $view->completebri;
                    echo "<th id=\"$anchor_id\" class=\"widget-content-header ui-state-active ui-corner-top\" colspan=\"3\">\n";

                    echo "<table>\n<tr>\n";
                    echo "<td align=\"left\" width=\"635px\">" . $object->device_name . " Board $span Port " . $port[$count] . "  Span " . $_SESSION['span_num'] . " $card_information<img src=\"fusionpbx/checkbox.gif\" width=\"12px\" height=\"12px\"/></td>\n";
                    echo "<td align=\"right\">$clear_button</td>\n";    
                    echo "</tr>\n</table>\n";
                    echo "</th>\n";

                    echo "</td>\n";                                         
                }
                else
                {

                    //Completed Analog Card
                    echo $view->completeanalog;
                    echo "<th id=\"$anchor_id\" class=\"widget-content-header ui-state-active ui-corner-top\" colspan=\"3\">\n";

                    echo "<table>\n<tr>\n";
                    echo "<td align=\"left\" width=\"635px\">" . $object->device_name . " Board $span Span " . $_SESSION['span_num'] . " $card_information<img src=\"fusionpbx/checkbox.gif\" width=\"12px\" height=\"12px\"/></td>\n";
                    echo "<td align=\"right\">$clear_button</td>\n";    
                    echo "</tr>\n</table>\n";
                    echo "</th>\n";

                    echo "</td>\n";                     
                }
                echo "<tr>\n";
                echo "<td>\n";

                //HW Table if card is configured
                echo $view->configured_completed_hrtable;

                echo "<tr align=\"center\">\n"; 
                echo "<td>\n";  
            }
            //Handles SS7 Table Completion items
            elseif (($hw_info[0] !="" && $ss7_info[0] !="" && $ss7_linkset !="" && $ss7_ccspan['isup'] !="") || ($hw_info[0] != "" && $ss7_m2ua_info[0] != "" && $ss7_m2ua_info[2] == "yes" && $ss7_mg_info[0] != "") || ($hw_info[0] != "" && $ss7_mg_info[0] != "") || ($hw_info[0] != "" && $ss7_m2ua_info[0] != "" && $ss7_m2ua_info[2] == "no"))
            {   

                if ($ss7_voice[0] == "")
                    //Completed SS7 Link
                    echo $view->complete_ss7link;
                else
                    //Completed Voice Link
                    echo $view->complete_ss7voice;                                                  


                echo "<tr>\n";
                echo "<th id=\"$anchor_id\" class=\"widget-content-header ui-state-active ui-corner-top\" colspan=\"3\">\n";

                echo "<table>\n<tr>\n";

                if ($object->device_name == "AFT-A101-SH" || $object->device_name == "AFT-A102-SH" || $object->device_name == "AFT-A104-SH" || $object->device_name == "AFT-A108-SH"  || $object->device_name == "AFT-A116-SH"|| $object->device_name == "AFT-B601-SH")
                {
                    //echo "i am here";
                    echo "<td align=\"left\" width=\"635px\">" . $object->device_name . " Board $span Port $count Span " . $_SESSION['span_num'] . " $card_information <img src=\"fusionpbx/checkbox.gif\" width=\"12px\" height=\"12px\"/></td>\n";
                }               
                echo "<td align=\"right\">$clear_button</td>\n";    
                echo "</tr>\n</table>\n";
                echo "</th>\n";

                echo "</td>\n";     

                echo "</tr>\n";
                echo "<td>\n";

                //HW Table if card is configured
                echo "<table height=\"47px\" width=\"110px\" class=\"mytable\">\n";
                echo "<tr align=\"center\">\n";
                echo "<td>\n";

                if ($ss7_voice[0] != "")
                {
                }       
            }
            else    
            {
                //Fresh Non Configured Port
                echo $view->port_nocfg;
                echo "<tr>\n";
                echo "<th id=\"$anchor_id\" class=\"widget-content-header ui-state-active ui-corner-top\" colspan=\"3\">\n";    
                echo "<table width=\"685px\">\n<tr>\n";

                if ($object->device_name == "AFT-A500-SH" || $object->device_name == "AFT-B700-SH")
                {       
                    echo "<td align=\"left\">" . $object->device_name . " Board $span Port " . $port[$count] . " Card Span " . $_SESSION['span_num'] . " $card_information</td>\n";                                     
                }
                elseif ($object->device_name == "AFT-A101-SH" || $object->device_name == "AFT-A102-SH" || $object->device_name == "AFT-A104-SH" || $object->device_name == "AFT-A108-SH" || $object->device_name == "AFT-A116-SH" || $object->device_name == "AFT-B601-SH")
                {
                    //echo "Wrong place";
                    echo "<td align=\"left\" >" . $object->device_name . " Board $span Port $count Span " . $_SESSION['span_num'] . "  $card_information</td>\n";
                }
                elseif ($object->device_name == "AFT-A200-SH" ||$object->device_name == "AFT-A400-SH" || $object->device_name == "AFT-B600-SH")
                {
                    echo "<td align=\"left\" >" . $object->device_name . " Board $span Port $count Span " . $_SESSION['span_num'] . "  $card_information</td>\n";                                   
                }

                echo "<td align=\"right\">$clear_button</td>\n";    
                echo "</tr>\n</table>\n";
                echo "</th>\n";

                echo "</td>\n";                 

                echo "</tr>\n";
                echo "<td>\n";                  


                //Hardware Configuration Table if nothing is configured
                echo "<table height=\"47px\" width=\"110px\" class=\"mytable\" >\n";
                echo "<tr align=\"center\">\n";
                echo "<td>\n";
            }

            //echo "<b>Physical Config</b>\n";
            echo "<b>Physical Config</b>:<br />\n";
            //echo "</td>";
            //echo "<td>";

            if ($object->device_name == "AFT-A500-SH" || $object->device_name == "AFT-B700-SH")
                echo "<input type=\"submit\" name=\"config-hw-" . $port_type[$count] . "-" . $card_name . "-". $port[$count] . "-" . $span . "\" value=\"Edit\" " . $_SESSION['button_class'] . "/>\n";
            else
            {
                if ($object->device_name == "AFT-A101-SH" || $object->device_name == "AFT-A102-SH" || $object->device_name == "AFT-A104-SH" || $object->device_name == "AFT-A108-SH")
                {
                    echo "<input type='hidden' name='last_page' value='hwprobe' />\n";
                    echo "<input type=\"submit\" name=\"config-led-" . $card_name . "-". $count . "-" . $span . "-" . $proc_id . "\" value=\"Identify\" " . $_SESSION['button_class'] . " />\n";
                }
                elseif ( $object->device_name == "AFT-A116-SH" ) {
                    echo "<input type='hidden' name='last_page' value='hwprobe' />\n";
                }
                //check if there has been a span removed and gateway is started.
                $finished_boards = $data->array_select_statement('sqlite:sqlite/cardinfo.db','finished_ports','card','');
                $generated_boards = $data->array_select_statement('sqlite:sqlite/cardinfo.db','generated_ports','card','');
                $out_of_sync = false;
                if (!empty($generated_boards)) {
                    foreach ($generated_boards as $gen_board) {
                        $found = false;
                        if (!empty($finished_boards)) {
                            foreach ($finished_boards as $fin_board) {
                                if ($fin_board['card'] == $gen_board['card']) {
                                    $found = true;
                                    break;
                                }
                            } 
                        }
                        if (!$found) {
                            $board_complete = $card_only_name . '_' . $span . '_' . $count;
                            $gateway_started = shell_exec ('pidof ' . $_SESSION['gateway_script']);
                            //`echo "board completed = $board_complete, card = " . $gen_board['card'] . " gateway = $gateway_started<br />";
                            if ($gen_board['card'] == $board_complete && trim($gateway_started) != "") {
                                $out_of_sync = true;
                                break;
                            }
                        }
                    }
                }

                if ($out_of_sync && $_SESSION['shotname'] == "NSG")
                    echo "<input type=\"submit\" name=\"config-hw-" . $card_name . "-". $count . "-" . $span . "-" . $_SESSION['span_num'] . "-" . $proc_id . "\" value=\"Edit\" " . $_SESSION['disabled_button_class'] . "/>\n";                   
                else
                    echo "<input type=\"submit\" name=\"config-hw-" . $card_name . "-". $count . "-" . $span . "-" . $_SESSION['span_num'] . "-" . $proc_id . "\" value=\"Edit\" " . $_SESSION['button_class'] . "/>\n";                                        
            }
            echo "</td>";
            echo "</tr>\n";       

            //Master Table Separations (Needed to seperate the specific tables)
            echo "</table>\n";
            echo "</td>\n";

            //echo "$hw_info[0] <br />";

            //Creates the signalling parameter box
            if ($hw_info[0] != "")
            {
                //Master Table Separations (Needed to seperate the specific tables)
                echo "<td>\n";                  

                $hash = "voice_link" . $card_name . "-" .  $span;
                $var = $card_name . "-". $count . "-" . $span;

                //If Statement for Signalling Check. If check passes, display signalling information, if it fails, display signalling options
                if ($object->device_name == "AFT-A101-SH" || $object->device_name == "AFT-A102-SH" || $object->device_name == "AFT-A104-SH" || $object->device_name == "AFT-A108-SH" || $object->device_name == "AFT-A116-SH" || $object->device_name == "AFT-B601-SH" && $count == 1)
                {       
                    if ($_SESSION['msbg'] == "yes")
                    {   
                        if (($ss7_info[0] != "" && $hw_info[0] == $ss7_info[1]) || ($ss7_m2ua_info[0] != "" && $hw_info[0] == $ss7_m2ua_info[1]) || ($hw_info[0] != "" && $ss7_mg_info[0] != ""))
                        {   
                            //Do Nothing
                            //SS7 or M2UA
                        }
                        elseif ($sig_info[0] != "" && $hw_info[0] == $sig_info[0])
                        {
                            //Do Nothing
                            //PRI
                        }
                        else
                        {
                            //Empty Configuration
                            echo $view->sig_ss7cfgtablet1e1;
                            echo "<tr>\n";  
                            echo "<td>\n";
                            echo "<select name=\"signal-$card_name-$count-$span\">\n";
                            echo "<option value=\"PRI\">PRI</option>\n";

                            if ($_SESSION['dahdi'] != "True")
                            {   
                                echo "<option value=\"SS7\" ";
                                if ($ss7_info[0] != "" )
                                { 
                                    echo "selected=selected"; 
                                } 
                                echo ">SS7</option>\n";
                            }
                            if ($hw_info[0] == "E1" && $hw_info[8] == "CAS")
                            {
                                echo "<option value=\"CAS\">CAS</option>\n";                       
                            }
                            echo "</select>\n";                             
                        }
                    }
                    elseif ($_SESSION['nbess7'] =="yes")
                    {

                        if (($ss7_info[0] != "" && $hw_info[0] == $ss7_info[1]) || ($ss7_m2ua_info[0] != "" && $hw_info[0] == $ss7_m2ua_info[1]) || ($hw_info[0] != "" && $ss7_mg_info[0] != "") || ($sig_info[0] != "" && $hw_info[0] == $sig_info[0]) || ($r2_info[0] != "" && $hw_info[0] == $r2_info[0]) )
                        {
                            //Do Nothing
                        }
                        else
                        {
                            //Empty Configuration
                            echo $view->ss7cfgtablet1e1;                            
                            echo "<tr>\n";  
                            echo "<td colspan=\"5\" align=\"left\">\n";
                            //echo "<b>SS7</b>\n";
                            echo "</td>\n";
                            echo "</tr>\n";
                            echo "<tr>\n<td>\n";
                            if (($ss7_info[0] != "" && $hw_info[0] == $ss7_info[1]) || ($ss7_m2ua_info[0] != "" && $hw_info[0] == $ss7_m2ua_info[1]) || ($hw_info[0] != "" && $ss7_mg_info[0] != "") || ($sig_info[0] != "" && $hw_info[0] == $sig_info[0]) || ($r2_info[0] != "" && $hw_info[0] == $r2_info[0]) )
                            {
                            }
                            else
                                echo "Link Config:";
                        }
                    }
                    //Check to see if the Port is configured for the right signalling profile
                    if ($sig_info[0] != "" && $hw_info[0] == $sig_info[0] && $_SESSION['msbg'] == "yes")
                    {
                        //T1/E1 Signalling Table
                        echo $view->sig_ss7cfgtablet1e1;
                        echo "<tr>\n";  
                        echo "<td>\n";
                        echo "<select name=\"signal-$card_name-$count-$span\">\n";
                        echo "<option value=\"PRI\">PRI</option>\n";

                        if ($_SESSION['dahdi'] != "True")
                        {   
                            echo "<option value=\"SS7\" ";
                            if ($ss7_info[0] != "" )
                                echo "selected=selected"; 
                            echo ">SS7</option>\n";
                        }
                        if ($hw_info[0] == "E1" && $hw_info[8] == "CAS")
                        {
                            echo "<option value=\"CAS\">CAS</option>\n";                       
                        }
                        echo "</select>\n"; 

                        echo "\t\t\t\t<br /><b>Profile:</b>\n\n";
                        if ($object->device_name == "AFT-B601-SH" && $count == 1)
                        {
                            echo "\t\t\t\t$sig_info[2]\n";
                        }
                        else
                        {
                            echo "\t\t\t\t$sig_info[1]\n";                              
                        }
                    }   
                    elseif (($ss7_info[0] != "" && $hw_info[0] == $ss7_info[1]) || ($ss7_m2ua_info[0] != "" && $hw_info[0] == $ss7_m2ua_info[1]) || ($sig_info[0] != "" && $hw_info[0] == $sig_info[0]) || ($r2_info[0] != "" && $hw_info[0] == $r2_info[0]) )
                    {
                        //SS7 Table
                        if ($_SESSION['msbg'] == "yes")
                        {
                            echo $view->ss7cfgtablet1e1;
                            echo "<tr>\n";  
                            echo "<td>\n";
                            echo "<select name=\"signal-$card_name-$count-$span\">\n";
                            echo "<option value=\"PRI\">PRI</option>\n";

                            if ($_SESSION['dahdi'] != "True")
                            {   
                                echo "<option value=\"SS7\" ";
                                if ($ss7_info[0] != "" )
                                    echo "selected=selected"; 
                                echo ">SS7</option>\n";
                            }
                            if ($hw_info[0] == "E1" && $hw_info[8] == "CAS")
                                echo "<option value=\"CAS\">CAS</option>\n";                       

                            echo "</select>\n";

                            echo "<br />\n";

                            if ($ss7_voice[0] == "")
                                echo "<b>Link:</b>\n";
                            elseif (($sig_info[0] != "" && $hw_info[0] == $sig_info[0]))
                                echo "<b>PRI:</b>\n";
                            else
                                echo "<b>Voice:</b>\n";

                            echo "$ss7_info[0]\n<br />\n";  
                            echo "</td>\n";                             
                        }
                        elseif ($_SESSION['nbess7'] == "yes") 
                        {
                            //Embedded mode
                            echo $view->ss7cfgtablet1e1;
                            echo "<tr>\n";  
                            echo "<td colspan=\"5\" align=\"left\">\n";
                            if ( $ss7_m2ua_info[0] != "" && $hw_info[0] == $ss7_m2ua_info[1])
                                echo "<b>M2UA SG</b>\n";
                            elseif ($ss7_info[0] != "" && $hw_info[0] == $ss7_info[1])
                                echo "<b>SS7</b>\n";
                            elseif (($sig_info[0] != "" && $hw_info[0] == $sig_info[0]))
                                echo "<b>PRI</b>\n";
                            elseif (($r2_info[0] != "" && $hw_info[0] == $r2_info[0]))                                  
                                echo "<b>MFC/R2</b>\n";

                            echo "</td>\n</tr>\n";
                            echo "<tr>\n<td>\n";
                            if (($sig_info[0] != "" && $hw_info[0] == $sig_info[0]))
                                echo "<b>Profile:</b>";
                            elseif (($r2_info[0] != "" && $hw_info[0] == $r2_info[0]))
                                echo "<b>Profile:</b>";
                            elseif ($ss7_voice[0] == "" || $ss7_m2ua_info[0] != "")
                                echo "<b>Link:</b>";
                            else
                                echo "<b>Voice:</b>";

                            if ($ss7_m2ua_info[0] != "")
                                echo "\t\t\t\t$ss7_m2ua_info[0]\n<br />\n"; 
                            elseif($sig_info[1]!= "") 
                                echo "$sig_info[1]<br />";
                            elseif ($r2_info[1]!= "")
                                echo "$r2_info[1]<br />";
                            else
                                echo "\t\t\t\t$ss7_info[0]\n<br />\n";  
                        }
                    }
                    elseif ($hw_info[0] != "" && $ss7_mg_info[0] != "") {
                        //MG Link
                        if ($_SESSION['nbess7'] == "yes") 
                        {
                            //Embedded mode
                            echo $view->ss7cfgtablet1e1;
                            /*echo "<tr>\n";    
                              echo "<td colspan=\"5\" align=\"left\">\n";
                              echo "<b>MG Profile:</b>\n";
                              echo "</td>\n</tr>\n";
                              echo "<tr>\n<td>\n";
                            //echo "\t\t\t\t<b>Profile:</b>\n\n";
                            echo "\t\t\t" . $ss7_mg_info[1] . "\n<br />\n"; */
                        }                           
                    }
                    elseif (($ss7_info[0] != "" && $hw_info[0] != $ss7_info[1]) || ($ss7_m2ua_info[0] != "" && $hw_info[0] != $ss7_m2ua_info[1]))
                    {
                        //Remove the line out of the signalling database
                        //echo $view->sig_ss7cfgtablet1e1;
                        //echo "<tr>\n";    
                        //echo "<td>\n";                            

                        //Profile cannot be used message for SS7
                        if ($ss7_m2ua_info[0] != "")
                            $table_name = $card_only_name . "_" . $span . "_m2ua_link";
                        elseif ($ss7_mg_info[0] != "")
                            $table_name = $card_only_name . "_" . $span . "_m2ua_channels";
                        else
                            $table_name = $card_only_name . "_" . $span . "_SS7_link";

                        $parameters = "port_id = " . $count;
                        $data->delete_generic($db_location, $table_name, $parameters);
                        echo "<font color=\"#FF0000\">ERROR: Media type changed</font>\n";  
                        unset ($ss7_info[0]);                                               
                    }
                    elseif (($sig_info[0] != "" && $hw_info[0] != $sig_info[0]) || ($r2_info[0] != "" && $hw_info[0] != $r2_info[0]) )
                    {
                        //Profile cannot be used message for T1/E1
                        //echo $view->sig_ss7cfgtablet1e1;
                        //echo "<tr>\n";    
                        //echo "<td>\n";

                        //Remove the line out of the signalling database
                        if ($r2_info[0] != "" && $hw_info[0] == $r2_info[0])
                            $table_name = $card_only_name . "_" . $span . "_r2_signalling";
                        else 
                            $table_name = $card_only_name . "_" . $span . "_signalling";

                        $parameters = "port_id = " . $count;
                        $data->delete_generic($db_location, $table_name, $parameters);
                        if ($object->device_name == "AFT-B601-SH" && $count == 1)
                        {   
                            echo "<br /><font color=\"#FF0000\"><b>$sig_info[2]</b> cannot be used on this port</font><br />\n";                                                    
                            unset ($sig_info[0]);       
                            unset($r2_info[0]);                         
                        }
                        else
                        {
                            if (($r2_info[0] != "" && $hw_info[0] == $r2_info[0]))
                                echo "<br /><font color=\"#FF0000\"><b>$r2_info[1]</b> cannot be used on this port</font><br />\n"; 
                            else
                                echo "<br /><font color=\"#FF0000\"><b>$sig_info[1]</b> cannot be used on this port</font><br />\n";    
                            unset ($sig_info[0]);                       
                            unset($r2_info[0]);
                        }
                    }
                    echo "\t\t\t</td>";
                    $relay_type = $data->select_statement('sqlite:sqlite/relay_info.db','ss7_relay','machine_type,relay_type',"");

                    if (($hw_info[0] != "" && $ss7_mg_info[0] != "") && ($hw_info[0] != "" && $ss7_mg_info[0] != "" && $ss7_m2ua_info[2] == "")) {

                    }
                    else
                        echo "\t\t\t<td align=\"right\"><input type=\"submit\" name=\"config-sig-" . $card_name . "-". $count . "-" . $span . "-" . $_SESSION['span_num'] . "-" . $hw_info[0] . "-" . $proc_id . "\" value=\"Edit\" " . $_SESSION['button_class'] . "/></td>\n";



                    if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
                    {

                        if (($ss7_info[0] != "" && $hw_info[0] == $ss7_info[1]))
                        {
                            //Do Nothing
                        }
                        elseif($ss7_m2ua_info[0] != "" && $hw_info[0] == $ss7_m2ua_info[1])
                        {
                        }
                        elseif ($hw_info[0] != "" && $ss7_mg_info[0] != "")
                        {
                        }
                        elseif ($sig_info[0] != "" && $hw_info[0] == $sig_info[0]) {
                        }
                        elseif (($r2_info[0] != "" && $hw_info[0] == $r2_info[0]))
                        {
                        }
                        else
                        {
                            //Empty Configuration
                            echo $view->voice_link_td_notcfg;
                        }
                    }                                                       
                }   
                elseif ($object->device_name == "AFT-A500-SH" || $object->device_name == "AFT-B700-SH") 
                {
                    echo $view->sig_ss7cfgtable;
                    echo "\t\t<tr>\n";  
                    echo "\t\t\t<td>\n";    

                    //$db_location = "sqlite:sqlite/cardinfo.db";
                    if ($port_type[$count] == "NT" || $port_type[$count] == "TE")
                    {
                        echo "<strong>BRI Profile</strong>:\n";
                        //Checks to see if the port is configured for the right signalling profile
                        if ($sig_info[0] != "" && $sig_info[1] == $port_type[$count])
                        {
                            echo "\t\t\t\t$sig_info[0]\n";
                        }
                        elseif ($sig_info[0] != "" && $sig_info[1] != $port_type[$count])
                        {
                            //Remove the line out of the signalling database
                            $table_name = $card_only_name . "_" . $span . "_signalling";
                            $parameters = "id = " . $port[$count];
                            $data->delete_generic($db_location, $table_name, $parameters);
                            echo "\t\t\t\t <font color=\"#FF0000\"><b>$sig_info[0]</b> cannot be used on this port</font>\n";
                        }
                    }
                    if ($port_type[$count] == "FXO" || $port_type[$count] == "FXS")
                    {
                        echo "<strong>Analog Profile</strong>:\n";

                        //Checks to see if the port is configured for the right signalling profile
                        if ($sig_info[0] != "")
                        {
                            echo "\t\t\t\t$sig_info[0]\n";
                        }
                    }
                    echo "\t\t\t</td>";
                    echo "\t\t\t<td align=\"right\"><input type=\"submit\" name=\"config-sig-" . $port_type[$count] . "-" . $card_name . "-". $port[$count] . "-" . $span . "\" value=\"Edit\" " . $_SESSION['button_class'] . "/></td>\n";                 
                }
                elseif ($object->device_name == "AFT-A200-SH" || $object->device_name == "AFT-A400-SH" || $object->device_name == "AFT-B600-SH") 
                {
                    echo $view->sig_ss7cfgtable;
                    echo "\t\t<tr>\n";  
                    echo "\t\t\t<td>\n";    

                    echo "<strong>Analog Profile</strong>:\n";

                    //Checks to see if the port is configured for the right signalling profile
                    if ($sig_info[0] != "")
                        echo "\t\t\t\t$sig_info[0]\n";

                    echo "\t\t\t</td>";
                    echo "\t\t\t<td align=\"right\"><input type=\"submit\" name=\"config-sig-" . $card_name . "-". $count . "-" . $span . "\" value=\"Edit\" " . $_SESSION['button_class'] . "/></td>\n";                   
                }
                elseif ($object->device_name == "AFT-B601-SH" && $count == 2)
                {
                    echo $view->sig_ss7cfgtable;
                    echo "\t\t<tr>\n";  
                    echo "\t\t\t<td>\n";    

                    echo "<strong>Analog Profile</strong>:\n";

                    //Checks to see if the port is configured for the right signalling profile
                    if ($sig_info[1] != "")
                    {
                        echo "\t\t\t\t$sig_info[1]\n";
                    }

                    echo "\t\t\t</td>";
                    echo "\t\t\t<td align=\"right\"><input type=\"submit\" name=\"config-sig-" . $card_name . "-". $count . "-" . $span . "\" value=\"Edit\" " . $_SESSION['button_class'] . "/></td>\n";                   
                }

                //Ends the sig table if you are using fusionpbx and its not an ss7 link
                if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
                {
                    //FusionPBX
                    if ($ss7_info[0] == "" && $ss7_m2ua_info[0] == "" && $ss7_mg_info[0] == "")
                    {
                        echo "</tr>\n";
                        echo "</table>\n";      
                    }
                }
                elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
                {
                    if ($ss7_info[0] == ""  && $ss7_m2ua_info[0] == "" && $ss7_mg_info[0] == "" && $sig_info[0] == "" && $r2_info[0] == "")
                    {
                        //ClearOS when no sig/voice link is created
                        echo "</tr>\n";
                        echo "</table>\n";
                        echo "<td>\n";
                        //No CCSPANS Section yet
                        echo $view->ccspan_notconfigured;

                        //echo "\t\t\t<tr>\n";
                        echo "<td>\n";
                        echo "</td>\n";
                        echo "</tr>\n";
                        echo "</table>\n";  
                    }
                }
                //echo "$sig_info[0] , $hw_info[3], $sig_info[4]<br />";
                //echo $sig_info[0] . " = " . $hw_info[3] .  " = " . $sig_info[4];
                //Redirects to the ss7_display_class for that port
                if ($ss7_info[0] != "" || $ss7_m2ua_info[0] != "" || $ss7_mg_info[0] != "")
                {   
                    $relay_type = $data->select_statement('sqlite:sqlite/relay_info.db','ss7_relay','machine_type',"");
                    if ($relay_type['machine_type'] == "standalone")
                        $ss7_class->proc_id = 1;
                    else
                        $ss7_class->proc_id = $proc_id;

                    $ss7_class->card_num = $span;
                    $ss7_class->port_count = $count;
                    $ss7_class->card_name = $card_name;
                    $ss7_class->line_type = $hw_info[0];
                    //$ss7_class->proc_id = $proc_id;
                    //echo "Proc = " . $proc_id . "<br />";
                    $ss7_class->span_counter = $span_counter;

                    //redirect to the main display for ss7
                    $ss7_class->main();
                }
                //Goes to channel Mapping/Context/Group Numbering
                elseif ($sig_info[0] != "" && $hw_info[0] == $sig_info[0] || $sig_info[0] != "" && $sig_info[1] == $port_type[$count] || $sig_info[0] != "" && $hw_info[3] == $sig_info[4] ||$sig_info[1] != "" && $hw_info[9] == $sig_info[4] || ($r2_info[0] != "" && $hw_info[0] == $r2_info[0]))
                {
                    //Master Table Separations (Needed to seperate the specific tables)
                    echo "</td>\n";
                    if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
                        echo "</table>\n";

                    echo "<td>\n";                  
                    //Channels Table
                    //Figures out default channel maps

                    if ($object->device_name == "AFT-A101-SH" || $object->device_name == "AFT-A102-SH" || $object->device_name == "AFT-A104-SH" || $object->device_name == "AFT-A108-SH" || $object->device_name == "AFT-A116-SH")
                    {
                        if (($r2_info[0] != "" && $hw_info[0] == $r2_info[0])) {
                            //R2 Signalling
                            if ($r2_info[2] != "")
                                //Takes the channels from the database
                                $channels = $r2_info[2];
                            else
                            {
                                if ($hw_info[0] == "T1")
                                    $channels = "1-23";
                                elseif ($hw_info[0] == "E1")
                                    $channels = "1-15,17-31";
                            }

                            //Figures out the group number
                            if (isset($r2_info[3]))
                                $group = $r2_info[3];
                            elseif ($r2_info[3] == "")
                                $group = 1 + $_SESSION['group'];
                            $_SESSION['group'] = $group;
                            $_SESSION['group'] = $group;
                        }
                        else {
                            //PRI Signalling
                            if ($sig_info[2] != "")
                                //Takes the channels from the database
                                $channels = $sig_info[2];
                            else
                            {
                                if ($hw_info[0] == "T1")
                                    $channels = "1-23";
                                elseif ($hw_info[0] == "E1")
                                    $channels = "1-15,17-31";
                            }

                            //Figures out the group number
                            if (isset($sig_info[3]))
                                $group = $sig_info[3];
                            elseif ($sig_info[3] == "")
                                $group = 1 + $_SESSION['group'];
                            $_SESSION['group'] = $group;
                            $_SESSION['group'] = $group;
                        }
                    }
                    elseif ($object->device_name == "AFT-B601-SH" && $count == 1)
                    {
                        if ($sig_info[9] != "")
                        {
                            //Takes the channels from the database
                            $channels = $sig_info[9];
                        }
                        else
                        {
                            //echo "Not Found<br />";

                            if ($hw_info[0] == "T1")
                                $channels = "1-23";
                            elseif ($hw_info[0] == "E1")
                                $channels = "1-15,17-31";
                        }

                        //Figures out the group number
                        if (isset($sig_info[3]))
                            $group = $sig_info[3];
                        elseif ($sig_info[3] == "")
                            $group = 1 + $_SESSION['group'];
                        $_SESSION['group'] = $group;
                        $_SESSION['group'] = $group;                            
                    }
                    elseif ($object->device_name == "AFT-A500-SH") 
                    {   
                        if ($sig_info[3] != "")
                            //Takes the channels from the database
                            $channels = $sig_info[3];
                        else
                            $channels = "1-2";

                        //Figures out the group number
                        if (isset($sig_info[4]))
                            $group = $sig_info[4];
                        elseif ($sig_info[4] == "") {
                            $group = 1 + $_SESSION['group'];
                            $_SESSION['group'] = $group;
                        }
                        $_SESSION['group'] = $group;                            
                    }
                    elseif ($object->device_name == "AFT-B700-SH")
                    {
                        //echo $port_type[$count] . "<br />";
                        if ($port_type[$count] == "TE" || $port_type[$count] == "NT")
                        {
                            if ($sig_info[3] != "")
                                //Takes the channels from the database
                                $channels = $sig_info[3];
                            else
                                $channels = "1-2";

                            //Figures out the group number
                            if (isset($sig_info[4]))
                                $group = $sig_info[4];
                            elseif ($sig_info[4] == "")
                            {   
                                $group = 1 + $_SESSION['group'];
                                $_SESSION['group'] = $group;
                            }
                            $_SESSION['group'] = $group;                                                            
                        }
                        elseif ($port_type[$count] == "FXO" || $port_type[$count] == "FXS")
                        {
                            //Figures out the group number
                            if ($sig_info[4] != "")
                                $group = $sig_info[4];
                            elseif ($sig_info[4] == "") {
                                $group = 1 + $_SESSION['group'];
                                $_SESSION['group'] = $group;
                            }

                            $_SESSION['group'] = $group;                                    
                        }
                    }
                    elseif ($object->device_name == "AFT-A200-SH" || $object->device_name == "AFT-A400-SH" || $object->device_name == "AFT-B600-SH" || $object->device_name == "AFT-B601-SH" && $count == 2) 
                    {   
                        //Figures out the group number
                        if ($sig_info[3] != "")
                            $group = $sig_info[3];
                        elseif ($sig_info[3] == "") {
                            $group = 1 + $_SESSION['group'];
                            $_SESSION['group'] = $group;
                        }

                        $_SESSION['group'] = $group;                            
                    }

                    //Table headings for the Channel Map Table (Non SS7)
                    if ($object->device_name == "AFT-A200-SH" || $object->device_name == "AFT-A400-SH" || $object->device_name == "AFT-B600-SH" || $object->device_name == "AFT-B601-SH" && $count == 2)
                        echo $view->chan_analog;
                    elseif ($object->device_name == "AFT-B700-SH" && $port_type[$count] == "FXS" || $port_type[$count] == "FXO")
                        echo $view->chan_brianalog;
                    else
                        echo $view->chan_t1e1_bri;

                    echo "<tr>\n";
                    echo "<td>\n";                  
                    echo $view->pribrianalogchan;
                    echo "<tr>\n";

                    if ($object->device_name == "AFT-A101-SH" || $object->device_name == "AFT-A102-SH" || $object->device_name == "AFT-A104-SH" || $object->device_name == "AFT-A108-SH" || $object->device_name == "AFT-A116-SH" || $object->device_name == "AFT-A500-SH" || $object->device_name == "AFT-B601-SH" && $count == 1)
                        echo "<td align=\"center\"><b>Channel Map</b></td>\n";
                    elseif ($object->device_name == "AFT-B700-SH" && $port_type[$count] == "NT" || $port_type[$count] == "TE")
                        echo "<td align=\"center\"><b>Channel Map</b></td>\n";

                    //COMMENTED OUT TEMPORARILY UNTIL PROPER GROUP SETUP DONE FOR ALL PROTOCOLS
                    echo "<td align=\"center\"><b>Span Group</b></td>\n";

                    //Shows the context table if the customer is using Dahdi/Asterisk
                    if ($_SESSION['dahdi'] == "True")
                        echo "<td align=\"center\">Context</td>\n";

                    //Submit button for this box
                    echo "\t\t<tr>\n";
                    if ($object->device_name == "AFT-A101-SH" || $object->device_name == "AFT-A102-SH" || $object->device_name == "AFT-A104-SH" || $object->device_name == "AFT-A108-SH" || $object->device_name == "AFT-A116-SH" || $object->device_name == "AFT-B601-SH" && $count == 1)
                    {
                        //echo "\t\t\t<td align=\"center\"><input type=\"text\" name=\"channel-map-" . $card_name . "-". $count . "-" . $span . "\" style=\"text-align:right; width:100px\" value=\"$channels\" readonly=\"readonly\" /></td>\n";
                        echo "<td align=\"center\">$channels</td>\n";
                        echo "<td align=\"center\"><input type=\"text\" name=\"group-" . $card_name . "-" . $count . "-" . $span . "\" value=\"" . $group . "\" style=\"text-align:right; width:30px; height: 15px\" /></td>\n";
                        if (($r2_info[0] != "" && $hw_info[0] == $r2_info[0]))
                            echo '<input type="hidden" name="span_type_'.$count.'_'.$span.'" value="r2_'.$count.'_'.$span.'" />';
                    }
                    elseif ($object->device_name == "AFT-A500-SH" || $object->device_name == "AFT-B700-SH" )
                    {
                        if ($port_type[$count] == "NT" || $port_type[$count] == "TE")
                        {
                            //echo "\t\t\t<td align=\"center\"><input type=\"text\" name=\"channel-map-" . $card_name . "-". $port[$count] . "-" . $span . "\" value=\"$channels\" readonly=\"readonly\" style=\"text-align:right; width:100px\" /></td>\n";
                            echo "<td align=\"center\">$channels</td>\n";
                        }
                        echo "\t\t\t<td align=\"center\"><input type=\"text\" name=\"group-" . $card_name . "-" . $port[$count] . "-" . $span . "\" value=\"" . $group . "\" style=\"text-align:right; width:30px; height: 15px\" /></td>\n";                           
                    }
                    elseif ($object->device_name == "AFT-A200-SH" || $object->device_name == "AFT-A400-SH" || $object->device_name == "AFT-B600-SH" || $object->device_name == "AFT-B601-SH" && $count == 2)
                    {
                        echo "\t\t\t<td align=\"center\"><input type=\"text\" name=\"group-" . $card_name . "-" . $count . "-" . $span . "\" value=\"" . $group . "\" style=\"text-align:right; width:30px; height: 15px\" /></td>\n";
                    }

                    //Shows the context table if the customer is using Dahdi/Asterisk
                    if ($_SESSION['dahdi'] == "True")
                    {
                        //Figures out the context entered
                        if ($object->device_name == "AFT-A101-SH" || $object->device_name == "AFT-A102-SH" || $object->device_name == "AFT-A104-SH" || $object->device_name == "AFT-A108-SH" || $object->device_name == "AFT-A116-SH")
                        {
                            if ($sig_info[4] != "")
                                $context = $sig_info[4];
                            else
                                $context = "from-port" . $port;
                            echo "\t\t\t<td align=\"center\"><input type=\"text\" name=\"context-" . $card_name . "-". $count . "-" . $span . "\" style=\"width:90px; height: 15px\" value=\"" . $context . "\" /></td>\n";                             
                        }
                        elseif ($object->device_name == "AFT-A200-SH" || $object->device_name == "AFT-A400-SH" || $object->device_name == "AFT-B600-SH" || $object->device_name == "AFT-B601-SH")
                        {
                            if ($sig_info[5] != "")
                                $context = $sig_info[5];
                            else
                                $context = "from-" . $card_only_name . "-" . $span;

                            echo "\t\t\t<td align=\"center\"><input type=\"text\" name=\"context-" . $card_name . "-". $count . "-" . $span . "\" style=\"width:90px; height: 15px\" value=\"" . $context . "\" /></td>\n";                             
                        }
                        elseif ($object->device_name == "AFT-A500-SH")
                        {
                            if ($sig_info[5] != "")
                                $context = $sig_info[5];
                            else
                                $context = "from-port" . $port[$count];

                            echo "\t\t\t<td align=\"center\"><input type=\"text\" name=\"context-" . $card_name . "-". $port[$count] . "-" . $span . "\" style=\"width:90px; height: 15px\" value=\"" . $context . "\" /></td>\n";                              
                        }
                        elseif ($object->device_name == "AFT-B700-SH")
                        {
                            if ($port_type[$count] == "FXS" || $port_type[$count] == "FXO")
                            {
                                if ($sig_info[5] != "")
                                    $context = $sig_info[5];
                                else
                                    $context = "from-" . $card_only_name . "-" . $span;

                                echo "\t\t\t<td align=\"center\"><input type=\"text\" name=\"context-" . $card_name . "-". $count . "-" . $span . "\" style=\"width:90px; height: 15px\" value=\"" . $context . "\" /></td>\n";                             
                            }
                            elseif ($port_type[$count] == "NT" || $port_type[$count] == "TE")
                            {
                                if ($sig_info[5] != "")
                                    $context = $sig_info[5];
                                else
                                    $context = "from-port" . $port[$count];

                                echo "\t\t\t<td align=\"center\"><input type=\"text\" name=\"context-" . $card_name . "-". $port[$count] . "-" . $span . "\" style=\"width:90px; height: 15px\" value=\"" . $context . "\" /></td>\n";                                  
                            }
                        }
                    }

                    //COMMENTED OUT TEMPORARILY UNTIL PROPER GROUP SETUP DONE FOR ALL PROTOCOLS
                    if ($object->device_name == "AFT-A101-SH" || $object->device_name == "AFT-A102-SH" || $object->device_name == "AFT-A104-SH" || $object->device_name == "AFT-A108-SH" || $object->device_name == "AFT-A116-SH" || $object->device_name == "AFT-A200-SH" || $object->device_name == "AFT-A400-SH" || $object->device_name == "AFT-B600-SH"|| $object->device_name == "AFT-B601-SH")   
                        echo "<td rowspan=2 align=\"right\"><input type=\"submit\" name=\"config-accept-" .  $card_name . "-". $count . "-" . $span . "\" value=\"Accept\" " . $_SESSION['button_class'] . "/></td>\n";
                    elseif ($object->device_name == "AFT-A500-SH" || $object->device_name == "AFT-B700-SH")
                        echo "<td rowspan=2 align=\"right\"><input type=\"submit\" name=\"config-accept-" .   $port_type[$count] . "-" .$card_name . "-". $port[$count] . "-" . $span . "\" value=\"Accept\" " . $_SESSION['button_class'] . " /></td>\n";                          


                    echo "\t\t</tr>\n";
                    echo "\t</table>\n";    

                    //Master Table Separations (Needed to seperate the specific tables)
                    echo "\t\t</td>\n";
                    //echo "\t\t<td>\n";    

                    //Shows the submit buttons if all the required information is taken
                    //echo "\t<input type=\"submit\" name=\"save-" . $card_name . "-". $count . "-" . $span . "\" value=\"Save Config\" /></td>\n";

                    //Autosaves the channel/group/context information into the signalling database
                    //Tokenize card name so that it can be passed as the table name
                    $name = $tokenization->token_name($card_name);

                    //Final completion. Place in database and tell the page to display an anchor and the generate configuration button
                    if ($object->device_name == "AFT-A200-SH" || $object->device_name == "AFT-A400-SH" || $object->device_name == "AFT-B600-SH" || $object->device_name == "AFT-B601-SH" && $count == 2)
                        $port_type2 = "Analog";
                    elseif ($object->device_name == "AFT-B700-SH" && $port_type[$count] == "FXS" || $port_type[$count] == "FXO")                        
                        $port_type2 = "Analog";
                    elseif ($object->device_name == "AFT-A101-SH" || $object->device_name == "AFT-A102-SH" || $object->device_name == "AFT-A104-SH" || $object->device_name == "AFT-A108-SH" || $object->device_name == "AFT-A116-SH" ||  $object->device_name == "AFT-B601-SH" && $count == 1)
                    {
                        if (($r2_info[0] != "" && $hw_info[0] == $r2_info[0]))
                            $port_type2 = "MFC/R2";
                        else
                            $port_type2 = "PRI";

                    }
                    elseif ($object->device_name == "AFT-A500-SH" || $object->device_name == "AFT-B700-SH" && $port_type[$count] == "NT" || $port_type[$count] == "TE")
                        $port_type2 = "BRI";

                    if (($r2_info[0] != "" && $hw_info[0] == $r2_info[0]))
                        $table_name = $name.'_'.$span.'_r2_signalling';
                    else
                        $table_name = $name . "_" . $span . "_signalling";

                    if ($object->device_name == "AFT-A101-SH" || $object->device_name == "AFT-A102-SH" || $object->device_name == "AFT-A104-SH" || $object->device_name == "AFT-A108-SH" || $object->device_name == "AFT-A116-SH" || $object->device_name == "AFT-B601-SH" && $count == 1)  
                    {                       
                        if ($_SESSION['dahdi'] != "")
                        {
                            $param = "channels = \"" . $channels . "\", group_num = \"" . $group . "\", context = \"" . $context . "\"";    
                            $where_param = "port_id = " . $count;
                        }
                        if ($_SESSION['freetdm'] != "")
                        {
                            $param = "channels = \"" . $channels . "\", group_num = \"" . $group . "\"";
                            $where_param = "port_id = " . $count;                           
                        }
                    }
                    elseif ($object->device_name == "AFT-A500-SH" || $object->device_name == "AFT-B700-SH")
                    {
                        if ($_SESSION['dahdi'] != "")
                        {
                            $param = "channels = \"" . $channels . "\", group_num = \"" . $group . "\", context = \"" . $context . "\"";    
                            $where_param = "id = " . $port[$count];
                        }
                        if ($_SESSION['freetdm'] != "")
                        {
                            $param = "channels = \"" . $channels . "\", group_num = \"" . $group . "\"";
                            $where_param = "id = " . $port[$count];                         
                        }                           
                    }
                    elseif ($object->device_name == "AFT-A200-SH" || $object->device_name == "AFT-A400-SH" || $object->device_name == "AFT-B600-SH")
                    {
                        if ($_SESSION['dahdi'] != "")
                        {
                            $param = "group_num = \"" . $group . "\", context = \"" . $context . "\"";  
                            $where_param = "port_id = 1";
                        }
                        if ($_SESSION['freetdm'] != "")
                        {
                            $param = "group_num = \"" . $group . "\"";
                            $where_param = "port_id = 1";                           
                        }                           
                    }
                    elseif ($object->device_name == "AFT-B601-SH" && $count == 2)
                    {
                        if ($_SESSION['dahdi'] != "")
                        {
                            $param = "group_num = \"" . $group . "\", context = \"" . $context . "\"";  
                            $where_param = "port_id = $count";
                        }
                        if ($_SESSION['freetdm'] != "")
                        {
                            $param = "group_num = \"" . $group . "\"";
                            $where_param = "port_id = $count";                          
                        }                               
                    }

                    //Updates the signalling table with default values
                    $data->update_table ($db_location, $table_name, $param, $where_param);  

                    $_SESSION['span_counter']++;
                    //Save the completed port configurtion within the finished ports table in order to display the generate configuration button
                    //$db_location = "sqlite:sqlite/cardinfo.db";
                    /*$table = "finished_ports";
                      $insert = "id, card, completed, type";

                      $check_for_entry = $data->select_statement($db_location,$table,$insert,'id='.$_SESSION['span_counter']);
                      $insert_card = $card_only_name . "_" . $span . "_" . $count;

                      if ($check_for_entry['id'] == "") {
                    //name_num_portnum
                    $insert_values = $_SESSION['span_counter'] . ", \"" . $insert_card . "\", \"yes\",\"" .  $port_type2 . "\"";
                    $data->insert_statement($db_location, $table, $insert, $insert_values); 
                    //echo $port_type2 . "<br />";      
                    }
                    else {
                    // update_table ($db_location, $table_name, $parameters, $where_param)
                    $update_values = 'card="'.$insert_card.'",type="'.$port_type2.'"';
                    $data->update_table($db_location,$table,$update_values,'id='.$_SESSION['span_counter']);
                    }*/
                }
                else
                {
                    if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
                    {
                        echo "\t\t<td>\n";
                        echo $view->emptytablechan2;
                        echo "<tr>\n";
                        echo "<td></td>\n";
                        echo "</tr>\n";
                        echo "</table>\n";
                    }
                }                       
            }
            elseif ($hw_info[0] == "" || $no_echo != "yes")
            {
                //Master Table Separations (Needed to seperate the specific tables)
                echo "\t\t<td>\n";  
                echo $view->emptytable;
                echo "<tr>\n";
                echo "<td></td>\n";
                echo "</tr>\n";
                echo "</table>\n";
                echo "\t\t<td>\n";  
                echo $view->emptytablechan;
                echo "<tr>\n";
                echo "<td></td>\n";
                echo "</tr>\n";
                echo "</table>\n";
            }

            //Master Table (Closes the entire table)
            //echo "\t\t\t</td>\n";

            echo "</tr>\n";
            echo "</table>\n";      
        }
    }
}

//Contains all the PRI Profile Creation Class information
class config_PRI_Profiles
{
    public $data = "";

    //Displays  Create/Edit Profile for PRI Configuration
    function display_PRI_profile_options ($edit, $error, $_REQUEST)
    {
        if ($edit['id'] != "") {
            //Clicked on EDIT
            $a = $edit['id'];
            $edit_profile = true;
        }
        else {
            $count = $this->data->select_statement('sqlite:../sqlite/cardinfo.db','t1e1_profile','count(id)','');
            //find total profiles
            $a = $count['count(id)'] + 1;
            $edit_profile = false;
        }
        /*elseif ($_SESSION['profile_pri_num'] == "")
          $a = 1;
          elseif ($_SESSION['profile_pri_num'] != "") {
          $a = $_SESSION['profile_pri_num'];
          $a++;
          }*/

        if ($_SESSION['id_num'] == "") { echo"<h3>" . $_SESSION['line_type'] . " Profile Creation</h3>"; } else { echo "<h3>" . $_SESSION['line_type'] . " Profile Editing</h3>"; } 

        if ($edit['ton_name'] != "" || $edit['ton_value'] != "" || $edit['npi_name'] != "" || $edit['npi_value'] != "")
        {
            $tok = strtok($edit['ton_name'], ",");

            $count = 0;
            while ($tok !== false) 
            {
                $token[$count] = $tok;
                $tok = strtok(",");
                $count++;
            }   

            $edit['ton_name1'] = $token[0];
            $edit['ton_name2'] = $token[1];
            $edit['ton_name3'] = $token[2];

            $token = "";        
            $tok = strtok($edit['ton_value'], ",");

            $count = 0;
            while ($tok !== false) 
            {
                $token[$count] = $tok;
                $tok = strtok(",");
                $count++;
            }   

            $edit['ton_value1'] = $token[0];
            $edit['ton_value2'] = $token[1];
            $edit['ton_value3'] = $token[2];

            $token = "";        
            $tok = strtok($edit['npi_name'], ",");

            $count = 0;
            while ($tok !== false) 
            {
                $token[$count] = $tok;
                $tok = strtok(",");
                $count++;
            }   

            $edit['npi_name1'] = $token[0];
            $edit['npi_name2'] = $token[1];
            $edit['npi_name3'] = $token[2];

            $token = "";        
            $tok = strtok($edit['npi_value'], ",");

            $count = 0;
            while ($tok !== false) 
            {
                $token[$count] = $tok;
                $tok = strtok(",");
                $count++;
            }   

            $edit['npi_value1'] = $token[0];
            $edit['npi_value2'] = $token[1];
            $edit['npi_value3'] = $token[2];        
        }


        //Dropdown box if statements. Control what item is selected on the return of the form
        if ($_REQUEST['signalling'] == "PRI CPE")
            $pick['signalling_cpe'] = "yes";
        elseif ($_REQUEST['signalling'] == "PRI NET")
            $pick['signalling_net'] = "yes";
        if ($edit['signalling'] == "PRI CPE")
            $pick['signalling_cpe'] = "yes";
        elseif ($edit['signalling'] == "PRI NET")
            $pick['signalling_net'] = "yes";
        elseif ($_REQUEST['signalling'] == "" && $edit['signalling'] == "")
            $pick['signalling_cpe'] = "yes";

        if ($_REQUEST['switchtype'] == "NI2")
            $pick['switchtype_ni2'] = "yes";
        elseif ($_REQUEST['switchtype'] == "4ESS")
            $pick['switchtype_4ess'] = "yes";
        elseif ($_REQUEST['switchtype'] == "5ESS")
            $pick['switchtype_5ess'] = "yes";
        elseif ($_REQUEST['switchtype'] == "QSIG")
            $pick['switchtype_qsig'] = "yes";
        elseif ($_REQUEST['switchtype'] == "DMS100")
            $pick['switchtype_ntt'] = "yes";
        elseif ($_REQUEST['switchtype'] == "EuroISDN")
            $pick['switchtype_euroisdn'] = "yes";
        if ($edit['switchtype'] == "NI2")
            $pick['switchtype_ni2'] = "yes";
        elseif ($edit['switchtype'] == "4ESS")
            $pick['switchtype_4ess'] = "yes";
        elseif ($edit['switchtype'] == "5ESS")
            $pick['switchtype_5ess'] = "yes";
        elseif ($edit['switchtype'] == "QSIG")
            $pick['switchtype_qsig'] = "yes";
        elseif ($edit['switchtype'] == "EuroISDN")
            $pick['switchtype_euroisdn'] = "yes";
        elseif ($edit['switchtype'] == "DMS100")
            $pick['switchtype_ntt'] = "yes";    
        elseif ($_REQUEST['switchtype'] == "" && $edit['switchtype'] == "" && $_SESSION['line_type'] == "E1")
            $pick['switchtype_euroisdn'] = "yes";
        elseif ($_REQUEST['switchtype'] == "" && $edit['switchtype'] == "" && $_SESSION['line_type'] == "T1")
            $pick['switchtype_ni2'] = "yes";

        if ($_REQUEST['facility'] == "no")
            $pick['facility_no'] = "no";
        elseif ($_REQUEST['facility'] == "yes")
            $pick['facility_yes'] = "yes";
        elseif ($edit['facility'] == "no" && $edit['facility'] == "")
            $pick['facility_yes'] = "yes";
        elseif ($edit['facility'] == "yes")
            $pick['facility_yes'] = "yes";

        if ($_REQUEST['bearer_ITC'] == "3.1khz")
            $pick['bearer_ITC_31khz'] = "yes";
        elseif ($_REQUEST['bearer_ITC'] == "unrestricted-digital")
            $pick['bearer_ITC_ud'] = "yes";
        elseif ($_REQUEST['bearer_ITC'] == "speech")
            $pick['bearer_ITC_speech'] = "yes";
        elseif ($edit['bearer_ITC'] == "3.1khz")
            $pick['bearer_ITC_31khz'] = "yes";
        elseif ($edit['bearer_ITC'] == "unrestricted-digital")
            $pick['bearer_ITC_ud'] = "yes";
        elseif ($edit['bearer_ITC'] == "speech")
            $pick['bearer_ITC_speech'] = "yes";

        if ($_REQUEST['bearer_UIL'] == "v110")
            $pick['bearer_UIL_v110'] = "yes";
        elseif ($_REQUEST['bearer_UIL'] == "ulaw")
            $pick['bearer_UIL_ulaw'] = "yes";
        elseif ($_REQUEST['bearer_UIL'] == "alaw")
            $pick['bearer_UIL_alaw'] = "yes";
        elseif ($edit['bearer_UIL'] == "v110")
            $pick['bearer_UIL_v110'] = "yes";
        elseif ($edit['bearer_UIL'] == "alaw")
            $pick['bearer_UIL_alaw'] = "yes";
        elseif ($edit['bearer_UIL'] == "ulaw")
            $pick['bearer_UIL_ulaw'] = "yes";

        if ($_REQUEST['ton_value1'] == "international")
            $pick['ton_value1_international'] = "yes";
        elseif ($_REQUEST['ton_value1'] == "national")
            $pick['ton_value1_national'] = "yes";
        elseif ($_REQUEST['ton_value1'] == "local")
            $pick['ton_value1_local'] = "yes";
        elseif ($_REQUEST['ton_value1'] == "unknown")
            $pick['ton_value1_unknown'] = 'yes';
        elseif ($_REQUEST['ton_value1'] == "network-specified")
            $pick['ton_value1_network-specified'] = 'yes';
        elseif ($_REQUEST['ton_value1'] == "subscriber-number")
            $pick['ton_value1_subscriber-number'] = "yes";
        elseif ($_REQUEST['ton_value1'] == "abbreviated-number")
            $pick['ton_value1_abbreviated-number'] = 'yes'; 
        elseif ($edit['ton_name1'] == "outbound-called-ton ")
        {
            if ($edit['ton_value1'] == "international ")
                $pick['ton_value1_international'] = "yes";
            elseif ($edit['ton_value1'] == "national ")
                $pick['ton_value1_national'] = "yes";
            elseif ($edit['ton_value1'] == "local ")
                $pick['ton_value1_local'] = "yes";
            elseif ($edit['ton_value1'] == "unknown ")
                $pick['ton_value1_unknown'] = 'yes';
            elseif ($edit['ton_value1'] == "network-specified ")
                $pick['ton_value1_network-specified'] = 'yes';
            elseif ($edit['ton_value1'] == "subscriber-number ")
                $pick['ton_value1_subscriber-number'] = "yes";
            elseif ($edit['ton_value1'] == "abbreviated-number ")
                $pick['ton_value1_abbreviated-number'] = 'yes';
        }       

        if ($_REQUEST['ton_value2'] == "international")
            $pick['ton_value2_international'] = "yes";
        elseif ($_REQUEST['ton_value2'] == "national")
            $pick['ton_value2_national'] = "yes";
        elseif ($_REQUEST['ton_value2'] == "local")
            $pick['ton_value2_local'] = "yes";
        elseif ($_REQUEST['ton_value2'] == "unknown")
            $pick['ton_value2_unknown'] = 'yes';
        elseif ($_REQUEST['ton_value2'] == "network-specified")
            $pick['ton_value2_network-specified'] = 'yes';
        elseif ($_REQUEST['ton_value2'] == "subscriber-number")
            $pick['ton_value2_subscriber-number'] = "yes";
        elseif ($_REQUEST['ton_value2'] == "abbreviated-number")
            $pick['ton_value2_abbreviated-number'] = 'yes'; 
        elseif($edit['ton_name2'] == " outbound-calling-ton ")
        {
            if ($edit['ton_value2'] == " international ")
                $pick['ton_value2_international'] = "yes";
            elseif ($edit['ton_value2'] == " national ")
                $pick['ton_value2_national'] = "yes";
            elseif ($edit['ton_value2'] == " local ")
                $pick['ton_value2_local'] = "yes";
            elseif ($edit['ton_value2'] == " unknown ")
                $pick['ton_value2_unknown'] = 'yes';
            elseif ($edit['ton_value2'] == " network-specified ")
                $pick['ton_value2_network-specified'] = 'yes';
            elseif ($edit['ton_value2'] == " subscriber-number ")
                $pick['ton_value2_subscriber-number'] = "yes";
            elseif ($edit['ton_value2'] == " abbreviated-number ")
                $pick['ton_value2_abbreviated-number'] = 'yes';             
        }                   


        if ($_REQUEST['ton_value3'] == "international")
            $pick['ton_value3_international'] = "yes";
        elseif ($_REQUEST['ton_value3'] == "national")
            $pick['ton_value3_national'] = "yes";
        elseif ($_REQUEST['ton_value3'] == "local")
            $pick['ton_value3_local'] = "yes";
        elseif ($_REQUEST['ton_value3'] == "unknown")
            $pick['ton_value3_unknown'] = 'yes';
        elseif ($_REQUEST['ton_value3'] == "network-specified")
            $pick['ton_value3_network-specified'] = 'yes';
        elseif ($_REQUEST['ton_value3'] == "subscriber-number")
            $pick['ton_value3_subscriber-number'] = "yes";
        elseif ($_REQUEST['ton_value3'] == "abbreviated-number")
            $pick['ton_value3_abbreviated-number'] = 'yes'; 
        elseif($edit['ton_name3'] == " outbound-rdnis-ton")
        {
            if ($edit['ton_value3'] == " international")
                $pick['ton_value3_international'] = "yes";
            elseif ($edit['ton_value3'] == " national")
                $pick['ton_value3_national'] = "yes";
            elseif ($edit['ton_value3'] == " local")
                $pick['ton_value3_local'] = "yes";
            elseif ($edit['ton_value3'] == " unknown")
                $pick['ton_value3_unknown'] = 'yes';
            elseif ($edit['ton_value3'] == " network-specified")
                $pick['ton_value3_network-specified'] = 'yes';
            elseif ($edit['ton_value3'] == " subscriber-number")
                $pick['ton_value3_subscriber-number'] = "yes";
            elseif ($edit['ton_value3'] == " abbreviated-number")
                $pick['ton_value3_abbreviated-number'] = 'yes';             
        }                   

        if ($_REQUEST['npi_value1'] == "isdn")
            $pick['npi_value1_isdn'] = "yes";
        elseif ($_REQUEST['npi_value1'] == "e164")
            $pick['npi_value1_e164'] = "yes";
        elseif ($_REQUEST['npi_value1'] == "data")
            $pick['npi_value1_data'] = "yes";
        elseif ($_REQUEST['npi_value1'] == "telex")
            $pick['npi_value1_telex'] = "yes";
        elseif ($_REQUEST['npi_value1'] == "national")
            $pick['npi_value1_national'] = "yes";
        elseif ($_REQUEST['npi_value1'] == "reserved")
            $pick['npi_value1_reserved'] = "yes";
        elseif ($_REQUEST['npi_value1'] == "private")
            $pick['npi_value1_private'] = "yes";
        elseif ($_REQUEST['npi_value1'] == "unknown")
            $pick['npi_value1_unknown'] = "yes";    
        elseif ($edit['npi_name1'] == "outbound-called-npi ")
        {
            if ($edit['npi_value1'] == "isdn ")
                $pick['npi_value1_isdn'] = "yes";
            elseif ($edit['npi_value1'] == "e164 ")
                $pick['npi_value1_e164'] = "yes";
            elseif ($edit['npi_value1'] == "data ")
                $pick['npi_value1_data'] = "yes";
            elseif ($edit['npi_value1'] == "telex ")
                $pick['npi_value1_telex'] = "yes";
            elseif ($edit['npi_value1'] == "national ")
                $pick['npi_value1_national'] = "yes";
            elseif ($edit['npi_value1'] == "reserved ")
                $pick['npi_value1_reserved'] = "yes";
            elseif ($edit['npi_value1'] == "private ")
                $pick['npi_value1_private'] = "yes";
            elseif ($edit['npi_value1'] == "unknown ")
                $pick['npi_value1_unknown'] = "yes";
        }       

        if ($_REQUEST['npi_value2'] == "isdn")
            $pick['npi_value2_isdn'] = "yes";
        elseif ($_REQUEST['npi_value2'] == "e164")
            $pick['npi_value2_e164'] = "yes";
        elseif ($_REQUEST['npi_value2'] == "data")
            $pick['npi_value2_data'] = "yes";
        elseif ($_REQUEST['npi_value2'] == "telex")
            $pick['npi_value2_telex'] = "yes";
        elseif ($_REQUEST['npi_value2'] == "national")
            $pick['npi_value2_national'] = "yes";
        elseif ($_REQUEST['npi_value2'] == "reserved")
            $pick['npi_value2_reserved'] = "yes";
        elseif ($_REQUEST['npi_value2'] == "private")
            $pick['npi_value2_private'] = "yes";
        elseif ($_REQUEST['npi_value2'] == "unknown")
            $pick['npi_value2_unknown'] = "yes";
        elseif($edit['npi_name2'] == " outbound-calling-npi ")
        {
            if ($edit['npi_value2'] == " isdn ")
                $pick['npi_value2_isdn'] = "yes";
            elseif ($edit['npi_value2'] == " e164 ")
                $pick['npi_value2_e164'] = "yes";
            elseif ($edit['npi_value2'] == " data ")
                $pick['npi_value2_data'] = "yes";
            elseif ($edit['npi_value2'] == " telex ")
                $pick['npi_value2_telex'] = "yes";
            elseif ($edit['npi_value2'] == " national ")
                $pick['npi_value2_national'] = "yes";
            elseif ($edit['npi_value2'] == " reserved ")
                $pick['npi_value2_reserved'] = "yes";
            elseif ($edit['npi_value2'] == " private ")
                $pick['npi_value2_private'] = "yes";
            elseif ($edit['npi_value2'] == " unknown ")
                $pick['npi_value2_unknown'] = "yes";                
        }

        if ($_REQUEST['npi_value3'] == "isdn")
            $pick['npi_value3_isdn'] = "yes";
        elseif ($_REQUEST['npi_value3'] == "e164")
            $pick['npi_value3_e164'] = "yes";
        elseif ($_REQUEST['npi_value3'] == "data")
            $pick['npi_value3_data'] = "yes";
        elseif ($_REQUEST['npi_value3'] == "telex")
            $pick['npi_value3_telex'] = "yes";
        elseif ($_REQUEST['npi_value3'] == "national")
            $pick['npi_value3_national'] = "yes";
        elseif ($_REQUEST['npi_value3'] == "reserved")
            $pick['npi_value3_reserved'] = "yes";
        elseif ($_REQUEST['npi_value3'] == "private")
            $pick['npi_value3_private'] = "yes";
        elseif ($_REQUEST['npi_value3'] == "unknown")
            $pick['npi_value3_unknown'] = "yes";
        elseif($edit['npi_name3'] == " outbound-rdnis-npi")
        {
            if ($edit['npi_value3'] == " isdn")
                $pick['npi_value3_isdn'] = "yes";
            elseif ($edit['npi_value3'] == " e164")
                $pick['npi_value3_e164'] = "yes";
            elseif ($edit['npi_value3'] == " data")
                $pick['npi_value3_data'] = "yes";
            elseif ($edit['npi_value3'] == " telex")
                $pick['npi_value3_telex'] = "yes";
            elseif ($edit['npi_value3'] == " national")
                $pick['npi_value3_national'] = "yes";
            elseif ($edit['npi_value3'] == " reserved")
                $pick['npi_value3_reserved'] = "yes";
            elseif ($edit['npi_value3'] == " private")
                $pick['npi_value3_private'] = "yes";
            elseif ($edit['npi_value3'] == " unknown")
                $pick['npi_value3_unknown'] = "yes";                
        }

        if ($_REQUEST['overlap'] == "" && $edit['overlap'] == "")
            $pick['overlap_disable'] = "yes";
        if ($_REQUEST['overlap'] == "disable")
            $pick['overlap_disable'] = "yes";
        elseif ($_REQUEST['overlap'] == "enable")
            $pick['overlap_enable'] = "yes";
        elseif ($edit['overlap'] == "disable")
            $pick['overlap_disable'] = "yes";
        elseif ($edit['overlap'] == "enable")
            $pick['overlap_enable'] = "yes";

        if ($_REQUEST['profile_name'] != "")
            $pick['profile_name'] = $_REQUEST['profile_name'];
        elseif ($edit['profile_name'] != "") {
            $pick['profile_name'] = $edit['profile_name'];
            $profile_name_disabled='disabled="disabled"';
        }
        elseif ($_REQUEST['profile_name'] == "" && $edit['profile_name'] == "")
            $pick['profile_name'] = "New " . $_SESSION['line_type'] . " Profile$a";

        if ($_REQUEST['facility_timeout'] != "")
            $pick['facility_timeout'] = $_REQUEST['facility_timeout'];
        elseif ($edit['facility_timeout'] != "")
            $pick['facility_timeout'] = $edit['facility_timeout'];
        elseif ($_REQUEST['facility_timeout'] == "" && $edit['facility_timeout'] == "")
            $pick['facility_timeout'] = 0;

        if ($_REQUEST['transfer'] == "yes")
            $pick['transfer_yes'] = "yes";
        elseif ($_REQUEST['transfer'] == "no")
            $pick['transfer_no'] = "yes";
        elseif ($pick['transfer'] == "yes")
            $pick['transfer_yes'] = "yes";
        elseif ($pick['transfer'] == "no")
            $pick['transfer_no'] = "yes";
        else
            $pick['transfer_yes'] = "yes";

        ?>
            <!-- <p>
            Please enter the Signalling Level configuration in order to generate a valid T1/E1 Profile.<br />
            Advanced options are available for your T1/E1 Profile. They are populated with their default values, but you may change them if required.
            </p> -->    
            <form name="create_profile">
            <input type="hidden" name="id_number" value="<?php echo $a; ?>"  />
            <input type="hidden" name="protocol" value="CCS" />
            <?php
            if ($edit_profile)
                echo '<input type="hidden" name="edit_profile" value="yes" />';
        ?>
            <table class="mytable" width='100%'>
            <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Standard Options</th>
            <tr>
            <td class="mytablesubheader" width='30%'>Profile Name</td>
            <td><input type="text" name="profile_name" value="<?=$pick['profile_name']?>" <?=$profile_name_disabled?> /></td>
            <td><?php echo $error['profile_name']; ?></td>
            </tr>
            <tr>
            <td class="mytablesubheader" width='30%'>Line Type</td>        
            <td><input type="text" name="line_type" value="<?php echo $_SESSION['line_type']; ?>" disabled='disabled' /></td>
            </tr>            
            <?php 
            /*if ($_SESSION['line_type'] == "E1")
              {
              ?>
              <tr>
              <td class="mytablesubheader" width='30%'>Protocol</td>
              <td>
              <select name="protocol">
              <option value="CCS" <?php if ($edit['protocol'] != "") { ?> selected="selected" <?php } elseif ($_REQUEST['protocol'] == "CCS") { ?> selected="selected" <?php } ?> >CCS</option>
              </select>
              </td>
              <td><?php echo $error['protocol']; ?></td>                                        
              </tr>            
              <?php
              }*/
            ?>        
            <tr>
            <td class="mytablesubheader" width='30%'>Signalling Type</td>                                        
            <td> 
            <select name="signalling">
            <option value="">Select Signalling</option>
            <option value="PRI CPE" <?php if ($pick['signalling_cpe'] == "yes") { ?> selected="selected" <?php }?> >PRI CPE</option>
            <option value="PRI NET" <?php if ($pick['signalling_net'] == "yes") { ?> selected="selected" <?php }?> >PRI NET</option>
            <?php /*    <option value="E&MWink" <?php if ($edit['signalling'] == "E&MWink") { ?> selected="selected" <?php } elseif ($_REQUEST['signalling'] == "E&MWink") { ?> selected="selected" <?php } ?> >E & M Wink</option> */ ?>
            </select>
            </td>
            <td><?php echo $error['switchtype'] . " " . $error['signalling'];  ?></td>
            </tr>
            <tr>
            <td class="mytablesubheader" width='30%'>Switchtype</td>
            <td>
            <select name="switchtype">
            <option value="">Select Switchtype</option>
            <?php
            if ($_SESSION['line_type'] == "T1")
            {
                ?>
                    <option value="NI2" <?php if ($pick['switchtype_ni2'] == "yes") { ?> selected="selected" <?php } ?> >National ISDN 2</option>       
                    <option value="4ESS" <?php if ($pick['switchtype_4ess'] == "yes") { ?> selected="selected" <?php }?> >Lucent 4ESS</option>
                    <option value="5ESS" <?php if ($pick['switchtype_5ess'] == "yes") { ?> selected="selected" <?php }?> >Lucent 5ESS</option>
                    <option value="DMS100" <?php if ($pick['switchtype_ntt'] == "yes") { ?> selected="selected" <?php }?> >DMS-100</option>   
                    <option value="QSIG" <?php if ($pick['switchtype_qsig'] == "yes") { ?> selected="selected" <?php }?> >QSIG</option>
                    <?php   
            }
        elseif ($_SESSION['line_type'] == "E1")
        {
            ?>
                <option value="EuroISDN" <?php if ($pick['switchtype_euroisdn'] == "yes") { ?> selected="selected" <?php }?> >EuroISDN</option>
                <option value="QSIG" <?php if ($pick['switchtype_qsig'] == "yes") { ?> selected="selected" <?php }?> >QSIG</option>
                <!-- <option value="E&MWink" <?php if ($pick['switchtype_em'] == "yes") { ?> selected="selected" <?php }?> >E & M Wink</option> -->
                <?php
        }
        ?>  
            </select>
            </td>
            <td><?php echo $error['switchtype'];?></td>                
            </tr> 
            <?php
            if ($_SESSION['freetdm'] == "True")
            {
                ?>      
                    </table>
                    <br />
                    <div class="fakelink" id="show_e"
                    onclick="this.style.display='none';
                document.getElementById('hide_e').style.display='block';
                document.getElementById('options').style.display='inline';
                ResizeFrame();
                ">&raquo; Show Advanced Options</div>
                    <div class="fakelink" id="hide_e"
                    onclick="this.style.display='none';
                document.getElementById('show_e').style.display='block';
                document.getElementById('options').style.display='none';
                ResizeFrame();
                ">&raquo; Hide Advanced Options</div>
                    <div id="options">
                    <br />
                    <font color="red"><i>NOTE: These options are set to their default parameters and shouldn't be changed unless required.</i></font>     
                    <table class="mytable" width='100%'>
                    <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Facility Message Options</th>
                    <tr>
                    <td class="mytablesubheader" width='30%'>Transfer Support</td>
                    <td>
                    <select name="transfer">
                    <option value="yes" <?php if ($pick['transfer_yes'] == "yes") { ?> selected="selected" <?php }?> >Enable</option>
                    <option value="no" <?php if ($pick['transfer_no'] == "no") { ?> selected="selected" <?php } ?> >Disable</option>
                    </select>
                    </td>
                    <td><?php echo $error['facility']; ?></td>
                    </tr>            
                    <tr>
                    <td class="mytablesubheader" width='30%'>Facility Message</td>
                    <td>
                    <select name="facility">
                    <option value="yes" <?php if ($pick['facility_yes'] == "yes") { ?> selected="selected" <?php }?> >Enable</option>
                    <option value="no" <?php if ($pick['facility_no'] == "no") { ?> selected="selected" <?php } ?> >Disable</option>
                    </select>
                    </td>
                    <td><?php echo $error['facility']; ?></td>
                    </tr>
                    <tr>
                    <td class="mytablesubheader" width='30%'>Facility Message Timeout</td>
                    <td><input type="text" name="facility_timeout" value="<?=$pick['facility_timeout']?>" style="width:50px" /></td>
                    <td><?php echo $error['facility_timeout']; ?></td>
                    </tr>
                    <?php
                    if ($_SESSION['line_type'] == "T1") {
                        ?>
                            <tr>
                            <td class="mytablesubheader" width='30%'>Overlap Dialing</td>
                            <td>
                            <select name="overlap" style="text-align:right">
                            <option value="enable" <?php if ($pick['overlap_enable'] =="yes") { echo "selected=selected"; } ?> style="text-align:right">Enabled</option>
                            <option value="disable" <?php if ($pick['overlap_disable'] =="yes") { echo "selected=selected"; } ?> style="text-align:right">Disabled</option>
                            </select>             
                            </td>
                            </tr>
                            <?php
                    }
                ?>
                    </table>
                    <br />
                    <font color="red"><i>Note:Used only when the Bearer Capability is <b>not available</b></i></font>
                    <table class="mytable" width='100%'>
                    <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Bearer Capability</th>              
                    <tr>
                    <td class="mytablesubheader" width='30%'>Bearer Capability - Information Transfer Capability</td>
                    <td>
                    <select name="bearer_ITC">
                    <option value="">Default</option>
                    <option value="speech" <?php if ($pick['bearer_ITC_speech'] == "yes") { ?> selected="selected" <?php }?> >Speech</option>
                    <option value="unrestricted-digital" <?php if ($pick['bearer_ITC_ud'] == "yes") { ?> selected="selected" <?php } ?> >Unrestricted Digital</option>
                    <option value="3.1khz" <?php if ($pick['bearer_ITC_31khz'] == "yes") { ?> selected="selected" <?php }?> >3.1 KHz</option>
                    </select>
                    </td>
                    </tr>
                    <tr>
                    <td class="mytablesubheader" width='30%'>Bearer Capability - User Information layer 1 Protocol</td>
                    <td>
                    <select name="bearer_UIL">
                    <option value="">Default</option>
                    <option value="v110" <?php if ($pick['bearer_UIL_v110'] == "yes" ) { ?> selected=selected <?php }?> >V.110</option>
                    <?php
                    if ($_SESSION['line_type'] == "T1") {
                        ?>
                            <option value="ulaw" <?php if ($pick['bearer_UIL_ulaw'] == "yes" ) { ?> selected=selected <?php }?> >uLaw</option>
                            <?php
                    }
                elseif ($_SESSION['line_type'] == "E1") {
                    ?>
                        <option value="alaw" <?php if ($pick['bearer_UIL_alaw'] == "yes" ) { ?> selected=selected <?php }?> >aLaw</option>
                        <?php
                }
                ?>
                    </select>
                    </td>
                    </tr>      
                    </table>
                    <br />
                    <table class="mytable" width='100%'>
                    <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Type of Number (TON) Options</th>     
                    <tr>    
                    <td class="mytablesubheader" width='30%'>Outbound Called TON</td>        
                    <td>
                    <select name="ton_value1">
                    <option value="">Default</option>
                    <option value="international" <?php if ($pick['ton_value1_international'] == "yes") { ?> selected="selected" <?php } ?> >International</option>
                    <option value="national" <?php if ($pick['ton_value1_national'] == "yes") { ?> selected="selected" <?php }?> >National</option>
                    <option value="unknown" <?php if ($pick['ton_value1_unknown'] == "yes") { ?> selected="selected" <?php }?> >Unknown</option>                        
                    <option value="network-specified" <?php if ($pick['ton_value1_network-specified'] == "yes") { ?> selected="selected" <?php }?> >Network Specified</option>
                    <option value="subscriber-number" <?php if ($pick['ton_value1_subscriber-number'] == "yes") { ?> selected="selected" <?php }?> >Subscriber Number</option>
                    <option value="abbreviated-number" <?php if ($pick['ton_value1_abbreviated-number'] == "yes") { ?> selected="selected" <?php }?> >Abbreviated Number</option>
                    <!--<option value="local" <?php if ($pick['ton_value1_local'] == "yes") { ?> selected="selected" <?php }?> >Local</option>-->
                    </select>
                    </td>
                    <td><?php if ($error['ton_name1'] == "") { echo $error['ton_value1']; } elseif ($error['ton_value1'] == "") { echo $error['ton_name1']; } ?></td>
                    </tr>
                    <tr>    
                    <td class="mytablesubheader" width='30%'>Outbound Calling TON</td>        
                    <td>
                    <select name="ton_value2">
                    <option value="">Default</option>
                    <option value="international" <?php if ($pick['ton_value2_international'] == "yes") { ?> selected="selected" <?php } ?> >International</option>
                    <option value="national" <?php if ($pick['ton_value2_national'] == "yes") { ?> selected="selected" <?php }?> >National</option>
                    <option value="unknown" <?php if ($pick['ton_value2_unknown'] == "yes") { ?> selected="selected" <?php }?> >Unknown</option>
                    <option value="network-specified" <?php if ($pick['ton_value2_network-specified'] == "yes") { ?> selected="selected" <?php }?> >Network Specified</option>
                    <option value="subscriber-number" <?php if ($pick['ton_value2_subscriber-number'] == "yes") { ?> selected="selected" <?php }?> >Subscriber Number</option>
                    <option value="abbreviated-number" <?php if ($pick['ton_value2_abbreviated-number'] == "yes") { ?> selected="selected" <?php }?> >Abbreviated Number</option>                        
                    <!-- <option value="local" <?php if ($pick['ton_value2_local'] == "yes") { ?> selected="selected" <?php }?> >Local</option>-->
                    </select>
                    </td>
                    <td><?php if ($error['ton_name2'] == "") { echo $error['ton_value2']; } elseif ($error['ton_value2'] == "") { echo $error['ton_name2']; } ?></td>
                    </tr>
                    <tr>    
                    <td class="mytablesubheader" width='30%'>Outbound rdnis TON</td>
                    <td>
                    <select name="ton_value3">
                    <option value="">Default</option>
                    <option value="international" <?php if ($pick['ton_value3_international'] == "yes") { ?> selected="selected" <?php } ?> >International</option>
                    <option value="national" <?php if ($pick['ton_value3_national'] == "yes") { ?> selected="selected" <?php }?> >National</option>
                    <option value="unknown" <?php if ($pick['ton_value3_unknown'] == "yes") { ?> selected="selected" <?php }?> >Unknown</option>
                    <option value="network-specified" <?php if ($pick['ton_value3_network-specified'] == "yes") { ?> selected="selected" <?php }?> >Network Specified</option>
                    <option value="subscriber-number" <?php if ($pick['ton_value3_subscriber-number'] == "yes") { ?> selected="selected" <?php }?> >Subscriber Number</option>
                    <option value="abbreviated-number" <?php if ($pick['ton_value3_abbreviated-number'] == "yes") { ?> selected="selected" <?php }?> >Abbreviated Number</option>                        
                    <!--<option value="local" <?php if ($pick['ton_value3_local'] == "yes") { ?> selected="selected" <?php }?> >Local</option>-->
                    </select>
                    </td>
                    <td><?php if ($error['ton_name3'] == "") { echo $error['ton_value3']; } elseif ($error['ton_value3'] == "") { echo $error['ton_name3']; } ?></td>
                    </tr>                        
                    </table> 
                    <br />
                    <table class="mytable" width='100%'>
                    <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Numbering Plan Identification (NPI) Options</th>  
                    <tr>
                    <td class="mytablesubheader" width='30%'>Outbound Called NPI</td>
                    <td>
                    <select name="npi_value1">
                    <option value="">Default</option>
                    <option value="isdn" <?php if ($pick['npi_value1_isdn'] == "yes") { ?> selected="selected" <?php } ?> >ISDN</option>
                    <option value="e164" <?php if ($pick['npi_value1_e164'] == "yes") { ?> selected="selected" <?php } ?> >E.164</option>
                    <option value="data" <?php if ($pick['npi_value1_data'] == "yes") { ?> selected="selected" <?php } ?> >Data</option>
                    <option value="telex" <?php if ($pick['npi_value1_telex'] == "yes") { ?> selected="selected" <?php } ?> >Telex</option>
                    <option value="national" <?php if ($pick['npi_value1_national'] == "yes") { ?> selected="selected" <?php } ?> >National</option>
                    <option value="private" <?php if ($pick['npi_value1_private'] == "yes") { ?> selected="selected" <?php } ?> >Private</option>
                    <option value="unknown" <?php if ($pick['npi_value1_unknown'] == "yes") { ?> selected="selected" <?php } ?> >Unknown</option>
                    <!--<option value="reserved" <?php if ($pick['npi_value1_reserved'] == "yes") { ?> selected="selected" <?php } ?> >Reserved</option>-->
                    </select>
                    </td>   
                    <td><?php if ($error['npi_name1'] == "") { echo $error['npi_value1']; } elseif ($error['npi_value1'] == "") { echo $error['npi_name1']; } ?></td>
                    </tr> 
                    <tr>
                    <td class="mytablesubheader" width='30%'>Outbound Calling NPI</td>
                    <td>
                    <select name="npi_value2">
                    <option value="">Default</option>
                    <option value="isdn" <?php if ($pick['npi_value2_isdn'] == "yes") { ?> selected="selected" <?php } ?> >ISDN</option>
                    <option value="e164" <?php if ($pick['npi_value2_e164'] == "yes") { ?> selected="selected" <?php } ?> >E.164</option>
                    <option value="data" <?php if ($pick['npi_value2_data'] == "yes") { ?> selected="selected" <?php } ?> >Data</option>
                    <option value="telex" <?php if ($pick['npi_value2_telex'] == "yes") { ?> selected="selected" <?php } ?> >Telex</option>
                    <option value="national" <?php if ($pick['npi_value2_national'] == "yes") { ?> selected="selected" <?php } ?> >National</option>
                    <option value="private" <?php if ($pick['npi_value2_private'] == "yes") { ?> selected="selected" <?php } ?> >Private</option>
                    <option value="unknown" <?php if ($pick['npi_value2_unknown'] == "yes") { ?> selected="selected" <?php } ?> >Unknown</option>                        
                    <!--<option value="reserved" <?php if ($pick['npi_value2_reserved'] == "yes") { ?> selected="selected" <?php } ?> >Reserved</option>-->
                    </select>
                    </td>   
                    <td><?php if ($error['npi_name2'] == "") { echo $error['npi_value2']; } elseif ($error['npi_value2'] == "") { echo $error['npi_name2']; } ?></td>
                    </tr> 
                    <tr>
                    <td class="mytablesubheader" width='30%'>Outbound rdnis NPI</td>
                    <td>
                    <select name="npi_value3">
                    <option value="">Default</option>
                    <option value="isdn" <?php if ($pick['npi_value3_isdn'] == "yes") { ?> selected="selected" <?php } ?> >ISDN</option>
                    <option value="e164" <?php if ($pick['npi_value3_e164'] == "yes") { ?> selected="selected" <?php } ?> >E.164</option>
                    <option value="data" <?php if ($pick['npi_value3_data'] == "yes") { ?> selected="selected" <?php } ?> >Data</option>
                    <option value="telex" <?php if ($pick['npi_value3_telex'] == "yes") { ?> selected="selected" <?php } ?> >Telex</option>
                    <option value="national" <?php if ($pick['npi_value3_national'] == "yes") { ?> selected="selected" <?php } ?> >National</option>
                    <option value="private" <?php if ($pick['npi_value3_private'] == "yes") { ?> selected="selected" <?php } ?> >Private</option>
                    <option value="unknown" <?php if ($pick['npi_value3_unknown'] == "yes") { ?> selected="selected" <?php } ?> >Unknown</option>                        
                    <!--<option value="reserved" <?php if ($pick['npi_value3_reserved'] == "yes") { ?> selected="selected" <?php } ?> >Reserved</option>-->
                    </select>
                    </td>   
                    <td><?php if ($error['npi_name3'] == "") { echo $error['npi_value3']; } elseif ($error['npi_value3'] == "") { echo $error['npi_name3']; } ?></td>
                    </tr>
                    <?php
            }
        ?>
            </table>
            </div>
            <table width="700px">
            <tr>
            <td width="10%"><input type="submit" name="create" value="<?php if ($_SESSION['id_num'] == "") { echo "Create Profile"; } else { echo "Save Profile"; } ?>" <?php echo $_SESSION['button_class']; ?>/></td>
            <td align="right"><input type="submit" name="cancel" value="<?php if ($_SESSION['id_num'] == "") { echo "Cancel Profile Creation"; } else { echo "Cancel Profile Editing"; } ?>" <?php echo $_SESSION['button_class']; ?>/></td>
            </tr>
            </table>
            </form>  
            <?php
            $_SESSION['id_num'] = "";
    }
}

class view_pri_profiles
{
    //Class variables
    public $data;       //Database object
    public $db;         //Database location

    /**
     *   Pulls data out of the database and returns it in an array
     *   @param table
     *           database table name
     *   @param param
     *           sql select parameter
     *   @param $data
     *           database object
     *   @return array
     */
    public function pull_data($table,$param) {
        $c = 0;
        $profile_array = array();

        if ($this->db == "") 
            $this->db = 'sqlite:../sqlite/cardinfo.db';


        //Table exists
        if ($this->data->check_for_table ($this->db, $table) > 1)
        {
            $select = "SELECT " . $param . " FROM " . $table . ";";

            try
            {
                //open the database
                $db = new PDO($this->db);

                $result = $db->query($select);

                foreach($result as $row)
                {
                    $profile_array[$c] = $row;
                    $c++;
                }
                // close the database connection
                $db = NULL;
            }
            catch(PDOException $e)
            {
                //echo "hello <br />";
                print 'Exception : '.$e->getMessage();
                echo "<br />";
                echo "Table = $table<br />";
                echo "Parameter = $param<br />";
                echo "db location = " . $this->db . "<br />";
            }
        }   
        return $profile_array;
    }   

    /**
     * Finds amount of available ports for the Use for all ports button. Will allow changing R2 profiles
     * @param object $data
     */
    public function find_available_ports ($data=NULL) {
        //Find total number of ports on card
        $table = 'card_present';
        $param = 'num_ports';
        $where = 'id='.$_SESSION['card_num'];

        $num_ports = $data->select_statement($this->db,$table,$param,$where);
        $current = $data->select_statement($this->db,$_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'],'*','port_id='.$_SESSION['port_num_clicked']);
        $physical = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'];

        $counter = 0;

        for ($a=1;$a<=$num_ports['num_ports'];$a++) {   
            $port = $a; 
            //Check if port has any other config. if it does, skip over the configuration.
            $m2ua = $data->select_statement($this->db,$_SESSION['card_clicked'].'_'.$_SESSION['card_num'].'_m2ua_link','link_name','port_id='.$port);
            $mg = $data->select_statement($this->db,$_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_m2ua_channels",'profile_name','port_id='.$port);
            $ss7_link = $data->select_statement($this->db,$_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_SS7_link","link_name",'port_id='.$port);
            //$pri = $data->select_statement($this->db,$_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_signalling",'signalling','port_id='.$port);
            $r2 = $data->select_statement($this->db,$_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_r2_signalling",'r2_profile','port_id='.$port);

            if ($ss7_link['link_name'] != "")
                $counter++;
            elseif($mg['profile_name'] != "")
                $counter++;
            elseif ($m2ua['link_name'] != "")
                $counter++;
            //elseif ($pri['signalling'] != "")
            //  $counter++;
            elseif ($r2['r2_profile'] != "")
                $counter++;

        }

        $total_available_ports = ($a-1) - $counter;

        if ($total_available_ports > 1)
            return true;
        else
            return false;       
    }   


    /**
     * Checks if a PRI profile is in use by any board in the system
     * @param string $profile_name
     * @return boolean
     */
    public function check_profile_used($profile_name) {
        //pull all the cards in the system
        $boards = $this->pull_data('card_present','id, dev_name');

        foreach ($boards as $board) {
            $board_name = explode ('-',$board['dev_name']);
            $dev_name = $board_name[1];
            $dev_id = $board['id'];

            $table = $dev_name.'_'.$dev_id.'_signalling';
            $card = $this->pull_data($table,'signalling');
            foreach ($card as $sig) {
                if ($sig['signalling'] == $profile_name)
                    return false;
            }
        }
        return true;
    }

    /**
     * Checks if a R2 profile is in use by any board in the system
     * @param string $profile_name
     * @return boolean
     */
    public function check_port_profile_used($profile_name, $data=NULL) {
        //pull all the cards in the system
        $table = $_SESSION['card_clicked'].'_'.$_SESSION['card_num'].'_signalling';
        $card = $this->data->select_statement($this->db,$table,'signalling','port_id='.$_SESSION['port_num_clicked']);

        if ($card['signalling'] == $profile_name)
            return false;

        return true;
    }   

    function display_profiles($profile_array, $a,$data=NULL)
    {
        $available_ports = $this->find_available_ports($this->data);

        ?>  
            <!--<h3><?php echo $_SESSION['line_type']; ?> Signalling Profiles</h3>

            <p>
            Below is a list of all <?php echo $_SESSION['line_type']; ?> Profiles configured on this system.<br />
            There are two default profiles configured for the user. These profiles can be edited to add more functionality to the profile.<br />
            You can manage you profiles using the edit and delete buttons on the right of the specific profile.<br />
            In order to create a new profile, click on "Create New Profile".<br />
            In order to use a specific profile on a port, click on "Use" or "Use for All Ports".
            </p>-->
            <br /> 
            <form name="view">    
            <table class="mytable" width='100%'>
            <th colspan="15" class="widget-content-header ui-state-active ui-corner-top" align="left"><?php echo $_SESSION['line_type']; ?> Signalling Profiles</th>
            <tr>
            <td class="mytableheader ">Profile Name</td>
            <!--<td class="mytableheader ">Line Type</td>-->
            <!--<td class="mytableheader ">Protocol</td>-->
            <td class="mytableheader ">Switchtype</td>
            <td class="mytableheader ">Signalling</td>
            <?php
            //Displays the following information only if SMG/FreeTDM is installed
            if ($_SESSION['freetdm'] == "True")
            {
                ?>          
                    <!--<td class="mytableheader ">Facility</td>
                    <td class="mytableheader ">Facility Timeout</td>
                    <td class="mytableheader ">Overlap Dialing</td>
                    <td class="mytableheader ">Bearer Capability (ITC)</td>
                    <td class="mytableheader ">Bearer Capability (UIL)</td>
                    <td class="mytableheader ">TON</td>
                    <td class="mytableheader ">NPI</td> -->
                    <?php
            }

        echo '<td class="mytableheader" colspan="4"></td>';
        echo "<tr>\n";
        for ($b = 0; $b < $a; $b++)
        {
            echo "\t\t\t<tr>\n";
            if ($_SESSION['last_profile'] == $profile_array[$b]['profile_name'])
                echo "\t\t\t\t<td align=\"left\"><b>" . $profile_array[$b]['profile_name'] . "</b></td>\n";
            else
                echo "\t\t\t\t<td align=\"left\">" . $profile_array[$b]['profile_name'] . "</td>\n";

            //echo "\t\t\t\t<td align=\"left\">" . $profile_array[$b]['line_type'] . "</td>\n";
            //echo "\t\t\t\t<td align=\"left\">" . $profile_array[$b]['protocol'] . "</td>\n";

            if ($profile_array[$b]['switchtype'] == "NI2")
                echo "\t\t\t\t<td align=\"left\">National ISDN 2</td>\n";
            elseif ($profile_array[$b]['switchtype'] == "4ESS")
                echo "\t\t\t\t<td align=\"left\">Lucent 4ESS</td>\n";   
            elseif ($profile_array[$b]['switchtype'] == "5ESS")
                echo "\t\t\t\t<td align=\"left\">Lucent 5ESS</td>\n";   
            elseif ($profile_array[$b]['switchtype'] == "DMS100")
                echo "\t\t\t\t<td align=\"left\">DMS 100</td>\n";
            elseif ($profile_array[$b]['switchtype'] == "QSIG")
                echo "\t\t\t\t<td align=\"left\">QSIG</td>\n";
            elseif ($profile_array[$b]['switchtype'] == "EuroISDN")
                echo "\t\t\t\t<td align=\"left\">EuroISDN</td>\n";              

            echo "\t\t\t\t<td align=\"left\">" . $profile_array[$b]['signalling'] . "</td>\n";

            //Displays the following information only if SMG/FreeTDM is installed
            if ($_SESSION['freetdm'] == "True")
            {
                //echo "\t\t\t\t<td align=\"left\">" . $profile_array[$b]['facility'] . "</td>\n";
                //echo "\t\t\t\t<td align=\"left\">" . $profile_array[$b]['facility_timeout'] . "</td>\n";
                //echo "\t\t\t\t<td align=\"left\">" . $profile_array[$b]['overlap'] . "</td>\n";
                //echo "\t\t\t\t<td align=\"left\">" . $profile_array[$b]['bearer_ITC'] . "</td>\n";
                //echo "\t\t\t\t<td align=\"left\">" . $profile_array[$b]['bearer_UIL'] . "</td>\n";
                /*if ($profile_array[$b]['ton_name'] == "" || $profile_array[$b]['ton_name'] == " ,  , ")
                  {
                  echo "\t\t\t\t<td align=\"center\"></td>\n";    
                  }   
                  elseif ($profile_array[$b]['ton_name'] != "")
                  {
                  $tons = $this->tokenize_values($profile_array[$b]['ton_name']);
                  if ($tons == 1)
                  echo "\t\t\t\t\t\t\t<td align=\"left\">$tons entry exists</td>\n";
                  elseif ($tons > 1)
                  echo "\t\t\t\t\t\t\t<td align=\"left\">$tons entries exist</td>\n";
                  }               
                  if ($profile_array[$b]['npi_name'] == "" || $profile_array[$b]['npi_name'] == " ,  , ")
                  echo "\t\t\t\t<td align=\"left\"></td>\n";  
                  elseif ($profile_array[$b]['npi_name'] != "")
                  {
                  $npis = $this->tokenize_values($profile_array[$b]['npi_name']);
                  if ($npis == 1)
                  echo "\t\t\t\t\t\t\t<td align=\"left\">$npis entry exists</td>\n";  
                  elseif ($npis > 1)
                  echo "\t\t\t\t\t\t\t<td align=\"left\">$npis entries exist</td>\n";             
                  }*/                                 
            }
            echo "<td align=\"right\" width='1%'>\n";

            if ($this->check_port_profile_used($profile_array[$b]['profile_name'],$data))
                echo "<input type=\"submit\" name=\"use" . $profile_array[$b]['id'] . "\" value=\"Use\" " . $_SESSION['button_class'] . "/>\n";
            else
                echo "<input type=\"submit\" name=\"use" . $profile_array[$b]['id'] . "\" value=\"Use\" " . $_SESSION['disabled_button_class'] . "/>\n";

            echo "</td>\n";
            echo "<td align=\"right\" width='1%'>\n";

            if ($_SESSION['card_clicked'] != "B601")
                if ($available_ports)   
                    echo "<input type=\"submit\" name=\"use-all-" . $profile_array[$b]['id'] . "\" value=\"Use for all Ports\" " . $_SESSION['button_class'] . "/>\n";      
                else
                    echo "<input type=\"submit\" name=\"use-all-" . $profile_array[$b]['id'] . "\" value=\"Use for all Ports\" " . $_SESSION['disabled_button_class'] . "/>\n";     

            echo "</td>\n";
            echo "<td align=\"right\" width='1%'>\n";
            echo "<input type=\"submit\" name=\"config" . $profile_array[$b]['id'] . "\" value=\"Edit Profile\" " . $_SESSION['button_class'] . "/>\n";
            echo "</td>\n";

            $skip = 0;
            //Disables deleting the default profile
            if ($profile_array[$b]['profile_name'] == "T1 PRI CPE" || $profile_array[$b]['profile_name'] == "T1 PRI NET")
                $skip = 1;
            elseif ($profile_array[$b]['profile_name'] == "E1 PRI CPE" || $profile_array[$b]['profile_name'] == "E1 PRI NET")
                $skip = 1;

            if ($skip == 0) {
                if (!$this->check_profile_used($profile_array[$b]['profile_name']))
                    echo "\t\t\t\t<td align=\"right\" width='1%'><input type=\"submit\" name=\"delete" . $profile_array[$b]['id'] . "\" value=\"Delete Profile\" " . $_SESSION['disabled_button_class'] . " disabled='disabled' /></td>\n";
                else
                    echo "\t\t\t\t<td align=\"right\" width='1%'><input type=\"submit\" name=\"delete" . $profile_array[$b]['id'] . "\" value=\"Delete Profile\" " . $_SESSION['button_class'] . " /></td>\n";
            }
            else
                echo "\t\t\t\t<td align=\"right\" width='1%'><input type=\"submit\" name=\"delete" . $profile_array[$b]['id'] . "\" value=\"Delete Profile\" " . $_SESSION['disabled_button_class'] . " disabled='disabled' /></td>\n";

            echo "\t\t\t<tr>\n";
            $num_entries++;
        }
        echo "\t\t</table>\n";      

        //Puts the number of entries in the database into a session variable
        $_SESSION['num_entries'] = $num_entries;
        ?>          
            <br />
            <table width="100%">
            <tr>
            <td width="10%"><input type="submit" name="create" value="Create New Profile" <?php echo $_SESSION['button_class']; ?>/></td>
            <td align="right"><input type="submit" name="back" value="Go Back to Hardware Information" <?php echo $_SESSION['button_class']; ?>/></td>
            </tr>
            </table>
            </form>        

            <?php
    }


    //Tokenizes the TON and NPI values for entry into the form
    function tokenize_values($string)
    {
        $tok = strtok($string, ",");

        $count = 0;
        while ($tok !== false) 
        {
            $token[$count] = $tok;
            $tok = strtok(",");
            $count++;
        }   

        for ($a = 0; $a < $count; $a++)
        {
            if ($token[$a] == " " || $token[$a] == "  ")
            {
            }
            else
            {
                $counter++;
            }
        }

        return $counter;            
    }           
}
?>
