<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/
require_once "database_classes.php";
require_once "SSH_Class_new.php";

// ************************************************************************************
// Functions
// ************************************************************************************
function hostGetServicesStatus( $ip_addr="", $ssh_port="" )
{
  // Create the SSH executor class
  $ssh_executor = new executor_class();

  $start_time = time();
  // Connect to host 
  if ( $ssh_executor->connect( $ip_addr, $ssh_port ) )
  {
    $service['ssh'] = "up";
  }
  else
  {
    $service['ssh'] = $ssh_executor->last_result;
    $ssh_executor = null;
    $service['profiling']['connect'] = time()-$start_time;
    return $service;
  }
  $service['profiling']['connect'] = time()-$start_time;
  $start_time = time();

  unset($output);
  // Query service status
  $cmd = "pidof " . $_SESSION['gateway_script'];
  // Check out if execution succeed
  if ($ssh_executor->execute($cmd, $output))
  {
    // Check for output
    if ($output[0] <= 0)
      $service['free']="down";
    else
      $service['free']="up";
  }
  else
  {
    // Get SSH execution error status
    $service['free']=$output[0];
  }
  $service['profiling']['free'] = time()-$start_time;
  $start_time = time();
  unset($output);

  if ($ssh_executor->execute (
          "/usr/sbin/wanrouter list | grep 'wanpipe[0-9]\{1,2\}' | tr \" \" \"\n\"",
         //" /usr/sbin/wanrouter summary | grep 'wanpipe[0-9]\{1,2\}' | cut -f1,7 | tr \"\t\" \"-\"",
		  $output ) )
  {
    if (count($output) == 0)
      $service['wan']="down";
    else
    {
      $service['wan']="up";
      // trim content
      for ($tmpIndex=0;$tmpIndex<count($output);$tmpIndex++)
        $output[$tmpIndex] = trim($output[$tmpIndex]);
      $service['wanpipe_list']=$output;
      unset($output);
      // Get the wanpipe configured
      // TODO(wadam) - wait for bug#2037 to be fixed
      // /usr/sbin/wanrouter summary | grep 'wanpipe[0-9]\{1,2\}' | cut -f1,7 | tr "\t" "-"
	  $ssh_executor->execute (
          //"/usr/sbin/wanrouter list | grep 'wanpipe[0-9]\{1,2\}' | tr \" \" \"\n\"",
         " /usr/sbin/wanrouter summary | grep 'wanpipe[0-9]\{1,2\}' | cut -f1,7 | tr \"\t\" \"-\"",
		  $output);
      for ($tmpIndex=0;$tmpIndex<count($output);$tmpIndex++)
        $output[$tmpIndex] = trim($output[$tmpIndex]);
      $service['wanpipe_summary']=$output;
      unset($output);		  
    }
  }
  else
  {
    // Get SSH execution error status
    $service['wan'] = $output[0];
  }
  $service['profiling']['wan'] = time()-$start_time;
  $start_time = time();
  unset($output);
  // Check if transcoding card is present in the system ?
  if ( $ssh_executor->execute(
          "/sbin/ifconfig -a | grep -e \"HWaddr 02:19:23:\" | cut -d: -f1 | awk '{ print $1}';",
          $output ) )
  {
    if ($output[0] == "" )
    {
      // No MP card
      $service['sngtc'] = "N/A";
    }
    else
    {
      unset($output);
      //Checks if transcoding is enabled or disabled
      if ($ssh_executor->execute(
                "pidof sngtc_server",
                $output ) )
      {
        if ($output[0] == 0)
          $service['sngtc']="down";
        else
          $service['sngtc']="up";
      }
      else
      {
        // Get SSH execution error status
        $service['sngtc'] = $output[0];
      }
    }
  }
  else
  {
    // Get SSH execution error status
    $service['sngtc'] = $output[0];
  }

  $service['profiling']['sngtc'] = time()-$start_time;
  $start_time = time();
  unset($output);
  $ssh_executor->disconnect();
  $ssh_executor = null;
  $service['profiling']['disconnect'] = time()-$start_time;
  $start_time = time();
  return $service;
};

// ************************************************************************************
// execute a command on the specified host (either local or remote)
// ************************************************************************************
function hostExecuteCommand($host_cmd, $ip_addr=null, $ssh_port=null)
{
  //echo "CMD=".$cmd . " on " . $ip_addr . ":" . $ssh_port;
  $executor = new executor_class();
  // Connect to host
  if ($executor->connect($ip_addr, $ssh_port))
  {
    // What do we have to do ?
    // WARNING: Keep start stop in order because of restart
    if ( $host_cmd == 'gateway_stop' || $host_cmd == 'gateway_restart'  )
    {
      // Stop the gateway
      $cmd = "/etc/init.d/" . $_SESSION['gateway_script'] . " stop";
      //echo $cmd;
      $executor->execute($cmd,$output );	
      $exec_rc['Media Gateway Stop'] = $output; 
      unset( $output );
	  $cmd = "/usr/bin/pkill -9 wanpipemon";
	  $executor->execute($cmd,$output);
      $cmd = "/usr/sbin/wanrouter stop";
      $executor->execute($cmd,$output);
      $cmd = "/usr/sbin/wanrouter stop";
      $executor->execute($cmd,$output);  
      $exec_rc['TDM Driver Stop'] = $output; 
      unset( $output );
    }  

    if ( $host_cmd == 'gateway_start' || $host_cmd == 'gateway_restart' )
    {
		//clear db flag for h323
		require_once 'database_classes.php';
		$data = new database_class;
		
		$data->delete_generic('sqlite:sqlite/cardinfo.db','h323_db','id=1');
		$data->delete_generic('sqlite:sqlite/cardinfo.db','sip_db','id=1');
		
      // Start the gateway
      unset($output);
      $cmd = "/usr/sbin/wanrouter start 2>&1";
      $executor->execute($cmd, $output);
      $exec_rc['TDM Driver Start'] = $output; 

      if ($output[0] > 0)
      {
		$cmd = "/usr/bin/pkill -9 wanpipemon";
		$executor->execute($cmd,$output);		  
        $cmd = "/usr/sbin/wanrouter stop 2>&1";
        $executor->execute($cmd, $output);
        $cmd = "/usr/sbin/wanrouter stop 2>&1";
        $executor->execute($cmd,$output);  
        $exec_rc['TDM Driver Stop'] = $output; 
        $_SESSION['wanrouter_error'] = $output[0];
      }
      else
      {
        unset($_SESSION['wanrouter_error']);
      }
      unset($output);
      sleep(5);
      $cmd = "/etc/init.d/" . $_SESSION['gateway_script'] . " start > /dev/null 2>/dev/null";
      //echo $cmd;
      $executor->execute($cmd,$output);
      unset( $output );
      // wait a little for service to start
      $serviceStartRc = "FAILED";
      for ($iLoop=0; $iLoop<10; $iLoop++)
      {
        usleep(250000);
        $cmd = "pidof " . $_SESSION['gateway_script'];
        $executor->execute($cmd,$output);
              if ($output[0]>0)
        {
          $serviceStartRc = "OK";
          break;
        }
        unset( $output );
      }
      $exec_rc['Media Gateway Start'] = array("Starting...", $serviceStartRc); 
    }  

    if ( $host_cmd == 'tc_stop' || $host_cmd == 'tc_restart' )
    {
      // Stop the transcoding
      unset( $output );
      $cmd = "/etc/init.d/" . $_SESSION['media_script'] . " stop";
      $executor->execute($cmd, $output);
      $exec_rc['Media Processing Stop'] = $output; 
      
      //echo "Response was " . $output[0] . "<br />";
      
      if ($output[0] == 0)
      {
        unset( $output );
        $cmd = "pidof " . $_SESSION['gateway_script'];
        $executor->execute($cmd,$output);
        
        if ($output[0] > 0)
        {
          unset( $output );
          $cmd = "/usr/sbin/" . $_SESSION['cli'] . " -x \"unload mod_sangoma_codec\"";
          $executor->execute($cmd,$output);
          $exec_rc['Codec Unregister'] = $output; 
          unset( $output );
        }			
      }
          
      unset( $output );
    }

    if ( $host_cmd == 'tc_start' || $host_cmd == 'tc_restart' )
    {
      // Start the transcoding
      $cmd = "/etc/init.d/" . $_SESSION['media_script'] . " start";
      $executor->execute($cmd,$output);
      $exec_rc['Media processing Start'] = $output; 
      unset($output);
      $executor->execute("echo $!",$output);
      
      //echo "Response was " . $output[0] . "<br />";
      
      if ($output[0] == 0)
      {
        unset($output);
        $cmd = "pidof " . $_SESSION['gateway_script'];
        $executor->execute($cmd,$output);
        
        if ($output[0] > 0)
        {
          unset($output);
          $cmd = "/usr/sbin/" .  $_SESSION['cli'] . " -x \"load mod_sangoma_codec\"";
          $executor->execute($cmd, $output);
          $exec_rc['Codec Register'] = $output; 
        }
      }
      unset( $output );
    }
    //Starts Wanrouter on system boot
    if ( $host_cmd == 'service_startup_boot' || $host_cmd == 'service_startup_manual' )
    {
      $wanpipe_common_functions = new wanpipe_common;
      if ( $host_cmd == 'service_startup_boot' )
      {
        $wanpipe_common_functions->wanrouter_start_script();
        $exec_rc['Service startup'] = array('Boot'); 
      }
      if ( $host_cmd == 'service_startup_manual' )
      {
        $wanpipe_common_functions->wanrouter_no_startup();
        $exec_rc['Service startup'] = array('Manual'); 
      }
      $wanpipe_common_functions = null;
    }
  }
  else
    $exec_rc['Connection'] = $executor->last_error; 
  $executor = null;
  return $exec_rc;
}

?>


