<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class analog_class
{
	
	//Class Variables
	public $conn = "";					//Connection type variable
	public $echo = "";					//Hardware Echo Cancellation variable
	public $dtmf = "";					//Hardware DTMF variable
	public $fax = "";					//Hardware Fax Detection Variable
	private $error = array();			//Holds the errors created in the form
	public $error_count = "";			//Error counter variable;
	public $untoken_card_name = "";		//Card Name
	public $card_name = "";				//Tokenized card_name
	public $total_ports = "";			//Contains the total number of ports for that particular card
	public $network_sync = "";			//Contains the network sync parameter
	public $rxgain="";					//RX Gain Parameter
	public $txgain="";					//TX Gain Parameter
	public $echo_cancel = "";			//Tells whether there is an echo canceler on the card
	
	
	//Main Display Function
	function main()
	{
		//Echo Cancellation Drop Down
		if ($_REQUEST['hw_ec'] == "" && $this->echo == "" )
		{
			$this->pick['hw_ec_yes'] = "yes";
		}
		elseif ($_REQUEST['hw_ec'] == "yes")
		{
			$this->pick['hw_ec_yes'] = "yes";
		}
		elseif ($_REQUEST['hw_ec'] == "no")
		{
			$this->pick['hw_ec_no'] = "yes";
		}
		elseif ($this->echo == "yes")
		{
			$this->pick['hw_ec_yes'] = "yes";
		}
		elseif ($this->echo == "no")
		{
			$this->pick['hw_ec_no'] = "yes";
		}
		
		//Hardware DTMF Drop Down
		if ($_REQUEST['hw_dtmf'] == "" && $this->dtmf == "" )
		{
			$this->pick['hw_dtmf_yes'] = "yes";
		}
		elseif ($_REQUEST['hw_dtmf'] == "yes")
		{
			$this->pick['hw_dtmf_yes'] = "yes";
		}
		elseif ($_REQUEST['hw_dtmf'] == "no")
		{
			$this->pick['hw_dtmf_no'] = "yes";
		}
		elseif ($this->dtmf == "yes")
		{
			$this->pick['hw_dtmf_yes'] = "yes";
		}
		elseif ($this->dtmf == "no")
		{
			$this->pick['hw_dtmf_no'] = "yes";
		}

		//Hardware Fax Detection Drop Down
		if ($_REQUEST['hw_dtmf'] == "" && $this->dtmf == "" )
		{
			$this->pick['hw_fax_no'] = "yes";
		}
		elseif ($_REQUEST['hw_fax'] == "yes")
		{
			$this->pick['hw_fax_yes'] = "yes";
		}
		elseif ($_REQUEST['hw_fax'] == "no")
		{
			$this->pick['hw_fax_no'] = "yes";
		}
		elseif ($this->fax == "yes")
		{
			$this->pick['hw_fax_yes'] = "yes";
		}
		elseif ($this->fax == "no")
		{
			$this->pick['hw_fax_no'] = "yes";
		}		
		
		//RX Gain
		if ($_REQUEST['rxgain'] != "")
		{
			$this->pick['rxgain'] = $_REQUEST['rxgain'];
		}
		elseif ($this->database['rxgain'] != "")
		{
			$this->pick['rxgain'] = $this->database['rxgain'];
		}
		elseif ($_REQUEST['rxgain'] == "")
		{
			$this->pick['rxgain'] = "0.0";
		}	

		//TX Gain
		if ($_REQUEST['txgain'] != "")
		{
			$this->pick['txgain'] = $_REQUEST['txgain'];
		}
		elseif ($this->database['txgain'] != "")
		{
			$this->pick['txgain'] = $this->database['txgain'];
		}
		elseif ($_REQUEST['txgain'] == "")
		{
			$this->pick['txgain'] = "0.0";
		}	
				
		if ($_SESSION['card_clicked'] == "B700")
		{
			echo "<h3>" . $_SESSION['card_clicked'] . " - " . $_SESSION['bri_type'] . " - Hardware Configuration</h3><br />";
		}
		elseif ($_SESSION['card_clicked'] == "B601")
		{
			echo "<h3>" . $_SESSION['card_clicked'] . " - Analog Hardware Configuration</h3>";
		}
		else
		{
			echo "<h3>" . $_SESSION['card_clicked'] . " - Hardware Configuration</h3>";
		}
		echo "<p>
		Please enter the low level configuration for your " . $_SESSION['card_clicked'] . ".<br />
		Advanced options are available for the " . $_SESSION['card_clicked'] . ". They are populated with their default values, but you may change them if required.
		</p>";
		echo "<hr style='width:700px;' align='left'/>";
		?>
		<h4>Standard Options</h4>
    	<form action="" method="post">
        <?php
		if ($this->echo_cancel == 0)
		{
			?>
            <h5>No Echo Canceler Found</h5>
            <?php
		}
		else
		{
		?>        
        	<table>
                <tr>
                	<td>Hardware Echo Cancellation:
                    <td align="right">
                    	<select name="hw_ec">
                        	<option value="yes" <?php if ($this->pick['hw_ec_yes'] == "yes") { ?> selected="selected" <?php } ?>>Enable</option>
                            <option value="no" <?php if ($this->pick['hw_ec_no'] == "yes") { ?> selected="selected" <?php } ?> >Disable</option>
                        </select>
                    </td>
                </tr>
                <tr>
                	<td>Hardware DTMF:
                    <td align="right">
                    	<select name="hw_dtmf">
                        	<option value="yes" <?php if ($this->pick['hw_dtmf_yes'] == "yes") { ?> selected="selected" <?php } ?>>Enable</option>
                            <option value="no" <?php if ($this->pick['hw_dtmf_no'] == "yes") { ?> selected="selected" <?php } ?>>Disable</option>
                        </select>
                    </td>
                    <?php if (isset($this->error['dtmf'])) { ?><td><font color="#FF0000"><?php echo $this->error['dtmf']; ?></font></td><?php } ?>
                </tr>
                <tr>
                	<td>Hardware Fax Detection:
                    <td align="right">
                    	<select name="hw_fax">
                        	<option value="yes" <?php if ($this->pick['hw_fax_yes'] == "yes") { ?> selected="selected" <?php } ?>>Enable</option>
                            <option value="no" <?php if ($this->pick['hw_fax_no'] == "yes") { ?> selected="selected" <?php } ?>>Disable</option>
                        </select>
                    </td>
                    <?php if (isset($this->error['fax'])) { ?> <td><font color="red"><?php echo $this->error['fax']; ?></font></td><?php } ?>
                </tr>                                               
            </table>
            <?php
		}
		?>
            <br />
            <hr style='width:700px;' align='left'/>
		<div class="fakelink"
			id="show_e"
			onclick="this.style.display='none';
			document.getElementById('hide_e').style.display='block';
			document.getElementById('options').style.display='inline';
            ResizeFrame();
			">&raquo; Show Advanced Options</div>
		<div class="fakelink"
			id="hide_e"
			onclick="this.style.display='none';
			document.getElementById('show_e').style.display='block';
			document.getElementById('options').style.display='none';
            ResizeFrame();
			">&raquo; Hide Advanced Options</div>
		<div id="options">            
			<br />
            <font color="red">NOTE: These options are set to their default parameters and shouldn't be changed unless required.</font>
            <br />
			<br />
            <table> 
                <tr>
                	<td>RX Gain</td>
                    <td><input type="text" name="rxgain" style="width:30px" value="<?php echo $this->pick['rxgain'];?>" /></td>
					<td><?php echo $this->error['rxgain']; ?></td>
    			</tr>
                <tr>
                	<td>TX Gain</td>
	                <td><input type="text" name="txgain" style="width:30px" value="<?php echo $this->pick['txgain'] ;?>" /></td>
					<td><?php echo $this->error['txgain'];?></td>
                </tr>                         
            <?php
			if ($_SESSION['card_clicked'] == "B601"  || $_SESSION['card_clicked'] == "B700")
			{
			}
			else
			{
			?>

            	<tr>
                	<td>Clock Synchronization</td>
                    <td>
                    	<select name="network_sync">
                        	<option value="yes"<?php if ($this->network_sync == "yes") { ?> selected="selected" <?php } ?>>Enable</option>
                            <option value="no"<?php if ($this->network_sync == "no" || $this->network_sync == "") { ?> selected="selected" <?php } ?>>Disable</option>
                        </select>
                    </td>
                </tr>              
            <?php
			}
			?>
            </table> 
            </div>
            <hr style='width:700px;' align='left'/>           
            <br />
            <table width="700px">
            <tr>
            <?php
			if ($_SESSION['card_clicked'] == "B700" || $_SESSION['card_clicked'] == "B601" )
			{
				?><td width="1%"><input type="submit" name="apply" value="Apply to Port" <?php echo $_SESSION['button_class']; ?>/></td><?php
			}
			else
			{
            	?><td width="1%"><input type="submit" name="apply" value="Apply to Card" <?php echo $_SESSION['button_class']; ?>/></td><?php
			}?>
            <td align="right"><input type="submit" name="cancel" value="Cancel Configuration" <?php echo $_SESSION['button_class']; ?>/></td>
            </tr>
            </table>
        </form>    
        <?php
	}
	
	//Validates the information
	function validate()
	{
		$this->card_name = $_SESSION['card_clicked'];
		if ($this->echo == "no" && $this->dtmf == "yes")
		{
			$this->error['dtmf'] = "Please Enable Hardware Echo Cancellation";
			$this->error_count++;
		}
		if ($this->echo == "no" && $this->fax == "yes")
		{
			$this->error['fax'] = "Please Enable Hardware Echo Cancellation";
			$this->error_count++;
		}	
		//Validates the RX Gain
		if (is_numeric($_REQUEST['rxgain']))
		{
			if ($_REQUEST['rxgain'] < -50 || $_REQUEST['rxgain'] > 50)
			{
				$this->error_count++;
				$this->error['rxgain'] = "<font color=\"red\"><b>RX Gain</b> must be between <b>-50 and 50</b></font>\n";
			}
		}
		else
		{
			$this->error_count++;			
			$this->error['rxgain'] = "<font color=\"red\"><b>RX Gain</b> must be <b>numeric</b></font>\n";
		}
		
		//Validates the TX Gain
		if (is_numeric($_REQUEST['txgain']))
		{
			if ($_REQUEST['txgain'] < -50 || $_REQUEST['txgain'] > 50)
			{
				$this->error_count++;
				$this->error['txgain'] = "<font color=\"red\"><b>TX Gain</b> must be between <b>-50 and 50</b></font>\n";
			}
		}
		else
		{
			$this->error_count++;			
			$this->error['txgain'] = "<font color=\"red\"><b>TX Gain</b> must be <b>numeric</b></font>\n";
		}			
	}
	
	//Tokenizes Card Name
	function tokenize()
	{
		$tok = strtok($this->untoken_card_name, "-");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok("-");
			$count++;
		}
	
		$this->card_name = $token[1];		
	}
}


?>
