<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Start Session
session_start();

//Page Authentication
if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{
	//Class Includes
	include "configure_analog_class.php";
	include "../database_classes.php";
	
	//Class Constructors
	$analog= new analog_class;
	$data = new database_class;
	
	//SQLite information
	$table_name = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'];
	$analog->untoken_card_name = $_SESSION['card_clicked'];
	
	$db_location = "sqlite:../sqlite/cardinfo.db";
	
	//Gets the number of ports for this card from the card_present table
	$where_param = "id = " . $_SESSION['card_num'];
	$return = $data->select_statement ($db_location, "card_present", "echo, num_ports", $where_param);
	$analog->total_ports = $return[1];
	$analog->echo_cancel = $return[0];
	
	//Check the database. If the database exists, use that information to display
	$table_exists = $data->check_for_table ($db_location, $table_name);
	
	if ($table_exists > 1)
	{
		if ($_SESSION['card_clicked'] == "B601")
		{
			$param = "port_id, dev_name, echo, dtmf, fax, rxgain, txgain";
		}
		elseif ($_SESSION['card_clicked'] == "B700")
		{
			$param = "port_id, conn_type, dev_name,hw_ec, hw_dtmf, hw_fax, rxgain, txgain";
		}	
		else
		{
			$param = "port_id, dev_name,hw_ec, hw_dtmf, hw_fax, network_sync, rxgain, txgain";
		}
		$where_param = "port_id = " . $_SESSION['port_num_clicked'];
		
		//Grab the information for that port
		$return = $data->select_statement ($db_location, $table_name, $param, $where_param);
		
		//Place them within the class
		if ($_SESSION['card_clicked'] == "B601")
		{
			$analog->echo = $return['echo'];
			$analog->dtmf = $return['dtmf'];
			$analog->fax = $return['fax'];
			$analog->rxgain = $return['rxgain'];
			$analog->txgain = $return['txgain'];
		}
		else
		{
			$analog->conn = $return['conn_type'];
			$analog->echo = $return['hw_ec'];
			$analog->dtmf = $return['hw_dtmf'];
			$analog->fax = $return['hw_fax'];
			$analog->network_sync = $return['network_sync'];
			$analog->rxgain = $return['rxgain'];
			$analog->txgain = $return['txgain'];		
		}
	}
	
	//if the form is submitted, populate the values of the form in the class
	if ($_REQUEST['apply'] == "Apply to Card" || $_REQUEST['apply'] == "Apply to Port")
	{
		//echo "I am here<br />";
		//Populate class variables
		if ($analog->echo_cancel == 0)
		{
			$analog->echo = "no";
			$analog->dtmf = "no";
			$analog->fax = "no";		
		}
		else
		{
			$analog->echo = $_REQUEST['hw_ec'];
			$analog->dtmf = $_REQUEST['hw_dtmf'];
			$analog->fax = $_REQUEST['hw_fax'];
		}
		$analog->network_sync = $_REQUEST['network_sync'];
		$analog->rxgain = $_REQUEST['rxgain'];
		$analog->txgain = $_REQUEST['txgain'];
		
		//Validate Information from the form
		$analog->validate();
	
		if ($analog->error_count == 0)
		{
			//Check if the database needs to be created		
			if ($table_exists < 2)
			{
				if ($_SESSION['card_clicked'] == "B601")
				{
					$param = "port_id int primary key, dev_name varchar(60), line_type varchar(10), coding varchar(10), framing varchar(10), clock varchar(30), ref_clock int, echo varchar(30), dtmf varchar(30), fax varchar(30), lbo varchar(30), txtristate varchar(30), sigmode varchar(10), impedence varchar(30), rx_level varchar(30), rxgain decimal(10,2), txgain decimal(10,2)";
				}
				else
				{
					$param = "port_id int primary key, conn_type varchar(10), dev_name varchar(30), hw_ec varchar(10), hw_dtmf varchar(10), hw_fax varchar(10), network_sync varchar(10), rxgain decimal(10,2), txgain decimal(10,2)";
				}
				$data->create_table($db_location, $table_name, $param);
			}
	
			//Place in database
			if ($table_exists > 1)
			{
				if ($_SESSION['card_clicked'] == "B601")
				{
					$insert_parameters = "port_id, dev_name , line_type , coding , framing , clock , ref_clock , echo , dtmf , fax , lbo , txtristate , sigmode , impedence, rx_level , rxgain , txgain ";		
					$param = "port_id int primary key, dev_name varchar(60), line_type varchar(10), coding varchar(10), framing varchar(10), clock varchar(30), ref_clock int, echo varchar(30), dtmf varchar(30), fax varchar(30), lbo varchar(30), txtristate varchar(30), sigmode varchar(10), impedence varchar(30), rx_level varchar(30), rxgain decimal(10,2), txgain decimal(10,2)";
					$data->check_schema($db_location, $table_name, $param, "17", $insert_parameters);	
				}
				elseif ($_SESSION['card_clicked'] == "B700")
				{
					$insert_parameters = "port_id,  conn_type , dev_name , hw_ec , hw_dtmf , hw_fax ,rxgain , txgain ";				
					$param = "port_id int primary key, conn_type varchar(10), dev_name varchar(30), hw_ec varchar(10), hw_dtmf varchar(10), hw_fax varchar(10), rxgain decimal(10,2), txgain decimal(10,2)";
					$data->check_schema($db_location, $table_name, $param, "8", $insert_parameters);				
				}
				else
				{
					$insert_parameters = "port_id, dev_name , hw_ec , hw_dtmf , hw_fax ,  network_sync, rxgain , txgain ";				
					$param = "port_id int primary key, dev_name varchar(30), hw_ec varchar(10), hw_dtmf varchar(10), hw_fax varchar(10), network_sync varchar(10), rxgain decimal(10,2), txgain decimal(10,2)";
					$data->check_schema($db_location, $table_name, $param, "8", $insert_parameters);				
				}			
				
				//Check if the line exists
				$param = "port_id";
				$where_param = "port_id = " . $_SESSION['port_num_clicked'];
				$result = $data->select_statement ($db_location, $table_name, $param, $where_param);
				
				if ($result['port_id'] != "")
				{
					//update
					if ($_SESSION['card_clicked'] == "B601")
					{
						$parameters = "port_id = \"" .  $_SESSION['port_num_clicked'] . "\", dev_name = \"" . $analog->card_name . "\", echo = \"" . $analog->echo . "\", dtmf = \"" . $analog->dtmf . "\", fax = \"" . $analog->fax . "\", rxgain =  \"" . $analog->rxgain ."\", txgain =  \"" . $analog->txgain . "\"";
					}
					elseif ($_SESSION['card_clicked'] == "B700")
					{	
						$parameters = "port_id = \"" .  $_SESSION['port_num_clicked'] . "\", dev_name = \"" . $analog->card_name . "\", hw_ec = \"" . $analog->echo . "\", hw_dtmf = \"" . $analog->dtmf . "\", hw_fax = \"" . $analog->fax . "\", rxgain = \"" . $analog->rxgain ."\", txgain = \"" . $analog->txgain . "\"";
					}				
					else
					{	
						$parameters = "port_id = \"" .  $_SESSION['port_num_clicked'] . "\", dev_name = \"" . $analog->card_name . "\", hw_ec = \"" . $analog->echo . "\", hw_dtmf = \"" . $analog->dtmf . "\", hw_fax = \"" . $analog->fax . "\", network_sync = \"" . $analog->network_sync . "\", rxgain = \"" . $analog->rxgain ."\", txgain = \"" . $analog->txgain . "\"";
					}
					
					$where_param = "port_id = " . $_SESSION['port_num_clicked'];
					$data->update_table ($db_location, $table_name, $parameters, $where_param);
				}
				else
				{
					if ($_SESSION['card_clicked'] == "B601")
					{
						$parameters = "port_id, dev_name, echo, dtmf, fax, rxgain, txgain";
						$values = $_SESSION['port_num_clicked'] . ", \"" . $analog->card_name . "\",\"" . $analog->echo . "\", \"" . $analog->dtmf . "\", \"" . $analog->fax . "\", \"" . $analog->rxgain ."\", \"" . $analog->txgain . "\"";				
					}
					elseif ($_SESSION['card_clicked'] == "B700")
					{
						$parameters = "port_id, dev_name, hw_ec, hw_dtmf, hw_fax, rxgain, txgain";
						$values = $_SESSION['port_num_clicked'] . ", \"" . $analog->card_name . "\",\"" . $analog->echo . "\", \"" . $analog->dtmf . "\", \"" . $analog->fax . "\", \"" . $analog->rxgain ."\", \"" . $analog->txgain . "\"";				
					}				
					else
					{
						$parameters = "port_id, dev_name, hw_ec, hw_dtmf, hw_fax, network_sync, rxgain, txgain";
						$values = $_SESSION['port_num_clicked'] . ", \"" . $analog->card_name . "\",\"" . $analog->echo . "\", \"" . $analog->dtmf . "\", \"" . $analog->fax . "\", \"" . $analog->network_sync . "\", \"" . $analog->rxgain ."\", \"" . $analog->txgain . "\"";				
					}
					$data->insert_statement($db_location, $table_name, $parameters, $values);
				}
			}
			elseif ($table_exists < 2)
			{
				//insert
				if ($_SESSION['card_clicked'] == "B601")
				{
					$parameters = "port_id, dev_name, echo, dtmf, fax, rxgain, txgain";
					$values = $_SESSION['port_num_clicked'] . ", \"" . $analog->card_name . "\",\"" . $analog->echo . "\", \"" . $analog->dtmf . "\", \"" . $analog->fax . "\", \"" . $analog->rxgain ."\", \"" . $analog->txgain . "\"";				
				}
				elseif ($_SESSION['card_clicked'] == "B700")
				{
					$parameters = "port_id, dev_name, hw_ec, hw_dtmf, hw_fax, rxgain, txgain";
					$values = $_SESSION['port_num_clicked'] . ", \"" . $analog->card_name . "\",\"" . $analog->echo . "\", \"" . $analog->dtmf . "\", \"" . $analog->fax . "\", \"" . $analog->rxgain ."\", \"" . $analog->txgain . "\"";				
				}			
				else
				{
					$parameters = "port_id, dev_name, hw_ec, hw_dtmf, hw_fax, network_sync, rxgain, txgain";
					$values = $_SESSION['port_num_clicked'] . ", \"" . $analog->card_name . "\",\"" . $analog->echo . "\", \"" . $analog->dtmf . "\", \"" . $analog->fax . "\", \"" . $analog->network_sync . "\", \"" . $analog->rxgain ."\", \"" . $analog->txgain . "\"";			
				}
				$data->insert_statement($db_location, $table_name, $parameters, $values);
				
			}
			//Return to wanrouterhwprobe.php
			header( 'Location:../wanrouterhwprobe.php' ) ;
		}	
	}
	
	//If the user clicks cancel
	if ($_REQUEST['cancel'] == "Cancel Configuration")
	{
		header( 'Location:../wanrouterhwprobe.php' ) ;
	}
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';
		//include 'database_classes.php';	
		include '../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("Analog Configuration", "../../../style.css");		
	}	
	
	//Main Analog configuration page
	$analog->main();

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}

}
else
{
	header( 'Location:../index.php' ) ;
}	

?>