<?php
/*
	SMG WebGUI
	Version: 1.1

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class bri_class
{
	
	//Class Variables
	public $conn = "";					//Connection type variable
	public $echo = "";					//Hardware Echo Cancellation variable
	public $dtmf = "";					//Hardware DTMF variable
	public $fax = "";					//Hardware Fax Detection Variable
	private $error = array();			//Holds the errors created in the form
	public $error_count = "";			//Error counter variable;
	public $untoken_card_name = "";		//Card Name
	public $card_name = "";				//Tokenized card_name
	public $total_ports = "";			//Contains the total number of ports for that particular card
	public $rxgain="";					//RX Gain Parameter
	public $txgain="";					//TX Gain Parameter	
	public $echo_cancel = "";
	
	//Main Display Function
	function main()
	{
		//echo $this->echo . ", " . $this->dtmf . ", " . $this->fax . "<br />";
		//Echo Cancellation Drop Down
		if ($_REQUEST['hw_ec'] == "" && $this->echo == "" )
		{
			$this->pick['hw_ec_yes'] = "yes";
		}
		elseif ($_REQUEST['hw_ec'] == "enable")
		{
			$this->pick['hw_ec_yes'] = "yes";
		}
		elseif ($_REQUEST['hw_ec'] == "disable")
		{
			$this->pick['hw_ec_no'] = "yes";
		}
		elseif ($this->echo == "enable")
		{
			$this->pick['hw_ec_yes'] = "yes";
		}
		elseif ($this->echo == "disable")
		{
			$this->pick['hw_ec_no'] = "yes";
		}
		
		//Hardware DTMF Drop Down
		if ($_REQUEST['hw_dtmf'] == "" && $this->dtmf == "" )
		{
			$this->pick['hw_dtmf_yes'] = "yes";
		}
		elseif ($_REQUEST['hw_dtmf'] == "enable")
		{
			$this->pick['hw_dtmf_yes'] = "yes";
		}
		elseif ($_REQUEST['hw_dtmf'] == "disable")
		{
			$this->pick['hw_dtmf_no'] = "yes";
		}
		elseif ($this->dtmf == "enable")
		{
			$this->pick['hw_dtmf_yes'] = "yes";
		}
		elseif ($this->dtmf == "disable")
		{
			$this->pick['hw_dtmf_no'] = "yes";
		}

		//Hardware Fax Detection Drop Down
		if ($_REQUEST['hw_dtmf'] == "" && $this->dtmf == "" )
		{
			$this->pick['hw_fax_no'] = "yes";
		}
		elseif ($_REQUEST['hw_fax'] == "enable")
		{
			$this->pick['hw_fax_yes'] = "yes";
		}
		elseif ($_REQUEST['hw_fax'] == "disable")
		{
			$this->pick['hw_fax_no'] = "yes";
		}
		elseif ($this->fax == "enable")
		{
			$this->pick['hw_fax_yes'] = "yes";
		}
		elseif ($this->fax == "disable")
		{
			$this->pick['hw_fax_no'] = "yes";
		}		
		
		//RX Gain
		if ($_REQUEST['rxgain'] != "")
		{
			$this->pick['rxgain'] = $_REQUEST['rxgain'];
		}
		elseif ($this->database['rxgain'] != "")
		{
			$this->pick['rxgain'] = $this->database['rxgain'];
		}
		elseif ($_REQUEST['rxgain'] == "")
		{
			$this->pick['rxgain'] = "0.0";
		}	
		
		//RX Gain
		if ($_REQUEST['rxgain'] != "")
		{
			$this->pick['rxgain'] = $_REQUEST['rxgain'];
		}
		elseif ($this->database['rxgain'] != "")
		{
			$this->pick['rxgain'] = $this->database['rxgain'];
		}
		elseif ($_REQUEST['rxgain'] == "")
		{
			$this->pick['rxgain'] = "0.0";
		}	

		//TX Gain
		if ($_REQUEST['txgain'] != "")
		{
			$this->pick['txgain'] = $_REQUEST['txgain'];
		}
		elseif ($this->database['txgain'] != "")
		{
			$this->pick['txgain'] = $this->database['txgain'];
		}
		elseif ($_REQUEST['txgain'] == "")
		{
			$this->pick['txgain'] = "0.0";
		}
				
		echo "<h3>" . $_SESSION['card_clicked'] . " - Port " . $_SESSION['port_num_clicked'] . " - Hardware Configuration</h3>";
		echo "<p>
		Please enter the low level configuration for your " . $_SESSION['card_clicked'] . ".<br />
		Advanced options are available for the " . $_SESSION['card_clicked'] . ". They are populated with their default values, but you may change them if required.
		</p>";
		echo "Port " . $_SESSION['port_num_clicked'] . " Module Type = <strong>" . $_SESSION['bri_type'] . "</strong><br />";		
		echo "<hr style='width:700px;' align='left'/>";		
		?>
		<h4>Standard Options</h4>
    	<form action="" method="post">
        <?php
		if ($this->echo_cancel == 0)
		{
			?>
            <h5>No Echo Canceler Found</h5>
            <?php
		}
		else
		{
		?>  
        	<table>
                <tr>
                	<td>Hardware Echo Cancellation:
                    <td align="right">
                    	<select name="hw_ec">
                        	<option value="yes" <?php if ($this->pick['hw_ec_yes'] == "yes") { ?> selected="selected" <?php } ?>>Enable</option>
                            <option value="no" <?php if ($this->pick['hw_ec_no'] == "yes") { ?> selected="selected" <?php } ?> >Disable</option>
                        </select>
                    </td>
                </tr>
                <tr>
                	<td>Hardware DTMF:
                    <td align="right">
                    	<select name="hw_dtmf">
                        	<option value="yes" <?php if ($this->pick['hw_dtmf_yes'] == "yes") { ?> selected="selected" <?php } ?>>Enable</option>
                            <option value="no" <?php if ($this->pick['hw_dtmf_no'] == "yes") { ?> selected="selected" <?php } ?>>Disable</option>
                        </select>
                    </td>
                    <?php if (isset($this->error['dtmf'])) { ?><td><font color="#FF0000"><?php echo $this->error['dtmf']; ?></font></td><?php } ?>
                </tr>
                <tr>
                	<td>Hardware Fax Detection:
                    <td align="right">
                    	<select name="hw_fax">
                        	<option value="yes" <?php if ($this->pick['hw_fax_yes'] == "yes") { ?> selected="selected" <?php } ?>>Enable</option>
                            <option value="no" <?php if ($this->pick['hw_fax_no'] == "yes") { ?> selected="selected" <?php } ?>>Disable</option>
                        </select>
                    </td>
                    <?php if (isset($this->error['fax'])) { ?> <td><font color="red"><?php echo $this->error['fax']; ?></font></td><?php } ?>
                </tr>                                
            </table>
            <?php
		}
		?>            
            <br />
            <hr style='width:700px;' align='left'/>
            <div class="fakelink"
                    id="show_e"
                    onclick="this.style.display='none';
                    document.getElementById('hide_e').style.display='block';
                    document.getElementById('options').style.display='inline';
                    ResizeFrame();
                    ">&raquo; Show Advanced Options</div>
            <div class="fakelink"
                    id="hide_e"
                    onclick="this.style.display='none';
                    document.getElementById('show_e').style.display='block';
                    document.getElementById('options').style.display='none';
                    ResizeFrame();
                    ">&raquo; Hide Advanced Options</div>
            <div id="options">
            <br />            
            <font color="red">NOTE: These options are set to their default parameters and shouldn't be changed unless required.</font>
            <br />
			<br />
            <table> 
                <tr>
                	<td>RX Gain</td>
                    <td><input type="text" name="rxgain" style="width:30px" value="<?php echo $this->pick['rxgain'];?>" /></td>
					<td><?php echo $this->error['rxgain']; ?></td>
    			</tr>
                <tr>
                	<td>TX Gain</td>
	                <td><input type="text" name="txgain" style="width:30px" value="<?php echo $this->pick['txgain'] ;?>" /></td>
					<td><?php echo $this->error['txgain'];?></td>
                </tr> 
            </table>
            </div>
            <hr style='width:700px;' align='left'/>
            <br /> 
            <table width="700px">
	    	    <tr>
    	    		<td width="1%"><input type="submit" name="apply" value="Apply to Port" <?php echo $_SESSION['button_class']; ?>/></td>
            		<td width="1%"><input type="submit" name="apply-all" value="Apply to all Ports" <?php echo $_SESSION['button_class']; ?>/></td>
					<td align="right"><input type="submit" name="cancel" value="Cancel Configuration" <?php echo $_SESSION['button_class']; ?>/></td>
                </tr>
            </table>
        </form>    
        <?php
	}
	
	//Validates the information
	function validate()
	{
		$this->card_name = $_SESSION['card_clicked'];
		if ($this->echo == "no" && $this->dtmf == "yes")
		{
			$this->error['dtmf'] = "Please Enable Hardware Echo Cancellation";
			$this->error_count++;
		}
		if ($this->echo == "no" && $this->fax == "yes")
		{
			$this->error['fax'] = "Please Enable Hardware Echo Cancellation";
			$this->error_count++;
		}	
		//Validates the RX Gain
		if (is_numeric($_REQUEST['rxgain']))
		{
			if ($_REQUEST['rxgain'] < -50 || $_REQUEST['rxgain'] > 50)
			{
				$this->error_count++;
				$this->error['rxgain'] = "<font color=\"red\"><b>RX Gain</b> must be between <b>-50 and 50</b></font>\n";
			}
		}
		else
		{
			$this->error_count++;			
			$this->error['rxgain'] = "<font color=\"red\"><b>RX Gain</b> must be <b>numeric</b></font>\n";
		}
		
		//Validates the TX Gain
		if (is_numeric($_REQUEST['txgain']))
		{
			if ($_REQUEST['txgain'] < -50 || $_REQUEST['txgain'] > 50)
			{
				$this->error_count++;
				$this->error['txgain'] = "<font color=\"red\"><b>TX Gain</b> must be between <b>-50 and 50</b></font>\n";
			}
		}
		else
		{
			$this->error_count++;			
			$this->error['txgain'] = "<font color=\"red\"><b>TX Gain</b> must be <b>numeric</b></font>\n";
		}			
			
	}
	
	//Tokenizes Card Name
	function tokenize()
	{
		$tok = strtok($this->untoken_card_name, "-");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok("-");
			$count++;
		}
	
		$this->card_name = $token[1];		
	}
	
	function get_ports()
	{
		$db_location = "sqlite:../sqlite/cardinfo.db";
		$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'];
	
		$select = "SELECT port_id FROM " . $table_name . ";";
		unset($this->total_ports);
		$count = 0;
		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
					
			foreach($result as $row)
			{
				if ($_SESSION['card_clicked'] == "B700" && $row['port_id'] == 5)
				{
				}
				else
				{
					$this->total_ports[$count] = $row;
					//echo "port num = " . $this->total_ports[$count]['port_id'] . "<br />";
					$count++;
				}
			}
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}		
	}	
}


?>
