<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//SSH2 CLASS USAGE
//================
/*
---------------------------------------------------------------------------------------------------------------------------------

Creating an SSH Connection:
USAGE: $output = $class->connect($ip_addr,$port);
SSH Connection result returned to variable $output

Variables:
$ip_addr - (IP Address) is the IP address of the remote machine
$port - (ex 22) SSH port of the remote machine

Returns a String with status

---------------------------------------------------------------------------------------------------------------------------------

Disconnecting an SSH Connection:
USAGE: $class->disconnect();

Returns a String with status

---------------------------------------------------------------------------------------------------------------------------------

To copy a file, use the following syntax:
USAGE: $class->copy_file($local_filename,$remote_file_name)
Command result stored in last_result

Variables:
$local_filename - ('/root/826.jpg') location where the file exists
$remote_filename - ('/root/826.jpg') location where the file needs to be copied too

Variable $last_result contains the result of the function

---------------------------------------------------------------------------------------------------------------------------------

To move a file, use the following syntax:
USAGE: $class->move_file($local_filename,$remote_file_name)
Command result stored in last_result

Variables:
$local_filename - ('/root/826.jpg') location where the file exists
$remote_filename - ('/root/826.jpg') location where the file needs to be copied too

Variable $last_result contains the result of the function

---------------------------------------------------------------------------------------------------------------------------------

To run commands over SSH, use the following syntax:
USAGE: $output = $class->execute($cmd)
Returns output
Command result stored in last_result

Variables:
$cmd - (wanrouter hwprobe) command to run over ssh. FULL COMMAND REQUIRED

Variable $last_result contains the result of the function
Returns an array with the output required

---------------------------------------------------------------------------------------------------------------------------------

*/


error_reporting(0);

//Class which contains the execution of either an SSH command or a regular shell_exec for relay
class executor_class
{	
	public $last_result = "";
	private $type = "";
	private $conn;

  function __destruct() {
		if (isset($this->conn)
      &&
			function_exists('ssh2_disconnect'))
		{
      ssh2_disconnect($this->con);
      unset($this->conn);
    }
  }

	//Establishes the SSH connection
	function connect($ip_addr = "",$port = "")
	{
    // Default is failure
    $rc = false;
		if ($ip_addr == "")
		{
			$this->type = "local";
      $rc = true;
		}
		elseif ($ip_addr != "")
		{
			if (isset($this->conn))
			{
				$output = "Connection Already Established";
        $rc = true;
			}
			else
			{
				//Check if it is a local IP or remote IP
        $command = "/sbin/ifconfig -a | grep -e \"inet addr:".$ip_addr."\" | cut -d: -f2 | awk '{ print $1}'";
        $output = shell_exec($command);

        if (trim($output) == trim($ip_addr))
        {
          $this->type = "local";
          $rc = true;
        }
        else
        {
          $remote = "yes";
        }
				
				//IP Address not found on system, assuming remote IP
				if ($remote == "yes")
				{
					//Check IP Address validity
					if (!preg_match('/^(([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]).){3}([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$/',$ip_addr))
					{
						$output = "Invalid IP Address Supplied";
					}
					else
					{
            // First check if system is up and reachable otherwise SSH will last 
            // for 20 sec before timeout
            $output = shell_exec( "ping -c 4 -w 4 -W 1 -s 160 -q -Q 0x18 ". $ip_addr . " &>/dev/null || echo $?");
            if ( !isset($output))
            {
              unset($output);
              if (!function_exists("ssh2_connect")) die("function ssh2_connect doesn't exist");
              if(!($this->con = ssh2_connect($ip_addr, $port,array('hostkey'=>'ssh-rsa'))))
              {
                //echo "fail: unable to establish connection\n";
                $output = "DISABLED";
              } 
              else 
              {
                // try to authenticate with username root, password secretpassword
                //if(!ssh2_auth_password($con, "root", "sangoma")) {
                if (!ssh2_auth_pubkey_file($this->con, 'root','/root/.ssh/nsg_rsa.pub','/root/.ssh/nsg_rsa','')) {
                  //echo "fail: unable to authenticate\n";
                  $output = "INVALID KEY";
                } 
                else 
                {	
                  $output = "Connection Established";	
                  $this->type = "remote";
                  $rc = true;
                }
              }
            }
            else
            {
              unset($output);
              $output = "UNREACHABLE";
            }
          }
				}
			}
		}
		$this->last_result = $output;	
    	return $rc;
	}
	
	//Disconnects the ssh connection
	function disconnect(&$output)
	{
		$rc = false;
		if (isset($this->conn))
		{
			if(!function_exists('ssh2_disconnect')) die ("function ssh2_disconnect doesn't exist");
			if (!ssh2_disconnect($this->con))
			{
				$output = "FAILED TO DISCONNECT";
			}
			else
			{
				$output = "DISCONNECTION COMPLETE";
				$rc = true;
			}
		}
		
		unset($this->conn);
		
		return $rc;
	}
	
	//Decides to run SCP or local exec
	function copy_file($local_filename,$remote_file_name)
	{
		$this->last_result = "";
		
		if ($this->type == "local")
		{
			//$cmd = "pidof sshd";
			//echo $cmd;
			$command = "cp " . $local_filename . " " . $remote_file_name;
			shell_exec($command);
		}
		elseif ($this->type == "remote")
		{
			
			if (ssh2_scp_send($this->con,$local_filename, $remote_file_name))
			{
				$this->last_result = "PASSED";
			}
			else
			{
				$this->last_result = "FAILED";
			}		
		}	
	}
	
	//Decides to run SCP or local exec
	function move_file($local_filename,$remote_file_name)
	{
		$this->last_result = "";
		
		if ($this->type == "local")
		{
			//$cmd = "pidof sshd";
			//echo $cmd;
			$command = "mv " . $local_filename . " " . $remote_file_name;
			shell_exec($command);
		}
		elseif ($this->type == "remote")
		{
			
			if (ssh2_scp_send($this->con,$local_filename, $remote_file_name))
			{
				shell_exec("rm " . $local_filename);
				$this->last_result = "PASSED";
			}
			else
			{
				$this->last_result = "FAILED";
			}		
		}	
	}
	
	//Decides whether to run local exec or ssh exec
	function execute($cmd, &$output)
	{
		$this->last_result = "";
		if ($this->type == "local")
		{
			//$cmd = "pidof sshd";
			exec($cmd,$output);
			//echo $cmd . "<br />";
      		//print_r($output);
			//echo "<br />";
      		$this->last_result = "PASSED";
		}
		elseif ($this->type == "remote")
		{
			// execute a command
			if (!($stream = ssh2_exec($this->con, $cmd))) {
				//echo "fail: unable to execute command\n";
				$output[0] = "DISABLED";
				$this->last_result = "FAILED";
			} 
			else 
			{
				// collect returning data from command
				stream_set_blocking($stream, true);
				$a = 0;
				 while($line = fgets($stream)) 
				 { 
					flush(); 
					//echo $line."<br />"; 
					$output[$a] = $line;
					$a++;
				}
				
				fclose($stream);
				$this->last_result = "PASSED";
			}
		}
		return ($this->last_result == "PASSED");
	}
}

?>
