<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//SSH2 CLASS USAGE
//================
/*

To run SCP commands, use the following syntax:
USAGE: $class->send_file($type,$ip_addr,$port,$local_filename,$remote_file_name,$cmd)
Command result stored in last_result

Variables:
$type - (local/remote) is whether you are running a local shell command or you are transferring a file to a remote machine
$ip_addr - (IP Address) is the IP address of the remote machine
$port - (ex 22) SSH port of the remote machine
$local_filename - ('/root/826.jpg') location where the file exists
$remote_filename - ('/root/826.jpg') location where the file needs to be copied too
$cmd - (mv or cp) local copy or move commands to run if $type is set to local

To run commands over SSH, use the following syntax:
USAGE: $output = $class->execute($type,$cmd, $ip_addr, $port)
Returns output
Command result stored in last_result

Variables:
$type - (local/remote) is whether you are running a local shell command or you are transferring a file to a remote machine
$ip_addr - (IP Address) is the IP address of the remote machine
$port - (ex 22) SSH port of the remote machine
$cmd - (wanrouter hwprobe) command to run over ssh. FULL COMMAND REQUIRED
*/


error_reporting(0);

//Class which contains the execution of either an SSH command or a regular shell_exec for relay
class ssh_class
{
	public $last_result = "";
	
	//Decides to run SCP or local exec
	function send_file($type,$ip_addr,$port,$local_filename,$remote_file_name,$cmd)
	{
		$this->last_result == "";
		//echo $type;
		if ($type == "local")
		{
			//$cmd = "pidof sshd";
			//echo $cmd;
			$command = $cmd . " " . $local_filename . " " . $remote_file_name;
			shell_exec($command);
		}
		elseif ($type == "remote")
		{
			if (!function_exists("ssh2_connect")) die("function ssh2_connect doesn't exist");
			//echo time() . "<br />";
			if(!($con = ssh2_connect($ip_addr, $port,array('hostkey'=>'ssh-rsa'))))
			{
				//echo "fail: unable to establish connection\n";
				$output[0] = "DISABLED";
			} 
			else 
			{
				// try to authenticate with username root, password secretpassword
				//if(!ssh2_auth_password($con, "root", "sangoma")) {
				if (!ssh2_auth_pubkey_file($con, 'root','/root/.ssh/nsg_rsa.pub','/root/.ssh/nsg_rsa','')) {
					//echo "fail: unable to authenticate\n";
					$output[0] = "INVALID KEY";
				} 
				else 
				{
					// allright, we're in!
					//echo "okay: logged in...\n";
					//echo $file_loc1 . "<br />";
					//echo $file_loc2 . "<br />";
					if (ssh2_scp_send($con,$local_filename, $remote_file_name))
					{
						shell_exec("rm " . $local_filename);
						$this->last_result == "PASSED";
						//echo time();
					}
					else
					{
						$this->last_result == "FAILED";
					}
				}
			}
		}
		//echo $this->last_result . "<br />";
		//echo $output[0];
		return $output;		
	}
	
	//Decides whether to run local exec or ssh exec
	function execute($type,$cmd, $ip_addr, $port)
	{
		$this->last_result == "";
		//echo $cmd;
		if ($type == "local")
		{
			//$cmd = "pidof sshd";
			//echo $cmd . "<br />";
			exec($cmd,$output);
		}
		elseif ($type == "remote")
		{
			if (!function_exists("ssh2_connect")) die("function ssh2_connect doesn't exist");
			if(!($con = ssh2_connect($ip_addr, $port,array('hostkey'=>'ssh-rsa'))))
			{
				//echo "fail: unable to establish connection\n";
				$output[0] = "DISABLED";
				$this->last_result = "FAILED";
			} 
			else 
			{
				// try to authenticate with username root, password secretpassword
				//if(!ssh2_auth_password($con, "root", "sangoma")) {
				if (!ssh2_auth_pubkey_file($con, 'root','/root/.ssh/nsg_rsa.pub','/root/.ssh/nsg_rsa','')) {
					//echo "fail: unable to authenticate\n";
					$output[0] = "INVALID KEY";
					$this->last_result = "FAILED";
				} 
				else 
				{
					// allright, we're in!
					//echo "okay: logged in...\n";
			
					// execute a command
					if (!($stream = ssh2_exec($con, $cmd))) {
						//echo "fail: unable to execute command\n";
						$output[0] = "DISABLED";
						$this->last_result = "FAILED";
					} 
					else 
					{
						// collect returning data from command
						stream_set_blocking($stream, true);
						/*$data = "";
						while ($buf = fread($stream,4096)) {
							$data .= $buf;
						}*/
						$a = 0;
						 while($line = fgets($stream)) 
						 { 
							flush(); 
							//echo $line."<br />"; 
							$output[$a] = $line;
							$a++;
						}
						
						fclose($stream);
						$this->last_result = "PASSED";
					}
				}
			}
		}
		//echo $output[0];
		return $output;
	}
}

?>