<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class ss7_linkset_view_profile_class extends database_class
{
	
	//Variable declarations
	public $proc_id="";						//Contains the proc_id
	private $all_proc=array();				//Contains all the proc_ids
	private $counter = int;					//Contains the total number of profiles
	public $profile_array = array();		//Contains the Analog Profiles in an array	
	public $total_ports = int;				//Contains the total number of ports for the card in question
	public $conn_type = "";					//Contains the connection type for the port
	private $table_name = "";				//Contains the sql table name
	private $all_cards = array();			//Contains all the cards in the database
	public $error_linkset="";				//Contains the state of linkset binding
	private $bind_error_msg="";				//Contains the error message shown for a bad bind
	private $link="";						//Contains the link in use
	public $clicked_id = "";				//Contains the clicked id for linkset binding
	private $linkset="";					//Contains the Linkset value for the link chosen
	
	//Function that retrieves the linkset profiles from the database and stores it in a multi-dimensional array
	function get_profiles()
	{
		/*$relay_type = parent::select_statement('sqlite:../sqlite/relay_info.db', 'ss7_relay', "machine_type, relay_type", $where);
		
		//GET ALL PROFILES FROM ALL DATABASES
		
		if ($relay_type['machine_type'] == "standalone" || $relay_type['relay_type'] == "SLAVE")
		{
			$count_hosts['count(id)'] = 1;
		}
		else
		{
			$count_hosts = parent::select_statement('sqlite:../sqlite/relay_info.db','relay_hosts','count(id)',"");
			//echo $count_hosts['count(id)'];
		}
		
		$a = 0;
		
		for ($b = 1; $b <= $count_hosts['count(id)']; $b++)
		{
			/*if ($b == 1)
			{
				$db_location = "sqlite:../sqlite/cardinfo.db";	
			}
			elseif ($b > 1)
			{
				$db_location = "sqlite:../sqlite/cardinfo" . $b . ".db";
			}
			$this->all_proc[$a] = $b;
			$a++;
		}*/
		
		$a = 0;
					
		$db_location = "sqlite:../sqlite/cardinfo.db";
		$where_param = "";
		//echo $db_location . "<br />";

		$select = "SELECT * FROM " . $this->table_name . ";";
		
		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
			foreach($result as $row)
			{
				$this->profile_array[$a] = $row;
				//echo "card = " . $this->profile_array[$a]['dev_name'] . "<br />";
				
				//echo $this->all_proc[$a] . "<br />";
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}
		$this->counter = $a;
	}

	function display_profiles()
	{
		if ($this->proc_id == 1)
		{
			$db_location = "sqlite:../sqlite/cardinfo.db";	
		}
		elseif ($this->proc_id > 1)
		{
			$db_location = "sqlite:../sqlite/cardinfo" . $this->proc_id . ".db";
		}			
		
		$table_name = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_SS7_link";
		$where = "port_id = " . $_SESSION['port_num_clicked'];
		//$db_location = "sqlite:../sqlite/cardinfo.db";
		$this->link = parent::select_statement($db_location, $table_name, "link_name, linkset", $where);
		
		$where = "id = " . $_SESSION['last_route'];
		//$db_location = "sqlite:../sqlite/cardinfo.db";
		//$route = parent::select_statement($db_location, "ss7_route_profile", "profile_name", $where);		
		
		//echo "$db_location <br />";
		
		if ($_SESSION['linkset'] == "Start")
		{
?>	
		<h2>SS7 LINKSET CONFIGURATION</h2>
<?php			
			if ($this->link['linkset'] != "")
			{
				echo "Below is a list of all SS7 linksets..<br />
				You can manage these linksets using the Edit and Delete buttons next to each linkset.<br /><br />
				If you do not need to make any changes to your linksets, click NEXT to continue.";
			}
			else
			{
				echo "Below is a list of all SS7 linksets.<br />
				You can manage these linksets using the Edit and Delete buttons next to each linkset.<br /><br />
				In order to proceed, please <b>BIND <font color=\"#6698FF\">" . $this->link['link_name'] . "</font></b> to a Linkset";
			}
		}
		elseif ($_SESSION['linkset'] == "Done")
		{
?>	
		<h2>SS7 ROUTE MANAGEMENT</h2>
<?php			
			echo "Below is a list of SS7 Routes.<br />
			You can manage these routes using the Edit and Delete buttons next to each route.<br /><br />
			A <b>MINIMUM</b> of 1 Route must be configured.<br />";
			
			if ($_SESSION['deleted_linkset'] == "yes")
			{
				echo "<font color=\"red\">NOTE:All the previous linksets were deleted. Please reset your route configurations as they are no longer valid</font><br />\n";
			}
		}
		elseif ($_SESSION['route'] == "Done")
		{
?>	
		<h2>SS7 ISUP INTERFACE MANAGEMENT</h2>
<?php			
			
			echo "Below is a list of SS7 ISUP Interfaces<br />
			You can manage these ISUP Interfaces using the Edit and Delete buttons next to each ISUP Interface.<br /><br />
			A <b>MINIMUM</b> of 1 ISUP Interface must be configured.<br />";
			
			if ($_SESSION['deleted_route'] == "yes")
			{
				echo "<font color=\"red\">NOTE:All the previous routes were deleted. Please reset your ISUP interfaces as they are no longer valid</font><br />\n";
			}			
		}
?>        
        <br />
        <br />
		<form name="view" method="post">
        
<?php
	if ($_SESSION['linkset'] == "Start")
		{
			
			if ($this->bind_error_msg != "")
			{
				echo $this->bind_error_msg . "<br />";
			}
			
			//Retrieve linkset Profile Information
			$this->table_name = "ss7_linkset_profile";
			$check = parent::check_for_table($db_location, $this->table_name);
			if ($check > 1)
			{
				$this->get_profiles();
			}
			
?>        
       	<table class="mytable" width="580px">
        	<th class="widget-content-header ui-state-active ui-corner-top" colspan="6" align="left">Linkset Profiles</th>
            <tr>
    		<td class="mytableheader ">Profile Name</td>
            <td class="mytableheader ">Adjacent Point Code</td> 
            <td class="mytableheader ">Minimum Signalling Links</td>
            <td class="mytableheader " colspan='3'></td>
            </tr>
<?php				
			//echo $this->counter;
            for ($b = 0; $b < $this->counter; $b++)
            {
				if ($this->profile_array[$b]['profile_name'] == $this->link['linkset'])
				{
					$font_start = "<font color=\"#6698FF\">";
					$font_end = "</font>";
				}
                echo "\t\t\t<tr>\n";
                if ($_SESSION['last_profile'] == $this->profile_array[$b]['profile_name'])
                {
					unset($_SESSION['ccspan']);
					$do_no_proceed = "yes";
					if ($this->profile_array[$b]['profile_name'] == $this->link['linkset'])
					{
						echo "\t\t\t\t<td>" . $font_start . "<b>" . $this->profile_array[$b]['profile_name'] . "</b>" . $font_end . "</td>\n";
					}
					else
					{
                    	echo "\t\t\t\t<td><b>" . $this->profile_array[$b]['profile_name'] . "</b></td>\n";
					}
                }
                else
                {
					if ($this->profile_array[$b]['profile_name'] == $this->link['linkset'])
					{
						echo "\t\t\t\t<td>" . $font_start . "" . $this->profile_array[$b]['profile_name'] . "" . $font_end . "</td>\n";
					}
					else
					{
                    	echo "\t\t\t\t<td>" . $this->profile_array[$b]['profile_name'] . "</td>\n";
					}					
                }
				
                echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['apc'] . "</td>\n";
                echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['minactive'] . "</td>\n";
				if ($this->profile_array[$b]['profile_name'] != $this->link['linkset'])
				{		
	                echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"use-linkset" . $this->profile_array[$b]['id'] . "\" value=\"Bind Linkset\" " . $_SESSION['button_class'] . "/></td>\n";			
				}
				else
				{
					echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"use-linkset" . $this->profile_array[$b]['id'] . "\" value=\"Bind Linkset\" " . $_SESSION['disabled_button_class'] . " disabled=\"disabled\"/></td>\n";		
				}
				
                echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"config-linkset" . $this->profile_array[$b]['id'] . "\" value=\"Edit Linkset\" " . $_SESSION['button_class'] . "/></td>\n";
				
				//Check to see whether the linkset is bound to anything. If it is, do not allow deletion the linkset
				$linkset_found = $this->find_linksets_used();
				
				for ($ll = 0; $ll <= count($linkset_found); $ll++)
				{
					//echo $this->profile_array[$b]['profile_name'] . " - " . $linkset_found[$ll]['name'] . "<br />";
					if ($linkset_found[$ll]['name'] == $this->profile_array[$b]['profile_name'])
					{
						$found_linkset = "yes";
					}
				}
				
				/*if ($linkset_found[$ll]['name'] != $this->profile_array[$b]['profile_name'])
				{					
					echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"delete-linkset" . $this->profile_array[$b]['id'] . "\" value=\"Delete Linkset\" " . $_SESSION['button_class'] . "/></td>\n";
				}*/
				if ($found_linkset =="yes")
				{
					//$_SESSION[$hash] = $hash;
					echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"delete-linkset" . $this->profile_array[$b]['id'] . "\" value=\"Linkset in Use\" " . $_SESSION['disabled_button_class'] . " disabled=\"disabled\"/></td>\n";
					//echo "\t\t\t\t<td><font color=\"red\">In use by " . $this->link['link_name'] . "</font></td>";
				}
				else
				{
					echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"delete-linkset" . $this->profile_array[$b]['id'] . "\" value=\"Delete Linkset\" " . $_SESSION['button_class'] . "/></td>\n";
				}
                echo "\t\t\t<tr>\n";
                $num_entries++;
				
				if (!isset($do_no_proceed))
				{
					$_SESSION['ccspan'] = "yes";
				}
								
				//If this link has a linkset bound to it, show the next button
				if ($this->link['linkset'] != "")
				{
					unset($_SESSION['ccspan']);
					$_SESSION['next'] = "yes";
				}				
            }		
			
			//If No linksets exist, remove the finish or next buttons
			if (count($this->profile_array) == 0)
			{
				//Don't display anything
				$_SESSION['deleted_linkset'] = "yes";
			}			
        
            //Puts the number of entries in the database into a session variable
            $_SESSION['num_entries-linkset'] = $num_entries;
?>	        
		</table> 
		<br />	        
    	<input type="submit" name="create_linkset" value="Create Linkset" <?php echo $_SESSION['button_class']; ?>/>
        <br />
<?php
		}
		//Route Profile Page
		elseif ($_SESSION['linkset'] == "Done")
		{
			//Retrieve route Profile Information
			$this->table_name = "ss7_route_profile";
			$check = parent::check_for_table($db_location, $this->table_name);
			if ($check > 1)
			{
				$this->get_profiles();
			}
?>        
       	<table class="mytable" width="350px">
        	<th class="widget-content-header ui-state-active ui-corner-top" colspan="4" style='text-align:left'>Route Profiles</th>
            <tr>
    			<td class="mytableheader ">Profile Name</td>
	            <td class="mytableheader ">Destination Point Code</td> 
	            <td class="mytableheader " colspan='2'></td>
            </tr>
<?php				

			for ($b = 0; $b < $this->counter; $b++)
			{
				echo "\t\t\t<tr>\n";
				if ($_SESSION['last_profile'] == $this->profile_array[$b]['profile_name'])
				{
					echo "\t\t\t\t<td><b>" . $this->profile_array[$b]['profile_name'] . "</b></td>\n";
				}
				else
				{
					echo "\t\t\t\t<td>" . $this->profile_array[$b]['profile_name'] . "</td>\n";
				}
				echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['dpc'] . "</td>\n";
				//echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"use-route" . $this->profile_array[$b]['id'] . "\" value=\"Bind Route\" /></td>\n";
				echo "\t\t\t\t<td><input type=\"submit\" name=\"config-route" . $this->profile_array[$b]['id'] . "\" value=\"Edit Route\" " . $_SESSION['button_class'] . "/></td>\n";
				
				//Check to see whether the route is bound to anything. If it is, do not allow deletion of the route interface				
				$route_found = $this->find_routes_used();
				
				for ($ll = 0; $ll <= count($route_found); $ll++)
				{
					//echo $this->profile_array[$b]['profile_name'] . " - " . $route_found[$ll]['name'] . "<br />";
					if ($route_found[$ll]['name'] == $this->profile_array[$b]['profile_name'])
					{
						$found_route = "yes";
					}
				}
				
				if ($found_route =="yes")
				{
					echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"delete-route" . $this->profile_array[$b]['id'] . "\" value=\"Route in Use\" " . $_SESSION['disabled_button_class'] . " disabled=\"disabled\"/></td>\n";
				}
				else
				{
					echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"delete-route" . $this->profile_array[$b]['id'] . "\" value=\"Delete Route\" " . $_SESSION['button_class'] . "/></td>\n";	
				}
									
				
				//echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"delete-route" . $this->profile_array[$b]['id'] . "\" value=\"Delete Route\" " . $_SESSION['button_class'] . "/></td>\n";			
				echo "\t\t\t<tr>\n";
				$num_entries++;
			}		
		
			//If No Routes Exist, remove the finish or next buttons
			if (count($this->profile_array) == 0)
			{
				//Don't display anything
				$_SESSION['deleted_route'] = "yes";	
			}
			else
			{
				unset($_SESSION['deleted_route']);
			}
			
			//Continue to ISUP Interface button if new route is added or all routes were deleted. 
			if ($_SESSION['new_route'] == "yes" || $_SESSION['deleted_route'] == "yes")
			{
				$_SESSION['next_route'] = "yes";
				unset($_SESSION['continue_isup']);
				unset($_SESSION['route_finish']);
			}
			else
			{
				$_SESSION['continue_isup'] = "yes";
				$_SESSION['route_finish'] = "yes";
			}
		
			//Puts the number of entries in the database into a session variable
			$_SESSION['num_entries-route'] = $num_entries;
?>	            
        </table>
   
<?php
		echo "<br />\n";
?>	        
    	<input type="submit" name="create_route" value="Create Route" <?php echo $_SESSION['button_class']; ?>/>
        <br />
<?php
		}
		//ISUP Profile Page
		elseif ($_SESSION['route'] == "Done")
		{	
			unset($_SESSION['continue_isup']);
			unset($_SESSION['linkset']);		
			//Retrieve route Profile Information
			$this->table_name = "ss7_isup_profile";
			$check = parent::check_for_table($db_location, $this->table_name);
			if ($check > 1)
			{
				$this->get_profiles();
			}

?>        
       	<table class="mytable" width="450px">
        	<th class="widget-content-header ui-state-active ui-corner-top" colspan="5" style='text-align:left'>ISUP Profiles</th>
            <tr>
	    		<td class="mytableheader ">Profile Name</td>
	            <td class="mytableheader ">Self Point Code</td>
	            <td class="mytableheader ">Attached Route</td>
	            <td class="mytableheader " colspan='2'></td>
            </tr>
<?php				
			
		for ($b = 0; $b < $this->counter; $b++)
		{
			echo "\t\t\t<tr>\n";
			if ($_SESSION['last_profile'] == $this->profile_array[$b]['profile_name'])
			{
				$_SESSION['isup_created'] = "yes";
				echo "\t\t\t\t<td><b>" . $this->profile_array[$b]['profile_name'] . "</b></td>\n";
			}
			else
			{
				$_SESSION['isup_created'] = "yes";
				echo "\t\t\t\t<td>" . $this->profile_array[$b]['profile_name'] . "</td>\n";
			}
			echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['spc'] . "</td>\n";
			echo "\t\t\t\t<td>" . $this->profile_array[$b]['route'] . "</td>\n";
			//echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"use-isup" . $this->profile_array[$b]['id'] . "\" value=\"Bind ISUP Interface\" /></td>\n";
			echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"config-isup" . $this->profile_array[$b]['id'] . "\" value=\"Edit ISUP Interface\" " . $_SESSION['button_class'] . "/></td>\n";
			
			//Check to see whether the isup is bound to anything. If it is, do not allow deletion of the route interface				
			$isup_found = $this->find_isups_used();
			
			for ($ll = 0; $ll <= count($isup_found); $ll++)
			{
				//echo $this->profile_array[$b]['profile_name'] . " - " . $isup_found[$ll]['name'] . "<br />";
				if ($isup_found[$ll]['name'] == $this->profile_array[$b]['profile_name'])
				{
					$found_isup = "yes";
				}
			}
			
			if ($found_isup =="yes")
			{
				echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"delete-isup" . $this->profile_array[$b]['id'] . "\" value=\"Interface in Use\" " . $_SESSION['disabled_button_class'] . " disabled=\"disabled\"/></td>\n";
			}
			else
			{
				echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"delete-isup" . $this->profile_array[$b]['id'] . "\" value=\"Delete Interface\" " . $_SESSION['button_class'] . "/></td>\n";	
			}			
					
			
			//echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"delete-isup" . $this->profile_array[$b]['id'] . "\" value=\"Delete ISUP Interface\" " . $_SESSION['button_class'] . "/></td>\n";			
			echo "\t\t\t<tr>\n";
			$num_entries++;
		}		
	
		//Check to see if a new route was created
		if ($_SESSION['new_route'] == "yes")
		{
		}
		else
		{
			unset($_SESSION['new_route']);
		}
	
		//Puts the number of entries in the database into a session variable
		$_SESSION['num_entries-isup'] = $num_entries;
?>
        </table>        
		<br />            
        
    	<input type="submit" name="create_isup" value="Create ISUP Interface" <?php echo $_SESSION['button_class']; ?>/>
		<br />
<?php
		}
		
		if ($_SESSION['error']  != "")
		{
			echo "<br /><br /><b><font color=\"red\">PLEASE CREATE AN ISUP INTERFACE TO PROCEED</font></b><br />\n";
		}
?>        
        <table width="560">
        	<tr>
<?php
		
		//Back buttons
		if ($_SESSION['linkset'] == "Done")
		{
			echo "<td><input type=\"submit\" name=\"back-route\" value=\"<- Back\" " . $_SESSION['button_class'] . "/></td>";
		}
		elseif ($_SESSION['route'] == "Done")
		{
			echo "<td><input type=\"submit\" name=\"back-isup\" value=\"<- Back\" " . $_SESSION['button_class'] . "/></td>";			
		}

		
		if ($_SESSION['deleted_linkset'] == "yes" || $_SESSION['deleted_route'] == "yes")
		{
		}
		//Go to Route Creation if new linkset is created
		elseif ($_SESSION['next'] == "yes")
		{
			echo "<td><input type=\"submit\" name=\"back-route\" value=\"Next ->\" " . $_SESSION['button_class'] . "/></td>";
		}
		//Finish button if no new linkset was created
		elseif ($_SESSION['finish'] == "yes")
		{
			echo "<td><input type=\"submit\" name=\"back-isup\" value=\"Finish\" " . $_SESSION['button_class'] . "/></td>";
		}
		//Go to ISUP Interfaces if new route is created
		elseif ($_SESSION['next_route'] == "yes"  && $_SESSION['new_linkset'] != "yes" || $_SESSION['continue_isup'] == "yes" && $_SESSION['new_linkset'] != "yes")
		{
			echo "<td><input type=\"submit\" name=\"back-route2\" value=\"Next ->\" " . $_SESSION['button_class'] . "/></td>";
		}
		//Finish button if no New Route was created
		elseif ($_SESSION['route_finish'] == "yes")
		{
			echo "<td><input type=\"submit\" name=\"back-isup\" value=\"Finish\" " . $_SESSION['button_class'] . "/></td>";			
		}
		//Finish button when all 3 steps are completed
		elseif ($_SESSION['route'] == "Done" && $_SESSION['isup_created'] == "yes" && !isset($_SESSION['new_route']))
		{
			echo "<td><input type=\"submit\" name=\"back-isup\" value=\"Finish\" " . $_SESSION['button_class'] . "/></td>";			
		}
	
?>		
    	<td width="500px" align="right"><input type="submit" name="back" value="Cancel" <?php echo $_SESSION['button_class']; ?> /></td>   
<?php	
?>
</form>        

<?php
	}
	
	//Tokenizes the TON,NPI and MSN values for entry into the form
	function tokenize_values($string)
	{
		$tok = strtok($string, ",");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok= strtok(",");
			$count++;
		}	
		
		for ($a = 0; $a < $count; $a++)
		{
			if ($token[$a] == " " || $token[$a] == "  ")
			{
			}
			else
			{
				$counter++;
			}
		}
		
		return $counter;		
	}	

	function tokenize_card_name($string)
	{
		$tok = strtok($string, "-");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok= strtok("-");
			$count++;
		}			
		
		return $token[1];
	}
	
	function check_linksets()
	{
		//Check if the link being bound has the same link type, switchtype and unique SLC value as all the other links attached to this linkset
		//If the linkset is not tied to any link, allow it
		//If it isn't then check to make sure all the attached links have the same values
		
		//Pull the cards
		/*if ($this->proc_id == 1)
		{
			$db_location = "sqlite:../sqlite/cardinfo.db";	
		}
		elseif ($this->proc_id > 1)
		{
			$db_location = "sqlite:../sqlite/cardinfo" . $this->proc_id . ".db";
		}*/
		$count = 0;
		$error = 0;
		$relay_count = parent::select_statement('sqlite:../sqlite/relay_info.db','relay_hosts','count(id)','');
		
		for ($ll = 1; $ll <= $relay_count['count(id)']; $ll++)
		{	
		
			if ($ll == 1)
			{
				$db_location = "sqlite:../sqlite/cardinfo.db";	
			}
			else
			{	
				$db_location = "sqlite:../sqlite/cardinfo" . $ll . ".db";
			}
			//echo $db_location;
			
			//$db_location = "sqlite:../sqlite/cardinfo.db";
			$this->table_name = "card_present";
			$this->get_profiles();
			
			
			for ($b = 0; $b < $this->counter; $b++)
			{
				//Tokenize the name of the card
				$card =$this->tokenize_card_name($this->profile_array[$b]['dev_name']);
				//echo $card . "<br />";
				//check if any cards have a bound linkset
				if ($card == "A101" || $card == "A102" || $card == "A104" || $card == "A108" || $card == "B601")
				{
					$table_name = $card . "_" . $this->profile_array[$b]['id'] . "_SS7_link";
					
					$table_exists = parent::check_for_table ($db_location, $table_name);
					
					if ($table_exists > 1)
					{
						//echo "i am here";
						//Table exists
						$select = "SELECT link_name, SLC, linkset, switchtype, link_type FROM " . $table_name . ";";
						
						try
						{
							//open the database
							$db = new PDO($db_location);
				
							$result = $db->query($select);
						
							foreach($result as $row)
							{
							
								$count++;
								$linkset[$count] = $row;
								//echo "linkset = " . $linkset[$count]['link_name'] . "<br />";
								//echo "SLC = " . $linkset[$count]['SLC'] . "<br />";
								$b++;
							}
							// close the database connection
							$db = NULL;
							}
						catch(PDOException $e)
						{
							print 'Exception : '.$e->getMessage();
						}
					}
				}
	
			}	
			//echo $count . "<br />";
		}
		
		if ($this->proc_id == 1)
		{
			$db = "sqlite:../sqlite/cardinfo.db";
		}
		else
		{
			$db = "sqlite:../sqlite/cardinfo" . $this->proc_id . ".db";
		}
		
		//Compare values
		$table_name = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_SS7_link";
		$where = "port_id = " . $_SESSION['port_num_clicked'];
		//$db_location = "sqlite:../sqlite/cardinfo.db";
		$this->link = parent::select_statement($db, $table_name, "link_name, SLC, linkset, switchtype, link_type", $where);
		
		$param = "profile_name";
		$where_param = "id = " . $this->clicked_id;
		$values = parent::select_statement ('sqlite:../sqlite/cardinfo.db', "ss7_linkset_profile", $param, $where_param);

		//echo "profile = " . $values['profile_name'] . "<br />";
		//echo "SLC = " . $this->link['SLC'] . "switchtype = " . $this->link['switchtype'] . " linktype = " . $this->link['link_type'] . "<br /><hr style='width:700px;' align='left'/>";

		for ($a = 1; $a <= $count; $a++)
		{
			for ($c = 0; $c <= $b; $c++)
			{
				//echo "SLC = " . $linkset[$a][$c]['SLC'] . "switchtype = " . $linkset[$a][$c]['switchtype'] . " linktype = " . $linkset[$a][$c]['link_type'] . "<br />";
				//echo "SLC = " . $linkset[$a]['SLC'] . "switchtype = " . $linkset[$a]['switchtype'] . " linktype = " . $linkset[$a]['link_type'] . "<br />";
				
				if ($this->link['link_name'] != $linkset[$a]['link_name'] && $values['profile_name'] == $linkset[$a]['linkset'])
				{
					//echo "i am here <br />";
					if ($this->link['SLC'] == $linkset[$a]['SLC'] || $this->link['switchtype'] != $linkset[$a]['switchtype'] || $this->link['link_type'] != $linkset[$a]['link_type'])
					{
						$error++;
					}
				}
			}
		}

		//echo $error . "<br />";

		if ($error > 0 )
		{
			//echo "here";
			$this->error_linkset = "error";
			$this->bind_error_msg = "<font color=\"red\">Cannot <b>BIND</b> Linkset. Please Create a new Linkset for the link <b>" . $this->link['link_name'] . "</b> <br />because the SLC values are the same or they have different a link type or Switchtype as other links bound to <b>" . $values['profile_name'] . "</b></font><br />";
		}
		elseif ($error == 0)
		{
			$this->error_linkset = "pass";
		}
				
	}
	
	//Unsets all session variables attached to the SS7 Configuration Page
	function unset_sessions()
	{
		unset ($_SESSION['last_profile']);
		unset ($_SESSION['linkset']);
		unset ($_SESSION['route']);
		unset ($_SESSION['last_profile']);
		unset ($_SESSION['skip_all']);
		unset ($_SESSION['skip_route']);
		unset ($_SESSION['skip_isup']);
		unset ($_SESSION['last_route']);
		unset ($_SESSION['error']);
		unset ($_SESSION['isup_created']);
		unset ($_SESSION['new_linkset']);
		unset ($_SESSION['new_route']);
		unset ($_SESSION['route_finish']);
		unset ($_SESSION['finish']);
		unset ($_SESSION['next']);
		unset ($_SESSION['next_route']);
		unset ($_SESSION['new_route']);	
		unset ($_SESSION['deleted_route']);	
		unset ($_SESSION['deleted_linkset']);
		unset ($_SESSION['continue_isup']);
		unset ($_SESSION['ccspan']);
		unset ($_SESSION['new_linkset']);
		unset ($_SESSION['new_route']);
	}

	//Remove linkset values from ss7 links bound that linkset
	function remove_linksets($link_name)
	{
		if ($this->proc_id == 1)
		{
			$db_location = "sqlite:../sqlite/cardinfo.db";	
		}
		elseif ($this->proc_id > 1)
		{
			$db_location = "sqlite:../sqlite/cardinfo" . $this->proc_id . ".db";
		}	
					
		//$db_location = "sqlite:../sqlite/cardinfo.db";
	
		$select = "SELECT id, dev_name FROM card_present;";

		//While Loop Counter
		$a = 1;
		
		//open the database
		$db = new PDO($db_location);

		$result = $db->query($select);
		
		foreach($result as $row)
		{
			$cards[$a] = $row;

			$device[$a]['dev_name'] = $this->tokenize_wanpipe($cards[$a]['dev_name']);
			//echo "Device name = " . $device[$a]['dev_name'] . "<br />";
			//echo "Card number = " . $cards[$a]['id'] . "<br />"; 				
			
			$table_name = $device[$a]['dev_name'] . "_" . $cards[$a]['id'] . "_SS7_link";
			$ss7_link = parent::check_for_table ($db_location, $table_name);							
			
			if ($ss7_link > 1)
			{
				$a++;						
			}
		}
		// close the database connection
		$db = NULL;
	
		//Pull information out of tables
		/*for ($b = 1; $b < $a; $b++)
		{
			$table = $device[$b]['dev_name'] . "_" . $cards[$b]['id'] . "_SS7_link";
			
			$select = "SELECT port_id FROM " . $table . " where linkset = \"$link_name\";";
					
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
			
			foreach($result as $row)
			{						
				if ($result['port_id'] != "")
				{					
					//Update the table that has the profile name to null
					$parameters = "linkset = \"\"";
					$where_param = "port_id = " . $result['port_id'];
					parent::update_table($db_location, $table, $parameters, $where_param); 
				}
			}
			// close the database connection
			$db = NULL;		
		}*/
		
	}
	
	//Tokenizes the device name
	function tokenize_wanpipe($string)
	{
		$tok = strtok($string, "-");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
			$tok = strtok("-");
			$count++;
		}
	
		return $token[1];
	}

	function find_linksets_used()
	{
		$a = 0;
		$relay_count = parent::select_statement('sqlite:../sqlite/relay_info.db','relay_hosts','count(id)','');
		
		for ($ll = 1; $ll <= $relay_count['count(id)']; $ll++)
		{	
		
			if ($ll == 1)
			{
				$db_location = "sqlite:../sqlite/cardinfo.db";	
			}
			else
			{	
				$db_location = "sqlite:../sqlite/cardinfo" . $ll . ".db";
			}
			//echo $db_location;
			
			$select = "SELECT name FROM used_linkset;";
		
			try
			{
				//open the database
				$db = new PDO($db_location);
	
				$result = $db->query($select);
			
				foreach($result as $row)
				{
					$profile_array[$a] = $row;
					//echo "card = " . $profile_array[$a]['name'] . "<br />";
					
					//echo $this->all_proc[$a] . "<br />";
					$a++;
				}
				// close the database connection
				$db = NULL;
			}
			catch(PDOException $e)
			{
				print 'Exception : '.$e->getMessage();
			}	
			//echo $a . "<br />";
		}		
	
		return $profile_array;
	}

	function find_routes_used()
	{		
		$a = 0;
		$relay_count = parent::select_statement('sqlite:../sqlite/relay_info.db','relay_hosts','count(id)','');
		
		for ($ll = 1; $ll <= $relay_count['count(id)']; $ll++)
		{	
		
			if ($ll == 1)
			{
				$db_location = "sqlite:../sqlite/cardinfo.db";	
			}
			else
			{	
				$db_location = "sqlite:../sqlite/cardinfo" . $ll . ".db";
			}
			//echo $db_location;
			
			$select = "SELECT isup, name FROM used_route;";
		
			try
			{
				//open the database
				$db = new PDO($db_location);
	
				$result = $db->query($select);
			
				foreach($result as $row)
				{
					$profile_array[$a] = $row;
					//echo "card = " . $profile_array[$a]['name'] . "<br />";
					
					//echo $this->all_proc[$a] . "<br />";
					$a++;
				}
				// close the database connection
				$db = NULL;
			}
			catch(PDOException $e)
			{
				print 'Exception : '.$e->getMessage();
			}	
			//echo $a . "<br />";
		}		
	
		return $profile_array;
		//return $route_found;
	}

	function find_isups_used()
	{		
		$a = 0;
		$relay_count = parent::select_statement('sqlite:../sqlite/relay_info.db','relay_hosts','count(id)','');
		
		for ($ll = 1; $ll <= $relay_count['count(id)']; $ll++)
		{	
		
			if ($ll == 1)
			{
				$db_location = "sqlite:../sqlite/cardinfo.db";	
			}
			else
			{	
				$db_location = "sqlite:../sqlite/cardinfo" . $ll . ".db";
			}
			//echo $db_location;
			
			$select = "SELECT name FROM used_isup;";
		
			try
			{
				//open the database
				$db = new PDO($db_location);
	
				$result = $db->query($select);
			
				foreach($result as $row)
				{
					$profile_array[$a] = $row;
					//echo "card = " . $profile_array[$a]['name'] . "<br />";
					
					//echo $this->all_proc[$a] . "<br />";
					$a++;
				}
				// close the database connection
				$db = NULL;
			}
			catch(PDOException $e)
			{
				print 'Exception : '.$e->getMessage();
			}	
			//echo $a . "<br />";
		}		
	
		return $profile_array;
		//return $route_found;
	}



}				
				

?>