<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
   NSG WebGUI

   Software distributed under the License is distributed on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
   for the specific language governing rights and limitations under the
   License.

   Licence information can be found within the file LICENCE.php

   The Original Code is SMG WebGUI

   The Initial Developer of the Original Code is
   Shaunt Libarian <shaunt@sangoma.com>

   Contributor(s):
   Abhishek Arora <aarora@sangoma.com>
 */

require_once '../database_classes.php';
class ss7_globalconfig extends database_class
{
    public $error= "";
    public $error_counter="";
    public $db_location = "sqlite:../sqlite/cardinfo.db";
    public $tablename = 'ss7_global_config';
    public $defaultValues = '';

    function display()
    {
        ?>
            <script type="text/javascript">
            $(document).ready(function(){

                    $('#auto-congestion-control').change(function(){
                        val = $(this).val();
                        if(val=='disable')
                        {
                        $('.acc_textfields').attr('disabled', 'disabled');
                        }
                        else
                        {
                        $('.acc_textfields').attr('disabled', false);
                        }
                        });
                    });
        </script>
            <form method="POST">
            <table class="mytable" width="100%" cellpadding='5'>
            <tbody><tr><th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">SS7 Global Configuration</th>
            <?php foreach($this->defaultValues as $globalParameters) { if($globalParameters['valuegroup']=='inr'){?>
                <tr>
                    <td class="mytablesubheader" width="50%"><?php echo $globalParameters['title'];?></td>
                    <td width="30%" align="left"><?php echo $this->getFields($globalParameters['type'], $globalParameters['value'], $globalParameters['parameter'], $globalParameters['valuegroup'], false)?></td> 
                    <td width="20%"><?php echo $this->error[$globalParameters['parameter']];?></td>
                    </tr>
                    <?php }} ?>
                    </tbody></table>
                    <div onclick="this.style.display='none';document.getElementById('hide_e').style.display='block';document.getElementById('advoptions').removeAttribute('style');
        ResizeFrame();" id="show_e" class="fakelink" style="display: block; margin:10px"> >>Show Advanced Options</div>
            <div onclick="this.style.display='none';document.getElementById('show_e').style.display='block';document.getElementById('advoptions').style.display='none';
        ResizeFrame();" id="hide_e" class="fakelink" style="display: none;margin:10px"> >>Hide Advanced Options</div>
            <table class="mytable" id="advoptions" width="100%" cellpadding='5' <?php if($this->error_counter==''){ echo "style='display:none;'";}?>>
            <tbody>
            <tr><th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">SS7 Advanced Options</th>
            <?php foreach($this->defaultValues as $globalParameters) { if($globalParameters['valuegroup']=='isup'){?>
                <tr>
                    <td class="mytablesubheader" width="50%"><?php echo $globalParameters['title'];?></td>
                    <td width="30%" align="left"><?php echo $this->getFields($globalParameters['type'], $globalParameters['value'], $globalParameters['parameter'], $globalParameters['valuegroup'], $disable)?>
                    </td>
                    <td width="20%"><?php echo $this->error[$globalParameters['parameter']];?></td>
                    </tr>
                    <?php }} ?>
                    <?php $disable=''; foreach($this->defaultValues as $globalParameters) { if($globalParameters['parameter'] == 'auto-congestion-control' && $globalParameters['value'] == 'disable'){ $disable = true; }} ?>
                    <tr><th colspan="5" style = "background:#c3c4c5; color:#004581; border-bottom:1px solid;" align="left">Automatic Congestion Control Options</th>
                    </tr>
                    <?php foreach($this->defaultValues as $globalParameters) { if($globalParameters['valuegroup']=='acc'){?>
                        <tr>
                            <td class="mytablesubheader" width="50%"><?php echo $globalParameters['title'];?></td>
                            <td width="30%" align="left"><?php echo $this->getFields($globalParameters['type'], $globalParameters['value'], $globalParameters['parameter'], $globalParameters['valuegroup'], $disable)?>
                            </td>
                            <td width="20%"><?php echo $this->error[$globalParameters['parameter']];?></td>
                            </tr>
                            <?php }} ?>
                            </tbody></table>
                            <br>
                            <table width="100%" cellpadding='5'>
                            <tbody><tr>
                            <td width="1%"><input name="save_ss7globalconfig" value="Save Configuration" class="ui-state-default ui-corner-all" type="submit"></td>
                            <td align="right"></td>
                            </tr>
                            </tbody></table>
                            </form>
                            <?php
    }
    public function validation($update=false)
    {
        if($update['auto-congestion-control'] == 'disable')
        {
            return true;
        }
        if(!is_numeric($update['max-cpu-usage']))
        {
            $this->error['max-cpu-usage'] = "<font color='red'>Max CPU should be numeric only</font>";
            $this->error_counter++;	
        }
        if((intval($update['max-cpu-usage']) > 90))
        {
            $this->error['max-cpu-usage'] = "<font color='red'>Max CPU should be less than 90 and more than 10</font>";
            $this->error_counter++;
        }
        if((intval($update['max-cpu-usage']) < 10))
        {
            var_dump($update['max-cpu-usage']);
            $this->error['max-cpu-usage'] = "<font color='red'>Max CPU should be less than 90 and more than 10</font>";
            $this->error_counter++;
        }
        if(!is_numeric($update['acc-q-size']))
        {
            $this->error['acc-q-size'] = "<font color='red'>Queue size should be numeric only</font>";
            $this->error_counter++;	
        }
        if($update['acc-q-size'] == 0)
        {
            $this->error['acc-q-size'] = "<font color='red'>Queue size should be greater 0</font>";
            $this->error_counter++;	
        }
        if(!is_numeric($update['acc-dequeue-rate']))
        {
            $this->error['acc-dequeue-rate'] = "<font color='red'>Dequeue rate should be numeric only</font>";
            $this->error_counter++;
        }
        if($update['acc-dequeue-rate'] < 2)
        {
            $this->error['acc-dequeue-rate'] = "<font color='red'>Dequeue rate should be greater than 2 and less than 50</font>";
            $this->error_counter++;
        }
        if($update['acc-dequeue-rate'] > 50)
        {
            $this->error['acc-dequeue-rate'] = "<font color='red'>Dequeue rate should be greater than 2 and less than 50 </font>";
            $this->error_counter++;	
        }
    }

    public function getDefaultValues()
    {
        $this->defaultValues = $this->array_select_statement($this->db_location, $this->tablename , '*');
    }
    public function updateData($update)
    {
        unset($update['save_ss7globalconfig']);
        unset($update['PHPSESSID']);
        foreach($update as $key=>$saveData)
        {
            $this->update_table($this->db_location, $this->tablename, "value = '$saveData'", "parameter='$key'");
        }
    }
    public function createSS7GlobalConfigTable($dbpath)
    {
        if($this->check_for_table($dbpath, $this->tablename)==1)
        {
            $columns = "id INTEGER PRIMARY KEY AUTOINCREMENT, parameter varchar(128), value varchar(256), title varchar(256), valuegroup varchar(64), type varchar(64)";
            $this->create_table($dbpath, $this->tablename, $columns);
            $this->create_table($dbpath, 'perm_'.$this->tablename, $columns);
            $parameters = "id, parameter , value , title , valuegroup,type";
            $records['insertForceInr']  = "NULL, 'force_inr', 'disable','ISUP INR','inr', 'select'";
            $records['insertUserMsgPriority']  = "NULL, 'set-isup-message-priority', '','ISUP User Message Priority','isup', 'text'";
            $records['insertAcc']  = "NULL, 'auto-congestion-control', 'disable','Auto Congestion','acc','select'";
            //$records['insertUserMessage']  = "NULL, 'enable-user-message-priority', 'disable','ISUP Message Priority','inr'";
            $records['insertAccQSize']  = "NULL, 'acc-q-size', 15,'Queue Size','acc', 'text'";
            $records['insertAccDqrate']  = "NULL, 'acc-dequeue-rate', 2,'Dequeue Rate','acc','text'";
            $records['insertMaxCpuUsage']  = "NULL, 'max-cpu-usage', 80,'Max CPU Usage','acc','text'";
            //$records['insertUserMsgType2']  = "NULL, 'isup-message-hexadecimal', '','Hexadecimal','isuptype', 'checkbox'";
            foreach($records as $record)
            {
                $this->insert_statement($dbpath, $this->tablename, $parameters, $record);
                $this->insert_statement($dbpath, 'perm_'.$this->tablename, $parameters, $record);
            }
        }
    }
    public function getFields($type,$value,$name,$class,$status)
    {

        if($name=='set-isup-message-priority'){
            $selectdisable = $selectenable = '';
            if($value =='87381'){$selectallone = "Selected = 'selected'";}
            if($value =='0'){$selectallzero = "Selected = 'selected'";}
            if($value =='7'){$selectdefault = "Selected = 'selected'";}
            return "<select name='".$name."' id='".$name."'>
                <option value='7' ".$selectdefault.">Default</option>
                <option value='87381' ".$selectallone.">All-Ones</option>
                <option value='0' ".$selectallzero.">All-Zeros</option>
                </select>";
        }
        if($type=='text')
        {
            $disable = '';
            if($status == true){$disable = "disabled = 'disable'";}
            return "<input type='text' value='".$value."' name='".$name."' class = '".$class."_textfields' id='".$name."' style='text-align:left; width:80px' ".$disable.">";
        }
        if($type=='select')
        {
            $selectdisable = $selectenable = '';
            if($value =='disable'){$selectdisable = "Selected = 'selected'";}
            if($value =='enable'){$selectenable = "Selected = 'selected'";}
            return "<select name='".$name."' id='".$name."'>
                <option value='enable' ".$selectenable.">Enable</option>
                <option value='disable' ".$selectdisable.">Disable</option>
                </select>";
        }
    }
}
?>
