<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/
//Checks to make sure the user is logged into the WebUI
if (empty($_POST))
	include '../check_referer.php';

//Starts PHP Session
session_start();
if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{	
	

	
	include 'ss7_globalconfig_class.php';
	//PHP Class Constructor
	$ss7_gconfig = new ss7_globalconfig;
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
		elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		
		include '../sqlite/database_creation.php';
		include '../display_class.php';

		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("SS7 Global Configuration", "../../style.css","");		
	}	
	if($_REQUEST['save_ss7globalconfig'])
	{
		$ss7_gconfig->validation($_REQUEST);
		if ($ss7_gconfig->error_counter == 0)
		{
			$ss7_gconfig->updateData($_REQUEST);
		}
	}

	$ss7_gconfig->createSS7GlobalConfigTable("sqlite:../sqlite/cardinfo.db");
	$ss7_gconfig->getDefaultValues();
	$ss7_gconfig->display();

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:index.php' ) ;
}
?>
