<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class ss7_m2ua_class
{
	
	//Class Variables
	public $data = "";					//Contains the database class
	public $db_table = "";				//m2ua db table
	public $edit = array();				//Contains database information
	public $pick = array();				//Contains form values
	private $error = array();			//Holds the errors created in the form
	public $error_count = "";			//Error counter variable;
	public $untoken_card_name = "";		//Card Name
	public $card_name = "";				//Tokenized card_name
	public $total_ports = "";			//Contains the total number of ports for that particular card
	private $name = "";					//Stores the name from the card_present table
	public $db_location = "";			//Contains the database location for sqlite
	public $proc_id="";					//Contains the relay proc_id
	public $relay_type = "";			//Contains the relay type
	public $line_type = "";
	public $span = "";				
	
	//Main Display Function
	function main()
	{		
		//Grabs db values
		$this->get_data_values($this->db_table,$_SESSION['port_num_clicked']);
		//Checks form values
		$this->form_values();
		
				
		//Checks which values to place in the form
		$this->form_values();
		?>
        <br />
    	<form id="m2ua_config" method="post">
			<table class="mytable" width='100%'>
                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">M2UA Signalling Gateway Profile</th>
            	<tr>
                	<td class="mytablesubheader" width='30%'>Link Name</td>
                    <?php
					if ($this->edit['link_name'] == "") {
					?>
                    <td width='40%'><input type='text' name='link_name' value='<?php echo $this->pick['link_name']; ?>' align='right' style='text-align:left; width:100px' /></td>
					<?php
                    }
					else {
					?>
                    <td width='40%'><?php echo $this->pick['link_name']; ?></td>
                    <!-- <td width='40%'><input type="text" name="link_name" value="<?php echo $this->pick['link_name']; ?>" align="right" style="text-align:left; width:100px" disabled="disabled" /></td>-->
					<?php						
					}
					?>
                    <td width='30%'><font color="#FF0000"><?=$this->error['link_name']?></font></td>
                </tr>
            </table>
            <br />
            <table class="mytable" width='100%'>
                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">MTP1 Information</th>
                <tr>
                	<td class="mytablesubheader" width='30%'>Span</td>
                    <td width='40%'><font color="#666666"><strong><?=$this->span?></strong></font></td>
                    <td width='30%'></td>
                </tr>
                <tr>
                	<td class="mytablesubheader" width='30%'>Line Media Type</td>
                    <td width='40%'><font color="#666666"><strong><?=$this->line_type?></strong></font></td>
                    <td width='30%'><font color="#FF0000"></font></td>
                </tr>                
                <tr>
                	<td class="mytablesubheader" width='30%'>Signalling Channel</td>
                    <td width='40%'><input type="text" name="sig_channel" value="<?=$this->pick['sig_channel']?>" style="text-align:left; width:30px" /></td>
                    <td width='30%'><font color="#FF0000"><?=$this->error['sig_channel']?></font></td>
                </tr>
            </table>
            <br />            
            <table class="mytable" width='100%'>
                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">MTP2 Information</th>  
                <tr>
                	<td class="mytablesubheader" width='30%'>Errortype</td>
                    <td width='40%'>
                    	<select name="error_type">
                        	<option value="basic" <?php if ($this->pick['error_type_basic'] == "yes" ) { ?> selected="selected" <?php } ?> style="text-align:left">Basic</option>
                            <option value="pcr" <?php if ($this->pick['error_type_pcr'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left" >PCR</option>
                        </select>
                    </td>
                    <td width='30%'><font color="#FF0000"><?=$this->error['error_type']?></font></td>
                </tr>
                <tr>
                	<td class="mytablesubheader" width='30%'>LSSU Length</td>
                    <td width='40%'>
                    	<select name="lssu">
                        	<option value="1" <?php if ($this->pick['lssu_1'] == "yes" ) { ?> selected="selected" <?php } ?> style="text-align:left">1</option>
                            <option value="2" <?php if ($this->pick['lssu_2'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">2</option>
                        </select>
                    </td>
                    <td width='30%'><font color="#FF0000"><?=$this->error['lssu']?></font></td>
                </tr>
                <tr>
                	<td class="mytablesubheader" width='30%'>Link Type</td>
                    <td width='40%'>
                    	<select name="link_type">
                        	<option value="itu92" <?php if ($this->pick['link_type_itu92'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ITU92</option>
                            <option value="itu88" <?php if ($this->pick['link_type_itu88'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ITU88</option>
                            <option value="ansi96" <?php if ($this->pick['link_type_ansi96'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ANSI96</option>
                            <option value="ansi92" <?php if ($this->pick['link_type_ansi92'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ANSI92</option>
                            <option value="ansi88" <?php if ($this->pick['link_type_ansi88'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ANSI88</option>
                            <option value="etsi" <?php if ($this->pick['link_type_etsi'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ETSI</option>
                        </select>
                    </td>
                    <td width='30%'><font color="red"><?=$this->error['link_type']?></font></td>
                </tr> 
           </table>
            <br />
			<table class="mytable" width='100%'>
                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">M2UA Configuration</th>
            	<tr>
                	<td class="mytablesubheader" width='30%'>M2UA Interface ID</td>
                    <td width='40%'><input type="text" name="interface_id" value="<?php echo $this->pick['interface_id']; ?>" align="right" style="text-align:left; width:100px" /></td>
                    <td width='30%'><font color="#FF0000"><?=$this->error['interface_id']?></font></td>
                </tr>
            </table>            
        <?php
			
			echo "<table width=\"100%\">\n";
			echo "<tr>\n";
			if ($this->relay_type == "SLAVE")
			{
		?>
            <td width="1%"><input type="submit" name="apply" value="Apply to Port" disabled="disabled" <?php echo $_SESSION['disabled_button_class']; ?>/></td>
        <?php
			}
			else
			{
			?>			
            <td width="1%"><input type="submit" name="apply" value="Apply to Port" <?php echo $_SESSION['button_class']; ?>/></td>
            <td align="right"><input type="submit" name="cancel" value="Cancel Configuration" <?php echo $_SESSION['button_class']; ?>/></td>
            </tr>
            </table>
        </form>  			
        <?php
			}
	}
	//Validates the information
	function validate()
	{
		$this->card_name = $_SESSION['card_clicked'];
		
		//Validate Link Name and make sure it doesn't exist
		//Must go through all SS7 link tables and extract the link names and compare them. If the link name exists, then will return an error
	
		$select = "SELECT id, dev_name FROM card_present;";

		try
		{
			//open the database
			$db = new PDO($this->db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$values[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			//echo "hello <br />";
			print 'Exception : '.$e->getMessage();
		}
		
		for ($b = 0; $b < $a; $b++)
		{
			//tokenize card_name
			$this->token_cards($values[$b]['dev_name']);
			$table = $this->name . "_" . $values[$b]['id'] . "_m2ua_link";
			
			//Check the database. If the database exists, use that information to display
			$table_exists = $this->data->check_for_table ($this->db_location, $table);
			
			//Table exists
			if ($table_exists > 1)
			{
				$select = "SELECT link_name FROM " . $table . ";";
		
				try
				{
					//open the database
					$db = new PDO($this->db_location);
		
					$result = $db->query($select);
				
					foreach($result as $row)
					{
						$link_name[$c] = $row['link_name'];
						$c++;
					}
					// close the database connection
					$db = NULL;
				}
				catch(PDOException $e)
				{
					//echo "hello <br />";
					print 'Exception : '.$e->getMessage();
				}
				
				for ($d = 0; $d < $c; $d++)
				{
					if ($_REQUEST['link_name'] != "") {
						if ($_REQUEST['link_name'] == $link_name[$d]['link_name'])
						{
							$this->error['link_name'] = "Link name <b>EXISTS</b>. Please use a <b>DIFFERENT</b> Link name";
							$this->error_count++;
							break;
						}
					}
				}
			}
		}
		
		if ($_REQUEST['interface_id'] == "") {
			$this->error['interface_id'] = "Interface ID <b>MUST</b> be entered";
			$this->error_count++;
		}
		elseif (!is_numeric($_REQUEST['interface_id'])) {
			$this->error['interface_id'] = "Interface ID <b>MUST</b> be a <b>NUMERIC</b> value";
			$this->error_count++;
		}
		elseif($_REQUEST['interface_id'] < 1 || $_REQUEST['interface_id'] > 32565) {
			$this->error['interface_id'] = "Interface iD <b>MUST</b> be between 1 and 32565";
			$this->error_count++;
		}
		elseif (!$this->validate_id($_REQUEST['interface_id'])) {
			$this->error_count++;
			$this->error['interface_id'] = "Interface ID <b>MUST</b> be a unique value. It cannot be used by another span";
		}
		
		//Validation for the Signalling Channel
		if ($_REQUEST['sig_channel'] == "")
		{
			$this->error['sig_channel'] = "Please enter a <b>Signalling Channel</b>.";
			$this->error_count++;			
		}
		elseif ($this->line_type == "T1")
		{
			if (!is_numeric($_REQUEST['sig_channel']))
			{
				$this->error['sig_channel'] = "Signalling Channel <b>MUST</b> be a <b>NUMERIC</b> value";
				$this->error_count++;				
			}
			elseif ($_REQUEST['sig_channel'] < 1 || $_REQUEST['sig_channel'] > 24)
			{
				$this->error['sig_channel'] = "Signalling Channel <b>MUST</b> be between Channel <b>1</b> and <b>24</b> for a <b>T1</b> Line";
				$this->error_count++;
			}
		}
		elseif ($this->line_type == "E1")
		{
			if (!is_numeric($_REQUEST['sig_channel']))
			{
				$this->error['sig_channel'] = "Signalling Channel <b>MUST</b> be a <b>NUMERIC</b> value";
				$this->error_count++;				
			}
			elseif ($_REQUEST['sig_channel'] < 1 || $_REQUEST['sig_channel'] > 31)
			{
				$this->error['sig_channel'] = "Signalling Channel <b>MUST</b> be between Channel <b>1</b> and <b>31</b> for a <b>E1</b> Line";
				$this->error_count++;
			}
		}
			
		if ($_REQUEST['link_name'] == "" && isset($_REQUEST['link_name'])) {
			$this->error_count++;
			$this->error['link_name'] = "Please enter a <b>Link Name</b>";
		}
		elseif (strpos($_REQUEST['link_name'], " ") !== false) {
			$this->error_count++;
			$this->error['link_name'] = "Please create a <b>Link Name</b> without any spaces";
		}
		
		if ($this->error_count == 0)
			return true;
		else
			return false;
	}
	
	private function validate_id($id) {
		$select = "SELECT id, dev_name FROM card_present;";
		$issue = true;
		$a = 0;
		try
		{
			//open the database
			$db = new PDO($this->db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$values[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			//echo "hello <br />";
			print 'Exception : '.$e->getMessage();
		}

		for ($b = 0; $b < $a; $b++)
		{
			//tokenize card_name
			$this->token_cards($values[$b]['dev_name']);
			$table = $this->name . "_" . $values[$b]['id'] . "_m2ua_link";
			//Check the database. If the database exists, use that information to display
			$table_exists = $this->data->check_for_table ($this->db_location, $table);
			
			//Table exists
			if ($table_exists > 1)
			{
				$select = "SELECT port_id, interface_id FROM " . $table . ";";
				try
				{
					//open the database
					$db = new PDO($this->db_location);
		
					$result = $db->query($select);
					$c=1;
					foreach($result as $row)
					{
						$int_id[$c]['interface_id'] = $row['interface_id'];
						$int_id[$c]['port_id'] = $row['port_id'];
						$c++;
					}
					// close the database connection
					$db = NULL;
				}
				catch(PDOException $e)
				{
					//echo "hello <br />";
					print 'Exception : '.$e->getMessage();
				}

				for ($d = 1; $d <= $c; $d++)
				{
					//echo "Card number = ". $values[$b]['id'].", Card clicked = " . $_SESSION['card_num'] . ", Port number = $d, Port number clicked = " . $_SESSION['port_num_clicked'] . "<br />";
					//echo "id = $id, ID in db = " . $int_id[$d]['interface_id'] . "<br />";
					if ($values[$b]['id'] ==  $_SESSION['card_num'] && $int_id[$d]['port_id'] == $_SESSION['port_num_clicked']) {
						//skip over itself and move to next ports
					}
					elseif ($id == $int_id[$d]['interface_id'])
					{
						$issue = false;
						break;
					}
				}
			}
		}

		if (!$issue)
			return false;
		else
			return true;
	}

	//Tokenizes Card Name
	function tokenize()
	{
		$tok = strtok($this->untoken_card_name, "-");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok("-");
			$count++;
		}
	
		$this->card_name = $token[1];		
	}
	
	//tokenizes the card names from the card_present table
	function token_cards($card_name)
	{
		$tok = strtok($card_name, "-");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok("-");
			$count++;
		}
	
		$this->name = $token[1];		
	}
	
	//Pulls information out of the database
	function get_data_values($table,$id){
		$table_exists = $this->data->check_for_table ($this->db_location, $table);
		if ($table_exists > 1)
			$this->edit = $this->data->select_statement($this->db_location,$table,'*','port_id=' . $id);
	}
	
	//Form Values
	function form_values()
	{
		if ($_REQUEST['link_name'] != "")
			$this->pick['link_name'] = $_REQUEST['link_name'];
		elseif ($this->edit['link_name'] != "")
			$this->pick['link_name'] = $this->edit['link_name'];
		else {
			$this->pick['link_name'] = "SGM2UA" .$this->span;
		}

		if ($_REQUEST['interface_id'] != "") 
			$this->pick['interface_id'] = $_REQUEST['interface_id'];
		elseif ($this->edit['interface_id'] != "")
			$this->pick['interface_id'] = $this->edit['interface_id'];

		if ($_REQUEST['sig_channel'] != "")
			$this->pick['sig_channel'] = $_REQUEST['sig_channel'];
		elseif ($this->edit['sig_channel'] != "")
			$this->pick['sig_channel'] = $this->edit['sig_channel'];
		
		if ($_REQUEST['error_type'] == "basic")
			$this->pick['error_type_basic'] = "yes";
		elseif ($_REQUEST['error_type'] == "pcr")
			$this->pick['error_type_pcr'] = "yes";
		elseif ($this->edit['error_type'] == "basic")
			$this->pick['error_type_basic'] = "yes";
		elseif ($this->edit['error_type'] == "pcr")
			$this->pick['error_type_pcr'] = "yes";
		
		if ($_REQUEST['lssu'] == "2")
			$this->pick['lssu_2'] = "yes";
		elseif ($_REQUEST['lssu'] == "1")
			$this->pick['lssu_1'] = "yes";
		elseif ($this->edit['lssu'] == "2")
			$this->pick['lssu_2'] = "yes";
		elseif ($this->edit['lssu'] == "1")
			$this->pick['lssu_1'] = "yes";
		
		if ($_REQUEST['link_type'] == "itu92")
			$this->pick['link_type_itu92'] = "yes";
		elseif ($_REQUEST['link_type'] == "itu88")
			$this->pick['link_type_itu88'] = "yes";
		elseif ($_REQUEST['link_type'] == "ansi96")
			$this->pick['link_type_ansi96'] = "yes";
		elseif ($_REQUEST['link_type'] == "ansi92")
			$this->pick['link_type_ansi92'] = "yes";
		elseif ($_REQUEST['link_type'] == "ansi88")
			$this->pick['link_type_ansi88'] = "yes";
		elseif ($_REQUEST['link_type'] == "etsi")
			$this->pick['link_type_etsi'] = "yes";
		elseif ($this->edit['link_type'] == "itu92")
			$this->pick['link_type_itu92'] = "yes";
		elseif ($this->edit['link_type'] == "itu88")
			$this->pick['link_type_itu88'] = "yes";
		elseif ($this->edit['link_type'] == "ansi96")
			$this->pick['link_type_ansi96'] = "yes";
		elseif ($this->edit['link_type'] == "ansi92")
			$this->pick['link_type_ansi92'] = "yes";
		elseif ($this->edit['link_type'] == "ansi88")
			$this->pick['link_type_ansi88'] = "yes";
		elseif ($this->edit['link_type'] == "etsi")
			$this->pick['link_type_etsi'] = "yes";
			
		if ($_REQUEST['sigtran_groupid'] != "")
			$this->pick['sigtran_groupid'] = $_REQUEST['sigtran_groupid'];
		elseif ($this->edit['sigtran_groupid'] != "")
			$this->pick['sigtran_groupid'] = $this->edit['sigtran_groupid'];
		
		if ($_REQUEST['sctp_ip_addr'] != "")
			$this->pick['sctp_ip_addr'] = $_REQUEST['sctp_ip_addr'];
		elseif ($this->edit['sctp_ip_addr'] != "")
			$this->pick['sctp_ip_addr'] = $this->edit['sctp_ip_addr'];		

		if ($_REQUEST['sctp_port'] != "")
			$this->pick['sctp_port'] = $_REQUEST['sctp_port'];
		elseif ($this->edit['sctp_port'] != "")
			$this->pick['sctp_port'] = $this->edit['sctp_port'];			

		if ($_REQUEST['group_keep_alive'] != "")
			$this->pick['group_keep_alive'] = $_REQUEST['group_keep_alive'];
		elseif ($this->edit['group_keep_alive'] != "")
			$this->pick['group_keep_alive'] = $this->edit['group_keep_alive'];			

		if ($_REQUEST['group_ack'] != "")
			$this->pick['group_ack'] = $_REQUEST['group_ack'];
		elseif ($this->edit['group_ack'] != "")
			$this->pick['group_ack'] = $this->edit['group_ack'];	
			
		if ($_REQUEST['group_recovery'] != "")
			$this->pick['group_recovery'] = $_REQUEST['group_recovery'];
		elseif ($this->edit['group_recovery'] != "")
			$this->pick['group_recovery'] = $this->edit['group_recovery'];	
			
		if ($_REQUEST['voice_chans'] == "yes")
			$this->pick['voice_chans_yes'] = "yes";
		elseif ($_REQUEST['voice_chans'] == "no")
			$this->pick['voice_chans_no'] = "yes";
		elseif ($this->edit['voice_chans'] == "yes")
			$this->pick['voice_chans_yes'] = "yes";
		elseif ($this->edit['voice_chans'] == "no")
			$this->pick['voice_chans_no'] = "no";
		
	}
}
?>
