<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/


class ss7_mg_channels_class {
	
	public $db_location;
	public $db_table;
	public $data;
	public $profile_name=array();
	public $profile_counter;
	public $span;
	public $edit=array();
	public $pick=array();
	private $error=array();
	private $name;
	public $sig_channel;
	public $line_type;
	private $_gateway_status = NULL;

	public function gateway_status() {
		$this->_gateway_status = shell_exec('pidof ' . $_SESSION['gateway_script']);
		if ($this->_gateway_status == 0 || $this->_gateway_status == "")
			return false;
		else
			return true;
	}
	
	public function display() {
	
		//get profile information
		$this->get_data_values($this->db_table,$_SESSION['port_num_clicked']);
		$this->get_profiles('mg_profiles');
		$this->form_values();
		$can_modify = $this->check_can_modify_profile($_SESSION['card_clicked'],$_SESSION['card_num'],$_SESSION['port_num_clicked']);
		?>
        	<h3>Media Gateway Channel Configuration</h3>
        	<br />
            
            <?php
			
			if ($this->profile_counter == 0) {
			?>
            	<p><font color='red'>There are currently no media gateway profiles configured on this system. Please proceed to the media gateway profile page in order to create a new media gateway profile</font></p>
                <form name='mg_error'>
                	<input type='submit' name='cancel_error' value='Back <-' <?=$_SESSION['button_class']?> />
                </form>
            <?php
			}
			else {
			?>
            
			<form name='mg_channels'>        
				<table class="mytable" width='100%'>
	                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Media Gateway Channel Profile</th>
    	        	<tr>
        	        	<td class="mytablesubheader" width='30%'>Profile Name</td>
                        <?php
						if ($this->edit['profile_name'] != "") {
						?>
						<td width='40%'><input type="text" name="profile_name" value="<?=$this->pick['profile_name']?>" align="right" style="text-align:left; width:100px" disabled='disabled' /></td>
						<?php
                        }
						else {
						?>
            	        <td width='40%'><input type="text" name="profile_name" value="<?=$this->pick['profile_name']?>" align="right" style="text-align:left; width:100px" /></td>
                        <?php
						}
						?>
                	    <td width='30%'><font color="#FF0000"><?=$this->error['profile_name']?></font></td>
	                </tr>
                </table>
                <br />
				<table class="mytable" width='100%'>
	                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Profile Options</th>
    	        	<tr>
        	        	<td class="mytablesubheader" width='30%'>Media Gateway Profile</td>
            	        <td width='40%'>
				<?php
					if(!$can_modify){
						echo "<select name='mg_profile_disabled' disabled='disabled'>";
						$selected = '';
						for ($a = 0; $a < $this->profile_counter; $a++)
						{ 
							$hash = $this->profile_name[$a]['name'];
							echo "<option value=\"" . $this->profile_name[$a]['name'] . "\""; if ($this->pick[$hash] == "yes") { ?> selected="selected" <?php } echo " style=\"text-align:left\" >" . $this->profile_name[$a]['name'] . "</option>\n";
							if($this->pick[$hash] == "yes")
								$selected = $this->profile_name[$a]['name'];
						}
						echo "<input type='hidden' name='mg_profile' value='".$selected."'/>";
					}else{
					echo "<select name='mg_profile'>";
						for ($a = 0; $a < $this->profile_counter; $a++)
						{ 
								$hash = $this->profile_name[$a]['name'];
								echo "<option value=\"" . $this->profile_name[$a]['name'] . "\""; if ($this->pick[$hash] == "yes") { ?> selected="selected" <?php } echo " style=\"text-align:left\" >" . $this->profile_name[$a]['name'] . "</option>\n";
						}
					}
				?>                            	
                            </select>
                        </td>
                	    <td width='30%'><font color="#FF0000"><?=$this->error['mg_profile']?></font></td>
	                </tr>
    	        	<tr>
        	        	<td class="mytablesubheader" width='30%'>Termination-ID Prefix</td>
            	        <td width='40%'><input type="text" name="prefix" value="<?=$this->pick['prefix']?>" align="right" style="text-align:left; width:100px" /></td>
                	    <td width='30%'><font color="#FF0000"><?=$this->error['prefix']?></font></td>
	                </tr>  
    	        	<tr>
        	        	<td class="mytablesubheader" width='30%'>Termination-ID Base</td>
            	        <td width='40%'><input type="text" name="base" value="<?=$this->pick['base']?>" align="right" style="text-align:left; width:100px" /></td>
                	    <td width='30%'><font color="#FF0000"><?=$this->error['base']?></font></td>
	                </tr>     
    	        	<tr>
        	        	<td class="mytablesubheader" width='30%'>Channel Map</td>
            	        <td width='40%'><input type="text" name="channel_map" value="<?=$this->pick['channel_map']?>" align="right" style="text-align:left; width:100px" /></td>
                	    <td width='30%'><font color="#FF0000"><?=$this->error['channel_map']?></font></td>
	                </tr>                                                                
                </table>  
            <br />
        <?php
			
			echo "<table width=\"100%\">\n";
			echo "<tr>\n";
			if ($this->relay_type == "SLAVE")
			{
		?>
            		<td width="1%"><input type="submit" name="apply" value="Apply to Port" disabled="disabled" <?=$_SESSION['disabled_button_class']?>/></td>
        <?php
			}
			else
			{
			?>			
    		        <td width="1%"><input type="submit" name="apply" value="Apply to Port" <?=$_SESSION['button_class']?>/></td>
    	    	    <td align="right"><input type="submit" name="cancel" value="Cancel Configuration" <?=$_SESSION['button_class']?>/></td>
    	        </tr>
    	        </table>
	        </form>                                
        <?php
			}
		}
	}
	
	
	public function get_profiles($table){ 
		$a = 0;

		$select = "SELECT name FROM " . $table . ";";
		$data = new database_class;
		
		$table = $data->check_for_table($this->db_location,$table);
		if ($table >1 )
		{
			try
			{
				//open the database
				$db = new PDO($this->db_location);
	
				$result = $db->query($select);
			
				foreach($result as $row)
				{
					$this->profile_name[$a] = $row;
					$a++;
				}
				// close the database connection
				$db = NULL;
			}
			catch(PDOException $e)
			{
				print 'Exception : '.$e->getMessage();
			}
		}
	
		$this->profile_counter = $a;
		
	}
	
	//Pulls information out of the database
	function get_data_values($table,$id){
		$table_exists = $this->data->check_for_table ($this->db_location, $table);
		if ($table_exists > 1)
			$this->edit = $this->data->select_statement($this->db_location,$table,'*','port_id=' . $id);
	}
	function check_can_modify_profile($type, $card, $port){
		if($this->gateway_status()) {
			//check scratch table for issue
			if ($this->data->check_for_table($this->db_location,$type.'_'.$card.'_m2ua_channels') > 1) {
				$table2 =  $type.'_'.$card.'_m2ua_channels';
				$exist = $this->data->select_statement($this->db_location,$table2,'port_id','port_id = ' . $port);
				if ($exist['port_id'] != "") {
					$table =  'perm_'.$type.'_'.$card.'_m2ua_channels';
					$table_exists = $this->data->check_for_table ($this->db_location, $table);
					if ($table_exists > 1){
						$values = $this->data->select_statement($this->db_location,$table,'*','port_id=' . $port);
						if(isset($values['mg_profile']))
						return false;
					}
				}
				else
					return true;
			}
		}
		return true;
	}
	
	//Form Values
	public function form_values()
	{
		if ($_REQUEST['mg_profile'] != "")
			$this->pick[$_REQUEST['mg_profile']] = 'yes';
		elseif ($this->edit['mg_profile'] != "")
			$this->pick[$this->edit['mg_profile']] = 'yes';
		
		if ($_REQUEST['profile_name'] != "")
			$this->pick['profile_name'] = $_REQUEST['profile_name'];
		elseif ($this->edit['profile_name'] != "")
			$this->pick['profile_name'] = $this->edit['profile_name'];
		else
			$this->pick['profile_name'] = "MGCHAN" .$this->span;
		
		
		if ($_REQUEST['channel_map'] != "")
			$this->pick['channel_map'] = $_REQUEST['channel_map'];
		elseif ($this->edit['channel_map'] != "")
			$this->pick['channel_map'] = $this->edit['channel_map'];
		else
			$this->pick['channel_map'] = $this->create_chan_map();
		
		if ($_REQUEST['prefix'] != "")
			$this->pick['prefix'] = $_REQUEST['prefix'];
		elseif ($this->edit['prefix'] != "")
			$this->pick['prefix'] = $this->edit['prefix'];
		elseif ($this->edit['prefix'] == "" && $_REQUEST['prefix'] == "")
			$this->pick['prefix'] = "A";
			
		if ($_REQUEST['base'] != "")
			$this->pick['base'] = $_REQUEST['base'];
		elseif ($this->edit['base'] != "")
			$this->pick['base'] = $this->edit['base'];	
		elseif ($this->edit['base'] == "" && $_REQUEST['base'] == "") {
			//Auto Increment the base
			if ($_SESSION['mg_base'] == "")
					$this->pick['base'] = "1";	
			elseif ($_SESSION['mg_base'] >= 1)
			{
				if ($this->line_type == "T1")
					$this->pick['base'] = $_SESSION['mg_base'] + 24;
				elseif ($this->line_type == "E1")
					$this->pick['base'] = $_SESSION['mg_base'] + 32;		
			}
		}
	}
	
	public function validation() {
		if ($this->edit['profile_name'] == "") {
			if ($_REQUEST['profile_name'] == ""){
				$this->error['profile_name'] = '<font color="red">Please enter a <b>Profile Name</b></font>';
				$error_count++;
			}
			elseif (strpos($_REQUEST['link_name'], " ") !== false) {
            	$this->error_count++;
                $this->error['profile_name'] = "Please create a <b>Profile Name</b> without any spaces";
            }			
			else
			{
				$this->card_name = $_SESSION['card_clicked'];
				
				//Validate Link Name and make sure it doesn't exist
				//Must go through all SS7 link tables and extract the link names and compare them. If the link name exists, then will return an error
			
				$select = "SELECT id, dev_name FROM card_present;";
		
				try
				{
					//open the database
					$db = new PDO($this->db_location);
		
					$result = $db->query($select);
				
					foreach($result as $row)
					{
						$values[$a] = $row;
						$a++;
					}
					// close the database connection
					$db = NULL;
				}
				catch(PDOException $e)
				{
					//echo "hello <br />";
					print 'Exception : '.$e->getMessage();
				}
				
				for ($b = 0; $b < $a; $b++)
				{
					//tokenize card_name
					$this->token_cards($values[$b]['dev_name']);
					$table = $this->name . "_" . $values[$b]['id'] . "_m2ua_channels";
					
					//Check the database. If the database exists, use that information to display
					$table_exists = $this->data->check_for_table ($this->db_location, $table);
					
					//Table exists
					if ($table_exists > 1)
					{
						$select = "SELECT profile_name FROM " . $table . ";";
				
						try
						{
							//open the database
							$db = new PDO($this->db_location);
				
							$result = $db->query($select);
						
							foreach($result as $row)
							{
								$link_name[$c] = $row['profile_name'];
								$c++;
							}
							// close the database connection
							$db = NULL;
						}
						catch(PDOException $e)
						{
							//echo "hello <br />";
							print 'Exception : '.$e->getMessage();
						}
						
						for ($d = 0; $d < $c; $d++)
						{
							if (($_REQUEST['profile_name'] == $link_name[$d]['profile_name']))
							{
								$this->error['profile_name'] = "Link name <b>EXISTS</b>. Please use a <b>DIFFERENT</b> Link name";
								$error_count++;
								break;
							}
						}
					}
				}			
			}
		}
		
		
		if ($_REQUEST['channel_map'] == ""){
			$this->error['channel_map'] = '<font color="red">Please enter a <b>Channel Map</b></font>';
			$error_count++;
		}
		if (isset ($_REQUEST['channel_map']) && isset($this->sig_channel))  {
			//Validate that a signalling link is present in the channel map.
			//Only required if a signalling link is entered in m2ua link config
			
			$found=false;
			
			$chan_map = explode(',',$_REQUEST['channel_map']);
			foreach ($chan_map as $chan) {
				$pos = strpos ($chan,"s");
				$pos_g = strpos($chan,'g');
				if ($pos !== false) {
					$found = true;
					break;
				}
				elseif ($pos_g !== false) {
					$found = true;
					break;
				}
			}
			
			if (!$found) {
				$error_count++;
				$this->error['channel_map'] = "The <b>signalling link channel</b> MUST be entered in your channel map";
			}
		}
		
		
		
		if ($_REQUEST['prefix'] == ""){
			$this->error['prefix'] = '<font color="red">Please enter a <b>Termination-ID Prefix</b></font>';
			$error_count++;
		}

		if ($_REQUEST['base'] == ""){
			$this->error['base'] = '<font color="red">Please enter a <b>Termination-ID Base</b></font>';
			$error_count++;
		}
		elseif (!is_numeric($_REQUEST['base'])) {
			$this->error['base'] = '<font color="red"><b>Termination-ID Base</b> MUST be a numeric value</font>';
			$error_count++;
		}
		elseif ($_REQUEST['base'] < 1) {
			$this->error['base'] = '<font color="red"><b>Termination-ID Base</b> MUST be greater than 0</font>';
			$error_count++;
		}
	
	
		if ($error_count == 0)
			return true;
		else
			return false;
	}
	
	//tokenizes the card names from the card_present table
	function token_cards($card_name)
	{
		$tok = strtok($card_name, "-");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok("-");
			$count++;
		}
	
		$this->name = $token[1];		
	}

	//Creates the channel map
	private function create_chan_map()
	{
		if ($this->line_type == "T1")
			$last_chan = "24";
		elseif ($this->line_type == "E1")
			$last_chan = "31";
		
		if ($this->sig_channel == 1)
			$channels = "s1,2-" . $last_chan;
		elseif ($this->sig_channel == 2)
			$channels = "1,s2,3-" . $last_chan;
		elseif ($this->line_type == "T1" && $this->sig_channel == 24)
		{
			$previous_chan = $last_chan -1;
			$channels = "1-" . $previous_chan . ",s" . $last_chan;
		}
		elseif ($this->line_type == "T1" && $this->sig_channel == 23)
		{
			$previous_chan = $this->sig_channel -1;
			$channels = "1-" . $previous_chan . ",s" . $this->sig_channel . ",24";
		}
		elseif ($this->line_type == "E1" && $this->sig_channel == 31)
		{
			$previous_chan = $last_chan -1;
			$this->channels = "1-" . $previous_chan . ",s" . $last_chan;
		}
		elseif ($this->line_type == "E1" && $this->sig_channel == 30)
		{
			$previous_chan = $this->sig_channel -1;
			$channels = "1-" . $previous_chan . ",s" . $this->sig_channel . ",31";			
		}
		elseif ($this->sig_channel == "")
			$channels = "1-" . $last_chan;
		else
		{
			$previous_chan = $this->sig_channel -1;
			$next_chan = $this->sig_channel + 1;
			
			$channels = "1-" . $previous_chan . ",s" . $this->sig_channel . "," . $next_chan . "-" . $last_chan;
		}
		return $channels;
	}	
}
