<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Start Session
session_start();

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{
	include 'm2ua_cluster_class.php';
	include '../../database_classes.php';
	
	$cluster = new m2ua_cluster;
	$data = new database_class;
	
	$cluster->untoken_card_name = $_SESSION['card_clicked'];
	$cluster->proc_id = $_SESSION['proc_id'];
	$cluster->db_m2ua_link_table = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_m2ua_link";	
	
	$no_other=false;
	$new_cluster=false;
	$cluster_mgmt=false;
	$cluster_edit=false;
	$delete_cluster=false;
	$add_peer=false;
	$view_cluster=false;	
	$view_peer=false;
	$new_sctp=false;
	$edit_sctp=false;
	$delete_sctp=false;

	if ($_POST['next_step'] == "Next ->") {
		//Check if m2ua link will have voice channels
		/*$check = $data->select_statement('sqlite:../../sqlite/cardinfo.db',$cluster->db_m2ua_link_table,'voice_chans','port_id='.$_SESSION['port_num_clicked']);
		
		if ($check['voice_chans'] == "yes")
			header('Location:mg_channels.php');
		else
			header('Location:../../wanrouterhwprobe.php');*/
		header('Location:m2ua_mg_chans.php');
	}

	if ($_POST['delete_cluster'] == "Remove") {
		$table = "m2ua_clusters";
		//grab table name
		$del_prof = $data->select_statement('sqlite:../../sqlite/cardinfo.db',$table,'profile_name','id='.$_POST['id_number']);
		$data->delete_generic('sqlite:../../sqlite/cardinfo.db',$table,'id=' . $_POST['id_number']);
		
		$peer_table = $del_prof['profile_name'] . '_peers';
		$data->drop_table('sqlite:../../sqlite/cardinfo.db',$peer_table);
		
		//header('Location:m2ua_clusters.php');			
		$cluster_mgmt=true;
		$no_other=true;
	}
	if ($_POST['delete_peer'] == "Remove") {
		$table = $_POST['cluster_profile']."_peers";
		$data->delete_generic('sqlite:../../sqlite/cardinfo.db',$table,'id=' . $_POST['id_number']);
			
		$cluster_id=$_POST['cluster_id'];	
		$view_cluster=true;
		$no_other=true;
	}
	if ($_POST['delete_sctp'] == "Remove") {
		$table = "sctp_interfaces";
		$data->delete_generic('sqlite:../../sqlite/cardinfo.db',$table,'id=' . $_POST['id_number']);
			
		$peer_id = $_POST['peer_id'];
		$peer_profile = $_POST['peer_profile'];
		$sctp_id = $_POST['id_number'];
		$cluster_profile = $_POST['cluster_profile'];
		$cluster_id = $_POST['cluster_id'];
		$no_other=true;
		$view_peer=true;
	}	
	if ($_POST['create_new_cluster'] == "Create") {
		if ($cluster->validation('new_cluster')) {
			//Save to db
			$insert_param = 'profile_name';
			$insert_values = "\"" . $_POST['cluster_name'] . "\"";
			$data->insert_statement($cluster->db_location,'m2ua_clusters',$insert_param,$insert_values);
			
			$prof['profile_name'] = $_POST['cluster_name'];
			
			//create peers table
			$create_param = "id integer primary key, profile_name varchar(100), include_asp_identifier varchar(100), asp_identifier int, sctp_association varchar(30), dest_ip_addr_1 varchar(100), dest_ip_addr_2 varchar(100), dest_ip_addr_3 varchar(100), dest_ip_addr_4 varchar(100),dest_ip_addr_5 varchar(100), dest_port varchar(100), num_out_streams int, sctp_int_name varchar(100)";
			$table_name = $_POST['cluster_name'] . "_peers";
			$data->create_table($cluster->db_location,$table_name,$create_param);
			
			//go to edit cluster
			$cluster_id=$_POST['id_number'];
			$cluster_edit=true;
			$no_other=true;
		}
		else
		{
			$new_cluster=true;
			$no_other=true;
		}
	}
	if ($_POST['create_new_peer'] == "Create") {
		if ($cluster->validation('new_peer')) {
			$insert_param = 'profile_name';
			$insert_values ='"' . $_POST['cluster_profile'] . '_' . $_POST['peer_name'] . '"';
			$data->insert_statement($cluster->db_location,$_POST['cluster_profile'] . '_peers',$insert_param,$insert_values);
			
			$peer_id=$_POST['id_number'];
			$cluster_profile=$_POST['cluster_profile'];
			$cluster_id=$_POST['cluster_id'];
			$edit_peer=true;
			$no_other=true;
		}
		else {
			$peer_id=$_POST['id_number'];
			$cluster_profile=$_POST['cluster_profile'];
			$cluster_id=$_POST['cluster_id'];			
			$add_peer=true;
			$no_other=true;
		}
	}
	if ($_POST['create_new_sctp'] == "Create") {
		if ($cluster->validation('new_sctp')) {
			$insert_param="profile_name";
			$insert_values="\"" . $_POST['sctp_name'] ."\"";
			$data->insert_statement($cluster->db_location,'sctp_interfaces',$insert_param, $insert_values);
			
			$sctp_id=$_POST['id_number'];
			$peer_id = $_POST['peer_id'];
			$cluster_id=$_POST['cluster_id'];
			$cluster_profile=$_POST['cluster_profile'];
			$peer_profile=$_POST['peer_profile'];
			$edit_sctp=true;
			$no_other=true;
		}
		else
		{
			$cluster_id=$_POST['cluster_id'];
			$peer_id=$_POST['id_number'];
			$peer_profile=$_POST['peer_profile'];
			$cluster_profile=$_POST['cluster_profile'];	
			$new_sctp=true;
			$no_other=true;				
		}
	}
	if ($_POST['save_cluster'] == "Save") {
		if ($cluster->validation('edit_cluster',$data))
		{
			$update_param="traffic_mode = \"" . $_POST['traffic_mode'] . "\", load_share=\"" . $_POST['load_share'] . "\"";
			$where='id='.$_POST['id_number'];
			$data->update_table('sqlite:../../sqlite/cardinfo.db','m2ua_clusters',$update_param,$where);
			
			$cluster_id=$_POST['id_number'];
			
			$view_cluster=true;
			$no_other=true;
		}
		else {
			$cluster_edit=true;
			$no_other=true;
		}
	}
	if ($_POST['save_peer'] == "Save") {
		if ($cluster->validation('edit_peer',$data))
		{
			$update_param="include_asp_identifier=\"" . $_POST['include_asp_identifier'] . "\",asp_identifier=\"" . $_POST['asp_identifier'] . "\", sctp_association=\"" . $_POST['sctp_association'] . "\", dest_ip_addr_1 = \"" . $_POST['dest_ip_1'] . "\", dest_ip_addr_2=\"" . $_POST['dest_ip_2'] . "\", dest_ip_addr_3=\"" . $_POST['dest_ip_3'] . "\", dest_ip_addr_4=\"". $_POST['dest_ip_4'] . "\", dest_ip_addr_5=\"" . $_POST['dest_ip_5'] . "\", num_out_streams=\"" . $_POST['num_streams'] . "\", dest_port=\"" . $_POST['dest_port'] . "\"";
			$where='id='.$_POST['id_number'];
			$data->update_table('sqlite:../../sqlite/cardinfo.db',$_POST['cluster_profile'].'_peers',$update_param,$where);
			
			$cluster_id = $_POST['cluster_id'];
			$cluster_profile = $_POST['cluster_profile'];
			$peer_id = $_POST['id_number'];
			
			$view_peer=true;
			$no_other=true;
		}
		else
		{
			$cluster_id = $_POST['cluster_id'];
			$cluster_profile = $_POST['cluster_profile'];
			$peer_id = $_POST['id_number'];
			$edit_peer=true;
			$no_other=true;
		}
	}
	if ($_POST['save_sctp'] == "Save") {
		if ($cluster->validation('edit_sctp',$data)) {
			$where='id='.$_POST['id_number'];
			$update_param="dest_ip_1 = \"" . $_POST['dest_ip_1'] . "\", dest_ip_2=\"" . $_POST['dest_ip_2'] . "\", dest_ip_3=\"" . $_POST['dest_ip_3'] . "\", dest_ip_4=\"". $_POST['dest_ip_4'] . "\", dest_ip_5=\"" . $_POST['dest_ip_5'] . "\", port=\"" . $_POST['port'] . "\"";
			
			$data->update_table('sqlite:../../sqlite/cardinfo.db','sctp_interfaces',$update_param,$where);		

			$peer_id = $_POST['peer_id'];
			$peer_profile = $_POST['peer_profile'];
			$sctp_id = $_POST['id_number'];
			$cluster_profile = $_POST['cluster_profile'];
			$cluster_id = $_POST['cluster_id'];
			$no_other=true;
			$view_peer=true;			
		}
		else {
			$peer_id = $_POST['peer_id'];
			$peer_profile = $_POST['peer_profile'];
			$sctp_id = $_POST['id_number'];
			$cluster_profile = $_POST['cluster_profile'];
			$cluster_id = $_POST['cluster_id'];
			$no_other=true;
			$edit_sctp=true;
		}
	}
	if ($_POST['edit_cluster_aggr'] == "Edit") {
		$prof['profile_name'] = $_POST['profile_name'];
		$cluster_id=$_POST['id_number'];
		$cluster_edit=true;
		$no_other=true;
	}
	if ($_POST['edit_aggr_peer'] == "Edit") {
		$cluster_profile = $_POST['cluster_profile'];
		$cluster_id=$_POST['cluster_id'];
		$peer_id=$_POST['id_number'];
		$peer_profile=$_POST['profile_name'];
		$edit_peer=true;
		$no_other=true;		
	}
	if ($_POST['add_peer'] == "Add") {
		$cluster_profile = $_POST['profile_name'];
		$cluster_id = $_POST['id_number'];
		$add_peer=true;
		$no_other=true;
	}
	if ($_POST['add_sctp_int'] == "Add") {
		$cluster_id=$_POST['cluster_id'];
		$peer_id=$_POST['id_number'];
		$peer_profile=$_POST['profile_name'];
		$cluster_profile=$_POST['cluster_profile'];	
		$new_sctp=true;
		$no_other=true;	
	}
	if ($_POST['view_clusters_peer'] == "view the associated cluster") {
		$cluster_id=$_POST['cluster_id'];
		$prof['profile_name'] = $_POST['cluster_profile'];
		$view_cluster=true;
		$no_other=true;
	}
	
	foreach ($_POST as $key=>$value) {
		$keys = explode ('-' , $key);
		//echo $keys[0] . "<br />";
		//echo $keys[1] . "<br />";
		//echo $value . "<br />";
		if ($keys[0] == "edit_cluster" && is_numeric($keys[1]) && $value=="Edit") {
			//edit cluster
			$prof = $data->select_statement('sqlite:../../sqlite/cardinfo.db','m2ua_clusters','profile_name','id='.$keys[1]);			
			$cluster_id = $keys[1];
			$view_cluster=true;
			$no_other=true;
		}
		elseif ($keys[0] == "edit_peer" && is_numeric($keys[1]) && $value=="Edit") {
			$cluster_id = $_POST['id_number'];
			$cluster_profile = $_POST['profile_name'];
			$peer_id=$keys[1];
			$view_peer=true;
			$no_other=true;
		}
		elseif ($keys[0] == "edit_sctp" && is_numeric($keys[1]) && $value=="Edit") {
			$cluster_id = $_POST['cluster_id'];
			$cluster_profile = $_POST['cluster_profile'];
			$peer_id = $_POST['id_number'];
			$peer_profile = $_POST['profile_name'];
			$sctp_id=$keys[1];
			$edit_sctp=true;
			$no_other=true;
		}		
		elseif  ($keys[0] == "delete_cluster" && is_numeric($keys[1]) && $value=="Delete") {
			//delete cluster and peers tables associated with cluster
			$cluster_id = $_POST['id_number'];
			$no_other=true;
			$delete_id=$keys[1];
			$delete_cluster=true;
		}
		elseif  ($keys[0] == "delete_peer" && is_numeric($keys[1]) && $value=="Delete") {
			//delete cluster and peers tables associated with cluster
			$no_other=true;
			$delete_id=$keys[1];
			$cluster_id=$_POST['id_number'];
			$delete_peer=true;
		}	
		elseif ($keys[0] == "delete_sctp" && is_numeric($keys[1]) && $value=="Delete") {
			$delete_id=$keys[1];
			$no_other=true;
			$cluster_id=$_POST['cluster_id'];
			$peer_id=$_POST['id_number'];
			$cluster_profile=$_POST['cluster_profile'];
			$peer_profile=$_POST['profile_name'];	
			$delete_sctp=true;
		}
		elseif ($keys[0] == "bind_cluster" && is_numeric($keys[1]) && $value=="Bind") {
			$prof = $data->select_statement('sqlite:../../sqlite/cardinfo.db','m2ua_clusters','profile_name','id='.$keys[1]);
			$update_param = "cluster = \"" . $prof['profile_name'] . "\"";
			$data->update_table('sqlite:../../sqlite/cardinfo.db',$cluster->db_m2ua_link_table,$update_param,'port_id=' . $_SESSION['port_num_clicked']);
			
			//redirect to tdm_config || mg_question.php
			//Check if m2ua link will have voice channels
			/*$check = $data->select_statement('sqlite:../../sqlite/cardinfo.db',$cluster->db_m2ua_link_table,'voice_chans','port_id='.$_SESSION['port_num_clicked']);
			
			if ($check['voice_chans'] == "yes")
				header('Location:mg_channels.php');
			else
				header('Location:../../wanrouterhwprobe.php');*/
			
			header ('Location:m2ua_mg_chans.php');
		}
		elseif ($keys[0] == "bind_sctp" && is_numeric($keys[1]) && $value=="Bind") {
			$prof = $data->select_statement('sqlite:../../sqlite/cardinfo.db','sctp_interfaces','profile_name','id='.$keys[1]);
			$update_param = "sctp_int_name = \"" . $prof['profile_name'] . "\"";
			$data->update_table('sqlite:../../sqlite/cardinfo.db',$_POST['cluster_profile'].'_peers',$update_param,'id=' . $_POST['id_number']);
			
			$no_other=true;
			$cluster_id=$_POST['cluster_id'];
			$peer_id=$_POST['id_number'];
			$cluster_profile=$_POST['cluster_profile'];
			$peer_profile=$_POST['profile_name'];
			$view_peer=true;		
		}		
	}
	
	//Check if a cluster exists, if not go straight to add a new cluster
	if (!$no_other) {
		if (!$cluster->check_for_row($data,'m2ua_clusters'))
			$new_cluster='true';
		elseif ($_POST['cancel_cluster'] == "Cancel")
			header ('Location: ../../wanrouterhwprobe.php');
		elseif ($_POST['cancel_new_cluster'] == "Cancel")
			$cluster_mgmt=true;
		elseif ($_POST['add_cluster'] == "Add") 
			$new_cluster = true;
		elseif ($_POST['cancel_edit_cluster'] == "Cancel") {
			$view_cluster=true;
			$cluster_id=$_POST['id_number'];
		}
		elseif ($_POST['cancel_new_peer'] == "Cancel") {
			$view_cluster=true;
			$cluster_id=$_POST['cluster_id'];
		}
		elseif ($_POST['cancel_new_sctp'] == "Cancel") {
			$view_peer=true;
			$cluster_id=$_POST['cluster_id'];
			$peer_id=$_POST['peer_id'];
			$peer_profile=$_POST['peer_profile'];
			$cluster_profile=$_POST['cluster_profile'];
		}
		elseif ($_POST['cancel_edit_sctp'] == "Cancel") {
			$view_peer=true;
			$cluster_id=$_POST['cluster_id'];
			$peer_id=$_POST['peer_id'];
			$peer_profile=$_POST['peer_profile'];
			$cluster_profile=$_POST['cluster_profile'];			
		}
		elseif ($_POST['cancel_sctp_delete'] == "Cancel") {
			$view_peer=true;
			$cluster_id = $_POST['cluster_id'];
			$peer_id=$_POST['peer_id'];
			$peer_profile=$_POST['peer_profile'];
			$cluster_profile=$_POST['cluster_profile'];
		}
		elseif ($_POST['cancel_edit_peer'] == "Cancel") {
			$view_peer=true;
			$cluster_id = $_POST['cluster_id'];
			$cluster_profile=$_POST['cluster_profile'];
			$peer_id=$_POST['id_number'];
		}
		elseif ($_POST['cancel_delete_peer'] == "Cancel") {
			$view_cluster=true;
			$cluster_id=$_POST['cluster_id'];
		}
		elseif ($_POST['done_cluster'] == "Complete") 
			$cluster_mgmt=true;
		elseif ($_POST['done_peer'] == "Back to Cluster") {
			$view_cluster=true;
			$cluster_id=$_POST['cluster_id'];
		}
	}
	
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		require_once ('../../display_class.php');
		//FusionPBX Integration
		require_once "../../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../../sqlite/database_creation.php';
		include '../../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";	
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:../../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("M2UA Cluster Configuration", "../../../../style.css","");		
	}	

	//Check if there are any clusters created. If not, go straight to adding a new m2ua cluster
	$check = $cluster->get_profiles('m2ua_clusters','*',$counter);
	
	if ($new_cluster || $counter == 0)
		$cluster->new_cluster($data);
	elseif ($add_peer)
		$cluster->new_peer($data,$cluster_profile,$cluster_id);
	elseif($edit_peer)
		$cluster->edit_peer($data, $peer_id,$cluster_profile, $cluster_id);
	elseif ($cluster_edit)
		$cluster->cluster_edit($data, $cluster_id, $prof['profile_name']);
	elseif ($delete_peer)
		$cluster->display_delete_peer($data,$delete_id,$cluster_id);
	elseif ($delete_cluster)
		$cluster->display_delete_cluster($data,$delete_id);
	elseif ($view_peer)
		$cluster->view_aggr_peer($data,$peer_id,$cluster_id,$cluster_profile);	
	elseif ($view_cluster)
		$cluster->view_aggr_cluster($data,$cluster_id);
	elseif ($new_sctp)
		$cluster->new_sctp($data, $peer_id, $peer_profile, $cluster_profile,$cluster_id);
	elseif ($edit_sctp)
		$cluster->edit_sctp($data, $sctp_id,$cluster_profile, $cluster_id, $peer_id, $peer_profile);
	elseif ($delete_sctp)
		$cluster->display_delete_sctp($data,$delete_id, $peer_id, $peer_profile, $cluster_profile, $cluster_id);
	elseif ($cluster_mgmt=true && (!$new_cluster && !$cluster_edit && !$delete_cluster && !$view_cluster && !$add_peer))
		$cluster->cluster_list($data);
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
		//ClearOS Integration
		$display_common->html_footer(true);	
}
else
{
	header( 'Location:../../index.php' ) ;
}

?>