<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class m2ua_cluster {
	private $error=array();
	public $untoken_card_name="";
	public $proc_id="";
	private $edit=array();
	private $pick=array();
	public $db_location = 'sqlite:../../sqlite/cardinfo.db';
	public $db_m2ua_link_table="";
	public $db_table="";
	
	private $_gateway_status = NULL;

	public function gateway_status() {
		$this->_gateway_status = shell_exec('pidof ' . $_SESSION['gateway_script']);
		if ($this->_gateway_status == 0 || $this->_gateway_status == "")
			return false;
		else
			return true;
	}
	
	
	/**
	*	Displays all the clusters configured on the system.
	*/
	public function cluster_list($data)
	{
		$c = 0;
		$not_bound = false;
		$profiles = $this->get_profiles('m2ua_clusters','*',$counter);
		if (isset ($profiles) ) {
			foreach ($profiles as $profile) {
				$check = $data->select_statement('sqlite:../../sqlite/cardinfo.db',$this->db_m2ua_link_table,'cluster','port_id=' . $_SESSION['port_num_clicked']);
				if ($check['cluster'] == "")
					$not_bound = true;
				else	
					$not_bound = false;
			}
		}
	
		?>
        <h3>M2UA Cluster Configuration</h3>
        
        <?php
		//Display notification
		if ($not_bound) {
			$notif = new NotificationBox( 'Warning', NotificationBox::Warning );
			$notif->add("","You <b>MUST BIND</b> a cluster to a M2UA Link in order to proceed");
			echo $notif->getHtml();		
			unset($notif);	
			echo "<br />";
		}
		
		//Check if generated ports table exists. If it does, show warning.
		$check = $data->select_statement('sqlite:../../sqlite/cardinfo.db','generated_ports','id','id=1');
		if (!empty($check) && $this->gateway_status()) {
			$notif = new NotificationBox( 'Warning', NotificationBox::Warning );
			$notif->add("","Cluster modification not allowed while Gateway is Running");
			echo $notif->getHtml();		
			unset($notif);	
			echo "<br />";
		}
		?>
        
		<form name='cluster_list' method='post'>
        	<table class="mytable" width='100%'>
		        <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">M2UA Clusters</th>
                <tr>
                	<td class="mytableheader ">Cluster Name</td>
                    <td class="mytableheader ">Traffic Mode</td>
                    <td class="mytableheader ">Load Share</td>
                    <td class="mytableheader "></td>
                </tr>
   		    	
                <?php
					//Display Clusters
					$profiles = $this->get_profiles('m2ua_clusters','*',$counter);
					if (isset ($profiles) ) {
						foreach ($profiles as $profile) {
							echo "<tr>";
							echo '<td>' . $profile['profile_name'] . '</td>';
							echo '<td>';
							if ($profile['traffic_mode'] == 'override')
								echo 'Override';
							elseif ($profile['traffic_mode'] == 'loadshare')
								echo 'Load Share';
							elseif ($profile['traffic_mode'] == 'broadcast')
								echo "Broadcast";
							echo "</td>\n";
							echo "<td>";
							if ($profile['load_share'] == 'roundrobin')
								echo "Round Robin";
							elseif ($profile['load_share'] == 'linkspecified')
								echo "Link Specified";
							elseif ($profile['load_share'] == 'customerspecified')
								echo "Customer Specified";							
							echo "</td>\n";
							echo '<td align="right">';
								
							//Check if this profile is bound to this port
							$check = $data->select_statement('sqlite:../../sqlite/cardinfo.db',$this->db_m2ua_link_table,'cluster','port_id=' . $_SESSION['port_num_clicked']);
							
							if ($check['cluster'] == $profile['profile_name']) 
								echo '<input type="submit" name="bind_cluster-' . $profile['id'] . '" value="Bind" ' . $_SESSION['disabled_button_class'] . ' />';
							else
								echo '<input type="submit" name="bind_cluster-' . $profile['id'] . '" value="Bind" ' . $_SESSION['button_class'] . ' />';
								
							if($this->gateway_status())
								echo '<input type="submit" name="edit_cluster-' . $profile['id'] . '" value="Edit" ' . $_SESSION['disabled_button_class'] . ' />';
							else
								echo '<input type="submit" name="edit_cluster-' . $profile['id'] . '" value="Edit" ' . $_SESSION['button_class'] . ' />';
							
							//check if used by any profile
							$cards = $this->pull_cards($data);
							$no_cards=false;
							foreach ($cards as $card) {
								//Check for mg_channels table
								if ($data->check_for_table('sqlite:../../sqlite/cardinfo.db',$card['name'] . '_' . $card['num'] . '_m2ua_link')) {
									$table = $card['name'] . '_' . $card['num'] . '_m2ua_link';
									$m2ua_link = $this->get_profiles($table,'cluster',$counter);
									if (isset ($m2ua_link) ) {
										foreach ($m2ua_link as $link) {
											if ($profile['profile_name'] == $link['cluster']) {
												$no_cards=true;
												break(2);
											}
										}
										unset ($m2ua_link);
									}
								}
							}
							
							if ($no_cards || $this->gateway_status())
								echo '<input type="submit" name="delete_cluster-' . $profile['id'] . '" value="Delete" ' . $_SESSION['disabled_button_class'] . ' />';
							else
								echo '<input type="submit" name="delete_cluster-' . $profile['id'] . '" value="Delete" ' . $_SESSION['button_class'] . ' />';
								
							echo '</td>';
							echo "</tr>";
						}
					}
				?>

			    <tr>
    	       		<td align='center' colspan="5" class="widget-content-header ui-state-active ui-corner-bottom">
					<?php
							if($this->gateway_status() && 0)  #NC Enable ADD for all cases: FIXME once we get this straight
								echo '<input type="submit" name="add_cluster" value="Add" ' . $_SESSION['disabled_button_class'] . ' />';
							else
								echo '<input type="submit" name="add_cluster" value="Add" ' . $_SESSION['button_class'] . ' />';
					?>
        	 	</tr>                
        	</table>
            <br />
			<table width="100%">
				<tr>
                	<?php
					if ($not_bound)
		            	echo "<td width='1%'><input type='submit' name='next_step' value='Next ->' " . $_SESSION['disabled_button_class'] . " /></td>";
					else
						echo "<td width='1%'><input type='submit' name='next_step' value='Next ->' " . $_SESSION['button_class'] . " /></td>";
					?>
            		<td align="right"><input type="submit" name="cancel_cluster" value="Cancel" <?=$_SESSION['button_class']?> /></td>
            	</tr>
            </table>            
            
        </form>
		<?php
	}
	
	/**
	*	Aggregated view for displaying the cluster and associated peers
	*	@param: $data
	*				Database object
	*	@param: $id
	*				cluster id number for retrieval from the database
	*/
	public function view_aggr_cluster($data,$id){
		$this->get_data_values($data,'m2ua_clusters',$id);
		$peer_profiles = $this->get_profiles($this->edit['profile_name'].'_peers','*',$counter);
		if (isset($peer_profiles)) {
			$notif = new NotificationBox( 'Info', NotificationBox::Info );
			$notif->add("", "Click here to <a href=\"m2ua_clusters.php\">view all profiles</a>" );
			echo $notif->getHtml();		
			unset($notif);		
		}
		else {
			$notif = new NotificationBox( 'Warning', NotificationBox::Warning );
			$notif->add("", "You <b>MUST CREATE</b> a Peer Profile in order to proceed with the configuration." );
			echo $notif->getHtml();		
			unset($notif);					
		}
		?>
        <br />
		<form name="aggr_cluster" method="post">  		   
	    	<input type="hidden" name="id_number" value="<?=$id?>" />
        	<input type="hidden" name="profile_name" value="<?=$this->edit['profile_name']?>" />
           	<table class="mytable" width='100%'>
	        	<th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">M2UA Cluster: <?=$this->edit['profile_name']?></th> 
    			<tr>
                	<td class='mytablesubheader' width='30%'>Traffic Mode</td>
                    <td align='left' width='50%'>
                    <?php
						if ($this->edit['traffic_mode'] == 'override')
							echo 'Override';
						elseif ($this->edit['traffic_mode'] == 'loadshare')
							echo 'Load Share';
						elseif ($this->edit['traffic_mode'] == 'broadcast')
							echo "Broadcast";
					?>
                    </td>
                    <td width='20%'></td>
                </tr>
    			<tr>
                	<td class='mytablesubheader' width='30%'>Load Sharing Method</td>
                    <td align='left' width='50%'>     
                    <?php
						if ($this->edit['load_share'] == 'roundrobin')
							echo "Round Robin";
						elseif ($this->edit['load_share'] == 'linkspecified')
							echo "Link Specified";
						elseif ($this->edit['load_share'] == 'customerspecified')
							echo "Customer Specified";
					?>
                    </td>
                    <td width='20%'></td>
                </tr>
                <tr>
                    <td class="mytablesubheader" width='30%'></td>
                    <td width='50%' align='left'>
                        <input type="submit" name="edit_cluster_aggr" value='Edit'  <?=$_SESSION['button_class']?>/>
                    </td>
                    <td width='20%'></td>
                </tr>                
            </table>
            <br />
            <table class="mytable" width='100%'>
                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left"><?=$this->edit['profile_name']?>: Peers</th>
                <tr>
                    <td class="mytableheader " width='85%'>Peer Name</td>
                    <?php /*<td class="mytableheader ">Include ASP Identifier</td>
                    <td class="mytableheader ">Initialize SCTP Association</td> */ ?>
                    <td class="mytableheader "></td>
				</tr>   
                <?php
				$used=false;
					$peer_profiles = $this->get_profiles($this->edit['profile_name'].'_peers','*',$counter);
					if (isset($peer_profiles)) {
						foreach ($peer_profiles as $peer) {
							$used=true;
							echo "<tr>\n";
							echo "<td>" . $peer['profile_name'] . "</td>";
							//echo "<td>" . $peer['include_asp_identifer'] . "</td>";
							//echo "<td>" . $peer['sctp_association'] . "</td>";
							echo "<td align=\"right\">";
							echo '<input type="submit" name="edit_peer-' . $peer['id'] . '" value="Edit" ' . $_SESSION['button_class'] . ' />';
							echo '<input type="submit" name="delete_peer-' . $peer['id'] . '" value="Delete" ' . $_SESSION['button_class'] . ' />';
							echo "</td>\n";
							echo "</tr>\n";
						}
					}
                ?>               
                <tr>
                    <td align='center' colspan="5" class="widget-content-header ui-state-active ui-corner-bottom"><input type='submit' name='add_peer' value='Add' <?=$_SESSION['button_class']?> /></td>
                </tr>                
            </table> 
            
            <br />
            <?php
			if ($used)
	            echo "<input type='submit' name='done_cluster' value='Complete' ".$_SESSION['button_class']." /> ";
            else
	            echo "<input type='submit' name='done_cluster' value='Complete' ".$_SESSION['disabled_button_class']." /> ";            
            ?>
        </form>                                   
		<?php
	}
	
	
	/**
	*	Edit a cluster profile
	*
	*	@param: $data
	*				Database object
	*/
	public function cluster_edit($data,$id,$profile_name) {
		//$table = $profile_name  . '_peers';
		$this->get_data_values($data,'m2ua_clusters',$id);
		$this->check_submit('edit_cluster');
		?>
		<form name="edit_cluster" method="post">  		   
	    	<input type="hidden" name="id_number" value="<?=$id?>" />
        	<input type="hidden" name="profile_name" value="<?=$profile_name?>" />
           	<table class="mytable" width='100%'>
	        	<th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left"><?=$profile_name?> Parameters</th> 
    			<tr>
                	<td class='mytablesubheader' width='30%'>Traffic Mode</td>
                    <td align='left' width='50%'>
                    	<select name='traffic_mode'>
                        	<option value='loadshare' <?php if ($this->pick['traffic_mode_loadshare'] == "yes") { echo 'selected="selected"'; } ?>  style="text-align:left" />Load Share</option>
                        	<option value='override' <?php if ($this->pick['traffic_mode_override'] == "yes") { echo 'selected="selected"'; } ?>  style="text-align:left" />Override</option>
                        	<option value='broadcast' <?php if ($this->pick['traffic_mode_broadcast'] == "yes") { echo 'selected="selected"'; } ?>  style="text-align:left" />Broadcast</option>                            
                        </select>
                    </td>
                    <td width='20%'><?=$this->error['load_share']?></td>
                </tr>
    			<tr>
                	<td class='mytablesubheader' width='30%'>Load Sharing Method</td>
                    <td align='left' width='50%'>
                    	<select name='load_share'>
                        	<option value='roundrobin' <?php if ($this->pick['load_share_roundrobin'] == "yes") { echo 'selected="selected"'; } ?>  style="text-align:left" />Round Robin</option>
                        	<option value='linkspecified' <?php if ($this->pick['load_share_linkspecified'] == "yes") { echo 'selected="selected"'; } ?>  style="text-align:left" />Link Specified</option>
                        	<option value='customerspecified' <?php if ($this->pick['load_share_customerspecified'] == "yes") { echo 'selected="selected"'; } ?>  style="text-align:left" />Customer Specified</option>                            
                        </select>
                    </td>
                    <td width='20%'><?=$this->error['load_share']?></td>
                </tr>
                <tr>
                    <td class="mytablesubheader" width='30%'></td>            
                    <td width='50%' align='left'>
                        <input type="submit" name="save_cluster" value='Save'  <?=$_SESSION['button_class']?>/>
                        <input type="submit" name="cancel_edit_cluster" value="Cancel" <?=$_SESSION['button_class']?>/>
                    </td>
                    <td width='20%'></td>
                </tr>                
            </table>
        </form>
    	<?php
	}
	
	/**
	*	Aggregated View for the Peer Profile
	*
	*	@param: $data
	*			Database Object
	*	@param: $id
	*			Peer ID Number
	*	@param: $profile_name
	*			Peer Profile Name
	*	@param: $cluster_profile
	*			Cluster profile name
	*	@param: $cluster_id
	*			Cluster ID Number	
	*/
	public function view_aggr_peer($data,$peer_id, $cluster_id, $cluster_profile){
		$this->get_data_values($data,$cluster_profile.'_peers',$peer_id);
		?>
		<form name="edit_peer" method="post">  	
        <?php
		$profiles = $this->get_profiles('sctp_interfaces','*',$counter);
		$used = false;
		$no_profile = false;
		
		if (isset ($profiles) ) {
			foreach ($profiles as $profile) {
				//Check if this profile is bound to this port
				$check = $data->select_statement('sqlite:../../sqlite/cardinfo.db',$cluster_profile.'_peers','sctp_int_name','id=' . $peer_id);
				if ($check['sctp_int_name'] == $profile['profile_name']) 
					$used=true;
			}
		}
		else {
			$no_profile = true;
			$notif = new NotificationBox( 'Warning', NotificationBox::Warning );
			$notif->add("", "You <b>MUST</b> create an SCTP interface in order to proceed with configuration." );
			if (!$used)
				$notif->add("", "You <b>MUST BIND</b> a SCTP interface to this Peer Profile." );
			echo $notif->getHtml();		
			unset($notif);
			unset($used);	
		}
					
		if ($used) {
			$notif = new NotificationBox( 'Info', NotificationBox::Info );
			$notif->add("", "Click here to <input type='submit' name='view_clusters_peer' value='view the associated cluster' ". $_SESSION['button_class'] . " />" );
			echo $notif->getHtml();		
			unset($notif);		
		}
		elseif (!$used && !$no_profile) {
			$notif = new NotificationBox( 'Warning', NotificationBox::Warning );
			$notif->add("", "You <b>MUST BIND</b> a SCTP interface to this Peer Profile." );
			echo $notif->getHtml();		
			unset($notif);		
		}
		?>			   
	    	<input type="hidden" name="id_number" value="<?=$peer_id?>" />
        	<input type="hidden" name="profile_name" value="<?=$this->edit['profile_name']?>" />
            <input type="hidden" name="cluster_profile" value="<?=$cluster_profile?>" />
            <input type="hidden" name="cluster_id" value="<?=$cluster_id?>" />
            <br />
           	<table class="mytable" width='100%'>
            	<th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left"><?=$this->edit['profile_name']?> Parameters</th> 
    			<tr>
                   	<td class='mytablesubheader' width='30%'>Include ASP Identifier</td>
                    <td align='left' width='50%'><?=ucfirst($this->edit['include_asp_identifier'])?></td>
                    <td width='20%'></td>
                </tr>
    			<tr>
                   	<td class='mytablesubheader' width='30%'>ASP Identifier</td>
                    <td align='left' width='50%'><?=$this->edit['asp_identifier']?></td>
                    <td width='20%'></td>
                </tr>
    			<tr>
                   	<td class='mytablesubheader' width='30%'>Initialize SCTP Association</td>
                    <td align='left' width='50%'><?=ucfirst($this->edit['sctp_association'])?></td>
                    <td width='20%'></td>
                </tr>
    			<tr>
                   	<td class='mytablesubheader' width='30%' rowspan="5" valign="center">Destination IP Address(es)</td>
                    <td align='left' width='50%'><?=$this->edit['dest_ip_addr_1']?></td>
                    <td width='20%'></td>                       
                </tr>
				<tr>
                    <td align='left' width='50%'><?=$this->edit['dest_ip_addr_2']?></td>
                    <td width='20%'></td>                       
                </tr>
				<tr>
                    <td align='left' width='50%'><?=$this->edit['dest_ip_addr_3']?></td>
                    <td width='20%'></td>                       
                </tr>
				<tr>
                    <td align='left' width='50%'><?=$this->edit['dest_ip_addr_4']?></td>
                    <td width='20%'></td>                       
                </tr>
				<tr>
                    <td align='left' width='50%'><?=$this->edit['dest_ip_addr_5']?></td>
                    <td width='20%'></td>                       
                </tr>
					<td class='mytablesubheader' width='30%'>Destination Port</td>
                    <td align='left' width='50%'><?=$this->edit['dest_port']?></td>
                    <td width='20%'></td>                  	
                </tr>  
                </tr>
					<td class='mytablesubheader' width='30%'>Number of Outgoing Streams</td>
                    <td align='left' width='50%'><?=$this->edit['num_out_streams']?></td>
                    <td width='20%'</td>                  	
                </tr>  
                <tr>
                    <td class="mytablesubheader" width='30%'></td>
                    <td width='50%' align='left'>
                        <input type="submit" name="edit_aggr_peer" value='Edit'  <?=$_SESSION['button_class']?>/>
                    </td>
                    <td width='20%'></td>
                </tr>                                                                    
            </table>
            <br />
           	<table class="mytable" width='100%'>
            	<th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">SCTP Interfaces</th> 
    			<tr> 
                	<td class="mytableheader " width='80%'>SCTP Interface Name</td>
                    <td class="mytableheader "></td>                
                </tr>
   		    	
                <?php
					//Display SCTP Interfaces
					$profiles = $this->get_profiles('sctp_interfaces','*',$counter);
					$used = false;
					if (isset ($profiles) ) {
						foreach ($profiles as $profile) {
							echo "<tr>";
							echo '<td>' . $profile['profile_name'] . '</td>';
							echo '<td align="right">';
								
							//Check if this profile is bound to this port
							$check = $data->select_statement('sqlite:../../sqlite/cardinfo.db',$cluster_profile.'_peers','sctp_int_name','id=' . $peer_id);
							
							//check if used by any profile
							$m2ua_clusters = $this->get_profiles('m2ua_clusters','*',$counter);
							$found_int=false;
							foreach ($m2ua_clusters as $cluster) {
								//Check for mg_channels table
								if ($data->check_for_table('sqlite:../../sqlite/cardinfo.db',$cluster['profile_name'].'_peers')) {
									$table = $cluster['profile_name'].'_peers';
									$peers_info = $this->get_profiles($table,'sctp_int_name',$counter);
									if (isset ($peers_info) ) {
										foreach ($peers_info as $peer) {
											if ($profile['profile_name'] == $peer['sctp_int_name']) {
												$found_int=true;
												break(2);
											}
										}
										unset ($peers_info);
									}
								}
							}

							if ($check['sctp_int_name'] == $profile['profile_name']) {
								echo '<input type="submit" name="bind_sctp-' . $profile['id'] . '" value="Bind" ' . $_SESSION['disabled_button_class'] . ' />';
								echo '<input type="submit" name="edit_sctp-' . $profile['id'] . '" value="Edit" ' . $_SESSION['button_class'] . ' />';
								$used=true;
							}
							else{
								if($this->gateway_status() && $found_int){
									echo '<input type="submit" name="bind_sctp-' . $profile['id'] . '" value="Bind" ' . $_SESSION['disabled_button_class'] . ' />';
									echo '<input type="submit" name="edit_sctp-' . $profile['id'] . '" value="Edit" ' . $_SESSION['disabled_button_class'] . ' />';
								}else{
									echo '<input type="submit" name="bind_sctp-' . $profile['id'] . '" value="Bind" ' . $_SESSION['button_class'] . ' />';
									echo '<input type="submit" name="edit_sctp-' . $profile['id'] . '" value="Edit" ' . $_SESSION['button_class'] . ' />';
								}
							}
							
							
							if ($found_int || $this->gateway_status())
								echo '<input type="submit" name="delete_sctp-' . $profile['id'] . '" value="Delete" ' . $_SESSION['disabled_button_class'] . ' />';
							else
								echo '<input type="submit" name="delete_sctp-' . $profile['id'] . '" value="Delete" ' . $_SESSION['button_class'] . ' />';
								
							echo '</td>';
							echo "</tr>";
						}
					}
				?>

			    <tr>
    	       		<td align='center' colspan="5" class="widget-content-header ui-state-active ui-corner-bottom"><input type='submit' name='add_sctp_int' value='Add' <?=$_SESSION['button_class']?> /></td>
        	 	</tr>                  
            </table>      
            <br />
            <?php
				if ($used) 
					echo "<input type='submit' name='done_peer' value='Back to Cluster' ".$_SESSION['button_class']." /> ";
				else
					echo "<input type='submit' name='done_peer' value='Back to Cluster' ".$_SESSION['disabled_button_class']." /> ";
			?>
        </form>
        <?php		
	}
	
	/**
	*	Edit a peer profile
	*	
	*	@param: $data
	*			Database Object
	*	@param: $id
	*			Peer ID Number
	*	@param: $profile_name
	*			Peer Profile Name
	*	@param: $cluster_profile
	*			Cluster profile name
	*	@param: $cluster_id
	*			Cluster ID Number
	*/
	public function edit_peer($data, $id,$cluster_profile, $cluster_id) {
		$this->get_data_values($data,$cluster_profile.'_peers',$id);
		$this->check_submit('edit_peer');
		?>
		<form name="edit_peer" method="post">  		   
	    	<input type="hidden" name="id_number" value="<?=$id?>" />
        	<input type="hidden" name="profile_name" value="<?=$this->edit['profile_name']?>" />
            <input type="hidden" name="cluster_profile" value="<?=$cluster_profile?>" />
            <input type="hidden" name="cluster_id" value="<?=$cluster_id?>" />
           	<table class="mytable" width='100%'>
            	<th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left"><?=$this->edit['profile_name']?> Parameters</th> 
    			<tr>
                   	<td class='mytablesubheader' width='30%'>Include ASP Identifier</td>
                    <td align='left' width='50%'>
                    	<select name='include_asp_identifier' id='include_asp_identifier'>
                        	<option value="enable" <?php if ($this->pick['include_asp_identifier_enable'] == "yes" ) { echo 'selected="selected"'; } ?> style="text-align:left" />Enable</option>
                            <option value="disable" <?php if ($this->pick['include_asp_identifier_disable'] == "yes" ) { echo 'selected="selected"'; } ?> style="text-align:left" />Disable</option>
                        </select>
                    </td>
                    <td width='20%'><?=$this->error['include_asp_identifier']?></td>
                </tr>
    			<tr>
                   	<td class='mytablesubheader' width='30%'>ASP Identifier</td>
                    <td align='left' width='50%'><input type='text' name='asp_identifier' id='asp_identifier' value='<?=$this->pick['asp_identifier']?>'  style="text-align:left; width:60px" /></td>
                    <td width='20%'><?=$this->error['asp_identifier']?></td>
                </tr>
    			<tr>
                   	<td class='mytablesubheader' width='30%'>Initialize SCTP Association</td>
                    <td align='left' width='50%'>
                    	<select name='sctp_association'>
                        	<option value="enable" <?php if ($this->pick['sctp_association_enable'] == "yes" ) { echo 'selected="selected"'; } ?> style="text-align:left" />Enable</option>
                            <option value="disable" <?php if ($this->pick['sctp_association_disable'] == "yes" ) { echo 'selected="selected"'; } ?> style="text-align:left" />Disable</option>
                        </select>
                    </td>
                    <td width='20%'><?=$this->error['sctp_association']?></td>
                </tr>
    			<tr>
                   	<td class='mytablesubheader' width='30%' valign="center">Destination IP Address(es)</td>
                    <td align='left' width='50%'><input type='text' name='dest_ip_1' value='<?=$this->pick['dest_ip_1']?>'  style="text-align:left; width:150px" /></td>
                    <td width='20%'><?=$this->error['dest_ip_1']?></td>                       
                </tr>
				<tr>
                	<td class='mytablesubheader' width='30%' valign="center"></td>
                    <td align='left' width='50%'><input type='text' name='dest_ip_2' value='<?=$this->pick['dest_ip_2']?>'  style="text-align:left; width:150px" /></td>
                    <td width='20%'><?=$this->error['dest_ip_2']?></td>                       
                </tr>
				<tr>
	                <td class='mytablesubheader' width='30%' valign="center"></td>
                    <td align='left' width='50%'><input type='text' name='dest_ip_3' value='<?=$this->pick['dest_ip_3']?>'  style="text-align:left; width:150px" /></td>
                    <td width='20%'><?=$this->error['dest_ip_3']?></td>                       
                </tr>
				<tr>
                	<td class='mytablesubheader' width='30%' valign="center"></td>
                    <td align='left' width='50%'><input type='text' name='dest_ip_4' value='<?=$this->pick['dest_ip_4']?>'  style="text-align:left; width:150px" /></td>
                    <td width='20%'><?=$this->error['dest_ip_4']?></td>                       
                </tr>
				<tr>
                	<td class='mytablesubheader' width='30%' valign="center"></td>
                    <td align='left' width='50%'><input type='text' name='dest_ip_5' value='<?=$this->pick['dest_ip_5']?>'  style="text-align:left; width:150px" /></td>
                    <td width='20%'><?=$this->error['dest_ip_5']?></td>                       
                </tr>                    
                <tr>
					<td class='mytablesubheader' width='30%'>Destination Port</td>
                    <td align='left' width='50%'><input type='text' name='dest_port' value='<?=$this->pick['dest_port']?>'  style="text-align:left; width:60px" /></td>
                    <td width='20%'><?=$this->error['dest_port']?></td>                  	
                </tr>  
                </tr>
					<td class='mytablesubheader' width='30%'>Number of Outgoing Streams</td>
                    <td align='left' width='50%'><input type='text' name='num_streams' value='<?=$this->pick['num_streams']?>'  style="text-align:left; width:60px" /></td>
                    <td width='20%'><?=$this->error['num_streams']?></td>                  	
                </tr>                  
                <tr>
                    <td class="mytablesubheader" width='30%'></td>            
                    <td width='50%' align='left'>
                        <input type="submit" name="save_peer" value='Save'  <?=$_SESSION['button_class']?>/>
                        <input type="submit" name="cancel_edit_peer" value="Cancel" <?=$_SESSION['button_class']?>/>
                    </td>
                    <td width='20%'></td>
                </tr>                                
            </table>
        </form>
        <?php
	}

	/**
	*	Edit a peer profile
	*	
	*	@param: $data
	*			Database Object
	*	@param: $id
	*			Peer ID Number
	*	@param: $profile_name
	*			Peer Profile Name
	*	@param: $cluster_profile
	*			Cluster profile name
	*	@param: $cluster_id
	*			Cluster ID Number
	*/
	public function edit_sctp($data, $id,$cluster_profile, $cluster_id, $peer_id, $peer_profile) {
		require_once '../../generic_functions.php';
		$interface_list = get_eth_interfaces();
		$this->get_data_values($data,'sctp_interfaces',$id);
		$this->check_submit('edit_sctp');
		
		?>
		<form name="edit_sctp" method="post">  		   
	    	<input type="hidden" name="id_number" value="<?=$id?>" />
        	<input type="hidden" name="profile_name" value="<?=$this->edit['profile_name']?>" />
            <input type="hidden" name="cluster_profile" value="<?=$cluster_profile?>" />
            <input type="hidden" name="cluster_id" value="<?=$cluster_id?>" />
            <input type='hidden' name='peer_id' value='<?=$peer_id?>' />
            <input type='hidden' name='peer_profile' value='<?=$peer_profile?>' />
           	<table class="mytable" width='100%'>
            	<th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left"><?=$this->edit['profile_name']?> Parameters</th> 
                    <!-- <td align='left' width='50%'><input type='text' name='dest_ip_1' value='<?=$this->pick['dest_ip_1']?>'  style="text-align:left; width:150px" /></td> -->
                <tr>
                	<td class='mytablesubheader' align='right' width='30%'>Source IP Address(es)</td>    
                    <td align='left' width='30%'>
                        <select name='dest_ip_1' id='dest_ip_1'>
                            <option value="">Select an IP Address</option>
                        <?php
                            foreach ($interface_list as $k=>$v) {
                                echo '<option value="' . $k . '" ';
                                if ($_REQUEST['dest_ip_1'] == $k)
                                    echo 'selected="selected"';
                                elseif ($this->edit['dest_ip_1'] == $k)
                                    echo 'selected="selected"';
                                echo '>'.$v;
                                echo '</option>';
                            }
                        ?>
                        </select>
               		</td>
                    <td width='20%'><?=$this->error['dest_ip_1']?></td>                       
                </tr>
				<tr>
                	<td class='mytablesubheader' width='30%' valign="center"></td>
                    <!-- <td align='left' width='50%'><input type='text' name='dest_ip_2' value='<?=$this->pick['dest_ip_2']?>'  style="text-align:left; width:150px" /></td> -->
                    <td align='left' width='30%'>
                        <select name='dest_ip_2' id='dest_ip_2'>
                            <option value="">Select an IP Address</option>
                        <?php
                            foreach ($interface_list as $k=>$v) {
                                echo '<option value="' . $k . '" ';
                                if ($_REQUEST['dest_ip_2'] == $k)
                                    echo 'selected="selected"';
                                elseif ($this->edit['dest_ip_2'] == $k)
                                    echo 'selected="selected"';
                                echo '>'.$v;
                                echo '</option>';
                            }
                        ?>
                        </select>
               		</td>
                    <td width='20%'><?=$this->error['dest_ip_2']?></td>                       
                </tr>
				<tr>
                	<td class='mytablesubheader' width='30%' valign="center"></td>
                    <!-- <td align='left' width='50%'><input type='text' name='dest_ip_3' value='<?=$this->pick['dest_ip_3']?>'  style="text-align:left; width:150px" /></td> -->
                    <td align='left' width='30%'>
                        <select name='dest_ip_3' id='dest_ip_3'>
                            <option value="">Select an IP Address</option>
                        <?php
                            foreach ($interface_list as $k=>$v) {
                                echo '<option value="' . $k . '" ';
                                if ($_REQUEST['dest_ip_3'] == $k)
                                    echo 'selected="selected"';
                                elseif ($this->edit['dest_ip_3'] == $k)
                                    echo 'selected="selected"';
                                echo '>'.$v;
                                echo '</option>';
                            }
                        ?>
                        </select>
               		</td>                    
                    <td width='20%'><?=$this->error['dest_ip_3']?></td>                       
                </tr>
				<tr>
                	<td class='mytablesubheader' width='30%' valign="center"></td>
                    <!-- <td align='left' width='50%'><input type='text' name='dest_ip_4' value='<?=$this->pick['dest_ip_4']?>'  style="text-align:left; width:150px" /></td> -->
                    <td align='left' width='30%'>
                        <select name='dest_ip_4' id='dest_ip_4'>
                            <option value="">Select an IP Address</option>
                        <?php
                            foreach ($interface_list as $k=>$v) {
                                echo '<option value="' . $k . '" ';
                                if ($_REQUEST['dest_ip_4'] == $k)
                                    echo 'selected="selected"';
                                elseif ($this->edit['dest_ip_4'] == $k)
                                    echo 'selected="selected"';
                                echo '>'.$v;
                                echo '</option>';
                            }
                        ?>
                        </select>
               		</td>                        
                    <td width='20%'><?=$this->error['dest_ip_4']?></td>                       
                </tr>
				<tr>
                	<td class='mytablesubheader' width='30%' valign="center"></td>
					<!-- <td align='left' width='50%'><input type='text' name='dest_ip_5' value='<?=$this->pick['dest_ip_5']?>'  style="text-align:left; width:150px" /></td> -->
                    <td align='left' width='30%'>
                        <select name='dest_ip_5' id='dest_ip_5'>
                            <option value="">Select an IP Address</option>
                        <?php
                            foreach ($interface_list as $k=>$v) {
                                echo '<option value="' . $k . '" ';
                                if ($_REQUEST['dest_ip_5'] == $k)
                                    echo 'selected="selected"';
                                elseif ($this->edit['dest_ip_5'] == $k)
                                    echo 'selected="selected"';
                                echo '>'.$v;
                                echo '</option>';
                            }
                        ?>
                        </select>
               		</td>                        
                    <td width='20%'><?=$this->error['dest_ip_5']?></td>                       
                </tr>
                <tr>
					<td class='mytablesubheader' width='30%'>Source Port</td>
                    <td align='left' width='50%'><input type='text' name='port' value='<?=$this->pick['port']?>'  style="text-align:left; width:60px" /></td>
                    <td width='20%'><?=$this->error['port']?></td>                  	
                </tr>                   
                <tr>
                    <td class="mytablesubheader" width='30%'></td>            
                    <td width='50%' align='left'>
                        <input type="submit" name="save_sctp" value='Save'  <?=$_SESSION['button_class']?>/>
                        <input type="submit" name="cancel_edit_sctp" value="Cancel" <?=$_SESSION['button_class']?>/>
                    </td>
                    <td width='20%'></td>
                </tr>                                
            </table>
        </form>
        <?php
	}
	
	/**
	*	Creates a new cluster profile
	*
	*	@param: $data
	*			Database object
	*/
	public function new_cluster($data) {
		$id = $data->select_statement_order_by($this->db_location,'m2ua_clusters','id','','id','-1');
		$a = $id['id'] + 1;

		?>
		<form name="create_profile" method="post">  		   
            <input type="hidden" name="id_number" value="<?=$a?>" />
            <table class="mytable" width='100%'>
                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">M2UA Cluster Creation</th> 
                <tr>
                    <td class="mytablesubheader" width='30%'>Cluster Name</td>
                    <td align="left" width='50%'><input type="text" name="cluster_name" value="CL<?=$a?>" style="text-align:left; width:150px" /></td>
                    <td width='20%'><?=$this->error['cluster_name']?></td>
                </tr>
                <tr>
                </tr>
                <tr>
                    <td class="mytablesubheader" width='30%'></td>            
                    <td width='50%' align='left'>
                        <input type="submit" name="create_new_cluster" value='Create'  <?=$_SESSION['button_class']?>/>
                        <input type="submit" name="cancel_new_cluster" value="Cancel" <?=$_SESSION['button_class']?>/>
                    </td>
                    <td width='20%'></td>
                </tr>
            </table>
		</form>
		<?php
	}	
	
	/**
	*	Creates a new peer profile
	*
	*	@param: $data
	*			Database object
	*	@param: $cluster_profile
	*			Cluster profile peer being added to
	*	@param: $cluster_id
	*			ID Number of the cluster profile being modified
	*/
	public function new_peer($data, $cluster_profile,$cluster_id) {
		$table = $cluster_profile . '_peers';
		$id = $data->select_statement_order_by($this->db_location,$table,'id','','id','-1');
		$a = $id['id'] + 1;

		?>
		<form name="create_profile" method="post">  		   
            <input type="hidden" name="id_number" value="<?=$a?>" />
            <input type='hidden' name='cluster_id' value="<?=$cluster_id?>" />
            <input type='hidden' name='cluster_profile' value="<?=$cluster_profile?>" />
            <table class="mytable" width='100%'>
                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left"><?=$cluster_profile?> Peer Creation</th> 
                <tr>
                    <td class="mytablesubheader" width='30%'>Peer Name</td>
                    <td align="left" width='50%'><?=$cluster_profile?>_<input type="text" name="peer_name" value="Peer<?=$a?>" style="text-align:left; width:150px" /></td>
                    <td width='20%'><?=$this->error['peer_name']?></td>
                </tr>
                <tr>
                </tr>
                <tr>
                    <td class="mytablesubheader" width='30%'></td>            
                    <td width='50%' align='left'>
                        <input type="submit" name="create_new_peer" value='Create'  <?=$_SESSION['button_class']?>/>
                        <input type="submit" name="cancel_new_peer" value="Cancel" <?=$_SESSION['button_class']?>/>
                    </td>
                    <td width='20%'></td>
                </tr>
            </table>
		</form>
		<?php
	}			
	
	/**
	*	Creates a new sctp profile
	*
	*	@param: $data
	*			Database object
	*	@param: $cluster_profile
	*			Cluster profile peer being added to
	*	@param: $cluster_id
	*			ID Number of the cluster profile being modified
	*/
	public function new_sctp($data, $peer_id, $peer_profile, $cluster_profile,$cluster_id) {
		$id = $data->select_statement_order_by($this->db_location,'sctp_interfaces','id','','id','-1');
		$a = $id['id'] + 1;

		?>
		<form name="create_sctp" method="post">  		   
            <input type="hidden" name="id_number" value="<?=$a?>" />
            <input type='hidden' name='peer_id' value='<?=$peer_id?>' />
            <input type='hidden' name='peer_profile' value='<?=$peer_profile?>' />
            <input type='hidden' name='cluster_id' value="<?=$cluster_id?>" />
            <input type='hidden' name='cluster_profile' value="<?=$cluster_profile?>" />
            <table class="mytable" width='100%'>
                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">SCTP Interface</th> 
                <tr>
                    <td class="mytablesubheader" width='30%'>Inteface Name</td>
                    <td align="left" width='50%'><input type="text" name="sctp_name" value="SCTP<?=$a?>" style="text-align:left; width:150px" /></td>
                    <td width='20%'><?=$this->error['sctp_name']?></td>
                </tr>
                <tr>
                </tr>
                <tr>
                    <td class="mytablesubheader" width='30%'></td>            
                    <td width='50%' align='left'>
                        <input type="submit" name="create_new_sctp" value='Create'  <?=$_SESSION['button_class']?>/>
                        <input type="submit" name="cancel_new_sctp" value="Cancel" <?=$_SESSION['button_class']?>/>
                    </td>
                    <td width='20%'></td>
                </tr>
            </table>
		</form>
		<?php
	}			
	
	/**
	* Displays the deletion confirmation box
	* @param: $data
	*			database object
	* @param: $delete_id
	*			id of cluster being removed
	*/
	public function display_delete_cluster($data,$delete_id) {
		$profile_name = $data->select_statement('sqlite:../../sqlite/cardinfo.db','m2ua_clusters',"profile_name","id = " . $delete_id);
		$notif = new NotificationBox( 'Error', NotificationBox::Error );
		$notif->add("", "Removing the Cluster <b>" . $profile_name['profile_name'] . "</b> will remove all associate peers." );
		$notif->add("", "Click <b>REMOVE</b> to continue." );
		echo $notif->getHtml();		
		unset($notif);	
		
		?>
        <br />
		<form name="remove_profile" method="post">  		   
            <input type="hidden" name="id_number" value="<?=$delete_id?>" />
                <table class="mytable" width='100%'>
                    <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">M2UA Cluster Configuration</th> 
                    <tr>
                        <td class="mytablesubheader" width='50%'>Cluster marked for Removal</td>
                        <td align="left" width='50%'><b><?=$profile_name['profile_name']?></b></td>
                    </tr>
                    <tr>
                        <td class="mytablesubheader" width='50%'></td>
                        <td>
                        <input type="submit" name="delete_cluster" value='Remove'  <?php echo $_SESSION['button_class']; ?>/>
                        <input type="submit" name="cancel" value="Cancel" <?php echo $_SESSION['button_class']; ?>/>
                        </td>
                    </tr>
                </table>
            </form>
		<?php
	}	
	
	/**
	* Displays the deletion confirmation box
	* @param: $data
	*			database object
	* @param: $delete_id
	*			id of peer being removed
	* @param: $cluster_id
	*			id of cluster
	*/
	public function display_delete_peer($data,$delete_id, $cluster_id) {
		$cluster_name = $data->select_statement('sqlite:../../sqlite/cardinfo.db','m2ua_clusters','profile_name','id=' . $cluster_id);
		$profile_name = $data->select_statement('sqlite:../../sqlite/cardinfo.db',$cluster_name['profile_name'].'_peers',"profile_name","id = " . $delete_id);
		$notif = new NotificationBox( 'Error', NotificationBox::Error );
		$notif->add("", "Removing the Peer <b>" . $profile_name['profile_name'] . "</b> will remove this peer ONLY." );
		$notif->add("", "Click <b>REMOVE</b> to continue." );
		echo $notif->getHtml();		
		unset($notif);	
		
		?>
        <br />
		<form name="remove_peer" method="post">  		   
            <input type="hidden" name="id_number" value="<?=$delete_id?>" />
            <input type='hidden' name='cluster_id' value='<?=$cluster_id?>' />
            <input type='hidden' name='cluster_profile' value='<?=$cluster_name['profile_name']?>' />
                <table class="mytable" width='100%'>
                    <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left"><?=$cluster_profile?> Peer Removal</th> 
                    <tr>
                        <td class="mytablesubheader" width='50%'>Cluster marked for Removal</td>
                        <td align="left" width='50%'><b><?=$profile_name['profile_name']?></b></td>
                    </tr>
                    <tr>
                        <td class="mytablesubheader" width='50%'></td>
                        <td>
                        <input type="submit" name="delete_peer" value='Remove'  <?php echo $_SESSION['button_class']; ?>/>
                        <input type="submit" name="cancel_delete_peer" value="Cancel" <?php echo $_SESSION['button_class']; ?>/>
                        </td>
                    </tr>
                </table>
            </form>
		<?php
	}		
	
	/**
	* Displays the deletion confirmation box
	* @param: $data
	*			database object
	* @param: $delete_id
	*			id of peer being removed
	* @param: $cluster_id
	*			id of cluster
	* @param: $peer_id
	*			id of peer
	* @param: $peer_profile
	*			peer profile working on
	* @param: $cluster_profile
	*			cluster profile working on
	*/
	public function display_delete_sctp($data,$delete_id, $peer_id, $peer_profile, $cluster_profile, $cluster_id) {
		$profile_name = $data->select_statement('sqlite:../../sqlite/cardinfo.db','sctp_interfaces',"profile_name","id = " . $delete_id);
		$notif = new NotificationBox( 'Error', NotificationBox::Error );
		$notif->add("", "Removing the Interface <b>" . $profile_name['profile_name'] . "</b> will remove this SCTP interface ONLY." );
		$notif->add("", "Click <b>REMOVE</b> to continue." );
		echo $notif->getHtml();		
		unset($notif);	
		
		?>
        <br />
		<form name="remove_sctp" method="post">  		   
            <input type="hidden" name="id_number" value="<?=$delete_id?>" />
            <input type='hidden' name='cluster_id' value='<?=$cluster_id?>' />
            <input type='hidden' name='peer_id' value='<?=$peer_id?>' />
            <input type='hidden' name='peer_profile' value='<?=$peer_profile?>' />
            <input type='hidden' name='cluster_profile' value='<?=$cluster_profile?>' />
                <table class="mytable" width='100%'>
                    <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">SCTP Interface</th> 
                    <tr>
                        <td class="mytablesubheader" width='50%'>Interface marked for Removal</td>
                        <td align="left" width='50%'><b><?=$profile_name['profile_name']?></b></td>
                    </tr>
                    <tr>
                        <td class="mytablesubheader" width='50%'></td>
                        <td>
                        <input type="submit" name="delete_sctp" value='Remove'  <?php echo $_SESSION['button_class']; ?>/>
                        <input type="submit" name="cancel_sctp_delete" value="Cancel" <?php echo $_SESSION['button_class']; ?>/>
                        </td>
                    </tr>
                </table>
            </form>
		<?php
	}		
	
	/**
	*	Retreives data from a database table
	*
	*	@param: $data
	*				Database object
	*	@param: $table
	*				Table to pull information from
	*	@param: $id
	*				ID to use in the select statement where clause
	*/
	private function get_data_values($data,$table,$id) {
		if ($data->check_for_table('sqlite:../../sqlite/cardinfo.db',$table) > 1)
			$this->edit = $data->select_statement('sqlite:../../sqlite/cardinfo.db',$table,'*','id=' . $id);
	}

	
	/**
	* Checks if a row exists in the database
	* @param: $data
	*			database object
	* @param: $table
	*			mg profile table name
	* @return boolean	
	*/
	public function check_for_row($data,$table) {
		$row_exists = $data->select_statement($this->db_location, $table, "id", 'id=1');

		if (count($row_exists) > 0)
			return true;
		else
			return false;
	}	
	
	/**
	*	Gets requested profiles
	*	
	*	@param: $table
	*				table where the data will be retrieved from
	*	@param: $param
	*				parameters to retrieve from the table
	*/
	public function get_profiles($table,$param,&$profile_counter)
	{
		$a = 0;

		$select = "SELECT " . $param . " FROM " . $table . ";";
		$data = new database_class;
		
		//echo $select;
		
		$table = $data->check_for_table($this->db_location,$table);
		if ($table >1 )
		{
			try
			{
				//open the database
				$db = new PDO($this->db_location);
	
				$result = $db->query($select);
			
				foreach($result as $row)
				{
					$profile[$a] = $row;
					$a++;
				}
				// close the database connection
				$db = NULL;
			}
			catch(PDOException $e)
			{
				print 'Exception : '.$e->getMessage();
				echo "Table = $table<br />";
				echo "Select statement = $select <br />";
			}
		}
	
		$profile_counter = $a;
		
		return $profile;
	}	
	
	public function pull_cards($data)
	{
		$temp_cards = $this->get_profiles('card_present','dev_name',$counter);
		$a = 0;
		foreach($temp_cards as $card) {
			$card_explode = explode ('-', $card['dev_name']);
			if ($card_explode[1] == "A101" || $card_explode[1] == "A102" || $card_explode[1] == "A104" || $card_explode[1] == "A108" || $card_explode[1] == "A116" || $card_explode[1] == "B601")
				$cards[$a]['name'] = $card_explode[1];
				$cards[$a]['num'] = $card_explode[3];
			$a++;
		}
		
		return $cards;
	}	
	
	
	public function validation($page,$data="") {
		if ($page == "new_cluster") {
			//check for profiles with the same name
			//pull profile names			
			if ($_POST['cluster_name'] == "") {
				$this->error['cluster_name'] = '<font color="red">Please enter a Cluster <b>Profile Name</b></font>';
				$error_count++;
			}
			elseif (strpos($_REQUEST['link_name'], " ") !== false) {
                        $this->error_count++;
                        $this->error['cluster_name'] = "Please create a <b>Cluster Name</b> without any spaces";
            }
			
			
			if ((strpbrk('-',$_POST['cluster_name']) != FALSE || strpbrk(',',$_POST['cluster_name']) != FALSE || strpbrk('@',$_POST['cluster_name']) != FALSE || strpbrk('*',$_POST['cluster_name']) != FALSE)) {
				$this->error['cluster_name'] = "<font color=\"red\">Invalid characters, <b>-,@*</b>, used in profile name</font>";
				$error_count++;			
			}
						
			else{
				$profiles = $this->get_profiles('m2ua_clusters','profile_name',$counter);
				if (isset($profiles)) {
					foreach ($profiles as $profile) {
						if ($_POST['cluster_name'] == $profile['profile_name']) {
							$this->error['cluster_name'] = '<font color="red">Please choose a <b>UNIQUE</b> Cluster <b>Profile Name</b></font>';
							$error_count++;
							break;
						}
					}
				}
			}
		}
		if ($page == "new_sctp") {
			if ($_POST['sctp_name'] == "") {
				$this->error['sctp_name'] = '<font color="red">Please enter a <b>SCTP Interface Name</b></font>';
				$error_count++;
			}
			elseif (strpos($_REQUEST['sctp_name'], " ") !== false) {
            	$this->error_count++;
                $this->error['sctp_name'] = "Please create a <b>SCTP Interface Name</b> without any spaces";
            }			
			elseif ((strpbrk('-',$_POST['sctp_name']) != FALSE || strpbrk(',',$_POST['sctp_name']) != FALSE || strpbrk('@',$_POST['sctp_name']) != FALSE || strpbrk('*',$_POST['sctp_name']) != FALSE)) {
				$this->error['sctp_name'] = "<font color=\"red\">Invalid characters, <b>-,@*</b>, used in profile name</font>";
				$error_count++;			
			}
			else {
				$profiles = $this->get_profiles('sctp_interfaces','profile_name',$counter);
					if (isset($profiles)) {
					foreach ($profiles as $profile) {
						if ($_POST['sctp_name'] == $profile['profile_name']) {
							$this->error['sctp_name'] = '<font color="red">Please choose a <b>UNIQUE SCTP Interface Name</b></font>';
							$error_count++;
							break;
						}
					}
				}
			}
		}
		if ($page == "new_peer") {
			if ($_POST['peer_name'] == "") {
				$this->error['peer_name'] = '<font color="red">Please enter a Peer <b>Profile Name</b></font>';
				$error_count++;
			}
			elseif (strpos($_REQUEST['peer_name'], " ") !== false) {
                        $this->error_count++;
            	$this->error['peer_name'] = "Please create a <b>Peer Profile Name</b> without any spaces";
            }			
			elseif ((strpbrk('-',$_POST['peer_name']) != FALSE || strpbrk(',',$_POST['peer_name']) != FALSE || strpbrk('@',$_POST['peer_name']) != FALSE || strpbrk('*',$_POST['peer_name']) != FALSE)) {
				$this->error['peer_name'] = "<font color=\"red\">Invalid characters, <b>-,@*</b>, used in profile name</font>";
				$error_count++;			
			}			
			else {
				$peers = $this->get_profiles($_POST['cluster_profile'].'_peers','profile_name',$counter);
				if (isset($peers)) {
					foreach ($peers as $peer) {
						if ($_POST['cluster_profile'] . '_' . $_POST['peer_name'] == $peer['profile_name']) {
							$this->error['peer_name'] = '<font color="red">Please choose a <b>UNIQUE</b> Peer <b>Profile Name</b></font>';
							$error_count++;
							break;
						}
					}
				}
			}	
		}
		if ($page == "edit_peer") {
			if (!preg_match('/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/',$_POST['dest_ip_1']) && $_POST['dest_ip_1'] != "") {
				$this->error['dest_ip_1'] ="<font color='red'><b>IP Address</b> entered is not a valid <b>IPv4 Address</b></font>";
				$error_count++;
			}
			else {
				if ($_POST['dest_ip_1'] != "") {
					if ($_POST['dest_ip_1'] == $_POST['dest_ip_2'] || $_POST['dest_ip_1'] == $_POST['dest_ip_3'] || $_POST['dest_ip_1'] == $_POST['dest_ip_4'] || $_POST['dest_ip_1'] == $_POST['dest_ip_5'] ) {
						$this->error['dest_ip_1'] ="<font color='red'><b>IP Address MUST</b> be <b>UNIQUE</b></font>";
						$error_count++;
					}
					
					//Check if IP Unique across all interfaces
					if (!$this->check_cl_peer_ips($data,$_POST['dest_ip_1'])) {
						$this->error['dest_ip_1'] = "<font color='red'><b>IP Address MUST</b> be UNIQUE across all cluster peers</font>";
						$error_count++;
					}
				}
			}			
			if (!preg_match('/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/',$_POST['dest_ip_2']) && $_POST['dest_ip_2'] != "") {
				$this->error['dest_ip_2'] ="<font color='red'><b>IP Address</b> entered is not a valid <b>IPv4 Address</b></font>";
				$error_count++;
			}
			else {
				if ($_POST['dest_ip_2'] != "") {
					if ($_POST['dest_ip_2'] == $_POST['dest_ip_1'] || $_POST['dest_ip_2'] == $_POST['dest_ip_3'] || $_POST['dest_ip_2'] == $_POST['dest_ip_4'] || $_POST['dest_ip_1'] == $_POST['dest_ip_5'] ) {
						$this->error['dest_ip_2'] ="<font color='red'><b>IP Address MUST </b> be <b>UNIQUE</b></font>";
						$error_count++;
					}
					//Check if IP Unique across all interfaces
					if (!$this->check_cl_peer_ips($data,$_POST['dest_ip_2'])) {
						$this->error['dest_ip_2'] = "<font color='red'><b>IP Address MUST</b> be UNIQUE across all cluster peers</font>";
						$error_count++;
					}				
				}
			}			
			if (!preg_match('/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/',$_POST['dest_ip_3']) && $_POST['dest_ip_3'] != "") {
				$this->error['dest_ip_3'] ="<font color='red'><b>IP Address</b> entered is not a valid <b>IPv4 Address</b></font>";
				$error_count++;
			}
			else {
				if ($_POST['dest_ip_3'] != "") {
					if ($_POST['dest_ip_3'] == $_POST['dest_ip_1'] || $_POST['dest_ip_3'] == $_POST['dest_ip_2'] || $_POST['dest_ip_3'] == $_POST['dest_ip_4'] || $_POST['dest_ip_3'] == $_POST['dest_ip_5'] ) {
						$this->error['dest_ip_3'] ="<font color='red'><b>IP Address MUST </b> be <b>UNIQUE</b></font>";
						$error_count++;
					}
					//Check if IP Unique across all interfaces
					if (!$this->check_cl_peer_ips($data,$_POST['dest_ip_3'])) {
						$this->error['dest_ip_3'] = "<font color='red'><b>IP Address MUST</b> be UNIQUE across all cluster peers</font>";
						$error_count++;
					}				
				}
			}					
			if (!preg_match('/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/',$_POST['dest_ip_4']) && $_POST['dest_ip_4'] != "") {
				$this->error['dest_ip_4'] ="<font color='red'><b>IP Address</b> entered is not a valid <b>IPv4 Address</b></font>";
				$error_count++;
			}
			else {
				if ($_POST['dest_ip_4'] != "") {
					if ($_POST['dest_ip_4'] == $_POST['dest_ip_1'] || $_POST['dest_ip_4'] == $_POST['dest_ip_2'] || $_POST['dest_ip_4'] == $_POST['dest_ip_3'] || $_POST['dest_ip_4'] == $_POST['dest_ip_5'] ) {
						$this->error['dest_ip_4'] ="<font color='red'><b>IP Address MUST </b> be <b>UNIQUE</b></font>";
						$error_count++;
					}
					//Check if IP Unique across all interfaces
					if (!$this->check_cl_peer_ips($data,$_POST['dest_ip_4'])) {
						$this->error['dest_ip_4'] = "<font color='red'><b>IP Address MUST</b> be UNIQUE across all cluster peers</font>";
						$error_count++;
					}				
				}
			}		
						
			if (!preg_match('/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/',$_POST['dest_ip_5']) && $_POST['dest_ip_5'] != "") {
				$this->error['dest_ip_5'] ="<font color='red'><b>IP Address</b> entered is not a valid <b>IPv4 Address</b></font>";
				$error_count++;
			}
			else {
				if ($_POST['dest_ip_5'] != "") {
					if ($_POST['dest_ip_5'] == $_POST['dest_ip_1'] || $_POST['dest_ip_5'] == $_POST['dest_ip_2'] || $_POST['dest_ip_5'] == $_POST['dest_ip_3'] || $_POST['dest_ip_5'] == $_POST['dest_ip_4'] ) {
						$this->error['dest_ip_5'] ="<font color='red'><b>IP Address MUST </b> be <b>UNIQUE</b></font>";
						$error_count++;
					}
					//Check if IP Unique across all interfaces
					if (!$this->check_cl_peer_ips($data,$_POST['dest_ip_5'])) {
						$this->error['dest_ip_5'] = "<font color='red'><b>IP Address MUST</b> be UNIQUE across all cluster peers</font>";
						$error_count++;
					}				
				}
			}				

			if ( ($_POST['dest_ip_1'] == "" && $_POST['dest_ip_2'] != "" ) || ($_POST['dest_ip_1'] == "" && $_POST['dest_ip_3'] != "" ) && ($_POST['dest_ip_1'] == "" && $_POST['dest_ip_4'] != "" ) || ($_POST['dest_ip_1'] == "" && $_POST['dest_ip_5'] != "" )) {
				$this->error['dest_ip_1'] = "<font color='red'>You must select a <b>IP Address</b> in the first field</font>";
				$error_count++;
			}
			elseif ($_POST['dest_ip_1'] == "" ) {
				$this->error['dest_ip_1'] = "<font color='red'>You must select at least 1 <b>IP Address</b></font>";
				$error_count++;				
			}
			
			if (isset($_POST['asp_identifier'])) {
				if ($_POST['asp_identifier'] == "" && $_POST['include_asp_identifer'] == "enable") {
					$this->error['asp_identifier'] = "<font color='red'>Please enter a value for the <b>ASP Identifier</b></font>";
					$error_count++;
				}
				elseif ($_POST['include_asp_identifier'] == "disable" && $_POST['asp_identifier'] != "") {
					$this->error['asp_identifier'] = "<font color='red'>Include ASP Identifier is set to <b>disabled</b>. ASP identifier is not required</font>";
					$error_counter++;
				}
				elseif (!is_numeric($_POST['asp_identifier'])) {
					$this->error['asp_identifier'] = "<font color=\"red\">Please Enter a <b>NUMERIC</b> value for the <b>ASP Identifier</b></font>";
					$error_counter++;
				}
			}
			
			if ($_POST['num_streams'] == "") {
				$this->error['num_streams'] = "<font color='red'>Please enter a value for the <b>Number of Streams</b></font>";
				$error_count++;
			}
			elseif (!is_numeric($_POST['num_streams'])) {
				$this->error['num_streams'] = "<font color=\"red\">Please Enter a <b>NUMERIC</b> value for the <b>Number of Streams</b></font>";
				$error_counter++;
			}	

			if ($_POST['dest_port'] == "") {
				$this->error['dest_port'] = "<font color='red'>Please enter a value for the <b>Destination Port</b></font>";
				$error_count++;
			}
			elseif (!is_numeric($_POST['dest_port'])) {
				$this->error['dest_port'] = "<font color=\"red\">Please Enter a <b>NUMERIC</b> value for the <b>Destination Port</b></font>";
				$error_counter++;
			}
			
			if ($_POST['dest_port'] < 0) {
				$this->error['dest_port'] = "<font color=\"red\"><b>Destination Port</b> MUST be between 1 and 65535</font>";
				$error_count++;
			}
			
			if ( $_POST['dest_port'] > 65535) {
				$this->error['dest_port'] = "<font color=\"red\"><b>Destination Port</b> MUST be between 1 and 65535</font>";
				$error_count++;
			}
		}
		if ($page == "edit_sctp") {
			if (!preg_match('/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/',$_POST['dest_ip_1']) && $_POST['dest_ip_1'] != "") {
				$this->error['dest_ip_1'] ="<font color='red'><b>IP Address</b> entered is not a valid <b>IPv4 Address</b></font>";
				$error_count++;
			}
			else {
				if ($_POST['dest_ip_1'] != "") {
					if ($_POST['dest_ip_1'] == $_POST['dest_ip_2'] || $_POST['dest_ip_1'] == $_POST['dest_ip_3'] || $_POST['dest_ip_1'] == $_POST['dest_ip_4'] || $_POST['dest_ip_1'] == $_POST['dest_ip_5'] ) {
						$this->error['dest_ip_1'] ="<font color='red'><b>IP Address MUST</b> be <b>UNIQUE</b></font>";
						$error_count++;
					}
					
					//Check if IP Unique across all interfaces
					if (!$this->check_sctp_interfaces($data,$_POST['dest_ip_1'])) {
						$this->error['dest_ip_1'] = "<font color='red'><b>IP Address MUST</b> be UNIQUE across all SCTP Interfaces</font>";
						$error_count++;
					}
				}
			}
			if (!preg_match('/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/',$_POST['dest_ip_2']) && $_POST['dest_ip_2'] != "") {
				$this->error['dest_ip_2'] ="<font color='red'><b>IP Address</b> entered is not a valid <b>IPv4 Address</b></font>";
				$error_count++;
			}
			else {
				if ($_POST['dest_ip_2'] != "") {
					if ($_POST['dest_ip_2'] == $_POST['dest_ip_1'] || $_POST['dest_ip_2'] == $_POST['dest_ip_3'] || $_POST['dest_ip_2'] == $_POST['dest_ip_4'] || $_POST['dest_ip_1'] == $_POST['dest_ip_5'] ) {
						$this->error['dest_ip_2'] ="<font color='red'><b>IP Address MUST </b> be <b>UNIQUE</b></font>";
						$error_count++;
					}
					//Check if IP Unique across all interfaces
					if (!$this->check_sctp_interfaces($data,$_POST['dest_ip_2'])) {
						$this->error['dest_ip_2'] = "<font color='red'><b>IP Address MUST</b> be UNIQUE across all SCTP Interfaces</font>";
						$error_count++;
					}				
				}
			}
			if (!preg_match('/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/',$_POST['dest_ip_3']) && $_POST['dest_ip_3'] != "") {
				$this->error['dest_ip_3'] ="<font color='red'><b>IP Address</b> entered is not a valid <b>IPv4 Address</b></font>";
				$error_count++;
			}
			else {
				if ($_POST['dest_ip_3'] != "") {
					if ($_POST['dest_ip_3'] == $_POST['dest_ip_1'] || $_POST['dest_ip_3'] == $_POST['dest_ip_2'] || $_POST['dest_ip_3'] == $_POST['dest_ip_4'] || $_POST['dest_ip_3'] == $_POST['dest_ip_5'] ) {
						$this->error['dest_ip_3'] ="<font color='red'><b>IP Address MUST </b> be <b>UNIQUE</b></font>";
						$error_count++;
					}
					//Check if IP Unique across all interfaces
					if (!$this->check_sctp_interfaces($data,$_POST['dest_ip_3'])) {
						$this->error['dest_ip_3'] = "<font color='red'><b>IP Address MUST</b> be UNIQUE across all SCTP Interfaces</font>";
						$error_count++;
					}				
				}
			}			
			if (!preg_match('/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/',$_POST['dest_ip_4']) && $_POST['dest_ip_4'] != "") {
				$this->error['dest_ip_4'] ="<font color='red'><b>IP Address</b> entered is not a valid <b>IPv4 Address</b></font>";
				$error_count++;
			}
			else {
				if ($_POST['dest_ip_4'] != "") {
					if ($_POST['dest_ip_4'] == $_POST['dest_ip_1'] || $_POST['dest_ip_4'] == $_POST['dest_ip_2'] || $_POST['dest_ip_4'] == $_POST['dest_ip_3'] || $_POST['dest_ip_4'] == $_POST['dest_ip_5'] ) {
						$this->error['dest_ip_4'] ="<font color='red'><b>IP Address MUST </b> be <b>UNIQUE</b></font>";
						$error_count++;
					}
					//Check if IP Unique across all interfaces
					if (!$this->check_sctp_interfaces($data,$_POST['dest_ip_4'])) {
						$this->error['dest_ip_4'] = "<font color='red'><b>IP Address MUST</b> be UNIQUE across all SCTP Interfaces</font>";
						$error_count++;
					}				
				}
			}			
			
			if (!preg_match('/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/',$_POST['dest_ip_5']) && $_POST['dest_ip_5'] != "") {
				$this->error['dest_ip_5'] ="<font color='red'><b>IP Address</b> entered is not a valid <b>IPv4 Address</b></font>";
				$error_count++;
			}
			else {
				if ($_POST['dest_ip_5'] != "") {
					if ($_POST['dest_ip_5'] == $_POST['dest_ip_1'] || $_POST['dest_ip_5'] == $_POST['dest_ip_2'] || $_POST['dest_ip_5'] == $_POST['dest_ip_3'] || $_POST['dest_ip_5'] == $_POST['dest_ip_4'] ) {
						$this->error['dest_ip_5'] ="<font color='red'><b>IP Address MUST </b> be <b>UNIQUE</b></font>";
						$error_count++;
					}
					//Check if IP Unique across all interfaces
					if (!$this->check_sctp_interfaces($data,$_POST['dest_ip_5'])) {
						$this->error['dest_ip_5'] = "<font color='red'><b>IP Address MUST</b> be UNIQUE across all SCTP Interfaces</font>";
						$error_count++;
					}				
				}
			}			

			if ( ($_POST['dest_ip_1'] == "" && $_POST['dest_ip_2'] != "" ) || ($_POST['dest_ip_1'] == "" && $_POST['dest_ip_3'] != "" ) && ($_POST['dest_ip_1'] == "" && $_POST['dest_ip_4'] != "" ) || ($_POST['dest_ip_1'] == "" && $_POST['dest_ip_5'] != "" )) {
				$this->error['dest_ip_1'] = "<font color='red'>You must enter a <b>Destination IP Address</b> in the first field</font>";
				$error_count++;
			}
			elseif ($_POST['dest_ip_1'] == "" ) {
				$this->error['dest_ip_1'] = "<font color='red'>You must enter at least 1 <b>Destination IP Address</b></font>";
				$error_count++;				
			}

			if ($_POST['port'] == "") {
				$this->error['port'] = "<font color='red'>Please enter a value for the <b>Port</b></font>";
				$error_count++;
			}
			elseif (!is_numeric($_POST['port'])) {
				$this->error['port'] = "<font color=\"red\">Please Enter a <b>NUMERIC</b> value for the <b>Port</b></font>";
				$error_count++;
			}
			elseif ($_POST['port'] < 0 || $_POST['port'] > 65535) {
				$this->error['port'] = "<font color=\"red\"><b>Destination Port</b> MUST be between 1 and 65535</font>";
				$error_count++;
			}				
		}

		if ($error_count == 0)
			return true;
		else
			return false;
	}
	
	/**
	*	Checks all the SCTP interfaces to make sure there are no IP Conflicts
	*/
	public function check_sctp_interfaces($data,$ip) {
		$get_all_sctp = $this->get_complete_table($data,'sctp_interfaces');
		
		if (!empty($get_all_sctp)) {
			foreach ($get_all_sctp as $sctp) {
				if ($sctp['profile_name'] != $_POST['profile_name']) {
					if ($ip == $sctp['dest_ip_1'])
						return false;
					if ($ip == $sctp['dest_ip_2']) 
						return false;
					if ($ip == $sctp['dest_ip_3'])
						return false;
					if ($ip == $sctp['dest_ip_4'])
						return false;
					if ($ip == $sctp['dest_ip_5'])
						return false;
				}
			}
		}
		return true;
	}
	
	public function check_cl_peer_ips($data,$ip) {
		$get_all_peers = $this->get_complete_table($data,$_POST['cluster_profile'].'_peers');
		
		if (!empty($get_all_peers)) {
			foreach ($get_all_peers as $peers) {
				if ($peers['profile_name'] != $_POST['profile_name']) {
					if ($ip == $peers['dest_ip_addr_1'])
						return false;
					if ($ip == $peers['dest_ip_addr_2']) 
						return false;
					if ($ip == $peers['dest_ip_addr_3'])
						return false;
					if ($ip == $peers['dest_ip_addr_4'])
						return false;
					if ($ip == $peers['dest_ip_addr_5'])
						return false;
				}
			}
		}
		
		return true;
	}
	
	public function get_complete_table ($data,$table,$db = 'sqlite:../../sqlite/cardinfo.db') {
		$array = $data->array_select_statement ($db, $table, '*', '');
		
		if (!empty($array)) 
			return $array;
		else
			return false;
	}
	
	/**
	*	Checks between post variables and database variables and displays appropriate values on screen
	*
	*	@param: $page
	*				Page being validated
	*/
	private function check_submit($page) {
		if ($page == 'edit_cluster') {
			if ($_POST['load_share'] == "roundrobin")
				$this->pick['load_share_roundrobin'] = "yes";
			elseif ($_POST['load_share'] == "linkspecified" )
				$this->pick['load_share_linkspecified'] = "yes";
			elseif ($_POST['load_share'] == "customerspecified")
				$this->pick['load_share_customerspecified'] = "yes";
			elseif ($this->edit['load_share'] == "roundrobin")
				$this->pick['load_share_roundrobin'] = "yes";
			elseif ($this->edit['load_share'] == "linkspecified" )
				$this->pick['load_share_linkspecified'] = "yes";
			elseif ($this->edit['load_share'] == "customerspecified")
				$this->pick['load_share_customerspecified'] = "yes";
				
			if ($_POST['traffic_mode'] == "override" )
				$this->pick['traffic_mode_override'] = "yes";
			elseif ($_POST['traffic_mode'] == "loadshare" )
				$this->pick['traffic_mode_loadshare'] = "yes";
			elseif ($_POST['traffic_mode'] == "broadcast" )
				$this->pick['traffic_mode_broadcast'] = "yes";
			elseif ($this->edit['traffic_mode'] == "override" )
				$this->pick['traffic_mode_override'] = "yes";
			elseif ($this->edit['traffic_mode'] == "loadshare" )
				$this->pick['traffic_mode_loadshare'] = "yes";
			elseif ($this->edit['traffic_mode'] == "broadcast" )
				$this->pick['traffic_mode_broadcast'] = "yes";
		}
		
		if ($page == 'edit_peer') {
			if ($_POST['include_asp_identifier'] == "enable")
				$this->pick['include_asp_identifier_enable'] = 'yes';
			elseif ($_POST['include_asp_identifier'] == "disable")
				$this->pick['include_asp_identifier_disable'] = 'yes';
			elseif ($this->edit['include_asp_identifier'] == "enable")
				$this->pick['include_asp_identifier_enable'] = 'yes';
			elseif ($this->edit['include_asp_identifier'] == 'disable')
				$this->pick['include_asp_identifier_disable'] = 'yes';
			elseif ($this->edit['include_asp_identifier'] == "" && $_REQUEST['include_asp_identifier'] == "")
				$this->pick['include_asp_identifier_disable'] = "yes";
				
			if ($_POST['asp_identifier'] != "") 
				$this->pick['asp_identifier'] = $_POST['asp_identifier'];
			elseif ($this->edit['asp_identifier'] != "")
				$this->pick['asp_identifier'] = $this->edit['asp_identifier'];
				
			if ($_POST['sctp_association'] == "enable")
				$this->pick['sctp_association_enable'] = 'yes';
			elseif ($_POST['sctp_association'] == "disable")
				$this->pick['sctp_association_disable'] = 'yes';
			elseif ($this->edit['sctp_association'] == "enable")
				$this->pick['sctp_association_enable'] = 'yes';
			elseif ($this->edit['sctp_association'] == 'disable')
				$this->pick['sctp_association_disable'] = 'yes';
			elseif ($this->edit['sctp_association'] == "" && $_REQUEST['sctp_association'] == "")
				$this->pick['sctp_association_disable'] = 'yes';
				
			if ($_POST['dest_ip_1'] != "") 
				$this->pick['dest_ip_1'] = $_POST['dest_ip_1'];
			elseif ($this->edit['dest_ip_addr_1'] != "")
				$this->pick['dest_ip_1'] = $this->edit['dest_ip_addr_1'];
				
			if ($_POST['dest_ip_2'] != "") 
				$this->pick['dest_ip_2'] = $_POST['dest_ip_2'];
			elseif ($this->edit['dest_ip_addr_2'] != "")
				$this->pick['dest_ip_2'] = $this->edit['dest_ip_addr_2'];
				
			if ($_POST['dest_ip_3'] != "") 
				$this->pick['dest_ip_3'] = $_POST['dest_ip_3'];
			elseif ($this->edit['dest_ip_addr_3'] != "")
				$this->pick['dest_ip_3'] = $this->edit['dest_ip_addr_3'];

			if ($_POST['dest_ip_4'] != "") 
				$this->pick['dest_ip_4'] = $_POST['dest_ip_4'];
			elseif ($this->edit['dest_ip_addr_4'] != "")
				$this->pick['dest_ip_4'] = $this->edit['dest_ip_addr_4'];
				
			if ($_POST['dest_ip_5'] != "") 
				$this->pick['dest_ip_5'] = $_POST['dest_ip_5'];
			elseif ($this->edit['dest_ip_addr_5'] != "")
				$this->pick['dest_ip_5'] = $this->edit['dest_ip_addr_5'];
				
			if ($_POST['dest_port'] != "")
				$this->pick['dest_port'] = $_POST['dest_port'];
			elseif ($this->edit['dest_port'] != "")
				$this->pick['dest_port'] = $this->edit['dest_port'];	
				
			if ($_POST['num_streams'] != "") 
				$this->pick['num_streams'] = $_POST['num_streams'];
			elseif ($this->edit['num_out_streams'] != "")
				$this->pick['num_streams'] = $this->edit['num_out_streams'];	
			else
				$this->pick['num_streams'] = 10;	
		}
		if ($page == "edit_sctp") {
			if ($_POST['dest_ip_1'] != "") 
				$this->pick['dest_ip_1'] = $_POST['dest_ip_1'];
			elseif ($this->edit['dest_ip_1'] != "")
				$this->pick['dest_ip_1'] = $this->edit['dest_ip_1'];
				
			if ($_POST['dest_ip_2'] != "") 
				$this->pick['dest_ip_2'] = $_POST['dest_ip_2'];
			elseif ($this->edit['dest_ip_2'] != "")
				$this->pick['dest_ip_2'] = $this->edit['dest_ip_2'];
				
			if ($_POST['dest_ip_3'] != "") 
				$this->pick['dest_ip_3'] = $_POST['dest_ip_3'];
			elseif ($this->edit['dest_ip_3'] != "")
				$this->pick['dest_ip_3'] = $this->edit['dest_ip_3'];

			if ($_POST['dest_ip_4'] != "") 
				$this->pick['dest_ip_4'] = $_POST['dest_ip_4'];
			elseif ($this->edit['dest_ip_4'] != "")
				$this->pick['dest_ip_4'] = $this->edit['dest_ip_4'];
				
			if ($_POST['dest_ip_5'] != "") 
				$this->pick['dest_ip_5'] = $_POST['dest_ip_5'];
			elseif ($this->edit['dest_ip_5'] != "")
				$this->pick['dest_ip_5'] = $this->edit['dest_ip_5'];
				
			if ($_POST['port'] != "")
				$this->pick['port'] = $_POST['port'];
			elseif ($this->edit['port'] != "")
				$this->pick['port'] = $this->edit['port'];			
		}
	}
}


?>
