<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Start Session
session_start();

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{
	$_SESSION['php_doc'] = $_SERVER['PHP_SELF'];

	require_once 'decide_ss7_linktype_class.php';
	include '../database_classes.php';
	
	$decide = new decide_ss7_link;
	$data = new database_class;
	$isup_term = false;
	$no_sip_link = false;
	$sig_gw = false;
	$link_type_back = false;
	$_SESSION['isup_term_voice_link'] = false;
	$_SESSION['isup_term_sig_link'] = false;
	
	//If database entry exists, bypass menu system and redirect to appropriate page
	$physical_table= $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'];
	$table_name = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_SS7_link";
	$m2ua_table_name = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_m2ua_link";
	$mg_table = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_m2ua_channels";
	$pri_table = $_SESSION['card_clicked'] . '_' . $_SESSION['card_num'] . '_signalling';
	$r2_table = $_SESSION['card_clicked'] . '_' . $_SESSION['card_num'] . '_r2_signalling';	
	$untoken_card_name = $_SESSION['card_clicked'];
	$proc_id = $_SESSION['proc_id'];
	
	if ($proc_id == 1)
		$db_location = "sqlite:../sqlite/cardinfo.db";	
	elseif ($proc_id > 1)
		$db_location = "sqlite:../sqlite/cardinfo" . $proc_id . ".db";
	
	$table_exist = $data->check_for_table('sqlite:../sqlite/relay_info.db',"ss7_relay");
	if ($table_exist > 1)
	{
		$relay = $data->select_statement('sqlite:../sqlite/relay_info.db',"ss7_relay","machine_type,relay_type","id = 1");
		$relay_type = $relay['relay_type'];
		$machine_type = $relay['machine_type'];
	}
	
	//Check what protocal is running on that specific port and redirect based on that.
	//Checks all protocols
	$sig_voice_ss7_link = $data->select_statement_order_by($db_location,$table_name,'sig_channel,voice','port_id = ' .$_SESSION['port_num_clicked']);
	$m2ua_ss7_link = $data->select_statement_order_by($db_location,$m2ua_table_name,'link_name','port_id = ' .$_SESSION['port_num_clicked']);
	$mg_link = $data->select_statement_order_by($db_location,$mg_table,'profile_name','port_id = ' . $_SESSION['port_num_clicked']);
	$pri_link = $data->select_statement_order_by($db_location,$pri_table,'signalling','port_id = ' . $_SESSION['port_num_clicked']);
	$physical_line = $data->select_statement_order_by($db_location,$physical_table,'line_type, sigmode','port_id = ' . $_SESSION['port_num_clicked']);
	$r2_link = $data->select_statement_order_by($db_location,$r2_table,'r2_profile','port_id = ' . $_SESSION['port_num_clicked']);
	
	$decide->line_type = $physical_line['line_type'];
	
	if ($sig_voice_ss7_link['voice'] == "yes") {
		//Goes directly to a voice link
		header( 'Location:SS7_link_config.php');
	}
	if ($sig_voice_ss7_link['sig_channel'] != "" || $machine_type != "standalone") {
		header( 'Location:SS7_link_config.php' ) ;
	}
	if ($m2ua_ss7_link['link_name'] != "") {
		header( 'Location:sigtran/SS7_m2ua_config.php' );
		exit;
	}
	if ($pri_link['signalling'] != "") {
		header('Location:../profiles/view_profiles.php');
		exit;
	}
	if ($r2_link['r2_profile'] != "") {
		header('Location:../r2_config/view_r2_profiles.php');
		exit;
	}
	
	if ($mg_link['profile_name'] != "")
		header( 'Location:sigtran/mg_channels.php' );
		
	
	//ONLY ALLOWED IF MASTER OR STANDALONE MODE
	if ($relay_type != "SLAVE") {
		if ($_REQUEST['link_type'] == "isup_term"){
			//TODO: NSG 5.1 will have another menu for ISUP termination (M2UA/MTP3)
			//$isup_term = true;
			
			//MTP1/MTP2/MTP3 goes directly to signalling link
			$_SESSION['isup_term_sig_link'] = true;
			header( 'Location:SS7_link_config.php' ) ;
		}
		if ($_REQUEST['link_type'] == "r2") {
			//if ($physical_line['sigmode'] == "CAS") {
				$_SESSION['r2_term_sig_link'] = true;
				header('Location:../r2_config/view_r2_profiles.php');
				exit;
			/*}
			else {
				//Error. Prompt user they didn't choose CAS signalling in physical layer
				$error = "Cannot choose MFC/R2 as CAS signalling has not been chosen on the physical layer. Please adjust physcial layer in order to continue.";
			}*/
		}

		if ($_REQUEST['link_type'] == "isdn") {
			$_SESSION['isdn_term_sig_link'] = true;
			header('Location:../profiles/view_profiles.php');
			exit;
		}
		if ($_REQUEST['link_type'] == "sig_gw")
			//$sig_gw = true;
			header('Location: sigtran/SS7_m2ua_config.php');
		if ($_REQUEST['link_type'] == "no_sig_link")
			$no_sig_link = true;
		if ($_REQUEST['link_type_back'] == "Back")
			$link_type_back = true;
		if ($_REQUEST['term_type'] == "ss7_term" && !$link_type_back) {
			//Goes directly to a voice link
			$_SESSION['isup_term_voice_link'] = true;
			header( 'Location:SS7_link_config.php');
		}
		if ($_REQUEST['term_type'] == "media_gw" && !$link_type_back)
			header ('Location:sigtran/mg_channels.php');
		
		if ($_REQUEST['cancel'])
			header( 'Location:../wanrouterhwprobe.php' ) ;
		
		
		//Check to see which UI we are running in
		if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
		{
			unset($_SESSION['embedded']);
			
			//FusionPBX Integration
			require_once "../fusionpbx/includes/header.php";
		}
		elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
		{
			//Includes required for ClearOS Integration
			include '../sqlite/database_creation.php';
			include '../display_class.php';
			
			$display_common = new Display_common;
			$_SESSION['embedded'] = "true";	
		
			//ClearOS Integration
			$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
			$display_common->html_header();
			$display_common->html_title("Link Decision", "../../../style.css","");		
		}	
	
		//Display HTML
		if ($no_sig_link)
			$decide->no_sig_link($data);
		elseif ($link_type_back)
			$decide->main($data);	
		else
			$decide->main($data,$error);
		
		//Check to see which UI we are running in
		if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
		{
			unset($_SESSION['embedded']);
			//FusionPBX Integration
			require_once "../fusionpbx/includes/footer.php";
		}
		elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
		{
			//ClearOS Integration
			$display_common->html_footer();	
		}
	}
	
}
else
{
	header( 'Location:../index.php' ) ;	
}

?>