<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class create_ss7_route_profile
{
	
	private $error= "";				//Contains validation errors
	public $error_counter="";		//Contains the number of errors in the form
	public $edit="";				//Contains database returned values for editing
	private $interface="";			//Contains the Interface
	public $profile_name = array();	//Contains the profile names within the database
	public $profile_counter = "";	//Contains the number of profiles in the database
	private $pick="";				//Contains the data for what was returned to the form
	public $stp="";					//Contains the value of APC
	public $dpc;					//Contains the value of minActive
	public $linkset_list=array();	//Contains an Array of the linksets chosen
	private $db_location="";		//Contains the database location
	private $table_name="";			//Contains the database table name
	public $comb_linksets="";		//Contains the linksets chosen in a string
	public $num_linksets="";		//Contains the number of linksets displayed on the page
	public $profile="";				//Contains the profile name
	public $data;
	
	//Display function
	function display()
	{
		$this->db_location = "sqlite:../sqlite/cardinfo.db";

		if ($_SESSION['id_num'] == "") 
		{ 
			echo "<h3>SS7 Route Profile Creation</h3>";		
		} 
		else 
		{ 
			echo "<h3>SS7 Route Profile - Edit</h3>"; 
		} 
		
		$this->check_submit();
		
		$this->table_name = "ss7_linkset_profile";
		$this->get_profiles();
		
		?>
	<p>
    	The third step of the SS7 configuration is the Route Configuration.<br />
        A SS7 Route is used by the MTP3 protocol in order to identify which path to take when sending messages to specific servers.<br />
        A SS7 Route must contain at least 1 Linkset.
    </p>
	<form name="create_profile" method="post">
   		<input type="hidden" name="id_number" value="<?php echo $a; ?>" />
		<br />
		<table class="mytable" width='100%'>
                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Route Profile Options</th>
			<tr>
				<td class="mytablesubheader" width='30%'>Profile Name</td>
				<?php
				if ($this->edit['profile_name'] == "") {
				?>
				<td width='40%'><input type="text" name="profile_name" value="<?=$this->pick['profile_name']?>" style="text-align:left; width:150px" /></td>
                <?php
				}
				else
				{
				?>
				<td width='40%'><input type="text" name="profile_name" value="<?=$this->pick['profile_name']?>" style="text-align:left; width:150px" disabled="disabled" /></td>
                <?php
				}
				?>
				<td width='30%'><?php echo $this->error['profile_name']; ?></td>
			</tr>   
            <tr>
            	<td class="mytablesubheader" width='30%'>Destination Point Code</td>
            	<td width='40%'><input type="text" name="dpc" value="<?php echo $this->dpc; ?>" style="text-align:left; width:40px" /></td>
                <td width='30%'><?php echo $this->error['dpc']; ?></td>
            </tr>         
			<tr>
				<td class="mytablesubheader" width='30%'>Does this route contain an STP?</td>
				<td width='40%'>
                	<select name="stp">
                    	<option value="yes" <?php if ($this->pick['stp_yes'] == "yes") { ?> selected="selected" <?php } ?>>YES</option>
                    	<option value="no" <?php if ($this->pick['stp_no'] == "yes") { ?> selected="selected" <?php } ?>>NO</option>                        
                    </select>
                </td>
				<td width='30%'><?php echo $this->error['apc']; ?></td>                                        
			</tr>            
       </table>
       <br />
		<table class="mytable" width='100%'>
        	<th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Signalling Gateway Profile</th>
        	<tr>
            	<td class="mytablesubheader" width='30%'>Please select 1 or more linksets to attach to this route</td>
                <td width='40%'>
        <?php
		//echo $this->profile_counter;
			for ($z = 0; $z < $this->profile_counter; $z++)
			{
				$hash = "linkset$z";
				
				echo "<input type=\"checkbox\" name=\"linkset$z\" value=\"" . $this->profile_name[$z]['profile_name'] . "\"";
				//print_r(count($this->linkset_list));
				if ($_REQUEST[$hash] == $this->profile_name[$z]['profile_name'] || $this->profile_counter == 1)
				{						
					 echo " checked=\"checked\" ";
				}
				else
				{
					for ($l = 0; $l < count($this->linkset_list); $l++)
					{
						//echo $_REQUEST[$hash] . "  " . $this->profile_name[$z]['profile_name'] . "<br />";
						if ($this->linkset_list[$l] == $this->profile_name[$z]['profile_name'])
						{						
							 echo " checked=\"checked\" ";
						}
					}
				
				}
				echo "/>" . $this->profile_name[$z]['profile_name'] . ", APC = " . $this->profile_name[$z]['apc']  . "<br />\n";
			}
			
			$this->num_linksets = $z;
			//echo $this->num_linksets;
			$_SESSION['num_linkset'] = $this->num_linksets;
			?>
				</td>
				<td width='30%'><?=$this->error['linkset']?></td>
			</tr>
        </table>
		<br />
        <table width="100%">
        <tr>
		<td width="1%"><input type="submit" name="create" value="<?php if ($_SESSION['id_num'] == "") { echo "Create Profile"; } else { echo "Save Profile"; } ?>" <?php echo $_SESSION['button_class']; ?>/></td>
		<td align="right"><input type="submit" name="cancel" value="<?php if ($_SESSION['id_num'] == "") { echo "Cancel Profile Creation"; } else { echo "Cancel Profile Editing"; } ?>" <?php echo $_SESSION['button_class']; ?>/></td>
        </tr>
        </table>
	</form>         
	<?php
	}	
	
	//Validates the Form
	function validation($data)
	{
		
		//Grab the profile name and make sure there isn't a profile already in the database
		//Only to occur if you are making a new profile
		$db = "sqlite:../sqlite/cardinfo.db";
		if ($_SESSION['id_num'] == 0 && $_REQUEST['create'] != "Save Profile")
		{	
			$this->table_name = "ss7_route_profile";
			$table = $data->check_for_table($db,$this->table_name);
			if ($table > 1)
			{
				$this->get_profiles();
			
				for ($z = 0; $z <= $this->profile_counter; $z++)
				{
					if (strtoupper($this->profile_name[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
					{
						$this->error['profile_name'] = "<font color=\"red\">Profile already <strong>EXISTS</strong>. Please use a different profile name</font>";
						$this->error_counter++;
					}
				}			
			}
			$this->table_name = "ss7_linkset_profile";
			
			$table = $data->check_for_table($db,$this->table_name);
			if ($table > 1)
			{
				$this->get_profiles();
				
				for ($z = 0; $z <= $this->profile_counter; $z++)
				{
					if (strtoupper($this->profile_name[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
					{
						$this->error['profile_name'] = "<font color=\"red\">Profile already <strong>EXISTS</strong>. Please use a different profile name</font>";
						$this->error_counter++;
					}
				}	
			}
			
			$this->table_name = "ss7_isup_profile";
			$table = $data->check_for_table($db,$this->table_name);
			if ($table > 1)
			{
				$this->get_profiles();
				
				for ($z = 0; $z <= $this->profile_counter; $z++)
				{
					if (strtoupper($this->profile_name[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
					{
						$this->error['profile_name'] = "<font color=\"red\">Profile already <strong>EXISTS</strong>. Please use a different profile name</font>";
						$this->error_counter++;
					}
				}	
			}
		}
		
		//Makes sure the user enters a profile name
		if ($_REQUEST['profile_name'] == "" && $_REQUEST['create'] != "Save Profile")
		{
			$this->error['profile_name'] = "<font color=\"red\">Please Enter a Profile Name</font>";
			$this->error_counter++;
		}		
		
		//Check to make sure the DPC is not the same as the SPC
		/*(require_once ('../display_class.php');
		$disp = new Display_common;
		
		$file = $_SESSION['smg_root_path'] . '/conf/license.txt';
		$array = $disp->open_file($file);
		
		for ($a = 0; $a < count($array); $a++)
		{
			if (preg_match('/SPC/',$array[$a]))
			{
				$pos = strpos($array[$a],' ');
				$spc_temp = substr($array[$a],$pos);
				$spc = trim($spc_temp," ");
				//echo $spc . "<br />";
				if (strpos($spc,','))
				{
					$token = $disp->token_generic($spc);
				}
			}
		}
		$prod=NULL;
		*/

		if ($_REQUEST['dpc'] == "")
		{
			$this->error['dpc'] = "<font color=\"red\">Please Enter a <b>Destination Point Code</b></font>";
			$this->error_counter++;
		}
		elseif (!is_numeric($_REQUEST['dpc']))
		{
			$this->error['dpc'] = "<font color=\"red\">Please Enter a <b>NUMERIC</b> value for the <b>Destination Point Code</b></font>";
			$this->error_counter++;
		}
		/*elseif ($_REQUEST['dpc'] != "")
		{
			//Check that makes sure the self point code entered is on in the license file
			for ($b = 0; $b < count($token); $b++)
			{
				//echo $_REQUEST['dpc'];
				//echo "=" . $token[$b] . "<br />";
				if ($token[$b] == $_REQUEST['dpc'])
				{
					//echo "i am here <br />";
					$this->error['dpc'] = "<font color=\"red\">Please Enter a <b>DESTINATION POINT CODE</b> that is not the same as your licensed Self Point Codes</b></font>";
					$this->error_counter++;
					//$temp = "good";
					//echo $temp . "<br />";
				}
			}
		}*/
		
		$this->table_name = "ss7_linkset_profile";
		$this->get_profiles();
		
		for ($z = 0; $z < $this->profile_counter; $z++)
		{
			$hash = "linkset$z";
			if ($_REQUEST[$hash] != "")
			{
				$click_counter++;
			}
		}						
		
		if ($click_counter == 0)
		{
			$this->error['linkset'] = "<font color=\"red\">Please Select at least <b>1 Linkset</b></font>";
			$this->error_counter++;
		}
	}	
	
	
	//Retrieves all the SS7 route/linkset Profile Names
	function get_profiles()
	{
		$a = 0;
		$this->db_location = "sqlite:../sqlite/cardinfo.db";
		
		if ($this->table_name == "ss7_linkset_profile")
		{
			$select = "SELECT profile_name, apc FROM " . $this->table_name . ";";
		}
		else
		{
			$select = "SELECT profile_name FROM " . $this->table_name . ";";
		}
		//echo $select;
		try
		{
			//open the database
			$db = new PDO($this->db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$this->profile_name[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}

		$this->profile_counter = $a;
	}	

	//Function to return the proper values when entering the page
	function check_submit()
	{
		if ($_REQUEST['stp'] == "" && $this->edit['stp'] == "")
			$this->pick['stp_no'] = "yes";
		elseif ($_REQUEST['stp'] == "yes")
			$this->pick['stp_yes'] = "yes";
		elseif ($_REQUEST['stp'] == "no")
			$this->pick['stp_no'] = "yes";
		elseif ($this->edit['stp'] == "yes")
			$this->pick['stp_yes'] = "yes";
		elseif ($this->edit['stp'] == "no")
			$this->pick['stp_no'] = "yes";

		if ($_REQUEST['profile_name'] != "")
			$this->pick['profile_name'] = $_REQUEST['profile_name'];
		elseif ($this->edit['profile_name'] != "")
			$this->pick['profile_name'] = $this->edit['profile_name'];
		else {
			$table = 'ss7_route_profile';
			$id = $this->data->select_statement_order_by($this->db_location,$table,'id','','id','-1');
			$a = $id['id'] + 1;			
			$this->pick['profile_name'] = "ROUTE" . $a;
		}

	}
	
	//separates the linkset values in the database
	function token_linksets()
	{
		$tok = strtok($this->comb_linksets, ",");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok(",");
			$count++;
		}	
		$hash = "sel_linkset$count";
		
		for ($a = 0; $a < $count; $a++)
		{
			$this->linkset_list[$a] = $token[$a];
			//echo $token[$a] . "<br />";
		}
		
		//echo $count;		
	}
}
