<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Starts PHP Session
session_start();

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{	
	//PHP Includes
	include 'create_ss7_route_class.php';
	include '../database_classes.php';
	
	//PHP Class Constructor
	$data = new database_class;
	$ss7_route = new create_ss7_route_profile;
	$ss7_route->data = $data;
	$db_location = "sqlite:../sqlite/cardinfo.db";

	//If statement that controls the HTML Title & gets the information out of the database if you are performing editing.
	if ($_SESSION['id_num'] == "") 
	{ 
		$title = $_SESSION['line_type'] . " Profile Creation"; 
	} 
	else 
	{ 
		$title = "Edit Profile"; 
		//echo "id = " . $_SESSION['id_num'] . "<br />";
		$id = $_SESSION['id_num'];
		
		//Pull the information out of the database and save it in the class variable "edit"
		$check = $data->check_for_table($db_location, "ss7_route_profile");
	
		if ($check > 1)
		{
			$ss7_route->edit = $data->select_statement($db_location, "ss7_route_profile", "*", "id = $id");
		
			$ss7_route->profile = $ss7_route->edit['profile_name'];
			$ss7_route->dpc = $ss7_route->edit['dpc'];
			$ss7_route->stp = $ss7_route->edit['stp'];
			$ss7_route->comb_linksets = $ss7_route->edit['linksets'];
		
			//Seperate the linksets
			$ss7_route->token_linksets();
		}
	}	

	
	if ($_REQUEST['create'] == "Create Profile" || $_REQUEST['create'] == "Save Profile")
	{
		$ss7_route->dpc = $_REQUEST['dpc'];
		$ss7_route->stp = $_REQUEST['stp'];
		
		//Runs the validation script
		$ss7_route->validation($data);
		
		//If there are no errors, place in the database
		//echo $ss7_route->error_counter . "<br />";
		if ($ss7_route->error_counter = 0 || $ss7_route->error_counter == "")
		{
			$_SESSION['profile_num_route'] = $_REQUEST['id_number'];
			
			//Combine the linksets
			for ($a = 0; $a < $_SESSION['num_linkset']; $a++)
			{
				$hash = "linkset" . $a;
			
				$string .= $_REQUEST[$hash] . ",";
			}
		
			$ss7_route->comb_linksets = $string;
			//echo $ss7_route->comb_linksets;
			
			$_SESSION['last_profile'] = $_REQUEST['profile_name'];
			
			//Check if it is a the profile is in the database
			if ($_SESSION['id_num'] != "")
			{
				$exist = $data->select_statement($db_location, "ss7_route_profile", "profile_name", "id = $id");
			}
			$id = $data->select_statement($db_location, "ss7_route_profile", "id", "");
			
			$id[0]++;
			
			if ($exist['profile_name'] == "")
			{
				//Line doesn't exist, insert it
				$insert_param = "id, profile_name, stp, dpc, linksets";
				$insert_values = "$id[0], \"" . $_REQUEST['profile_name'] . "\", \"" . $_REQUEST['stp'] . "\", \"" . $_REQUEST['dpc'] . "\", \"" . $ss7_route->comb_linksets . "\"";
				
				$data->insert_statement($db_location, "ss7_route_profile", $insert_param, $insert_values);
			}
			elseif ($exist['profile_name'] != "")
			{
				//Line exists, update it
				$update_param = "dpc = \"" . $_REQUEST['dpc'] . "\", stp = \"" . $_REQUEST['stp'] . "\", linksets = \"" . $ss7_route->comb_linksets . "\"";

				$where_param = "id = " . $_SESSION['id_num'];
				
				$data->update_table($db_location, "ss7_route_profile", $update_param, $where_param);
			}
			
			//$_SESSION['profile_num_route']--;
			if ($_SESSION['skip_all'] == "yes")
			{
				unset ($_SESSION['skip_route']);
				header( 'Location:create_ss7_isup.php' ) ;
			}
			else
			{
				if ($exist['profile_name'] == "")
				{
					$_SESSION['last_route'] = $id[0];
				}
				elseif ($exist['profile_name'] != "")
				{
					$_SESSION['last_route'] = $_SESSION['id_num'];
				}
				unset ($_SESSION['skip_route']);
				
				if ($_REQUEST['create'] == "Create Profile")
				{
					if ($_SESSION['skip_route'] == "yes")
					{
						unset($_SESSION['skip_route']);
					}
					$_SESSION['new_route'] = "yes";
					unset($_SESSION['new_linkset']);
				}
				//Redirects to viewing all profiles page
				header( 'Location:view_ss7_linkset.php' ) ;			
			}
				
		}
		else
		{
			$ss7_route->profile = $_REQUEST['profile_name'];
			$ss7_route->stp = $_REQUEST['stp'];
			$ss7_route->dpc = $_REQUEST['dpc'];	
			
			//Seperate the linksets		
		}
	}
	if ($_REQUEST['cancel'] == "Cancel Profile Creation" || $_REQUEST['cancel'] == "Cancel Profile Editing")
	{
		$_SESSION['id_num'] = "";
		
		//$_SESSION['profile_num_route'] = $_SESSION['profile_num_route'] - 2;
		
		if ($_SESSION['skip_all'] == "yes")
		{
			unset($_SESSION['skip_all']);
			header( 'Location:../wanrouterhwprobe.php#top' );				
		}
		elseif ($_SESSION['skip_route'] == "yes")
		{
			unset($_SESSION['skip_route']);
			$_SESSION['linkset'] = "Start";
			//Redirects to viewing all profiles page
			header( 'Location:view_ss7_linkset.php#top' ) ;			
		}
		else
		{
			//Redirects to viewing all profiles page
			header( 'Location:view_ss7_linkset.php#top' ) ;			
		}
	}

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';	
		include '../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
	
		if ($_SESSION['id_num'] == "") 
		{ 
			$title = "SS7 Route Profile Creation";		
		} 
		else 
		{ 
			$title = "SS7 Route Profile - Edit"; 
		} 	
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title($title, "../../../style.css","");		
	}	

	//SS7 Route Create Page
	$ss7_route->display();	

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:../index.php' ) ;
}	
?>