<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class create_ss7_linkset_profile
{
	
	private $error= "";				//Contains validation errors
	public $error_counter="";		//Contains the number of errors in the form
	public $edit="";				//Contains database returned values for editing
	private $interface="";			//Contains the Interface
	public $profile_name = array();	//Contains the profile names within the database
	public $profile = "";			//Contains the active profile
	public $profile_counter = "";	//Contains the number of profiles in the database
	private $pick="";				//Contains the data for what was returned to the form
	public $apc="";					//Contains the value of APC
	public $minactive;				//Contains the value of minActive
	private $table_name="";			//Contains the SQL Table name
	public $data;
	
	//Display function
	function display()
	{
		if ($_SESSION['id_num'] == "") 
		{ 
			echo "<h3>SS7 Linkset Profile Creation</h3>";		
		} 
		else 
		{ 
			echo "<h3>SS7 Linkset Profile - Edit</h3>"; 
		} 
		
		//$this->check_submit();
		if ($_REQUEST['profile_name'] != "")
			$this->pick['profile_name'] = $_REQUEST['profile_name'];
		elseif ($this->edit['profile_name'] != "")
			$this->pick['profile_name'] = $this->edit['profile_name'];
		else {
			$table = 'ss7_linkset_profile';
			$id = $this->data->select_statement_order_by($this->db_location,$table,'id','','id','-1');
			$a = $id['id'] + 1;			
			$this->pick['profile_name'] = "LS" . $a;
		}	
		
		?>
	<p>
    The second step in the SS7 configuration is the creation of the linkset.<br />
    A Linkset is a collection of SS7 signalling links, all bound together within a logical group, all connecting to the same Adjacent Point Code.
    </p>
	<form name="create_profile" method="post">
    	<input type="hidden" name="id_number" value="<?php echo $a; ?>" />
		<br />   		
		<table class="mytable" width='100%'>
            <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Linkset Options</th>
			<tr>
				<td class="mytablesubheader" width='30%'>Profile Name</td>
				<?php
				if ($this->edit['profile_name'] == "") {
				?>
				<td width='40%'><input type="text" name="profile_name" value="<?=$this->pick['profile_name']?>" style="text-align:left; width:150px" /></td>
                <?php
				}
				else
				{
				?>
				<td width='40%'><input type="text" name="profile_name" value="<?=$this->pick['profile_name']?>" style="text-align:left; width:150px" disabled="disabled" /></td>
                <?php
				}
				?>
				<td width='30%'><?php echo $this->error['profile_name']; ?></td>
			</tr>            
			<tr>
				<td class="mytablesubheader" width='30%'>Adjacent Point Code</td>
				<td width='40%'><input type="text" name="apc" value="<?php if ($this->apc != "") { echo $this->apc; } ?>" align="right" style="text-align:left; width:30px" /></td>
				<td width='30%'><?php echo $this->error['apc']; ?></td>                                        
			</tr>            
			<tr>
				<td class="mytablesubheader" width='30%'>Minimum Active Signalling Links</td>
				<td width='40%'><input type="text" name="minactive" value="<?php if ($this->minactive != "") { echo $this->minactive; } ?>" align="right" style="text-align:left; width:30px" /></td>
                <td width='30%'><?php echo $this->error['minactive'];?></td>
			</tr>
       </table>
		<br />
        <table width="100%">
        <tr>
			<td width="1%"><input type="submit" name="create" value="<?php if ($_SESSION['id_num'] == "") { echo "Create Profile"; } else { echo "Save Profile"; } ?>" <?php echo $_SESSION['button_class']; ?>/></td>
			<td align="right"><input type="submit" name="cancel" value="<?php if ($_SESSION['id_num'] == "") { echo "Cancel Profile Creation"; } else { echo "Cancel Profile Editing"; } ?>" <?php echo $_SESSION['button_class']; ?>/></td>
        </tr>
        </table>
	</form>         
	<?php
	}	
	
	//Validates the Form
	function validation($data)
	{
		//Check to make sure the APC is not the same as the SPC
		/*require_once ('../display_class.php');
		$disp = new Display_common;
		
		$file = $_SESSION['smg_root_path'] . '/conf/license.txt';
		$array = $disp->open_file($file);
		
		for ($a = 0; $a < count($array); $a++)
		{
			if (preg_match('/SPC/',$array[$a]))
			{
				$pos = strpos($array[$a],' ');
				$spc_temp = substr($array[$a],$pos);
				$spc = trim($spc_temp," ");
				//echo $spc . "<br />";
				if (strpos($spc,','))
				{
					$token = $disp->token_generic($spc);
				}
			}
		}
		$prod=NULL;
		*/
		
		//Grab the profile name and make sure there isn't a profile already in the database
		//Only to occur if you are making a new profile
		if ($_SESSION['id_num'] == 0 && $_REQUEST['create'] != "Save Profile")
		{	
			$db = "sqlite:../sqlite/cardinfo.db";
			
			$this->table_name = "ss7_route_profile";
			$table = $data->check_for_table($db,$this->table_name);
			if ($table > 1)
			{
				$this->get_ss7_linkset_profiles();
				
				for ($z = 0; $z <= $this->profile_counter; $z++)
				{
					if (strtoupper($this->profile_name[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
					{
						$this->error['profile_name'] = "<font color=\"red\">Profile already <strong>EXISTS</strong>. Please use a different profile name</font>";
						$this->error_counter++;
					}
				}	
			}
			//Check for the table
			$this->table_name = "ss7_linkset_profile";
			$table = $data->check_for_table($db,$this->table_name);
			if ($table > 1)
			{			
				$this->get_ss7_linkset_profiles();
				
				for ($z = 0; $z <= $this->profile_counter; $z++)
				{
					if (strtoupper($this->profile_name[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
					{
						$this->error['profile_name'] = "<font color=\"red\">Profile already <strong>EXISTS</strong>. Please use a different profile name</font>";
						$this->error_counter++;
					}
				}	
			}
			$this->table_name = "ss7_isup_profile";
			$table = $data->check_for_table($db,$this->table_name);
			if ($table > 1)
			{
				$this->get_ss7_linkset_profiles();
				
				for ($z = 0; $z <= $this->profile_counter; $z++)
				{
					if (strtoupper($this->profile_name[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
					{
						$this->error['profile_name'] = "<font color=\"red\">Profile already <strong>EXISTS</strong>. Please use a different profile name</font>";
						$this->error_counter++;
					}
				}
			}
		}
		
		//Makes sure the user enters a profile name
		if ($_REQUEST['profile_name'] == "" && $_REQUEST['create'] != "Save Profile")
		{
			$this->error['profile_name'] = "<font color=\"red\">Please Enter a Profile Name</font>";
			$this->error_counter++;
		}
		
		if ($_REQUEST['apc'] == "")
		{
			$this->error['apc'] = "<font color=\"red\">Please enter a value for the <strong>Adjacent Point Code</strong></font>";
			$this->error_counter++;
		}
		elseif (!is_numeric($_REQUEST['apc']))
		{
			$this->error['apc'] = "<font color=\"red\">Please enter a numeric value for the <strong>Adjacent Point Code</strong></font>";
			$this->error_counter++;
		}
		/*elseif ($_REQUEST['apc'] != "")
		{
			//Check that makes sure the self point code entered is on in the license file
			for ($b = 0; $b < count($token); $b++)
			{
				//echo $_REQUEST['dpc'];
				//echo "=" . $token[$b] . "<br />";
				if ($token[$b] == $_REQUEST['apc'])
				{
					//echo "i am here <br />";
					$this->error['apc'] = "<font color=\"red\">Please Enter an <b>ADJACENT POINT CODE</b> that is not the same as your licensed Self Point Codes</b></font>";
					$this->error_counter++;
					//$temp = "good";
					//echo $temp . "<br />";
				}
			}
		}*/
				
		if ($_REQUEST['minactive'] == "")
		{
			$this->error['minactive'] = "<font color=\"red\">Please select a value for the <strong>Minimum Active Signalling Links</strong></font>";
			$this->error_counter++;
		}
		elseif (!is_numeric($_REQUEST['minactive']))
		{
			$this->error['minactive'] = "<font color=\"red\">Please select a numeric value for the <strong>Minimum Active Signalling Links</strong></font>";
			$this->error_counter++;
		}			
		elseif ($_REQUEST['minactive'] < 0 || $_REQUEST['minactive'] > 16 )
		{
			$this->error['minactive'] = "<font color=\"red\">Please use a value between <strong>0</strong> and <strong>16</strong> for the <strong>Minimum Active Signalling Links</strong></font>";
			$this->error_counter++;
		}			
		
	}	
	
	//Retrieves all the SS7 Linkset Profile Names
	function get_ss7_linkset_profiles()
	{
		$db_location = "sqlite:../sqlite/cardinfo.db";
		$a = 0;

		$select = "SELECT profile_name FROM " . $this->table_name . ";";
		//echo $select . "<br />";
		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$this->profile_name[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}

		$this->profile_counter = $a;
	}	

}
