<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

	//Starts PHP Session
	session_start();
if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{	
	//PHP Includes
	include 'create_ss7_isup_class.php';
	include '../database_classes.php';
	
	//PHP Class Constructor
	$data = new database_class;
	$ss7_isup = new create_ss7_isup_profile;
	$ss7_isup->data=$data;
	$db_location = "sqlite:../sqlite/cardinfo.db";

	//If statement that controls the HTML Title & gets the information out of the database if you are performing editing.
	if ($_SESSION['id_num'] == "") 
	{ 
		$title = $_SESSION['line_type'] . " Profile Creation"; 
	} 
	else 
	{ 
		$title = "Edit Profile"; 
		//echo "id = " . $_SESSION['id_num'] . "<br />";
		$id = $_SESSION['id_num'];
		
		//Pull the information out of the database and save it in the class variable "edit"
		$ss7_isup->edit = $data->select_statement($db_location, "ss7_isup_profile", "*", "id = $id");
		
		$ss7_isup->profile = $ss7_isup->edit['profile_name'];
		$ss7_isup->spc = $ss7_isup->edit['spc'];
		$ss7_isup->ssf = $ss7_isup->edit['ssf'];
		$ss7_isup->route = $ss7_isup->edit['route'];
		$ss7_isup->t6 = $ss7_isup->edit['t6'];
		$ss7_isup->t9 = $ss7_isup->edit['t9'];
		//$ss7_isup->lpa = $ss7_isup->edit['lpa'];
	}	

	
	if ($_REQUEST['create'] == "Create Profile" || $_REQUEST['create'] == "Save Profile")
	{
		$ss7_isup->spc = $_REQUEST['spc'];
		$ss7_isup->ssf = $_REQUEST['ssf'];
		$ss7_isup->route = $_REQUEST['route'];
		$ss7_isup->t6 = $_REQUEST['t6'];
		$ss7_isup->t9 = $_REQUEST['t9'];
		//$ss7_isup->lpa = $_REQUEST['lpa'];
		
		//Runs the validation script
		$ss7_isup->validation($data);
		//echo "I am here <br />";
		//If there are no errors, place in the database
		if ($ss7_isup->error_counter == 0)
		{
			$_SESSION['profile_num_isup'] = $_REQUEST['id_number'];
			$_SESSION['last_profile'] = $_REQUEST['profile_name'];
			
			//Check if it is a the profile is in the database
			if ($_SESSION['id_num'] != "")
			{
				$exist = $data->select_statement($db_location, "ss7_isup_profile", "profile_name", "id = $id");
			}
			$id = $data->select_statement($db_location, "ss7_isup_profile", "id", "");
			
			$id[0]++;
			
			//Add the route to the used_route table so that no one will accidentally delete the entry
			$route_param = "isup, name";
			$route_where_param = "isup = \"" . $_REQUEST['profile_name'] . "\"";
			$route_found = $data->select_statement ($db_location, "used_route", $route_param, $route_where_param);	
			
			if ($route_found['isup'] == $_REQUEST['profile_name'])
			{
				//update the existing entry for the new profile name
				$route_update_where = "isup = \"" . $_REQUEST['profile_name'] . "\"";
				$route_update_param = "name = \"" . $ss7_isup->route . "\"";
				$data->update_table($db_location,"used_route", $route_update_param, $route_update_where);
			}				
			elseif ($route_found['isup'] == "")
			{
				//Entry was not found, insert it into the table
				$route_insert_param = "id, isup, name";
				$route_insert_values = "$id[0], \"" . $_REQUEST['profile_name'] . "\" ,\"" . $ss7_isup->route . "\"";
				$data->insert_statement($db_location, "used_route", $route_insert_param, $route_insert_values);
			}						
			
			if ($exist['profile_name'] == "")
			{
				//Line doesn't exist, insert it
				$insert_param = "id, profile_name, ssf, spc, route, t6, t9";
				$insert_values = "$id[0], \"" . $_REQUEST['profile_name'] . "\", \"" . $_REQUEST['ssf'] . "\", \"" . $_REQUEST['spc'] . "\", \"" . $_REQUEST['route'] . "\", " . $_REQUEST['t6'] . ", " . $_REQUEST['t9'];
				
				$data->insert_statement($db_location, "ss7_isup_profile", $insert_param, $insert_values);
			}
			elseif ($exist['profile_name'] != "")
			{
				//Line exists, update it
				$update_param = "spc = \"" . $_REQUEST['spc'] . "\", ssf = \"" . $_REQUEST['ssf'] . "\", route = \"" . $_REQUEST['route'] . "\", t6 = " . $_REQUEST['t6'] . ", t9 = " . $_REQUEST['t9'];

				$where_param = "id = " . $_SESSION['id_num'];
				
				$data->update_table($db_location, "ss7_isup_profile", $update_param, $where_param);
			}
			
			//$_SESSION['profile_num_isup']--;
			
			if ($_SESSION['skip_all'] == "yes")
			{
				//Redirects you to the ccspans page if this is the first time
				unset($_SESSION['skip_all']);
				unset($_SESSION['skip_isup']);
				unset($_SESSION['error']);
				header( 'Location:create_ss7_ccspans.php' );				
			}
			else
			{
				//Redirects to the ss7 configuration page if this is past the first time through
				$_SESSION['isup_created'] = "yes";
				unset($_SESSION['new_route']);
				unset($_SESSION['new_linkset']);
				unset($_SESSION['error']);
				unset($_SESSION['skip_isup']);
				//Redirects to viewing all profiles page
				header( 'Location:view_ss7_linkset.php' ) ;			
			}
		}
		else
		{
			$ss7_isup->profile = $_REQUEST['profile_name'];
			$ss7_isup->ssf = $_REQUEST['ssf'];
			$ss7_isup->spc = $_REQUEST['spc'];
			$ss7_isup->route = $_REQUEST['route'];	
			//$ss7_isup->lpa = $_REQUEST['lpa'];
		}
	}
	if ($_REQUEST['cancel'] == "Cancel Profile Creation" || $_REQUEST['cancel'] == "Cancel Profile Editing")
	{
		$_SESSION['id_num'] = "";
		
		//$_SESSION['profile_num_isup'] = $_SESSION['profile_num_isup'] - 2;

		if ($_SESSION['skip_all'] == "yes")
		{
			unset($_SESSION['skip_all']);
			header( 'Location:../wanrouterhwprobe.php#top' );				
		}
		elseif($_SESSION['skip_isup'] == "yes")
		{
			$_SESSION['linkset'] = "Done";
			unset ($_SESSION['route']);
			unset($_SESSION['skip_isup']);
			//Redirects to viewing all profiles page
			header( 'Location:view_ss7_linkset.php' ) ;			
		}
		else
		{
			//Redirects to viewing all profiles page
			header( 'Location:view_ss7_linkset.php' ) ;			
		}
		
	}

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';	
		require_once '../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
	
		if ($_SESSION['id_num'] == "") 
		{ 
			$title = "SS7 ISUP Interface Creation";		
		} 
		else 
		{ 
			$title = "SS7 ISUP Interface - Edit"; 
		} 	
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title($title, "../../../style.css","");		
	}	

	//ISUP interface creation page
	$ss7_isup->display();	

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:../index.php' ) ;
}	
?>